System.register("chunks:///_virtual/ActionFramesItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './FrameUtil.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, Sprite, SpriteFrame, Component, FrameUtil;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      SpriteFrame = module.SpriteFrame;
      Component = module.Component;
    }, function (module) {
      FrameUtil = module.default;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5;
      cclegacy._RF.push({}, "34d231t/uJAKKkOWiG725z6", "ActionFramesItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var ActionFramesItem = exports('ActionFramesItem', (_dec = ccclass("ActionFramesItem"), _dec2 = property(Sprite), _dec3 = property([SpriteFrame]), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(ActionFramesItem, _Component);
        function ActionFramesItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "action", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "frames", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "frameRate", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "loop", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "autoPlay", _descriptor5, _assertThisInitialized(_this));
          _this.isPlaying = false;
          return _this;
        }
        var _proto = ActionFramesItem.prototype;
        _proto.onLoad = function onLoad() {};
        _proto.start = function start() {
          if (this.autoPlay && this.frames.length > 0) {
            this.play();
          }
        };
        _proto.play = function play() {
          var _this2 = this;
          if (this.frames.length === 0 || this.isPlaying) {
            return;
          }
          this.isPlaying = true;
          FrameUtil.play(this.action, this.frames, {
            frameRate: this.frameRate,
            loop: this.loop,
            timeScale: 1
          }, function (success) {
            _this2.isPlaying = false;
          });
        }
        /**
         *
         * @param bundleName 动画路径
         * @param name 动画文件名字
         * @param action 动画动作
         * @param callFunc 播放完成回调
         * @returns
         */;
        _proto.playWithResource = /*#__PURE__*/
        function () {
          var _playWithResource = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(bundleName, name, action, callFunc) {
            var _this3 = this;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!this.isPlaying) {
                    _context.next = 2;
                    break;
                  }
                  return _context.abrupt("return");
                case 2:
                  this.isPlaying = true;
                  _context.prev = 3;
                  _context.next = 6;
                  return FrameUtil.getAnimationFrames({
                    bundleName: bundleName,
                    name: name,
                    action: action
                  });
                case 6:
                  this.frames = _context.sent;
                  FrameUtil.play(this.action, this.frames, {
                    frameRate: this.frameRate,
                    loop: this.loop,
                    timeScale: 1
                  }, function (success) {
                    _this3.isPlaying = false;
                    if (callFunc) {
                      callFunc();
                    }
                  });
                  _context.next = 14;
                  break;
                case 10:
                  _context.prev = 10;
                  _context.t0 = _context["catch"](3);
                  console.error("加载动画帧失败:", _context.t0);
                  this.isPlaying = false;
                case 14:
                case "end":
                  return _context.stop();
              }
            }, _callee, this, [[3, 10]]);
          }));
          function playWithResource(_x, _x2, _x3, _x4) {
            return _playWithResource.apply(this, arguments);
          }
          return playWithResource;
        }();
        _proto.stop = function stop() {
          FrameUtil.stop(this.action);
          this.isPlaying = false;
        };
        _proto.pause = function pause() {
          FrameUtil.pause(this.action);
        };
        _proto.resume = function resume() {
          FrameUtil.resume(this.action);
        };
        _proto.setFrames = function setFrames(frames) {
          this.frames = frames;
        };
        _proto.setFrameRate = function setFrameRate(rate) {
          this.frameRate = rate;
        };
        _proto.setLoop = function setLoop(loop) {
          this.loop = loop;
        };
        _proto.onDestroy = function onDestroy() {
          if (this.action) {
            this.isPlaying = false;
            FrameUtil.stop(this.action);
          }
        };
        _proto.clearAllResources = function clearAllResources() {
          FrameUtil.clearAllResources();
        };
        _proto.clearBundleResources = function clearBundleResources(bundleName) {
          FrameUtil.clearBundleResources(bundleName);
        };
        return ActionFramesItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "action", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "frames", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "frameRate", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 10;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "loop", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return true;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "autoPlay", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return true;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/ActionShadow.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './env'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createClass, cclegacy, _decorator, CCInteger, Node, UIOpacity, Sprite, sp, Animation, instantiate, UIRenderer, isValid, Component, color, DEV;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      CCInteger = module.CCInteger;
      Node = module.Node;
      UIOpacity = module.UIOpacity;
      Sprite = module.Sprite;
      sp = module.sp;
      Animation = module.Animation;
      instantiate = module.instantiate;
      UIRenderer = module.UIRenderer;
      isValid = module.isValid;
      Component = module.Component;
      color = module.color;
    }, function (module) {
      DEV = module.DEV;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _class2, _class3, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6;
      cclegacy._RF.push({}, "6c744BX3AZH6ogmvOgCzXnX", "ActionShadow", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property,
        executeInEditMode = _decorator.executeInEditMode,
        playOnFocus = _decorator.playOnFocus,
        menu = _decorator.menu;
      var ShadowData = function ShadowData() {
        this.x = 0;
        this.y = 0;
        this.angle = 0;
        this.scaleX = 1;
        this.scaleY = 1;
        this.scale = 1;
        this.actionName = "";
        this.animationName = "";
        this.trackIndex = 0;
      };
      var ActionShadow = exports('ActionShadow', (_dec = ccclass("ActionShadow"), _dec2 = property({
        displayName: DEV,
        tooltip: DEV
      }), _dec3 = property({
        type: CCInteger,
        displayName: DEV
      }), _dec4 = property({
        type: CCInteger,
        displayName: DEV
      }), _dec5 = property({
        displayName: DEV
      }), _dec6 = property({
        min: 0,
        max: 1,
        step: 0.1,
        slide: true,
        displayName: DEV
      }), _dec7 = property({
        type: CCInteger,
        min: 0,
        max: 255,
        slide: true,
        displayName: DEV
      }), _dec(_class2 = executeInEditMode(_class2 = playOnFocus(_class2 = (_class3 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(ActionShadow, _Component);
        function ActionShadow() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "_active", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "_shadowNum", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "_deltTime", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "_shadowColor", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "_shadowScale", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "_opacity", _descriptor6, _assertThisInitialized(_this));
          _this.nodeOpacity = 255;
          _this.model = null;
          _this.shadowNode = null;
          _this.shadowData = [];
          _this.isSpine = false;
          return _this;
        }
        var _proto = ActionShadow.prototype;
        _proto.start = function start() {
          var _this$node$getCompone;
          var shadowNodeName = this.node.name + "<ActionShadow>";
          this.shadowNode = this.node.parent.getChildByName(shadowNodeName);
          if (!this.shadowNode) {
            console.log("shadowNode new");
            this.shadowNode = new Node(shadowNodeName);
            this.shadowNode.addComponent(UIOpacity);
            this.shadowNode.addComponent(Sprite);
            this.shadowNode.setParent(this.node.parent);
            this.shadowNode.setSiblingIndex(this.node.getSiblingIndex());
          }
          this.nodeOpacity = (_this$node$getCompone = this.node.getComponent(UIOpacity)) == null ? void 0 : _this$node$getCompone.opacity;
          this.model = this.node.getComponent(sp.Skeleton);
          if (!this.model) {
            this.model = this.node.getComponent(Animation);
            this.isSpine = false;
          } else {
            this.isSpine = true;
          }
          this.node.updateWorldTransform();
          this.updateShadowNum();
          this.updateDeltTime();
          this.updateShadowData();
          this.updateColor();
          this.updateOpacity();
        };
        _proto.onEnable = function onEnable() {
          if (this.active && this.shadowNode) {
            this.shadowNode.active = true;
            this.shadowData.length && this.updateShadowData();
          }
        };
        _proto.onDisable = function onDisable() {
          this.shadowNode.active = false;
        };
        _proto.update = function update() {
          var _this$node$getCompone2;
          if (this.nodeOpacity !== ((_this$node$getCompone2 = this.node.getComponent(UIOpacity)) == null ? void 0 : _this$node$getCompone2.opacity)) {
            var _this$node$getCompone3;
            this.nodeOpacity = (_this$node$getCompone3 = this.node.getComponent(UIOpacity)) == null ? void 0 : _this$node$getCompone3.opacity;
            this.updateOpacity();
          }
          for (var i = this.shadowNum * this.deltTime; i > 0; --i) {
            var cur = this.shadowData[i];
            var prev = this.shadowData[i - 1];
            cur.x = prev.x;
            cur.y = prev.y;
            cur.scaleX = prev.scaleX;
            cur.scaleY = prev.scaleY;
            cur.angle = prev.angle;
            cur.actionName = prev.actionName;
            cur.animationName = prev.animationName;
            cur.trackIndex = prev.trackIndex;
          }
          var data = this.shadowData[0];
          var matrix = this.node.worldMatrix;
          data.x = matrix.m12;
          data.y = matrix.m13;
          data.scaleX = this.node.scale.x;
          data.scaleY = this.node.scale.y;
          data.angle = this.node.angle;
          if (this.model) {
            if (this.isSpine) {
              var spineModel = this.model;
              var state = spineModel.getState();
              if (state && state.tracks.length > 0) {
                var track = state.tracks[0];
                if (track && track.animation) {
                  data.animationName = track.animation.name;
                  data.trackIndex = 0;
                }
              }
            } else {
              var _defaultClip;
              data.actionName = ((_defaultClip = this.model.defaultClip) == null ? void 0 : _defaultClip.name) || "";
            }
          }
          this.shadowNode.updateWorldTransform();
          matrix = this.shadowNode.worldMatrix;
          for (var _i = this.shadowNum - 1; _i >= 0; --_i) {
            var node = this.shadowNode.children[_i];
            data = this.shadowData[this.deltTime * (_i + 1)];
            var x = data.x - matrix.m12;
            var y = data.y - matrix.m13;
            node.setPosition(x, y);
            node.setScale(data.scaleX * data.scale, data.scaleY * data.scale);
            node.angle = data.angle;
            if (this.isSpine) {
              var spineComp = node.getComponent(sp.Skeleton);
              if (spineComp && data.animationName) {
                spineComp.setAnimation(data.trackIndex, data.animationName, true);
              }
            } else {
              var animComp = node.getComponent(Animation);
              if (animComp && data.actionName) {
                animComp.play(data.actionName);
              }
            }
          }
        };
        _proto.updateShadowNum = function updateShadowNum() {
          this.shadowNode.removeAllChildren();
          this.shadowNode.destroyAllChildren();
          for (var i = 0, len = this.shadowNum; i < len; ++i) {
            var node = instantiate(this.node);
            node.name = this.node.name + i;
            var cmps = node["_components"];
            for (var j = cmps.length - 1; j >= 0; --j) {
              if (cmps[j] instanceof UIRenderer) continue;
              if (cmps[j] instanceof Animation) continue;
              if (cmps[j] instanceof sp.Skeleton) continue;
              cmps[j].destroy();
            }
            node.setParent(this.shadowNode);
          }
        };
        _proto.updateDeltTime = function updateDeltTime() {
          this.shadowData = [];
          for (var i = this.shadowNum * this.deltTime; i >= 0; --i) {
            this.shadowData[i] = new ShadowData();
          }
        };
        _proto.updateShadowData = function updateShadowData() {
          var scaleDelt = (1 - this.shadowScale) / (this.shadowNum * this.deltTime);
          var matrix = this.node.worldMatrix;
          for (var i = this.shadowNum * this.deltTime; i >= 0; --i) {
            var data = this.shadowData[i];
            data.x = matrix.m12;
            data.y = matrix.m13;
            data.scaleX = this.node.scale.x;
            data.scaleY = this.node.scale.y;
            data.scale = 1 - i * scaleDelt;
            data.angle = this.node.angle;
            if (this.model) {
              if (this.isSpine) {
                var spineModel = this.model;
                var state = spineModel.getState();
                if (state && state.tracks.length > 0) {
                  var track = state.tracks[0];
                  if (track && track.animation) {
                    data.animationName = track.animation.name;
                    data.trackIndex = 0;
                  }
                }
              } else {
                var _defaultClip2;
                data.actionName = ((_defaultClip2 = this.model.defaultClip) == null ? void 0 : _defaultClip2.name) || "";
              }
            }
          }
        };
        _proto.updateColor = function updateColor() {
          for (var index = 0; index < this.shadowNode.children.length; index++) {
            var element = this.shadowNode.children[index];
            if (this.isSpine) {
              var spineComp = element.getComponent(sp.Skeleton);
              if (spineComp) {
                spineComp.color = this.shadowColor;
              }
            } else {
              var spriteComp = element.getComponentInChildren(Sprite);
              if (spriteComp) {
                spriteComp.color = this.shadowColor;
              }
            }
          }
        };
        _proto.updateOpacity = function updateOpacity() {
          var component = this.shadowNode.getComponent(UIOpacity);
          if (component) {
            component.opacity = this.opacity;
          }
        };
        _proto.onDestroy = function onDestroy() {
          if (isValid(this.shadowNode)) {
            this.shadowNode.removeFromParent();
            this.shadowNode.destroy();
          }
        };
        _createClass(ActionShadow, [{
          key: "active",
          get: function get() {
            return this._active;
          },
          set: function set(value) {
            this._active = value;
            if (value) {
              if (this.node.active && this.shadowNode) {
                this.shadowNode.active = true;
                this.shadowData.length && this.updateShadowData();
              }
            } else {
              this.shadowNode.active = false;
            }
          }
        }, {
          key: "shadowNum",
          get: function get() {
            return this._shadowNum;
          },
          set: function set(value) {
            this._shadowNum = Math.max(value, 0);
            this.updateShadowNum();
            this.updateDeltTime();
            this.updateShadowData();
            this.updateColor();
          }
        }, {
          key: "deltTime",
          get: function get() {
            return this._deltTime;
          },
          set: function set(value) {
            this._deltTime = Math.max(value, 1);
            this.updateDeltTime();
            this.updateShadowData();
          }
        }, {
          key: "shadowColor",
          get: function get() {
            return this._shadowColor;
          },
          set: function set(value) {
            this._shadowColor = value;
            this.updateColor();
          }
        }, {
          key: "shadowScale",
          get: function get() {
            return this._shadowScale;
          },
          set: function set(value) {
            this._shadowScale = value;
            this.updateShadowData();
          }
        }, {
          key: "opacity",
          get: function get() {
            return this._opacity;
          },
          set: function set(value) {
            this._opacity = value;
            this.updateOpacity();
          }
        }]);
        return ActionShadow;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class3.prototype, "_active", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return true;
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "active", [_dec2], Object.getOwnPropertyDescriptor(_class3.prototype, "active"), _class3.prototype), _descriptor2 = _applyDecoratedDescriptor(_class3.prototype, "_shadowNum", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 5;
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "shadowNum", [_dec3], Object.getOwnPropertyDescriptor(_class3.prototype, "shadowNum"), _class3.prototype), _descriptor3 = _applyDecoratedDescriptor(_class3.prototype, "_deltTime", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 4;
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "deltTime", [_dec4], Object.getOwnPropertyDescriptor(_class3.prototype, "deltTime"), _class3.prototype), _descriptor4 = _applyDecoratedDescriptor(_class3.prototype, "_shadowColor", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return color(255, 255, 255);
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "shadowColor", [_dec5], Object.getOwnPropertyDescriptor(_class3.prototype, "shadowColor"), _class3.prototype), _descriptor5 = _applyDecoratedDescriptor(_class3.prototype, "_shadowScale", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 0.1;
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "shadowScale", [_dec6], Object.getOwnPropertyDescriptor(_class3.prototype, "shadowScale"), _class3.prototype), _descriptor6 = _applyDecoratedDescriptor(_class3.prototype, "_opacity", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 100;
        }
      }), _applyDecoratedDescriptor(_class3.prototype, "opacity", [_dec7], Object.getOwnPropertyDescriptor(_class3.prototype, "opacity"), _class3.prototype)), _class3)) || _class2) || _class2) || _class2));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/ADMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './MonitorType.ts', './DBRecord.ts', './Prompt.ts', './UtilGame.ts'], function (exports) {
  var _createClass, cclegacy, App, MonitorType, DBRecord, Prompt, UtilGame;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      App = module.App;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      Prompt = module.Prompt;
    }, function (module) {
      UtilGame = module.UtilGame;
    }],
    execute: function () {
      cclegacy._RF.push({}, "d4402PtJ6hBHZQI8/oohsdn", "ADMgr", undefined);
      var ADMgr = exports('ADMgr', /*#__PURE__*/function () {
        function ADMgr() {
          //------------------------------------------------------------         声明变量         --------------------------------------------------------------------------------------------
          this.cur_guanka_cnt_ad = 0;
          //  今日看广告双倍关卡结算奖励领取当前次数
          this._total_guanka_cnt_ad = 0;
          this.cur_xybx_cnt_ad = 0;
          //  今日看广告双倍关卡结算奖励领取当前次数
          this._total_xybx_cnt_ad = 0;
          this.xybx_cnt_ad = 0;
        }
        var _proto = ADMgr.prototype;
        //  今日看广告领取幸运宝箱次数
        //-------------------------------------------------------------         初始化         --------------------------------------------------------------------------------------------
        _proto.init = function init() {
          App.monitorMgr.addEventListener(MonitorType.web_ad_140001, this.sc_watch_ad_140001, this);
          App.monitorMgr.addEventListener(MonitorType.web_ad_146001, this.sc_get_ad_times_146001, this);
        };
        _proto.dispose = function dispose() {
          App.monitorMgr.removeEventListener(MonitorType.web_ad_140001, this.sc_watch_ad_140001, this);
          App.monitorMgr.removeEventListener(MonitorType.web_ad_146001, this.sc_get_ad_times_146001, this);
        }

        //---------------------------------------------------------         华丽分割线(协议部分)         --------------------------------------------------------------------------------------------
        /**
         * 获取广告次数
         */;
        _proto.sc_get_ad_times_146001 = function sc_get_ad_times_146001(obj) {
          console.log("广告 sc_get_ad_times_146001", obj);
          this.cur_guanka_cnt_ad = obj.guanka_cnt_ad;
          this.xybx_cnt_ad = obj.guanka_cnt_ad;
          this.cur_xybx_cnt_ad = obj.xybx_cnt_ad;
        };
        _proto.sc_watch_ad_140001 = function sc_watch_ad_140001(obj) {
          console.log("广告 sc_watch_ad_140001", obj);
          if (obj.err_code === 0) {
            this.cur_guanka_cnt_ad = obj.guanka_cnt_ad;
            var vAward = App.bagMgr.rplOpsrcLoc(12811, obj.item_list);
            App.bagMgr.sortAward(vAward);
            // let isAutoJump = App.autoFightManager.isAutoJumpRunning() && App.autoFightManager.sendWebAd140001;
            var isAutoJump = false;
            UtilGame.showCommonAward(vAward, function () {
              console.warn(">>>>>>>>>> AutoFight sc_watch_ad_140001 isAutoJump", isAutoJump);
              if (!isAutoJump) {
                App.battleMgr.onExit(null, function () {
                  // App.bagMgr.auto_decompose_equip(); //自动分解装备
                });
              }
            });
          } else {
            Prompt.popTip("双倍视频错误, error code is :" + obj.err_code);
          }
        };
        _createClass(ADMgr, [{
          key: "total_guanka_cnt_ad",
          get:
          //  今日看广告双倍关卡结算奖励领取总次数
          function get() {
            return Number(DBRecord.fetchId("ShuoMingQuanJu", 1001).value);
          }
        }, {
          key: "total_xybx_cnt_ad",
          get:
          //  今日看广告双倍关卡结算奖励领取总次数
          function get() {
            return Number(DBRecord.fetchId("ShuoMingQuanJu", 1000).value);
          }
        }]);
        return ADMgr;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AdsorptionBullet.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BulletBase.ts', './BattleDefine.ts', './App.ts'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, game, Vec3, v3, BulletBase, GameBattle, App;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      game = module.game;
      Vec3 = module.Vec3;
      v3 = module.v3;
    }, function (module) {
      BulletBase = module.BulletBase;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "b1b2eJ9CalIw6f4LGzB+/rJ", "AdsorptionBullet", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      /**
       * 吸附子弹
       */
      var AdsorptionBullet = exports('AdsorptionBullet', (_dec = ccclass("AdsorptionBullet"), _dec(_class = /*#__PURE__*/function (_BulletBase) {
        _inheritsLoose(AdsorptionBullet, _BulletBase);
        function AdsorptionBullet() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _BulletBase.call.apply(_BulletBase, [this].concat(args)) || this;
          // 吸附作用目标
          _this.targets = [];
          /**
           * 吸附强度
           */
          _this.attractionStrength = 0;
          /**
           * 吸附半径
           */
          _this.crashRadius = 0;
          /**
           * 检测帧率
           */
          _this.frameCounter = 0;
          _this.tempVector = new Vec3(0.01, 0.01, 0);
          // 方向
          _this.tempDirection = new Vec3();
          // 偏移
          _this.tempOffset = new Vec3();
          // 位置
          _this.tempPos = new Vec3();
          return _this;
        }
        var _proto = AdsorptionBullet.prototype;
        _proto.init = function init() {
          _BulletBase.prototype.init.call(this);
          this._type = GameBattle.BulletType.Adsorption;
        };
        _proto.reuse = function reuse() {
          _BulletBase.prototype.reuse.call(this);
        };
        _proto.recovery = function recovery() {
          this.targets = [];
          _BulletBase.prototype.recovery.call(this);
        };
        _proto.launch = function launch(bulletLauncherData) {
          _BulletBase.prototype.launch.call(this, bulletLauncherData);
          this.crashRadius = this.bulletVO.crash_box[0] * this.bulletVO.volume;
          this.attractionStrength = this.bulletVO.type_param[0] / Number(game.frameRate);
          // this.attractionStrength = 50 / Number(game.frameRate); // 测试吸力
        };

        _proto.getTargets = function getTargets() {
          var _this2 = this;
          this.targets = [];
          App.battleMgr.roleCtrl.foreachEntity(this, function (v) {
            if (!_this2.checkTargetType(v)) return false;
            if (v.immuneDrag()) return false;
            var distance = Vec3.distance(_this2.node.worldPosition, v.node.worldPosition);
            if (distance <= _this2.crashRadius) {
              _this2.targets.push(v);
            }
            return false;
          });
          return this.targets;
        };
        _proto.onUpdate = function onUpdate(dt) {
          var _this3 = this;
          _BulletBase.prototype.onUpdate.call(this, dt);
          this.frameCounter++;
          if (this.frameCounter >= 5) {
            this.frameCounter = 0;
            this.getTargets();
          }
          this.targets.forEach(function (target) {
            Vec3.subtract(_this3.tempDirection, _this3.node.worldPosition, target.node.worldPosition);
            Vec3.normalize(_this3.tempDirection, _this3.tempDirection);
            if (_this3.tempDirection.x === 0 && _this3.tempDirection.y === 0) return;
            Vec3.multiplyScalar(_this3.tempOffset, _this3.tempDirection, _this3.attractionStrength);
            if (Vec3.distance(target.node.worldPosition, _this3.node.worldPosition) < _this3.tempOffset.length()) {
              return;
            }
            Vec3.copy(_this3.tempPos, target.node.worldPosition);
            var isBoss = target.isBoss();
            var flag = isBoss;
            var x = _this3.tempOffset.x;
            var y = _this3.tempOffset.y;
            if (!App.mapMgr.checkCanMove(v3(_this3.tempPos.x + x, _this3.tempPos.y + y, 0), flag)) {
              if (App.mapMgr.checkCanMove(v3(_this3.tempPos.x + x, _this3.tempPos.y, 0), flag)) {
                y = 0;
              } else if (App.mapMgr.checkCanMove(v3(_this3.tempPos.x, _this3.tempPos.y + y, 0), flag)) {
                x = 0;
              } else {
                x = 0;
                y = 0;
              }
            }
            _this3.tempPos.x += x;
            _this3.tempPos.y += y;
            target.node.worldPosition = _this3.tempPos;
            target.moveDirection.set(_this3.tempVector);
          });
        };
        return AdsorptionBullet;
      }(BulletBase)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AIFollow.ts", ['cc', './Monster.ts', './AxingManager.ts', './App.ts', './BaseAi.ts'], function (exports) {
  var cclegacy, Monster, FindPathDeepType, App, AI_BEHAVIOR;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      Monster = module.Monster;
    }, function (module) {
      FindPathDeepType = module.FindPathDeepType;
    }, function (module) {
      App = module.App;
    }, function (module) {
      AI_BEHAVIOR = module.AI_BEHAVIOR;
    }],
    execute: function () {
      cclegacy._RF.push({}, "9d9f5mHqrpLpIlXji/HOgYE", "AIFollow", undefined);

      /**
       * 跟随AI
       */
      var AIFollow = exports('AIFollow', /*#__PURE__*/function () {
        function AIFollow() {
          /** 跟随目标 */
          this.followTarget = void 0;
          /** 跟随者 */
          this._owner = void 0;
          /** 跟随距离 */
          this.followDistanceX = 150;
          this.followDistanceY = 80;
          /**跟随时忽略目标：宠物（没有追击、普攻，优先跟随） */
          this.ignoreTarget = false;
        }
        var _proto = AIFollow.prototype;
        /**
         * 设置跟随距离
         * @param disX
         * @param disY
         */
        _proto.setFollowDistance = function setFollowDistance(disX, disY) {
          this.followDistanceX = disX;
          this.followDistanceY = disY;
        }

        /**
         * 检查跟随
         * @returns
         */;
        _proto.checkFollow = function checkFollow() {
          if (!this.followTarget) {
            return false;
          }
          var target = this._owner.lockTargetCtrl.target;
          if (target && target.node.active && target.checkValid) {
            if (!this.ignoreTarget) {
              return false;
            }
          }
          if (this._owner.atkSkill.checkRange()) {
            return false;
          }
          var distanceX = this.followTarget.node.worldPosition.x - this._owner.node.worldPosition.x;
          var distanceY = this.followTarget.node.worldPosition.y - this._owner.node.worldPosition.y;
          var disX = this.followDistanceX;
          var disY = this.followDistanceY;
          var behavior = this._owner instanceof Monster ? this._owner._monsterAI._curBehavior : null;
          if (behavior !== null && behavior !== AI_BEHAVIOR.GENSUI) {
            disX += 25;
            disY += 25;
          }
          if (Math.abs(distanceX) > disX || Math.abs(distanceY) > disY) {
            return true;
          }
          return false;
        }

        /**
         * 执行跟随
         */;
        _proto.doFollow = function doFollow() {
          if (this.followTarget) {
            var pos = App.mapMgr.getMoveVector(this._owner.node.worldPosition, this.followTarget.node.worldPosition, true, FindPathDeepType.Boss);
            if (pos.x === 0 && pos.y === 0) {
              this._owner.exitMove();
              return;
            }
            this._owner.move(pos);
          }
        };
        return AIFollow;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/Animal.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './ModuleDef.ts', './MoneyTips.ts', './ActionFramesItem.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Component, ModuleDef, MoneyTips, ActionFramesItem;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Component = module.Component;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      MoneyTips = module.MoneyTips;
    }, function (module) {
      ActionFramesItem = module.ActionFramesItem;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2;
      cclegacy._RF.push({}, "6a7b82Q6rFJ7JXdSket3fLP", "Animal", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var Animal = exports('Animal', (_dec = ccclass("Animal"), _dec2 = property(ActionFramesItem), _dec3 = property({
        type: MoneyTips
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(Animal, _Component);
        function Animal() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "actionFrames", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "moneyTips", _descriptor2, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = Animal.prototype;
        _proto.show = function show(animalType, rewards) {
          var _this2 = this;
          this.node.active = true;
          // let resNaqme = "";
          // if (animalType === AnimalType.CHICKEN) {
          //     resNaqme = "npc_1001";
          // } else if (animalType === AnimalType.DUCK) {
          //     resNaqme = "npc_1001";
          // } else if (animalType === AnimalType.GOOSE) {
          //     resNaqme = "npc_1001";
          // }
          this.actionFrames.playWithResource(ModuleDef.NPC, "npc_xiaoji", "Idle", function () {
            _this2.shuoMoneyTip(rewards[0]);
          });
        }

        /**
         * 展示金币
         * @param money
         */;
        _proto.shuoMoneyTip = function shuoMoneyTip(itemArr) {
          if (itemArr && itemArr.length > 0) {
            this.moneyTips.shuoMoneyTip(itemArr[0], itemArr[1]);
          }
        };
        _proto.hide = function hide() {
          this.node.active = false;
        };
        return Animal;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "actionFrames", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "moneyTips", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AnimationResourceManager.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, assetManager, SpriteFrame, App;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      assetManager = module.assetManager;
      SpriteFrame = module.SpriteFrame;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "e84f3L++VxEfKInaTYa8Oam", "AnimationResourceManager", undefined);
      var ccclass = _decorator.ccclass;

      // 动画资源键

      // 帧回调接口

      // 动画配置

      var AnimationResourceManager = exports('AnimationResourceManager', (_dec = ccclass("AnimationResourceManager"), _dec(_class = (_class2 = /*#__PURE__*/function () {
        function AnimationResourceManager() {
          // 资源缓存池
          this.resourcePool = new Map();
          // 加载中的资源
          this.loadingResources = new Map();
          // Bundle 缓存
          this.bundleCache = new Map();
        }
        AnimationResourceManager.getInstance = function getInstance() {
          if (!this.instance) {
            this.instance = new AnimationResourceManager();
          }
          return this.instance;
        }

        /**
         * 获取Bundle
         * @param bundleName Bundle文件夹名称
         * @returns Bundle
         */;
        var _proto = AnimationResourceManager.prototype;
        _proto.asyncGetBundle = /*#__PURE__*/
        function () {
          var _asyncGetBundle = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(bundleName, _cb) {
            var _this = this;
            var bundle;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  bundle = assetManager.getBundle(bundleName);
                  if (!bundle) {
                    _context.next = 4;
                    break;
                  }
                  this.bundleCache.set(bundleName, bundle);
                  return _context.abrupt("return", bundle);
                case 4:
                  App.log.logBusiness("Bundle文件夹名称: " + bundleName);
                  return _context.abrupt("return", new Promise(function (resolve) {
                    assetManager.loadBundle(bundleName, null, function (err, loadedBundle) {
                      console.log("------module:<" + bundleName + ">loaded.---sub_ui");
                      if (err) {
                        console.log(err);
                        resolve(null);
                      } else {
                        _this.bundleCache.set(bundleName, loadedBundle);
                        resolve(loadedBundle);
                        _cb == null || _cb();
                      }
                    });
                  }));
                case 6:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function asyncGetBundle(_x, _x2) {
            return _asyncGetBundle.apply(this, arguments);
          }
          return asyncGetBundle;
        }()
        /**
         * 预加载多个角色资源
         */;

        _proto.preloadBattleResources = /*#__PURE__*/
        function () {
          var _preloadBattleResources = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(resourceList, _cb) {
            var _this2 = this;
            var bundleNames, bundlePromises, bundles, failedBundles, loadPromises, _iterator, _step, resource, _loop, _iterator2, _step2;
            return _regeneratorRuntime().wrap(function _callee2$(_context3) {
              while (1) switch (_context3.prev = _context3.next) {
                case 0:
                  // 先预加载所有需要的 Bundle
                  bundleNames = [].concat(new Set(resourceList.map(function (resource) {
                    return resource.bundle;
                  })));
                  bundlePromises = bundleNames.map(function (bundleName) {
                    return _this2.asyncGetBundle(bundleName, _cb);
                  });
                  _context3.prev = 2;
                  _context3.next = 5;
                  return Promise.all(bundlePromises);
                case 5:
                  bundles = _context3.sent;
                  failedBundles = bundles.filter(function (bundle) {
                    return bundle === null;
                  });
                  if (!(failedBundles.length > 0)) {
                    _context3.next = 10;
                    break;
                  }
                  console.error("Some bundles failed to load");
                  return _context3.abrupt("return", false);
                case 10:
                  // 加载所有动画资源
                  loadPromises = [];
                  _iterator = _createForOfIteratorHelperLoose(resourceList);
                case 12:
                  if ((_step = _iterator()).done) {
                    _context3.next = 24;
                    break;
                  }
                  resource = _step.value;
                  _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop() {
                    var action, animationKey, loadPromise;
                    return _regeneratorRuntime().wrap(function _loop$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          action = _step2.value;
                          animationKey = _this2.getAnimationKey(resource.bundle, resource.name, action); // 如果已经加载或正在加载，跳过
                          if (!(_this2.resourcePool.has(animationKey) || _this2.loadingResources.has(animationKey))) {
                            _context2.next = 4;
                            break;
                          }
                          return _context2.abrupt("return", 1);
                        case 4:
                          loadPromise = _this2.loadAnimationFramesFromBundle(resource.bundle, resource.name, action).then(function (frames) {
                            _this2.resourcePool.set(animationKey, frames);
                            _this2.loadingResources["delete"](animationKey);
                          })["catch"](function (error) {
                            console.error("Failed to preload: " + animationKey, error);
                            _this2.loadingResources["delete"](animationKey);
                          });
                          _this2.loadingResources.set(animationKey, loadPromise);
                          loadPromises.push(loadPromise);
                        case 7:
                        case "end":
                          return _context2.stop();
                      }
                    }, _loop);
                  });
                  _iterator2 = _createForOfIteratorHelperLoose(resource.actions);
                case 16:
                  if ((_step2 = _iterator2()).done) {
                    _context3.next = 22;
                    break;
                  }
                  return _context3.delegateYield(_loop(), "t0", 18);
                case 18:
                  if (!_context3.t0) {
                    _context3.next = 20;
                    break;
                  }
                  return _context3.abrupt("continue", 20);
                case 20:
                  _context3.next = 16;
                  break;
                case 22:
                  _context3.next = 12;
                  break;
                case 24:
                  _context3.next = 26;
                  return Promise.all(loadPromises);
                case 26:
                  console.log("All battle resources preloaded successfully");
                  return _context3.abrupt("return", true);
                case 30:
                  _context3.prev = 30;
                  _context3.t1 = _context3["catch"](2);
                  console.error("Failed to preload battle resources", _context3.t1);
                  return _context3.abrupt("return", false);
                case 34:
                case "end":
                  return _context3.stop();
              }
            }, _callee2, null, [[2, 30]]);
          }));
          function preloadBattleResources(_x3, _x4) {
            return _preloadBattleResources.apply(this, arguments);
          }
          return preloadBattleResources;
        }()
        /**
         * 从 Bundle 加载动画帧
         */;

        _proto.loadAnimationFramesFromBundle = /*#__PURE__*/
        function () {
          var _loadAnimationFramesFromBundle = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(bundleName, name, action) {
            var _this3 = this;
            var bundle, path;
            return _regeneratorRuntime().wrap(function _callee3$(_context4) {
              while (1) switch (_context4.prev = _context4.next) {
                case 0:
                  _context4.next = 2;
                  return this.asyncGetBundle(bundleName);
                case 2:
                  bundle = _context4.sent;
                  if (bundle) {
                    _context4.next = 5;
                    break;
                  }
                  throw new Error("Bundle not found: " + bundleName);
                case 5:
                  path = name + "/" + action;
                  return _context4.abrupt("return", new Promise(function (resolve, reject) {
                    bundle.loadDir(path, SpriteFrame, function (err, assets) {
                      if (err) {
                        reject(err);
                        return;
                      }
                      if (assets.length === 0) {
                        reject(new Error("No frames found at path: " + path));
                        return;
                      }
                      var frames = _this3.sortFrames(assets);
                      resolve(frames);
                    });
                  }));
                case 7:
                case "end":
                  return _context4.stop();
              }
            }, _callee3, this);
          }));
          function loadAnimationFramesFromBundle(_x5, _x6, _x7) {
            return _loadAnimationFramesFromBundle.apply(this, arguments);
          }
          return loadAnimationFramesFromBundle;
        }()
        /**
         * 获取动画帧
         */;

        _proto.getAnimationFrames = /*#__PURE__*/
        function () {
          var _getAnimationFrames = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(bundleName, name, action) {
            var animationKey, frames;
            return _regeneratorRuntime().wrap(function _callee4$(_context5) {
              while (1) switch (_context5.prev = _context5.next) {
                case 0:
                  animationKey = this.getAnimationKey(bundleName, name, action); // 从缓存中获取
                  if (!this.resourcePool.has(animationKey)) {
                    _context5.next = 3;
                    break;
                  }
                  return _context5.abrupt("return", this.resourcePool.get(animationKey));
                case 3:
                  if (!this.loadingResources.has(animationKey)) {
                    _context5.next = 7;
                    break;
                  }
                  _context5.next = 6;
                  return this.loadingResources.get(animationKey);
                case 6:
                  return _context5.abrupt("return", _context5.sent);
                case 7:
                  _context5.next = 9;
                  return this.loadAnimationFramesFromBundle(bundleName, name, action);
                case 9:
                  frames = _context5.sent;
                  this.resourcePool.set(animationKey, frames);
                  return _context5.abrupt("return", frames);
                case 12:
                case "end":
                  return _context5.stop();
              }
            }, _callee4, this);
          }));
          function getAnimationFrames(_x8, _x9, _x10) {
            return _getAnimationFrames.apply(this, arguments);
          }
          return getAnimationFrames;
        }()
        /**
         * 对帧进行排序并调整偏移（模拟锚点 y=0 的效果）
         */;

        _proto.sortFrames = function sortFrames(frames) {
          var sortedFrames = frames.sort(function (a, b) {
            var getFrameNumber = function getFrameNumber(name) {
              var match = name.match(/(\d+)$/);
              return match ? parseInt(match[1]) : 0;
            };
            var numA = getFrameNumber(a.name || "");
            var numB = getFrameNumber(b.name || "");
            return numA - numB;
          });

          // 找到所有帧中的最大高度
          var maxHeight = 0;
          sortedFrames.forEach(function (frame) {
            if (frame && frame.rect) {
              maxHeight = Math.max(maxHeight, frame.rect.height);
            }
          });

          // 使用统一的最大高度调整所有帧的偏移，使其底部对齐
          // 这样可以避免不同高度的帧导致的上下偏移
          sortedFrames.forEach(function (frame) {
            if (frame && frame.rect) {
              // 计算当前帧与最大高度的差值
              var heightDiff = maxHeight - frame.rect.height;
              // 调整offset.y，使所有帧底部对齐
              // offset.y 正值向上偏移，所以需要向上偏移差值的一半
              frame.offset.y = heightDiff / 2;
            }
          });
          return sortedFrames;
        }

        /**
         * 生成动画键
         */;
        _proto.getAnimationKey = function getAnimationKey(bundleName, name, action) {
          return bundleName + "/" + name + "/" + action;
        }

        /**
         * 检查资源是否已加载
         */;
        _proto.isResourceLoaded = function isResourceLoaded(bundleName, name, action) {
          var animationKey = this.getAnimationKey(bundleName, name, action);
          return this.resourcePool.has(animationKey);
        }

        /**
         * 清理指定 Bundle 的资源
         */;
        _proto.clearBundleResources = function clearBundleResources(bundleName) {
          var _this4 = this;
          var keysToDelete = [];
          for (var _iterator3 = _createForOfIteratorHelperLoose(this.resourcePool.keys()), _step3; !(_step3 = _iterator3()).done;) {
            var key = _step3.value;
            if (key.startsWith(bundleName + "/")) {
              keysToDelete.push(key);
            }
          }
          keysToDelete.forEach(function (key) {
            _this4.resourcePool["delete"](key);
            _this4.loadingResources["delete"](key);
          });
          this.bundleCache["delete"](bundleName);
          var bundle = this.bundleCache.get(bundleName);
          if (bundle) {
            assetManager.removeBundle(bundle);
          }
        }

        /**
         * 清理所有资源
         */;
        _proto.clearAllResources = function clearAllResources() {
          this.resourcePool.clear();
          this.loadingResources.clear();
          this.bundleCache.clear();
        }

        /**
         * 获取所有已加载的资源键
         */;
        _proto.getLoadedResourceKeys = function getLoadedResourceKeys() {
          return Array.from(this.resourcePool.keys());
        };
        return AnimationResourceManager;
      }(), _class2.instance = null, _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/App.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MonitorMgr.ts', './ResMgr.ts', './NodePoolMgr.ts', './RoleMgr.ts', './LoginMgr.ts', './RedPointMgr.ts', './EmailMgr.ts', './SoundMgr.ts', './SaveDataMgr.ts', './ChatMgr.ts', './MixMgr.ts', './BattleProprMgr.ts', './LanguageMgr.ts', './MapMgr.ts', './SpineMgr.ts', './SkillMgr.ts', './PlatformMgr.ts', './BagMgr.ts', './LockMgr.ts', './ADMgr.ts', './GameStateMgr.ts', './ScheduleMgr.ts', './BroadcastMgr.ts', './GameShareMgr.ts', './SubscribeMgr.ts', './NetChannelMgr.ts', './UIMgr.ts', './Logger.ts', './BattleNewMgr.ts', './DungeonBattleMgr.ts', './AnimationResourceManager.ts', './PlaceGameMgr.ts', './TeamMgr.ts', './EventType.ts', './SingletonRegistry.ts', './GameBoot.ts'], function (exports) {
  var _createClass, cclegacy, MonitorMgr, ResMgr, NodePoolMgr, RoleMgr, LoginMgr, RedPointMgr, EmailMgr, SoundMgr, SaveDataMgr, ChatMgr, MixMgr, BattleProprMgr, LanguageMgr, MapMgr, SpineMgr, SkillMgr, PlatformMgr, BagMgr, LockMgr, ADMgr, GameStateMgr, ScheduleMgr, BroadcastMgr, GameShareMgr, SubscribeMgr, netChannel, UIMgr, Logger, BattleNewMgr, DungeonBattleMgr, AnimationResourceManager, PlaceGameMgr, TeamMgr, EventType, singletonRegistry, GameBoot;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      MonitorMgr = module.MonitorMgr;
    }, function (module) {
      ResMgr = module.ResMgr;
    }, function (module) {
      NodePoolMgr = module.NodePoolMgr;
    }, function (module) {
      RoleMgr = module.RoleMgr;
    }, function (module) {
      LoginMgr = module.LoginMgr;
    }, function (module) {
      RedPointMgr = module.RedPointMgr;
    }, function (module) {
      EmailMgr = module.EmailMgr;
    }, function (module) {
      SoundMgr = module.SoundMgr;
    }, function (module) {
      SaveDataMgr = module.SaveDataMgr;
    }, function (module) {
      ChatMgr = module.ChatMgr;
    }, function (module) {
      MixMgr = module.MixMgr;
    }, function (module) {
      BattleProprMgr = module.BattleProprMgr;
    }, function (module) {
      LanguageMgr = module.LanguageMgr;
    }, function (module) {
      MapMgr = module.MapMgr;
    }, function (module) {
      SpineMgr = module.SpineMgr;
    }, function (module) {
      SkillMgr = module.SkillMgr;
    }, function (module) {
      PlatformMgr = module.PlatformMgr;
    }, function (module) {
      BagMgr = module.BagMgr;
    }, function (module) {
      LockMgr = module.LockMgr;
    }, function (module) {
      ADMgr = module.ADMgr;
    }, function (module) {
      GameStateMgr = module.GameStateMgr;
    }, function (module) {
      ScheduleMgr = module.ScheduleMgr;
    }, function (module) {
      BroadcastMgr = module.BroadcastMgr;
    }, function (module) {
      GameShareMgr = module.GameShareMgr;
    }, function (module) {
      SubscribeMgr = module.SubscribeMgr;
    }, function (module) {
      netChannel = module.netChannel;
    }, function (module) {
      UIMgr = module.UIMgr;
    }, function (module) {
      Logger = module.Logger;
    }, function (module) {
      BattleNewMgr = module.BattleNewMgr;
    }, function (module) {
      DungeonBattleMgr = module.DungeonBattleMgr;
    }, function (module) {
      AnimationResourceManager = module.AnimationResourceManager;
    }, function (module) {
      PlaceGameMgr = module.PlaceGameMgr;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      EventType = module.EventType;
    }, function (module) {
      singletonRegistry = module.singletonRegistry;
    }, function (module) {
      GameBoot = module.GameBoot;
    }],
    execute: function () {
      cclegacy._RF.push({}, "614f0eHfj5FmKdZhQkRakCI", "App", undefined);
      var App = exports('App', /*#__PURE__*/function () {
        function App() {}
        /** 启动 */
        App.launch = function launch(boot) {
          if (!this.boot && boot) {
            this.boot = boot;
          }
          this.initBaseManagers();
          this.initModuleManagers();
        }

        /**
         * 初始化基础管理器
         * @param boot
         */;
        App.initBaseManagers = function initBaseManagers() {
          var _this$resMgr, _this$soundMgr, _this$scheduleMgr, _this$monitorMgr, _this$nodePoolMgr, _this$saveDataMgr, _this$languageMgr, _this$platformMgr;
          this.log.resetTags();
          (_this$resMgr = this.resMgr) == null || _this$resMgr.init(); // 资源管理
          (_this$soundMgr = this.soundMgr) == null || _this$soundMgr.init(this.boot); // 音乐管理
          (_this$scheduleMgr = this.scheduleMgr) == null || _this$scheduleMgr.init(); // 全局schedule管理类
          (_this$monitorMgr = this.monitorMgr) == null || _this$monitorMgr.init(); // 事件系统
          (_this$nodePoolMgr = this.nodePoolMgr) == null || _this$nodePoolMgr.init(); // 节点池管理
          (_this$saveDataMgr = this.saveDataMgr) == null || _this$saveDataMgr.init(); // 存储管理
          (_this$languageMgr = this.languageMgr) == null || _this$languageMgr.init(); // 多语言
          (_this$platformMgr = this.platformMgr) == null || _this$platformMgr.init(); // 广告相关
          this.spineMgr.init(); // 骨骼管理
        }

        /**
         * 初始化模块管理器
         * @param boot
         */;
        App.initModuleManagers = function initModuleManagers() {
          this.loginMgr.init(); // 区服管理
          this.redPointMgr.init(); // 红点管理
          this.roleMgr.init(); // 角色管理
          this.emailMgr.init(); // 邮件管理
          this.chatMgr.init(); // 聊天管理
          this.battleMgr.init(); // 战斗管理
          this.dungeonBattleMgr.initPool();
          this.battleProprMgr.init(); // 属性系统
          this.skillMgr.init(); // 技能系统
          this.bagMgr.init(); // 背包管理
          this.adMgr.init(); // 广告相关
          this.lockMgr.init(); // 解锁条件检测
          this.gameStateMgr.init(); // 游戏状态
          this.broadcastMgr.init(); // 广播
          this.gameShareMgr.init(); // 微信分享
          this.subscribeMgr.init(); // 微信订阅
          this.mapMgr.init(); // 地图管理
          this.mixMgr.init(); // 杂项管理

          PlaceGameMgr.inst.init();
          TeamMgr.inst.init();
        }

        /** 重置 */;
        App.dispose = function dispose() {
          this.monitorMgr.dispose(); // 事件系统
          this.loginMgr.dispose(); // 区服管理
          this.redPointMgr.dispose(); // 红点管理
          this.emailMgr.dispose(); // 邮件管理
          this.chatMgr.dispose(); // 聊天管理
          this.battleMgr.dispose(); // 战斗管理
          this.dungeonBattleMgr.dispose();
          this.resourceManager.clearAllResources();
          this.skillMgr.dispose(); // 技能系统
          this.battleProprMgr.dispose(); // 属性系统
          this.roleMgr.dispose(); // 角色管理
          this.bagMgr.dispose(); // 背包管理
          this.platformMgr.dispose(); // 广告相关
          this.adMgr.dispose(); // 广告相关
          this.lockMgr.dispose(); // 解锁条件检测
          this.gameStateMgr.dispose(); // 游戏状态
          this.scheduleMgr.dispose(); // 全局schedule管理类
          this.broadcastMgr.dispose(); // 广播
          this.gameShareMgr.dispose(); // 微信分享
          this.subscribeMgr.dispose(); // 微信订阅
          this.mapMgr.dispose(); // 地图管理

          // 清理资源
          this._monitorMgr = null;
          this._resMgr = null;
          this._nodePoolMgr = null;
          this._roleMgr = null;
          this._battleMgr = null;
          this._dungeonBattleMgr = null;
          this._loginMgr = null;
          this._redPointMgr = null;
          this._saveDataMgr = null;
          this._soundMgr = null;
          this._emailMgr = null;
          this._chatMgr = null;
          this._mixMgr = null;
          this._spineMgr = null;
          this._mapMgr = null;
          this._languageMgr = null;
          this._battleProprMgr = null;
          this._skillMgr = null;
          this._bagMgr = null;
          this._platformMgr = null;
          this._lockMgr = null;
          this._adMgr = null;
          this._gameStateMgr = null;
          this._scheduleMgr = null;
          this._broadcastMgr = null;
          this._gameShareMgr = null;
          this._subscribeMgr = null;
          PlaceGameMgr.inst.dispose();
          TeamMgr.inst.dispose();
        };
        App.update = function update(dt) {
          this.monitorMgr.dispatchEvent(EventType.manager_to_view_update, dt);
        }

        //------------------------------------------------------
        //other
        ;

        App.goToLoginMain = function goToLoginMain() {
          if (App.battleMgr.isInBattle()) {
            App.battleMgr.onExit(0, undefined, false);
          }
          netChannel.gameClose();
          this.dispose();
          netChannel.game.rejectReconnect(); //拒绝重新连接
          this.launch();
          UIMgr.inst.closeAllPanel();
          GameBoot.Instance.gotoGame();
          // 添加延迟确保UI系统完全初始化
          // setTimeout(() => {
          //     GameBoot.Instance.gotoGame();
          // }, 1000);
        }

        /**
         * 退出程序
         */;
        App.exitApp = function exitApp() {
          console.log("App exitApp");
        }

        /** 重新回到游戏 */;
        App.reloadApp = function reloadApp() {
          console.log("App reloadApp");
        };
        _createClass(App, null, [{
          key: "log",
          get:
          //微信订阅

          function get() {
            return this._log || (this._log = new Logger());
          }
        }, {
          key: "monitorMgr",
          get: function get() {
            return this._monitorMgr || (this._monitorMgr = new MonitorMgr());
          }
        }, {
          key: "resMgr",
          get: function get() {
            return this._resMgr || (this._resMgr = new ResMgr());
          }
        }, {
          key: "nodePoolMgr",
          get: function get() {
            return this._nodePoolMgr || (this._nodePoolMgr = new NodePoolMgr());
          }
        }, {
          key: "roleMgr",
          get: function get() {
            return this._roleMgr || (this._roleMgr = new RoleMgr());
          }
        }, {
          key: "battleMgr",
          get: function get() {
            return this._battleMgr || (this._battleMgr = new BattleNewMgr());
          }
        }, {
          key: "dungeonBattleMgr",
          get: function get() {
            return this._dungeonBattleMgr || DungeonBattleMgr.getInstance();
          }
        }, {
          key: "resourceManager",
          get: function get() {
            return this._resourceManager || AnimationResourceManager.getInstance();
          }
        }, {
          key: "loginMgr",
          get: function get() {
            return this._loginMgr || (this._loginMgr = new LoginMgr());
          }
        }, {
          key: "redPointMgr",
          get: function get() {
            return this._redPointMgr || (this._redPointMgr = new RedPointMgr());
          }
        }, {
          key: "saveDataMgr",
          get: function get() {
            return this._saveDataMgr || (this._saveDataMgr = new SaveDataMgr());
          }
        }, {
          key: "soundMgr",
          get: function get() {
            return this._soundMgr || (this._soundMgr = new SoundMgr());
          }
        }, {
          key: "emailMgr",
          get: function get() {
            return this._emailMgr || (this._emailMgr = new EmailMgr());
          }
        }, {
          key: "chatMgr",
          get: function get() {
            return this._chatMgr || (this._chatMgr = new ChatMgr());
          }
        }, {
          key: "mixMgr",
          get: function get() {
            return this._mixMgr || (this._mixMgr = new MixMgr());
          }
        }, {
          key: "spineMgr",
          get: function get() {
            return this._spineMgr || (this._spineMgr = new SpineMgr());
          }
        }, {
          key: "mapMgr",
          get: function get() {
            return this._mapMgr || (this._mapMgr = new MapMgr());
          }
        }, {
          key: "languageMgr",
          get: function get() {
            return this._languageMgr || (this._languageMgr = new LanguageMgr());
          }
        }, {
          key: "battleProprMgr",
          get: function get() {
            return this._battleProprMgr || (this._battleProprMgr = new BattleProprMgr());
          }
        }, {
          key: "skillMgr",
          get: function get() {
            return this._skillMgr || (this._skillMgr = new SkillMgr());
          }
        }, {
          key: "bagMgr",
          get: function get() {
            return this._bagMgr || (this._bagMgr = new BagMgr());
          }
        }, {
          key: "platformMgr",
          get: function get() {
            return this._platformMgr || (this._platformMgr = new PlatformMgr());
          }
        }, {
          key: "lockMgr",
          get: function get() {
            return this._lockMgr || (this._lockMgr = new LockMgr());
          }
        }, {
          key: "adMgr",
          get: function get() {
            return this._adMgr || (this._adMgr = new ADMgr());
          }
        }, {
          key: "gameStateMgr",
          get: function get() {
            return this._gameStateMgr || (this._gameStateMgr = new GameStateMgr());
          }
        }, {
          key: "scheduleMgr",
          get: function get() {
            return this._scheduleMgr || (this._scheduleMgr = new ScheduleMgr());
          }
        }, {
          key: "broadcastMgr",
          get: function get() {
            return this._broadcastMgr || (this._broadcastMgr = new BroadcastMgr());
          }
        }, {
          key: "gameShareMgr",
          get: function get() {
            return this._gameShareMgr || (this._gameShareMgr = new GameShareMgr());
          }
        }, {
          key: "subscribeMgr",
          get: function get() {
            return this._subscribeMgr || (this._subscribeMgr = new SubscribeMgr());
          }
        }]);
        return App;
      }());
      App.insMap = singletonRegistry;
      App.boot = void 0;
      App._log = new Logger();
      App._monitorMgr = void 0;
      //事件系统
      App._resMgr = void 0;
      // 资源管理
      App._nodePoolMgr = void 0;
      // 节点池管理
      App._roleMgr = void 0;
      // 角色管理
      App._battleMgr = void 0;
      // 战斗管理
      App._dungeonBattleMgr = void 0;
      App._resourceManager = void 0;
      App._loginMgr = void 0;
      //区服管理
      App._redPointMgr = void 0;
      //红点管理
      App._saveDataMgr = void 0;
      //存储管理
      App._soundMgr = void 0;
      //音乐管理
      App._emailMgr = void 0;
      //邮件管理
      App._chatMgr = void 0;
      //聊天管理
      App._mixMgr = void 0;
      App._spineMgr = void 0;
      // 骨骼管理
      App._mapMgr = void 0;
      // 地图管理
      App._languageMgr = void 0;
      // 多语言;
      App._battleProprMgr = void 0;
      // 属性系统;
      App._skillMgr = void 0;
      // 技能系统;
      App._bagMgr = void 0;
      // 背包管理
      App._platformMgr = void 0;
      // 广告相关
      App._lockMgr = void 0;
      // 解锁条件检测
      App._adMgr = void 0;
      //  广告相关
      App._gameStateMgr = void 0;
      //游戏状态
      App._scheduleMgr = void 0;
      // 全局schedule管理类
      App._broadcastMgr = void 0;
      // 广播
      App._gameShareMgr = void 0;
      //微信分享
      App._subscribeMgr = void 0;
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AttrItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './ModuleDef.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Sprite, Label, Component, App, ModuleDef;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Label = module.Label;
      Component = module.Component;
    }, function (module) {
      App = module.App;
    }, function (module) {
      ModuleDef = module.default;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5;
      cclegacy._RF.push({}, "40814Jeu8hKVISSf3DG3yrQ", "AttrItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var AttrItem = exports('AttrItem', (_dec = ccclass("AttrItem"), _dec2 = property({
        type: Sprite
      }), _dec3 = property({
        type: Sprite
      }), _dec4 = property({
        type: Label
      }), _dec5 = property({
        type: Label
      }), _dec6 = property({
        type: Label
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(AttrItem, _Component);
        function AttrItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /** 背景 */
          _initializerDefineProperty(_this, "bgSp", _descriptor, _assertThisInitialized(_this));
          /** 属性图标 */
          _initializerDefineProperty(_this, "icon", _descriptor2, _assertThisInitialized(_this));
          /** 属性名称 */
          _initializerDefineProperty(_this, "nameLab", _descriptor3, _assertThisInitialized(_this));
          /** 属性值 */
          _initializerDefineProperty(_this, "typeLab", _descriptor4, _assertThisInitialized(_this));
          /** 属性+值 */
          _initializerDefineProperty(_this, "addLab", _descriptor5, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = AttrItem.prototype;
        _proto.show = function show(data) {
          if (!data) return;

          // 设置属性图标
          if (this.icon && data.icon) {
            App.resMgr.loadImage(this.icon, ModuleDef.BASE_COMMON, "/texture/new_common/" + data.icon);
          }

          // 设置属性名称
          if (this.nameLab) {
            this.nameLab.string = data.name || "";
          }

          // 设置当前属性值
          if (this.typeLab) {
            this.typeLab.string = "" + data.value;
          }

          // 设置下一级属性增加值
          if (this.addLab) {
            var addValue = data.nextValue - data.value;
            this.addLab.string = addValue > 0 ? "+" + addValue : "";
          }
        };
        return AttrItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "bgSp", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "icon", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "nameLab", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "typeLab", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "addLab", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AutoBattleMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleDefine.ts', './Singleton.ts'], function (exports) {
  var _inheritsLoose, _createClass, cclegacy, _decorator, v3, GameBattle, Singleton;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      v3 = module.v3;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      Singleton = module.Singleton;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "6c517oWq2NPGqc7qV1UlTGb", "AutoBattleMgr", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /**
       * 自动战斗管理器
       * 负责控制英雄的自动释放技能和自动出击功能
       */
      var AutoBattleMgr = exports('AutoBattleMgr', (_dec = ccclass("AutoBattleMgr"), _dec(_class = /*#__PURE__*/function (_Singleton) {
        _inheritsLoose(AutoBattleMgr, _Singleton);
        function AutoBattleMgr() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Singleton.call.apply(_Singleton, [this].concat(args)) || this;
          // 是否启用自动战斗
          _this._isAutoBattleEnabled = false;
          // 所有可出战的英雄
          _this._availableHeroes = new Map();
          // 所有活跃的英雄
          _this._activeHeroes = new Map();
          // 所有活跃的怪物
          _this._activeMonsters = [];
          // 检查间隔（秒）
          _this._checkInterval = 0.5;
          // 上次检查时间
          _this._lastCheckTime = 0;
          // 技能释放距离阈值
          _this._skillCastDistanceThreshold = 300;
          return _this;
        }
        var _proto = AutoBattleMgr.prototype;
        /**
         * 初始化自动战斗管理器
         */
        _proto.init = function init() {
          this._availableHeroes.clear();
          this._activeHeroes.clear();
          this._activeMonsters = [];
          this._isAutoBattleEnabled = false;
          this._lastCheckTime = 0;
        }

        /**
         * 开启自动战斗
         */;
        _proto.enableAutoBattle = function enableAutoBattle() {
          this._isAutoBattleEnabled = true;
          console.log("Auto battle enabled");

          // 立即执行一次检查
          this._lastCheckTime = 0;
        }

        /**
         * 关闭自动战斗
         */;
        _proto.disableAutoBattle = function disableAutoBattle() {
          this._isAutoBattleEnabled = false;
          console.log("Auto battle disabled");
        }

        /**
         * 切换自动战斗状态
         */;
        _proto.toggleAutoBattle = function toggleAutoBattle() {
          this._isAutoBattleEnabled = !this._isAutoBattleEnabled;
          console.log("Auto battle " + (this._isAutoBattleEnabled ? "enabled" : "disabled"));
          if (this._isAutoBattleEnabled) {
            this._lastCheckTime = 0;
          }
          return this._isAutoBattleEnabled;
        }

        /**
         * 获取自动战斗状态
         */;
        /**
         * 添加可用英雄
         */
        _proto.addAvailableHero = function addAvailableHero(hero) {
          if (hero) {
            this._availableHeroes.set(hero.uid, hero);
            console.log("Hero " + hero.uid + " added to available heroes");
          }
        }

        /**
         * 移除可用英雄
         */;
        _proto.removeAvailableHero = function removeAvailableHero(heroUid) {
          this._availableHeroes["delete"](heroUid);
          this._activeHeroes["delete"](heroUid);
          console.log("Hero " + heroUid + " removed from available heroes");
        }

        /**
         * 更新活跃的怪物列表
         */;
        _proto.updateActiveMonsters = function updateActiveMonsters(monsters) {
          this._activeMonsters = monsters.filter(function (monster) {
            return !monster.isDead;
          });
        }

        /**
         * 英雄进入战场
         */;
        _proto.onHeroEnterBattle = function onHeroEnterBattle(hero) {
          if (hero) {
            this._activeHeroes.set(hero.uid, hero);
            this._availableHeroes["delete"](hero.uid);
            console.log("Hero " + hero.uid + " entered battle");
          }
        }

        /**
         * 英雄离开战场
         */;
        _proto.onHeroLeaveBattle = function onHeroLeaveBattle(heroUid) {
          this._activeHeroes["delete"](heroUid);
          console.log("Hero " + heroUid + " left battle");
        }

        /**
         * 更新
         */;
        _proto.update = function update(deltaTime) {
          if (!this._isAutoBattleEnabled) {
            return;
          }
          this._lastCheckTime += deltaTime;

          // 按间隔执行检查
          if (this._lastCheckTime >= this._checkInterval) {
            this._lastCheckTime = 0;

            // 自动释放技能
            this.autoCastSkills();

            // 自动派遣英雄
            this.autoDeployHeroes();
          }
        }

        /**
         * 自动释放技能
         */;
        _proto.autoCastSkills = function autoCastSkills() {
          var _this2 = this;
          this._activeHeroes.forEach(function (hero) {
            if (hero.isDead || !hero.isFullRage) {
              return;
            }

            // 查找技能范围内的目标
            var target = _this2.findBestSkillTarget(hero);
            if (target) {
              // 释放技能
              hero.castSkill(0); // 假设0是主要技能ID
              console.log("Hero " + hero.uid + " auto cast skill at target " + target.uid);
            }
          });
        }

        /**
         * 自动派遣英雄
         */;
        _proto.autoDeployHeroes = function autoDeployHeroes() {
          if (this._availableHeroes.size === 0 || this._activeMonsters.length === 0) {
            return;
          }

          // 找到怪物最多的兵线
          var laneMonsterCount = this.countMonstersByLane();
          var busiestLane = this.findBusiestLane(laneMonsterCount);

          // 如果找到兵线且有可用英雄
          if (busiestLane !== null) {
            // 获取第一个可用的英雄
            var availableHero = this._availableHeroes.values().next().value;
            if (availableHero && !availableHero.isDead && availableHero.canDeploy) {
              // 部署到最繁忙的兵线
              this.deployHeroToLane(availableHero, busiestLane);
            }
          }
        }

        /**
         * 计算各兵线的怪物数量
         */;
        _proto.countMonstersByLane = function countMonstersByLane() {
          var laneCount = new Map();

          // 初始化兵线计数
          Object.values(GameBattle.LanePosition).forEach(function (lane) {
            if (typeof lane === "number") {
              laneCount.set(lane, 0);
            }
          });

          // 统计各兵线怪物数量
          this._activeMonsters.forEach(function (monster) {
            var lane = monster.lane;
            if (lane !== null && laneCount.has(lane)) {
              laneCount.set(lane, (laneCount.get(lane) || 0) + 1);
            }
          });
          return laneCount;
        }

        /**
         * 找到怪物最多的兵线
         */;
        _proto.findBusiestLane = function findBusiestLane(laneCount) {
          var busiestLane = null;
          var maxCount = 0;
          laneCount.forEach(function (count, lane) {
            if (count > maxCount) {
              maxCount = count;
              busiestLane = lane;
            }
          });
          return busiestLane;
        }

        /**
         * 将英雄部署到指定兵线
         */;
        _proto.deployHeroToLane = function deployHeroToLane(hero, lane) {
          // 根据兵线计算部署位置
          var deployPositions = [v3(-300, -500, 0),
          // 左路
          v3(0, -500, 0),
          // 中路
          v3(300, -500, 0) // 右路
          ];

          var deployPosition = deployPositions[lane];
          if (deployPosition) {
            // 部署英雄
            hero.deployToLane(lane, deployPosition);

            // 更新状态
            this._activeHeroes.set(hero.uid, hero);
            this._availableHeroes["delete"](hero.uid);
            console.log("Hero " + hero.uid + " auto deployed to lane " + lane);
          }
        }

        /**
         * 查找最佳技能目标
         */;
        _proto.findBestSkillTarget = function findBestSkillTarget(hero) {
          var _this3 = this;
          if (!hero || this._activeMonsters.length === 0) {
            return null;
          }
          var heroPos = hero.node.position;
          var bestTarget = null;
          var closestDistance = this._skillCastDistanceThreshold;

          // 优先选择距离最近且在技能范围内的敌人
          this._activeMonsters.forEach(function (monster) {
            var distance = _this3.calculateDistance(heroPos, monster.node.position);

            // 如果在技能范围内且距离更近
            if (distance <= _this3._skillCastDistanceThreshold && distance < closestDistance) {
              closestDistance = distance;
              bestTarget = monster;
            }
          });
          return bestTarget;
        }

        /**
         * 计算两点之间的距离
         */;
        _proto.calculateDistance = function calculateDistance(pos1, pos2) {
          var dx = pos1.x - pos2.x;
          var dy = pos1.y - pos2.y;
          return Math.sqrt(dx * dx + dy * dy);
        }

        /**
         * 设置技能释放距离阈值
         */;
        _proto.setSkillCastDistanceThreshold = function setSkillCastDistanceThreshold(threshold) {
          this._skillCastDistanceThreshold = threshold;
        }

        /**
         * 设置检查间隔
         */;
        _proto.setCheckInterval = function setCheckInterval(interval) {
          this._checkInterval = interval;
        }

        /**
         * 重置管理器
         */;
        _proto.reset = function reset() {
          this.disableAutoBattle();
          this._availableHeroes.clear();
          this._activeHeroes.clear();
          this._activeMonsters = [];
          this._lastCheckTime = 0;
        }

        /**
         * 获取活跃英雄数量
         */;
        _createClass(AutoBattleMgr, [{
          key: "isAutoBattleEnabled",
          get: function get() {
            return this._isAutoBattleEnabled;
          }
        }, {
          key: "activeHeroCount",
          get: function get() {
            return this._activeHeroes.size;
          }

          /**
           * 获取可用英雄数量
           */
        }, {
          key: "availableHeroCount",
          get: function get() {
            return this._availableHeroes.size;
          }
        }]);
        return AutoBattleMgr;
      }(Singleton())) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/AxingManager.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleBigMap.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, Vec3, v3, BattleBigMap;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Vec3 = module.Vec3;
      v3 = module.v3;
    }, function (module) {
      BattleBigMap = module.BattleBigMap;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "3c0b7n3T2JAtqyQzjDnQIo7", "AxingManager", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /** 寻路深度类型 */
      var FindPathDeepType = exports('FindPathDeepType', /*#__PURE__*/function (FindPathDeepType) {
        FindPathDeepType[FindPathDeepType["Normal"] = 80] = "Normal";
        FindPathDeepType[FindPathDeepType["Boss"] = 200] = "Boss";
        FindPathDeepType[FindPathDeepType["AutoFightFindEnemy"] = 300] = "AutoFightFindEnemy";
        FindPathDeepType[FindPathDeepType["AutoFightFindWayPoint"] = 500] = "AutoFightFindWayPoint";
        return FindPathDeepType;
      }({}));

      /**
       * 任务结构体
       */

      var AxingManagerNew = exports('AxingManagerNew', (_dec = ccclass("AxingManagerNew"), _dec(_class = (_class2 = /*#__PURE__*/function () {
        function AxingManagerNew() {
          this._pathFindingQueue = [];
          this._isProcessing = false;
          this._maxTasksPerFrame = 3;
          // 每帧最多处理的任务数
          this._frameInterval = 1 / 60;
          // 帧间隔时间
          this._lastProcessTime = 0;
          this._defaultMaxDepth = 200;
          // 默认最大寻路深度
          this.useFrameQueue = false;
          this._mapArray = new Array();
          // 地图数据
          this.map2d = void 0;
          this._mapCache = {};
        }
        AxingManagerNew.getInstance = function getInstance() {
          if (this._instance == undefined) {
            this._instance = new this();
          }
          return this._instance;
        }

        /**使用新的物理层数据 */;
        var _proto = AxingManagerNew.prototype;
        // 是否使用帧队列
        _proto.setUseFrameQueue = function setUseFrameQueue(flag) {
          this.useFrameQueue = flag;
        }

        // 添加任务到队列
        ;

        _proto.addPathFindingTask = function addPathFindingTask(startPoint, endPoint, callback, maxDepth) {
          var task = {
            startPoint: startPoint,
            endPoint: endPoint,
            callback: callback,
            maxDepth: maxDepth || this._defaultMaxDepth
          };
          if (this.useFrameQueue) {
            this._pathFindingQueue.push(task);
            if (!this._isProcessing) {
              this.processPathFindingQueue();
            }
          } else {
            // 直接执行寻路，不加入队列
            var _result = this.Astar_use(startPoint, endPoint, maxDepth);
            callback(_result);
            return _result;
          }
        }

        // 处理队列中的任务
        ;

        _proto.processPathFindingQueue = /*#__PURE__*/
        function () {
          var _processPathFindingQueue = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var _this = this;
            var currentTime, processedTasks, task, _result2;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!(this._pathFindingQueue.length === 0)) {
                    _context.next = 3;
                    break;
                  }
                  this._isProcessing = false;
                  return _context.abrupt("return");
                case 3:
                  this._isProcessing = true;
                  currentTime = Date.now();
                  if (!(currentTime - this._lastProcessTime < this._frameInterval * 1000)) {
                    _context.next = 8;
                    break;
                  }
                  setTimeout(function () {
                    return _this.processPathFindingQueue();
                  }, this._frameInterval * 1000);
                  return _context.abrupt("return");
                case 8:
                  processedTasks = 0;
                  while (this._pathFindingQueue.length > 0 && processedTasks < this._maxTasksPerFrame) {
                    task = this._pathFindingQueue.shift();
                    if (task) {
                      _result2 = this.Astar_use(task.startPoint, task.endPoint, task.maxDepth);
                      task.callback(_result2);
                      processedTasks++;
                    }
                  }
                  this._lastProcessTime = currentTime;

                  // 如果队列中还有任务，在下一帧继续处理
                  if (this._pathFindingQueue.length > 0) {
                    setTimeout(function () {
                      return _this.processPathFindingQueue();
                    }, this._frameInterval * 1000);
                  } else {
                    this._isProcessing = false;
                  }
                case 12:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function processPathFindingQueue() {
            return _processPathFindingQueue.apply(this, arguments);
          }
          return processPathFindingQueue;
        }() // 清空寻路队列
        ;

        _proto.clearPathFindingQueue = function clearPathFindingQueue() {
          this._pathFindingQueue = [];
          this._isProcessing = false;
        }

        // 获取当前队列长度
        ;

        _proto.getQueueLength = function getQueueLength() {
          return this._pathFindingQueue.length;
        };
        _proto.init = function init() {};
        _proto.Array2D = function Array2D(w, h, num) {
          var data = [];
          var default_num = num || 0;
          for (var x = 0; x < h; x++) {
            var temp = [];
            for (var y = 0; y < w; y++) {
              temp.push(default_num);
            }
            data.push(temp);
          }
          return {
            w: w,
            h: h,
            data: data,
            showArray2D: function showArray2D() {
              var s = "";
              for (var y = 0; y < this.h; y++) {
                for (var x = 0; x < this.w; x++) {
                  s += this.data[x][y] + " ";
                }
                s += "\n";
              }
              console.log(s);
            }
          };
        }

        //点结构
        ;

        _proto.Point = function Point(x, y) {
          return {
            x: x,
            y: y,
            eq: function eq(other) {
              return this.x === other.x && this.y === other.y;
            }
          };
        }

        //节点结构
        ;

        _proto.Node = function Node(point, endPoint, g) {
          var tG = g || 0;
          return {
            point: point,
            father: null,
            g: tG,
            h: (Math.abs(endPoint.x - point.x) + Math.abs(endPoint.y - point.y)) * 10
          };
        }

        /**
         * 创建AStar对象，进行寻路
         * @param map2d 地图数据
         * @param startPoint 寻路起点
         * @param endPoint 寻路终点
         * @param passTag 可行走标记
         * @param self 寻路管理器
         * @returns
         */;
        _proto.AStar = function AStar(map2d, startPoint, endPoint, passTag, self) {
          return {
            map2d: map2d,
            startPoint: startPoint,
            endPoint: endPoint,
            passTag: passTag,
            openList: [],
            //开启表
            closeList: [],
            //关闭表
            // 计算节点的F值
            getF: function getF(node) {
              return node.g + node.h;
            },
            // 优化：二分查找插入位置
            findInsertPosition: function findInsertPosition(node) {
              var nodeF = this.getF(node);
              var left = 0;
              var right = this.openList.length - 1;
              while (left <= right) {
                var mid = Math.floor((left + right) / 2);
                var midF = this.getF(this.openList[mid]);
                if (midF < nodeF) {
                  right = mid - 1;
                } else {
                  left = mid + 1;
                }
              }
              return left;
            },
            // 优化：添加节点到openList
            addToOpenList: function addToOpenList(node) {
              var pos = this.findInsertPosition(node);
              this.openList.splice(pos, 0, node);
            },
            // 优化：更新openList中的节点
            updateOpenListNode: function updateOpenListNode(node, newG, newFather) {
              // 先从openList中移除节点
              var index = this.openList.indexOf(node);
              if (index !== -1) {
                this.openList.splice(index, 1);
              }

              // 更新节点的g值和父节点
              node.g = newG;
              node.father = newFather;

              // 重新插入到正确的位置
              this.addToOpenList(node);
            },
            // 修改搜索周围节点的逻辑
            searchNear: function searchNear(minF, offsetX, offsetY) {
              var newX = minF.point.x + offsetX;
              var newY = minF.point.y + offsetY;

              //检测是否可通行
              if (!this.checkCanPass(newX, newY)) {
                return null;
              }

              // 如果在关闭表中就忽略
              var currentPoint = self.Point(newX, newY);
              if (this.pointInCloseList(currentPoint)) {
                return null;
              }

              // 计算新的g值
              var step = offsetX === 0 || offsetY === 0 ? 10 : 14;
              var newG = minF.g + step;

              // 检查是否在开启列表中
              var currentNode = this.pointInOpenList(currentPoint);
              if (!currentNode) {
                // 如果不在开启列表中，创建新节点并添加
                var newNode = self.Node(currentPoint, this.endPoint, newG);
                newNode.father = minF;
                this.addToOpenList(newNode);
              } else if (newG < currentNode.g) {
                // 如果新路径更好，使用 updateOpenListNode 更新节点
                this.updateOpenListNode(currentNode, newG, minF);
              }
            },
            //检测是否可通行
            checkCanPass: function checkCanPass(newX, newY) {
              if (AxingManagerNew.USE_NEW_DATA) {
                return !BattleBigMap.getInstance().isBlock(newX, newY);
              } else {
                // 边界检查
                if (newX < 0 || newX >= this.map2d.w || newY < 0 || newY >= this.map2d.h) {
                  return false;
                }

                // 障碍检查 (0表示可通行)
                if (this.map2d.data[newY][newX] !== 0) {
                  return false;
                }
                return true;
              }
            },
            //判断point是否在关闭表中
            pointInCloseList: function pointInCloseList(point) {
              for (var _iterator = _createForOfIteratorHelperLoose(this.closeList), _step; !(_step = _iterator()).done;) {
                var node = _step.value;
                if (node.point.eq(point)) return true;
              }
              return false;
            },
            //判断point是否在开启表中
            pointInOpenList: function pointInOpenList(point) {
              for (var _iterator2 = _createForOfIteratorHelperLoose(this.openList), _step2; !(_step2 = _iterator2()).done;) {
                var node = _step2.value;
                if (node.point.eq(point)) return node;
              }
              return null;
            },
            //判断终点是否在闭表中
            endPointInCloseList: function endPointInCloseList() {
              for (var _iterator3 = _createForOfIteratorHelperLoose(this.closeList), _step3; !(_step3 = _iterator3()).done;) {
                var node = _step3.value;
                if (node.point.eq(this.endPoint)) return node;
              }
              return null;
            },
            //开始寻路
            start: function start(maxDepth) {
              this.openList = [];
              this.closeList = [];
              var startNode = self.Node(this.startPoint, this.endPoint);
              this.addToOpenList(startNode);
              while (this.openList.length > 0) {
                if (maxDepth && this.closeList.length >= maxDepth) {
                  console.log("达到最大深度限制:", maxDepth);
                  return null;
                }
                var minF = this.getMinNode();
                if (!minF) break;
                this.closeList.push(minF);
                this.openList.pop();

                // 先检查是否到达终点
                if (minF.point.eq(this.endPoint)) {
                  //console.log('找到路径，总迭代次数:', iterations,this.closeList.length);
                  return this.buildPath(minF);
                }

                // 搜索八个方向
                this.searchNear(minF, 0, -1);
                this.searchNear(minF, 0, 1);
                this.searchNear(minF, -1, 0);
                this.searchNear(minF, 1, 0);
                this.searchNear(minF, -1, -1);
                this.searchNear(minF, -1, 1);
                this.searchNear(minF, 1, -1);
                this.searchNear(minF, 1, 1);
              }
              // console.log('未找到路径，总迭代次数:', iterations);
              return null;
            },
            // 添加 buildPath 方法
            buildPath: function buildPath(endNode) {
              var path = [];
              var current = endNode;
              while (current.father) {
                path.push(current.point);
                current = current.father;
              }
              return path.reverse();
            },
            getMinNode: function getMinNode() {
              if (this.openList.length === 0) return null;
              return this.openList[this.openList.length - 1];
            }
          };
        };
        _proto.initMapData_zhangaiwu = function initMapData_zhangaiwu(width, height, mapData) {
          this.map2d = this.Array2D(width, height, 0);
          for (var i = 0; i < height; i++) {
            for (var j = 0; j < width; j++) {
              //this.map2d.data[i][j] = mapData[i * width + j]
              this.map2d.data[i][j] = mapData[i * width + j] == 0 ? 1 : 0;
            }
          }
        }

        /**
         * tiledMap地图数据转换为二维数组
         * @param width 地图宽度
         * @param height
         * @param mapData
         * @returns
         */;
        _proto.tilesToMapData = function tilesToMapData(width, height, mapData) {
          var data = [];
          var default_num = 0;
          for (var x = 0; x < height; x++) {
            var temp = [];
            for (var y = 0; y < width; y++) {
              temp.push(default_num);
            }
            data.push(temp);
          }
          for (var i = 0; i < height; i++) {
            for (var j = 0; j < width; j++) {
              data[i][j] = mapData[i * width + j] == 0 ? 1 : 0;
            }
          }
          return data;
        };
        // 缓存寻路结果
        // 修改 Astar_use 方法
        _proto.Astar_use = function Astar_use(start_point, to_point, maxDepth) {
          if (maxDepth === void 0) {
            maxDepth = this._defaultMaxDepth;
          }
          // console.log(
          //   '开始寻路:',
          //   '起点:',
          //   start_point,
          //   '终点:',
          //   to_point,
          //   '地图大小:',
          //   this.map2d.w,
          //   'x',
          //   this.map2d.h
          // );

          // 查点是否有效
          if (!this.isValidPoint(start_point)) {
            // console.log('起点无效');
            return Vec3.ZERO;
          }
          if (!this.isValidPoint(to_point)) {
            // console.log('终点无效');
            return Vec3.ZERO;
          }

          // 检查缓存
          var cacheKey = start_point.x + "," + start_point.y + "," + to_point.x + "," + to_point.y;
          if (this._mapCache[cacheKey]) {
            return this._mapCache[cacheKey];
          }
          var start_row = Math.floor(start_point.x);
          var start_column = Math.floor(start_point.y);
          var to_row = Math.floor(to_point.x);
          var to_column = Math.floor(to_point.y);

          // 创建 AStar 实例并寻路
          var aStar = this.AStar(this.map2d, this.Point(start_row, start_column), this.Point(to_row, to_column), 0, this);
          var pathList = aStar.start(maxDepth);
          if (!pathList || pathList.length === 0) {
            return Vec3.ZERO;
          }
          if (BattleBigMap.SHOW_PATH_SPRITE) {
            //TODOO
            if (maxDepth == FindPathDeepType.AutoFightFindEnemy || maxDepth == FindPathDeepType.AutoFightFindWayPoint) {
              BattleBigMap.getInstance().showDebugPath(pathList);
            }
          }

          // 计算移动向量
          var firstPoint = v3(pathList[0].x, pathList[0].y, 0);
          //const moveVector = firstPoint.subtract(v3(start_row, start_column, 0));
          var result;
          if (AxingManagerNew.USE_NEW_DATA) {
            result = firstPoint.subtract(v3(start_point.x, start_point.y, 0));
          } else {
            var moveVector = v3(start_point.x, start_point.y, 0).subtract(firstPoint);
            result = v3(moveVector.x * -1, moveVector.y, 0);
          }

          // 缓存结果
          this._mapCache[cacheKey] = result;
          return result;
        }

        // 添加点检查方法
        ;

        _proto.isValidPoint = function isValidPoint(point) {
          if (AxingManagerNew.USE_NEW_DATA) {
            if (BattleBigMap.getInstance().isBlock(point.x, point.y)) {
              return false;
            }
            return true;
          } else {
            if (!this.map2d || !this.map2d.data) {
              console.log("地图数据未初始化");
              return false;
            }
            var row = Math.floor(point.y);
            var col = Math.floor(point.x);

            // 检查边界
            if (row < 0 || row >= this.map2d.h || col < 0 || col >= this.map2d.w) {
              console.log("\u70B9 (" + row + ", " + col + ") \u8D85\u51FA\u8FB9\u754C");
              return false;
            }

            // 检查是否可通行（0表示可通行）
            var isPassable = this.map2d.data[row][col] === 0;
            if (!isPassable) {
              console.log("\u70B9 (" + row + ", " + col + ") \u662F\u969C\u788D\u7269");
            }
            return isPassable;
          }
        }

        /**
         * 使用A*算法寻路
         * @param start 起点
         * @param end 终点
         * @returns
         */;
        _proto.findPath = function findPath(start, end) {
          var _this2 = this;
          return new Promise(function (resolve) {
            _this2.addPathFindingTask(start, end, function (result) {
              resolve(result);
            });
          });
        }

        /**
         * 使用A*算法寻路,立即返回结果
         * @param start 起点
         * @param end 终点
         * @returns
         */;
        _proto.findPathImmediately = function findPathImmediately(start, end, maxDepthValue) {
          var maxDepth = maxDepthValue ? maxDepthValue : AxingManagerNew.DEEP_LIMIT;
          return this.addPathFindingTask(start, end, function () {}, maxDepth) || Vec3.ZERO;
        }

        // 清除缓存方法
        ;

        _proto.clearCache = function clearCache() {
          this._mapCache = {};
        };
        _proto.dispose = function dispose() {};
        return AxingManagerNew;
      }(), _class2._instance = new _class2(), _class2.USE_NEW_DATA = true, _class2.DEEP_LIMIT = 80, _class2.DEEP_LIMIT_BOSS = 200, _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BagMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MonitorType.ts', './DBRecord.ts', './Prompt.ts', './ModuleDef.ts', './App.ts', './NetChannelMgr.ts', './EventType.ts', './UIUtil.ts', './UIMgr.ts', './UI_ItemSourceView.ts', './Layout_UI_ItemSourceView.ts', './UI_GetRewardView.ts', './Layout_UI_GetRewardView.ts', './UI_ItemDetailView.ts', './Layout_UI_ItemDetailView.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, MonitorType, ModType, DBRecord, Prompt, ModuleDef, App, netChannel, EventType, UIUtil, UIMgr, LayerType, UI_ItemSourceView, Layout_UI_ItemSourceView, UI_GetRewardView, Layout_UI_GetRewardView, UI_ItemDetailView, Layout_UI_ItemDetailView;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      MonitorType = module.MonitorType;
      ModType = module.ModType;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      Prompt = module.Prompt;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      App = module.App;
    }, function (module) {
      netChannel = module.netChannel;
    }, function (module) {
      EventType = module.EventType;
    }, function (module) {
      UIUtil = module.UIUtil;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      UI_ItemSourceView = module.UI_ItemSourceView;
    }, function (module) {
      Layout_UI_ItemSourceView = module.Layout_UI_ItemSourceView;
    }, function (module) {
      UI_GetRewardView = module.UI_GetRewardView;
    }, function (module) {
      Layout_UI_GetRewardView = module.Layout_UI_GetRewardView;
    }, function (module) {
      UI_ItemDetailView = module.UI_ItemDetailView;
    }, function (module) {
      Layout_UI_ItemDetailView = module.Layout_UI_ItemDetailView;
    }],
    execute: function () {
      cclegacy._RF.push({}, "08f8b5iTEhLfal6tOFR40mV", "BagMgr", undefined);

      /**
       * 背包类型
       */
      var BagType = exports('BagType', /*#__PURE__*/function (BagType) {
        BagType[BagType["prop"] = 1] = "prop";
        BagType[BagType["libao"] = 2] = "libao";
        BagType[BagType["suipian"] = 3] = "suipian";
        BagType[BagType["equip"] = 4] = "equip";
        return BagType;
      }({}));

      /**
       * 道具类型
       */
      var ItemType = exports('ItemType', /*#__PURE__*/function (ItemType) {
        ItemType[ItemType["none"] = 0] = "none";
        ItemType[ItemType["assets"] = 1] = "assets";
        ItemType[ItemType["prop"] = 2] = "prop";
        ItemType[ItemType["hero"] = 3] = "hero";
        ItemType[ItemType["equip"] = 4] = "equip";
        ItemType[ItemType["zhuangban"] = 5] = "zhuangban";
        return ItemType;
      }({}));

      /**道具子类型 */
      var ItemSubType = exports('ItemSubType', /*#__PURE__*/function (ItemSubType) {
        ItemSubType[ItemSubType["none"] = 0] = "none";
        ItemSubType[ItemSubType["xhcl"] = 1] = "xhcl";
        ItemSubType[ItemSubType["cglb"] = 2] = "cglb";
        ItemSubType[ItemSubType["kxlb"] = 3] = "kxlb";
        ItemSubType[ItemSubType["suipian"] = 4] = "suipian";
        ItemSubType[ItemSubType["yxzk"] = 5] = "yxzk";
        ItemSubType[ItemSubType["yxsp"] = 6] = "yxsp";
        ItemSubType[ItemSubType["equip"] = 7] = "equip";
        ItemSubType[ItemSubType["head"] = 8] = "head";
        ItemSubType[ItemSubType["title"] = 9] = "title";
        return ItemSubType;
      }({}));
      var BagMgr = exports('BagMgr', /*#__PURE__*/function () {
        function BagMgr() {
          /**背包道具 */
          this._bag_items = [];
          /**装备 */
          this._bag_equips = [];
        }
        var _proto = BagMgr.prototype;
        //========================================== 配置获取方法 ===========================================
        /**
         * 获取物品配置
         * @param itemid 物品ID
         * @returns 物品配置
         */
        _proto.getItemConfig = function getItemConfig(itemid) {
          return DBRecord.fetchId("Item", itemid);
        }

        /**
         * 获取背包分类配置
         * @param bagType 背包类型
         * @returns 背包分类配置
         */;
        _proto.getItemBagConfig = function getItemBagConfig(bagType) {
          return DBRecord.fetchId("Item_Bag", bagType);
        }

        /**
         * 获取物品获取途径配置
         * @param gainId 获取途径ID
         * @returns 获取途径配置
         */;
        _proto.getItemGainConfig = function getItemGainConfig(gainId) {
          return DBRecord.fetchId("Item_Gain", gainId);
        }
        //========================================== 配置获取方法 ===========================================

        /**
         * 根据物品ID判断属于哪个背包类型
         * @param itemid 道具ID
         * @returns 背包类型
         */;
        _proto.getItemBagType = function getItemBagType(itemid) {
          var itemConfig = this.getItemConfig(itemid);
          if (!itemConfig) {
            App.log.logError("\u7269\u54C1\u914D\u7F6E\u4E0D\u5B58\u5728: itemid=" + itemid);
            return BagType.prop;
          }
          for (var bagType = BagType.prop; bagType <= BagType.equip; bagType++) {
            var bagConfig = this.getItemBagConfig(bagType);
            if (bagConfig && bagConfig.itemtype) {
              for (var _iterator = _createForOfIteratorHelperLoose(bagConfig.itemtype), _step; !(_step = _iterator()).done;) {
                var itemTypePair = _step.value;
                if (itemConfig.type === itemTypePair[0] && itemConfig.subtype === itemTypePair[1]) {
                  return bagType;
                }
              }
            }
          }
          return BagType.prop;
        }

        /**
         * 重置数据
         */;
        _proto._resetData = function _resetData() {
          this._bag_equips = [];
          this._bag_items = [];
        }

        /**
         * 添加事件监听
         */;
        _proto.addEventListener = function addEventListener() {
          App.monitorMgr.addEventListener(MonitorType.CMD_ResUserLoadBag, this.recResUserLoadBag, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResUserbagchange, this.recResUserbagchange, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResAKeyUseGift, this.recResAKeyUseGift, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResUseOptionalGift, this.recResUseOptionalGift, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResFragmentCombine, this.recResFragmentCombine, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResUseItem, this.resUseItem, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResRewardPopup, this.resRewardPopup, this);
        }

        /**
         * 初始化背包管理器
         */;
        _proto.init = /*#__PURE__*/
        function () {
          var _init = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  this._resetData();
                  this.addEventListener();
                  _context.next = 4;
                  return App.nodePoolMgr.createPoolByPath(ModuleDef.BASE_COMMON, "prefab/item/itemProp", {
                    preloadCount: 50,
                    maxSize: 60,
                    autoExpand: true
                  });
                case 4:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function init() {
            return _init.apply(this, arguments);
          }
          return init;
        }()
        /**
         * 释放资源
         */;

        _proto.dispose = function dispose() {
          this._resetData();
          App.monitorMgr.offTarget(this);
          App.nodePoolMgr.clearPoolByPath(ModuleDef.BASE_COMMON, "prefab/item/itemProp");
        }

        /**
         * 查找装备物品
         * @param itemuid 物品唯一ID
         * @returns 装备物品
         */;
        _proto.findEquipItem = function findEquipItem(itemuid) {
          return App.bagMgr.getBagItemByItemuid(itemuid) || App.bagMgr.getWearEquipDataByItemuid(itemuid);
        }

        /**
         * 获取穿戴的装备数据
         * @param type 装备类型
         * @returns 装备数据
         */;
        _proto.getWearEquipData = function getWearEquipData(type) {
          if (type < 0 || type >= this._bag_equips.length) return null;
          return this._bag_equips[type];
        }

        /**
         * 检查指定物品唯一ID的装备是否已经穿戴
         * @param itemuid 物品唯一ID
         * @returns 是否已经穿戴
         */;
        _proto.isEquipWorn = function isEquipWorn(itemuid) {
          for (var i = 0; i < this._bag_equips.length; i++) {
            if (this._bag_equips[i] && this._bag_equips[i].itemUid === itemuid) {
              return true;
            }
          }
          return false;
        }

        /**
         * 获取穿戴的装备列表
         * @returns 装备列表
         */;
        _proto.getWearEquipList = function getWearEquipList() {
          var list = [];
          for (var i = 0; i < this._bag_equips.length; i++) {
            if (this._bag_equips[i]) list.push(this._bag_equips[i]);
          }
          return list;
        }

        /**
         * 根据物品唯一ID获取穿戴的装备数据
         * @param itemuid 物品唯一ID
         * @returns 装备数据
         */;
        _proto.getWearEquipDataByItemuid = function getWearEquipDataByItemuid(itemuid) {
          for (var i = 0; i < this._bag_equips.length; i++) {
            if (this._bag_equips[i] && this._bag_equips[i].itemUid === itemuid) return this._bag_equips[i];
          }
        }

        /**
         * 根据物品ID获取穿戴的装备数据
         * @param itemid 物品ID
         * @returns 装备数据
         */;
        _proto.getWearEquipDataByItemId = function getWearEquipDataByItemId(itemid) {
          for (var i = 0; i < this._bag_equips.length; i++) {
            if (this._bag_equips[i] && this._bag_equips[i].itemid === itemid) return this._bag_equips[i];
          }
        }

        /**
         * 检查指定物品ID的装备是否已经穿戴
         * @param itemid 物品ID
         * @returns 是否已经穿戴
         */;
        _proto.checkWearByItemId = function checkWearByItemId(itemid, vEquip) {
          vEquip = vEquip || this._bag_equips;
          for (var dx0 = 0; dx0 < vEquip.length; dx0++) if (vEquip[dx0] && vEquip[dx0].itemid === itemid) return true;
          return false;
        }

        /**
         * 获取穿戴装备的战力
         * @returns 战力值
         */;
        _proto.getWearEquipPower = function getWearEquipPower() {
          var power = 0;
          // for (let i = 0; i < this._bag_equips.length; i++) {
          //     if (this._bag_equips[i]) power += this._bag_equips[i].equipment.fighting;
          // }
          return power;
        }

        /**
         * 获取背包物品映射
         * @param bag_type 背包类型
         * @returns 物品映射
         */;
        _proto.getBagItemsMap = function getBagItemsMap(bag_type) {
          if (bag_type >= 0 && bag_type < this._bag_items.length) return this._bag_items[bag_type];
        }

        /**
         * 获取背包物品列表
         * @param bag_type 背包类型
         * @returns 物品列表
         */;
        _proto.getBagItemList = function getBagItemList(bag_type) {
          var mapItems = this.getBagItemsMap(bag_type);
          if (!mapItems || mapItems.size <= 0) return [];
          var list = [];
          for (var _iterator2 = _createForOfIteratorHelperLoose(mapItems), _step2; !(_step2 = _iterator2()).done;) {
            var _step2$value = _step2.value,
              k = _step2$value[0],
              v = _step2$value[1];
            list.push(v);
          }
          return list;
        }

        /**
         * 根据物品唯一ID获取物品
         * @param itemuid 物品唯一ID
         * @param bag_type 背包类型
         * @returns 物品
         */;
        _proto.getBagItemByItemuid = function getBagItemByItemuid(itemuid, bag_type) {
          if (bag_type === void 0) {
            bag_type = -1;
          }
          for (var i = 0; i < this._bag_items.length; i++) {
            if (bag_type >= 0 && i !== bag_type) continue;
            var mapItems = this._bag_items[i];
            if (!mapItems) continue;
            var item = mapItems.get(itemuid);
            if (item) return item;
          }
        }

        /**
         * 根据物品ID获取背包物品
         * @param itemid 物品ID
         * @returns 物品
         */;
        _proto.getBagItemByItemid = function getBagItemByItemid(itemid) {
          var cfg = this.getItemConfig(itemid);
          if (cfg && cfg.type === ItemType.assets) {
            return null;
          }
          for (var i = 0; i < this._bag_items.length; i++) {
            var mapItems = this._bag_items[i];
            if (!mapItems) continue;
            for (var _iterator3 = _createForOfIteratorHelperLoose(mapItems), _step3; !(_step3 = _iterator3()).done;) {
              var _step3$value = _step3.value,
                k = _step3$value[0],
                v = _step3$value[1];
              if (v.itemid === itemid) return v;
            }
          }
          return null;
        }

        /**
         * 获取物品数量（统一接口）
         * @param itemid 道具ID
         * @returns 物品数量
         */;
        _proto.getItemCount = function getItemCount(itemid) {
          var cfg = this.getItemConfig(itemid);
          if (!cfg) return 0;
          if (cfg.type === ItemType.assets) {
            return App.roleMgr.getPlayerResCount(itemid);
          }
          var bagType = this.getItemBagType(itemid);
          var mapItems = this._bag_items[bagType];
          if (!mapItems) return 0;
          var count = 0;
          for (var _iterator4 = _createForOfIteratorHelperLoose(mapItems), _step4; !(_step4 = _iterator4()).done;) {
            var _step4$value = _step4.value,
              k = _step4$value[0],
              v = _step4$value[1];
            if (v.itemid === itemid) count += v.num;
          }
          return count;
        }

        /**
         * 更新单个背包物品
         * @param bag_item 物品数据
         * @param bNew 是否是新物品
         */;
        _proto.updateBagItem = function updateBagItem(bag_item, bNew) {
          if (bNew === void 0) {
            bNew = false;
          }
          if (!bag_item || !bag_item.itemid) {
            App.log.logError("\u65E0\u6548\u7684\u7269\u54C1\u6570\u636E: " + JSON.stringify(bag_item));
            return;
          }
          var itemConfig = this.getItemConfig(bag_item.itemid);
          if (!itemConfig) {
            App.log.logError("\u7269\u54C1\u914D\u7F6E\u4E0D\u5B58\u5728: itemid=" + bag_item.itemid);
            return;
          }
          if (itemConfig.type === ItemType.assets) {
            return;
          }
          var bagType = this.getItemBagType(bag_item.itemid);
          if (bagType === BagType.equip) {
            if (this._bag_equips.some(function (equip) {
              return equip && equip.itemUid === bag_item.itemUid;
            })) {
              var equipIndex = this._bag_equips.findIndex(function (equip2) {
                return equip2 && equip2.itemUid === bag_item.itemUid;
              });
              if (equipIndex !== -1) {
                this._bag_equips[equipIndex] = bag_item;
              }
              if (!bNew) {
                return;
              }
            }
          }
          if (!this._bag_items[bagType]) {
            this._bag_items[bagType] = new Map();
          }
          this._bag_items[bagType].set(bag_item.itemUid, bag_item);
        }

        /**
         * 背包奖励排序
         * @param vData 背包物品数组
         * @returns 排序后的物品数组
         */;
        _proto.sortAward = function sortAward(vData) {
          var _this = this;
          if (!Array.isArray(vData)) {
            App.log.logError("sortAward\u65B9\u6CD5\u53C2\u6570\u9519\u8BEF: " + JSON.stringify(vData));
            return [];
          }
          vData.sort(function (itemA, itemB) {
            var nMoneyA = itemA.itemid <= 100 ? 1 : 0;
            var nMoneyB = itemB.itemid <= 100 ? 1 : 0;
            if (nMoneyA !== nMoneyB) {
              return nMoneyB - nMoneyA;
            }
            var itemAConfig = _this.getItemConfig(itemA.itemid);
            var itemBConfig = _this.getItemConfig(itemB.itemid);
            var colorA = (itemAConfig == null ? void 0 : itemAConfig.color) || 0;
            var colorB = (itemBConfig == null ? void 0 : itemBConfig.color) || 0;
            return colorB - colorA;
          });
          return vData;
        }

        /**
         * 检查背包是否有该物品
         * @param item_id 物品ID
         * @returns 是否有
         */;
        _proto.checkHaveEquipByItemId = function checkHaveEquipByItemId(item_id) {
          if (this.getBagItemByItemid(item_id)) return true;
          if (this.getWearEquipDataByItemId(item_id)) return true;
          return false;
        }

        /**
         * 检查背包是否已满
         * @param bag_type 背包类型
         * @returns 是否已满
         */;
        _proto.checkBagfull = function checkBagfull(bag_type) {
          if (bag_type === BagType.equip) {
            var map = this.getBagItemsMap(bag_type);
            if (!map) return false;
          }
          return false;
        }

        /**
         * 检查物品消耗列表是否足够
         * @param vCost 消耗列表 [[物品ID, 数量], ...]
         * @param andOr true=AND模式, false=OR模式
         * @returns 是否足够
         */;
        _proto.checkItemCost = function checkItemCost(vCost, andOr) {
          if (vCost === void 0) {
            vCost = [];
          }
          if (andOr === void 0) {
            andOr = true;
          }
          if (andOr) {
            // AND 模式：所有道具都必须足够
            for (var dx0 = 0; dx0 < vCost.length; dx0++) {
              var oCost = vCost[dx0];
              if (this.getItemCount(oCost[0]) < oCost[1]) {
                return false;
              }
            }
            return true;
          } else {
            // OR 模式：至少一个道具足够即可
            for (var _dx = 0; _dx < vCost.length; _dx++) {
              var _oCost = vCost[_dx];
              if (this.getItemCount(_oCost[0]) >= _oCost[1]) {
                return true;
              }
            }
            return false;
          }
        }

        /**
         * 检查物品是否足够 统一弹窗
         * @param itemid 物品ID
         * @param cost 数量
         * @param sTips 提示
         * @param popPanel 是否弹窗
         * @returns 是否足够
         */;
        _proto.checkPropEnough = function checkPropEnough(itemid, cost, sTips, popPanel) {
          if (sTips === void 0) {
            sTips = undefined;
          }
          if (popPanel === void 0) {
            popPanel = false;
          }
          var resCount = App.roleMgr.getPlayerResCount(itemid);
          var count = this.getItemCount(itemid);
          if (resCount >= cost || count >= cost) return true;
          if (sTips) {
            Prompt.popTip(sTips);
          }
          if (popPanel) {
            this.propNotEnough(itemid, cost);
          }
          return false;
        }

        /**
         * 检查物品消耗列表是否足够 统一弹窗
         * @param costList 消耗列表 [[物品ID, 数量], ...]
         * @param sTips 提示：true=默认提示，false=不提示，string=自定义提示
         * @param popPanel 是否打开获取途径弹窗
         * @returns 是否足够
         */;
        _proto.checkPropEnoughList = function checkPropEnoughList(costList, sTips, popPanel) {
          var _this2 = this;
          if (sTips === void 0) {
            sTips = false;
          }
          if (popPanel === void 0) {
            popPanel = false;
          }
          var _loop = function _loop() {
              var _step5$value = _step5.value,
                itemid = _step5$value[0],
                cost = _step5$value[1];
              if (_this2.getItemCount(itemid) >= cost) return 0; // continue
              var tipText = typeof sTips === "string" ? sTips : function () {
                var cfg = _this2.getItemConfig(itemid);
                return cfg ? "<b>" + cfg.name + " \u4E0D\u8DB3</b>" : "";
              }();
              if (sTips && tipText) UIUtil.showTip(tipText);
              if (popPanel) _this2.propNotEnough(itemid, cost);
              return {
                v: false
              };
            },
            _ret;
          for (var _iterator5 = _createForOfIteratorHelperLoose(costList), _step5; !(_step5 = _iterator5()).done;) {
            _ret = _loop();
            if (_ret === 0) continue;
            if (_ret) return _ret.v;
          }
          return true;
        }

        /**
         * 检查物品是否足够 统一弹窗
         * @param itemid 物品ID
         * @param cost 数量
         */;
        _proto.propNotEnough = function propNotEnough(itemid, cost) {
          var cfg = this.getItemConfig(itemid);
          if (!cfg || !cfg.getAccess) return;
          var itemData = {};
          itemData.itemid = itemid;
          UIMgr.inst.open(UI_ItemSourceView, LayerType.panel, Layout_UI_ItemSourceView, [itemData]);
        }

        /**
         * 道具不足弹窗
         * @param item_id 物品ID
         */;
        _proto.showItemDetailView = function showItemDetailView(item_id) {
          if (item_id) {
            var itemData = {};
            itemData.itemid = item_id;
            UIMgr.inst.open(UI_ItemDetailView, LayerType.panel, Layout_UI_ItemDetailView, [itemData]);
          }
        }
        /**
         * 道具来源弹窗
         * @param item_id 物品ID
         */;
        _proto.showItemResources = function showItemResources(item_id) {
          if (item_id) {
            var itemData = {};
            itemData.itemid = item_id;
            UIMgr.inst.open(UI_ItemSourceView, LayerType.panel, Layout_UI_ItemSourceView, [itemData]);
          }
        }

        /**
         * 批量更新背包物品
         * @param items 物品数组
         */;
        _proto.updateBagItemList = function updateBagItemList(items) {
          if (!items || items.length === 0) return;
          var hasAssetsChange = false;
          App.roleMgr.updatePlayerAsset(items);
          for (var _iterator6 = _createForOfIteratorHelperLoose(items), _step6; !(_step6 = _iterator6()).done;) {
            var item = _step6.value;
            if (!item || !item.itemid) continue;
            var itemConfig = this.getItemConfig(item.itemid);
            if (itemConfig && itemConfig.type === ItemType.assets) {
              hasAssetsChange = true;
              continue;
            }
            this.updateBagItem(item);
          }
          if (hasAssetsChange) {
            App.monitorMgr.dispatchEvent(EventType.web_player_assets_info);
          }
        }

        /**
         * 整理背包数据 - 清空并重新初始化所有背包数据
         * @param items 服务器返回的物品数组
         */;
        _proto.makeBagData = function makeBagData(items) {
          this._bag_items = [];
          if (!items || items.length === 0) return;
          this.updateBagItemList(items);
        }

        /**
         * 加载背包数据
         */;
        _proto.reqLoadBag = function reqLoadBag() {
          netChannel.game.send(ModType.user, MonitorType.CMD_ReqUserLoadBag, {});
        }

        /**
         * 一键使用礼包
         */;
        _proto.reqAKeyUseGift = function reqAKeyUseGift() {
          netChannel.game.send(ModType.user, MonitorType.CMD_ReqAKeyUseGift, {});
        }

        /**
         * 使用可选礼包
         * @param giftId 礼包ID
         */;
        _proto.reqUseOptionalGift = function reqUseOptionalGift(giftId) {
          netChannel.game.send(ModType.user, MonitorType.CMD_ReqUseOptionalGift, {
            gift_id: giftId
          });
        }

        /**
         * 碎片合成
         * @param fragmentId 碎片ID
         * @param count 合成数量
         */;
        _proto.reqFragmentCombine = function reqFragmentCombine(fragmentId, count) {
          netChannel.game.send(ModType.user, MonitorType.CMD_ReqFragmentCombine, {
            fragment_id: fragmentId,
            count: count
          });
        }

        /**
         * 请求使用道具
         * @param uid
         */;
        _proto.reqUseItem = function reqUseItem(uid) {
          var msg = {};
          msg.item_uid = uid;
          netChannel.game.send(ModType.user, MonitorType.CMD_ReqUseItem, msg);
        }

        /**
         * 请求使用道具返回
         * @param msg
         */;
        _proto.resUseItem = function resUseItem(msg) {
          if (msg.code !== 200) {
            App.log.logError(msg);
          }
        }

        /**
         * 通用奖励弹窗
         * @param msg
         * @returns
         */;
        _proto.resRewardPopup = function resRewardPopup(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u6253\u5F00\u5956\u52B1\u5F39\u7A97\u5931\u8D25: code=" + msg.code);
            return;
          }
          UIMgr.inst.open(UI_GetRewardView, LayerType.panel, Layout_UI_GetRewardView, [msg.items]);
        }

        /**
         * 接收玩家背包数据
         */;
        _proto.recResUserLoadBag = function recResUserLoadBag(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u52A0\u8F7D\u80CC\u5305\u5931\u8D25: code=" + msg.code);
            return;
          }
          this.makeBagData(msg.items);
          App.monitorMgr.dispatchEvent(EventType.bag_update_list);
        }

        /**
         * 接收玩家背包数据变化通知
         */;
        _proto.recResUserbagchange = function recResUserbagchange(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u80CC\u5305\u6570\u636E\u53D8\u5316\u5931\u8D25: code=" + msg.code);
            return;
          }
          this.updateBagItemList(msg.items);
          App.monitorMgr.dispatchEvent(EventType.bag_update_list);
        };
        _proto.recResAKeyUseGift = function recResAKeyUseGift(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u4E00\u952E\u4F7F\u7528\u793C\u5305\u5931\u8D25: code=" + msg.code);
            return;
          }
          App.log.logBusiness("一键使用礼包成功");
        };
        _proto.recResUseOptionalGift = function recResUseOptionalGift(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u4F7F\u7528\u53EF\u9009\u793C\u5305\u5931\u8D25: code=" + msg.code);
            return;
          }
          App.log.logBusiness("使用可选礼包成功");
        };
        _proto.recResFragmentCombine = function recResFragmentCombine(msg) {
          if (msg.code !== 200) {
            App.log.logError("\u788E\u7247\u5408\u6210\u5931\u8D25: code=" + msg.code);
            return;
          }
          App.log.logBusiness("碎片合成成功");
        };
        return BagMgr;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BaseAi.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './DBRecord.ts', './BattleProprMgr.ts', './App.ts'], function (exports) {
  var _createClass, cclegacy, Vec3, DBRecord, BattlePropertyName, App;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      cclegacy._RF.push({}, "7299f7yTKNKMbLJWa9xq+P4", "BaseAi", undefined);
      var AI_BEHAVIOR = exports('AI_BEHAVIOR', /*#__PURE__*/function (AI_BEHAVIOR) {
        AI_BEHAVIOR[AI_BEHAVIOR["DAIJI"] = 0] = "DAIJI";
        AI_BEHAVIOR[AI_BEHAVIOR["YUHUI"] = 1] = "YUHUI";
        AI_BEHAVIOR[AI_BEHAVIOR["TUOZHAN"] = 2] = "TUOZHAN";
        AI_BEHAVIOR[AI_BEHAVIOR["GENSUI"] = 3] = "GENSUI";
        AI_BEHAVIOR[AI_BEHAVIOR["ZHUIJI"] = 4] = "ZHUIJI";
        AI_BEHAVIOR[AI_BEHAVIOR["GONGJI"] = 5] = "GONGJI";
        AI_BEHAVIOR[AI_BEHAVIOR["SKILL"] = 6] = "SKILL";
        AI_BEHAVIOR[AI_BEHAVIOR["CHASECHEST"] = 7] = "CHASECHEST";
        AI_BEHAVIOR[AI_BEHAVIOR["OPENCHEST"] = 8] = "OPENCHEST";
        AI_BEHAVIOR[AI_BEHAVIOR["UNDERATTACK"] = 9] = "UNDERATTACK";
        AI_BEHAVIOR[AI_BEHAVIOR["XUNLUO"] = 10] = "XUNLUO";
        AI_BEHAVIOR[AI_BEHAVIOR["SIWANG"] = 11] = "SIWANG";
        return AI_BEHAVIOR;
      }({}));

      // 0	无AI条件
      // 101	查找技能范围内是否有血量不满的友军
      // 102	查找自己的召唤物数量是否未超过上限		填写召唤物数量
      // 201	自己的血量万分比是否低于配置值		填写血量万分比
      // 202	自己的血量万分比是否高于配置值		填写血量万分比
      // 301	主动技能施放次数是否到达上限		填写上限值，施放后上限值清0
      // 302	自己身上是否有配置BUFF		填写BUFFID
      // 303	自己身上是否没有配置BUFF		填写BUFFID
      // 304	自己身上是否有配置BUFF组的任意BUFF		填写BUFF组ID
      // 305	自己身上是否没有配置BUFF组的任意BUFF		填写BUFF组ID
      // 306	检测上一个技能ID		填写技能ID
      // 307	目标身上是否有配置BUFF		填写BUFFID
      // 308	目标身上是否没有配置BUFF		填写BUFFID
      // 309	目标身上是否有配置BUFF组的任意BUFF		填写BUFF组ID
      // 310	目标身上是否没有配置BUFF组的任意BUFF		填写BUFF组ID
      // 311	普攻施放次数是否到达上限		填写上限值，施放后上限值清0
      // 312	场上有某种子弹		填写子弹id
      // 313	释放某个技能几秒后		填写技能id,秒数

      var BaseAi = exports('BaseAi', /*#__PURE__*/function () {
        function BaseAi() {
          this._owner = null;
          this.lastSkillId = 0;
          this._condtion = [];
          /** 技能使用次数 */
          this._skillUseTime = void 0;
          /** 普攻使用次数 */
          this._atkUseTime = void 0;
        }
        var _proto = BaseAi.prototype;
        _proto.init = function init(owner) {
          this._owner = owner;
          this._condtion = this.getAIByType(owner.roleVO.AIType);
          this._skillUseTime = 0;
          this.lastSkillId = 0;
          this._atkUseTime = 0;
        };
        _proto.getAIByType = function getAIByType(type) {
          var ai = DBRecord._getRes("AI");
          var list = [];
          for (var i in ai) {
            var data = ai[i];
            if (data.type === type) {
              list.push(data);
            }
          }
          // 测试用
          // return [];
          return list;
        };
        _proto.check = function check(skillVo) {
          if (this._condtion.length === 0) {
            return true;
          }
          var index = this._owner.roleVO.skillIDList.indexOf(skillVo.skillID);
          for (var i = 0; i < 3; i++) {
            var condtion = this._condtion[index]["AI_group" + (i + 1)];
            if (!condtion) continue;
            if (!this.checkCondtion(skillVo, condtion)) {
              return false;
            }
          }
          return true;
        };
        _proto.checkCondtion = function checkCondtion(skillVo, condtion) {
          for (var i = 0; i < condtion.length; i++) {
            var _condtion$i = condtion[i],
              id = _condtion$i[0],
              arg = _condtion$i[1],
              arg2 = _condtion$i[2];
            var func = this["_check_" + id];
            if (!func.call(this, skillVo, arg, arg2)) {
              return false;
            }
          }
          return true;
        }

        //检测无条件
        ;

        _proto._check_0 = function _check_0() {
          return true;
        }
        //检测友军血量
        ;

        _proto._check_101 = function _check_101(skillVo) {
          var range = skillVo.distance[1];
          var roles = App.battleMgr.roleCtrl.getRolesByType(this._owner.type);
          for (var i in roles) {
            var role = roles[i];
            var distance = Vec3.distance(this._owner.node.worldPosition, role.node.worldPosition);
            if (distance < range && role.roleVO.curHP < role.roleVO.getRoleAttr(BattlePropertyName.shengming)) {
              return true;
            }
          }
          return false;
        }

        //检测召唤物数量
        ;

        _proto._check_102 = function _check_102(skillVo, max) {
          var count = 0;
          var roles = App.battleMgr.roleCtrl.getRolesByType(this._owner.type);
          for (var i in roles) {
            var role = roles[i];
            if (role.masterId === this._owner.uid) {
              count++;
            }
          }
          return count < max;
        }

        //201	自己的血量万分比是否低于配置值		填写血量万分比
        ;

        _proto._check_201 = function _check_201(skillVo, max) {
          var count = this._owner.roleVO.curHP / this._owner.roleVO.getRoleAttr(BattlePropertyName.shengming) * 10000;
          return count < max;
        }

        //202	自己的血量万分比是否高于配置值		填写血量万分比
        ;

        _proto._check_202 = function _check_202(skillVo, max) {
          var count = this._owner.roleVO.curHP / this._owner.roleVO.getRoleAttr(BattlePropertyName.shengming) * 10000;
          return count > max;
        }

        // 301	主动技能施放次数是否到达上限		填写上限值，施放后上限值清0
        ;

        _proto._check_301 = function _check_301(skillVo, max) {
          return this._skillUseTime > 0 && this._skillUseTime % max === 0;
        }

        // 302	自己身上是否有配置BUFF		填写BUFFID
        ;

        _proto._check_302 = function _check_302(skillVo, buffID) {
          return this._owner._buffBox.getBuffById(buffID) !== null;
        }

        // 303	自己身上是否没有配置BUFF		填写BUFFID
        ;

        _proto._check_303 = function _check_303(skillVo, buffID) {
          return this._owner._buffBox.getBuffById(buffID) === null;
        }

        // 304	自己身上是否有配置BUFF组的任意BUFF		填写BUFF组ID
        ;

        _proto._check_304 = function _check_304(skillVo, groupID) {
          return this._owner._buffBox.getBuffGroupById(groupID) !== null;
        }

        // 305	自己身上是否没有配置BUFF组的任意BUFF		填写BUFF组ID
        ;

        _proto._check_305 = function _check_305(skillVo, groupID) {
          return this._owner._buffBox.getBuffGroupById(groupID) === null;
        }

        // 306	检测上一个技能ID		填写技能ID
        ;

        _proto._check_306 = function _check_306(skillVo, skillId) {
          // console.log('aiaiaiai  check', this.lastSkillId , skillId )
          var ret = this.lastSkillId === skillId;
          if (ret) {
            this._owner.publicSkillCd = 0;
          }
          return ret;
        }

        // 307	目标身上是否有配置BUFF		填写BUFFID
        ;

        _proto._check_307 = function _check_307(skillVo, buffID) {
          var _skillVo$getTarget;
          return ((_skillVo$getTarget = skillVo.getTarget()) == null ? void 0 : _skillVo$getTarget._buffBox.getBuffById(buffID)) !== null;
        }

        // 308	目标身上是否没有配置BUFF		填写BUFFID
        ;

        _proto._check_308 = function _check_308(skillVo, buffID) {
          var _skillVo$getTarget2;
          return ((_skillVo$getTarget2 = skillVo.getTarget()) == null ? void 0 : _skillVo$getTarget2._buffBox.getBuffById(buffID)) === null;
        }

        // 309	目标身上是否有配置BUFF组的任意BUFF		填写BUFF组ID
        ;

        _proto._check_309 = function _check_309(skillVo, groupID) {
          var _skillVo$getTarget3;
          return ((_skillVo$getTarget3 = skillVo.getTarget()) == null ? void 0 : _skillVo$getTarget3._buffBox.getBuffGroupById(groupID)) !== null;
        }

        // 310	目标身上是否没有配置BUFF组的任意BUFF		填写BUFF组ID
        ;

        _proto._check_310 = function _check_310(skillVo, groupID) {
          var _skillVo$getTarget4;
          return ((_skillVo$getTarget4 = skillVo.getTarget()) == null ? void 0 : _skillVo$getTarget4._buffBox.getBuffGroupById(groupID)) === null;
        }

        // 311	目标身上是否没有配置BUFF组的任意BUFF		填写BUFF组ID
        ;

        _proto._check_311 = function _check_311(skillVo, max) {
          return this._atkUseTime > 0 && this._atkUseTime % max === 0;
        }

        //312	场上有某种子弹		填写子弹id
        ;

        _proto._check_312 = function _check_312(skillVo, bulletId) {
          var bullets = App.battleMgr.bulletCtrl.getBulletsByBullId(bulletId);
          return bullets.length > 0;
        }

        // 313	释放某个技能几秒后		填写技能id,秒数
        ;

        _proto._check_313 = function _check_313(skillVo, skillId, second) {
          var skillTimeStamp = this._owner.useSkillTimeStamp[skillId];
          var now = Date.now();
          return skillTimeStamp && now - skillTimeStamp >= second * 1000;
        }

        // 314——
        ;

        _proto._check_314 = function _check_314(skillVo, skillId, second) {
          var skillTimeStamp = this._owner.useSkillTimeStamp[skillId];
          var now = Date.now();
          return skillTimeStamp && now - skillTimeStamp <= second * 1000;
        };
        _createClass(BaseAi, [{
          key: "condtion",
          get: function get() {
            return this._condtion;
          },
          set: function set(value) {
            this._condtion = value;
          }
        }, {
          key: "skillUseTime",
          get: function get() {
            return this._skillUseTime;
          },
          set: function set(value) {
            this._skillUseTime = value;
          }
        }, {
          key: "atkUseTime",
          get: function get() {
            return this._atkUseTime;
          },
          set: function set(value) {
            this._atkUseTime = value;
          }
        }]);
        return BaseAi;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BaseSpine.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './ModuleDef.ts', './Item_BattleMap.ts', './UIMgr.ts', './App.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createForOfIteratorHelperLoose, _createClass, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, sp, UITransform, UIOpacity, builtinResMgr, Material, Color, Component, ModuleDef, Item_BattleMap, UIMgr, App;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _createClass = module.createClass;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      sp = module.sp;
      UITransform = module.UITransform;
      UIOpacity = module.UIOpacity;
      builtinResMgr = module.builtinResMgr;
      Material = module.Material;
      Color = module.Color;
      Component = module.Component;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      Item_BattleMap = module.Item_BattleMap;
    }, function (module) {
      UIMgr = module.UIMgr;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _dec2, _class, _class2, _descriptor;
      cclegacy._RF.push({}, "e536d7crf5JopUu4stqrzXE", "BaseSpine", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /** spine基类 */
      var BaseSpine = exports('BaseSpine', (_dec = ccclass("BaseSpine"), _dec2 = property({
        type: sp.Skeleton
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BaseSpine, _Component);
        function BaseSpine() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /** 骨骼对象 */
          _initializerDefineProperty(_this, "skeleton", _descriptor, _assertThisInitialized(_this));
          _this._partId = 0;
          //0-通常；11-翅膀
          /** 透明度 */
          _this._alpha = void 0;
          /** 缩放 */
          _this._sacle = void 0;
          /** 是否翻转 */
          _this._isFlipX = false;
          /** 是否置灰 */
          _this._isGray = false;
          /** 是否阴影化 */
          _this._isShadow = false;
          /** 当前Spine动画使用的皮肤 */
          _this._skinName = "";
          return _this;
        }
        var _proto = BaseSpine.prototype;
        _proto.start = function start() {};
        _proto.onDestroy = function onDestroy() {};
        _proto.reset = function reset() {
          this.clearAllAnimation();
          this.clearAllHandler();
          this.stopAllTrack();
          this._skinName = "";
          this.playRate = 1;
          this.isGray = false;
          this.isShadow = false;
          this.isFlipX = false;
          this.pause = false;
          this.skeleton.skeletonData = null;
          // this.skeleton.setSkin('')
        }

        /** 当前正在播放的动画名 */;
        /**
         * 加载骨骼数据
         * @param path 目录
         * @param onCompleted 成功回调
         * @param onFaild 失败回调
         */
        _proto.loadSkeletonData = function loadSkeletonData(path, onCompleted, onFaild, bundleName) {
          var _this2 = this;
          this.skeleton.skeletonData = null;
          if (typeof path !== "string" || path === "") {
            var _err = new Error();
            _err.message = "path:" + path;
            onFaild == null || onFaild(_err);
            return;
          }
          var bundleStr = bundleName ? bundleName : ModuleDef.SPINE;
          App.resMgr.loadAsset(bundleStr, path, sp.SkeletonData, null, function (err, res) {
            if (err) {
              onFaild == null || onFaild(err);
              return;
            }
            if (_this2 && _this2.skeleton) {
              _this2.skeleton.skeletonData = res;
              _this2.skeleton.setAnimationCacheMode(sp.AnimationCacheMode.REALTIME);
            }
            onCompleted == null || onCompleted();
          });
        }

        /**
         * 加载英雄骨骼数据
         * @param path 目录
         * @param onCompleted 成功回调
         * @param onFaild 失败回调
         */;
        _proto.loadHeroSkeletonData = /*#__PURE__*/
        function () {
          var _loadHeroSkeletonData = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(path, onCompleted, onFaild) {
            var _this3 = this;
            var _err2, bundle;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  this.skeleton.skeletonData = null;
                  if (!(typeof path !== "string" || path === "")) {
                    _context.next = 6;
                    break;
                  }
                  _err2 = new Error();
                  _err2.message = "path:" + path;
                  onFaild == null || onFaild(_err2);
                  return _context.abrupt("return");
                case 6:
                  if (!(this && this.skeleton)) {
                    _context.next = 17;
                    break;
                  }
                  if (!Item_BattleMap.heroAsset[path]) {
                    _context.next = 12;
                    break;
                  }
                  this.skeleton.skeletonData = Item_BattleMap.heroAsset[path];
                  onCompleted == null || onCompleted();
                  _context.next = 17;
                  break;
                case 12:
                  console.log("============================>> loadHeroSkeletonData:", path, "没有资源，重新加载");
                  _context.next = 15;
                  return UIMgr.inst.asyncGetBundle(ModuleDef.HERO);
                case 15:
                  bundle = _context.sent;
                  bundle.load(path + "/" + path, sp.SkeletonData, null, function (err, res) {
                    if (err) {
                      onFaild == null || onFaild(err);
                      return;
                    }
                    Item_BattleMap.heroAsset[path] = res;
                    if (_this3 && _this3.skeleton) {
                      _this3.skeleton.skeletonData = res;
                      _this3.skeleton.setAnimationCacheMode(sp.AnimationCacheMode.REALTIME);
                    }
                    onCompleted == null || onCompleted();
                  });
                case 17:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function loadHeroSkeletonData(_x, _x2, _x3) {
            return _loadHeroSkeletonData.apply(this, arguments);
          }
          return loadHeroSkeletonData;
        }()
        /**
         * 加载士兵骨骼数据
         * @param path 目录
         * @param onCompleted 成功回调
         * @param onFaild 失败回调
         */;

        _proto.loadSoldierSkeletonData = /*#__PURE__*/
        function () {
          var _loadSoldierSkeletonData = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(path, onCompleted, onFaild) {
            var _this4 = this;
            var _err3, bundle;
            return _regeneratorRuntime().wrap(function _callee2$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  this.skeleton.skeletonData = null;
                  if (!(typeof path !== "string" || path === "")) {
                    _context2.next = 6;
                    break;
                  }
                  _err3 = new Error();
                  _err3.message = "path:" + path;
                  onFaild == null || onFaild(_err3);
                  return _context2.abrupt("return");
                case 6:
                  if (!(this && this.skeleton)) {
                    _context2.next = 17;
                    break;
                  }
                  if (!Item_BattleMap.soldierAsset[path]) {
                    _context2.next = 12;
                    break;
                  }
                  this.skeleton.skeletonData = Item_BattleMap.soldierAsset[path];
                  onCompleted == null || onCompleted();
                  _context2.next = 17;
                  break;
                case 12:
                  console.log("============================>> loadHeroSkeletonData:", path, "没有资源，重新加载");
                  _context2.next = 15;
                  return UIMgr.inst.asyncGetBundle(ModuleDef.SOLDIER);
                case 15:
                  bundle = _context2.sent;
                  bundle.load(path + "/" + path, sp.SkeletonData, null, function (err, res) {
                    if (err) {
                      onFaild == null || onFaild(err);
                      return;
                    }
                    Item_BattleMap.soldierAsset[path] = res;
                    if (_this4 && _this4.skeleton) {
                      _this4.skeleton.skeletonData = res;
                      _this4.skeleton.setAnimationCacheMode(sp.AnimationCacheMode.REALTIME);
                    }
                    onCompleted == null || onCompleted();
                  });
                case 17:
                case "end":
                  return _context2.stop();
              }
            }, _callee2, this);
          }));
          function loadSoldierSkeletonData(_x4, _x5, _x6) {
            return _loadSoldierSkeletonData.apply(this, arguments);
          }
          return loadSoldierSkeletonData;
        }()
        /**
         * 加载怪物骨骼数据
         * @param path 目录
         * @param onCompleted 成功回调
         * @param onFaild 失败回调
         */;

        _proto.loadMonsterSkeletonData = /*#__PURE__*/
        function () {
          var _loadMonsterSkeletonData = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(path, onCompleted, onFaild) {
            var _this5 = this;
            var _err4, bundle;
            return _regeneratorRuntime().wrap(function _callee3$(_context3) {
              while (1) switch (_context3.prev = _context3.next) {
                case 0:
                  this.skeleton.skeletonData = null;
                  if (!(typeof path !== "string" || path === "")) {
                    _context3.next = 6;
                    break;
                  }
                  _err4 = new Error();
                  _err4.message = "path:" + path;
                  onFaild == null || onFaild(_err4);
                  return _context3.abrupt("return");
                case 6:
                  if (!(this && this.skeleton)) {
                    _context3.next = 16;
                    break;
                  }
                  if (!Item_BattleMap.monsterAsset[path]) {
                    _context3.next = 12;
                    break;
                  }
                  this.skeleton.skeletonData = Item_BattleMap.monsterAsset[path];
                  onCompleted == null || onCompleted();
                  _context3.next = 16;
                  break;
                case 12:
                  _context3.next = 14;
                  return UIMgr.inst.asyncGetBundle(ModuleDef.MONSTER);
                case 14:
                  bundle = _context3.sent;
                  bundle.load(path + "/" + path, sp.SkeletonData, null, function (err, res) {
                    if (err) {
                      onFaild == null || onFaild(err);
                      return;
                    }
                    Item_BattleMap.monsterAsset[path] = res;
                    if (_this5 && _this5.skeleton) {
                      _this5.skeleton.skeletonData = res;
                      _this5.skeleton.setAnimationCacheMode(sp.AnimationCacheMode.REALTIME);
                    }
                    onCompleted == null || onCompleted();
                  });
                case 16:
                case "end":
                  return _context3.stop();
              }
            }, _callee3, this);
          }));
          function loadMonsterSkeletonData(_x7, _x8, _x9) {
            return _loadMonsterSkeletonData.apply(this, arguments);
          }
          return loadMonsterSkeletonData;
        }()
        /**
         * 加载怪物骨骼数据
         * @param path 目录
         * @param onCompleted 成功回调
         * @param onFaild 失败回调
         */;

        _proto.loadMonsterSkeletonData2 = function loadMonsterSkeletonData2(path, onCompleted, onFaild) {
          var _this6 = this;
          this.skeleton.skeletonData = null;
          if (typeof path !== "string" || path === "") {
            var _err5 = new Error();
            _err5.message = "path:" + path;
            onFaild == null || onFaild(_err5);
            return;
          }
          App.resMgr.loadAsset("HuoBan", path + "/" + path, sp.SkeletonData, null, function (err, res) {
            if (err) {
              onFaild == null || onFaild(err);
              return;
            }
            if (_this6 && _this6.skeleton) {
              _this6.skeleton.skeletonData = res;
              _this6.skeleton.setAnimationCacheMode(sp.AnimationCacheMode.REALTIME);
            }
            onCompleted == null || onCompleted();
          });
        }

        /** 设置皮肤 */;
        _proto.setSkin = function setSkin(skinName) {
          this._skinName = skinName;
          if (this._skinName !== null && this._skinName !== "") {
            var _this$skeleton$_skele;
            var skins = this.skeleton.skeletonData.getSkinsEnum();
            if (skins !== null && skins[skinName] !== null && this.skeleton._skeleton !== null && ((_this$skeleton$_skele = this.skeleton._skeleton.skin) == null ? void 0 : _this$skeleton$_skele.name) !== skinName) {
              this.skeleton.setSkin(this._skinName);
            }
          }
        }

        /**
         * 播放默认动画（排序第一的动画）
         * @param loop 是否循环
         */;
        _proto.playDefault = function playDefault(loop) {
          this.playByIndex(1, loop, 0);
        }

        /**
         * 播放动画
         * @param animationIndex 动画名称索引
         * @param loop 是否循环
         * @param trackIndex 队列索引
         */;
        _proto.playByIndex = function playByIndex(animationIndex, loop, trackIndex) {
          if (trackIndex === void 0) {
            trackIndex = 0;
          }
          if (!this.skeleton || !this.skeleton.skeletonData) return;
          var animsEnum = this.skeleton.skeletonData.getAnimsEnum();
          var name = String(animsEnum[animationIndex]);
          this.play(name, loop, trackIndex);
        }

        /**
         * 播放动画
         * @param animationName 动画名
         * @param loop 是否循环
         * @param _trackIndex 队列
         */;
        _proto.play = function play(animationName, loop, _trackIndex) {
          // if (this._partId == WINGS_PART) {
          //     //翅膀不能与动作融合
          //     if (animationName.endsWith('_Move')) {
          //         animationName = 'Move';
          //     } else if (animationName.endsWith('_Idle')) {
          //         animationName = 'Idle';
          //     }
          // }
          // if (!this.skeleton.getComponent(sp.Skeleton).findAnimation(animationName)) return;
          if (!this.skeleton.findAnimation(animationName)) return;
          if (this.skeleton.paused) {
            this.skeleton.paused = false;
          }
          this.clearAllAnimation();
          this.skeleton.setAnimation(0, animationName, loop);
        }

        /** 停止播放 */;
        _proto.stop = function stop(trackIndex) {
          if (trackIndex === void 0) {
            trackIndex = 0;
          }
          this.skeleton.clearTrack(trackIndex);
        }

        /** 停止所有的动画轨道 */;
        _proto.stopAllTrack = function stopAllTrack() {
          this.skeleton.clearTracks();
        }

        /**
         * 添加融合动画
         * @param animationName 动画名称
         * @param loop 是否循环，默认为true
         * @param trackIndex 轨道索引，默认为0
         */;
        _proto.addAnimation = function addAnimation(animationName, loop, trackIndex) {
          if (loop === void 0) {
            loop = true;
          }
          // if (!this.skeleton.getComponent(sp.Skeleton).findAnimation(animationName)) return;

          // if (this._partId == WINGS_PART) {
          //     //翅膀不能与动作融合
          //     if (animationName.endsWith('_Move')) {
          //         animationName = 'Move';
          //     } else if (animationName.endsWith('_Idle')) {
          //         animationName = 'Idle';
          //     }
          //     if (this.skeleton.findAnimation(animationName)) {
          //         this.skeleton.setAnimation(0, animationName, loop);
          //     }
          //     return;
          // }
          // 添加的通道索引
          if (!this.skeleton.findAnimation(animationName)) {
            return;
          }
          var state = this.skeleton.getState();
          if (!state) {
            return;
          }
          var index = trackIndex !== undefined ? trackIndex : state.tracks.length;
          this.skeleton.addAnimation(index, animationName, loop);
        }

        /**
         * 清除单一动画
         * @param animationName 清除的动画名称
         */;
        _proto.clearAnimation = function clearAnimation(animationName) {
          var state = this.skeleton.getState();
          if (!state) {
            return;
          }
          var tracks = state.tracks;
          //console.log('清除动画', animationName, '轨道', tracks.length);
          for (var _iterator = _createForOfIteratorHelperLoose(tracks), _step; !(_step = _iterator()).done;) {
            var value = _step.value;
            if (!!value && value.animation.name === animationName) {
              this.skeleton.clearAnimation(value.trackIndex);
              break;
            }
          }
        }

        /**
         * 清除所有动画
         */;
        _proto.clearAllAnimation = function clearAllAnimation() {
          this.skeleton.clearAnimations();
        }

        /**
         * 获取世界坐标系下包围盒
         * @returns
         */;
        _proto.getBoundingBoxToWorld = function getBoundingBoxToWorld() {
          return this.skeleton.getComponent(UITransform).getBoundingBoxToWorld();
        }

        /**
         * 清理所有回调函数
         */;
        _proto.clearAllHandler = function clearAllHandler() {
          this.setStartHandler(null);
          this.setCompleteHandler(null);
          this.setInterruptHandler(null);
          this.setFrameEventHandler(null);
        }

        /**
         * 用来设置开始播放动画的事件监听。
         * @param handler 回调函数
         * @returns
         */;
        _proto.setStartHandler = function setStartHandler(handler) {
          if (typeof handler !== "function") {
            this.skeleton.setStartListener(null);
            return;
          }
          this.skeleton.setStartListener(function (trace) {
            handler(trace);
          });
        }

        /**
         * 用来设置动画播放一次循环结束后的事件监听。
         * @param handler 回调函数
         * @returns
         */;
        _proto.setCompleteHandler = function setCompleteHandler(handler) {
          if (typeof handler !== "function") {
            this.skeleton.setCompleteListener(null);
            return;
          }
          this.skeleton.setCompleteListener(function (trace) {
            handler(trace);
          });
        }

        /**
         * 用来设置动画被打断的事件监听。
         * @param handler 回调函数
         * @returns
         */;
        _proto.setInterruptHandler = function setInterruptHandler(handler) {
          var _this7 = this;
          if (typeof handler !== "function") {
            this.skeleton.setInterruptListener(null);
            return;
          }
          this.skeleton.setInterruptListener(function () {
            handler(_this7);
          });
        }

        /**
         * 用来设置动画播放过程中帧事件的监听。
         * @param handler 回调函数
         * @returns
         */;
        _proto.setFrameEventHandler = function setFrameEventHandler(handler) {
          if (typeof handler !== "function") {
            this.skeleton.setEventListener(null);
            return;
          }
          this.skeleton.setEventListener(function (trackEntry, event) {
            handler(trackEntry, event);
          });
        }

        /**
         * @param skinName 要替换的部件皮肤名称
         * @param slotName 要替换的部件的插槽名称
         * @param targetAttaName  Spine中皮肤占位符的名字
         */;
        _proto.changeSlot = function changeSlot(skinName, slotName, targetAttaName) {
          //查找局部皮肤
          var skeletonData = this.skeleton.skeletonData.getRuntimeData();
          var targetSkin = skeletonData.findSkin(skinName);

          //查找局部皮肤下的插槽与附件
          var targetSkinSlotIndex = skeletonData.findSlotIndex(slotName);
          if (targetSkin && targetSkinSlotIndex > -1) {
            var atta = targetSkin.getAttachment(targetSkinSlotIndex, targetAttaName);

            //查找全身皮肤下的插槽
            var curSlot = this.skeleton.findSlot(slotName);

            //替换全身皮肤插槽的附件
            curSlot && curSlot.setAttachment(atta);
          }
        };
        _proto.setTimeScale = function setTimeScale(timeScale) {
          this.skeleton.timeScale = timeScale;
        }

        /**
         * 获取当前正在播放的动画
         * @returns
         */;
        _proto.getAllPlayingAnimation = function getAllPlayingAnimation() {
          var animations = [];
          var state = this.skeleton.getState();
          if (state && state.tracks) {
            // 遍历所有轨道获取正在播放的动画
            for (var i = 0; i < state.tracks.length; i++) {
              var track = state.tracks[i];
              if (track && track.animation) {
                animations.push(track.animation.name);
              }
            }
          }
          console.log("当前正在播放的动画：", animations);
          return animations;
        }

        /**
         * 检查太刀玩家是否正在攻击、技能动作，此时隐藏背后的武器模型
         * @returns
         */;
        _proto.checkPlayerAttack = function checkPlayerAttack() {
          return true;
          ////this.getAllPlayingAnimation();
          // const state = this.skeleton.getState();
          // if (state && state.tracks) {
          //     for (let i = 0; i < state.tracks.length; i++) {
          //         const track = state.tracks[i];
          //         if (
          //             track &&
          //             track.animation &&
          //             (track.animation.name == 'TaiDao_Skill' ||
          //                 track.animation.name == 'TaiDao_Skill2' ||
          //                 track.animation.name == 'TaiDao_Skill3' ||
          //                 track.animation.name == 'TaiDao_Buff' ||
          //                 track.animation.name == 'TaiDao_Attack')
          //         ) {
          //             return true;
          //         }
          //     }
          // }
          // return false;
        };

        _createClass(BaseSpine, [{
          key: "animation",
          get: function get() {
            return this.skeleton.animation;
          }

          /** 当前动作时长 */
        }, {
          key: "duration",
          get: function get() {
            return this.skeleton.getCurrent(0).animation.duration;
          }

          /** 当前动作播放了多久 */
        }, {
          key: "playTime",
          get: function get() {
            return this.skeleton.getCurrent(0).trackTime;
          }

          /** 暂停 */
        }, {
          key: "pause",
          get: function get() {
            return this.skeleton.paused;
          },
          set: function set(v) {
            this.skeleton.paused = v;
          }
        }, {
          key: "partId",
          set: function set(v) {
            this._partId = v;
          }

          /** 播放速率 */
        }, {
          key: "playRate",
          get: function get() {
            return this.skeleton.timeScale;
          },
          set: function set(v) {
            this.skeleton.timeScale = v;
          }

          /** 宽度 */
        }, {
          key: "width",
          get: function get() {
            return this.skeleton.getComponent(UITransform).width;
          }

          /** 高度 */
        }, {
          key: "height",
          get: function get() {
            return this.skeleton.getComponent(UITransform).height;
          }

          /** 设置透明度（0-1） */
        }, {
          key: "alpha",
          get: function get() {
            return this._alpha;
          },
          set: function set(v) {
            this._alpha = v;
            var opacity = this.node.getComponent(UIOpacity);
            if (!opacity) {
              opacity = this.node.addComponent(UIOpacity);
            }
            opacity.opacity = v * 255;
          }

          /** 设置缩放 */
        }, {
          key: "scale",
          get: function get() {
            return this._sacle;
          },
          set: function set(v) {
            if (this._sacle === v) return;
            this._sacle = v;
            this.node.setScale(this._sacle, this._sacle, this.node.scale.z);
          }

          /** 设置置灰 */
        }, {
          key: "isGray",
          set: function set(v) {
            v = !!v;
            if (this._isGray === v) return;
            this._isGray = v;
            if (this._isGray) {
              var srcMat = builtinResMgr.get("ui-sprite-gray-material");
              var mat = new Material();
              mat.copy(srcMat);
              this.skeleton.customMaterial = mat;
            } else {
              if (this.skeleton.customMaterial) {
                this.skeleton.customMaterial.destroy();
              }
              this.skeleton.customMaterial = null;
            }
          }

          /** 是否镜像翻转 */
        }, {
          key: "isFlipX",
          get: function get() {
            return this._isFlipX;
          },
          set: function set(v) {
            v = !!v;
            if (this._isFlipX === v) return;
            this._isFlipX = v;
            if (v) {
              this.node.setScale(-this.node.scale.x, this.node.scale.y, this.node.scale.z);
            } else {
              this.node.setScale(Math.abs(this.node.scale.x), this.node.scale.y, this.node.scale.z);
            }
          }

          /**
           * 设置阴影化
           */
        }, {
          key: "isShadow",
          get: function get() {
            return this._isShadow;
          },
          set: function set(isShadow) {
            isShadow = !!isShadow;
            if (this._isShadow === isShadow) return;
            this._isShadow = isShadow;
            this.skeleton.color = new Color(this._isShadow ? "#000000CC" : "#FFFFFF");
          }
        }]);
        return BaseSpine;
      }(Component), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "skeleton", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleBigMap.ts", ['cc'], function (exports) {
  var cclegacy, v2, UITransform, v3, instantiate, Label, Sprite, color;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
      v2 = module.v2;
      UITransform = module.UITransform;
      v3 = module.v3;
      instantiate = module.instantiate;
      Label = module.Label;
      Sprite = module.Sprite;
      color = module.color;
    }],
    execute: function () {
      var _class;
      cclegacy._RF.push({}, "4299aPC4gVKSq/XYkZaH49W", "BattleBigMap", undefined);

      /**
       * 整个关卡的物理层数据
       */
      var BattleBigMap = exports('BattleBigMap', /*#__PURE__*/function () {
        function BattleBigMap() {
          /**
           * 物理层数据,只保存可行走的格子行列值：{列,行}。
           * 一个{列,行}数据存储为一个string。
           * 允许负数行列值，方便和怪物的实际坐标转换。
           */
          this.bigMapPhysicsData = new Set();
          /** 格子大小 */
          this.tileSize = void 0;
          /**调试路径用的贴图 */
          this.debugPathSprite = void 0;
          /**调试物理层用的贴图 */
          this.debugPhysicsSprite = void 0;
          /**调试路径用的层 */
          this.debugLayer = void 0;
          /**贴图列表 */
          this.debugSpriteList = [];
          /**物理层key temp */
          this.phyKeyStrTemp = "";
        }
        BattleBigMap.getInstance = function getInstance() {
          if (this._instance === undefined) {
            this._instance = new this();
          }
          return this._instance;
        };
        var _proto = BattleBigMap.prototype;
        /**
         * 添加单个地块的物理层数据到bigMapPhysicsData中
         * @param x
         * @param y
         * @param tiledMap
         */
        _proto.addMapPhysicsData = function addMapPhysicsData(x, y, tiledMap, mapName) {
          var mapHeight = tiledMap.getMapSize().height;
          var mapWidth = tiledMap.getMapSize().width;
          var tiles = tiledMap.getLayer("physicalLayer").tiles;
          var tileSize = tiledMap.getTileSize().width;
          this.tileSize = tileSize;
          var startRow = Math.trunc(y / tileSize);
          var startColumn = Math.trunc(x / tileSize);
          var debugPhysicsList = [];
          //从地块底部逐行遍历
          for (var row = mapHeight - 1; row >= 0; row--) {
            for (var column = 0; column < mapWidth; column++) {
              if (tiles[row * mapWidth + column] > 0) {
                var columnInBigMap = startColumn + column;
                //TiledMap的Y坐标向下，行数需要倒序
                var rowInBigMap = startRow + mapHeight - 1 - row;
                var pyhKey = columnInBigMap + "_" + rowInBigMap;
                this.bigMapPhysicsData.add(pyhKey);
                debugPhysicsList.push([startColumn + column, startRow + mapHeight - 1 - row]);
              }
            }
          }
          this.showDebugPhysics(debugPhysicsList);
          //log("-------->addMapPhysicsData,x,y,w,h,startRow,startColumn",mapName,x,y,mapWidth,mapHeight,startRow,startColumn,this.bigMapPhysicsData.size);
        }

        /**
         * 清除大地图物理层数据
         */;
        _proto.clearMapPhysicsData = function clearMapPhysicsData() {
          this.bigMapPhysicsData.clear();
        }

        /**
         * 修改物理层数据
         * @param column y 世界坐标
         * @param val 0不可行走 1可行走
         */;
        _proto.modifyMapPhysicsData = function modifyMapPhysicsData(column, row, tiledMap, val) {
          if (val === void 0) {
            val = 0;
          }
          var pos = this.tileGridToBigMapGrid(column, row, tiledMap);
          var phyKeyStr = pos.x + "_" + pos.y;
          //console.log('------------> modifyMapPhysicsData:', val == 0 ? '阻挡' : '可行走', this.bigMapPhysicsData.has(key), pos.x, pos.y);
          if (val == 0) {
            this.bigMapPhysicsData["delete"](phyKeyStr);
            // this.setTestPhysicsTile(pos.x*this.tileSize,pos.y*this.tileSize,"#ffffff")
          } else {
            this.bigMapPhysicsData.add(phyKeyStr);
            // this.setTestPhysicsTile(pos.x*this.tileSize,pos.y*this.tileSize,"#ff0000")
          }
        }

        /**大地图坐标转成大地图的行列 */;
        _proto.pointToBigMapGrid = function pointToBigMapGrid(point) {
          var x = Math.trunc(point.x / this.tileSize);
          if (point.x < 0 && Math.abs(point.x) % this.tileSize != 0) {
            x -= 1;
          }
          var y = Math.trunc(point.y / this.tileSize);
          if (point.y < 0 && Math.abs(point.y) % this.tileSize != 0) {
            y -= 1;
          }
          return v2(x, y);
        }

        /**格子是否阻挡 */;
        _proto.isBlock = function isBlock(x, y) {
          this.phyKeyStrTemp = x + "_" + y;
          return !this.bigMapPhysicsData.has(this.phyKeyStrTemp);
        }

        /**
         * tileMap的行列转成大地图的行列
         * @param column
         * @param row
         * @param tiledMap
         * @returns
         */;
        _proto.tileGridToBigMapGrid = function tileGridToBigMapGrid(column, row, tiledMap) {
          row = tiledMap.getMapSize().height - row - 1;
          var x = column * this.tileSize;
          var y = row * this.tileSize;
          var pos = tiledMap.getComponent(UITransform).convertToWorldSpaceAR(v3(x, y, 0));
          var grid = this.pointToBigMapGrid(pos);
          return grid;
        };
        _proto.initDebugPathSprite = function initDebugPathSprite(debugSprite) {
          this.debugPathSprite = debugSprite;
        };
        _proto.initDebugPhysicsSprite = function initDebugPhysicsSprite(debugSprite) {
          this.debugPhysicsSprite = debugSprite;
        };
        _proto.initDebugLayer = function initDebugLayer(layer) {
          this.debugLayer = layer;
        }

        /**
         * 显示路径
         * @param path
         */;
        _proto.showDebugPath = function showDebugPath(path) {
          if (!this.debugPathSprite || !this.debugPathSprite.isValid || !this.debugLayer || !this.debugLayer.isValid) {
            return;
          }
          var angleMap = {
            "1_0": 0,
            "1_1": 45,
            "0_1": 90,
            "-1_1": 135,
            "-1_0": 180,
            "-1_-1": 225,
            "0_-1": 270,
            "1_-1": 315
          };
          var colorNum;
          // for (const element of this.debugSpriteList) {
          //     element.removeFromParent();
          // }
          var debugSpriteList = [];
          for (var index = 0; index < path.length; index++) {
            var xDir = 2;
            var yDir = 2;
            if (index < path.length - 1) {
              xDir = path[index + 1].x > path[index].x ? 1 : path[index + 1].x < path[index].x ? -1 : 0;
              yDir = path[index + 1].y > path[index].y ? 1 : path[index + 1].y < path[index].y ? -1 : 0;
            }
            colorNum = index == 0 ? 0x3fca33 : index == path.length - 1 ? 0xffff7f : 0x202e00;
            var key = xDir.toString() + "_" + yDir.toString();
            this.addDebugPathGrid(path[index].x, path[index].y, path.length, "#" + colorNum.toString(16), angleMap[key], debugSpriteList);
          }
          setTimeout(function () {
            for (var _i = 0, _debugSpriteList = debugSpriteList; _i < _debugSpriteList.length; _i++) {
              var element = _debugSpriteList[_i];
              element.removeFromParent();
            }
            debugSpriteList.length = 0;
          }, 1500);
        }

        /**
         * 添加路径格子贴图
         * @param x
         * @param y
         * @param len 路径长度
         * @param colorStr
         * @param angle 箭头朝向
         * @param list
         */;
        _proto.addDebugPathGrid = function addDebugPathGrid(x, y, len, colorStr, angle, list) {
          var spriteNode = instantiate(this.debugPathSprite);
          spriteNode.active = true;
          spriteNode.parent = this.debugLayer;
          spriteNode.setPosition(x * this.tileSize, y * this.tileSize, 0);
          spriteNode.getChildByName("Label").getComponent(Label).string = len.toString();
          spriteNode.getComponent(Sprite).color = color(colorStr);
          if (angle == undefined) {
            spriteNode.getChildByName("Sprite").active = false;
          } else {
            spriteNode.getChildByName("Sprite").angle = angle;
          }
          this.debugSpriteList.push(spriteNode);
          list.push(spriteNode);
        }

        /**
         * 显示物理层
         */;
        _proto.showDebugPhysics = function showDebugPhysics(list) {
          if (!BattleBigMap.SHOW_PHYSICS_SPRITE) {
            return;
          }
          if (!this.debugPhysicsSprite || !this.debugPhysicsSprite.isValid || !this.debugLayer || !this.debugLayer.isValid) {
            return;
          }
          for (var index = 0; index < list.length; index++) {
            var x = list[index][0];
            var y = list[index][1];
            var spriteNode = instantiate(this.debugPhysicsSprite);
            spriteNode.active = true;
            spriteNode.parent = this.debugLayer;
            spriteNode.setPosition(x * this.tileSize, y * this.tileSize, 0);
            if (BattleBigMap.SHOW_PHYSICS_ROW_COL) {
              spriteNode.getChildByName("row").getComponent(Label).string = y.toString();
              spriteNode.getChildByName("col").getComponent(Label).string = x.toString();
            } else {
              spriteNode.getChildByName("row").active = false;
              spriteNode.getChildByName("col").active = false;
            }
          }
        }

        /**
         * 锁住当前地图块的四周出口，boss战时调用
         */;
        _proto.lockCurMap = function lockCurMap(tiledMap) {
          var _mapHeight = tiledMap.getMapSize().height;
          var _mapWidth = tiledMap.getMapSize().width;
          for (var row = 0; row < _mapHeight; row++) {
            this.modifyMapPhysicsData(0, row, tiledMap, 0);
            this.modifyMapPhysicsData(_mapWidth - 1, row, tiledMap, 0);
          }
          for (var col = 0; col < _mapWidth; col++) {
            this.modifyMapPhysicsData(col, 0, tiledMap, 0);
            this.modifyMapPhysicsData(col, _mapHeight - 1, tiledMap, 0);
          }
        };
        return BattleBigMap;
      }());
      _class = BattleBigMap;
      BattleBigMap._instance = new _class();
      /**显示路径贴图 */
      BattleBigMap.SHOW_PATH_SPRITE = false;
      /**显示物理层贴图 */
      BattleBigMap.SHOW_PHYSICS_SPRITE = false;
      /**显示物理层行列 */
      BattleBigMap.SHOW_PHYSICS_ROW_COL = false;
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleCtrlView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './JoystickItem.ts', './BattleDefine.ts', './App.ts', './EventType.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Node, UITransform, View, Vec3, Component, JoystickItem, GameBattle, App, EventType;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      UITransform = module.UITransform;
      View = module.View;
      Vec3 = module.Vec3;
      Component = module.Component;
    }, function (module) {
      JoystickItem = module.JoystickItem;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      App = module.App;
    }, function (module) {
      EventType = module.EventType;
    }],
    execute: function () {
      var _dec, _dec2, _class, _class2, _descriptor;
      cclegacy._RF.push({}, "99a78qUZDhGeK+0gHNFqfdL", "BattleCtrlView", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleCtrlView = exports('BattleCtrlView', (_dec = ccclass("BattleCtrlView"), _dec2 = property({
        type: JoystickItem
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleCtrlView, _Component);
        function BattleCtrlView() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "joystickItem", _descriptor, _assertThisInitialized(_this));
          _this._onTouchNPC = false;
          return _this;
        }
        var _proto = BattleCtrlView.prototype;
        _proto.onLoad = function onLoad() {
          this.node.on(Node.EventType.TOUCH_START, this._onTouchStart, this);
          this.node.on(Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
          this.node.on(Node.EventType.TOUCH_END, this._onTouchEnd, this);
          this.node.on(Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
          var vJoyPos = new Array();
          var uitrans = this.node.getComponent(UITransform);
          var screenHeight = View.instance.getVisibleSize().height;
          var baseY = -(screenHeight / 2) + 350;
          vJoyPos[0] = uitrans.convertToWorldSpaceAR(new Vec3(0, baseY, 0));
          vJoyPos[1] = uitrans.convertToWorldSpaceAR(new Vec3(-200, baseY, 0));
          vJoyPos[2] = uitrans.convertToWorldSpaceAR(new Vec3(0, baseY, 0));
          vJoyPos[3] = uitrans.convertToWorldSpaceAR(new Vec3(200, baseY, 0));
          this.joystickItem.initJoyPos(vJoyPos);
          if (App.battleMgr.guanQiaType === GameBattle.GuanQiaType.JingJiChang) {
            this.node.active = false;
          }
        };
        _proto.onDestroy = function onDestroy() {
          this.node.off(Node.EventType.TOUCH_START, this._onTouchStart, this);
          this.node.off(Node.EventType.TOUCH_MOVE, this._onTouchMove, this);
          this.node.off(Node.EventType.TOUCH_END, this._onTouchEnd, this);
          this.node.off(Node.EventType.TOUCH_CANCEL, this._onTouchCancel, this);
        };
        _proto._onTouchStart = function _onTouchStart(event) {
          var uitrans = this.node.getComponent(UITransform);
          var uiPos = event.getUILocation();
          var worldPos = uitrans.convertToNodeSpaceAR(new Vec3(uiPos.x, uiPos.y));
          worldPos = uitrans.convertToWorldSpaceAR(worldPos);
          App.monitorMgr.dispatchEvent(EventType.joystick_touch_start);
          this.joystickItem.onStart(worldPos);
        };
        _proto._onTouchMove = function _onTouchMove(event) {
          if (this._onTouchNPC) {
            this._onTouchNPC = false;
            return;
          }
          var uitrans = this.node.getComponent(UITransform);
          var uiPos = event.getUILocation();
          var worldPos = uitrans.convertToNodeSpaceAR(new Vec3(uiPos.x, uiPos.y));
          worldPos = uitrans.convertToWorldSpaceAR(worldPos);
          this.joystickItem.onMove(event.getDelta(), worldPos);
        };
        _proto._onTouchEnd = function _onTouchEnd(event) {
          this.joystickItem.onEnd();
        };
        _proto._onTouchCancel = function _onTouchCancel(event) {
          this.joystickItem.onEnd();
        };
        return BattleCtrlView;
      }(Component), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "joystickItem", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleDebugNewView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './GameConfig.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Button, Node, Component, GameConfig;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Button = module.Button;
      Node = module.Node;
      Component = module.Component;
    }, function (module) {
      GameConfig = module.default;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10;
      cclegacy._RF.push({}, "a2ff5mu/BJPkZIQAefXQz9G", "BattleDebugNewView", undefined);

      // import { Monster } from '../../game_battle_b/monster/Monster';
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleDebugNewView = exports('BattleDebugNewView', (_dec = ccclass("BattleDebugNewView"), _dec2 = property({
        type: Button
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Button
      }), _dec5 = property({
        type: Button
      }), _dec6 = property({
        type: Button
      }), _dec7 = property({
        type: Button
      }), _dec8 = property({
        type: Button
      }), _dec9 = property({
        type: Button
      }), _dec10 = property({
        type: Button
      }), _dec11 = property({
        type: Button
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleDebugNewView, _Component);
        function BattleDebugNewView() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "gmBtn", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "debugPanel", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "allHitBtn", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroHitBtn", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "soldierHitBtn", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "monsterHitBtn", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "allBoxBtn", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroBoxBtn", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "soldierBoxBtn", _descriptor9, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "monsterBoxBtn", _descriptor10, _assertThisInitialized(_this));
          _this.flag = false;
          _this._lastBtnName = "";
          return _this;
        }
        var _proto = BattleDebugNewView.prototype;
        _proto.start = function start() {
          this.flag = false;
          this.debugPanel.active = false;
          {
            this.allHitBtn.interactable = GameConfig.DebugInfo.showBulletBox;
            this.heroHitBtn.interactable = GameConfig.DebugInfo.showHeroHit;
            this.soldierHitBtn.interactable = GameConfig.DebugInfo.showSoldierHit;
            this.monsterHitBtn.interactable = GameConfig.DebugInfo.showMonsterHit;
            this.allBoxBtn.interactable = GameConfig.DebugInfo.showAllBox;
            this.heroBoxBtn.interactable = GameConfig.DebugInfo.showHeroBox;
            this.soldierBoxBtn.interactable = GameConfig.DebugInfo.showSoldierBox;
            this.monsterBoxBtn.interactable = GameConfig.DebugInfo.showMonsterBox;
          }
          this._registerEvent();
        };
        _proto.onEnable = function onEnable() {
          if (GameConfig.DebugInfo.closeGm) {
            this.node.active = false;
          }
        };
        _proto.onDestroy = function onDestroy() {
          this._unregisterEvent();
        }

        /**
         * 注册事件
         */;
        _proto._registerEvent = function _registerEvent() {
          {
            this.gmBtn && this.gmBtn.node.on(Node.EventType.TOUCH_END, this.onGM, this);
            this.allHitBtn && this.allHitBtn.node.on(Node.EventType.TOUCH_END, this.onAllHit, this);
            this.heroHitBtn && this.heroHitBtn.node.on(Node.EventType.TOUCH_END, this.onHeroHit, this);
            this.soldierHitBtn && this.soldierHitBtn.node.on(Node.EventType.TOUCH_END, this.onSoldierHit, this);
            this.monsterHitBtn && this.monsterHitBtn.node.on(Node.EventType.TOUCH_END, this.onMonsterHit, this);
            this.allBoxBtn && this.allBoxBtn.node.on(Node.EventType.TOUCH_END, this.onAllBox, this);
            this.heroBoxBtn && this.heroBoxBtn.node.on(Node.EventType.TOUCH_END, this.onHeroBox, this);
            this.soldierBoxBtn && this.soldierBoxBtn.node.on(Node.EventType.TOUCH_END, this.onSoldierBox, this);
            this.monsterBoxBtn && this.monsterBoxBtn.node.on(Node.EventType.TOUCH_END, this.onMonsterBox, this);
          }
        }

        /**
         * 注销事件
         */;
        _proto._unregisterEvent = function _unregisterEvent() {
          if (this.gmBtn && this.gmBtn.node && this.gmBtn.node.isValid) {
            this.gmBtn && this.gmBtn.node.off(Node.EventType.TOUCH_END, this.onGM, this);
            this.allHitBtn && this.allHitBtn.node.off(Node.EventType.TOUCH_END, this.onAllHit, this);
            this.heroHitBtn && this.heroHitBtn.node.off(Node.EventType.TOUCH_END, this.onHeroHit, this);
            this.soldierHitBtn && this.soldierHitBtn.node.off(Node.EventType.TOUCH_END, this.onSoldierHit, this);
            this.monsterHitBtn && this.monsterHitBtn.node.off(Node.EventType.TOUCH_END, this.onMonsterHit, this);
            this.allBoxBtn && this.allBoxBtn.node.off(Node.EventType.TOUCH_END, this.onAllBox, this);
            this.heroBoxBtn && this.heroBoxBtn.node.off(Node.EventType.TOUCH_END, this.onHeroBox, this);
            this.soldierBoxBtn && this.soldierBoxBtn.node.off(Node.EventType.TOUCH_END, this.onSoldierBox, this);
            this.monsterBoxBtn && this.monsterBoxBtn.node.off(Node.EventType.TOUCH_END, this.onMonsterBox, this);
          }
        };
        _proto.onGM = function onGM() {
          this.flag = !this.flag;
          this.debugPanel.active = this.flag;
        };
        _proto.init = function init() {}

        // 点击事件实现
        ;

        _proto.onAllHit = function onAllHit() {
          GameConfig.DebugInfo.showBulletBox = !GameConfig.DebugInfo.showBulletBox;
          this.allHitBtn.interactable = GameConfig.DebugInfo.showBulletBox;
        };
        _proto.onHeroHit = function onHeroHit() {
          GameConfig.DebugInfo.showHeroHit = !GameConfig.DebugInfo.showHeroHit;
          this.heroHitBtn.interactable = GameConfig.DebugInfo.showHeroHit;
        };
        _proto.onSoldierHit = function onSoldierHit() {
          GameConfig.DebugInfo.showSoldierHit = !GameConfig.DebugInfo.showSoldierHit;
          this.soldierHitBtn.interactable = GameConfig.DebugInfo.showSoldierHit;
        };
        _proto.onMonsterHit = function onMonsterHit() {
          GameConfig.DebugInfo.showMonsterHit = !GameConfig.DebugInfo.showMonsterHit;
          this.monsterHitBtn.interactable = GameConfig.DebugInfo.showMonsterHit;
        };
        _proto.onAllBox = function onAllBox() {
          GameConfig.DebugInfo.showAllBox = !GameConfig.DebugInfo.showAllBox;
          this.allBoxBtn.interactable = GameConfig.DebugInfo.showAllBox;
        };
        _proto.onHeroBox = function onHeroBox() {
          GameConfig.DebugInfo.showHeroBox = !GameConfig.DebugInfo.showHeroBox;
          this.heroBoxBtn.interactable = GameConfig.DebugInfo.showHeroBox;
        };
        _proto.onSoldierBox = function onSoldierBox() {
          GameConfig.DebugInfo.showSoldierBox = !GameConfig.DebugInfo.showSoldierBox;
          this.soldierBoxBtn.interactable = GameConfig.DebugInfo.showSoldierBox;
        };
        _proto.onMonsterBox = function onMonsterBox() {
          GameConfig.DebugInfo.showMonsterBox = !GameConfig.DebugInfo.showMonsterBox;
          this.monsterBoxBtn.interactable = GameConfig.DebugInfo.showMonsterBox;
        };
        return BattleDebugNewView;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "gmBtn", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "debugPanel", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "allHitBtn", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "heroHitBtn", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "soldierHitBtn", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "monsterHitBtn", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "allBoxBtn", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "heroBoxBtn", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "soldierBoxBtn", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "monsterBoxBtn", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleDebugView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleDefine.ts', './MonitorType.ts', './ModuleDef.ts', './UIMgr.ts', './DBRecord.ts', './GameConfig.ts', './Item_BattleMap.ts', './uiGameLoading.ts', './BattleMainView.ts', './Prompt.ts', './App.ts', './BattleProprMgr.ts', './BattleUtil.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createForOfIteratorHelperLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, EditBox, input, Input, KeyCode, Label, Vec3, find, Camera, tween, v3, Component, GameBattle, MonitorType, ModuleDef, UIMgr, LayerType, DBRecord, GameConfig, Item_BattleMap, uiGameLoading, BattleMainView, Prompt, App, BattlePropertyName, BattleUtil;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      EditBox = module.EditBox;
      input = module.input;
      Input = module.Input;
      KeyCode = module.KeyCode;
      Label = module.Label;
      Vec3 = module.Vec3;
      find = module.find;
      Camera = module.Camera;
      tween = module.tween;
      v3 = module.v3;
      Component = module.Component;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      Item_BattleMap = module.Item_BattleMap;
    }, function (module) {
      uiGameLoading = module.uiGameLoading;
    }, function (module) {
      BattleMainView = module.BattleMainView;
    }, function (module) {
      Prompt = module.Prompt;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      var _dec, _dec2, _class, _class2, _descriptor;
      cclegacy._RF.push({}, "7778flRmYpPGb3VlN1qHQdE", "BattleDebugView", undefined);

      // import { Monster } from '../../game_battle_b/monster/Monster';
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleDebugView = exports('BattleDebugView', (_dec = ccclass("BattleDebugView"), _dec2 = property([EditBox]), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleDebugView, _Component);
        function BattleDebugView() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "eb", _descriptor, _assertThisInitialized(_this));
          _this.flag = false;
          _this._lastBtnName = "";
          return _this;
        }
        var _proto = BattleDebugView.prototype;
        _proto.start = function start() {
          this._registerEvent();
          this._refreshHP();
          this._refreshMP();
          // const player = App.battleMgr.roleCtrl.player;
          // player.view.setCompleteHandler((trace:sp.spine.TrackEntry)=>{
          //     console.log('动画完成', trace, trace.animation.name)
          //     if(trace.animation.name === 'Attack'){
          //         player.state.exitType(GameBattle.ActionState.Attack)
          //         console.log('xxxxxxxxxxxxxxxxxxx')
          //     }
          // })
        };

        _proto.onEnable = function onEnable() {
          if (GameConfig.DebugInfo.closeGm) {
            this.node.active = false;
          }
          var pop = this.node.getChildByName("pop");
          pop.active = false;
          this._lastBtnName = "";
          var buttonBar = this.node.getChildByName("buttonBar");
          buttonBar.active = false;
          var bg = this.node.getChildByName("bg");
          bg.active = buttonBar.active;
          var panelTab = this.node.getChildByName("panelTab");
          panelTab.active = false;
        };
        _proto.onDestroy = function onDestroy() {
          this._unregisterEvent();
        }

        /**
         * 注册事件
         */;
        _proto._registerEvent = function _registerEvent() {
          App.monitorMgr.addEventListener(MonitorType.battle_player_update_hp, this._refreshHP, this);
          App.monitorMgr.addEventListener(MonitorType.battle_player_update_nengliang, this._refreshMP, this);
          {
            input.on(Input.EventType.KEY_DOWN, function (eve) {
              switch (eve.keyCode) {
                case KeyCode.F1:
                  // UIMgr.inst.open(uiKuangChall, LayerType.panel, undefined, []);
                  break;
                case KeyCode.F2:
                  UIMgr.inst.closeAllPanel(["uiMain"]);
                  break;
                case KeyCode.F3:
                  // UIMgr.inst.openOnce(uiResult11, undefined, undefined, [{}]);
                  break;
              }
            }, this);
          }
        }

        /**
         * 注销事件
         */;
        _proto._unregisterEvent = function _unregisterEvent() {
          App.monitorMgr.removeEventListener(MonitorType.battle_player_update_hp, this._refreshHP, this);
          App.monitorMgr.removeEventListener(MonitorType.battle_player_update_nengliang, this._refreshMP, this);
        };
        _proto.init = function init() {};
        _proto.onSelectTab = function onSelectTab(event) {
          this.selectTab(event.target.name);
        };
        _proto.selectTab = function selectTab(tabName) {
          //console.log(">>>>>>>>>>>>>>>>>  on tab:",tabName);
          var list = this.node.getChildByName("buttonBar").children;
          for (var index = 0; index < list.length; index++) {
            var element = list[index];
            element.active = element.name === tabName;
          }
        };
        _proto._refreshHP = function _refreshHP() {
          var player = App.battleMgr.roleCtrl.player;
          if (!player) {
            return;
          }
          var roleVO = player.roleVO;
          var lab_hp = this.node.getChildByPath("lab_hp").getComponent(Label);
          // lab_hp.string = `${roleVO.curHP}/${roleVO.hp}`;
          lab_hp.string = roleVO.curHP + "/" + roleVO.getRoleAttr(BattlePropertyName.shengming);
        };
        _proto._refreshMP = function _refreshMP() {
          var player = App.battleMgr.roleCtrl.player;
          if (!player) {
            return;
          }
          var roleVO = player.roleVO;
          var lab_mp = this.node.getChildByPath("lab_mp").getComponent(Label);
          // lab_mp.string = `${roleVO.curNengLiiang}/${roleVO.hp}`;
          lab_mp.string = roleVO.curNengLiiang + "/" + roleVO.getRoleAttr(BattlePropertyName.nengliang);
        };
        _proto.onBtnIdle = function onBtnIdle() {
          var player = App.battleMgr.roleCtrl.player;
          if (!player) {
            return;
          }
          // player.view.spine_leftHand.skeleton.setAnimation(0, 'Attack', false)
          // player.view.play("Idle", true);;
          // App.monitorMgr.dispatchEvent(MonitorType.battle_monster_die, 10000000);
          App.battleMgr.roleCtrl.recoveryAllMonster();
          var pos = [1330.40437, 1359.815555];
          var comp = App.battleMgr.roleCtrl.createMonster({
            id: 11006,
            position: new Vec3(pos[0], pos[1])
          });

          // App.chatMgr.cs_chat_gm_2001(`add_item 509022 1 1 `);
          // App.chatMgr.cs_chat_gm_2001(`add_item 504026 1 1 `);
          // App.chatMgr.cs_chat_gm_2001(`add_item 503022 1 1 `);
        };

        _proto.onBtnMove = function onBtnMove() {
          var player = App.battleMgr.roleCtrl.player;
          if (!player) {
            return;
          }
          // player.view.play("Move", true);;

          /**
           * 
           * 掉落装备测试
              let node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemFallingProp)
              let com = node.getComponent(ItemFallingProp)
              com.init(1,6, player.node.worldPosition.clone().add3f(200,0,0))
              com.flyTo(player.node)
           * 
          */

          /**
           *  经验飞行测试
              let parent = this.node.parent.getChildByPath('miniMap/imgBattleProgressBg/imgBattleProgress')
              let node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemExpMotionSteak)
                  let pos = player.node.worldPosition.clone().add3f(200,0,0)
              // 获取战斗相机
              const playerCamera = App.battleMgr.battleMainViewCtrl.playerCamera
              // 将世界坐标转换为屏幕坐标
              const screenPosition = playerCamera.camera.worldToScreen(pos);
              let uiCamera = find('Canvas/Camera').getComponent(Camera)
              // 将屏幕坐标转换为 UI 相机下的坐标
              const uiPosition = uiCamera.screenToWorld(screenPosition);
              
              node.parent = parent
              node.setWorldPosition(uiPosition)
                  console.log('player.node pos',player.node.worldPosition.x, player.node.worldPosition.y, player.node.x, player.node.y)
                  */
          // EffectManager.flyTo(player.node, node, 0.4)
          // node.setWorldPosition(player.node.worldPosition.clone())
        };

        _proto.onBtnAttack = function onBtnAttack() {
          var player = App.battleMgr.roleCtrl.player;
          // player.view.play("Attack", true);;
          player.state.animationType = GameBattle.ActionState.Attack;
          console.log("onBtnAttack", player.view);
        };
        _proto.onBtnAddAttack = function onBtnAddAttack() {
          var player = App.battleMgr.roleCtrl.player;
          player.view.addAnimation("Attack", false);
        };
        _proto.onBtnAddMove = function onBtnAddMove() {
          var player = App.battleMgr.roleCtrl.player;
          player.view.addAnimation("Move", true);
        };
        _proto.onBtnClearAllMonster = function onBtnClearAllMonster() {
          var player = App.battleMgr.roleCtrl.player;
          App.battleMgr.roleCtrl.recoveryAllMonster();
        };
        _proto.onBtnAddMonster = function onBtnAddMonster() {
          var cfg = DBRecord.fetchId("ShuoMingQuanJu", 32);

          //获取palyer坐标
          var player = App.battleMgr.roleCtrl.player;
          var playerLocalPos = player.node.position;
          var comp = App.battleMgr.roleCtrl.createMonster({
            id: 999999,
            position: playerLocalPos
          });

          // const comp = App.battleMgr.roleCtrl.createSummon({
          //     id: 1000000,
          //     position: playerLocalPos,
          //     masterId:player.uid
          // });
        };

        _proto.onBtnCloseAtk = function onBtnCloseAtk() {
          var player = App.battleMgr.roleCtrl.player;
          player.openAtk = false;
        };
        _proto.onBtnOpenAtk = function onBtnOpenAtk() {
          var player = App.battleMgr.roleCtrl.player;
          player.openAtk = true;
        };
        _proto.onBtnXsyd = function onBtnXsyd() {
          // Utils.findManager('_xinShouManager').skipStory();
        };
        _proto.onBtnGmDmg = function onBtnGmDmg() {
          // App.mixMgr.setGmDmg(10000000000000);
        };
        _proto.onBtnDqsx = function onBtnDqsx() {
          var player = App.battleMgr.roleCtrl.player;
          // if (player && player.roleVO) UIMgr.inst.openOnce(gmRoleAttr, null, null, [player.roleVO.getFullAttr()]);
        };

        _proto.onBtnGmRoleSkill = function onBtnGmRoleSkill() {
          var player = App.battleMgr.roleCtrl.player;
          // if (player && player.roleVO) UIMgr.inst.openOnce(uiGmRoleSkill, null, null);
        };

        _proto.onBtnOpenAllGuanqia = function onBtnOpenAllGuanqia() {
          App.battleMgr.curGuanQiaId = 15050;
        }

        /**玩家只受一点伤害 */;
        _proto.onBtnplayerDmgReduce = function onBtnplayerDmgReduce() {
          GameConfig.DebugInfo.playerDmgReduce = !GameConfig.DebugInfo.playerDmgReduce;
          Prompt.popTip("玩家只受一点伤害:" + GameConfig.DebugInfo.playerDmgReduce);
        }

        /**怪物只受一点伤害 */;
        _proto.onBtnMonsteDmgReduce = function onBtnMonsteDmgReduce() {
          GameConfig.DebugInfo.monsterDmgReduce = !GameConfig.DebugInfo.monsterDmgReduce;
          Prompt.popTip("怪物只受一点伤害:" + GameConfig.DebugInfo.monsterDmgReduce);
        }

        /**玩家加buff飘字 */;
        _proto.onBtnShowPlayerAddBuff = function onBtnShowPlayerAddBuff() {
          GameConfig.DebugInfo.showPlayerAddBuffTips = !GameConfig.DebugInfo.showPlayerAddBuffTips;
          Prompt.resetTipsCount();
          Prompt.popTip("玩家加buff飘字:" + GameConfig.DebugInfo.showPlayerAddBuffTips);
        }

        /**战斗是否创建怪物 */;
        _proto.onBtnNoMonster = function onBtnNoMonster() {
          GameConfig.DebugInfo.noMonster = !GameConfig.DebugInfo.noMonster;
          Prompt.popTip("战斗中不创建怪物:" + GameConfig.DebugInfo.noMonster);
        }

        /**
         * 事件消息： 战斗 —— 主角 —— 更新血量
         */;
        _proto._onEventBattlePlayerUpdateHP = function _onEventBattlePlayerUpdateHP() {
          this._refreshHP();
        }

        // onPlayerInfoDebug(data: m_proto.SC_10021): void {

        //     //更新玩家信息
        //     console.log(`获取玩家info10021`);
        //     console.log(`获取玩家info10021：${JSON.stringify([data])}`);

        //     this.dianfengDengjiNumber = data.peak_level;
        //     this._dianfengDengji.string = data.peak_level.toString();

        //     // this._touruDianshu.string = data.peak_level.toString();
        //     this._shengYUDianshu.string = Math.abs(this.dianfengDengjiNumber - this.touruNumber).toString();
        // }
        ;

        _proto.onDianFengTouruDebug = function onDianFengTouruDebug(data) {
          //更新玩家信息
          console.log("\u5DC5\u5CF0\u5DF2\u6295\u516520021");
          console.log("\u5DC5\u5CF0\u5DF2\u6295\u516520021\uFF1A" + JSON.stringify([data]));
          this.scheduleOnce(function () {
            // UIMgr.inst.open(Ui_peakLevel, LayerType.panel, Layout_uiPeakLevel, [data]);
          }, 2);
        };
        _proto.onBtnLvMax = function onBtnLvMax() {
          //测试增加经验
          App.chatMgr.cs_chat_gm_2001("add_item 3 14000000");
        }

        /**
         * 事件消息： 战斗 —— 主角 —— 更新能量
         */;
        _proto._onEventBattlePlayerUpdateNengLiang = function _onEventBattlePlayerUpdateNengLiang() {
          var player = App.battleMgr.roleCtrl.player;
          if (!player) {
            return;
          }
          var roleVO = player.roleVO;
          var lab_mp = this.node.getChildByPath("lab_mp").getComponent(Label);
          // lab_mp.string = `${roleVO.curNengLiiang}/${roleVO.nengLiang}`;
          lab_mp.string = roleVO.curNengLiiang + "/" + roleVO.getRoleAttr(BattlePropertyName.nengliang);
        };
        _proto.onBtnShowBtns = function onBtnShowBtns() {
          // let play = App.battleMgr.roleCtrl.player
          // play.view.addAnimation('Move', true)
          // play.view.addAnimation('Skill', false)
          // return

          var buttonBar = this.node.getChildByName("buttonBar");
          buttonBar.active = !buttonBar.active;
          var bg = this.node.getChildByName("bg");
          bg.active = buttonBar.active;
          var pop = this.node.getChildByName("pop");
          pop.active = false;
          var panelTab = this.node.getChildByName("panelTab");
          panelTab.active = !panelTab.active;
          if (panelTab.active) {
            this.selectTab("battle");
          }
        };
        _proto.onBtnShowMonsterBox = function onBtnShowMonsterBox() {
          GameConfig.DebugInfo.showMonsterBox = true;
          console.log("onBtnShowMonsterBox");
        };
        _proto.onBtnShowBulletBox = function onBtnShowBulletBox() {
          GameConfig.DebugInfo.showBulletBox = true;
        };
        _proto.onBtnQuick = function onBtnQuick() {
          // Utils.guideManager.finishAll();
          App.chatMgr.cs_chat_gm_2001("add_item 1 1000000");
          App.chatMgr.cs_chat_gm_2001("add_item 2 1000000");
          App.chatMgr.cs_chat_gm_2001("add_item 6 1000000");
          App.chatMgr.cs_chat_gm_2001("tg_zdgk 21001");
        };
        _proto.onBtnShowPop = function onBtnShowPop(event) {
          var name = event.target.name;
          var pop = this.node.getChildByName("pop");
          pop.active = true;
          console.log("onBtnShowPop", event);
          if (name === "btn_addItem") {
            for (var i = 0; i < this.eb.length; i++) {
              this.eb[i].node.active = true;
              this.eb[i].placeholder = ["请输入道具ID", "请输入道具数量", "请输入道具品质"][i];
            }
          } else if (name === "btn_subItem") {
            for (var _i = 0; _i < this.eb.length; _i++) {
              this.eb[_i].node.active = true;
              this.eb[_i].placeholder = ["请输入道具ID", "请输入道具数量", "请输入道具品质"][_i];
            }
          } else if (name === "btn_pause") {
            App.battleMgr.setPause(true);
          } else if (name === "btn_resume") {
            App.battleMgr.setPause(false);
            for (var _i2 = 1; _i2 < this.eb.length; _i2++) {
              this.eb[_i2].node.active = false;
              this.eb[_i2].placeholder = ["请输入道具ID", "请输入道具数量", "请输入道具品质"][_i2];
            }
          } else if (name === "btn_addSkill") {
            for (var _i3 = 1; _i3 < this.eb.length; _i3++) {
              this.eb[_i3].node.active = false;
            }
            this.eb[0].node.active = true;
            this.eb[0].placeholder = "请输入技能ID,多个技能用,分隔";
          } else if (name === "btn_test_buff") {
            for (var _i4 = 1; _i4 < this.eb.length; _i4++) {
              this.eb[_i4].node.active = false;
            }
            this.eb[0].node.active = true;
            this.eb[0].placeholder = "请输入buffID,多个buff用,分隔";
            // let player: Player = App.battleMgr.roleCtrl.player;
            // let monster = player.atkSkill.getTarget();
            // let effect = new BuffEffect(99999990, player._buffBox, 0, monster);
            // effect.trigger();
            // let buttonBar = this.node.getChildByName('buttonBar');
            // buttonBar.active = false;
            // let bg = this.node.getChildByName('bg');
            // bg.active = false;
            // let pop = this.node.getChildByName('pop');
            // pop.active = false;
          } else if (name === "btn_test") {
            var parent = this.node.parent.getChildByPath("miniMap/imgBattleProgressBg/imgBattleProgress");
            var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemExpMotionSteak);
            var player = App.battleMgr.roleCtrl.player;
            var pos = player.node.worldPosition.clone().add3f(200, 0, 0);
            // 获取战斗相机
            var playerCamera = App.battleMgr.battleMainViewCtrl.playerCamera;
            // 将世界坐标转换为屏幕坐标
            var screenPosition = playerCamera.camera.worldToScreen(pos);
            var uiCamera = find("Canvas/Camera").getComponent(Camera);
            // 将屏幕坐标转换为 UI 相机下的坐标
            var uiPosition = uiCamera.screenToWorld(screenPosition);
            node.parent = parent;
            node.setWorldPosition(uiPosition);
            tween(node).by(5, {
              position: v3(200, 200, 1)
            }).start();
          } else if (name === "btn_showBoss") {
            App.battleMgr.battleMainViewCtrl.showBoss();
            pop.active = false;
          } else if (name === "btn_gm") {
            for (var _i5 = 0; _i5 < this.eb.length; _i5++) {
              this.eb[_i5].string = "";
              this.eb[_i5].node.active = false;
            }
            this.eb[0].node.active = true;
            this.eb[0].placeholder = "请输入道具GM命令";
          } else if (name === "btn_guide") {
            for (var _i6 = 0; _i6 < this.eb.length; _i6++) {
              this.eb[_i6].string = "";
              this.eb[_i6].node.active = false;
            }
            this.eb[0].node.active = true;
            this.eb[0].placeholder = "请输入引导组Id";
          } else if (name === "btn_addMonster") {
            for (var _i7 = 0; _i7 < this.eb.length; _i7++) {
              this.eb[_i7].node.active = true;
              this.eb[_i7].placeholder = ["请输入怪物ID", "请输入相对玩家的X坐标", "请输入相对玩家的Y坐标"][_i7];
            }
            //App.battleMgr.roleCtrl.recoveryAllMonster();
          } else if (name === "btn_send") {
            if (this._lastBtnName === "btn_addMonster") {
              //获取palyer坐标
              var _player = App.battleMgr.roleCtrl.player;
              var playerLocalPos = _player.node.position;
              var _cmd = "" + this.eb[0].string;
              var data = _cmd.split(",").map(function (part) {
                return Number(part.trim());
              });
              var monsterId = data[0],
                buffId = data[1],
                flag = data[2];
              var offsetX = this.eb[1].string ? Number(this.eb[1].string) : 0;
              var offsetY = this.eb[2].string ? Number(this.eb[2].string) : 0;
              var x = playerLocalPos.x + offsetX;
              var y = playerLocalPos.y + offsetY;
              var monster = App.battleMgr.roleCtrl.createMonster({
                id: monsterId,
                // position: new Vec3(pos[0], pos[1]),
                position: v3(x, y)
              });
              if (buffId) {
                if (flag) {
                  monster._buffBox.addBuff(buffId, _player);
                } else {
                  monster._buffBox.addBuff(buffId, monster);
                }
              }
              return;
            } else if (this._lastBtnName === "btn_addSkill") {
              GameConfig.DebugInfo.debugSkillList = [];
              var _cmd2 = "" + this.eb[0].string;
              var _data = _cmd2.split(",").map(function (part) {
                return part.trim();
              });
              for (var _iterator = _createForOfIteratorHelperLoose(_data), _step; !(_step = _iterator()).done;) {
                var id = _step.value;
                GameConfig.DebugInfo.debugSkillList.push(Number(id));
              }
              return;
            } else if (this._lastBtnName === "btn_test_buff") {
              var _cmd3 = "" + this.eb[0].string;
              var _data2 = _cmd3.split(",").map(function (part) {
                return part.trim();
              });
              var _player2 = App.battleMgr.roleCtrl.player;
              for (var _iterator2 = _createForOfIteratorHelperLoose(_data2), _step2; !(_step2 = _iterator2()).done;) {
                var _id = _step2.value;
                _player2._buffBox.addBuff(Number(_id), _player2);

                // player.summonBuff[id] = [Number(id)];
              }

              return;
            } else if (this._lastBtnName === "btn_test_buff_monster") {
              var _cmd4 = "" + this.eb[0].string;
              var _data3 = _cmd4.split(",").map(function (part) {
                return part.trim();
              });
              var _player3 = App.battleMgr.roleCtrl.player;
              for (var _iterator3 = _createForOfIteratorHelperLoose(_data3), _step3; !(_step3 = _iterator3()).done;) {
                var _id2 = _step3.value;
                _player3._buffBox.addBuff(Number(_id2), _player3);

                // player.summonBuff[id] = [Number(id)];
              }

              return;
            }
            var cmd = "add_item " + this.eb[0].string + " " + this.eb[1].string + " " + this.eb[2].string;
            if (this._lastBtnName === "btn_gm") cmd = "" + this.eb[0].string;
            if (this._lastBtnName === "btn_subItem") cmd = "sub_item " + this.eb[0].string + " " + this.eb[1].string;
            if (this._lastBtnName === "btn_guide") ;else {
              App.chatMgr.cs_chat_gm_2001(cmd);
            }
          }
          if (name !== "btn_send") {
            this._lastBtnName = name;
          }
        };
        _proto.onBtnChangeProp = function onBtnChangeProp() {
          var _player$roleVO$addLoc;
          console.log("onBtnChangeProp");
          var player = App.battleMgr.roleCtrl.player;
          if (player === undefined || player.roleVO === undefined) {
            return;
          }
          player.roleVO.addLockAttr(BattlePropertyName.yisu, (_player$roleVO$addLoc = {}, _player$roleVO$addLoc[BattlePropertyName.yisu] = 500, _player$roleVO$addLoc));
        };
        _proto.onBtnReduceProp = function onBtnReduceProp() {
          console.log("onBtnReduceProp");
          var player = App.battleMgr.roleCtrl.player;
          if (player === undefined || player.roleVO === undefined) {
            return;
          }
          player.roleVO.delLockAttr(BattlePropertyName.yisu);
        }

        /**
         * 结束当前boss aciton
         */;
        _proto.onBtnEndBossAction = function onBtnEndBossAction() {
          var enMAp = App.battleMgr.roleCtrl.entityMap;
          var _map = new Map(enMAp.entries());
          for (var _iterator4 = _createForOfIteratorHelperLoose(_map), _step4; !(_step4 = _iterator4()).done;) {
            var _step4$value = _step4.value,
              k = _step4$value[0],
              v = _step4$value[1];
            if (v.type === GameBattle.RoleType.Monster) {
              var monsterRole = v;
              if (monsterRole.roleVO.quality === GameBattle.MonsterQuality.Boss) {
                monsterRole.curSkill.endAction();
                // monsterRole.roleVO.curHP = 0
                // monsterRole.state.type = GameBattle.ActionState.Dead
                // App.battleMgr.skillCtrl.getSkills(monsterRole.uid);
                // monsterRole.curSkill.end()
                // monsterRole._monsterAI.pause = false
                // const skills = App.battleMgr.skillCtrl.getSkills(monsterRole.uid);
                // let skill: SkillVO;
                // for (const it of skills) {
                //     it.CD = 100000000
                //     it.curCD = 10000000
                // }
              }
            }
          }
        };

        _proto.onBtnDrawGrid = function onBtnDrawGrid() {
          console.log("onBtnDrawGrid");
          GameConfig.DebugInfo.drawCollisionGrid = !GameConfig.DebugInfo.drawCollisionGrid;
        };
        _proto.onBtnttttttttttttttttttttttttttttttttt = /*#__PURE__*/function () {
          var _onBtnttttttttttttttttttttttttttttttttt = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            var guanQiaId, cfg, diMao, ui;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  // UIMgr.inst.open(uiTimeActivitySign, LayerType.panel);
                  // UIMgr.inst.open(Ui_zhigoulibao, LayerType.panel, Layout_zhigoulibao, [{ openType: OpenType.MainUi }])
                  guanQiaId = 17001;
                  App.battleMgr._isInBattle = true;
                  App.battleMgr.challengeGuanQiaId = guanQiaId;
                  cfg = DBRecord.fetchId("GuanQia", guanQiaId);
                  diMao = BattleUtil.getValueByProbability(cfg.random_map);
                  App.battleMgr.diMao = diMao;
                  App.battleMgr.fallingPropCtrl.initFallingByGuanQiaId(App.battleMgr.challengeGuanQiaId, null);
                  App.battleMgr.battleNpcCtrl.setZhuangBeiJiaData([], []);
                  _context.next = 10;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 10:
                  ui = _context.sent;
                  ui.setCloseByHand(true);
                  _context.next = 14;
                  return Item_BattleMap.loadMap(diMao, ui.onProgress.bind(ui));
                case 14:
                  UIMgr.inst.openOnce(BattleMainView, LayerType.main, Layout_uiCommonGet, [guanQiaId], function () {
                    ui.onClose();
                    UIMgr.inst.closeAllPanel(["BattleMainView"]);
                  });
                case 15:
                case "end":
                  return _context.stop();
              }
            }, _callee);
          }));
          function onBtnttttttttttttttttttttttttttttttttt() {
            return _onBtnttttttttttttttttttttttttttttttttt.apply(this, arguments);
          }
          return onBtnttttttttttttttttttttttttttttttttt;
        }();
        _proto.onBtn22222222222222222222222 = function onBtn22222222222222222222222() {
          // UIMgr.inst.asyncOpen(uiDoubleCard, LayerType.panel);
          // UIMgr.inst.asyncOpen(Ui_uiPromptWarn, LayerType.panel, Layout_uiPromptWarn);
          // UIMgr.inst.asyncOpen(uiFashionCard, LayerType.panel);
          // UIMgr.inst.asyncOpen(uiPetCard, LayerType.panel);
          // UIMgr.inst.asyncOpen(uiJingJiChang, LayerType.panel);
          // App.battleMgr.roleCtrl.createEnemy({
          //     id: 10000,
          //     job: 1,
          //     parent: App.battleMgr.battleMainViewCtrl.roleLayer,
          //     position: App.battleMgr.roleCtrl.player.node.worldPosition
          // });
          this.node.active = false;
          GameConfig.DebugInfo.closeGm = true;
          // UIMgr.inst.openOnce(uiPaTaRank, LayerType.panel, Layout_uiPaTaRank);
          // UIMgr.inst.openOnce(uiVictoryPaTa, LayerType.panel, null);
          // UIMgr.inst.openOnce(uiPaTaBuffSelect, LayerType.panel, Layout_uiPaTaBuffSelect);
        };

        _proto.onBtnTemp0 = function onBtnTemp0() {
          // UIMgr.inst.openOnce(uiFuShiCard, LayerType.panel);
          //  UIMgr.inst.open(uiGouYu)
        };
        _proto.onBtnTempFuShi = function onBtnTempFuShi() {
          // UIMgr.inst.openOnce(uiCZSC, LayerType.panel);
        };
        return BattleDebugView;
      }(Component), _descriptor = _applyDecoratedDescriptor(_class2.prototype, "eb", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleDefine.ts", ['cc'], function (exports) {
  var cclegacy, v3;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
      v3 = module.v3;
    }],
    execute: function () {
      exports('GameBattle', void 0);
      cclegacy._RF.push({}, "40902NyHc9L7qf2cOIUx023", "BattleDefine", undefined);
      /** 游戏战斗模块 */
      var GameBattle;
      (function (_GameBattle, _GameBattle$BattleSco, _GameBattle$RolePrefa, _GameBattle$BulletPre) {
        var BattleTweenTag = _GameBattle.BattleTweenTag = 99999999999;

        // 战斗配置

        // 奖励配置
        /**
         * 敌我关系
         */
        var BattleSide = /*#__PURE__*/function (BattleSide) {
          BattleSide[BattleSide["Player"] = 0] = "Player";
          BattleSide[BattleSide["Enemy"] = 1] = "Enemy";
          return BattleSide;
        }({});
        _GameBattle.BattleSide = BattleSide;
        var RoleType = /*#__PURE__*/function (RoleType) {
          RoleType[RoleType["None"] = 0] = "None";
          RoleType[RoleType["Hero"] = 1] = "Hero";
          RoleType[RoleType["Soldier"] = 2] = "Soldier";
          RoleType[RoleType["Monster"] = 3] = "Monster";
          return RoleType;
        }({});
        _GameBattle.RoleType = RoleType;
        var SoldierType = /*#__PURE__*/function (SoldierType) {
          SoldierType[SoldierType["None"] = 0] = "None";
          SoldierType[SoldierType["Infantry"] = 1] = "Infantry";
          SoldierType[SoldierType["Archer"] = 2] = "Archer";
          SoldierType[SoldierType["Cavalry"] = 3] = "Cavalry";
          SoldierType[SoldierType["Mage"] = 4] = "Mage";
          SoldierType[SoldierType["Shield"] = 5] = "Shield";
          return SoldierType;
        }({});
        _GameBattle.SoldierType = SoldierType;
        var LanePosition = /*#__PURE__*/function (LanePosition) {
          LanePosition[LanePosition["None"] = 0] = "None";
          LanePosition[LanePosition["Left"] = 1] = "Left";
          LanePosition[LanePosition["Middle"] = 2] = "Middle";
          LanePosition[LanePosition["Right"] = 3] = "Right";
          return LanePosition;
        }({});
        _GameBattle.LanePosition = LanePosition;
        var HeroPoints = _GameBattle.HeroPoints = new Map([[GameBattle.LanePosition.Left, v3(187, 300, 0)], [GameBattle.LanePosition.Middle, v3(360, 300, 0)], [GameBattle.LanePosition.Right, v3(533, 300, 0)]]);
        var BattleScope = _GameBattle.BattleScope = (_GameBattle$BattleSco = {}, _GameBattle$BattleSco["min_x"] = 100, _GameBattle$BattleSco["big_x"] = 620, _GameBattle$BattleSco);
        var BattleState = /*#__PURE__*/function (BattleState) {
          BattleState[BattleState["None"] = 0] = "None";
          BattleState[BattleState["Preparing"] = 1] = "Preparing";
          BattleState[BattleState["Battling"] = 2] = "Battling";
          BattleState[BattleState["Ended"] = 3] = "Ended";
          return BattleState;
        }({});
        _GameBattle.BattleState = BattleState;
        var BattleResult = /*#__PURE__*/function (BattleResult) {
          BattleResult[BattleResult["None"] = 0] = "None";
          BattleResult[BattleResult["Victory"] = 1] = "Victory";
          BattleResult[BattleResult["Defeat"] = 2] = "Defeat";
          BattleResult[BattleResult["Draw"] = 3] = "Draw";
          return BattleResult;
        }({});
        _GameBattle.BattleResult = BattleResult;
        var GuanQiaType = /*#__PURE__*/function (GuanQiaType) {
          GuanQiaType[GuanQiaType["None"] = 0] = "None";
          GuanQiaType[GuanQiaType["MainLine"] = 1] = "MainLine";
          GuanQiaType[GuanQiaType["Elite"] = 2] = "Elite";
          GuanQiaType[GuanQiaType["Dungeon"] = 3] = "Dungeon";
          GuanQiaType[GuanQiaType["JingJiChang"] = 4] = "JingJiChang";
          return GuanQiaType;
        }({});
        _GameBattle.GuanQiaType = GuanQiaType;
        var BulletType = /*#__PURE__*/function (BulletType) {
          BulletType[BulletType["None"] = 0] = "None";
          BulletType[BulletType["Remote"] = 1] = "Remote";
          BulletType[BulletType["Melee"] = 2] = "Melee";
          BulletType[BulletType["Follow"] = 3] = "Follow";
          BulletType[BulletType["NoAngle"] = 4] = "NoAngle";
          BulletType[BulletType["ShiZhu"] = 5] = "ShiZhu";
          BulletType[BulletType["LockNoSame"] = 6] = "LockNoSame";
          BulletType[BulletType["Circular"] = 7] = "Circular";
          BulletType[BulletType["Adsorption"] = 8] = "Adsorption";
          BulletType[BulletType["LockNoSame2"] = 10] = "LockNoSame2";
          BulletType[BulletType["LockNoSame3"] = 11] = "LockNoSame3";
          BulletType[BulletType["Affected"] = 12] = "Affected";
          return BulletType;
        }({});
        _GameBattle.BulletType = BulletType;
        var BulletMoveType = /*#__PURE__*/function (BulletMoveType) {
          BulletMoveType[BulletMoveType["None"] = 0] = "None";
          BulletMoveType[BulletMoveType["Line"] = 1] = "Line";
          BulletMoveType[BulletMoveType["Follow"] = 2] = "Follow";
          BulletMoveType[BulletMoveType["Bezier"] = 3] = "Bezier";
          BulletMoveType[BulletMoveType["Round"] = 4] = "Round";
          BulletMoveType[BulletMoveType["FollowOwner"] = 5] = "FollowOwner";
          BulletMoveType[BulletMoveType["FollowWeapon"] = 6] = "FollowWeapon";
          BulletMoveType[BulletMoveType["Arrow"] = 7] = "Arrow";
          BulletMoveType[BulletMoveType["ShiBi"] = 8] = "ShiBi";
          BulletMoveType[BulletMoveType["InCreator"] = 9] = "InCreator";
          BulletMoveType[BulletMoveType["TanTiao"] = 10] = "TanTiao";
          BulletMoveType[BulletMoveType["RoundBullet"] = 11] = "RoundBullet";
          BulletMoveType[BulletMoveType["Lock"] = 12] = "Lock";
          BulletMoveType[BulletMoveType["onTarget"] = 13] = "onTarget";
          BulletMoveType[BulletMoveType["yanZHan"] = 14] = "yanZHan";
          BulletMoveType[BulletMoveType["Warning"] = 15] = "Warning";
          BulletMoveType[BulletMoveType["AngularFollow"] = 16] = "AngularFollow";
          BulletMoveType[BulletMoveType["HuiXuan"] = 17] = "HuiXuan";
          BulletMoveType[BulletMoveType["HanBingJiGuang"] = 18] = "HanBingJiGuang";
          BulletMoveType[BulletMoveType["ZhiXianFenLie"] = 19] = "ZhiXianFenLie";
          BulletMoveType[BulletMoveType["ToPlayer"] = 20] = "ToPlayer";
          BulletMoveType[BulletMoveType["HuoYanTuXi"] = 21] = "HuoYanTuXi";
          BulletMoveType[BulletMoveType["TanLiQiu"] = 22] = "TanLiQiu";
          BulletMoveType[BulletMoveType["GuangMangSheXian"] = 23] = "GuangMangSheXian";
          BulletMoveType[BulletMoveType["ToOwnerLine"] = 24] = "ToOwnerLine";
          BulletMoveType[BulletMoveType["LeiTingWanJun"] = 25] = "LeiTingWanJun";
          BulletMoveType[BulletMoveType["FeiWuLeiHuan"] = 26] = "FeiWuLeiHuan";
          BulletMoveType[BulletMoveType["WorldBossTuXi"] = 27] = "WorldBossTuXi";
          BulletMoveType[BulletMoveType["DistanceOffset"] = 28] = "DistanceOffset";
          BulletMoveType[BulletMoveType["InCreatorTaiDao"] = 29] = "InCreatorTaiDao";
          BulletMoveType[BulletMoveType["HugeBullet"] = 30] = "HugeBullet";
          BulletMoveType[BulletMoveType["FollowMoveDir"] = 31] = "FollowMoveDir";
          BulletMoveType[BulletMoveType["FollowMoveDir2"] = 32] = "FollowMoveDir2";
          return BulletMoveType;
        }({});
        _GameBattle.BulletMoveType = BulletMoveType;
        var BulletHitShape = /*#__PURE__*/function (BulletHitShape) {
          BulletHitShape[BulletHitShape["Round"] = 1] = "Round";
          BulletHitShape[BulletHitShape["Rect"] = 2] = "Rect";
          return BulletHitShape;
        }({});
        _GameBattle.BulletHitShape = BulletHitShape;
        var ActionState = /*#__PURE__*/function (ActionState) {
          ActionState[ActionState["Idle"] = 0] = "Idle";
          ActionState[ActionState["Move"] = 2] = "Move";
          ActionState[ActionState["Attack"] = 4] = "Attack";
          ActionState[ActionState["UnderAttack"] = 8] = "UnderAttack";
          ActionState[ActionState["Skill"] = 16] = "Skill";
          ActionState[ActionState["Celebrate"] = 128] = "Celebrate";
          ActionState[ActionState["Run"] = 32] = "Run";
          ActionState[ActionState["Affected"] = 64] = "Affected";
          ActionState[ActionState["MIDDLE"] = 1024] = "MIDDLE";
          ActionState[ActionState["Stun"] = 1048576] = "Stun";
          ActionState[ActionState["Slowed"] = 16384] = "Slowed";
          ActionState[ActionState["Rooted"] = 65536] = "Rooted";
          ActionState[ActionState["Feared"] = 32768] = "Feared";
          ActionState[ActionState["Bewitch"] = 16384] = "Bewitch";
          ActionState[ActionState["Dead"] = 524288] = "Dead";
          ActionState[ActionState["Rebirth"] = 262144] = "Rebirth";
          ActionState[ActionState["GoldenBody"] = 196608] = "GoldenBody";
          ActionState[ActionState["Stealth"] = 229376] = "Stealth";
          return ActionState;
        }({});
        _GameBattle.ActionState = ActionState;
        var MonsterAIState = /*#__PURE__*/function (MonsterAIState) {
          MonsterAIState[MonsterAIState["Idle"] = 0] = "Idle";
          MonsterAIState[MonsterAIState["Homing"] = 1] = "Homing";
          MonsterAIState[MonsterAIState["Patrol"] = 2] = "Patrol";
          MonsterAIState[MonsterAIState["Pursuit"] = 3] = "Pursuit";
          return MonsterAIState;
        }({});
        _GameBattle.MonsterAIState = MonsterAIState;
        var RoleStateChangeTime = /*#__PURE__*/function (RoleStateChangeTime) {
          RoleStateChangeTime[RoleStateChangeTime["None"] = 0] = "None";
          RoleStateChangeTime[RoleStateChangeTime["Start"] = 1] = "Start";
          RoleStateChangeTime[RoleStateChangeTime["Course"] = 2] = "Course";
          RoleStateChangeTime[RoleStateChangeTime["End"] = 3] = "End";
          return RoleStateChangeTime;
        }({});
        _GameBattle.RoleStateChangeTime = RoleStateChangeTime;
        var Direction = /*#__PURE__*/function (Direction) {
          Direction[Direction["None"] = 0] = "None";
          Direction[Direction["Up"] = 1] = "Up";
          Direction[Direction["Down"] = 2] = "Down";
          Direction[Direction["Left"] = 3] = "Left";
          Direction[Direction["Right"] = 4] = "Right";
          Direction[Direction["LeftUp"] = 5] = "LeftUp";
          Direction[Direction["LeftDown"] = 6] = "LeftDown";
          Direction[Direction["RightUp"] = 7] = "RightUp";
          Direction[Direction["RightDown"] = 8] = "RightDown";
          return Direction;
        }({});
        _GameBattle.Direction = Direction;
        var MonsterQuality = /*#__PURE__*/function (MonsterQuality) {
          MonsterQuality[MonsterQuality["None"] = 0] = "None";
          MonsterQuality[MonsterQuality["Normal"] = 1] = "Normal";
          MonsterQuality[MonsterQuality["Boss"] = 2] = "Boss";
          return MonsterQuality;
        }({});
        _GameBattle.MonsterQuality = MonsterQuality;
        var SkillApplyTarget = /*#__PURE__*/function (SkillApplyTarget) {
          SkillApplyTarget[SkillApplyTarget["None"] = 0] = "None";
          SkillApplyTarget[SkillApplyTarget["Self"] = 1] = "Self";
          SkillApplyTarget[SkillApplyTarget["Enemy"] = 2] = "Enemy";
          SkillApplyTarget[SkillApplyTarget["Friends"] = 3] = "Friends";
          SkillApplyTarget[SkillApplyTarget["SelfAndFriends"] = 4] = "SelfAndFriends";
          SkillApplyTarget[SkillApplyTarget["All"] = 5] = "All";
          return SkillApplyTarget;
        }({});
        _GameBattle.SkillApplyTarget = SkillApplyTarget;
        var SkillEffectType = /*#__PURE__*/function (SkillEffectType) {
          SkillEffectType[SkillEffectType["None"] = 0] = "None";
          SkillEffectType[SkillEffectType["Damage"] = 1] = "Damage";
          SkillEffectType[SkillEffectType["Damage2"] = 102] = "Damage2";
          SkillEffectType[SkillEffectType["Damage3"] = 103] = "Damage3";
          SkillEffectType[SkillEffectType["Damage4"] = 8] = "Damage4";
          SkillEffectType[SkillEffectType["Damage5"] = 9] = "Damage5";
          SkillEffectType[SkillEffectType["AddBuff"] = 2] = "AddBuff";
          SkillEffectType[SkillEffectType["RemoveBuff"] = 3] = "RemoveBuff";
          SkillEffectType[SkillEffectType["CreateBullet"] = 4] = "CreateBullet";
          SkillEffectType[SkillEffectType["CreateBullet360"] = 41] = "CreateBullet360";
          SkillEffectType[SkillEffectType["TarGetMove"] = 5] = "TarGetMove";
          SkillEffectType[SkillEffectType["Summon"] = 6] = "Summon";
          SkillEffectType[SkillEffectType["Heal"] = 7] = "Heal";
          return SkillEffectType;
        }({});
        _GameBattle.SkillEffectType = SkillEffectType;
        var BattleNpcType = /*#__PURE__*/function (BattleNpcType) {
          BattleNpcType[BattleNpcType["TuTeng"] = 1] = "TuTeng";
          BattleNpcType[BattleNpcType["ZhuangBeiJia"] = 2] = "ZhuangBeiJia";
          BattleNpcType[BattleNpcType["BaoXiang"] = 3] = "BaoXiang";
          BattleNpcType[BattleNpcType["BaoXiangMoon"] = 4] = "BaoXiangMoon";
          BattleNpcType[BattleNpcType["NpcMoon"] = 5] = "NpcMoon";
          return BattleNpcType;
        }({});
        _GameBattle.BattleNpcType = BattleNpcType;
        var BuffType = /*#__PURE__*/function (BuffType) {
          BuffType[BuffType["Normal"] = 0] = "Normal";
          return BuffType;
        }({});
        _GameBattle.BuffType = BuffType;
        var BuffDurationType = /*#__PURE__*/function (BuffDurationType) {
          BuffDurationType[BuffDurationType["Timer"] = 1] = "Timer";
          BuffDurationType[BuffDurationType["Battle"] = 2] = "Battle";
          BuffDurationType[BuffDurationType["Forever"] = 3] = "Forever";
          BuffDurationType[BuffDurationType["SpineTimer"] = 4] = "SpineTimer";
          return BuffDurationType;
        }({});
        _GameBattle.BuffDurationType = BuffDurationType;
        var BuffCondition = /*#__PURE__*/function (BuffCondition) {
          BuffCondition[BuffCondition["monster_count"] = 1] = "monster_count";
          BuffCondition[BuffCondition["skill_id"] = 2] = "skill_id";
          BuffCondition[BuffCondition["death_count"] = 3] = "death_count";
          return BuffCondition;
        }({});
        _GameBattle.BuffCondition = BuffCondition;
        var BuffAddType = /*#__PURE__*/function (BuffAddType) {
          BuffAddType[BuffAddType["None"] = 0] = "None";
          BuffAddType[BuffAddType["Replace"] = 1] = "Replace";
          BuffAddType[BuffAddType["Add"] = 2] = "Add";
          BuffAddType[BuffAddType["Exclusive"] = 3] = "Exclusive";
          BuffAddType[BuffAddType["Overlap"] = 4] = "Overlap";
          return BuffAddType;
        }({});
        _GameBattle.BuffAddType = BuffAddType;
        var BuffTargetType = /*#__PURE__*/function (BuffTargetType) {
          BuffTargetType[BuffTargetType["enemy"] = 1] = "enemy";
          BuffTargetType[BuffTargetType["self"] = 2] = "self";
          BuffTargetType[BuffTargetType["partner"] = 3] = "partner";
          BuffTargetType[BuffTargetType["selfAndSummon"] = 4] = "selfAndSummon";
          return BuffTargetType;
        }({});
        _GameBattle.BuffTargetType = BuffTargetType;
        var BuffEffectCalculate = /*#__PURE__*/function (BuffEffectCalculate) {
          BuffEffectCalculate[BuffEffectCalculate["none"] = 0] = "none";
          BuffEffectCalculate[BuffEffectCalculate["add"] = 1] = "add";
          BuffEffectCalculate[BuffEffectCalculate["mul"] = 2] = "mul";
          BuffEffectCalculate[BuffEffectCalculate["equ"] = 3] = "equ";
          BuffEffectCalculate[BuffEffectCalculate["append"] = 4] = "append";
          return BuffEffectCalculate;
        }({});
        _GameBattle.BuffEffectCalculate = BuffEffectCalculate;
        var EventBuffId = /*#__PURE__*/function (EventBuffId) {
          EventBuffId[EventBuffId["allBall"] = 1] = "allBall";
          EventBuffId[EventBuffId["reborn"] = 2] = "reborn";
          EventBuffId[EventBuffId["shanBi"] = 3] = "shanBi";
          EventBuffId[EventBuffId["attack"] = 4] = "attack";
          EventBuffId[EventBuffId["underAttack"] = 5] = "underAttack";
          EventBuffId[EventBuffId["enterBattle"] = 6] = "enterBattle";
          EventBuffId[EventBuffId["userSkill"] = 7] = "userSkill";
          EventBuffId[EventBuffId["hpBall"] = 8] = "hpBall";
          EventBuffId[EventBuffId["bulletLaunch"] = 9] = "bulletLaunch";
          EventBuffId[EventBuffId["geDang"] = 10] = "geDang";
          EventBuffId[EventBuffId["TuTeng"] = 11] = "TuTeng";
          EventBuffId[EventBuffId["MiaoSha"] = 12] = "MiaoSha";
          EventBuffId[EventBuffId["HitEnemy"] = 13] = "HitEnemy";
          return EventBuffId;
        }({});
        _GameBattle.EventBuffId = EventBuffId;
        var BuffEffectType = /*#__PURE__*/function (BuffEffectType) {
          BuffEffectType[BuffEffectType["removeBuff"] = 4] = "removeBuff";
          BuffEffectType[BuffEffectType["removeGroupBuff"] = 5] = "removeGroupBuff";
          BuffEffectType[BuffEffectType["Hurt"] = 101] = "Hurt";
          BuffEffectType[BuffEffectType["Hurt2"] = 102] = "Hurt2";
          BuffEffectType[BuffEffectType["Hurt3"] = 103] = "Hurt3";
          BuffEffectType[BuffEffectType["Hurt4"] = 8] = "Hurt4";
          BuffEffectType[BuffEffectType["Hurt5"] = 9] = "Hurt5";
          BuffEffectType[BuffEffectType["AddBuffByOdds"] = 202] = "AddBuffByOdds";
          BuffEffectType[BuffEffectType["XuanYun"] = 204] = "XuanYun";
          BuffEffectType[BuffEffectType["Round"] = 205] = "Round";
          BuffEffectType[BuffEffectType["MaBi"] = 206] = "MaBi";
          BuffEffectType[BuffEffectType["Bewitch"] = 208] = "Bewitch";
          BuffEffectType[BuffEffectType["RemoveBuff"] = 301] = "RemoveBuff";
          BuffEffectType[BuffEffectType["CreateBullet"] = 401] = "CreateBullet";
          BuffEffectType[BuffEffectType["AddAttr1"] = 501] = "AddAttr1";
          BuffEffectType[BuffEffectType["AddAttr2"] = 502] = "AddAttr2";
          BuffEffectType[BuffEffectType["AddAttr3"] = 503] = "AddAttr3";
          BuffEffectType[BuffEffectType["ForcedAttr"] = 506] = "ForcedAttr";
          BuffEffectType[BuffEffectType["ZhiLiao"] = 801] = "ZhiLiao";
          BuffEffectType[BuffEffectType["XiuGaiShuXing"] = 901] = "XiuGaiShuXing";
          BuffEffectType[BuffEffectType["XiuGaiQuanJuShuXing"] = 902] = "XiuGaiQuanJuShuXing";
          BuffEffectType[BuffEffectType["AddSkillHurtByOdds"] = 903] = "AddSkillHurtByOdds";
          BuffEffectType[BuffEffectType["ConstantlyAttr"] = 904] = "ConstantlyAttr";
          BuffEffectType[BuffEffectType["KillSelf"] = 905] = "KillSelf";
          BuffEffectType[BuffEffectType["EventBuff"] = 906] = "EventBuff";
          BuffEffectType[BuffEffectType["Invulnerable"] = 907] = "Invulnerable";
          BuffEffectType[BuffEffectType["Scale"] = 909] = "Scale";
          return BuffEffectType;
        }({});
        _GameBattle.BuffEffectType = BuffEffectType;
        var MapWidht = _GameBattle.MapWidht = 3072;
        var MapHeight = _GameBattle.MapHeight = 3072;
        var PlayerCameraWidht = _GameBattle.PlayerCameraWidht = 760;
        var PlayerCameraHeight = _GameBattle.PlayerCameraHeight = 1334;
        var RolePrefabPath = _GameBattle.RolePrefabPath = (_GameBattle$RolePrefa = {}, _GameBattle$RolePrefa[GameBattle.RoleType.Monster] = "prefabs/scene/role/Monster", _GameBattle$RolePrefa[GameBattle.RoleType.Hero] = "prefabs/scene/role/Hero", _GameBattle$RolePrefa[GameBattle.RoleType.Soldier] = "prefabs/scene/role/Soldier", _GameBattle$RolePrefa);
        var BulletPrefabPath = _GameBattle.BulletPrefabPath = (_GameBattle$BulletPre = {}, _GameBattle$BulletPre[GameBattle.BulletType.Remote] = "prefabs/scene/bullet/RemoteBullet", _GameBattle$BulletPre[GameBattle.BulletType.Melee] = "prefabs/scene/bullet/MeleeBullet", _GameBattle$BulletPre[GameBattle.BulletType.Follow] = "prefabs/scene/bullet/FollowBullet", _GameBattle$BulletPre[GameBattle.BulletType.NoAngle] = "prefabs/scene/bullet/RemoteBullet", _GameBattle$BulletPre[GameBattle.BulletType.ShiZhu] = "prefabs/scene/bullet/MeleeBullet", _GameBattle$BulletPre[GameBattle.BulletType.LockNoSame] = "prefabs/scene/bullet/RemoteBullet", _GameBattle$BulletPre[GameBattle.BulletType.Circular] = "prefabs/scene/bullet/CircularBullet", _GameBattle$BulletPre[GameBattle.BulletType.Adsorption] = "prefabs/scene/bullet/AdsorptionBullet", _GameBattle$BulletPre[GameBattle.BulletType.LockNoSame2] = "prefabs/scene/bullet/RemoteBullet", _GameBattle$BulletPre[GameBattle.BulletType.LockNoSame3] = "prefabs/scene/bullet/RemoteBullet", _GameBattle$BulletPre[GameBattle.BulletType.Affected] = "prefabs/scene/effect/affected", _GameBattle$BulletPre);
        var OtherPrefabPath = _GameBattle.OtherPrefabPath = {
          /** 伤害提示 */
          DamageTips: "prefabs/scene/DamageTips",
          /** 掉落物品 */
          itemFallingProp: "prefabs/scene/itemFallingProp",
          /** 掉落金币 卡皮巴拉专用的 */
          itemFallingGold: "prefabs/scene/itemFallingGold",
          /** 经验飞行拖尾 */
          itemExpMotionSteak: "prefabs/scene/itemExpMotionSteak",
          /** 地图上的动态效果 */
          skillCastEffect: "prefabs/scene/skillCastEffect",
          /** 获取物品提示 */
          itemGetPropTips: "prefabs/scene/itemGetPropTips",
          /** BUFF图标 */
          itemBuffIcon: "prefabs/scene/itemBuffIcon",
          /** 技能预警图标 */
          skillWarning: "prefabs/scene/spineSkillYuJing",
          /** 肉钩 */
          // hook: 'skill/monster/Hook',

          /** 石壁 */
          shibi: "skill/monster/shibi",
          /** 掉落UI动画 */
          itemFallUi: "prefabs/scene/ItemFallUi"

          /** 血月模式副本NPC */
          // itemBattleMoonNPC: 'prefabs/scene/itemBattleMoonNPC',
        };

        var itemTMXGrass = _GameBattle.itemTMXGrass = "prefabs/scene/itemTMXGrass";
        var item_battleMap = _GameBattle.item_battleMap = "prefabs/scene/item_battleMap";
        var itemBattleNpc = _GameBattle.itemBattleNpc = "prefabs/scene/itemBattleNpc";
        var CommomUiTip = /*#__PURE__*/function (CommomUiTip) {
          CommomUiTip[CommomUiTip["hpBall"] = 0] = "hpBall";
          CommomUiTip[CommomUiTip["mpBall"] = 1] = "mpBall";
          CommomUiTip[CommomUiTip["skill"] = 2] = "skill";
          return CommomUiTip;
        }({});
        _GameBattle.CommomUiTip = CommomUiTip;
        var PlayerSkillTierNum = _GameBattle.PlayerSkillTierNum = 5;
      })(GameBattle || (GameBattle = exports('GameBattle', {})));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleGlobalData.ts", ['cc'], function (exports) {
  var cclegacy;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
    }],
    execute: function () {
      cclegacy._RF.push({}, "aef35QLCJZD+q3qidKiyUHf", "BattleGlobalData", undefined);
      var BattleGlobalDataType = exports('BattleGlobalDataType', /*#__PURE__*/function (BattleGlobalDataType) {
        BattleGlobalDataType[BattleGlobalDataType["hpBallRatio"] = 1] = "hpBallRatio";
        BattleGlobalDataType[BattleGlobalDataType["skillCost"] = 2] = "skillCost";
        BattleGlobalDataType[BattleGlobalDataType["geDangRatio"] = 3] = "geDangRatio";
        BattleGlobalDataType[BattleGlobalDataType["maxBossHitRatio"] = 4] = "maxBossHitRatio";
        return BattleGlobalDataType;
      }({}));
      var BattleGlobalData = exports('BattleGlobalData', /*#__PURE__*/function () {
        function BattleGlobalData() {
          this._map = {};
        }
        var _proto = BattleGlobalData.prototype;
        _proto.init = function init() {
          this._map = {};
          this._map[BattleGlobalDataType.hpBallRatio] = 0;
          this._map[BattleGlobalDataType.skillCost] = 1;
          this._map[BattleGlobalDataType.geDangRatio] = 0;
          this._map[BattleGlobalDataType.maxBossHitRatio] = 0;
        };
        _proto.getData = function getData(type) {
          return this._map[type];
        };
        _proto.setData = function setData(type, value) {
          if (!this._map[type]) {
            this._map[type] = value;
          } else {
            this._map[type] += value;
          }
        };
        return BattleGlobalData;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleHeroHeadsItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './TeamMgr.ts', './ModuleDef.ts', './DBRecord.ts', './UtilGame.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Sprite, ProgressBar, Node, Color, Vec2, instantiate, UITransform, director, Canvas, v3, Component, App, TeamMgr, ModuleDef, DBRecord, UtilGame;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      ProgressBar = module.ProgressBar;
      Node = module.Node;
      Color = module.Color;
      Vec2 = module.Vec2;
      instantiate = module.instantiate;
      UITransform = module.UITransform;
      director = module.director;
      Canvas = module.Canvas;
      v3 = module.v3;
      Component = module.Component;
    }, function (module) {
      App = module.App;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      UtilGame = module.UtilGame;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7;
      cclegacy._RF.push({}, "0338aY0z9dLG6eo8ssahBzX", "BattleHeroHeadsItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleHeroHeadsItem = exports('BattleHeroHeadsItem', (_dec = ccclass("BattleHeroHeadsItem"), _dec2 = property({
        type: Sprite
      }), _dec3 = property({
        type: Sprite
      }), _dec4 = property({
        type: Sprite
      }), _dec5 = property({
        type: ProgressBar
      }), _dec6 = property({
        type: Node
      }), _dec7 = property({
        type: Sprite
      }), _dec8 = property({
        type: Sprite
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleHeroHeadsItem, _Component);
        function BattleHeroHeadsItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /** 英雄特效-满怒气状态 */
          _initializerDefineProperty(_this, "effSp", _descriptor, _assertThisInitialized(_this));
          /** 英雄品质背景 */
          _initializerDefineProperty(_this, "headBg", _descriptor2, _assertThisInitialized(_this));
          /** 英雄头像 */
          _initializerDefineProperty(_this, "headIcon", _descriptor3, _assertThisInitialized(_this));
          /** 英雄怒气值进度条 */
          _initializerDefineProperty(_this, "rageBar", _descriptor4, _assertThisInitialized(_this));
          /** 技能节点node */
          _initializerDefineProperty(_this, "skillNode", _descriptor5, _assertThisInitialized(_this));
          /** 技能图标 */
          _initializerDefineProperty(_this, "skillIcon", _descriptor6, _assertThisInitialized(_this));
          /** 技能类型icon */
          _initializerDefineProperty(_this, "skillType", _descriptor7, _assertThisInitialized(_this));
          // 私有变量
          _this._heroData = null;
          // 英雄数据
          _this._heroEntity = null;
          // 英雄实体引用
          _this._rageGainPerSecond = 0;
          // 每秒怒气增长值
          _this._maxRage = 100;
          // 最大怒气值
          _this._isDead = false;
          // 是否死亡
          _this._isInBattle = false;
          // 是否在战场上
          _this._isRageFull = false;
          // 怒气是否已满
          _this._skillId = 0;
          // 技能ID
          _this._isDraggingSkill = false;
          // 是否正在拖拽技能
          _this._skillDragIcon = null;
          // 拖拽中的技能作用范围圈节点
          _this._touchEventListenerAdded = false;
          // 是否已注册触摸事件
          _this._dragStartPos = null;
          // 拖拽起始位置
          _this._dragThreshold = 10;
          // 拖拽阈值（像素），超过此距离视为拖拽
          _this._justReleasedSkill = false;
          return _this;
        }
        var _proto = BattleHeroHeadsItem.prototype;
        // 刚刚释放了技能（用于防止事件冒泡）
        _proto.onLoad = function onLoad() {
          // 注册点击事件
          this.node.on(Node.EventType.TOUCH_END, this.onHeroHeadClick, this);

          // 初始隐藏技能节点
          if (this.skillNode) {
            this.skillNode.active = false;
          }
        };
        _proto.onDestroy = function onDestroy() {
          // 移除点击事件
          if (this.node && this.node.isValid) {
            this.node.off(Node.EventType.TOUCH_END, this.onHeroHeadClick, this);
          }

          // 移除技能拖拽事件
          if (this.skillNode && this.skillNode.isValid) {
            this.skillNode.off(Node.EventType.TOUCH_START, this.onSkillDragStart, this);
            this.skillNode.off(Node.EventType.TOUCH_MOVE, this.onSkillDragMove, this);
            this.skillNode.off(Node.EventType.TOUCH_END, this.onSkillDragEnd, this);
            this.skillNode.off(Node.EventType.TOUCH_CANCEL, this.onSkillDragCancel, this);
          }

          // 清理拖拽图标
          if (this._skillDragIcon && this._skillDragIcon.isValid) {
            this._skillDragIcon.destroy();
            this._skillDragIcon = null;
          }

          // 重置标志
          this._touchEventListenerAdded = false;
        }

        /**
         * 显示英雄头像
         * @param data 英雄数据
         * @param heroEntity 英雄实体（可选）
         */;
        _proto.show = function show(data, heroEntity) {
          this.showEmpty();
          if (!data) return;
          this._heroData = data;
          this._heroEntity = heroEntity;
          this._isDead = false;
          this._isInBattle = false;
          this._isRageFull = false;

          // 显示背景
          if (this.headBg) {
            this.headBg.node.active = true;
          }

          // 显示头像
          var heroCfg = TeamMgr.inst.getHeroIdCfg(data.hero_id);
          if (heroCfg && this.headIcon) {
            this.headIcon.node.active = true;
            App.resMgr.loadImage(this.headIcon, ModuleDef.GAME_ICON, "/head_icon/" + heroCfg.icon + "_head");
          }

          // 获取怒气配置
          this.updateRageConfig();

          // 初始化怒气条为隐藏状态（未上战场）
          if (this.rageBar) {
            this.rageBar.node.active = false;
            this.rageBar.progress = 0;
          }

          // 隐藏满怒气特效
          if (this.effSp) {
            this.effSp.node.active = false;
          }

          // 恢复正常颜色
          this.setGrayScale(false);

          // 加载并显示技能图标
          this.loadSkillIcon();
        }

        /**
         * 显示空位置
         */;
        _proto.showEmpty = function showEmpty() {
          // 隐藏头像
          if (this.headIcon) {
            this.headIcon.node.active = false;
          }
          // 隐藏怒气条
          if (this.rageBar) {
            this.rageBar.node.active = false;
          }
          // 隐藏满怒气特效
          if (this.effSp) {
            this.effSp.node.active = false;
          }
          // 隐藏技能节点
          if (this.skillNode) {
            this.skillNode.active = false;
          }

          // 重置内部状态
          this._heroData = null;
          this._heroEntity = null;
          this._isDead = false;
          this._isInBattle = false;
          this._skillId = 0;
          this._isRageFull = false;
          this._touchEventListenerAdded = false;
        }

        /**
         * 更新怒气配置（从Hero_Stage配置读取）
         */;
        _proto.updateRageConfig = function updateRageConfig() {
          if (!this._heroData) return;
          var stageCfg = TeamMgr.inst.getHeroStageCfg(this._heroData.hero_id, this._heroData.stage);
          if (stageCfg && stageCfg.nuqi) {
            // nuqi格式: [每秒增长值, 增长间隔(秒), 最大值]
            // 例如: [5, 1, 100] 表示每1秒增长5点怒气，最大100
            var _stageCfg$nuqi = stageCfg.nuqi,
              gainAmount = _stageCfg$nuqi[0],
              gainInterval = _stageCfg$nuqi[1],
              maxRage = _stageCfg$nuqi[2];
            this._rageGainPerSecond = gainAmount / gainInterval; // 转换为每秒增长值
            this._maxRage = maxRage;
          } else {
            // 默认值
            this._rageGainPerSecond = 5;
            this._maxRage = 100;
          }
        }

        /**
         * 英雄部署到战场
         */;
        _proto.onHeroDeployed = function onHeroDeployed() {
          this._isInBattle = true;
          this._isDead = false;

          // 显示怒气条
          if (this.rageBar) {
            this.rageBar.node.active = true;
            this.rageBar.progress = 0;
          }

          // 恢复正常颜色
          this.setGrayScale(false);
        }

        /**
         * 英雄返回城墙（待命状态）
         */;
        _proto.onHeroReturnToWall = function onHeroReturnToWall() {
          this._isInBattle = false;

          // 隐藏怒气条
          if (this.rageBar) {
            this.rageBar.node.active = false;
            this.rageBar.progress = 0;
          }

          // 隐藏满怒气特效
          if (this.effSp) {
            this.effSp.node.active = false;
          }

          // 恢复正常颜色
          this.setGrayScale(false);
        }

        /**
         * 英雄死亡
         */;
        _proto.onHeroDead = function onHeroDead() {
          this._isDead = true;

          // 清空怒气条
          if (this.rageBar) {
            this.rageBar.progress = 0;
          }

          // 隐藏满怒气特效
          if (this.effSp) {
            this.effSp.node.active = false;
          }

          // 设置灰色显示
          this.setGrayScale(true);
        }

        /**
         * 英雄复活
         */;
        _proto.onHeroRevive = function onHeroRevive() {
          this._isDead = false;
          this._isInBattle = false;

          // 隐藏怒气条（复活后在城墙上）
          if (this.rageBar) {
            this.rageBar.node.active = false;
            this.rageBar.progress = 0;
          }

          // 恢复正常颜色
          this.setGrayScale(false);
        }

        /**
         * 更新英雄怒气值进度条
         * @param rage 当前怒气值
         */;
        _proto.updateRageBar = function updateRageBar(rage) {
          if (!this._isInBattle || this._isDead) {
            return;
          }

          // 更新进度条
          if (this.rageBar) {
            this.rageBar.progress = rage / this._maxRage;
          }

          // 更新怒气满状态
          this._isRageFull = rage >= this._maxRage;

          // 显示/隐藏满怒气特效（怒火燃烧特效）
          if (this.effSp) {
            this.effSp.node.active = this._isRageFull;
            this._justReleasedSkill = !this._isRageFull;
          }
        }

        /**
         * 每帧更新（从英雄实体同步怒气值）
         */;
        _proto.update = function update(_dt) {
          if (!this._heroEntity || !this._isInBattle || this._isDead) {
            return;
          }

          // 从英雄实体同步怒气值
          this.updateRageBar(this._heroEntity.rage);
        }

        /**
         * 设置灰度显示
         * @param isGray 是否灰度
         */;
        _proto.setGrayScale = function setGrayScale(isGray) {
          var grayColor = new Color(128, 128, 128, 255);
          var normalColor = new Color(255, 255, 255, 255);
          var targetColor = isGray ? grayColor : normalColor;
          if (this.headIcon) {
            this.headIcon.color = targetColor;
          }
          if (this.headBg) {
            this.headBg.color = targetColor;
          }
        }

        /**
         * 绑定英雄实体
         * @param heroEntity 英雄实体
         */;
        _proto.bindHeroEntity = function bindHeroEntity(heroEntity) {
          this._heroEntity = heroEntity;
        }

        /**
         * 加载技能图标
         */;
        _proto.loadSkillIcon = function loadSkillIcon() {
          if (!this._heroData || !this.skillNode) {
            return;
          }

          // 获取英雄星级配置中的技能ID
          var starCfg = TeamMgr.inst.getHeroStarCfg(this._heroData.hero_id, this._heroData.star);
          if (!starCfg || !starCfg.skill_id) {
            return;
          }
          this._skillId = starCfg.skill_id;

          // 获取技能配置
          var skillCfg = DBRecord.fetchId("Skill", this._skillId);
          if (!skillCfg) {
            return;
          }

          // 加载技能图标
          if (this.skillIcon && skillCfg.icon) {
            UtilGame.loadSkillIcon(this.skillIcon, skillCfg.id);
          }

          // 设置技能类型图标（根据技能类型设置不同图标）
          if (this.skillType) {
            // TODO: 根据技能类型加载对应图标
            UtilGame.loadSkillTypeIcon(this.skillType, skillCfg.type);
          }
          // 防止重复注册导致多次回调
          if (!this._touchEventListenerAdded) {
            this._touchEventListenerAdded = true;
            // 拖拽事件处理特殊，触发顺序: move -> end (手指在节点上抬起) 或 move -> cancel (手指移出节点外抬起)
            // 为避免拖拽在节点外抬起没有触发end，我们全局监听touch end/up事件
            this.skillNode.on(Node.EventType.TOUCH_START, this.onSkillDragStart, this);
            this.skillNode.on(Node.EventType.TOUCH_MOVE, this.onSkillDragMove, this);
            this.skillNode.on(Node.EventType.TOUCH_END, this.onSkillDragEnd, this);
            this.skillNode.on(Node.EventType.TOUCH_CANCEL, this.onSkillDragCancel, this);
          }
        }

        /**
         * 英雄头像点击事件处理
         */;
        _proto.onHeroHeadClick = function onHeroHeadClick() {
          // 如果刚刚释放了技能，忽略此次点击（防止事件冒泡）
          if (this._justReleasedSkill) {
            this._justReleasedSkill = false;
            return;
          }

          // 只有怒气满时才响应点击
          if (!this._isRageFull || !this._heroEntity || this._isDead || !this._isInBattle) {
            return;
          }
          if (!this._heroData || !this.skillNode) {
            return;
          }

          // 切换技能节点显示状态
          this.skillNode.active = !this.skillNode.active;
          if (this.skillNode.active) {
            // 显示英雄攻击范围
            var starCfg = TeamMgr.inst.getHeroStarCfg(this._heroData.hero_id, this._heroData.star);
            if (starCfg && starCfg.skill_id) {
              var skillCfg = DBRecord.fetchId("Skill", starCfg.skill_id);
              if (skillCfg && skillCfg.distance && skillCfg.distance.length >= 2) {
                var attackRange = skillCfg.distance[1];
                this._heroEntity.showAttackRange(attackRange);
              }
            }
          } else {
            // 隐藏攻击范围
            this._heroEntity.hideAttackRange();
          }
        }

        /**
         * 技能拖拽开始
         */;
        _proto.onSkillDragStart = function onSkillDragStart(event) {
          if (!this._isRageFull || !this._heroEntity || this._isDead || !this._isInBattle) {
            return;
          }

          // 阻止事件冒泡，防止触发英雄头像的点击事件
          event.propagationStopped = true;
          this._isDraggingSkill = true;

          // 记录拖拽起始位置
          this._dragStartPos = event.getUILocation();

          // 不在这里创建范围圈，等到TOUCH_MOVE时才创建（区分点击和拖拽）
        }

        /**
         * 技能拖拽移动
         */;
        _proto.onSkillDragMove = function onSkillDragMove(event) {
          if (!this._isDraggingSkill) {
            return;
          }

          // 如果范围圈还未创建，先检查是否移动距离足够（避免轻微抖动触发拖拽）
          if (!this._skillDragIcon && this.skillIcon && this._dragStartPos) {
            var currentPos = event.getUILocation();
            var moveDistance = Vec2.distance(this._dragStartPos, currentPos);

            // 移动距离小于阈值，不创建范围圈
            if (moveDistance < this._dragThreshold) {
              return;
            }
          }

          // 创建范围圈
          if (!this._skillDragIcon && this.skillIcon) {
            var _director$getScene;
            this._skillDragIcon = instantiate(this.skillIcon.node);

            // 获取技能范围
            var skillRange = 100; // 默认范围
            if (this._heroEntity.roleSkill && this._skillId) {
              var skill = this._heroEntity.roleSkill.getSkillById(this._skillId);
              if (skill && skill.distance && skill.distance.length > 0) {
                // 使用distance[1]（最大范围）作为圆圈半径
                skillRange = skill.distance[1] || skill.distance[0];
              }
            }

            // 替换Sprite资源为范围圆圈
            var sprite = this._skillDragIcon.getComponent(Sprite);
            if (sprite) {
              sprite.node.active = false;
              // 加载范围圆圈图片
              App.resMgr.loadImage(sprite, ModuleDef.GAME_BATTLE_B, "/images/new_battleUI/zd_img_fanwei", function () {
                sprite.node.active = true;
              });

              // 设置为完全不透明
              sprite.color = new Color(255, 255, 255, 255);

              // 获取Sprite的UITransform来设置实际尺寸
              var uiTransform = this._skillDragIcon.getComponent(UITransform);
              if (uiTransform) {
                // 直接设置内容尺寸为技能范围的直径
                var diameter = skillRange * 2;
                uiTransform.setContentSize(diameter, diameter);
                // 重置缩放为1
                this._skillDragIcon.setScale(1, 1, 1);
              }
            }
            var canvas = (_director$getScene = director.getScene()) == null ? void 0 : _director$getScene.getComponentInChildren(Canvas);
            if (canvas) {
              this._skillDragIcon.setParent(canvas.node);
              this._skillDragIcon.setSiblingIndex(9999);
            }
          }

          // 更新范围圈位置
          if (this._skillDragIcon) {
            var _director$getScene2;
            var _canvas = (_director$getScene2 = director.getScene()) == null ? void 0 : _director$getScene2.getComponentInChildren(Canvas);
            if (!_canvas) {
              return;
            }
            var uiPos = event.getUILocation();
            var uiPos3 = v3(uiPos.x, uiPos.y, 0);
            var uiTrans = _canvas.getComponent(UITransform);
            if (uiTrans) {
              var localPos = uiTrans.convertToNodeSpaceAR(uiPos3);
              this._skillDragIcon.setPosition(localPos);
            } else {
              this._skillDragIcon.setPosition(uiPos3);
            }
          }
        }

        /**
         * 技能拖拽结束
         * 必须保证拖拽状态 _isDraggingSkill 为 true 才进行操作
         */;
        _proto.onSkillDragEnd = function onSkillDragEnd(_event) {
          if (!this._isDraggingSkill) {
            return;
          }
          this._isDraggingSkill = false;

          // 判断是点击还是拖拽
          var isDrag = false;
          var targetWorldPos = null;

          // 如果拖拽图标存在，说明发生了拖拽（因为只有TOUCH_MOVE时才创建）
          if (this._skillDragIcon && this._skillDragIcon.isValid) {
            isDrag = true;
            // 获取拖拽图标的当前世界位置作为目标位置
            targetWorldPos = this._skillDragIcon.worldPosition.clone();
          }

          // 清理拖拽图标（范围圈）
          if (this._skillDragIcon) {
            if (this._skillDragIcon.isValid) {
              this._skillDragIcon.destroy();
            }
            this._skillDragIcon = null;
          }

          // 隐藏技能节点
          if (this.skillNode) {
            this.skillNode.active = false;
          }

          // 设置标志，防止事件冒泡触发头像点击
          this._justReleasedSkill = true;
          if (!this._heroEntity || !this._heroEntity.node || !this._heroEntity.node.isValid) {
            return;
          }

          // 如果是拖拽，英雄闪现到目标点
          if (isDrag && targetWorldPos) {
            this._heroEntity.node.setWorldPosition(targetWorldPos);
          }
          // 如果是点击，英雄在原地释放技能（不移动）

          // 释放技能
          if (this._heroEntity.roleSkill && this._skillId) {
            // 消耗怒气
            this._heroEntity.rage = 0;

            // 获取技能对象
            var skill = this._heroEntity.roleSkill.getSkillById(this._skillId);
            if (skill) {
              // 退出移动状态
              this._heroEntity.exitMove();

              // 设置当前技能（用于动画完成回调识别）
              this._heroEntity.useSkill(skill);

              // 标记为手动释放的技能（用于handleSkillComplete判断）
              this._heroEntity._isManualSkill = true;

              // 锁定AI状态，防止技能播放期间被打断
              if (this._heroEntity._heroAI) {
                this._heroEntity._heroAI.stateLock = true;
              }

              // 播放Skill动作（在帧事件中会执行skill.use()）
              this._heroEntity.state.setSkill(skill.arts_action, skill);

              // 注意：不要在这里取消手动控制，会在handleSkillComplete中自动恢复
              // this._heroEntity.isManualControl = false;
            }
          }

          // 隐藏攻击范围
          this._heroEntity.hideAttackRange();

          // 重置拖拽起始位置
          this._dragStartPos = null;
        }

        /**
         * 技能拖拽取消
         * 当手指拖拽到节点外部抬起时会触发此事件而不是TOUCH_END
         * 所以需要和TOUCH_END一样处理：释放技能
         */;
        _proto.onSkillDragCancel = function onSkillDragCancel(event) {
          // 直接调用 onSkillDragEnd 来处理
          this.onSkillDragEnd(event);
        }

        /**
         * 将UI屏幕坐标转换为世界坐标
         * @param uiPos UI屏幕坐标（getUILocation返回的坐标）
         * @returns 世界坐标
         */;
        _proto.convertToWorldPosition = function convertToWorldPosition(uiPos) {
          var _director$getScene3;
          var canvas = (_director$getScene3 = director.getScene()) == null ? void 0 : _director$getScene3.getComponentInChildren(Canvas);
          if (!canvas) {
            return null;
          }
          var uiTrans = canvas.getComponent(UITransform);
          if (!uiTrans) {
            return null;
          }

          // getUILocation() 返回的是UI坐标系（左下角为原点）
          // 直接转换为Canvas节点的本地坐标，然后转为世界坐标
          var uiPos3 = v3(uiPos.x, uiPos.y, 0);
          var localPos = uiTrans.convertToNodeSpaceAR(uiPos3);
          var worldPos = uiTrans.convertToWorldSpaceAR(localPos);
          return worldPos;
        };
        return BattleHeroHeadsItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "effSp", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "headBg", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "headIcon", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "rageBar", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "skillNode", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "skillIcon", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "skillType", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleHeroStancesItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Hero.ts', './App.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createForOfIteratorHelperLoose, cclegacy, _decorator, Sprite, Node, Label, color, Component, Hero, App;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Node = module.Node;
      Label = module.Label;
      color = module.color;
      Component = module.Component;
    }, function (module) {
      Hero = module.Hero;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4;
      cclegacy._RF.push({}, "4abca25u7dJRaptzyApTi/s", "BattleHeroStancesItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleHeroStancesItem = exports('BattleHeroStancesItem', (_dec = ccclass("BattleHeroStancesItem"), _dec2 = property({
        type: Sprite
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Label
      }), _dec5 = property({
        type: Label
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleHeroStancesItem, _Component);
        function BattleHeroStancesItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "yinying", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroNode", _descriptor2, _assertThisInitialized(_this));
          /** 英雄状态 */
          _initializerDefineProperty(_this, "stateLab", _descriptor3, _assertThisInitialized(_this));
          /** 复活时间 */
          _initializerDefineProperty(_this, "timeLab", _descriptor4, _assertThisInitialized(_this));
          _this._hero = null;
          _this._heroIndex = 0;
          return _this;
        }
        var _proto = BattleHeroStancesItem.prototype;
        // 英雄索引（1, 2, 3...）
        _proto.start = function start() {
          this.stateLab.node.active = false;
          this.timeLab.node.active = false;
          this.timeLab.string = "00:00";

          // 初始化时获取Hero组件
          this.initHero();
        }

        /**
         * 初始化Hero组件
         */;
        _proto.initHero = function initHero() {
          if (!this.heroNode) return;

          // 首先尝试从heroNode或其子节点获取Hero组件
          this._hero = this.heroNode.getComponent(Hero);
          if (!this._hero) {
            this._hero = this.heroNode.getComponentInChildren(Hero);
          }

          // 如果还是找不到，尝试从DungeonBattleMgr的待命列表中查找
          if (!this._hero && App.dungeonBattleMgr) {
            // 根据heroNode在City中的索引来确定英雄索引
            var city = App.dungeonBattleMgr.city;
            if (city) {
              var heroItems = city.heros;
              var index = heroItems.indexOf(this);
              if (index >= 0) {
                this._heroIndex = index + 1;
                // 从待命列表中查找对应索引的英雄
                var standbyHeros = App.dungeonBattleMgr.standbyHeros;
                for (var _iterator = _createForOfIteratorHelperLoose(standbyHeros.values()), _step; !(_step = _iterator()).done;) {
                  var _hero = _step.value;
                  if (_hero.citySlotIndex === this._heroIndex) {
                    this._hero = _hero;
                    break;
                  }
                }

                // 如果待命列表中没有，尝试从已部署列表中查找
                if (!this._hero) {
                  var deployedHeros = App.dungeonBattleMgr.deployedHeroes;
                  for (var _iterator2 = _createForOfIteratorHelperLoose(deployedHeros.values()), _step2; !(_step2 = _iterator2()).done;) {
                    var hero = _step2.value;
                    if (hero.citySlotIndex === this._heroIndex) {
                      this._hero = hero;
                      break;
                    }
                  }
                }
              }
            }
          }

          // 如果找到了Hero，设置其citySlotIndex（如果还没有设置）
          if (this._hero && this._heroIndex > 0 && this._hero.citySlotIndex === 0) {
            this._hero.citySlotIndex = this._heroIndex;
          }

          // 更新初始状态
          this.updateHeroState();
        };
        _proto.update = function update(deltaTime) {
          if (!this._hero) {
            // 如果还没有找到Hero，继续尝试查找
            if (this.heroNode) {
              this.initHero();
            }
            return;
          }

          // 更新英雄状态显示
          this.updateHeroState();

          // 如果英雄死亡，更新倒计时
          if (this._hero.isDead && this._hero.reviveCD > 0) {
            this.updateReviveCountdown(deltaTime);
          }
        }

        /**
         * 更新英雄状态显示
         */;
        _proto.updateHeroState = function updateHeroState() {
          if (!this._hero) {
            // 如果没有Hero，隐藏状态和时间
            this.stateLab.node.active = false;
            this.timeLab.node.active = false;
            return;
          }

          // 如果英雄已出战（不在待命状态），隐藏状态和时间
          if (!this._hero.isWaiting) {
            this.stateLab.node.active = false;
            this.timeLab.node.active = false;
            return;
          }

          // 英雄在待命状态，显示状态
          this.stateLab.node.active = true;

          // 检查英雄是否死亡且倒计时未结束
          if (this._hero.isDead && this._hero.reviveCD > 0) {
            // 英雄死亡且倒计时未结束：显示"休整中"，红色，显示倒计时
            this.stateLab.string = "休整中";
            this.stateLab.color = color(255, 62, 62); // #FF3E3E
            this.timeLab.node.active = true;
          } else {
            // 英雄未死亡或倒计时已结束：显示"可出战"，青色，隐藏倒计时
            this.stateLab.string = "可出战";
            this.stateLab.color = color(70, 255, 248); // #46FFF8
            this.timeLab.node.active = false;
          }
        }

        /**
         * 更新复活倒计时
         */;
        _proto.updateReviveCountdown = function updateReviveCountdown(_deltaTime) {
          if (!this._hero || !this._hero.isDead) {
            this.timeLab.node.active = false;
            return;
          }

          // Hero.onUpdate 已经在更新 reviveCD，这里只需要读取并显示
          var remainingTime = Math.max(0, this._hero.reviveCD);

          // 格式化时间显示（MM:SS）
          var minutes = Math.floor(remainingTime / 60);
          var seconds = Math.floor(remainingTime % 60);
          this.timeLab.string = minutes.toString().padStart(2, "0") + ":" + seconds.toString().padStart(2, "0");

          // 倒计时结束，英雄可以出战
          if (remainingTime <= 0) {
            // 更新状态显示（Hero.onUpdate 已经处理了 reviveCD 的更新）
            this.updateHeroState();
          }
        }

        /**
         * 设置Hero实例（外部调用）
         */;
        _proto.setHero = function setHero(hero) {
          this._hero = hero;
          if (hero) {
            this._heroIndex = hero.citySlotIndex || 0;
          }
          this.updateHeroState();
        }

        /**
         * 当英雄死亡时，将Hero节点移回heroNode
         */;
        _proto.onHeroDead = function onHeroDead() {
          if (!this._hero || !this.heroNode) return;

          // 将Hero节点移回heroNode
          if (this._hero.node && this._hero.node.parent !== this.heroNode) {
            var worldPos = this._hero.node.worldPosition.clone();
            this._hero.node.setParent(this.heroNode);
            this._hero.node.setWorldPosition(worldPos);
          }

          // 更新状态显示
          this.updateHeroState();
        };
        return BattleHeroStancesItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "yinying", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "heroNode", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "stateLab", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "timeLab", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMainView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './ModuleDef.ts', './MonitorType.ts', './ModuleContext.ts', './UIBase.ts', './BattleMainViewCtrl.ts'], function (exports) {
  var _inheritsLoose, cclegacy, App, ModuleDef, MonitorType, ModuleContext, UIBase, BattleMainViewCtrl;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      App = module.App;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      ModuleContext = module.ModuleContext;
    }, function (module) {
      UIBase = module.UIBase;
    }, function (module) {
      BattleMainViewCtrl = module.BattleMainViewCtrl;
    }],
    execute: function () {
      cclegacy._RF.push({}, "81d44K+XPBOT7p7d2FzBe2b", "BattleMainView", undefined);
      var BattleMainView = exports('BattleMainView', /*#__PURE__*/function (_UIBase) {
        _inheritsLoose(BattleMainView, _UIBase);
        function BattleMainView() {
          return _UIBase.call(this, BattleMainView.custom) || this;
        }
        var _proto = BattleMainView.prototype;
        _proto.onCreated = function onCreated(guanqiaId, dungeonInfoOrCallback, callBack) {
          console.warn(">>>>>>>>>> AutoFight BattleMainView onCreated", guanqiaId, dungeonInfoOrCallback, callBack);
          _UIBase.prototype.onCreated.call(this);
          var comp = this.node.getComponent(BattleMainViewCtrl);

          // 处理参数兼容性：可能是 (dungeonId, callback) 或 (dungeonId, dungeonInfo, callback)
          var dungeonInfo = null;
          if (dungeonInfoOrCallback instanceof Function) ;else if (dungeonInfoOrCallback) {
            // 新格式：(dungeonId, dungeonInfo, callback)
            dungeonInfo = dungeonInfoOrCallback;
          }
          comp.init(guanqiaId, dungeonInfo);
          App.monitorMgr.addEventListener(MonitorType.battle_flow_back_home, this._onEventBattleFlowBackHome, this);
        };
        _proto.onDispose = function onDispose() {
          console.warn("######### AutoFight BattleMainView onDispose() ");
          _UIBase.prototype.onDispose.call(this);
          App.monitorMgr.removeEventListener(MonitorType.battle_flow_back_home, this._onEventBattleFlowBackHome, this);
        }

        /**
         * 事件消息： 战斗 —— 流程 —— 返回主界面
         */;
        _proto._onEventBattleFlowBackHome = function _onEventBattleFlowBackHome() {
          App.battleMgr.onExit();
          // App.autoFightManager.exitAutoJump();
          this.onClose();
        };
        return BattleMainView;
      }(UIBase));
      BattleMainView.custom = {
        prefab: "prefabs/scene/BattleMainView",
        binding: {}
      };
      ModuleContext.attachModule(BattleMainView, ModuleDef.GAME_BATTLE_B);
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMainViewCtrl.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MonitorType.ts', './BattleDefine.ts', './DBRecord.ts', './BattleMap.ts', './BattleMiniMapCtrl.ts', './BattleCtrlView.ts', './BattleUIView.ts', './PlayerCamera.ts', './App.ts', './City.ts', './TeamMgr.ts', './UtilGame.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, Node, Sprite, sp, Label, tween, Component, MonitorType, GameBattle, DBRecord, BattleMap, BattleMiniMapCtrl, BattleCtrlView, BattleUIView, PlayerCamera, App, City, TeamMgr, UtilGame;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      Sprite = module.Sprite;
      sp = module.sp;
      Label = module.Label;
      tween = module.tween;
      Component = module.Component;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      BattleMap = module.BattleMap;
    }, function (module) {
      BattleMiniMapCtrl = module.BattleMiniMapCtrl;
    }, function (module) {
      BattleCtrlView = module.BattleCtrlView;
    }, function (module) {
      BattleUIView = module.BattleUIView;
    }, function (module) {
      PlayerCamera = module.PlayerCamera;
    }, function (module) {
      App = module.App;
    }, function (module) {
      City = module.City;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      UtilGame = module.UtilGame;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _dec18, _dec19, _dec20, _dec21, _dec22, _dec23, _dec24, _dec25, _dec26, _dec27, _dec28, _dec29, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _descriptor15, _descriptor16, _descriptor17, _descriptor18, _descriptor19, _descriptor20, _descriptor21, _descriptor22, _descriptor23, _descriptor24, _descriptor25, _descriptor26, _descriptor27, _descriptor28;
      cclegacy._RF.push({}, "ccb1cw9AYdPEqiew7dyIOzE", "BattleMainViewCtrl", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleMainViewCtrl = exports('BattleMainViewCtrl', (_dec = ccclass("BattleMainViewCtrl"), _dec2 = property({
        type: Node
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Node
      }), _dec5 = property({
        type: Node
      }), _dec6 = property({
        type: Node
      }), _dec7 = property({
        type: Node
      }), _dec8 = property({
        type: PlayerCamera
      }), _dec9 = property({
        type: BattleCtrlView
      }), _dec10 = property({
        type: BattleMap
      }), _dec11 = property({
        type: BattleUIView
      }), _dec12 = property({
        type: City
      }), _dec13 = property({
        type: Node
      }), _dec14 = property({
        type: Node
      }), _dec15 = property({
        type: Sprite
      }), _dec16 = property({
        type: Node
      }), _dec17 = property({
        type: sp.Skeleton
      }), _dec18 = property({
        type: sp.Skeleton
      }), _dec19 = property({
        type: sp.Skeleton
      }), _dec20 = property({
        type: Node
      }), _dec21 = property({
        type: Node
      }), _dec22 = property({
        type: Node
      }), _dec23 = property({
        type: Node
      }), _dec24 = property({
        type: Node
      }), _dec25 = property({
        type: Node
      }), _dec26 = property({
        type: Node
      }), _dec27 = property({
        type: BattleMiniMapCtrl
      }), _dec28 = property({
        type: Node
      }), _dec29 = property({
        type: Label
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleMainViewCtrl, _Component);
        function BattleMainViewCtrl() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "monsterUiLayer", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "warningLayer", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "roleLayer", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bulletLayer", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "underBulletLayer", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "effectLayer", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "playerCamera", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleCtrlView", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleMap", _descriptor9, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleUIView", _descriptor10, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleCity", _descriptor11, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "spineWarning", _descriptor12, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroWarning", _descriptor13, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroBody", _descriptor14, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "fallingLayer", _descriptor15, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "effectBarLight", _descriptor16, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "effectEye", _descriptor17, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "spineXieShenKaiSa", _descriptor18, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "nodeParticleBar", _descriptor19, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleBg", _descriptor20, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bossHpBarCurrent", _descriptor21, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bossHpBarCurrentParti", _descriptor22, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bossHpBarBG", _descriptor23, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bossHpTips", _descriptor24, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bossName", _descriptor25, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "miniMapCtrl", _descriptor26, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "imgBattleProgressBg", _descriptor27, _assertThisInitialized(_this));
          /** 疲劳值 */
          _initializerDefineProperty(_this, "lbTired", _descriptor28, _assertThisInitialized(_this));
          /**自动战斗UI */
          // @property({ type: BattleAutoFightUI })
          // public battleAutoFightUI: BattleAutoFightUI = null;
          _this.boosHpList = [];
          _this._meiGuanNum = 0;
          _this._cur_progress_limit = 0;
          _this._total_progress_limit = 0;
          _this._imgBattleProgressWidth = 216;
          _this.dungeonId = 0;
          _this.dungeonType = 1;
          _this.imgPregressArray = ["10", "11", "12"];
          //['04', '05', '06', '08', '10', '11', '12'];
          _this._lastBGProgress = null;
          _this._hpDuration = 0.2;
          _this._hasBoss = false;
          _this._isPush = false;
          _this._currentMonster = void 0;
          /** 更新体力数值定时器 */
          _this.updateTiLiTimer = null;
          /** 初始体力值 */
          _this.initTili = 0;
          return _this;
        }
        var _proto = BattleMainViewCtrl.prototype;
        _proto.hasBoss = function hasBoss() {
          return this._hasBoss;
        };
        _proto.onLoad = function onLoad() {};
        _proto.start = function start() {
          // BattleBigMap.getInstance().initDebugPathSprite(this.node.getChildByName('DebugSprite'));
          // BattleBigMap.getInstance().initDebugPhysicsSprite(this.node.getChildByName('DebugSpritePhysics'));
          App.battleMgr.battleMainViewCtrl = this;
          // App.battleMgr.onEnter();
          // this.battleUIView.initSkillItems();
          // this.init()

          App.dungeonBattleMgr.battleMainViewCtrl = this;
          App.monitorMgr.addEventListener(MonitorType.battle_monster_die, this.onMonsterDie, this);
          App.monitorMgr.addEventListener(MonitorType.battle_update_buff_ui, this.onUpdateBuffUi, this);
          var fbr = App.battleMgr.getFbCfg(this.dungeonId);
          var spawnConfigs = App.battleMgr.initFbMonsterSpawnCfg(fbr.id);
          var config = {
            dungeonId: this.dungeonId,
            dungeonType: this.dungeonType,
            cityDurability: fbr.zhucheng_hp,
            militaryOrders: fbr.junling,
            heroes: TeamMgr.inst.currFormation.heros,
            soldiers: TeamMgr.inst.currFormation.soldiers,
            spawnConfigs: spawnConfigs
          };

          // this.spineWarning.setCompleteListener(() => {
          //     this.spineWarning.node.active = false;
          // });

          // const playerCamera = this.playerCamera.camera;
          // playerCamera.orthoHeight = 830;
          this.playerCamera.updateSet();
          if (!this._isPush) {
            App.dungeonBattleMgr.initBattle(config);
          }
        };
        _proto.onEnable = function onEnable() {
          // this.battleMiJingB = null;
          this.scheduleOnce(function () {
            // App.battleMgr.roleCtrl.player?._buffBox.triggerEventBuff(GameBattle.EventBuffId.enterBattle);
          }, 1.0);
        }

        /**
         * 初始化关卡
         * @param guanqiaId 关卡ID
         * @param dungeonInfo 推送的副本信息（可选）
         */;
        _proto.init = function init(guanqiaId, dungeonInfo) {
          App.dungeonBattleMgr.battleMainViewCtrl = this;
          this.dungeonId = guanqiaId;
          var dbr = DBRecord.fetchId("Fb", guanqiaId);
          this._total_progress_limit = dbr.zhucheng_hp;
          this.spineWarning.active = false;
          this._hasBoss = false;

          // 如果有推送的副本信息，使用推送的数据初始化战斗
          if (dungeonInfo) {
            this._isPush = true;
            this.initBattleWithPushInfo(dungeonInfo);
          }
        }

        /**
         * 使用推送的副本信息初始化战斗
         * @param dungeonInfo 推送的副本信息
         */;
        _proto.initBattleWithPushInfo = function initBattleWithPushInfo(dungeonInfo) {
          // 从推送信息中获取战斗数据
          var waveIndex = dungeonInfo.wave_times || 0;
          var moraleValue = dungeonInfo.shiqi_val || 0;
          var pushUnits = dungeonInfo.units || [];
          var pushSoldiers = dungeonInfo.soldiers || [];
          App.log.logBusiness("\u7EE7\u7EED\u6218\u6597\uFF1A\u526F\u672CID=" + dungeonInfo.dungeon_id + ", \u6CE2\u6570=" + waveIndex + ", \u58EB\u6C14=" + moraleValue);

          // 从当前编队获取英雄
          var currFormation = TeamMgr.inst.currFormation;
          var heroes = [];
          if (currFormation && currFormation.heros) {
            heroes = currFormation.heros;
          }

          // 从当前编队获取士兵
          var soldiers = [];
          if (currFormation && currFormation.soldiers) {
            soldiers = currFormation.soldiers;
          }

          // 获取怪物刷新配置
          var fbr = App.battleMgr.getFbCfg(dungeonInfo.dungeon_id);
          var spawnConfigs = App.battleMgr.initFbMonsterSpawnCfg(fbr.id);

          // 初始化战斗配置
          var config = {
            dungeonId: dungeonInfo.dungeon_id,
            dungeonType: GameBattle.GuanQiaType.MainLine,
            cityDurability: fbr.zhucheng_hp,
            militaryOrders: fbr.junling,
            heroes: heroes,
            soldiers: soldiers,
            spawnConfigs: spawnConfigs,
            // 继续战斗的特殊参数
            continueFromWave: waveIndex,
            initialMorale: moraleValue,
            pushUnits: pushUnits,
            pushSoldiers: pushSoldiers
          };

          // 保存推送的士兵信息到DungeonBattleMgr供后续使用
          App.dungeonBattleMgr.setPushSoldierInfo(pushSoldiers);

          // 初始化战斗
          App.dungeonBattleMgr.initBattle(config);
        }

        /**
         * 退出战场
         */;
        _proto.onExit = function onExit() {
          // if (this.battleMuZhuang) {
          //     this.battleMuZhuang = null;
          // }
          // if (this.battleJingJiChang) {
          //     this.battleJingJiChang = null;
          // }
          App.dungeonBattleMgr.reset();
          if (this.updateTiLiTimer) {
            App.scheduleMgr.unschedule(this.updateTiLiTimer);
            this.updateTiLiTimer = null;
          }
        };
        _proto.onDestroy = function onDestroy() {
          App.monitorMgr.removeEventListener(MonitorType.battle_monster_die, this.onMonsterDie, this);
          App.monitorMgr.removeEventListener(MonitorType.battle_update_buff_ui, this.onUpdateBuffUi, this);
        };
        _proto.update = function update(deltaTime) {
          App.battleMgr.update(deltaTime);
          App.dungeonBattleMgr.update(deltaTime);
        };
        _proto.onMonsterDie = function onMonsterDie(monster, attrUser) {
          monster._monsterAI.pause = true;
          App.dungeonBattleMgr.handleMonsterDead(monster.uid, attrUser);
        };
        _proto.showBoss = /*#__PURE__*/function () {
          var _showBoss = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(_bossPos) {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!this._hasBoss) {
                    _context.next = 2;
                    break;
                  }
                  return _context.abrupt("return");
                case 2:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function showBoss(_x) {
            return _showBoss.apply(this, arguments);
          }
          return showBoss;
        }();
        _proto.onUpdateBuffUi = function onUpdateBuffUi(_ui_type, _buffId, _icon, _cd, _count, _remove) {};
        _proto.pauseAllAI = function pauseAllAI() {
          // boss._monsterAI.pause = true;
          // player.pause = true;
        };
        _proto.showBattleUI = function showBattleUI(val) {
          if (val === void 0) {
            val = true;
          }
          this.node.getChildByPath("BattleCtrlView").active = val;
          this.node.getChildByPath("BattleUIView/under/btnDrug").active = val;
        }
        /**
         *  播放出场动画
         * @param type hero、monster
         * @returns
         */;
        _proto.showSpineWarning = function showSpineWarning(type, hero_id) {
          var node = this.spineWarning;
          if (type === "monster") {
            this.spineWarning.active = true;
          } else {
            node = this.heroWarning;
            UtilGame.loadHeroHeadIcon(this.heroBody, hero_id, "_list");
          }

          //从左边出来，停留1秒后慢慢透明为0，然后隐藏掉
          if (!node) return;
          node.active = true;
          node.opacity = 255;
          node.setPosition(-720, node.position.y);

          // 移动到屏幕中央
          var targetX = 0;
          // 使用cc.Tween或Tween
          tween(node).to(0.3, {
            x: targetX
          }, {
            easing: "sineOut"
          }).delay(1).to(0.5, {
            opacity: 0
          }).call(function () {
            node.active = false;
            node.opacity = 255;
          }).start();
        };
        return BattleMainViewCtrl;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "monsterUiLayer", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "warningLayer", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "roleLayer", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "bulletLayer", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "underBulletLayer", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "effectLayer", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "playerCamera", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "battleCtrlView", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "battleMap", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "battleUIView", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "battleCity", [_dec12], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "spineWarning", [_dec13], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "heroWarning", [_dec14], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "heroBody", [_dec15], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor15 = _applyDecoratedDescriptor(_class2.prototype, "fallingLayer", [_dec16], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor16 = _applyDecoratedDescriptor(_class2.prototype, "effectBarLight", [_dec17], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor17 = _applyDecoratedDescriptor(_class2.prototype, "effectEye", [_dec18], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor18 = _applyDecoratedDescriptor(_class2.prototype, "spineXieShenKaiSa", [_dec19], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor19 = _applyDecoratedDescriptor(_class2.prototype, "nodeParticleBar", [_dec20], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor20 = _applyDecoratedDescriptor(_class2.prototype, "battleBg", [_dec21], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor21 = _applyDecoratedDescriptor(_class2.prototype, "bossHpBarCurrent", [_dec22], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor22 = _applyDecoratedDescriptor(_class2.prototype, "bossHpBarCurrentParti", [_dec23], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor23 = _applyDecoratedDescriptor(_class2.prototype, "bossHpBarBG", [_dec24], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor24 = _applyDecoratedDescriptor(_class2.prototype, "bossHpTips", [_dec25], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor25 = _applyDecoratedDescriptor(_class2.prototype, "bossName", [_dec26], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor26 = _applyDecoratedDescriptor(_class2.prototype, "miniMapCtrl", [_dec27], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor27 = _applyDecoratedDescriptor(_class2.prototype, "imgBattleProgressBg", [_dec28], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor28 = _applyDecoratedDescriptor(_class2.prototype, "lbTired", [_dec29], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMap.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Utils.ts', './Item_BattleMap.ts', './DBRecord.ts', './MonitorType.ts', './BattleDefine.ts', './BattleBigMap.ts', './ModuleDef.ts', './GameConfig.ts', './App.ts', './BattleUtil.ts'], function (exports) {
  var _inheritsLoose, _createForOfIteratorHelperLoose, _createClass, cclegacy, _decorator, Vec3, Component, Utils, Item_BattleMap, DBRecord, MonitorType, GameBattle, BattleBigMap, ModuleDef, GameConfig, App, AxingManager;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Vec3 = module.Vec3;
      Component = module.Component;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      Item_BattleMap = module.Item_BattleMap;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      BattleBigMap = module.BattleBigMap;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      App = module.App;
    }, function (module) {
      AxingManager = module.AxingManager;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "37263d/r85Kbrfd+gSc2wy5", "BattleMap", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleMap = exports('BattleMap', (_dec = ccclass("BattleMap"), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleMap, _Component);
        function BattleMap() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _this._owner = void 0;
          _this._curGrid = null;
          _this._gridWidth = 0;
          _this._gridHeight = 0;
          _this._mapData = {};
          return _this;
        }
        var _proto = BattleMap.prototype;
        _proto.getCurGridSize = function getCurGridSize() {
          return this._curGrid.tiledMap.getTileSize();
        };
        _proto.getCurMapSize = function getCurMapSize() {
          return this._curGrid.tiledMap.getMapSize();
        };
        _proto.start = function start() {};
        _proto.onDisable = function onDisable() {
          this._owner = null;
          this._curGrid = null;
          if (App.battleMgr.guanQiaType === GameBattle.GuanQiaType.MiJingB) {
            var node = this.node.getChildByName("MijingBMap");
            if (node) {
              node.destroy();
            }
          }
          for (var _iterator = _createForOfIteratorHelperLoose(this.node.children), _step; !(_step = _iterator()).done;) {
            var _node = _step.value;
            var comp = _node.getComponent(Item_BattleMap);
            comp && (comp.tiledMap.tmxAsset = null);
          }
          this.node.removeAllChildren();
          Item_BattleMap.releaseMap();
        };
        _proto.init = function init(owner) {
          this.node.removeAllChildren();
          this._owner = owner;
          BattleBigMap.getInstance().initDebugLayer(this.node.parent.getChildByName("bgDebug"));
          var born_map = this.initMapData(App.battleMgr.diMao);
          var _this$getMapGrid = this.getMapGrid(born_map.res, born_map.id, true),
            bornGrid = _this$getMapGrid[0],
            comp = _this$getMapGrid[1];
          // bornGrid.setPosition(this.node.uiTransform.convertToWorldSpaceAR(v3(0,0,0)));
          bornGrid.setPosition(0, 0, 0);
          this._curGrid = bornGrid.getComponent(Item_BattleMap);
          var gridSize = this._curGrid.tiledMap.getTileSize();
          this._gridWidth = this._curGrid.map_width * gridSize.width;
          this._gridHeight = this._curGrid.map_height * gridSize.height;
          BattleBigMap.getInstance().clearMapPhysicsData();
          AxingManager.getInstance().clearCache();
          BattleBigMap.getInstance().addMapPhysicsData(0, 0, this._curGrid.tiledMap, born_map.res);
          App.mapMgr.setMap(this._curGrid.tiledMap, true, owner.node, born_map.id);
          App.battleMgr.battleNpcCtrl.enterNewMap(this._curGrid.node.uuid, this._curGrid.diKuaiId, this._curGrid.tiledMap);
          var worldPos = App.mapMgr.getBornPosition();
          this._owner.node.setWorldPosition(worldPos);
          App.battleMgr.setBattleBg(worldPos, App.battleMgr.diMao);
          console.log("this.node.uiTransform.convertToWorldSpaceAR(new Vec3(0,0,0))", this.node.uiTransform.convertToWorldSpaceAR(new Vec3(0, 0, 0)));
          //初始化小地图
          App.monitorMgr.dispatchEvent(MonitorType.battle_init_minimap, born_map.res, this._owner.node.worldPosition);
          this.scheduleOnce(function () {
            App.mapMgr.addMapWayPoint(comp.tiledMap, born_map.id);
          }, 0);
          this.setNextMapgrid();
        };
        _proto.lateUpdate = function lateUpdate(dt) {
          if (!this._owner || !this._curGrid) return;
          var pos = this._owner.node.worldPosition;
          if (pos.x > this._curGrid.node.worldPosition.x + this._gridWidth || pos.x < this._curGrid.node.worldPosition.x || pos.y > this._curGrid.node.worldPosition.y + this._gridHeight || pos.y < this._curGrid.node.worldPosition.y) {
            //进入到下一个地图块了
            for (var i = 0; i < this.node.children.length; i++) {
              var grid = this.node.children[i];
              var x = grid.worldPosition.x;
              var y = grid.worldPosition.y;
              if (pos.x >= x && pos.x <= x + this._gridWidth && pos.y >= y && pos.y <= y + this._gridHeight) {
                this._curGrid = grid.getComponent(Item_BattleMap);
                App.mapMgr.setMap(this._curGrid.tiledMap, true, this._owner.node, this._curGrid.diKuaiId);
                this.setNextMapgrid();
                App.battleMgr.battleNpcCtrl.enterNewMap(this._curGrid.node.uuid, this._curGrid.diKuaiId, this._curGrid.tiledMap);
                App.mapMgr.setAllWayPointArrivedCurDiKuai();
                App.mapMgr.curDiKuaiIndex = i;
                break;
              }
            }
          }
        };
        _proto.getMapGrid = function getMapGrid(tmxName, diKuaiId, is_born) {
          if (is_born === void 0) {
            is_born = false;
          }
          console.log(">>>>>>>>>>  BattleMap.getMapGrid:", tmxName);
          var mapgGrid = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.item_battleMap);
          this.node.addChild(mapgGrid);
          var comp = mapgGrid.getComponent(Item_BattleMap);
          comp.init(tmxName, is_born, diKuaiId);
          return [mapgGrid, comp];
        };
        _proto.initMapData = function initMapData(diMao) {
          var _App$battleMgr$getMap = App.battleMgr.getMapData(diMao),
            mapData = _App$battleMgr$getMap[0],
            bornMap = _App$battleMgr$getMap[1];
          this._mapData = {};
          this._mapData = mapData;
          var born_map = bornMap;
          var index = Math.floor(Math.random() * born_map.length);
          var map = born_map[index];
          if (GameConfig.DebugInfo.testMapList && GameConfig.DebugInfo.testMapList.length > 0) {
            map = DBRecord.fetchId("DiKuai", GameConfig.DebugInfo.testMapList[0]);
          }
          return map;
        };
        _proto.setNextMapgrid = function setNextMapgrid() {
          if (this._curGrid.hasNext) {
            console.log("战斗地图: 下一地块已生成完毕", this._curGrid.diKuaiId);
            return;
          }
          this._curGrid.hasNext = true;
          var next_in_direction = [0, 5, 8, 7, 6, 1, 4, 3, 2][this._curGrid.out_direction];
          var msps = this._mapData[next_in_direction];
          var index = Utils.GetRandomNum(0, msps.length - 1);
          var direction = [[1], [2, 3, 4], [5], [6, 7, 8]]; // 上 右 下 左
          // let dir_vector = [[0,1],[1,0],[0,-1],[-1,0]]
          var dir_vector = [];
          for (var i = 0; i < direction.length; i++) {
            if (direction[i].indexOf(this._curGrid.out_direction) > -1) {
              dir_vector = [[0, 1], [1, 0], [0, -1], [-1, 0]][i]; // 上 右 下 左
              break;
            }
          }

          // let rand_arr = []
          var pos = this._curGrid.node.getPosition();
          // let dir = rand_arr[Utils.GetRandomNum(0, rand_arr.length-1)]
          // let next_out_direction = direction[dir][Utils.GetRandomNum(0, direction[dir].length-1)]
          var targetMap = msps[index];
          if (GameConfig.DebugInfo.testMapList && GameConfig.DebugInfo.testMapList.length > 0 && BattleMap.testMapListIndex < GameConfig.DebugInfo.testMapList.length - 1) {
            targetMap = DBRecord.fetchId("DiKuai", GameConfig.DebugInfo.testMapList[++BattleMap.testMapListIndex]);
          }
          var tmxName = targetMap.res;
          var _this$getMapGrid2 = this.getMapGrid(tmxName, targetMap.id),
            grid = _this$getMapGrid2[0],
            comp = _this$getMapGrid2[1];
          var x = pos.x + dir_vector[0] * this._gridWidth;
          var y = pos.y + dir_vector[1] * this._gridHeight;
          grid.setPosition(x, y, 0);
          console.log("战斗地图: 下一块地图", tmxName);

          //增加小地图
          App.monitorMgr.dispatchEvent(MonitorType.battle_add_minimap, tmxName, dir_vector);
          BattleBigMap.getInstance().addMapPhysicsData(x, y, comp.tiledMap, tmxName);
          this.scheduleOnce(function () {
            App.mapMgr.addMapWayPoint(comp.tiledMap, targetMap.id);
          }, 0);
        }

        /**
         * 初始化导航
         * @param tiledMap
         */;
        _proto.initAXingData = function initAXingData(tiledMap) {
          var mapHeight = tiledMap.getMapSize().height;
          var mapWidth = tiledMap.getMapSize().width;
          var tiles = tiledMap.getLayer("physicalLayer").tiles;
          AxingManager.getInstance().initMapData_zhangaiwu(mapWidth, mapHeight, tiles);
        };
        _createClass(BattleMap, [{
          key: "curGrid",
          get: function get() {
            return this._curGrid;
          }
        }, {
          key: "gridWidth",
          get: function get() {
            return this._gridWidth;
          }
        }, {
          key: "gridHeight",
          get: function get() {
            return this._gridHeight;
          }
        }]);
        return BattleMap;
      }(Component), _class2.testMapListIndex = 0, _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMapBg.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Node, Sprite, NodePool, Component;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      Sprite = module.Sprite;
      NodePool = module.NodePool;
      Component = module.Component;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _class, _class2, _descriptor, _descriptor2, _descriptor3;
      cclegacy._RF.push({}, "b5495imb3BMkqrKA4Qam5Uh", "BattleMapBg", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleMapBg = exports('BattleMapBg', (_dec = ccclass("BattleMapBg"), _dec2 = property(Node), _dec3 = property(Node), _dec4 = property(Sprite), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleMapBg, _Component);
        function BattleMapBg() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "imgYun", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "nodeYunParent", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "fog", _descriptor3, _assertThisInitialized(_this));
          _this.spYun = [];
          _this._nodePool = new NodePool();
          _this._dt = 0;
          return _this;
        }
        var _proto = BattleMapBg.prototype;
        _proto.start = function start() {
          // let diMao = App.battleMgr.diMao;
          // this.spYun = [];
          // let index = 0;
          // for (var i = 0; i < 4; i++) {
          //     App.resMgr.loadSpriteFrame("battleMap", `map${diMao}/yun${i + 1}`, (err, sp) => {
          //         this._dt = -3;
          //         if (err) return;
          //         index++;
          //         this.spYun[index] && (this.spYun[index] = sp);
          //     });
          // }
          // this.fog.spriteFrame = null;
          // App.resMgr.loadImage(this.fog, "battleMap", `map${diMao}/fog`);
          // for (var i = 0; i < 4; i++) {
          //     var item: Node = instantiate(this.imgYun);
          //     this._nodePool.put(item);
          // }
          // this._nodePool.put(this.imgYun);
        };
        _proto.onDisable = function onDisable() {
          // Tween.stopAllByTag(11111);
          // for (let i = this.nodeYunParent.children.length; i--; ) {
          //     this._nodePool.put(this.nodeYunParent.children[i]);
          // }
        };
        _proto.createYun = function createYun() {
          // if (this._nodePool.size() === 0) {
          //     this._nodePool.put(instantiate(this.imgYun));
          // }
          // let node = this._nodePool.get();
          // let startPoint = v3(this.node.worldPosition.x + this.node.w, this.node.worldPosition.y + Math.random() * (this.node.h / 2));
          // let endPoint = v3(this.node.worldPosition.x, this.node.worldPosition.y + Math.random() * (this.node.h / 2) + this.node.h / 2);

          // this.nodeYunParent.addChild(node);
          // let len = this.spYun.length;
          // node.sprite.spriteFrame = this.spYun[Math.floor(Math.random() * len)];
          // node.setWorldPosition(startPoint);
          // tween(node)
          //     .tag(11111)
          //     .to(36.0, { worldPosition: endPoint })
          //     .call(() => {
          //         this._nodePool.put(node);
          //     })
          //     .start();
        };
        _proto.update = function update(dt) {
          // this._dt -= dt;
          // if (this._dt < 0) {
          //     this.createYun();
          //     this._dt = Math.random() * 10 + 5;
          // }
          // if (App.battleMgr.roleCtrl.player) {
          //     this.fog.node.setWorldPosition(App.battleMgr.roleCtrl.player.node.worldPosition);
          // }
        };
        return BattleMapBg;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "imgYun", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "nodeYunParent", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "fog", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './ModuleDef.ts', './BulletCtrl.ts', './DamageTips.ts', './BattleDefine.ts', './RoleCtrl.ts', './SkillCtrl.ts', './FallingPropCtrl.ts', './UIMgr.ts', './MonitorType.ts', './uiGameLoading.ts', './BattleNpcCtrl.ts', './DBRecord.ts', './GameStateMgr.ts', './BattleGlobalData.ts', './ui_Defeat.ts', './GameConfig.ts', './NetChannelMgr.ts', './Prompt.ts', './Item_BattleMap.ts', './UtilityPlatform.ts', './BattleMainView.ts', './App.ts', './BattleUtil.ts', './UI_MainView.ts', './Layout_UI_MainView.ts', './EventType.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _extends, _createClass, _asyncToGenerator, _regeneratorRuntime, cclegacy, Tween, TweenSystem, Node, view, ModuleDef, BulletCtrl, DamageTips, GameBattle, RoleCtrl, SkillCtrl, FallingPropCtrl, UIMgr, LayerType, MonitorType, uiGameLoading, BattleNpcCtrl, DBRecord, GameState, BattleGlobalData, ui_Defeat, GameConfig, netChannel, Prompt, Item_BattleMap, UtilityPlatform, BattleMainView, App, BattleUtil, UI_MainView, Layout_UI_MainView, EventType;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _extends = module.extends;
      _createClass = module.createClass;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      Tween = module.Tween;
      TweenSystem = module.TweenSystem;
      Node = module.Node;
      view = module.view;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      BulletCtrl = module.BulletCtrl;
    }, function (module) {
      DamageTips = module.DamageTips;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      RoleCtrl = module.RoleCtrl;
    }, function (module) {
      SkillCtrl = module.SkillCtrl;
    }, function (module) {
      FallingPropCtrl = module.FallingPropCtrl;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      uiGameLoading = module.uiGameLoading;
    }, function (module) {
      BattleNpcCtrl = module.BattleNpcCtrl;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      GameState = module.GameState;
    }, function (module) {
      BattleGlobalData = module.BattleGlobalData;
    }, function (module) {
      ui_Defeat = module.ui_Defeat;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      netChannel = module.netChannel;
    }, function (module) {
      Prompt = module.Prompt;
    }, function (module) {
      Item_BattleMap = module.Item_BattleMap;
    }, function (module) {
      UtilityPlatform = module.default;
    }, function (module) {
      BattleMainView = module.BattleMainView;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }, function (module) {
      UI_MainView = module.UI_MainView;
    }, function (module) {
      Layout_UI_MainView = module.Layout_UI_MainView;
    }, function (module) {
      EventType = module.EventType;
    }],
    execute: function () {
      cclegacy._RF.push({}, "60b98bByexNwJ+Wn8zLiSfm", "BattleMgr", undefined);
      var TypeGuanQia = exports('TypeGuanQia', /*#__PURE__*/function (TypeGuanQia) {
        TypeGuanQia[TypeGuanQia["Main"] = 1] = "Main";
        TypeGuanQia[TypeGuanQia["Guide"] = 99] = "Guide";
        return TypeGuanQia;
      }({}));

      /**通关宝箱领取状态 */
      var RewardReceiveState = exports('RewardReceiveState', /*#__PURE__*/function (RewardReceiveState) {
        RewardReceiveState[RewardReceiveState["Lock"] = 0] = "Lock";
        RewardReceiveState[RewardReceiveState["CanReceive"] = 1] = "CanReceive";
        RewardReceiveState[RewardReceiveState["Received"] = 2] = "Received";
        return RewardReceiveState;
      }({}));

      /**通关奖励宝箱类型 */
      var RewardChestType = exports('RewardChestType', /*#__PURE__*/function (RewardChestType) {
        RewardChestType[RewardChestType["Fast"] = 0] = "Fast";
        RewardChestType[RewardChestType["Normal"] = 1] = "Normal";
        return RewardChestType;
      }({}));

      /**血月宝箱状态 */
      var BloodMoonBoxState = exports('BloodMoonBoxState', /*#__PURE__*/function (BloodMoonBoxState) {
        BloodMoonBoxState[BloodMoonBoxState["Got"] = 1] = "Got";
        BloodMoonBoxState[BloodMoonBoxState["Lock"] = 2] = "Lock";
        BloodMoonBoxState[BloodMoonBoxState["Exchaged"] = 3] = "Exchaged";
        return BloodMoonBoxState;
      }({}));
      var BattleMgr = exports('BattleMgr', /*#__PURE__*/function () {
        function BattleMgr() {
          this._roleCtrl = new RoleCtrl();
          this._bulletCtrl = new BulletCtrl();
          this._skillCtrl = new SkillCtrl();
          this._battleMainViewCtrl = void 0;
          this._battleNpcCtrl = new BattleNpcCtrl();
          this._playerCamera = void 0;
          /** 伤害提示UI唯一id生成器 */
          this._damageTipsUIDCounter = 0;
          /** 伤害提示UI列表 */
          this._damgeTipsMap = new Map();
          this.fallingPropCtrl = new FallingPropCtrl();
          this.guanka_list = [];
          this._curGuanQiaId = 0;
          /** 挑战主线关卡ID */
          this.challengeGuanQiaId = 0;
          /** 挑战主线关卡ID 缓存, 用于进入其他副本后还原主线副本ID */
          this.challengeGuanQiaIdCatch = 0;
          this.guankaUnLock = false;
          //是否解锁关卡
          this.tongguanGuanQiaId = -1;
          //最新通关的关卡ID   新增-1的时候表示协议还没到
          this.lastTgGuanQiaId = 0;
          //上一次通关的关卡ID
          this.lastChallengeIsNewest = true;
          //上一次挑战的是否是最新主线关卡
          this.lastChallengeQuanQiaId = 0;
          //上一次挑战的主线关卡
          /** 所有关卡列表 */
          this.allGuanQiaList = void 0;
          /** 自动跳转挑战关卡双倍 */
          this._autoJumpShuangBei = false;
          /** 自动跳转挑战关卡倍数 */
          this._autoJumpBeishu = 0;
          this._pause = false;
          this.diMao = 0;
          this._runningActions = [];
          /** 装备副本ID */
          this.zbfb_id = 0;
          /** 装备副本次数 */
          this.zbfb_num = 0;
          /** 卡皮巴拉副本ID */
          this.kpblfb_id = 0;
          /** 卡皮巴拉副本次数 */
          this.kpblfb_num = 0;
          /** 土拨鼠副本次数 */
          this.fsfb_num = 0;
          /** 秘境B副本ID */
          this.miJingBfb_id = 0;
          /** 秘境A副本ID */
          this.miJingAfb_id = 0;
          this.globalData = new BattleGlobalData();
          this.guanQiaType = GameBattle.GuanQiaType.None;
          this.reviveCount = 0;
          this.data36012 = null;
          this.isTouZiDream = false;
          /** 幸运宝箱当前领取次数 */
          this.cur_xybx_times = 0;
          /** 幸运宝箱最大领取次数 */
          this.max_xybx_times = 0;
          /**战斗过关协议数据 */
          this.battle_end_msg = void 0;
          /** 最大同时存在的伤害提示数量 */
          this.MAX_DAMAGE_TIPS = 50;
          /** 当前活跃的伤害提示数量 */
          this._activeDamageTipsCount = 0;
          /**血月模式信息 */
          this.blood_moon_msg = void 0;
          /**血月模式宝箱 */
          this.blood_moon_box_list = [];
          /** 血月刷怪定时器 */
          this._blood_moon_monster_timer = null;
          /** 血月消耗的材料总数 */
          this._blood_moon_cost_count = 0;
          /** 血月耗材id */
          this._blood_moon_cost_item_id = 1031;
          // 帧管理相关
          this._frameCounter = 0;
          // 主线副本计时相关
          this._mainFBTimer = null;
          this.FB_TIME_INTERVAL = 1;
          this._bossIsDead = false;
          this._isInBattle = false;
          //图鉴加成
          this._mTuJianAttr = {};
          /** 进入过战斗 */
          this.enterBattleFlag = false;
          this.commomUiTimer = [false, false, false];
          /**
           * 本次战斗随机boss id
           */
          this.curRandomBossId = 0;
          this.allBulletIdList = [];
          /** 新手引导战斗子弹资源列表 */
          this.GuideBattleBulletResList = ["effect_bullet_fashi_shengguangrensuxuanfeng", "effect_Monster_YuanZhengJunGongNuShou_Bullet", "effect_bullet_fashi_luoleishu", "effect_dummy_leimingchuxiang", "effect_dummy_tiannushenfa"];
          /** 战斗子弹资源列表补漏 */
          this.BulletResList = {
            // [GameBattle.RoleJob.fashi]: [],
            // [GameBattle.RoleJob.taidao]: ["effect_bullet_taidao_dujianqi", "effect_bullet_taidao_chaogaosutuxi02"]
          };
          this.noLoadBulletIdList = new Set();
        }
        var _proto = BattleMgr.prototype;
        /**
         * 获取当前帧组(0或1)
         */
        _proto.getCurrentFrame = function getCurrentFrame() {
          return this._frameCounter;
        };
        _proto.init = function init() {
          // this._roleCtrl.init();
          // this._bulletCtrl.initPool();
          // this._roleCtrl.initPool();
          // this._skillCtrl.init();
          // this._bulletCtrl.init();
          // this._battleNpcCtrl.init();
          // this._runningActions = [];
          // this.challengeGuanQiaId = 0;
          // this.challengeGuanQiaIdCatch = -1;
          // this.tongguanGuanQiaId = -1;
          // App.monitorMgr.addEventListener(MonitorType.web_battle_pass_List, this.sc_battle_pass_List, this);
          // App.monitorMgr.addEventListener(MonitorType.web_battle_start, this.sc_battle_start, this);
          // App.monitorMgr.addEventListener(MonitorType.game_set, this._onGameSet, this);
          // App.monitorMgr.addEventListener(MonitorType.web_xybx_times_86001, this.sc_xybx_times_86001, this);
          // App.monitorMgr.addEventListener(MonitorType.web_blood_moon_info, this.sc_blood_moon, this);
          // App.monitorMgr.addEventListener(MonitorType.web_pass_reward, this.recGuanQiaAward0, this);
          // App.monitorMgr.addEventListener(MonitorType.web_battle_zhuangbei_fuben, this.sc_battle_zhuangbei_fuben_36011, this);
          // App.monitorMgr.addEventListener(MonitorType.web_battle_trial_ticket, this.sc_36012, this);
          // App.monitorMgr.addEventListener(MonitorType.rec_pass_data3, this.recPassData3, this);
          // // 预创建伤害提示对象池
          // App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.itemTMXGrass, {
          //     preloadCount: 10,
          //     maxSize: 20,
          //     autoExpand: true
          // });
          // App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.item_battleMap, {
          //     preloadCount: 10,
          //     maxSize: 20,
          //     autoExpand: true
          // });
          // App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.itemBattleNpc, {
          //     preloadCount: 10,
          //     maxSize: 20,
          //     autoExpand: true
          // });
        };
        _proto.dispose = function dispose() {
          Tween.stopAllByTag(GameBattle.BattleTweenTag);
          this._roleCtrl.dispose();
          this._skillCtrl.dispose();
          this._bulletCtrl.dispose();
          this._battleNpcCtrl.dispose();
          App.monitorMgr.offTarget(this);
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.itemTMXGrass);
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.item_battleMap);
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.itemBattleNpc);
          clearTimeout(this._blood_moon_monster_timer);
        };
        _proto._onGameSet = function _onGameSet(key, val) {
          if (key === "nView" && this._battleMainViewCtrl && this._battleMainViewCtrl.playerCamera) {
            this._battleMainViewCtrl.playerCamera.updateSet();
          }
          if (this._roleCtrl) {
            this._roleCtrl.updtNameShow();
          }
        };
        _proto.sc_battle_pass_List = function sc_battle_pass_List(obj) {
          //登录返回
          this.guanka_list = obj.guanka_list;
          this.tongguanGuanQiaId = 0;
          for (var i = obj.guanka_list.length; i--;) {
            if (this.tongguanGuanQiaId < obj.guanka_list[i].guanka_id) {
              this.tongguanGuanQiaId = obj.guanka_list[i].guanka_id;
            }
          }
          console.error("App.battleMgr.tongguanGuanQiaId;", this.tongguanGuanQiaId);
          if (this.guanka_list.length <= 0) {
            this.lastTgGuanQiaId = 11001;
          }
          if (this.lastTgGuanQiaId === 0) {
            this.lastTgGuanQiaId = this.tongguanGuanQiaId;
            this.guankaUnLock = false;
          } else {
            if (this.lastTgGuanQiaId === this.tongguanGuanQiaId) {
              this.guankaUnLock = false;
              if (this.lastTgGuanQiaId === 11001) {
                this.guankaUnLock = true;
              }
            } else if (this.lastTgGuanQiaId > this.tongguanGuanQiaId) {
              this.guankaUnLock = false;
            } else {
              this.guankaUnLock = true;
            }
          }
          this.curGuanQiaId = this.tongguanGuanQiaId;
          if (!this.allGuanQiaList) {
            this.allGuanQiaList = DBRecord.fetchAll("GuanQia");
          }

          // let temp = 999999999999;
          // let list = [];
          for (var _iterator = _createForOfIteratorHelperLoose(this.allGuanQiaList), _step; !(_step = _iterator()).done;) {
            var _GuanQia = _step.value;
            if (_GuanQia.type === TypeGuanQia.Main && _GuanQia.id > this.curGuanQiaId) {
              this.curGuanQiaId = _GuanQia.id;
              break;
            }
          }

          // for (let guanqia of list) {
          //     if (guanqia.id < temp) {
          //         temp = guanqia.id;
          //     }
          // }
          // this._curGuanQiaId = temp;
          console.log("已通关关卡信息列表===", this.curGuanQiaId);
          App.lockMgr.initItemFuncUnlock();

          //SOP上报
          var action_id = 0;
          if (this.tongguanGuanQiaId >= 18050) {
            action_id = 215;
          } else if (this.tongguanGuanQiaId >= 18001) {
            action_id = 214;
          } else if (this.tongguanGuanQiaId >= 17120) {
            //关卡到达地狱120
            action_id = 206;
          } else if (this.tongguanGuanQiaId === 17080) {
            action_id = 213;
          } else if (this.tongguanGuanQiaId === 17050) {
            action_id = 212;
          } else if (this.tongguanGuanQiaId === 17020) {
            action_id = 211;
          } else if (this.tongguanGuanQiaId >= 17001) {
            //关卡到达地狱1
            action_id = 205;
          } else if (this.tongguanGuanQiaId >= 16001) {
            //关卡到达托娅旧址1
            action_id = 204;
          } else if (this.tongguanGuanQiaId === 15001) {
            action_id = 210;
          } else if (this.tongguanGuanQiaId >= 14001) {
            //关卡到达不灭熔岩1
            action_id = 203;
          }
          if (action_id) {
            UtilityPlatform.getInstance().SOPInfo(action_id);
          }
          // App.autoFightManager.rec30011();
        }

        /**
         * 检查关卡是否解锁
         * @param guanQiaId 关卡id
         * @returns
         */;
        _proto.checkGuanQiaUnlock = function checkGuanQiaUnlock(guanQiaId) {
          return guanQiaId < this.curGuanQiaId;
        };
        _proto.sc_battle_start = function sc_battle_start(obj) {
          if (obj.err_code !== 0) {
            Prompt.popErrorCode(obj.err_code);
            return;
          }
          if (App.battleMgr.guanQiaType !== GameBattle.GuanQiaType.ZhuXian) {
            console.log("不是主线关卡 sc_battle_start===", obj);
            this.fallingPropCtrl.initFallingByGuanQiaId(this.challengeGuanQiaId, obj);
            this._battleNpcCtrl.setZhuangBeiJiaData(obj.guanka_award.equipment_rack_awards, obj.guanka_award.equipment2_rack_awards);
          } else if (App.battleMgr.guanQiaType === GameBattle.GuanQiaType.ZhuXian) {
            if (obj.c_num === 1) {
              this.fallingPropCtrl.initFallingByGuanQiaId(this.challengeGuanQiaId, obj);
              this._battleNpcCtrl.setZhuangBeiJiaData(obj.guanka_award.equipment_rack_awards, obj.guanka_award.equipment2_rack_awards);
            }
          }
        };
        _proto.initPool = function initPool() {
          App.mapMgr.clearMap();
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips, {
            preloadCount: 200,
            maxSize: 200,
            autoExpand: true
          });
          for (var _key in GameBattle.OtherPrefabPath) {
            App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath[_key], {
              preloadCount: 20,
              maxSize: 20,
              autoExpand: true
            });
          }
          for (var i = 3; i < 9; i++) {
            App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "images/effect_FallingProp_trail/effect_FallingProp_trail" + i, {
              preloadCount: 20,
              maxSize: 20,
              autoExpand: true
            });
          }
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/effect/damageNum", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/affected", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/buffEffect", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
        };
        _proto.clearPool = function clearPool() {
          for (var _key2 in GameBattle.OtherPrefabPath) {
            App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath[_key2]);
          }
          for (var i = 3; i < 9; i++) {
            App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "images/effect_FallingProp_trail/effect_FallingProp_trail" + i);
          }
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/effect/damageNum");
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/affected");
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/buffEffect");
        };
        _proto.setPause = function setPause(v) {
          this._pause = v;
          if (v) {
            this._runningActions = TweenSystem.instance.ActionManager.pauseAllRunningActions();
            var popActions = [];
            for (var i = this._runningActions.length; i--;) {
              if (this._runningActions[i] instanceof Node && this._runningActions[i].name === "uiPrompt") {
                popActions.push(this._runningActions[i]);
                this._runningActions.splice(i, 1);
              }
            }
            if (popActions.length > 0) {
              TweenSystem.instance.ActionManager.resumeTargets(popActions);
            }
            if (this._battleMainViewCtrl && this._battleMainViewCtrl.battleMap) this.pauseNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
            App.scheduleMgr.pauseAll();
          } else {
            TweenSystem.instance.ActionManager.resumeTargets(this._runningActions);
            this._runningActions = [];
            if (this._battleMainViewCtrl && this._battleMainViewCtrl.battleMap) this.resumeNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
            App.scheduleMgr.resumeAll();
          }
        }

        /**
         * 暂停节点及其所有子节点
         * @param node
         */;
        _proto.pauseNodeAndChildren = function pauseNodeAndChildren(node) {
          var _this = this;
          // 暂停骨骼动画
          if (node.spine) {
            node.spine.paused = true;
          }
          node.children.forEach(function (child) {
            _this.pauseNodeAndChildren(child);
          });
        }

        /**
         * 恢复节点及其所有子节点
         * @param node
         */;
        _proto.resumeNodeAndChildren = function resumeNodeAndChildren(node) {
          var _this2 = this;
          // 恢复骨骼动画
          if (node.spine) {
            node.spine.paused = false;
          }

          // 遍历并恢复所有子节点
          node.children.forEach(function (child) {
            _this2.resumeNodeAndChildren(child);
          });
        }

        /**
         * 更新
         */;
        _proto.update = function update(dt) {
          if (this._pause) return;

          //console.time('roleCtrl.update');
          this._roleCtrl.update(dt);
          //console.timeEnd('roleCtrl.update');

          this._skillCtrl.update(dt);
          this._bulletCtrl.update(dt);
          this.fallingPropCtrl.update(dt);
          this._frameCounter = 1 - this._frameCounter;
        }

        /**
         * 开始主线副本计时
         */;
        _proto.startMainFBTimer = function startMainFBTimer() {
          var _this3 = this;
          this.bossIsDead = false;
          if (this._mainFBTimer) {
            App.scheduleMgr.unschedule(this._mainFBTimer);
            this._mainFBTimer = null;
          }
          this._mainFBTimer = App.scheduleMgr.schedule(function () {
            if (!_this3._pause && !_this3.bossIsDead) {
              var _this3$_battleMainVie;
              // 使用 BattleUIView 中的时间
              var battleUIView = (_this3$_battleMainVie = _this3._battleMainViewCtrl) == null ? void 0 : _this3$_battleMainVie.battleUIView;
              if (battleUIView) {
                var timeLimit = battleUIView.time_limit;
                var dbTime = battleUIView.time_limit_DB;
                var useTime = Math.floor(dbTime - timeLimit);
                var data = {
                  guanka_id: _this3.challengeGuanQiaId,
                  stay_second: useTime
                };
                netChannel.game.send(MonitorType.send_bt_toServer, data);
              }
            }
          }, this, this.FB_TIME_INTERVAL);
        }

        /**
         * 进入战场
         */;
        _proto.onEnter = function onEnter() {
          this.enterBattleFlag = true;
          this._isInBattle = true;
          this.setPause(false);
          UIMgr.inst.preloadUIBundle(ui_Defeat, function () {
            console.log("预加载战斗失败页面成功");
          });
          this.bossIsDead = false;
          // UIMgr.inst.preloadUIBundle(uiLuckBox, () => {
          //     console.log('预加载转盘页面');
          // });
          this.initPool();
          this.globalData.init();
          this._roleCtrl.onEnter();
          this._skillCtrl.onEnter();
          this._bulletCtrl.onEnter();
          this._battleNpcCtrl.onEnter(this.challengeGuanQiaId);
          this._battleMainViewCtrl.playerCamera.setLockTarget(this.roleCtrl.player.node);
          this._battleMainViewCtrl.playerCamera.updateSet();
          this._battleMainViewCtrl.battleCtrlView.joystickItem.owner = this.roleCtrl.player;
          this._battleMainViewCtrl.battleMap.init(this.roleCtrl.player);

          // 初始化碰撞网格调试渲染器
          if (GameConfig.DebugInfo.useCollisionGrid) {
            CollisionMgr.inst.initDebugRenderer(this._battleMainViewCtrl.node);
          }
          this.playerCamera = this._battleMainViewCtrl.playerCamera;
          App.gameStateMgr.state = GameState.Battle_ZhuxianGuanQia;
          this.playBattleMusic();
          this.reviveCount = 0;

          // 玩家初始化完成后，添加到网格中
          this.roleCtrl.player.initGridPosition();
          this._blood_moon_cost_count = 0;

          // 如果是主线副本,开始计时
          if (this.guanQiaType === GameBattle.GuanQiaType.ZhuXian) {
            this.startMainFBTimer();
          }
          this.roleCtrl.player.initFollowerPos();
          this.roleCtrl.player.initPetPos();
          this.initTuJianAttr();
          this.fallingPropCtrl.onEnter();
        }

        /**
         * 退出战场
         */;
        _proto.onExit = /*#__PURE__*/
        function () {
          var _onExit = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(type, callFunc, openMain) {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (callFunc === void 0) {
                    callFunc = null;
                  }
                  if (openMain === void 0) {
                    openMain = true;
                  }
                  this._isInBattle = false;
                  this.clearPool();
                  // ui.onProgress(0)
                  Tween.stopAllByTag(GameBattle.BattleTweenTag);
                  if (this._battleMainViewCtrl) {
                    if (this._battleMainViewCtrl.battleMap) {
                      this.resumeNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
                    }
                    this._battleMainViewCtrl.battleCtrlView.joystickItem.onEnd();
                    this._battleMainViewCtrl.onExit();
                  }
                  this.guanQiaType = GameBattle.GuanQiaType.None;
                  this._roleCtrl.onExit();
                  this._skillCtrl.onExit();
                  this._bulletCtrl.onExit();
                  this.recoveryAllDamageTips();
                  App.scheduleMgr.clear();
                  if (GameConfig.DebugInfo.useCollisionGrid) {
                    CollisionMgr.inst.clear();
                  }
                  this._battleMainViewCtrl = undefined;
                  this.isTouZiDream = false;
                  this.fallingPropCtrl.onExit();
                  App.soundMgr.clearAllBattleSound();
                  if (this.challengeGuanQiaIdCatch > 0) {
                    this.challengeGuanQiaId = this.challengeGuanQiaIdCatch;
                    this.challengeGuanQiaIdCatch = -1;
                  }
                  // 清理计时器
                  if (this._mainFBTimer) {
                    App.scheduleMgr.unschedule(this._mainFBTimer);
                    this._mainFBTimer = null;
                    this.bossIsDead = false;
                  }
                  this._mTuJianAttr = {};
                  this.curRandomBossId = 0;
                  App.mapMgr.clearMapWayPoint();
                  if (openMain) {
                    _context.next = 25;
                    break;
                  }
                  return _context.abrupt("return");
                case 25:
                  console.warn("######### AutoFight BattleManager.onExit()");
                  _context.next = 28;
                  return this.enterCity(function () {
                    console.warn("######### AutoFight BattleManager.onExit().enterCity().callBack closeAllPanel() ");
                    UIMgr.inst.closeAllPanel(["uiLoading", "uiFunctionUnlock"]);
                    if (callFunc) callFunc();
                  });
                case 28:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function onExit(_x, _x2, _x3) {
            return _onExit.apply(this, arguments);
          }
          return onExit;
        }()
        /**
         * 进入主城
         */;

        _proto.enterCity = /*#__PURE__*/
        function () {
          var _enterCity = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(callback) {
            var ui, progressValues, _loop, i;
            return _regeneratorRuntime().wrap(function _callee2$(_context3) {
              while (1) switch (_context3.prev = _context3.next) {
                case 0:
                  _context3.next = 2;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 2:
                  ui = _context3.sent;
                  if (callback) {
                    callback();
                  }
                  ui.setCloseByHand(true);
                  progressValues = [0.15, 0.25, 0.35, 0.55, 0.65, 0.75, 0.85, 0.92, 0.96, 1.0];
                  _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop(i) {
                    return _regeneratorRuntime().wrap(function _loop$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          setTimeout(function () {
                            ui.onProgress(progressValues[i]);
                            if (i === 9) {
                              ui.onClose();
                              console.warn("######### AutoFight BattleManager.onExit().enterCity() delay i === 9 closeAllPanel() ");
                              UIMgr.inst.closeAllPanel(["uiMain", "uiJingJiChang", "uiFunctionUnlock", "uiPrompt", "uiBlockLayer"]);
                              App.monitorMgr.dispatchEvent(EventType.loading_end_to_mainGame);
                              // App.autoFightManager.closeProgressBar();
                            }
                          }, 100 * i + Math.random() * 100 * i);
                        case 1:
                        case "end":
                          return _context2.stop();
                      }
                    }, _loop);
                  });
                  i = 0;
                case 8:
                  if (!(i < 10)) {
                    _context3.next = 13;
                    break;
                  }
                  return _context3.delegateYield(_loop(i), "t0", 10);
                case 10:
                  i++;
                  _context3.next = 8;
                  break;
                case 13:
                  _context3.next = 15;
                  return UIMgr.inst.openOnce(UI_MainView, LayerType.main, Layout_UI_MainView, null, function () {});
                case 15:
                case "end":
                  return _context3.stop();
              }
            }, _callee2);
          }));
          function enterCity(_x4) {
            return _enterCity.apply(this, arguments);
          }
          return enterCity;
        }()
        /**
         * 播放战斗音乐
         */;

        _proto.playBattleMusic = function playBattleMusic() {
          var soundId = App.soundMgr.getBattleMusicId(App.battleMgr.diMao);
          if (soundId) {
            App.soundMgr.playMusicById(soundId);
          }
        }

        /**
         * 创建伤害提示UI
         * @returns
         */;
        _proto.createDamageTips = function createDamageTips() {
          if (!this._battleMainViewCtrl) return;
          if (this._activeDamageTipsCount >= this.MAX_DAMAGE_TIPS) {
            return null;
          }
          var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips);
          if (!node) return null;
          var tips = node.getComponent(DamageTips);
          tips.node.parent = this._battleMainViewCtrl.effectLayer;
          tips.uid = ++this._damageTipsUIDCounter;
          this._damgeTipsMap.set(tips.uid, tips);
          this._activeDamageTipsCount++;
          return tips;
        }

        /**
         * 回收伤害提示
         */;
        _proto.recoveryDamageTips = function recoveryDamageTips(tips) {
          if (!tips) return;
          this._damgeTipsMap["delete"](tips.uid);
          tips.recovery();
          tips.uid = 0;
          this._activeDamageTipsCount--;
          App.nodePoolMgr.putNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips, tips.node);
        }

        /**
         * 回收所有伤害提示UI
         */;
        _proto.recoveryAllDamageTips = function recoveryAllDamageTips() {
          var _this4 = this;
          this._damgeTipsMap.forEach(function (v) {
            _this4.recoveryDamageTips(v);
          });
          this._damgeTipsMap.clear();
          this._activeDamageTipsCount = 0;
        };
        _proto.moveBattleBg = function moveBattleBg(x, y, playerPos) {
          var _this$_battleMainView;
          if ((_this$_battleMainView = this._battleMainViewCtrl) != null && _this$_battleMainView.battleBg) {
            var pos = this._battleMainViewCtrl.battleBg.position.clone();
            pos.add3f(x, y, 0);
            this._battleMainViewCtrl.battleBg.position = pos;
            //高填充了4倍 宽填充了10倍
            var size = view.getVisibleSize();
            if (playerPos.x > pos.x + this._battleMainViewCtrl.battleBg.w - size.width) {
              this._battleMainViewCtrl.battleBg.x += this._battleMainViewCtrl.battleBg.w * 0.6;
            }
            if (playerPos.x < pos.x + size.width) {
              this._battleMainViewCtrl.battleBg.x -= this._battleMainViewCtrl.battleBg.w * 0.6;
            }
            if (playerPos.y > pos.y + this._battleMainViewCtrl.battleBg.h - size.height / 2) {
              this._battleMainViewCtrl.battleBg.y += this._battleMainViewCtrl.battleBg.h * 0.5;
            }
            if (playerPos.y < pos.y + size.height / 2) {
              this._battleMainViewCtrl.battleBg.y -= this._battleMainViewCtrl.battleBg.h * 0.5;
            }
          }
        }

        /**
         * 更新小地图
         * @param x
         * @param y
         * @param playerPos
         */;
        _proto.moveMiniBattleBG = function moveMiniBattleBG(x, y, playerPos) {
          this._battleMainViewCtrl.updateMiniBGPos(x, y, playerPos);
        }

        /**
         * 设置战场背景
         * @param pos
         * @param diMao
         */;
        _proto.setBattleBg = function setBattleBg(pos, diMao) {
          var _this$_battleMainView2;
          var x = pos.x - this._battleMainViewCtrl.battleBg.w / 2;
          var y = pos.y - this._battleMainViewCtrl.battleBg.h / 2;
          this._battleMainViewCtrl.battleBg.setWorldPosition(x, y, 0);
          App.resMgr.loadImage((_this$_battleMainView2 = this._battleMainViewCtrl) == null || (_this$_battleMainView2 = _this$_battleMainView2.battleBg) == null ? void 0 : _this$_battleMainView2.sprite, "battleMap", "map" + diMao + "/background");
        };
        _proto.getGuankaList = function getGuankaList() {
          return this.guanka_list;
        }

        /**
         * 获取速通奖励领取状态
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaSuTongType = function getGuanQiaSuTongType(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].receive1;
            }
          }
          return 0;
        }

        /**
         * 获取首通奖励领取状态
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaShouTongType = function getGuanQiaShouTongType(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].receive;
            }
          }
          return 0;
        }

        /**
         * 获取关卡最快通关时间
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaFastestPassTime = function getGuanQiaFastestPassTime(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].tg_second;
            }
          }
          return 0;
        };
        _proto.reqGuanQiaAwardAll = function reqGuanQiaAwardAll(tp) {
          var msg = {
            category: tp
          };
          netChannel.game.send(MonitorType.web_pass_reward, msg);
        };
        _proto.reqGuanQiaAwardOne = function reqGuanQiaAwardOne(id, tp) {
          var obj = {
            guanka_id: id,
            category: tp
          };
          netChannel.game.send(MonitorType.web_battle_fast_reward, obj);
        };
        _proto.recGuanQiaAward0 = function recGuanQiaAward0(msg) {
          // if (msg.category === RewardChestType.Fast) {
          //     this.settGuanQiaSuTongType(msg.guanka_id, RewardReceiveState.Received);
          // } else {
          //     this.settGuanQiaShouTongType(msg.guanka_id, RewardReceiveState.Received);
          // }
          // if (msg.category === RewardChestType.Normal) {
          //     for (let dx0 = 0; dx0 < this.guanka_list.length; dx0++) {
          //         let oData = this.guanka_list[dx0];
          //         if (oData.receive === AwardState.Able) {
          //             oData.receive = AwardState.Done;
          //         }
          //     }
          // } else if (msg.category === RewardChestType.Fast) {
          //     for (let dx0 = 0; dx0 < this.guanka_list.length; dx0++) {
          //         let oData = this.guanka_list[dx0];
          //         if (oData.receive1 === AwardState.Able) {
          //             oData.receive1 = AwardState.Done;
          //         }
          //     }
          // }
        };
        _proto.recPassData3 = function recPassData3(msg) {
          for (var dx0 = 0; dx0 < this.guanka_list.length; dx0++) {
            var oData = this.guanka_list[dx0];
            if (oData.id === msg.guanka_id) {
              oData.receive = msg.receive;
              oData.receive1 = msg.receive1;
            }
          }
        }

        /**
         * 设置速通宝箱领取状态
         * @param guanQiaId
         * @param type
         */;
        _proto.settGuanQiaSuTongType = function settGuanQiaSuTongType(guanQiaId, type) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              if (type > this.guanka_list[i].receive1) {
                this.guanka_list[i].receive1 = type;
              }
            }
          }
        }

        /**
         * 设置首通宝箱领取状态
         * @param guanQiaId
         * @param type
         */;
        _proto.settGuanQiaShouTongType = function settGuanQiaShouTongType(guanQiaId, type) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              if (type > this.guanka_list[i].receive) {
                this.guanka_list[i].receive = type;
              }
            }
          }
        };
        _proto.getPassIdMax = function getPassIdMax() {
          return this.tongguanGuanQiaId;
        };
        _proto.getGuanQiaCfg = function getGuanQiaCfg(type, difficulty, map_level) {
          var list = DBRecord.fetchAll("GuanQia");
          for (var i = 0; i < list.length; i++) {
            var cfg = list[i];
            if (cfg.type === type && cfg.difficulty === difficulty && cfg.map_level === map_level) return cfg;
          }
        }

        /**
         * 找出配置表GuanQia中，最大的关卡，也就是最大的ID
         * @returns 最大的关卡ID
         */;
        _proto.findMaxGuanQiaId = function findMaxGuanQiaId() {
          var maxId = 0;
          var guanQiaList = DBRecord.fetchAll("GuanQia");
          for (var i = 0; i < guanQiaList.length; i++) {
            if (guanQiaList[i].type === 1 && guanQiaList[i].id > maxId) {
              maxId = guanQiaList[i].id;
            }
          }
          return maxId;
        };
        _proto.sc_battle_zhuangbei_fuben_36011 = function sc_battle_zhuangbei_fuben_36011(data) {
          var _data$zbfb_id, _data$zbfb_num, _data$kpblfb_id, _data$kpblfb_num, _data$fsfb_num, _data$scfb_id, _data$dnfb_id;
          console.log("sc_battle_zhuangbei_fuben_36011", data);
          this.zbfb_id = (_data$zbfb_id = data.zbfb_id) != null ? _data$zbfb_id : 0;
          this.zbfb_num = (_data$zbfb_num = data.zbfb_num) != null ? _data$zbfb_num : 0;
          this.kpblfb_id = (_data$kpblfb_id = data.kpblfb_id) != null ? _data$kpblfb_id : 0;
          this.kpblfb_num = (_data$kpblfb_num = data.kpblfb_num) != null ? _data$kpblfb_num : 0;
          this.fsfb_num = (_data$fsfb_num = data.fsfb_num) != null ? _data$fsfb_num : 0;
          this.miJingBfb_id = (_data$scfb_id = data.scfb_id) != null ? _data$scfb_id : 0;
          this.miJingAfb_id = (_data$dnfb_id = data.dnfb_id) != null ? _data$dnfb_id : 0;
        };
        _proto.sc_36012 = function sc_36012(data) {
          if (!data) {
            this.data36012.kpbl_expire_time = 0;
            this.data36012.kpbl_times = 0;
            this.data36012.zb_expire_time = 0;
            this.data36012.zb_times = 0;
            this.data36012.fs_expire_time = 0;
            this.data36012.fs_times = 0;
          } else {
            this.data36012 = data;
          }
        };
        _proto.sc_xybx_times_86001 = function sc_xybx_times_86001(data) {
          var _data$bx_times, _data$max_times;
          this.cur_xybx_times = (_data$bx_times = data.bx_times) != null ? _data$bx_times : 0;
          this.max_xybx_times = (_data$max_times = data.max_times) != null ? _data$max_times : 0;
        };
        /**
         * 战斗飘字提示
         * @param str 提示内容
         */
        _proto.popTips = function popTips(str, type) {
          var _this5 = this;
          if (this.commomUiTimer[type]) {
            return;
          }
          this.commomUiTimer[type] = true;
          var tmIndex = [0, 0, 1]; //42 血瓶能量瓶  43 技能
          this._battleMainViewCtrl.battleUIView.popTips(str);
          var cfg = DBRecord.fetchId("ShuoMingQuanJu", 42 + tmIndex[type]);
          var tm = Number(cfg.value);
          setTimeout(function () {
            _this5.commomUiTimer[type] = false;
          }, tm);
        }

        /**
         * 血月模式信息
         * @param data
         */;
        _proto.sc_blood_moon = function sc_blood_moon(msg) {
          console.log(">>> sc_blood_moon,msg:", msg);
          this.blood_moon_msg = msg;
          App.monitorMgr.dispatchEvent(MonitorType.blood_moon_update);
        }

        /**
         * 是否血月关卡
         * @returns
         */;
        _proto.isBloodMoonGuanQia = function isBloodMoonGuanQia() {
          if (!this.isBloodMoonState()) {
            return false;
          }
          return App.battleMgr.guanQiaType === GameBattle.GuanQiaType.BloodMoon;
        }

        /**
         * 检查当前关卡是否为主线关卡
         * @returns
         */;
        _proto.isMainLineGuanQia = function isMainLineGuanQia() {
          return this.guanQiaType === GameBattle.GuanQiaType.ZhuXian;
        }

        /**
         * 是否血月状态
         * @returns
         */;
        _proto.isBloodMoonState = function isBloodMoonState() {
          return false;
        }

        /**
         *   血月拾取宝箱
         * @param boxId
         */;
        _proto.pickUpBox = function pickUpBox(boxId) {
          if (!boxId) return;
          for (var i = 0; i < this.blood_moon_box_list.length; i++) {
            if (this.blood_moon_box_list[i].id === boxId && this.blood_moon_box_list[i].state === BloodMoonBoxState.Lock) {
              this.blood_moon_box_list[i].state = BloodMoonBoxState.Got;
              break;
            }
          }
          App.monitorMgr.dispatchEvent(MonitorType.blood_moon_get_box, boxId);
        }

        /**
         * 血月检测是否拾取所有宝箱
         */;
        _proto.checkPickUpAllBox = function checkPickUpAllBox() {
          if (this.blood_moon_box_list.length <= 0) {
            return false;
          }
          for (var _iterator2 = _createForOfIteratorHelperLoose(this.blood_moon_box_list), _step2; !(_step2 = _iterator2()).done;) {
            var element = _step2.value;
            if (element.state === BloodMoonBoxState.Lock) {
              return false;
            }
          }
          return true;
        }

        /**
         * 血月兑换宝箱
         * @param boxId
         */;
        _proto.bloodMoonExchangeBox = function bloodMoonExchangeBox(boxId) {
          if (!boxId) return;
          for (var i = 0; i < this.blood_moon_box_list.length; i++) {
            if (this.blood_moon_box_list[i].id === boxId && this.blood_moon_box_list[i].state === BloodMoonBoxState.Got) {
              this.blood_moon_box_list[i].state = BloodMoonBoxState.Exchaged;
              break;
            }
          }
          var cfg = DBRecord.fetchId("XueYueBaoXiang", boxId);
          if (cfg.cost && cfg.cost.length >= 2) {
            this._blood_moon_cost_count += cfg.cost[1];
            console.log("bloodMoonExchangeBox,cost =", this._blood_moon_cost_count, cfg.cost[1]);
            App.monitorMgr.dispatchEvent(MonitorType.blood_moon_exchange_box_update);
          }
        }

        /**
         * 获取血月耗材数量
         */;
        _proto.getBloodMoonCostNum = function getBloodMoonCostNum() {
          var num = 0;
          var itemList = App.battleMgr.fallingPropCtrl.allItems;
          // let itemList: m_proto.IItem[] = App.bagMgr.getBagItemList(BagType.prop);
          for (var _iterator3 = _createForOfIteratorHelperLoose(itemList), _step3; !(_step3 = _iterator3()).done;) {
            var element = _step3.value;
            if (element.item_id === this._blood_moon_cost_item_id) {
              num += element.item_count;
            }
          }
          return Math.max(0, num - this._blood_moon_cost_count);
        }

        /**
         * 剩余材料是否还能兑换宝箱
         */;
        _proto.bloodMoonCanExchange = function bloodMoonCanExchange() {
          var num = this.getBloodMoonCostNum();
          for (var _iterator4 = _createForOfIteratorHelperLoose(this.blood_moon_box_list), _step4; !(_step4 = _iterator4()).done;) {
            var element = _step4.value;
            if (element.state === BloodMoonBoxState.Got) {
              var cfg = DBRecord.fetchId("XueYueBaoXiang", element.id);
              if (cfg.cost && cfg.cost.length >= 2) {
                if (num >= cfg.cost[1]) {
                  return true;
                }
              }
            }
          }
          return false;
        }

        /**
         * 血月刷怪
         */;
        _proto.bloodMoonRefreshMonster = function bloodMoonRefreshMonster() {
          //console.log("血月刷怪",Math.random());
          if (App.battleMgr.roleCtrl.getBoss() != null) {
            return;
          }
          var monsterBorn = App.mapMgr._tiledMap.getObjectGroup("monsterBorn");
          if (!monsterBorn) {
            return;
          }
          var born_list = monsterBorn.getObjects();
          var max = born_list[0]["maxLimit"] || 20;
          var count = 0;
          App.battleMgr.roleCtrl.foreachEntity(this, function (entity) {
            if (entity.type === GameBattle.RoleType.Monster && !entity.isSummon()) {
              count++;
            }
            return false;
          });
          var self = this;
          var tm = born_list[0]["refresh"] || 7;
          this._blood_moon_monster_timer = setTimeout(function () {
            self.bloodMoonRefreshMonster();
          }, tm * 1000);
          if (count >= max) {
            return;
          }
          App.mapMgr.initMonsterData(undefined, true);
        }

        /**
         * 是否在战斗中
         */;
        _proto.isInBattle = function isInBattle() {
          return this._isInBattle;
        }

        //TODO_YK
        ;

        _proto.initTuJianAttr = function initTuJianAttr() {
          var _this6 = this;
          var mTuJianAttr = {};
          var vTuJianTaoZhuang = DBRecord.fetchAll("TuJianTaoZhuang");
          for (var dx0 = 0; dx0 < vTuJianTaoZhuang.length; dx0++) {
            var oTuJianTaoZhuang = vTuJianTaoZhuang[dx0];
            if ((oTuJianTaoZhuang.map || []).findIndex(function (ele) {
              return ele === _this6.diMao;
            }) < 0) {
              continue;
            }
            // if (App.instituteManager.getGroupLv(oTuJianTaoZhuang.group) < oTuJianTaoZhuang.condition) {
            //     continue;
            // }
            for (var dx1 = 0; dx1 < (oTuJianTaoZhuang.mon || []).length; dx1++) {
              mTuJianAttr[oTuJianTaoZhuang.mon[dx1]] = oTuJianTaoZhuang.attr;
            }
          }
          this._mTuJianAttr = mTuJianAttr;
        };
        _proto.getTuJianAttr = function getTuJianAttr(DeferVO) {
          var mAttr = {};
          if (this.guanQiaType === GameBattle.GuanQiaType.ZhuXian) {
            mAttr = this._mTuJianAttr[DeferVO.quality] || {};
          }
          return mAttr;
        }

        /**
         * 获取地图数据
         * @param diMao
         */;
        _proto.getMapData = function getMapData(diMao) {
          var _mapData = {};
          var guanQiaId = App.battleMgr.challengeGuanQiaId;
          var cfg = DBRecord.fetchId("GuanQia", guanQiaId);
          var random_map = cfg.random_map;
          var diMaoIndex = 0;
          for (var i = 0; i < random_map.length; i++) {
            if (diMao === random_map[i][0]) {
              diMaoIndex = i;
              break;
            }
          }
          var monster_density = cfg.monster_density[diMaoIndex];
          _mapData = {};
          var dbr = DBRecord.fetchAll("DiKuai");
          var born_map = [];
          for (var _iterator5 = _createForOfIteratorHelperLoose(dbr), _step5; !(_step5 = _iterator5()).done;) {
            var it = _step5.value;
            if (it.name === diMao && it.monster_density === monster_density) {
              if (!_mapData[it["in"]]) {
                _mapData[it["in"]] = [];
              }
              _mapData[it["in"]].push(it);
              if (it["in"] === 0) {
                born_map.push(it);
              }
            }
          }
          return [_mapData, born_map];
        }

        /**
         * 初始化当前章节所有怪物的资源名称
         */;
        _proto.initAllMonsterRes = function initAllMonsterRes(_mapData) {
          if (!_mapData) {
            console.warn("地图数据不存在，无法初始化怪物数据");
            return;
          }

          // 用于存储所有怪物ID，避免重复
          var monsterIds = new Set();

          // 遍历所有地图块
          for (var _key3 in _mapData) {
            if (!_mapData.hasOwnProperty(_key3)) continue;
            var mapItems = _mapData[_key3];
            if (!Array.isArray(mapItems)) continue;

            // 遍历数组中的每个地块信息
            for (var i = 0; i < mapItems.length; i++) {
              var mapItem = mapItems[i];
              if (!mapItem || !mapItem.id) continue;

              // 获取地块信息
              var _dbr = mapItem;
              if (!_dbr || !_dbr.moster_born) continue;

              // 遍历该地块的所有怪物出生点
              var monsterBornList = _dbr.moster_born;
              for (var j = 0; j < monsterBornList.length; j++) {
                var data = monsterBornList[j];
                if (!data || data.length < 2) continue;

                // 获取怪物组ID
                var monsterGroupId = data[1];
                var monsterGroup = DBRecord.fetchId("GuaiWuZu", monsterGroupId);
                if (!monsterGroup || !monsterGroup.probability) continue;

                // 从怪物组中获取所有可能的怪物ID
                for (var _iterator6 = _createForOfIteratorHelperLoose(monsterGroup.probability), _step6; !(_step6 = _iterator6()).done;) {
                  var element = _step6.value;
                  monsterIds.add(element[0]);
                }
              }
            }
          }
          var bossId = this.initRandomBossId();
          if (bossId) {
            monsterIds.add(bossId);
          }

          // 将怪物ID转换为怪物资源名称
          var monsterNameList = [];
          var monsterResSet = new Set();
          monsterIds.forEach(function (monsterId) {
            // 获取怪物配置
            var monsterConfig = DBRecord.fetchId("GuaiWu", monsterId);
            if (monsterConfig && monsterConfig.res) {
              // 使用Set确保资源名称不重复
              if (!monsterResSet.has(monsterConfig.res)) {
                monsterResSet.add(monsterConfig.res);
                monsterNameList.push(monsterConfig.res);
              }
            }
          });

          //console.log('================================>>当前章节所有怪物动画名称列表:', monsterNameList);
          var monsterIdList = Array.from(monsterIds);
          return [monsterNameList, monsterIdList];
        };
        /**
         * 先确定随机boss的id,方便laoding时加载boss资源
         */
        _proto.initRandomBossId = function initRandomBossId() {
          var dbr = DBRecord.fetchId("GuanQia", this.challengeGuanQiaId);
          if (dbr && dbr.bossid && dbr.bossid.length > 0) {
            this.curRandomBossId = BattleUtil.getValueByProbability(dbr.bossid);
          }
          //console.log('================================>>本次战斗随机boss id:', this.curRandomBossId);
          return this.curRandomBossId;
        };
        /**
         * 初始化当前章节所有子弹的资源名称
         */
        _proto.getAllBulletRes = function getAllBulletRes(monsterIdList) {
          var allBulletList = [];
          var allBuffs = [];
          //玩家英雄技能
          // let playerHeroBuffs = App.heroTavernManager.getAllHeroSkillBuff();
          // for (let i = 0; i < playerHeroBuffs.length; i++) {
          //     allBuffs.push(playerHeroBuffs[i]);
          // }
          //玩家装备buff
          var list_equip = App.bagMgr.getWearEquipList();
          for (var _iterator7 = _createForOfIteratorHelperLoose(list_equip), _step7; !(_step7 = _iterator7()).done;) {
            var _it = _step7.value;
            for (var _i9 = 0; _i9 < _it.equipment.skillid_list.length; _i9++) {
              var _cfg9 = DBRecord.fetchId("ZhuangBeiJiNeng", _it.equipment.skillid_list[_i9]);
              if (_cfg9.buff_id > 0) {
                allBuffs.push(_cfg9.buff_id);
              }
            }
          }
          //玩家勾玉buff
          var list_gouyu = App.bagMgr.getGouYuInlay();
          for (var key0 in list_gouyu) {
            var BaoShiShuXing = DBRecord.fetchId("BaoShiShuXing", list_gouyu[key0].gem.sx_id);
            if (BaoShiShuXing && BaoShiShuXing.buff) {
              for (var key1 in BaoShiShuXing.buff) {
                allBuffs.push(BaoShiShuXing.buff[key1]);
              }
            }
          }
          //玩家套装buff
          var list_suit = App.bagMgr.getWearEquipSuitBuff();
          for (var i = 0; i < list_suit.length; i++) {
            var _cfg = list_suit[i];
            if (_cfg.buff_id > 0) {
              allBuffs.push(_cfg.buff_id);
            }
          }
          // //玩家时装buff
          // let playerFashionBuffs = App.fashionManager.getAllFashionsSkillBuff();
          // for (let i = 0; i < playerFashionBuffs.length; i++) {
          //     allBuffs.push(playerFashionBuffs[i]);
          // }
          // //玩家翅膀buff
          // let wingsId = App.wingsManager.getWingsWear();
          // let playerWingsBuffs = App.wingsManager.getWingsBuff(wingsId);
          // for (let i = 0; i < playerWingsBuffs.length; i++) {
          //     allBuffs.push(playerWingsBuffs[i]);
          // }
          // //玩家圣坛词缀buff
          // let playerCiZuiBuffs = App.shengTanManager.initCiZuiSkills();
          // for (let i = 0; i < playerCiZuiBuffs.length; i++) {
          //     let config = DBRecord.fetchId('ZhuangBeiJiNeng', playerCiZuiBuffs[i]);
          //     if (config.buff_id > 0) {
          //         allBuffs.push(config.buff_id);
          //     }
          // }
          // //玩家随从buff
          // let playerFolloerBuffs = App.heroTavernManager.getHeroFollowerBuff() || [];
          // for (let i = 0; i < playerFolloerBuffs.length; i++) {
          //     allBuffs.push(playerFolloerBuffs[i]);
          // }
          // let petInfo = App.petManager.getPetById(App.petManager.getCurFightPetId());
          // if (petInfo) {
          //     for (let index = 0; index < petInfo.skills.length; index++) {
          //         const skill = petInfo.skills[index];
          //         let skillCfg: dbr.ChongWuJiNeng = DBRecord.fetchId('ChongWuJiNeng', skill.skill_id);
          //         let buffs = skillCfg.buff;
          //         if (buffs) {
          //             for (let i = 0; i < buffs.length; i++) {
          //                 allBuffs.push(buffs[i]);
          //             }
          //         }
          //     }
          // }

          //玩家学习的技能
          var playerSkills = App.skillMgr.getDirectSkill();
          var cfg = DBRecord.fetchId("ZhiYe", App.roleMgr.getRoleJob());
          playerSkills.push(cfg.atk_id);
          for (var _iterator8 = _createForOfIteratorHelperLoose(playerSkills), _step8; !(_step8 = _iterator8()).done;) {
            var _it2 = _step8.value;
            var _cfg10 = DBRecord.fetchId("Skill", _it2);
            if (_cfg10 && _cfg10.buff_id) {
              for (var _i10 = 0; _i10 < _cfg10.buff_id.length; _i10++) {
                allBuffs.push(_cfg10.buff_id[_i10]);
              }
            }
            if (_cfg10 && _cfg10.bullet_id) {
              for (var _i11 = 0; _i11 < _cfg10.bullet_id.length; _i11++) {
                allBulletList.push(_cfg10.bullet_id[_i11]);
              }
            }
          }
          // console.log('================================>>TEST BULLET 玩家技能列表:', playerSkills);
          var playerPassiveSkills = App.skillMgr.getLearnPassiveId();
          for (var _iterator9 = _createForOfIteratorHelperLoose(playerPassiveSkills), _step9; !(_step9 = _iterator9()).done;) {
            var _it3 = _step9.value;
            var _cfg11 = DBRecord.fetchId("Skill", _it3);
            if (_cfg11.buff_id && _cfg11.buff_id.length > 0) {
              for (var _i12 = 0; _i12 < _cfg11.buff_id.length; _i12++) {
                allBuffs.push(_cfg11.buff_id[_i12]);
              }
            }
            if (_cfg11.bullet_id) {
              for (var _i13 = 0; _i13 < _cfg11.bullet_id.length; _i13++) {
                allBulletList.push(_cfg11.bullet_id[_i13]);
              }
            }
          }

          //怪物
          //玩家随从id
          // let heroId = App.heroTavernManager.curHeroId;
          // if (heroId) {
          //     let cfg: dbr.YingXiongShengJi = App.heroTavernManager.getAllHeroSjByHid(heroId)[0];
          //     if (cfg && cfg.entourage) {
          //         monsterIdList.push(cfg.entourage);
          //     }
          // }
          //怪物技能id
          var monsterSkillList = [];
          for (var _i = 0; _i < monsterIdList.length; _i++) {
            var _cfg2 = DBRecord.fetchId("GuaiWu", monsterIdList[_i]);
            if (_cfg2) {
              if (_cfg2.init_buff_id) {
                for (var j = 0; j < _cfg2.init_buff_id.length; j++) {
                  allBuffs.push(_cfg2.init_buff_id[j]);
                }
              }
              if (_cfg2.skill_id) {
                for (var _j = 0; _j < _cfg2.skill_id.length; _j++) {
                  monsterSkillList.push(_cfg2.skill_id[_j]);
                }
              }
              if (_cfg2.atk_id) {
                monsterSkillList.push(_cfg2.atk_id);
              }
            }
          }
          //怪物技能buff、子弹
          for (var _i2 = 0, _monsterSkillList = monsterSkillList; _i2 < _monsterSkillList.length; _i2++) {
            var it = _monsterSkillList[_i2];
            var _cfg3 = DBRecord.fetchId("Skill", it);
            if (_cfg3 && _cfg3.buff_id && _cfg3.buff_id.length > 0) {
              for (var _i3 = 0; _i3 < _cfg3.buff_id.length; _i3++) {
                allBuffs.push(_cfg3.buff_id[_i3]);
              }
            }
            if (_cfg3 && _cfg3.bullet_id) {
              for (var _i4 = 0; _i4 < _cfg3.bullet_id.length; _i4++) {
                allBulletList.push(_cfg3.bullet_id[_i4]);
              }
            }
          }

          //子弹创建的buff、子弹
          var bulletSubBuff = [];
          var subBulletList = [];
          for (var index = 0; index < allBulletList.length; index++) {
            var element = allBulletList[index];
            var _cfg4 = DBRecord.fetchId("JiNengXiaoGuo", element);
            //添加buff
            if (_cfg4 && _cfg4.type === 2) {
              if (_cfg4.atr && _cfg4.atr.length > 0) {
                for (var _i5 = 0; _i5 < _cfg4.atr.length; _i5++) {
                  bulletSubBuff.push(_cfg4.atr[_i5]);
                }
              }
            }
            //添加子弹
            if (_cfg4 && _cfg4.type === 4) {
              if (_cfg4.atr && _cfg4.atr.length > 0) {
                for (var _i6 = 0; _i6 < _cfg4.atr.length; _i6++) {
                  subBulletList.push(_cfg4.atr[_i6]);
                }
              }
            }
          }
          allBuffs.push.apply(allBuffs, bulletSubBuff);
          allBulletList.push.apply(allBulletList, subBulletList);

          //buff创建的buff
          var subBuffList = [];
          //修改子弹效果
          var modifyBulletEffect = [];
          //修改buff效果
          var modifyBuffEffect = [];
          for (var _index = 0; _index < allBuffs.length; _index++) {
            var _element = allBuffs[_index];
            var _cfg5 = DBRecord.fetchId("JiNengBuff", _element);
            if (!_cfg5) {
              continue;
            }
            if (_cfg5.effect_ids) {
              for (var _index2 = 0; _index2 < _cfg5.effect_ids.length; _index2++) {
                var elementEff = _cfg5.effect_ids[_index2];
                var xiaoguoCfg = DBRecord.fetchId("JiNengBuffXiaoGuo", elementEff);
                if (xiaoguoCfg.type === GameBattle.BuffEffectType.AddBuffByOdds) {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0) {
                    for (var _index3 = 0; _index3 < xiaoguoCfg.atr.length; _index3++) {
                      subBuffList.push(xiaoguoCfg.atr[_index3]);
                    }
                  }
                }
                if (xiaoguoCfg.configuration === "buff_id") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0) {
                    for (var _index4 = 0; _index4 < xiaoguoCfg.atr.length; _index4++) {
                      subBuffList.push(xiaoguoCfg.atr[_index4]);
                    }
                  }
                }
                if (xiaoguoCfg.type === GameBattle.BuffEffectType.EventBuff) {
                  if (xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    for (var _index5 = 0; _index5 < xiaoguoCfg.value.length; _index5++) {
                      subBuffList.push(xiaoguoCfg.value[_index5]);
                    }
                  }
                }
                //修改子弹效果
                if (xiaoguoCfg.grid_type === 2 && xiaoguoCfg.configuration === "effect_id") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0 && xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    modifyBulletEffect[xiaoguoCfg.atr[0]] = xiaoguoCfg.value[0];
                  }
                }
                //修改buff效果
                if (xiaoguoCfg.grid_type === 4 && xiaoguoCfg.configuration === "effect_ids") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0 && xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    for (var _index6 = 0; _index6 < xiaoguoCfg.value.length; _index6++) {
                      if (!modifyBuffEffect[xiaoguoCfg.atr[0]]) {
                        modifyBuffEffect[xiaoguoCfg.atr[0]] = [];
                      }
                      modifyBuffEffect[xiaoguoCfg.atr[0]].push(xiaoguoCfg.value[_index6]);
                    }
                  }
                }
              }
            }
          }
          allBuffs.push.apply(allBuffs, subBuffList);
          var allBulletResList = [];
          var allEffectResList = [];
          for (var _index7 = 0; _index7 < allBuffs.length; _index7++) {
            var _element2 = allBuffs[_index7];
            var _cfg6 = DBRecord.fetchId("JiNengBuff", _element2);
            if (_cfg6) {
              _cfg6 = _extends({}, _cfg6);
              if (_cfg6.effect_ids) {
                _cfg6.effect_ids = [].concat(_cfg6.effect_ids);
              }
            }
            if (_cfg6 && _cfg6.effect_ids) {
              if (modifyBuffEffect[_cfg6.id]) {
                var _cfg6$effect_ids;
                //console.log('================================>>TEST BULLET 修改buff效果:',cfg.id,modifyBuffEffect[cfg.id]);
                (_cfg6$effect_ids = _cfg6.effect_ids).push.apply(_cfg6$effect_ids, modifyBuffEffect[_cfg6.id]);
              }
              for (var _index8 = 0; _index8 < _cfg6.effect_ids.length; _index8++) {
                var effectElement = _cfg6.effect_ids[_index8];
                var _xiaoguoCfg = DBRecord.fetchId("JiNengBuffXiaoGuo", effectElement);
                if (_xiaoguoCfg.type === GameBattle.BuffEffectType.CreateBullet) {
                  if (_xiaoguoCfg.atr && _xiaoguoCfg.atr.length > 0) {
                    allBulletList.push(_xiaoguoCfg.atr[0]);
                  }
                }
                if (_xiaoguoCfg.configuration === "bullet_id") {
                  if (_xiaoguoCfg.value && _xiaoguoCfg.value.length > 0) {
                    allBulletList.push(_xiaoguoCfg.value[0]);
                  }
                } else if (_xiaoguoCfg.configuration === "res") {
                  if (_xiaoguoCfg.value) {
                    allBulletResList.push(_xiaoguoCfg.value);
                  }
                }
              }
            }
          }
          this.allBulletIdList = [].concat(allBulletList);
          //console.log('================================>>TEST BULLET 怪物列表:', monsterIdList);
          // console.log('================================>>TEST BULLET 子弹列表:', allBulletList);
          // console.log('================================>>TEST BULLET buff列表:', allBuffs);

          for (var _i7 = 0; _i7 < allBulletList.length; _i7++) {
            var _cfg7 = DBRecord.fetchId("JiNengZiDan", allBulletList[_i7]);
            if (_cfg7) {
              if (_cfg7.res) {
                allBulletResList.push(_cfg7.res);
              }
              if (_cfg7.hit_effect) {
                allEffectResList.push(_cfg7.hit_effect);
              }
            }
          }
          for (var _i8 = 0; _i8 < allBuffs.length; _i8++) {
            var _cfg8 = DBRecord.fetchId("JiNengBuff", allBuffs[_i8]);
            if (_cfg8) {
              if (_cfg8.vfx) {
                allEffectResList.push(_cfg8.vfx);
              }
            }
          }
          if (this.guanQiaType === GameBattle.GuanQiaType.XinShou) {
            var _allBulletResList;
            (_allBulletResList = allBulletResList).push.apply(_allBulletResList, this.GuideBattleBulletResList);
          } else {
            var _allBulletResList2;
            (_allBulletResList2 = allBulletResList).push.apply(_allBulletResList2, this.BulletResList[App.roleMgr.getRoleJob()]);
          }
          allEffectResList = Array.from(new Set(allEffectResList));
          allBulletResList = Array.from(new Set(allBulletResList));
          // console.log('================================>>TEST BULLET 子弹资源列表:', allBulletResList);
          // console.log('================================>>TEST EFFECT 特效资源列表:', allEffectResList);
          return [allBulletResList, allEffectResList];
        };
        /**
         * 检查子弹是否加载，测试用
         * @param bulletId
         */
        _proto.checkPreLoadBullet = function checkPreLoadBullet(bulletId) {
          {
            if (this.allBulletIdList.findIndex(function (item) {
              return item === bulletId;
            }) < 0) {
              if (!this.noLoadBulletIdList.has(bulletId)) {
                console.warn("****************** TEST BULLET 子弹没有加载：", bulletId);
                this.noLoadBulletIdList.add(bulletId);
              }
            }
          }
        }
        /**
         * 检测木桩副本是否开始战斗了
         */;
        _proto.checkBattleStart = function checkBattleStart() {
          if (!this.battleMainViewCtrl) {
            return false;
          }
          // if (this.guanQiaType === GameBattle.GuanQiaType.MuZhuang) {
          //     if (!this.battleMainViewCtrl.battleMuZhuang) {
          //         return false;
          //     }
          //     return this.battleMainViewCtrl.battleMuZhuang.startBattle;
          // }
          // if (this.guanQiaType === GameBattle.GuanQiaType.JingJiChang) {
          //     if (!this.battleMainViewCtrl.battleJingJiChang) {
          //         return false;
          //     }
          //     return this.battleMainViewCtrl.battleJingJiChang.startBattle;
          // }
          return true;
        }

        /**
         * 挑战主线关卡
         * @param guanQiaId 要挑战的关卡ID
         */;
        _proto.cs_challengeGuanQia = function cs_challengeGuanQia(guanQiaId, shuangbei, beishu) {
          console.warn(">>>>>>>>>> AutoFight cs_challengeGuanQia() guanQiaId, shuangbei, beishu ", guanQiaId, shuangbei, beishu);
          this.challengeGuanQiaId = guanQiaId;
          this.lastChallengeIsNewest = guanQiaId === this.curGuanQiaId;
          this.lastChallengeQuanQiaId = guanQiaId;
          this.guanQiaType = GameBattle.GuanQiaType.ZhuXian;
          this._autoJumpShuangBei = shuangbei;
          this._autoJumpBeishu = beishu;
          var obj = {
            guanka_id: guanQiaId,
            shuangbei: shuangbei,
            beishu: beishu
          };
          netChannel.game.send(MonitorType.web_battle_start, obj);
        }

        /**
         * 自动跳转挑战主线关卡
         */;
        _proto.cs_challengeGuanQia_auto_jump = function cs_challengeGuanQia_auto_jump(guanQiaId) {
          console.warn(">>>>>>>>>> AutoFight  cs_challengeGuanQia_auto_jump() ", guanQiaId);
          if (!guanQiaId) {
            return;
          }
          this.cs_challengeGuanQia(guanQiaId, this._autoJumpShuangBei, this._autoJumpBeishu);
        }

        /**
         * 获取卡皮巴拉关卡ID
         */;
        _proto.getKapiBalaGuanQiaId = function getKapiBalaGuanQiaId() {
          var guanqiaId = App.battleMgr.kpblfb_id;
          // if (App.trialManager.curTrialId != 0) {
          //     guanqiaId = App.trialManager.curTrialId;
          // }
          return guanqiaId;
        }

        /**
         * 挑战卡皮巴拉关卡
         * @param guanQiaId 要挑战的关卡ID
         * @param type 挑战类型（0：默认；1：消耗门票或骰子梦境）
         */;
        _proto.cs_challengeKaPiBaLa = /*#__PURE__*/
        function () {
          var _cs_challengeKaPiBaLa = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3(guanQiaId, type) {
            var obj, cfg, diMao, ui;
            return _regeneratorRuntime().wrap(function _callee3$(_context4) {
              while (1) switch (_context4.prev = _context4.next) {
                case 0:
                  console.warn("========== AutoFight cs_challengeKaPiBaLa() guanQiaId, type ", guanQiaId, type);
                  App.battleMgr.guanQiaType = GameBattle.GuanQiaType.KaPiBaLa;
                  obj = {
                    guanka_id: guanQiaId,
                    c_type: type
                  };
                  netChannel.game.send(MonitorType.web_battle_start, obj);
                  if (App.battleMgr.challengeGuanQiaId > 0) {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.challengeGuanQiaId;
                  } else {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.curGuanQiaId;
                  }
                  App.battleMgr.challengeGuanQiaId = guanQiaId;
                  cfg = DBRecord.fetchId("GuanQia", guanQiaId);
                  diMao = cfg.random_map[0][0];
                  App.battleMgr.diMao = diMao;
                  _context4.next = 11;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 11:
                  ui = _context4.sent;
                  console.warn("========== AutoFight cs_challengeKaPiBaLa() guanQiaId, type,openLoading ", guanQiaId, type);
                  ui.setCloseByHand(true);
                  _context4.next = 16;
                  return Item_BattleMap.loadMap(diMao, ui.onProgress.bind(ui));
                case 16:
                  console.warn("========== AutoFight cs_challengeKaPiBaLa() guanQiaId, type,loadMap finish,open BattleMainView ", guanQiaId, type);
                  UIMgr.inst.openOnce(BattleMainView, LayerType.main, Layout_uiCommonGet, [guanQiaId], function () {
                    ui.onClose();
                    console.warn("========== AutoFight cs_challengeKaPiBaLa() guanQiaId, type,closeAllPanel ", guanQiaId, type);
                    // App.autoFightManager.finishAutoJump();
                    UIMgr.inst.closeAllPanel(["BattleMainView"]);
                  });
                case 18:
                case "end":
                  return _context4.stop();
              }
            }, _callee3);
          }));
          function cs_challengeKaPiBaLa(_x5, _x6) {
            return _cs_challengeKaPiBaLa.apply(this, arguments);
          }
          return cs_challengeKaPiBaLa;
        }()
        /**
         * 获取装备宝库关卡ID
         */;

        _proto.getZhuangBeiBaoKuGuanQiaId = function getZhuangBeiBaoKuGuanQiaId() {
          var guanqiaId = App.battleMgr.zbfb_id;
          // if (App.trialManager.curTrialId != 0) {
          //     guanqiaId = App.trialManager.curTrialId;
          // }
          return guanqiaId;
        }

        /**
         * 挑战装备宝库关卡
         * @param guanQiaId 要挑战的关卡ID
         */;
        _proto.cs_challengeZhuangBeiBaoKu = /*#__PURE__*/
        function () {
          var _cs_challengeZhuangBeiBaoKu = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee4(guanQiaId, type) {
            var obj, cfg, diMao, ui;
            return _regeneratorRuntime().wrap(function _callee4$(_context5) {
              while (1) switch (_context5.prev = _context5.next) {
                case 0:
                  if (type === void 0) {
                    type = 0;
                  }
                  console.warn("========== AutoFight cs_challengeZhuangBeiBaoKu() guanQiaId ", guanQiaId);
                  App.battleMgr.guanQiaType = GameBattle.GuanQiaType.ZhuangBeiBaoKu;
                  obj = {
                    guanka_id: guanQiaId,
                    c_type: type
                  };
                  netChannel.game.send(MonitorType.web_battle_start, obj);
                  if (App.battleMgr.challengeGuanQiaId > 0) {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.challengeGuanQiaId;
                  } else {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.curGuanQiaId;
                  }
                  App.battleMgr.challengeGuanQiaId = guanQiaId;
                  cfg = DBRecord.fetchId("GuanQia", guanQiaId);
                  diMao = cfg.random_map[0][0];
                  App.battleMgr.diMao = 2;
                  _context5.next = 12;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 12:
                  ui = _context5.sent;
                  ui.setCloseByHand(true);
                  _context5.next = 16;
                  return Item_BattleMap.loadMap(diMao, ui.onProgress.bind(ui));
                case 16:
                  console.warn("========== AutoFight cs_challengeZhuangBeiBaoKu() loadMap finish,open BattleMainView");
                  UIMgr.inst.openOnce(BattleMainView, LayerType.main, Layout_uiCommonGet, [200], function () {
                    ui.onClose();
                    // App.autoFightManager.finishAutoJump();
                    console.warn("========== AutoFight cs_challengeZhuangBeiBaoKu() closeAllPanel");
                    UIMgr.inst.closeAllPanel(["BattleMainView"]);
                  });
                case 18:
                case "end":
                  return _context5.stop();
              }
            }, _callee4);
          }));
          function cs_challengeZhuangBeiBaoKu(_x7, _x8) {
            return _cs_challengeZhuangBeiBaoKu.apply(this, arguments);
          }
          return cs_challengeZhuangBeiBaoKu;
        }()
        /**
         * 获取骰子梦境关卡ID
         */;

        _proto.getTouZiDreamGuanQiaId = function getTouZiDreamGuanQiaId() {
          var guanqiaId = App.battleMgr.tongguanGuanQiaId;
          // if (App.trialManager.curTrialId != 0) {
          //     guanqiaId = App.trialManager.curTrialId;
          // }
          return guanqiaId;
        }

        /**
         * 挑战骰子梦境关卡
         * @param guanQiaId 要挑战的关卡ID
         */;
        _proto.cs_challengeTouZiDream = /*#__PURE__*/
        function () {
          var _cs_challengeTouZiDream = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee5(guanQiaId) {
            var guanka_id, obj, cfg, diMao, ui;
            return _regeneratorRuntime().wrap(function _callee5$(_context6) {
              while (1) switch (_context6.prev = _context6.next) {
                case 0:
                  console.warn("========== AutoFight cs_challengeTouZiDream() guanQiaId ", guanQiaId);
                  App.battleMgr.guanQiaType = GameBattle.GuanQiaType.ZhuXian;
                  guanka_id = guanQiaId;
                  App.battleMgr.challengeGuanQiaId = guanka_id;
                  obj = {
                    guanka_id: guanka_id,
                    c_type: 1,
                    c_num: 1
                  };
                  netChannel.game.send(MonitorType.web_battle_start, obj);
                  App.battleMgr.isTouZiDream = true;
                  cfg = DBRecord.fetchId("GuanQia", guanka_id);
                  diMao = BattleUtil.getValueByProbability(cfg.random_map);
                  App.battleMgr.diMao = diMao;
                  _context6.next = 12;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 12:
                  ui = _context6.sent;
                  ui.setCloseByHand(true);
                  _context6.next = 16;
                  return Item_BattleMap.loadMap(diMao, ui.onProgress.bind(ui));
                case 16:
                  console.warn("========== AutoFight cs_challengeTouZiDream() loadMap finish,open BattleMainView");
                  UIMgr.inst.openOnce(BattleMainView, LayerType.main, Layout_uiCommonGet, [guanka_id], function () {
                    ui.onClose();
                    // App.autoFightManager.showTouZiDreamTip();
                    // App.autoFightManager.finishAutoJump();
                    console.warn("========== AutoFight cs_challengeTouZiDream() closeAllPanel");
                    UIMgr.inst.closeAllPanel(["BattleMainView", "uiPrompt"]);
                  });
                case 18:
                case "end":
                  return _context6.stop();
              }
            }, _callee5);
          }));
          function cs_challengeTouZiDream(_x9) {
            return _cs_challengeTouZiDream.apply(this, arguments);
          }
          return cs_challengeTouZiDream;
        }()
        /**
         * 挑战土拨鼠关卡
         * @param type 挑战类型（0：默认；1：消耗门票或骰子梦境）
         */;

        _proto.cs_challengeTuBoShu = /*#__PURE__*/
        function () {
          var _cs_challengeTuBoShu = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee6(type) {
            var guanka_id, obj, cfg, diMao, ui;
            return _regeneratorRuntime().wrap(function _callee6$(_context7) {
              while (1) switch (_context7.prev = _context7.next) {
                case 0:
                  if (type === void 0) {
                    type = 0;
                  }
                  console.warn("========== AutoFight cs_challengeTuBoShu() guanQiaId ", type);
                  App.battleMgr.guanQiaType = GameBattle.GuanQiaType.TuBoshu;
                  guanka_id = 400;
                  if (App.battleMgr.challengeGuanQiaId > 0) {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.challengeGuanQiaId;
                  } else {
                    App.battleMgr.challengeGuanQiaIdCatch = App.battleMgr.curGuanQiaId;
                  }
                  App.battleMgr.challengeGuanQiaId = guanka_id;
                  obj = {
                    guanka_id: guanka_id,
                    c_type: type
                  };
                  netChannel.game.send(MonitorType.web_battle_start, obj);
                  cfg = DBRecord.fetchId("GuanQia", guanka_id);
                  diMao = BattleUtil.getValueByProbability(cfg.random_map);
                  App.battleMgr.diMao = diMao;
                  _context7.next = 13;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 13:
                  ui = _context7.sent;
                  ui.setCloseByHand(true);
                  _context7.next = 17;
                  return Item_BattleMap.loadMap(diMao, ui.onProgress.bind(ui));
                case 17:
                  console.warn("========== AutoFight cs_challengeTuBoShu() loadMap finish,open BattleMainView");
                  UIMgr.inst.openOnce(BattleMainView, LayerType.main, Layout_uiCommonGet, [guanka_id], function () {
                    ui.onClose();
                    // App.autoFightManager.finishAutoJump();
                    console.warn("========== AutoFight cs_challengeTuBoShu() closeAllPanel");
                    UIMgr.inst.closeAllPanel(["BattleMainView"]);
                  });
                case 19:
                case "end":
                  return _context7.stop();
              }
            }, _callee6);
          }));
          function cs_challengeTuBoShu(_x10) {
            return _cs_challengeTuBoShu.apply(this, arguments);
          }
          return cs_challengeTuBoShu;
        }();
        _createClass(BattleMgr, [{
          key: "roleCtrl",
          get: function get() {
            return this._roleCtrl;
          }
        }, {
          key: "bulletCtrl",
          get: function get() {
            return this._bulletCtrl;
          }
        }, {
          key: "skillCtrl",
          get: function get() {
            return this._skillCtrl;
          }
        }, {
          key: "battleMainViewCtrl",
          get: function get() {
            return this._battleMainViewCtrl;
          },
          set: function set(v) {
            this._battleMainViewCtrl = v;
          }
        }, {
          key: "battleNpcCtrl",
          get: function get() {
            return this._battleNpcCtrl;
          }
        }, {
          key: "playerCamera",
          get: function get() {
            return this._playerCamera;
          },
          set: function set(val) {
            this._playerCamera = val;
          }
        }, {
          key: "pause",
          get: function get() {
            return this._pause;
          }
        }, {
          key: "curGuanQiaId",
          get: function get() {
            return this._curGuanQiaId;
          }

          /**
           * 获取boss是否已死亡
           * @returns
           */,
          set: function set(v) {
            this._curGuanQiaId = v;
          }
        }, {
          key: "bossIsDead",
          get: function get() {
            return this._bossIsDead;
          }

          /**
           * 设置boss是否已死亡
           * @param value
           */,
          set: function set(value) {
            this._bossIsDead = value;
          }
        }]);
        return BattleMgr;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleMiniMapCtrl.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Utils.ts', './MonitorType.ts', './ModuleDef.ts', './BattleDefine.ts', './DBRecord.ts', './ItemBattleNpc.ts', './ItemFallingProp.ts', './App.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createForOfIteratorHelperLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, Node, Label, NodePool, instantiate, UITransform, Sprite, Vec3, Component, Utils, MonitorType, ModuleDef, GameBattle, DBRecord, ItemBattleNpc, ItemFallingProp, App;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      Label = module.Label;
      NodePool = module.NodePool;
      instantiate = module.instantiate;
      UITransform = module.UITransform;
      Sprite = module.Sprite;
      Vec3 = module.Vec3;
      Component = module.Component;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      ItemBattleNpc = module.ItemBattleNpc;
    }, function (module) {
      ItemFallingProp = module.ItemFallingProp;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11;
      cclegacy._RF.push({}, "151dakFZNFHE6fbKBZW5Ep2", "BattleMiniMapCtrl", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleMiniMapCtrl = exports('BattleMiniMapCtrl', (_dec = ccclass("BattleMiniMapCtrl"), _dec2 = property({
        type: Node,
        displayName: "小地图父节点"
      }), _dec3 = property({
        type: Node,
        displayName: "地图节点"
      }), _dec4 = property({
        type: Node,
        displayName: "小地图代表角色的点"
      }), _dec5 = property({
        type: Node,
        displayName: "小地图用来拷贝的节点"
      }), _dec6 = property({
        type: Node,
        displayName: "怪物icon节点"
      }), _dec7 = property({
        type: Node,
        displayName: "小地图根节点"
      }), _dec8 = property({
        type: Label,
        displayName: "关卡名"
      }), _dec9 = property({
        type: Node,
        displayName: "宝箱icon节点"
      }), _dec10 = property({
        type: Node,
        displayName: "图腾icon节点"
      }), _dec11 = property({
        type: Node,
        displayName: "武器架icon节点"
      }), _dec12 = property({
        type: Node,
        displayName: "装备品质icon节点>5品质"
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleMiniMapCtrl, _Component);
        function BattleMiniMapCtrl() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "miniMapParent", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "miniMapImg", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "miniRole", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "poolNode", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "monsterPoolNode", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "miniMapRoot", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbGuanQiuaName", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "baoxiangPoolNode", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "totemPoolNode", _descriptor9, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "weaponRackPoolNode", _descriptor10, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "equipQualityNode", _descriptor11, _assertThisInitialized(_this));
          _this._nodePool = new NodePool();
          _this._monsterNodePool = new NodePool();
          _this.baoXiangNodePool = new NodePool();
          _this.totemNodePool = new NodePool();
          _this.weaponRackNodePool = new NodePool();
          _this.initMapPromise = null;
          _this.equipNodePool = new NodePool();
          _this.mapWidth = void 0;
          // 真实地图宽度
          _this.mapHeight = void 0;
          // 真实地图高度
          _this.miniMapWidth = void 0;
          // 小地图宽度
          _this.miniMapHeight = void 0;
          // 小地图高度
          _this.MINI_MAP_SCALE = 3;
          // 活跃的怪物图标
          _this.activeMonsters = new Map();
          _this.activeBaoXiangs = new Map();
          _this.activeTotems = new Map();
          _this.activeWeaponRacks = new Map();
          _this.activeEquips = new Map();
          // 道具颜色品质对应
          _this.itemColorArr = [5, 6, 7, 8, 9, 10];
          return _this;
        }
        var _proto = BattleMiniMapCtrl.prototype;
        _proto.onEnable = function onEnable() {
          if (App.battleMgr.guanQiaType !== GameBattle.GuanQiaType.MainLine) {
            this.node.active = false;
            return;
          }
          this.initListener();
        };
        _proto.start = function start() {
          for (var i = 0; i < 4; i++) {
            this._nodePool.put(instantiate(this.poolNode));
            this._monsterNodePool.put(instantiate(this.monsterPoolNode));
            this.baoXiangNodePool.put(instantiate(this.baoxiangPoolNode));
          }
          for (var index = 0; index < 2; index++) {
            this.totemNodePool.put(instantiate(this.totemPoolNode));
            this.weaponRackNodePool.put(instantiate(this.weaponRackPoolNode));
            this.equipNodePool.put(instantiate(this.equipQualityNode));
          }
          var cfg = DBRecord.fetchId("GuanQia", App.battleMgr.challengeGuanQiaId);
          var difficulty = cfg.difficulty;
          var map_level = cfg.map_level;
          var diMaoDesc = DBRecord.fetchId("ShuoMingQuanJu", 146);
          var curDiMaoDesc = diMaoDesc.value.find(function (item) {
            return item[0] == App.battleMgr.diMao;
          });
          if (curDiMaoDesc) {
            this.lbGuanQiuaName.string = Utils.getGlobalTxt(curDiMaoDesc[1]) + "(" + Utils.getGlobalTxt(1000 + difficulty) + " " + map_level + ")";
          } else {
            this.lbGuanQiuaName.string = Utils.getGlobalTxt(1000 + difficulty) + " " + map_level;
          }
        };
        _proto.initListener = function initListener() {
          App.monitorMgr.addEventListener(MonitorType.battle_add_minimap, this.addAndCreateMiniMap, this);
          App.monitorMgr.addEventListener(MonitorType.battle_init_minimap, this.initMiniMap, this);
          App.monitorMgr.addEventListener(MonitorType.battle_player_get_falling_item, this.handleEquipmentGet, this);
        }

        /**
         * 初始化地图数据
         */;
        _proto.initMiniMapData = function initMiniMapData() {
          var mapSize = App.battleMgr.battleMainViewCtrl.battleMap.getCurMapSize();
          var gridSize = App.battleMgr.battleMainViewCtrl.battleMap.getCurGridSize();
          this.mapWidth = mapSize.width * gridSize.width;
          this.mapHeight = mapSize.height * gridSize.height;
          this.miniMapWidth = this.miniMapImg.getComponent(UITransform).width;
          this.miniMapHeight = this.miniMapImg.getComponent(UITransform).height;
        }

        /**
         * 初始化第一张小地图
         */;
        _proto.initMiniMap = function initMiniMap(dikuiId, bornPos) {
          var _this2 = this;
          this.initMiniMapData();
          this.initMapPromise = new Promise(function (resolve) {
            if (dikuiId > 10000) {
              dikuiId %= 10000;
            }
            console.log("Loading map:", dikuiId);
            App.resMgr.loadSpriteFrame(ModuleDef.GAME_BATTLE_B, "/images/miniMap/mapsTexture/" + dikuiId, function (err, spriteFrame) {
              if (!_this2.isValid) return;
              if (!_this2.miniMapImg.isValid) return;
              _this2.miniMapImg.getComponent(Sprite).spriteFrame = spriteFrame;
              var mapCenterX = _this2.mapWidth / 2;
              var mapCenterY = _this2.mapHeight / 2;
              var playerOffsetX = bornPos.x - mapCenterX;
              var playerOffsetY = bornPos.y - mapCenterY;
              var scaleRatio = _this2.miniMapWidth / _this2.mapWidth;
              var offsetX = -playerOffsetX * scaleRatio;
              var offsetY = -playerOffsetY * scaleRatio;
              var finalX = 130 + offsetX * _this2.MINI_MAP_SCALE;
              var finalY = 83 + offsetY * _this2.MINI_MAP_SCALE;
              if (_this2.miniMapParent.isValid) {
                _this2.miniMapParent.setPosition(finalX, finalY);
              }
              resolve();
            });
          });
        }

        /**
         * 添加新的小地图
         */;
        _proto.addAndCreateMiniMap = /*#__PURE__*/
        function () {
          var _addAndCreateMiniMap = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(dikuiId, dir) {
            var _this3 = this;
            var node, referencePos, newPosition;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return this.initMapPromise;
                case 2:
                  if (this._nodePool.size() == 0) {
                    this._nodePool.put(instantiate(this.miniMapImg));
                  }
                  node = this._nodePool.get();
                  referencePos = {
                    x: this.miniMapImg.position.x,
                    y: this.miniMapImg.position.y
                  };
                  if (dir[0] !== 0) {
                    newPosition = new Vec3(referencePos.x + dir[0] * this.miniMapWidth, referencePos.y, 0);
                  } else {
                    newPosition = new Vec3(referencePos.x, referencePos.y + dir[1] * this.miniMapHeight, 0);
                  }

                  // 加载并设置新地图
                  _context.next = 8;
                  return new Promise(function (resolve) {
                    if (dikuiId > 10000) {
                      dikuiId %= 10000;
                    }
                    console.log("Loading map:", dikuiId);
                    App.resMgr.loadSpriteFrame(ModuleDef.GAME_BATTLE_B, "/images/miniMap/mapsTexture/" + dikuiId, function (err, spriteFrame) {
                      if (!_this3.isValid) return;
                      node.getComponent(Sprite).spriteFrame = spriteFrame;
                      node.active = true;
                      node.name = "" + dikuiId;
                      node.setPosition(newPosition);
                      _this3.miniMapParent.addChild(node);
                      _this3.miniMapImg = node;
                      console.log("Final map position:", node.position);
                      resolve();
                    });
                  });
                case 8:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function addAndCreateMiniMap(_x, _x2) {
            return _addAndCreateMiniMap.apply(this, arguments);
          }
          return addAndCreateMiniMap;
        }()
        /**
         * 显示小地图上的所有图标（宝箱、图腾、武器架等）
         */;

        _proto.showMapIcons = function showMapIcons() {
          var roleLayer = App.battleMgr.battleMainViewCtrl.roleLayer;
          var player = App.battleMgr.roleCtrl.player;
          if (!(player != null && player.roleVO)) {
            return;
          }
          var playerWorldPos = player.node.worldPosition;
          var scaleRatio = this.miniMapWidth / this.mapWidth;
          var entityMap = roleLayer.children;
          for (var i = 0; i < entityMap.length; i++) {
            var child = entityMap[i];
            if (!child.name.startsWith("itemBattleNpc")) continue;
            var comp = child.getComponent(ItemBattleNpc);
            var worldPos = child.worldPosition;
            var distance = Vec3.distance(playerWorldPos, worldPos);
            if (distance > 1000) continue;
            var iconNode = null;
            var iconPool = null;
            var activeMap = null;
            var id = -1;

            // 根据NPC类型选择对应的图标池和激活Map
            if (comp.isBaoxiang()) {
              iconPool = this.baoXiangNodePool;
              activeMap = this.activeBaoXiangs;
              id = comp.getBaoxiangId();
            } else if (comp.isTotem()) {
              iconPool = this.totemNodePool;
              activeMap = this.activeTotems;
              id = comp.getTotemId();
            } else if (comp.isWeaponRack()) {
              iconPool = this.weaponRackNodePool;
              activeMap = this.activeWeaponRacks;
              id = comp.getRackId();
            } else {
              continue;
            }

            // 获取或创建图标节点
            iconNode = activeMap.get(id);
            if (!iconNode) {
              if (iconPool.size() === 0) {
                var template = comp.isBaoxiang() ? this.baoxiangPoolNode : comp.isTotem() ? this.totemPoolNode : this.weaponRackPoolNode;
                iconPool.put(instantiate(template));
              }
              if (!comp.isUsed()) {
                iconNode = iconPool.get();
                activeMap.set(id, iconNode);
                this.miniMapRoot.addChild(iconNode);
              }
            } else if (comp.isUsed()) {
              iconPool.put(iconNode);
              activeMap["delete"](id);
              continue;
            }
            if (!iconNode) continue;

            // 计算图标位置
            var offsetX = (worldPos.x - playerWorldPos.x) * scaleRatio * this.MINI_MAP_SCALE;
            var offsetY = (worldPos.y - playerWorldPos.y) * scaleRatio * this.MINI_MAP_SCALE;
            var finalPos = new Vec3(this.miniRole.position.x + offsetX, this.miniRole.position.y + offsetY, 0);
            var halfWidth = this.miniMapRoot.uiTransform.width / 2;
            var halfHeight = this.miniMapRoot.uiTransform.height / 2;

            // 设置图标显示状态
            if (finalPos.x > halfWidth || finalPos.y > halfHeight || finalPos.x < -halfWidth || finalPos.y < -halfHeight) {
              if (iconNode && iconNode.isValid) iconNode.active = false;
            } else {
              if (iconNode && iconNode.isValid) {
                iconNode.active = true;
                iconNode.setPosition(finalPos);
              }
            }
          }
        }

        /**
         * 处理装备拾取事件
         * @param item
         */;
        _proto.handleEquipmentGet = function handleEquipmentGet(item) {
          var iconNode = this.activeEquips.get(item.item_id);
          if (iconNode) {
            this.equipNodePool.put(iconNode);
            this.activeEquips["delete"](item.item_id);
          }
        }

        /**
         * 处理装备掉落事件
         */;
        _proto.handleEquipmentDrop = function handleEquipmentDrop() {
          var _this4 = this;
          var fallingLayer = App.battleMgr.battleMainViewCtrl.fallingLayer;
          var player = App.battleMgr.roleCtrl.player;
          if (!(player != null && player.node)) return;
          var playerWorldPos = player.node.worldPosition;
          var scaleRatio = this.miniMapWidth / this.mapWidth;
          var currentFallingItemIds = new Set();
          fallingLayer.children.forEach(function (child) {
            if (child instanceof Node) {
              var itemComp = child.getComponent(ItemFallingProp);
              if (itemComp) {
                if (!itemComp || itemComp.item_color < 5 || itemComp.item_id < 500000) return;
                var distance = Vec3.distance(child.worldPosition, playerWorldPos);
                if (distance > 1000) return;

                // Add this item ID to the set of current falling items
                currentFallingItemIds.add(itemComp.item_id);

                // 复用已存在的图标或创建新的图标
                var iconNode = _this4.activeEquips.get(itemComp.item_id);
                if (!iconNode) {
                  if (_this4.equipNodePool.size() === 0) {
                    _this4.equipNodePool.put(instantiate(_this4.equipQualityNode));
                  }
                  iconNode = _this4.equipNodePool.get();
                  iconNode.name = "equip_" + itemComp.item_id;
                  var sprite = iconNode.getComponent(Sprite);
                  var maxIndex = _this4.itemColorArr.length - 1;
                  var index = itemComp.item_color - 5 > maxIndex ? maxIndex : itemComp.item_color - 5;
                  index = Math.max(0, index);
                  if (sprite) {
                    App.resMgr.loadImage(sprite, ModuleDef.GAME_BATTLE_B, "/images/battleUI/icon_zhuangbei_0" + (index + 1));
                  }
                  _this4.activeEquips.set(itemComp.item_id, iconNode);
                  _this4.miniMapRoot.addChild(iconNode);
                }

                // 计算图标位置
                var offsetX = (child.worldPosition.x - playerWorldPos.x) * scaleRatio * _this4.MINI_MAP_SCALE;
                var offsetY = (child.worldPosition.y - playerWorldPos.y) * scaleRatio * _this4.MINI_MAP_SCALE;
                var finalPos = new Vec3(_this4.miniRole.position.x + offsetX, _this4.miniRole.position.y + offsetY, 0);
                var halfWidth = _this4.miniMapRoot.getComponent(UITransform).width / 2;
                var halfHeight = _this4.miniMapRoot.getComponent(UITransform).height / 2;

                // 设置图标显示状态
                if (finalPos.x > halfWidth || finalPos.y > halfHeight || finalPos.x < -halfWidth || finalPos.y < -halfHeight) {
                  iconNode.active = false;
                } else {
                  iconNode.active = true;
                  iconNode.setPosition(finalPos);
                }
              }
            }
          });

          // 回收不再活跃的装备图标
          for (var _iterator = _createForOfIteratorHelperLoose(this.activeEquips.entries()), _step; !(_step = _iterator()).done;) {
            var _step$value = _step.value,
              itemId = _step$value[0],
              iconNode = _step$value[1];
            if (!currentFallingItemIds.has(itemId)) {
              this.equipNodePool.put(iconNode);
              this.activeEquips["delete"](itemId);
            }
          }
        }

        /**
         * 显示怪物
         */;
        _proto.showMonster = function showMonster() {
          var _this5 = this;
          var player = App.battleMgr.roleCtrl.player;
          if (!(player != null && player.roleVO)) {
            return;
          }
          var playerWorldPos = player.node.worldPosition;
          var entityMap = App.battleMgr.roleCtrl.entityMap;
          var scaleRatio = this.miniMapWidth / this.mapWidth;

          // 遍历所有实体
          for (var _iterator2 = _createForOfIteratorHelperLoose(entityMap), _step2; !(_step2 = _iterator2()).done;) {
            var _step2$value = _step2.value,
              uid = _step2$value[0],
              entity = _step2$value[1];
            if (entity.type === GameBattle.RoleType.Monster) {
              var monsterRole = entity;
              if (monsterRole.roleVO.quality === GameBattle.MonsterQuality.Elite) {
                var monsterWorldPos = monsterRole.node.worldPosition;
                var distance = Vec3.distance(playerWorldPos, monsterWorldPos);
                if (distance > 1000) {
                  continue;
                }
                var monsterNode = this.activeMonsters.get(uid);
                if (!monsterNode) {
                  if (this._monsterNodePool.size() === 0) {
                    this._monsterNodePool.put(instantiate(this.monsterPoolNode));
                  }
                  monsterNode = this._monsterNodePool.get();
                  this.activeMonsters.set(uid, monsterNode);
                  this.miniMapRoot.addChild(monsterNode);
                }
                var offsetX = (monsterWorldPos.x - playerWorldPos.x) * scaleRatio * this.MINI_MAP_SCALE;
                var offsetY = (monsterWorldPos.y - playerWorldPos.y) * scaleRatio * this.MINI_MAP_SCALE;
                var finalPos = new Vec3(this.miniRole.position.x + offsetX, this.miniRole.position.y + offsetY, 0);
                var halfWidth = this.miniMapRoot.uiTransform.width / 2;
                var halfHeight = this.miniMapRoot.uiTransform.height / 2;
                if (finalPos.x > halfWidth || finalPos.y > halfHeight || finalPos.x < -halfWidth || finalPos.y < -halfHeight) {
                  monsterNode.active = false;
                } else {
                  monsterNode.active = true;
                  monsterNode.setPosition(finalPos);
                }
              }
            }
          }
          // 回收不再活跃的怪物节点
          this.activeMonsters.forEach(function (node, uid) {
            if (!entityMap.has(uid)) {
              _this5._monsterNodePool.put(node);
              _this5.activeMonsters["delete"](uid);
            }
          });
        }

        /**
         * 更新小地图位置（当玩家移动时调用）
         */;
        _proto.updateMiniPos = function updateMiniPos(x, y, playerPos) {
          var mapCenterX = this.mapWidth / 2;
          var mapCenterY = this.mapHeight / 2;
          var playerOffsetX = playerPos.x - mapCenterX;
          var playerOffsetY = playerPos.y - mapCenterY;
          var scaleRatio = this.miniMapWidth / this.mapWidth;
          var offsetX = -playerOffsetX * scaleRatio;
          var offsetY = -playerOffsetY * scaleRatio;

          // 考虑父节点的缩放和初始位置
          var finalX = 130 + offsetX * this.MINI_MAP_SCALE;
          var finalY = 83 + offsetY * this.MINI_MAP_SCALE;
          this.miniMapParent.setPosition(finalX, finalY);
          this.showMapIcons();
          this.handleEquipmentDrop();
        };
        _proto.update = function update(dt) {
          this.showMonster();
        };
        _proto.onDestroy = function onDestroy() {
          var _this6 = this;
          this.activeMonsters.forEach(function (node) {
            _this6._monsterNodePool.put(node);
          });
          this.activeMonsters.clear();
          this.activeBaoXiangs.forEach(function (node) {
            _this6.baoXiangNodePool.put(node);
          });
          this.activeBaoXiangs.clear();
          this.activeTotems.forEach(function (node) {
            _this6.totemNodePool.put(node);
          });
          this.activeTotems.clear();
          this.activeWeaponRacks.forEach(function (node) {
            _this6.weaponRackNodePool.put(node);
          });
          this.activeWeaponRacks.clear();

          // 清理装备图标对象池
          this.equipNodePool.clear();
          this.activeEquips.forEach(function (node) {
            _this6.equipNodePool.put(node);
          });
          this.activeEquips.clear();
        };
        _proto.dispose = function dispose() {
          App.monitorMgr.offTarget(this);
        };
        return BattleMiniMapCtrl;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "miniMapParent", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "miniMapImg", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "miniRole", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "poolNode", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "monsterPoolNode", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "miniMapRoot", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "lbGuanQiuaName", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "baoxiangPoolNode", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "totemPoolNode", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "weaponRackPoolNode", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "equipQualityNode", [_dec12], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleNewMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './ModuleDef.ts', './BulletCtrl.ts', './DamageTips.ts', './BattleDefine.ts', './RoleCtrl.ts', './SkillCtrl.ts', './FallingPropCtrl.ts', './UIMgr.ts', './uiGameLoading.ts', './BattleNpcCtrl.ts', './DBRecord.ts', './GameStateMgr.ts', './BattleGlobalData.ts', './ui_Defeat.ts', './App.ts', './BattleUtil.ts', './UI_MainView.ts', './Layout_UI_MainView.ts', './TeamMgr.ts', './EventType.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _extends, _createClass, _asyncToGenerator, _regeneratorRuntime, cclegacy, Tween, TweenSystem, Node, ModuleDef, BulletCtrl, DamageTips, GameBattle, RoleCtrl, SkillCtrl, FallingPropCtrl, UIMgr, LayerType, uiGameLoading, BattleNpcCtrl, DBRecord, GameState, BattleGlobalData, ui_Defeat, App, BattleUtil, UI_MainView, Layout_UI_MainView, TeamMgr, EventType;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _extends = module.extends;
      _createClass = module.createClass;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      Tween = module.Tween;
      TweenSystem = module.TweenSystem;
      Node = module.Node;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      BulletCtrl = module.BulletCtrl;
    }, function (module) {
      DamageTips = module.DamageTips;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      RoleCtrl = module.RoleCtrl;
    }, function (module) {
      SkillCtrl = module.SkillCtrl;
    }, function (module) {
      FallingPropCtrl = module.FallingPropCtrl;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      uiGameLoading = module.uiGameLoading;
    }, function (module) {
      BattleNpcCtrl = module.BattleNpcCtrl;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      GameState = module.GameState;
    }, function (module) {
      BattleGlobalData = module.BattleGlobalData;
    }, function (module) {
      ui_Defeat = module.ui_Defeat;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }, function (module) {
      UI_MainView = module.UI_MainView;
    }, function (module) {
      Layout_UI_MainView = module.Layout_UI_MainView;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      EventType = module.EventType;
    }],
    execute: function () {
      cclegacy._RF.push({}, "bd4cbQDPmpGg7r4v0QNIVvf", "BattleNewMgr", undefined);
      var TypeGuanQia = exports('TypeGuanQia', /*#__PURE__*/function (TypeGuanQia) {
        TypeGuanQia[TypeGuanQia["Main"] = 1] = "Main";
        TypeGuanQia[TypeGuanQia["Guide"] = 99] = "Guide";
        return TypeGuanQia;
      }({}));

      /**通关宝箱领取状态 */
      var RewardReceiveState = exports('RewardReceiveState', /*#__PURE__*/function (RewardReceiveState) {
        RewardReceiveState[RewardReceiveState["Lock"] = 0] = "Lock";
        RewardReceiveState[RewardReceiveState["CanReceive"] = 1] = "CanReceive";
        RewardReceiveState[RewardReceiveState["Received"] = 2] = "Received";
        return RewardReceiveState;
      }({}));

      /**通关奖励宝箱类型 */
      var RewardChestType = exports('RewardChestType', /*#__PURE__*/function (RewardChestType) {
        RewardChestType[RewardChestType["Fast"] = 0] = "Fast";
        RewardChestType[RewardChestType["Normal"] = 1] = "Normal";
        return RewardChestType;
      }({}));
      var BattleNewMgr = exports('BattleNewMgr', /*#__PURE__*/function () {
        function BattleNewMgr() {
          this._roleCtrl = new RoleCtrl();
          this._bulletCtrl = new BulletCtrl();
          this._skillCtrl = new SkillCtrl();
          this._battleMainViewCtrl = void 0;
          this._battleNpcCtrl = new BattleNpcCtrl();
          this._playerCamera = void 0;
          /** 伤害提示UI唯一id生成器 */
          this._damageTipsUIDCounter = 0;
          /** 伤害提示UI列表 */
          this._damgeTipsMap = new Map();
          this.fallingPropCtrl = new FallingPropCtrl();
          this.guanka_list = [];
          this._curGuanQiaId = 0;
          /** 挑战主线关卡ID */
          this.challengeGuanQiaId = 0;
          /** 挑战主线关卡ID 缓存, 用于进入其他副本后还原主线副本ID */
          this.challengeGuanQiaIdCatch = 0;
          this.guankaUnLock = false;
          //是否解锁关卡
          this.tongguanGuanQiaId = -1;
          //最新通关的关卡ID   新增-1的时候表示协议还没到
          this.lastTgGuanQiaId = 0;
          //上一次通关的关卡ID
          this.lastChallengeIsNewest = true;
          //上一次挑战的是否是最新主线关卡
          this.lastChallengeQuanQiaId = 0;
          //上一次挑战的主线关卡
          /** 所有关卡列表 */
          this.allGuanQiaList = void 0;
          /** 自动跳转挑战关卡双倍 */
          this._autoJumpShuangBei = false;
          /** 自动跳转挑战关卡倍数 */
          this._autoJumpBeishu = 0;
          this._pause = false;
          this.diMao = 0;
          this._runningActions = [];
          this.globalData = new BattleGlobalData();
          this.guanQiaType = GameBattle.GuanQiaType.None;
          this.reviveCount = 0;
          /** 幸运宝箱当前领取次数 */
          this.cur_xybx_times = 0;
          /** 幸运宝箱最大领取次数 */
          this.max_xybx_times = 0;
          /** 最大同时存在的伤害提示数量 */
          this.MAX_DAMAGE_TIPS = 50;
          /** 当前活跃的伤害提示数量 */
          this._activeDamageTipsCount = 0;
          // 帧管理相关
          this._frameCounter = 0;
          // 主线副本计时相关
          this._mainFBTimer = null;
          this.FB_TIME_INTERVAL = 1;
          this._bossIsDead = false;
          this._isInBattle = false;
          //图鉴加成
          this._mTuJianAttr = {};
          /** 进入过战斗 */
          this.enterBattleFlag = false;
          this.commomUiTimer = [false, false, false];
          /**
           * 本次战斗随机boss id
           */
          this.curRandomBossId = 0;
          this.allBulletIdList = [];
          /** 新手引导战斗子弹资源列表 */
          this.GuideBattleBulletResList = ["effect_bullet_fashi_shengguangrensuxuanfeng", "effect_Monster_YuanZhengJunGongNuShou_Bullet", "effect_bullet_fashi_luoleishu", "effect_dummy_leimingchuxiang", "effect_dummy_tiannushenfa"];
          /** 战斗子弹资源列表补漏 */
          this.BulletResList = {
            // [GameBattle.RoleJob.fashi]: [],
            // [GameBattle.RoleJob.taidao]: ["effect_bullet_taidao_dujianqi", "effect_bullet_taidao_chaogaosutuxi02"]
          };
          this.noLoadBulletIdList = new Set();
        }
        var _proto = BattleNewMgr.prototype;
        /**
         * 获取当前帧组(0或1)
         */
        _proto.getCurrentFrame = function getCurrentFrame() {
          return this._frameCounter;
        };
        _proto.init = function init() {
          // this._roleCtrl.init();
        };
        _proto.dispose = function dispose() {
          Tween.stopAllByTag(GameBattle.BattleTweenTag);
          this._roleCtrl.dispose();
        }

        /**
         * 检查关卡是否解锁
         * @param guanQiaId 关卡id
         * @returns
         */;
        _proto.checkGuanQiaUnlock = function checkGuanQiaUnlock(guanQiaId) {
          return guanQiaId < this.curGuanQiaId;
        };
        _proto.initPool = function initPool() {
          // App.mapMgr.clearMap();
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.RolePrefabPath[GameBattle.RoleType.Hero], {
            preloadCount: 200,
            maxSize: 200,
            autoExpand: true
          });
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips, {
            preloadCount: 200,
            maxSize: 200,
            autoExpand: true
          });
          for (var _key in GameBattle.OtherPrefabPath) {
            App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath[_key], {
              preloadCount: 20,
              maxSize: 20,
              autoExpand: true
            });
          }
          for (var i = 3; i < 9; i++) {
            App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "images/effect_FallingProp_trail/effect_FallingProp_trail" + i, {
              preloadCount: 20,
              maxSize: 20,
              autoExpand: true
            });
          }
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/effect/damageNum", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/affected", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
          App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/buffEffect", {
            preloadCount: 50,
            maxSize: 60,
            autoExpand: true
          });
        };
        _proto.clearPool = function clearPool() {
          for (var _key2 in GameBattle.OtherPrefabPath) {
            App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath[_key2]);
          }
          for (var i = 3; i < 9; i++) {
            App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "images/effect_FallingProp_trail/effect_FallingProp_trail" + i);
          }
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/effect/damageNum");
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/affected");
          App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, "prefabs/scene/effect/buffEffect");
        };
        _proto.setPause = function setPause(v) {
          this._pause = v;
          if (v) {
            this._runningActions = TweenSystem.instance.ActionManager.pauseAllRunningActions();
            var popActions = [];
            for (var i = this._runningActions.length; i--;) {
              if (this._runningActions[i] instanceof Node && this._runningActions[i].name === "uiPrompt") {
                popActions.push(this._runningActions[i]);
                this._runningActions.splice(i, 1);
              }
            }
            if (popActions.length > 0) {
              TweenSystem.instance.ActionManager.resumeTargets(popActions);
            }
            if (this._battleMainViewCtrl && this._battleMainViewCtrl.battleMap) this.pauseNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
            App.scheduleMgr.pauseAll();
          } else {
            TweenSystem.instance.ActionManager.resumeTargets(this._runningActions);
            this._runningActions = [];
            if (this._battleMainViewCtrl && this._battleMainViewCtrl.battleMap) this.resumeNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
            App.scheduleMgr.resumeAll();
          }
        }

        /**
         * 暂停节点及其所有子节点
         * @param node
         */;
        _proto.pauseNodeAndChildren = function pauseNodeAndChildren(node) {
          var _this = this;
          // 暂停骨骼动画
          if (node.spine) {
            node.spine.paused = true;
          }
          node.children.forEach(function (child) {
            _this.pauseNodeAndChildren(child);
          });
        }

        /**
         * 恢复节点及其所有子节点
         * @param node
         */;
        _proto.resumeNodeAndChildren = function resumeNodeAndChildren(node) {
          var _this2 = this;
          // 恢复骨骼动画
          if (node.spine) {
            node.spine.paused = false;
          }

          // 遍历并恢复所有子节点
          node.children.forEach(function (child) {
            _this2.resumeNodeAndChildren(child);
          });
        }

        /**
         * 更新
         */;
        _proto.update = function update(dt) {
          if (this._pause) return;

          //console.time('roleCtrl.update');
          this._roleCtrl.update(dt);
          //console.timeEnd('roleCtrl.update');

          this._skillCtrl.update(dt);
          this._bulletCtrl.update(dt);
          this.fallingPropCtrl.update(dt);
          this._frameCounter = 1 - this._frameCounter;
        }

        /**
         * 开始主线副本计时
         */;
        _proto.startMainFBTimer = function startMainFBTimer() {
          this.bossIsDead = false;
        }

        /**
         * 进入战场
         */;
        _proto.onEnter = function onEnter() {
          this.enterBattleFlag = true;
          this._isInBattle = true;
          this.setPause(false);
          UIMgr.inst.preloadUIBundle(ui_Defeat, function () {
            console.log("预加载战斗失败页面成功");
          });
          this.bossIsDead = false;
          // UIMgr.inst.preloadUIBundle(uiLuckBox, () => {
          //     console.log('预加载转盘页面');
          // });
          this.initPool();
          this.globalData.init();
          this._roleCtrl.onEnter();
          this._skillCtrl.onEnter();
          this._bulletCtrl.onEnter();
          this._battleNpcCtrl.onEnter(this.challengeGuanQiaId);

          // 初始化碰撞网格调试渲染器
          // if (GameConfig.DebugInfo.useCollisionGrid) {
          //     CollisionMgr.inst.initDebugRenderer(this._battleMainViewCtrl.node);
          // }
          this.playerCamera = this._battleMainViewCtrl.playerCamera;
          App.gameStateMgr.state = GameState.Battle_ZhuxianGuanQia;
          this.playBattleMusic();
          this.reviveCount = 0;

          // 如果是主线副本,开始计时
          if (this.guanQiaType === GameBattle.GuanQiaType.MainLine) {
            this.startMainFBTimer();
          }
          this.fallingPropCtrl.onEnter();
        }

        /**
         * 退出战场
         */;
        _proto.onExit = /*#__PURE__*/
        function () {
          var _onExit = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(_type, callFunc, openMain) {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (callFunc === void 0) {
                    callFunc = null;
                  }
                  if (openMain === void 0) {
                    openMain = true;
                  }
                  this._isInBattle = false;
                  this._pause = false;
                  this.clearPool();
                  // ui.onProgress(0)
                  Tween.stopAllByTag(GameBattle.BattleTweenTag);
                  if (this._battleMainViewCtrl) {
                    if (this._battleMainViewCtrl.battleMap) {
                      this.resumeNodeAndChildren(this._battleMainViewCtrl.battleMap.node.parent);
                    }
                    // this._battleMainViewCtrl.battleCtrlView.joystickItem.onEnd();
                    this._battleMainViewCtrl.onExit();
                  }
                  this.guanQiaType = GameBattle.GuanQiaType.None;
                  this._roleCtrl.onExit();
                  this._skillCtrl.onExit();
                  this._bulletCtrl.onExit();
                  this.recoveryAllDamageTips();
                  App.dungeonBattleMgr.dispose();
                  App.scheduleMgr.clear();
                  this._battleMainViewCtrl = undefined;
                  this.fallingPropCtrl.onExit();
                  App.soundMgr.clearAllBattleSound();
                  if (this.challengeGuanQiaIdCatch > 0) {
                    this.challengeGuanQiaId = this.challengeGuanQiaIdCatch;
                    this.challengeGuanQiaIdCatch = -1;
                  }
                  // 清理计时器
                  if (this._mainFBTimer) {
                    App.scheduleMgr.unschedule(this._mainFBTimer);
                    this._mainFBTimer = null;
                    this.bossIsDead = false;
                  }
                  this._mTuJianAttr = {};
                  this.curRandomBossId = 0;
                  App.mapMgr.clearMapWayPoint();
                  if (openMain) {
                    _context.next = 25;
                    break;
                  }
                  return _context.abrupt("return");
                case 25:
                  console.warn("######### AutoFight BattleManager.onExit()");
                  _context.next = 28;
                  return this.enterCity(function () {
                    console.warn("######### AutoFight BattleManager.onExit().enterCity().callBack closeAllPanel() ");
                    UIMgr.inst.closeAllPanel(["uiLoading", "uiFunctionUnlock"]);
                    if (callFunc) callFunc();
                  });
                case 28:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function onExit(_x, _x2, _x3) {
            return _onExit.apply(this, arguments);
          }
          return onExit;
        }()
        /**
         * 进入主城
         */;

        _proto.enterCity = /*#__PURE__*/
        function () {
          var _enterCity = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2(callback) {
            var ui, progressValues, _loop, i;
            return _regeneratorRuntime().wrap(function _callee2$(_context3) {
              while (1) switch (_context3.prev = _context3.next) {
                case 0:
                  _context3.next = 2;
                  return UIMgr.inst.asyncOpen(uiGameLoading, LayerType.load);
                case 2:
                  ui = _context3.sent;
                  ui.setCloseByHand(true);
                  progressValues = [0.15, 0.25, 0.35, 0.55, 0.65, 0.75, 0.85, 0.92, 0.96, 1.0];
                  _loop = /*#__PURE__*/_regeneratorRuntime().mark(function _loop(i) {
                    return _regeneratorRuntime().wrap(function _loop$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          setTimeout(function () {
                            ui.onProgress(progressValues[i]);
                            if (i === 9) {
                              ui.onClose();
                              console.warn("######### AutoFight BattleManager.onExit().enterCity() delay i === 9 closeAllPanel() ");
                              UIMgr.inst.closeAllPanel(["uiMain", "uiJingJiChang", "uiFunctionUnlock", "uiPrompt", "uiBlockLayer"]);
                              App.monitorMgr.dispatchEvent(EventType.loading_end_to_mainGame);
                              // App.autoFightManager.closeProgressBar();
                              if (callback) {
                                callback();
                              }
                            }
                          }, 100 * i + Math.random() * 100 * i);
                        case 1:
                        case "end":
                          return _context2.stop();
                      }
                    }, _loop);
                  });
                  i = 0;
                case 7:
                  if (!(i < 10)) {
                    _context3.next = 12;
                    break;
                  }
                  return _context3.delegateYield(_loop(i), "t0", 9);
                case 9:
                  i++;
                  _context3.next = 7;
                  break;
                case 12:
                  _context3.next = 14;
                  return UIMgr.inst.openOnce(UI_MainView, LayerType.main, Layout_UI_MainView, null, function () {});
                case 14:
                case "end":
                  return _context3.stop();
              }
            }, _callee2);
          }));
          function enterCity(_x4) {
            return _enterCity.apply(this, arguments);
          }
          return enterCity;
        }()
        /**
         * 播放战斗音乐
         */;

        _proto.playBattleMusic = function playBattleMusic() {
          var soundId = App.soundMgr.getBattleMusicId(App.battleMgr.diMao);
          if (soundId) {
            App.soundMgr.playMusicById(soundId);
          }
        }

        /**
         * 创建伤害提示UI
         * @returns
         */;
        _proto.createDamageTips = function createDamageTips() {
          if (!this._battleMainViewCtrl) return;
          if (this._activeDamageTipsCount >= this.MAX_DAMAGE_TIPS) {
            return null;
          }
          var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips);
          if (!node) return null;
          var tips = node.getComponent(DamageTips);
          tips.node.parent = this._battleMainViewCtrl.effectLayer;
          tips.uid = ++this._damageTipsUIDCounter;
          this._damgeTipsMap.set(tips.uid, tips);
          this._activeDamageTipsCount++;
          return tips;
        }

        /**
         * 回收伤害提示
         */;
        _proto.recoveryDamageTips = function recoveryDamageTips(tips) {
          if (!tips) return;
          this._damgeTipsMap["delete"](tips.uid);
          tips.recovery();
          tips.uid = 0;
          this._activeDamageTipsCount--;
          App.nodePoolMgr.putNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.DamageTips, tips.node);
        }

        /**
         * 回收所有伤害提示UI
         */;
        _proto.recoveryAllDamageTips = function recoveryAllDamageTips() {
          var _this3 = this;
          this._damgeTipsMap.forEach(function (v) {
            _this3.recoveryDamageTips(v);
          });
          this._damgeTipsMap.clear();
          this._activeDamageTipsCount = 0;
        }

        /**
         * 设置战场背景
         * @param pos
         * @param diMao
         */;
        _proto.setBattleBg = function setBattleBg(pos, diMao) {
          var _this$_battleMainView;
          var x = pos.x - this._battleMainViewCtrl.battleBg.w / 2;
          var y = pos.y - this._battleMainViewCtrl.battleBg.h / 2;
          this._battleMainViewCtrl.battleBg.setWorldPosition(x, y, 0);
          App.resMgr.loadImage((_this$_battleMainView = this._battleMainViewCtrl) == null || (_this$_battleMainView = _this$_battleMainView.battleBg) == null ? void 0 : _this$_battleMainView.sprite, "battleMap", "map" + diMao + "/background");
        };
        _proto.getGuankaList = function getGuankaList() {
          return this.guanka_list;
        }

        /**
         * 获取速通奖励领取状态
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaSuTongType = function getGuanQiaSuTongType(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].receive1;
            }
          }
          return 0;
        }

        /**
         * 获取首通奖励领取状态
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaShouTongType = function getGuanQiaShouTongType(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].receive;
            }
          }
          return 0;
        }

        /**
         * 获取关卡最快通关时间
         * @param guanQiaId
         * @returns
         */;
        _proto.getGuanQiaFastestPassTime = function getGuanQiaFastestPassTime(guanQiaId) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              return this.guanka_list[i].tg_second;
            }
          }
          return 0;
        }

        /**
         * 设置速通宝箱领取状态
         * @param guanQiaId
         * @param type
         */;
        _proto.settGuanQiaSuTongType = function settGuanQiaSuTongType(guanQiaId, type) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              if (type > this.guanka_list[i].receive1) {
                this.guanka_list[i].receive1 = type;
              }
            }
          }
        }

        /**
         * 设置首通宝箱领取状态
         * @param guanQiaId
         * @param type
         */;
        _proto.settGuanQiaShouTongType = function settGuanQiaShouTongType(guanQiaId, type) {
          for (var i = this.guanka_list.length; i--;) {
            if (guanQiaId === this.guanka_list[i].guanka_id) {
              if (type > this.guanka_list[i].receive) {
                this.guanka_list[i].receive = type;
              }
            }
          }
        };
        _proto.getPassIdMax = function getPassIdMax() {
          return this.tongguanGuanQiaId;
        };
        _proto.getFbCfg = function getFbCfg(fbid) {
          var cfg = DBRecord.fetchId("Fb", fbid);
          if (!cfg) return null;
          return cfg;
        }

        /**
         * 找出配置表GuanQia中，最大的关卡，也就是最大的ID
         * @returns 最大的关卡ID
         */;
        _proto.findMaxGuanQiaId = function findMaxGuanQiaId() {
          var maxId = 0;
          var guanQiaList = DBRecord.fetchAll("GuanQia");
          for (var i = 0; i < guanQiaList.length; i++) {
            if (guanQiaList[i].type === 1 && guanQiaList[i].id > maxId) {
              maxId = guanQiaList[i].id;
            }
          }
          return maxId;
        };
        /**
         * 战斗飘字提示
         * @param str 提示内容
         */
        _proto.popTips = function popTips(str, type) {
          var _this4 = this;
          if (this.commomUiTimer[type]) {
            return;
          }
          this.commomUiTimer[type] = true;
          var tmIndex = [0, 0, 1]; //42 血瓶能量瓶  43 技能
          this._battleMainViewCtrl.battleUIView.popTips(str);
          var cfg = DBRecord.fetchId("ShuoMingQuanJu", 42 + tmIndex[type]);
          var tm = Number(cfg.value);
          setTimeout(function () {
            _this4.commomUiTimer[type] = false;
          }, tm);
        }

        /**
         * 检查当前关卡是否为主线关卡
         * @returns
         */;
        _proto.isMainLineGuanQia = function isMainLineGuanQia() {
          return this.guanQiaType === GameBattle.GuanQiaType.MainLine;
        }

        /**
         * 是否在战斗中
         */;
        _proto.isInBattle = function isInBattle() {
          return this._isInBattle;
        }

        /**
         * 获取地图数据
         * @param diMao
         */;
        _proto.getMapData = function getMapData(diMao) {
          var _mapData = {};
          var guanQiaId = App.battleMgr.challengeGuanQiaId;
          var cfg = DBRecord.fetchId("GuanQia", guanQiaId);
          var random_map = cfg.random_map;
          var diMaoIndex = 0;
          for (var i = 0; i < random_map.length; i++) {
            if (diMao === random_map[i][0]) {
              diMaoIndex = i;
              break;
            }
          }
          var monster_density = cfg.monster_density[diMaoIndex];
          _mapData = {};
          var dbr = DBRecord.fetchAll("DiKuai");
          var born_map = [];
          for (var _iterator = _createForOfIteratorHelperLoose(dbr), _step; !(_step = _iterator()).done;) {
            var it = _step.value;
            if (it.name === diMao && it.monster_density === monster_density) {
              if (!_mapData[it["in"]]) {
                _mapData[it["in"]] = [];
              }
              _mapData[it["in"]].push(it);
              if (it["in"] === 0) {
                born_map.push(it);
              }
            }
          }
          return [_mapData, born_map];
        };
        _proto.initFbMonsterSpawnCfg = function initFbMonsterSpawnCfg(fbId) {
          // 优化后的怪物出生配置初始化函数，修复空对象赋值以及对象初始化的问题，避免空指针、脏数据等

          var list = [];
          var fb_monsters = DBRecord.fetchKvs("Fb_Monster", {
            fbid: fbId
          });

          // 提前判断
          if (!Array.isArray(fb_monsters) || fb_monsters.length === 0) {
            return list;
          }
          for (var _iterator2 = _createForOfIteratorHelperLoose(fb_monsters), _step2; !(_step2 = _iterator2()).done;) {
            var cfg = _step2.value;
            if (!cfg || !Array.isArray(cfg.monster) || cfg.monster.length === 0) continue;

            // 初始化spCfg，不能直接null
            var spCfg = {
              waveId: cfg.wave,
              spawnTime: cfg.time,
              waveCfg: []
            };
            for (var j = 0; j < cfg.monster.length; j++) {
              var mCfg = cfg.monster[j];
              if (Array.isArray(mCfg) && mCfg.length > 2) {
                var monsterId = mCfg[1];
                var gwCfg = DBRecord.fetchId("GuaiWu", monsterId);

                // 初始化waveCfg
                var waveCfg = {
                  lane: mCfg[0],
                  monsterId: monsterId,
                  count: mCfg[2],
                  monsterType: gwCfg ? gwCfg.type : 0,
                  monsterQuality: 1,
                  interval: 0.2,
                  isBoss: gwCfg ? gwCfg.type === 2 : false
                };
                spCfg.waveCfg.push(waveCfg);
              }
            }
            // 只添加有怪物的波次
            if (spCfg.waveCfg.length > 0) {
              list.push(spCfg);
            }
          }
          return list;
        }

        /**
         * 初始化当前章节所有怪物的资源名称
         */;
        _proto.initAllMonsterRes = function initAllMonsterRes(fb_monsters) {
          if (!fb_monsters) {
            console.warn("无怪物，无法初始化怪物数据");
            return;
          }

          // 用于存储所有怪物ID，避免重复
          var monsterIds = new Set();
          var monsterResSet = new Set();
          var monsterNameList = [];
          var mosnterResList = [];

          // 遍历数组中的怪物信息
          for (var i = 0; i < fb_monsters.length; i++) {
            var cfg = fb_monsters[i];
            if (!cfg || cfg.monster.length <= 0) continue;

            // 遍历该地块的所有怪物出生点
            var monsterBornList = cfg.monster;
            for (var j = 0; j < monsterBornList.length; j++) {
              var data = monsterBornList[j];
              if (!data || data.length < 2) continue;

              // 获取怪物组ID
              var monsterId = data[1];
              var monsterCfg = DBRecord.fetchId("GuaiWu", monsterId);
              if (!monsterCfg) continue;
              if (!monsterIds.has(monsterCfg.id)) {
                monsterIds.add(monsterCfg.id);
              }
              if (!monsterResSet.has(monsterCfg.res)) {
                monsterResSet.add(monsterCfg.res);
                monsterNameList.push(monsterCfg.res);
                mosnterResList.push({
                  bundle: ModuleDef.MONSTER,
                  name: monsterCfg.res,
                  actions: ["Idle", "Move", "Attack", "Dead"]
                });
              }
            }
          }

          //console.log('================================>>当前章节所有怪物动画名称列表:', monsterNameList);
          var monsterIdList = Array.from(monsterIds);
          return [mosnterResList, monsterIdList];
        }
        /**
         * 初始化英雄和士兵资源
         * @returns [{bundle: ModuleDef.HERO, name: heroCfg.res, actions: [ "Idle", "Move", "Attack", "Dead", "Skill"]}]
         */;
        _proto.initHeroAndSoldierRes = function initHeroAndSoldierRes() {
          var formation = TeamMgr.inst.currFormation;
          var heros = formation.heros;
          var soldiers = formation.soldiers;
          var resList = [];
          var heroIdsIds = new Set();
          var heroIdsResSet = new Set();
          heros.forEach(function (hero) {
            if (hero.id > 0) {
              var heroCfg = TeamMgr.inst.getHeroIdCfg(hero.id);
              if (heroCfg) {
                if (!heroIdsIds.has(heroCfg.id)) {
                  heroIdsIds.add(heroCfg.id);
                }
                if (!heroIdsResSet.has(heroCfg.res)) {
                  heroIdsResSet.add(heroCfg.res);
                  resList.push({
                    bundle: ModuleDef.HERO,
                    name: heroCfg.res,
                    actions: ["Idle", "Move", "Attack", "Dead", "Skill"]
                  });
                }
              }
            }
          });
          soldiers.forEach(function (soldier) {
            if (soldier.id > 0) {
              var soldierCfg = TeamMgr.inst.getSoldierIdCfg(soldier.id);
              if (soldierCfg) {
                resList.push({
                  bundle: ModuleDef.SOLDIER,
                  name: soldierCfg.res,
                  actions: ["Idle", "Move", "Attack", "Dead"]
                });
              }
            }
          });
          return resList;
        };
        /**
         * 先确定随机boss的id,方便laoding时加载boss资源
         */
        _proto.initRandomBossId = function initRandomBossId() {
          var dbr = DBRecord.fetchId("GuanQia", this.challengeGuanQiaId);
          if (dbr && dbr.bossid && dbr.bossid.length > 0) {
            this.curRandomBossId = BattleUtil.getValueByProbability(dbr.bossid);
          }
          //console.log('================================>>本次战斗随机boss id:', this.curRandomBossId);
          return this.curRandomBossId;
        };
        /**
         * 初始化当前章节所有子弹的资源名称
         */
        _proto.getAllBulletRes = function getAllBulletRes(monsterIdList) {
          var allBulletList = [];
          var allBuffs = [];

          //怪物技能id
          var monsterSkillList = [];
          for (var i = 0; i < monsterIdList.length; i++) {
            var cfg = DBRecord.fetchId("GuaiWu", monsterIdList[i]);
            if (cfg) {
              if (cfg.init_buff_id) {
                for (var j = 0; j < cfg.init_buff_id.length; j++) {
                  allBuffs.push(cfg.init_buff_id[j]);
                }
              }
              if (cfg.skill_id) {
                for (var _j = 0; _j < cfg.skill_id.length; _j++) {
                  monsterSkillList.push(cfg.skill_id[_j]);
                }
              }
              if (cfg.atk_id) {
                monsterSkillList.push(cfg.atk_id);
              }
            }
          }
          //怪物技能buff、子弹
          for (var _i = 0, _monsterSkillList = monsterSkillList; _i < _monsterSkillList.length; _i++) {
            var it = _monsterSkillList[_i];
            var _cfg = DBRecord.fetchId("Skill", it);
            if (_cfg && _cfg.buff_id && _cfg.buff_id.length > 0) {
              for (var _i2 = 0; _i2 < _cfg.buff_id.length; _i2++) {
                allBuffs.push(_cfg.buff_id[_i2]);
              }
            }
            if (_cfg && _cfg.bullet_id) {
              for (var _i3 = 0; _i3 < _cfg.bullet_id.length; _i3++) {
                allBulletList.push(_cfg.bullet_id[_i3]);
              }
            }
          }

          //子弹创建的buff、子弹
          var bulletSubBuff = [];
          var subBulletList = [];
          for (var index = 0; index < allBulletList.length; index++) {
            var element = allBulletList[index];
            var _cfg2 = DBRecord.fetchId("JiNengXiaoGuo", element);
            //添加buff
            if (_cfg2 && _cfg2.type === 2) {
              if (_cfg2.atr && _cfg2.atr.length > 0) {
                for (var _i4 = 0; _i4 < _cfg2.atr.length; _i4++) {
                  bulletSubBuff.push(_cfg2.atr[_i4]);
                }
              }
            }
            //添加子弹
            if (_cfg2 && _cfg2.type === 4) {
              if (_cfg2.atr && _cfg2.atr.length > 0) {
                for (var _i5 = 0; _i5 < _cfg2.atr.length; _i5++) {
                  subBulletList.push(_cfg2.atr[_i5]);
                }
              }
            }
          }
          allBuffs.push.apply(allBuffs, bulletSubBuff);
          allBulletList.push.apply(allBulletList, subBulletList);

          //buff创建的buff
          var subBuffList = [];
          //修改子弹效果
          var modifyBulletEffect = [];
          //修改buff效果
          var modifyBuffEffect = [];
          for (var _index = 0; _index < allBuffs.length; _index++) {
            var _element = allBuffs[_index];
            var _cfg3 = DBRecord.fetchId("JiNengBuff", _element);
            if (!_cfg3) {
              continue;
            }
            if (_cfg3.effect_ids) {
              for (var _index2 = 0; _index2 < _cfg3.effect_ids.length; _index2++) {
                var elementEff = _cfg3.effect_ids[_index2];
                var xiaoguoCfg = DBRecord.fetchId("JiNengBuffXiaoGuo", elementEff);
                if (xiaoguoCfg.type === GameBattle.BuffEffectType.AddBuffByOdds) {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0) {
                    for (var _index3 = 0; _index3 < xiaoguoCfg.atr.length; _index3++) {
                      subBuffList.push(xiaoguoCfg.atr[_index3]);
                    }
                  }
                }
                if (xiaoguoCfg.configuration === "buff_id") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0) {
                    for (var _index4 = 0; _index4 < xiaoguoCfg.atr.length; _index4++) {
                      subBuffList.push(xiaoguoCfg.atr[_index4]);
                    }
                  }
                }
                if (xiaoguoCfg.type === GameBattle.BuffEffectType.EventBuff) {
                  if (xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    for (var _index5 = 0; _index5 < xiaoguoCfg.value.length; _index5++) {
                      subBuffList.push(xiaoguoCfg.value[_index5]);
                    }
                  }
                }
                //修改子弹效果
                if (xiaoguoCfg.grid_type === 2 && xiaoguoCfg.configuration === "effect_id") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0 && xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    modifyBulletEffect[xiaoguoCfg.atr[0]] = xiaoguoCfg.value[0];
                  }
                }
                //修改buff效果
                if (xiaoguoCfg.grid_type === 4 && xiaoguoCfg.configuration === "effect_ids") {
                  if (xiaoguoCfg.atr && xiaoguoCfg.atr.length > 0 && xiaoguoCfg.value && xiaoguoCfg.value.length > 0) {
                    for (var _index6 = 0; _index6 < xiaoguoCfg.value.length; _index6++) {
                      if (!modifyBuffEffect[xiaoguoCfg.atr[0]]) {
                        modifyBuffEffect[xiaoguoCfg.atr[0]] = [];
                      }
                      modifyBuffEffect[xiaoguoCfg.atr[0]].push(xiaoguoCfg.value[_index6]);
                    }
                  }
                }
              }
            }
          }
          allBuffs.push.apply(allBuffs, subBuffList);
          var allBulletResList = [];
          var allEffectResList = [];
          for (var _index7 = 0; _index7 < allBuffs.length; _index7++) {
            var _element2 = allBuffs[_index7];
            var _cfg4 = DBRecord.fetchId("JiNengBuff", _element2);
            if (_cfg4) {
              _cfg4 = _extends({}, _cfg4);
              if (_cfg4.effect_ids) {
                _cfg4.effect_ids = [].concat(_cfg4.effect_ids);
              }
            }
            if (_cfg4 && _cfg4.effect_ids) {
              if (modifyBuffEffect[_cfg4.id]) {
                var _cfg4$effect_ids;
                //console.log('================================>>TEST BULLET 修改buff效果:',cfg.id,modifyBuffEffect[cfg.id]);
                (_cfg4$effect_ids = _cfg4.effect_ids).push.apply(_cfg4$effect_ids, modifyBuffEffect[_cfg4.id]);
              }
              for (var _index8 = 0; _index8 < _cfg4.effect_ids.length; _index8++) {
                var effectElement = _cfg4.effect_ids[_index8];
                var _xiaoguoCfg = DBRecord.fetchId("JiNengBuffXiaoGuo", effectElement);
                if (_xiaoguoCfg.type === GameBattle.BuffEffectType.CreateBullet) {
                  if (_xiaoguoCfg.atr && _xiaoguoCfg.atr.length > 0) {
                    allBulletList.push(_xiaoguoCfg.atr[0]);
                  }
                }
                if (_xiaoguoCfg.configuration === "bullet_id") {
                  if (_xiaoguoCfg.value && _xiaoguoCfg.value.length > 0) {
                    allBulletList.push(_xiaoguoCfg.value[0]);
                  }
                } else if (_xiaoguoCfg.configuration === "res") {
                  if (_xiaoguoCfg.value) {
                    allBulletResList.push(_xiaoguoCfg.value);
                  }
                }
              }
            }
          }
          this.allBulletIdList = [].concat(allBulletList);
          //console.log('================================>>TEST BULLET 怪物列表:', monsterIdList);
          // console.log('================================>>TEST BULLET 子弹列表:', allBulletList);
          // console.log('================================>>TEST BULLET buff列表:', allBuffs);

          for (var _i6 = 0; _i6 < allBulletList.length; _i6++) {
            var _cfg5 = DBRecord.fetchId("JiNengZiDan", allBulletList[_i6]);
            if (_cfg5) {
              if (_cfg5.res) {
                allBulletResList.push(_cfg5.res);
              }
              if (_cfg5.hit_effect) {
                allEffectResList.push(_cfg5.hit_effect);
              }
            }
          }
          for (var _i7 = 0; _i7 < allBuffs.length; _i7++) {
            var _cfg6 = DBRecord.fetchId("JiNengBuff", allBuffs[_i7]);
            if (_cfg6) {
              if (_cfg6.vfx) {
                allEffectResList.push(_cfg6.vfx);
              }
            }
          }

          // if (this.guanQiaType === GameBattle.GuanQiaType.XinShou) {
          //     allBulletResList.push(...this.GuideBattleBulletResList);
          // } else {
          //     allBulletResList.push(...this.BulletResList[App.roleMgr.getRoleJob()]);
          // }
          allEffectResList = Array.from(new Set(allEffectResList));
          allBulletResList = Array.from(new Set(allBulletResList));
          // console.log('================================>>TEST BULLET 子弹资源列表:', allBulletResList);
          // console.log('================================>>TEST EFFECT 特效资源列表:', allEffectResList);
          return [allBulletResList, allEffectResList];
        };
        /**
         * 检查子弹是否加载，测试用
         * @param bulletId
         */
        _proto.checkPreLoadBullet = function checkPreLoadBullet(bulletId) {
          {
            if (this.allBulletIdList.findIndex(function (item) {
              return item === bulletId;
            }) < 0) {
              if (!this.noLoadBulletIdList.has(bulletId)) {
                console.warn("****************** TEST BULLET 子弹没有加载：", bulletId);
                this.noLoadBulletIdList.add(bulletId);
              }
            }
          }
        }
        /**
         * 检测木桩副本是否开始战斗了
         */;
        _proto.checkBattleStart = function checkBattleStart() {
          if (!this.battleMainViewCtrl) {
            return false;
          }
          // if (this.guanQiaType === GameBattle.GuanQiaType.MuZhuang) {
          //     if (!this.battleMainViewCtrl.battleMuZhuang) {
          //         return false;
          //     }
          //     return this.battleMainViewCtrl.battleMuZhuang.startBattle;
          // }
          // if (this.guanQiaType === GameBattle.GuanQiaType.JingJiChang) {
          //     if (!this.battleMainViewCtrl.battleJingJiChang) {
          //         return false;
          //     }
          //     return this.battleMainViewCtrl.battleJingJiChang.startBattle;
          // }
          return true;
        };
        _createClass(BattleNewMgr, [{
          key: "roleCtrl",
          get: function get() {
            return this._roleCtrl;
          }
        }, {
          key: "bulletCtrl",
          get: function get() {
            return this._bulletCtrl;
          }
        }, {
          key: "skillCtrl",
          get: function get() {
            return this._skillCtrl;
          }
        }, {
          key: "battleMainViewCtrl",
          get: function get() {
            return this._battleMainViewCtrl;
          },
          set: function set(v) {
            this._battleMainViewCtrl = v;
          }
        }, {
          key: "battleNpcCtrl",
          get: function get() {
            return this._battleNpcCtrl;
          }
        }, {
          key: "playerCamera",
          get: function get() {
            return this._playerCamera;
          },
          set: function set(val) {
            this._playerCamera = val;
          }
        }, {
          key: "pause",
          get: function get() {
            return this._pause;
          }
        }, {
          key: "curGuanQiaId",
          get: function get() {
            return this._curGuanQiaId;
          }

          /**
           * 获取boss是否已死亡
           * @returns
           */,
          set: function set(v) {
            this._curGuanQiaId = v;
          }
        }, {
          key: "bossIsDead",
          get: function get() {
            return this._bossIsDead;
          }

          /**
           * 设置boss是否已死亡
           * @param value
           */,
          set: function set(value) {
            this._bossIsDead = value;
          }
        }]);
        return BattleNewMgr;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleNpcCtrl.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './DBRecord.ts', './Utils.ts', './ModuleDef.ts', './BattleDefine.ts', './ItemBattleNpc.ts', './MonitorType.ts', './CommonCfgUtil.ts', './App.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, cclegacy, _decorator, DBRecord, Utils, ModuleDef, GameBattle, ItemBattleNpc, MonitorType, CommonCfgUtil, App;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      ItemBattleNpc = module.ItemBattleNpc;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      CommonCfgUtil = module.CommonCfgUtil;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      cclegacy._RF.push({}, "dc460QcalVABI1r01s2ZXKM", "BattleNpcCtrl", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      // ghjgjuy:
      // 1-图腾
      // 2-装备架
      // 3-宝箱

      var BattleNpcCtrl = exports('BattleNpcCtrl', /*#__PURE__*/function () {
        function BattleNpcCtrl() {
          this._npcCount = [0, 0, 0, 0];
          this._npcs = {};
          this._zhuangBeiJiaData = {};
          this._bxIndex = 1;
          this._flag = {};
          this._bxOpend = false;
          this._bxItems = [];
          /** 所有战斗npc */
          this.allBattleNpcList = [];
          this._curBaoXiangOdss = 10000;
        }
        var _proto = BattleNpcCtrl.prototype;
        _proto.init = function init() {
          this._npcCount = [0, 0, 0, 0];
          this._zhuangBeiJiaData = {};
          this._flag = {};
          this.resetData();
        };
        _proto.resetData = function resetData() {
          this._npcs = {};
          this._flag = {};
          this._bxIndex = 1;
        };
        _proto.dispose = function dispose() {
          this.onExit();
        };
        _proto.enterNewMap = function enterNewMap(uuid, diKuaiId, map) {
          if (this._flag[uuid]) return;
          this._flag[uuid] = true;
          var roleLayer = App.battleMgr.battleMainViewCtrl.roleLayer;
          var cfg = DBRecord.fetchId("DiKuai", diKuaiId);
          if (!cfg.totem_weight) return;
          //let count = BattleUtil.getValueByProbability(cfg.totem_weight);
          // this.initBloodMoon(map);
          var npcObj = map.getObjectGroup("npc");
          if (npcObj) {
            var data = npcObj.getObjects();
            for (var i = 0; i < data.length; i++) {
              if (Math.random() > 0.5) {
                // data[i].type = 3
                var npc = this.getNpcByType(data[i].type);
                if (npc) {
                  if (npc.type === GameBattle.BattleNpcType.BaoXiang) {
                    //宝箱次数到达上限
                    if (App.battleMgr.cur_xybx_times >= App.battleMgr.max_xybx_times) {
                      continue;
                    }
                    //当前副本开过宝箱了
                    if (this._bxOpend) {
                      continue;
                    }
                    //未通过宝箱的概率衰减
                    var odds = Math.random() * 10000;
                    if (odds > this._curBaoXiangOdss) {
                      console.log("宝箱 未通过宝箱的概率衰减 当前宝箱出现概率", this._curBaoXiangOdss);
                      continue;
                    }
                  }
                  var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.itemBattleNpc);
                  roleLayer.addChild(node);
                  var world_pos = App.mapMgr.mapPointToWorldPostion(data[i].x, data[i].y);
                  node.setWorldPosition(world_pos);
                  var comp = node.getComponent(ItemBattleNpc);
                  if (npc.type === GameBattle.BattleNpcType.BaoXiang) {
                    comp.init(npc, this._bxIndex++, data[i]);
                    this._bxItems.push(comp);
                  } else {
                    comp.init(npc, -1, data[i]);
                  }
                  if (npc.type === GameBattle.BattleNpcType.ZhuangBeiJia) {
                    comp.setZhuangBei(this.getZhuangBeiJiaItem(npc.id));
                  }
                  this.allBattleNpcList.push(comp);
                }
              }
            }
          }
          App.monitorMgr.dispatchEvent(MonitorType.battle_enter_new_map, {
            uuid: uuid,
            diKuaiId: diKuaiId
          });
        };
        _proto.onEnter = function onEnter(guanQiaId) {
          this.resetData();
          var GuanQiaCfg = DBRecord.fetchId("GuanQia", guanQiaId);
          this._npcCount[1] = GuanQiaCfg.totem_max;
          this._npcCount[3] = GuanQiaCfg.box_max;
          var cfg = DBRecord.fetchAll("NpcSuiJi");
          for (var i = 0; i < cfg.length; i++) {
            var type = cfg[i].type;
            if (!this._npcs[type]) {
              this._npcs[type] = [];
            }
            this._npcs[type].push(Utils.deepCopy(cfg[i]));
          }
          this._curBaoXiangOdss = 10000;
          var odds = CommonCfgUtil.getValue(81) / 10000;
          for (var _i = 0; _i < App.battleMgr.cur_xybx_times; _i++) {
            this._curBaoXiangOdss *= odds;
          }
          this._bxOpend = false;
          this._bxItems = [];
          this.allBattleNpcList = [];
          console.log("宝箱 onEnter", this._npcCount, this._curBaoXiangOdss);
        };
        _proto.onExit = function onExit() {
          this._bxItems = [];
          this.allBattleNpcList = [];
        }

        /**
         * 通过NPC类型获取NPC
         * @param type
         * @returns
         */;
        _proto.getNpcByType = function getNpcByType(type) {
          var npcs = this._npcs[type];
          if (!npcs) return;
          if (this._npcCount[type] <= 0) return null;
          this._npcCount[type]--;
          if (type === GameBattle.BattleNpcType.ZhuangBeiJia) {
            if (this._zhuangBeiJiaData[2001].length === 0) {
              npcs[0].weight = 0;
            }
            if (this._zhuangBeiJiaData[2002].length === 0) {
              npcs[1].weight = 0;
            }
          }
          var weights = [];
          var sum = 0;
          for (var i = 0; i < npcs.length; i++) {
            sum += npcs[i].weight;
            weights[i] = sum;
          }
          var index = 0;
          var temp = Math.random() * sum;
          for (var _i2 = 0; _i2 < weights.length; _i2++) {
            index = _i2;
            if (weights[_i2] > temp) break;
          }
          // index = 1
          npcs[index].weight -= npcs[index].weight_low;
          return npcs[index];
        };
        _proto.setZhuangBeiJiaData = function setZhuangBeiJiaData(wuQiJia, fangJuJia) {
          this._zhuangBeiJiaData = {
            2001: wuQiJia,
            2002: fangJuJia
          };
          this._npcCount[2] = wuQiJia.length + fangJuJia.length;
        };
        _proto.getZhuangBeiJiaItem = function getZhuangBeiJiaItem(key) {
          var item = this._zhuangBeiJiaData[key].shift();
          return item;
        }
        /** 宝箱开奖后要清除地图上的其他宝箱 */;
        _proto.setBxOpend = function setBxOpend() {
          this._bxOpend = true;
          for (var _iterator = _createForOfIteratorHelperLoose(this._bxItems), _step; !(_step = _iterator()).done;) {
            var comp = _step.value;
            comp.used = true;
            comp.spine.setAnimation(0, "Play", false);
            comp.uifBar.node.parent.active = false;
            comp.bg.active = false;
            comp.bg.parent = comp.node;
            comp.imgYingZi.active = false;
          }
          this._bxItems = [];
        };
        return BattleNpcCtrl;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleProprMgr.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Utils.ts', './BattleUISysDef.ts', './DBRecord.ts', './MonitorType.ts', './MonsterVO.ts', './BattleDefine.ts', './UtilGame.ts', './App.ts'], function (exports) {
  var _createClass, _createForOfIteratorHelperLoose, cclegacy, _decorator, randomRangeInt, Utils, BattleUISysDef, DBRecord, MonitorType, MonsterVO, GameBattle, UtilGame, App;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      randomRangeInt = module.randomRangeInt;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      BattleUISysDef = module.BattleUISysDef;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      MonsterVO = module.MonsterVO;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      UtilGame = module.UtilGame;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "18339U3DihIs4yRZNjNax9F", "BattleProprMgr", undefined);
      var ccclass = _decorator.ccclass;
      var PlayerTimerFuncsDef = exports('PlayerTimerFuncsDef', /*#__PURE__*/function (PlayerTimerFuncsDef) {
        PlayerTimerFuncsDef[PlayerTimerFuncsDef["None"] = 0] = "None";
        PlayerTimerFuncsDef[PlayerTimerFuncsDef["RecoveryLife"] = 1] = "RecoveryLife";
        PlayerTimerFuncsDef[PlayerTimerFuncsDef["RecoveryNengLiang"] = 2] = "RecoveryNengLiang";
        return PlayerTimerFuncsDef;
      }({}));
      var FormulaResultItem = exports('FormulaResultItem', /*#__PURE__*/function (FormulaResultItem) {
        FormulaResultItem[FormulaResultItem["_none"] = 0] = "_none";
        FormulaResultItem[FormulaResultItem["_sanbi"] = 1] = "_sanbi";
        FormulaResultItem[FormulaResultItem["_baoji"] = 2] = "_baoji";
        FormulaResultItem[FormulaResultItem["_zhiliao"] = 4] = "_zhiliao";
        return FormulaResultItem;
      }({}));
      var EleType = exports('EleType', /*#__PURE__*/function (EleType) {
        EleType[EleType["None"] = 0] = "None";
        EleType[EleType["Wuli"] = 1] = "Wuli";
        EleType[EleType["Huoyan"] = 2] = "Huoyan";
        EleType[EleType["Binghan"] = 3] = "Binghan";
        EleType[EleType["Shandian"] = 4] = "Shandian";
        EleType[EleType["Shensheng"] = 5] = "Shensheng";
        EleType[EleType["Dusu"] = 6] = "Dusu";
        EleType[EleType["Anyin"] = 7] = "Anyin";
        EleType[EleType["All"] = 99] = "All";
        return EleType;
      }({}));

      /**
       * 排行榜属性类型(数组从0开始)
       */
      var PlayModelType = exports('PlayModelType', /*#__PURE__*/function (PlayModelType) {
        PlayModelType[PlayModelType["toukui"] = 1] = "toukui";
        PlayModelType[PlayModelType["yifu"] = 2] = "yifu";
        PlayModelType[PlayModelType["zhuwuqi"] = 3] = "zhuwuqi";
        PlayModelType[PlayModelType["fuwuqi"] = 4] = "fuwuqi";
        PlayModelType[PlayModelType["hujian"] = 5] = "hujian";
        PlayModelType[PlayModelType["kuzi"] = 6] = "kuzi";
        PlayModelType[PlayModelType["xie"] = 7] = "xie";
        PlayModelType[PlayModelType["shouzhuo"] = 8] = "shouzhuo";
        PlayModelType[PlayModelType["shiping"] = 9] = "shiping";
        PlayModelType[PlayModelType["jiezhi"] = 10] = "jiezhi";
        return PlayModelType;
      }({}));
      //不稀释属性
      var MLT_ATTR_ID1 = exports('MLT_ATTR_ID1', {
        10039: true,
        10040: true,
        10041: true,
        10042: true,
        10044: true,
        10046: true,
        10047: true,
        10048: true,
        10049: true,
        10050: true,
        10051: true,
        10052: true,
        10053: true
      });
      //减伤式属性
      var MLT_ATTR_ID2 = exports('MLT_ATTR_ID2', {
        10005: true,
        //暴击
        10008: true,
        //减伤
        10015: true,
        //全元素减伤
        10043: true,
        //技能减伤
        10045: true,
        //全元素减伤2
        10056: true //竞技抵御
      });
      // //需要反转的属性
      // export const MLT_ATTR_ID3 = {
      //     10043: true,//技能减伤
      //     10045: true, //全元素减伤2
      // }
      //伤害相关属性
      var DMG_ATTR_ID = exports('DMG_ATTR_ID', {
        1: true,
        2: true,
        3: true,
        5: true,
        1001: true,
        //攻击
        1002: true,
        //防御
        1003: true,
        //生命
        1005: true,
        //能量

        2001: true,
        //攻击
        2002: true,
        //防御
        2003: true,
        //生命
        2005: true,
        //能量

        10001: true,
        //移速
        10002: true,
        //攻速
        // 10003: true, //暴击
        10004: true,
        //暴伤
        10005: true,
        //暴击
        10006: true,
        //闪避
        10007: true,
        //增伤
        10008: true,
        //减伤
        10009: true,
        //生命回复
        10011: true,
        //能量回复
        10012: true,
        //生命球回复

        10013: true,
        //易伤
        10032: 1,
        //物理易伤
        10033: 2,
        //火焰易伤
        10034: 3,
        //冰寒易伤
        10035: 4,
        //闪电易伤
        10036: 5,
        //神圣易伤
        10037: 6,
        //毒素易伤
        10038: 7,
        //暗影易伤

        10014: true,
        //全元素增害
        10015: true,
        //全元素减伤
        10016: 1,
        //物理增伤
        10017: 2,
        //火焰增伤
        10018: 3,
        //冰寒增伤
        10019: 4,
        //闪电增伤
        10020: 5,
        //神圣增伤
        10021: 6,
        //毒素增伤
        10022: 7,
        //暗影增伤

        10023: true,
        //全怪物伤害
        10024: 2,
        //对精英伤害
        10025: 9,
        //对首领伤害
        10026: 1,
        //对小怪伤害

        10027: 1,
        //基础技能伤害
        10028: 2,
        //法术技能伤害
        10029: 3,
        //主宰技能伤害
        10030: 4,
        //驾驭技能伤害
        10031: 5,
        //终极技能伤害

        10039: true,
        10040: true,
        10041: true,
        10042: true,
        //增伤乘区3
        10043: true,
        //减伤乘区3

        10044: true,
        //全元素增伤2
        10045: true,
        //全元素减伤2
        10046: true,
        //物理2
        10047: true,
        //火焰2
        10048: true,
        //冰寒2
        10049: true,
        //闪电2
        10050: true,
        //神圣2
        10051: true,
        //毒素2
        10052: true,
        //暗影2

        10053: true,
        //独立易伤

        10055: true,
        //竞技压制
        10056: true,
        //竞技抵御

        20001: true //神力
      });
      //万分比对应属性
      var PERCENT_VIT_ID = exports('PERCENT_VIT_ID', {
        3004: [4, 3],
        3006: [6, 5]
      });
      //当前值属性
      var CURRENT_VIT_ID = exports('CURRENT_VIT_ID', {
        4: 4,
        2004: 4,
        6: 6,
        2006: 6
      });
      //元素增伤1
      var ATK_ELE_DMG1 = exports('ATK_ELE_DMG1', {
        1: 10016,
        2: 10017,
        3: 10018,
        4: 10019,
        5: 10020,
        6: 10021,
        7: 10022
      });
      //元素增伤2
      var ATK_ELE_DMG2 = exports('ATK_ELE_DMG2', {
        1: 10046,
        2: 10047,
        3: 10048,
        4: 10049,
        5: 10050,
        6: 10051,
        7: 10052
      });
      //元素易伤1
      var DEF_ELE_DMG1 = exports('DEF_ELE_DMG1', {
        1: 10032,
        2: 10033,
        3: 10034,
        4: 10035,
        5: 10036,
        6: 10037,
        7: 10038
      });
      //怪物类型对应增伤属性
      var MST_TYPE_ATTR = exports('MST_TYPE_ATTR', {
        2: 10024,
        3: 10026,
        4: 10026,
        9: 10025,
        1: 10026
      });
      //技能类型对应增伤属性
      var SKILL_TYPE_ATTR = exports('SKILL_TYPE_ATTR', {
        1: 10027,
        2: 10028,
        3: 10029,
        4: 10030,
        5: 10031
      });
      var BattlePropertyName = exports('BattlePropertyName', {
        gongji: 1,
        fangyu: 2,
        shengming: 3,
        dangqianshengming: 4,
        nengliang: 5,
        dangqiangnengliang: 6,
        lock_yisu: 7,
        //锁定移速
        lock_gongsu: 8,
        //锁定攻速

        abs_gongji: 1001,
        abs_fangyu: 1002,
        abs_shengming: 1003,
        abs_curShengming: 1004,
        abs_nengLiang: 1005,
        abs_dangQianNengLiang: 1006,
        wfb_gongji: 2001,
        wfb_fangyu: 2002,
        wfb_shengming: 2003,
        wfb_curShengming: 2004,
        wfb_nengliang1: 2005,
        wfb_nengliang2: 2006,
        wfb_danqianShengMing: 2007,
        wfb_danqianNengLiang: 2008,
        buff_gongji: 3001,
        buff_fangyu: 3002,
        buff_shengming: 3003,
        yisu: 10001,
        gongsu: 10002,
        baoji: 10003,
        baoshang: 10004,
        baojilv: 10005,
        sanbilv: 10006,
        zengshang: 10007,
        jianshang: 10008,
        //减伤乘区1(面板)
        meimiaoShengMinghuifu: 10009,
        jinengZengShang: 10010,
        meiMiaoNengLiangHuiFu: 10011,
        shengMingQiuHuiFu: 10012,
        yishang: 10013,
        eleAdd: 10014,
        //全元素增伤
        eleDel: 10015,
        //全元素减伤
        eleWuli: 10016,
        //物理
        eleHuoyan: 10017,
        //火焰
        eleBinghan: 10018,
        //冰寒
        eleShandian: 10019,
        //闪电
        eleShensheng: 10020,
        //神圣
        eleDusu: 10021,
        //毒素
        eleAnyin: 10022,
        //暗影

        mstAll: 10023,
        //全怪物增伤
        mstJingYing: 10024,
        //精英
        mstShouLing: 10025,
        //首领
        mstXiaoGuai: 10026,
        //小怪

        skillJiChu: 10027,
        //基础
        skillFaShu: 10028,
        //法术
        skillZhuZai: 10029,
        //主宰
        skillJiaYu: 10030,
        //驾驭
        skillZhongJi: 10031,
        //终级

        wfb_gongji2: 10039,
        //攻击乘区2
        wfb_fangyu2: 10040,
        //防御乘区2
        zengshang2: 10041,
        //伤害乘区2

        zengshang3: 10042,
        //增伤乘区3
        jianshang3: 10043,
        //减伤乘区3(技能)

        eleAdd2: 10044,
        //全元素增伤2
        eleDel2: 10045,
        //全元素减伤2
        eleWuli2: 10046,
        //物理2
        eleHuoyan2: 10047,
        //火焰2
        eleBinghan2: 10048,
        //冰寒2
        eleShandian2: 10049,
        //闪电2
        eleShensheng2: 10050,
        //神圣2
        eleDusu2: 10051,
        //毒素2
        eleAnyin2: 10052,
        //暗影2

        yishang2: 10053,
        //独立易伤

        jingjiYaZhi: 10055,
        //竞技压制
        jingjiDiYu: 10056,
        //竞技抵御
        HuiXueJiangDi: 10058,
        //回血效果降低
        shenli: 20001,
        //  神力（爬塔）

        ac2KeyObj: {},
        init: function init() {
          for (var key in BattlePropertyName) {
            var ac = BattlePropertyName[key];
            if (typeof ac !== "number") {
              continue;
            }
            BattlePropertyName.ac2KeyObj[ac] = key;
          }
        }
      });
      var BattleProprMgr = exports('BattleProprMgr', (_dec = ccclass("BattleProprMgr"), _dec(_class = (_class2 = /*#__PURE__*/function () {
        function BattleProprMgr() {
          this._leftPoint = void 0;
          this._hitType = FormulaResultItem._none;
          this._roleVONativeProps = [1, 2, 3, 4, 5, 6, 10001, 10002];
          this._lastAttrMap = new Map();
          /**
           * 战斗属性
           */
          this._lastAttr = void 0;
          /**
           * 战斗属性
           */
          this.lastAttProtodata = void 0;
          //改变值
          this._sysPropMapTemp = new Map();
          /**
           * 玩家初始vo
           */
          this._playerInitVo = null;
          this._maxShanBi = 0;
        }
        var _proto = BattleProprMgr.prototype;
        _proto.getSysPropMapTemp = function getSysPropMapTemp(name) {
          return this._sysPropMapTemp.get(name);
        };
        _proto.init = function init() {
          this._sysPropMapTemp.set(BattleUISysDef.DianFengUISys, new Map());
        };
        _proto.dispose = function dispose() {
          this._sysPropMapTemp.clear();
          this._lastAttrMap.clear();
          this._lastAttr = null;
        }

        /**
         * 设置默认值
         */;
        _proto.setDefaultAtti = function setDefaultAtti() {
          var _this = this;
          var ShuXing = DBRecord.fetchAll("ShuXing");
          Utils.forArr(ShuXing, function (row) {
            _this._lastAttrMap.set(row.id, 0);
          });
        }

        /**
         *
         * @param id 获取属性值
         * @returns
         */;
        _proto.featchValueById = function featchValueById(id, roleVO) {
          if (DMG_ATTR_ID[id]) {
            return roleVO.getRoleAttr(id);
          }
          var lib = PERCENT_VIT_ID[id];
          if (lib) {
            return roleVO.getTempAttr(lib[0]) / roleVO.getRoleAttr(lib[1]) * 10000;
          }
          switch (id) {
            case BattlePropertyName.dangqianshengming:
              return roleVO.curHP;
            case BattlePropertyName.dangqiangnengliang:
              return roleVO.curNengLiiang;
          }
          return roleVO.lastAttrMap.get(id) || 0;
        }

        /**
         * 修改数值值
         * @param id
         * @param changeVal
         * @param roleBaseVO
         * @param notifyUI
         */;
        _proto.changeValueById = function changeValueById(id, changeVal, roleBaseVO, notifyUI) {
          // let noExist = true;
          // console.log(`修改属性id:${id},changeVal:${changeVal} notifyUI:${notifyUI}`)

          if (this._roleVONativeProps.findIndex(function (value) {
            return value == id;
          }) != -1) {
            //本地
            this.checkChangeNativeProp(id, changeVal, roleBaseVO, notifyUI);
          } else {
            Utils.forArr(roleBaseVO.battleAttrList, function (item, index) {
              if (item.id == id) {
                item.value += changeVal;
                console.log("\u4FEE\u6539\u5C5E\u6027\u6218\u6597\u516C\u5F0Fid:" + id + ",changeVal:" + changeVal + " notifyUI:" + notifyUI);
                return true; //break
              }
            });
          }

          roleBaseVO.battleAttrList = roleBaseVO.battleAttrList;
        }

        /**
         * 检查修改本地属性
         * @param id
         * @param changeVal
         * @param roleBaseVO
         * @param notifyUI
         */;
        _proto.checkChangeNativeProp = function checkChangeNativeProp(id, changeVal, roleBaseVO, _notifyUI) {
          var notifyEnum = MonitorType.battle_player_none;
          var data = {};
          switch (id) {
            case BattlePropertyName.gongji:
              // roleBaseVO.updateCurAtk(changeVal);

              break;
            case BattlePropertyName.fangyu:
              // roleBaseVO.updateDef(changeVal);
              break;
            case BattlePropertyName.shengming:
              // roleBaseVO.updateHp(changeVal);
              break;
            case BattlePropertyName.dangqianshengming:
              var maxHp = roleBaseVO.getRoleAttr(BattlePropertyName.shengming);
              if (roleBaseVO.curHP + changeVal > maxHp) {
                roleBaseVO.updateCurHP(maxHp, true);
              } else {
                roleBaseVO.updateCurHP(changeVal);
              }
              notifyEnum = MonitorType.battle_player_update_hp;
              break;
            case BattlePropertyName.nengliang:
              // roleBaseVO.updateNengLiang(changeVal);
              break;
            case BattlePropertyName.dangqiangnengliang:
              var maxMp = roleBaseVO.getRoleAttr(BattlePropertyName.nengliang);
              if (roleBaseVO.curNengLiiang + changeVal > maxMp) {
                roleBaseVO.updateCurNengLiang(maxMp, true);
              } else {
                roleBaseVO.updateCurNengLiang(changeVal);
              }
              notifyEnum = MonitorType.battle_player_update_nengliang;
              break;
          }
          // console.log(`修改属性native完成id:${id},changeVal:${changeVal} notifyUI:${notifyUI}`)
          //通知
          if (notifyEnum !== MonitorType.battle_player_none) {
            App.monitorMgr.dispatchEvent(notifyEnum, data);
          }
        };
        _proto.execBattleFormula = function execBattleFormula(Atker, Defer, exInfo, bullet, buff) {
          if (bullet === void 0) {
            bullet = null;
          }
          if (buff === void 0) {
            buff = null;
          }
          var result = [0, FormulaResultItem._none];
          var DeferVO = Defer.roleVO;
          var AtkerVO = Atker.roleVO;
          if (exInfo.dmgType === GameBattle.BuffEffectType.Hurt2) {
            //真实伤害（直接数值）
            result[0] = exInfo.mltDmg1;
            return result;
          } else if (exInfo.dmgType === GameBattle.BuffEffectType.Hurt3) {
            //真实伤害（等级相关）
            result[0] = exInfo.mltDmg1;
            return result;
          } else if (exInfo.dmgType === GameBattle.BuffEffectType.Hurt4) {
            //真实伤害（总量百分比）
            var _DeferVO = Defer.roleVO;
            var _mDefAttr = Utils.covVitM(Utils.addVitM(Utils.copyObj(_DeferVO.getFullAttr()), Defer._buffBox.getConstantlyAttrBuff(Atker)), _DeferVO.getLockAttr());
            result[0] = Math.ceil(_mDefAttr[BattlePropertyName.shengming] * exInfo.mltDmg0 / 10000);
            return result;
          } else if (exInfo.dmgType === GameBattle.BuffEffectType.Hurt5) {
            //真实伤害（当前百分比）
            result[0] = Math.ceil(Defer.roleVO.curHP * exInfo.mltDmg0 / 10000);
            return result;
          }
          var mAtkAttr = UtilGame.cloneS(AtkerVO.getFullAttr());
          var mAtkLock = UtilGame.cloneS(AtkerVO.getLockAttr());
          var mDefAttr = UtilGame.cloneS(DeferVO.getFullAttr());
          //子弹owner被回收后重用成别的怪物，使用备份属性
          if (bullet && bullet.checkOwnerError()) {
            mAtkAttr = bullet.initOwnerFullAttr || {};
            mAtkLock = bullet.initOwnerLockAttr || {};
            //console.warn('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR execBattleFormula , bullet use backUpAttr', bullet.bulletVO.bulletID);
          } else if (Defer.type === GameBattle.RoleType.Monster && buff && buff.checkSourceError()) {
            mAtkAttr = buff.initSourceFullAttr || {};
            mAtkLock = buff.initSourceLockAttr || {};
            //console.warn('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR execBattleFormula ,buffuse backUpAttr', bullet.bulletVO.bulletID);
          }

          //临时buff加成
          Utils.addVitM(mAtkAttr, Atker._buffBox.getConstantlyAttrBuff(Defer));
          Utils.addVitM(mDefAttr, Defer._buffBox.getConstantlyAttrBuff(Atker));

          //物品图鉴加成
          // let vTuJianAttr = App.battleMgr.getTuJianAttr(DeferVO);
          // Utils.addVitA(mAtkAttr, vTuJianAttr);

          //标准化属性（放在加成最后）
          // Utils.stdVitM(mAtkAttr);
          // Utils.stdVitM(mDefAttr);
          Utils.covVitM(mAtkAttr, mAtkLock);
          Utils.covVitM(mDefAttr, DeferVO.getLockAttr());

          //闪避
          var global_83 = DBRecord.fetchId("ShuoMingQuanJu", 83);
          var evade = Math.min(mDefAttr[BattlePropertyName.sanbilv], global_83.value);
          if (randomRangeInt(0, 10001) < evade) {
            result[1] = FormulaResultItem._sanbi;
            return result;
          }

          //防御乘区
          // let def = mDefAttr[BattlePropertyName.abs_fangyu] * (10000 + (mDefAttr[BattlePropertyName.wfb_fangyu] || 0)) / 10000
          // let defMlt = 1 - (def * 0.7) / (2000 + def);

          //技能附加伤害(系数1)
          var exMlt1 = (exInfo.mltDmg0 || 10000) / 10000;

          //技能附加伤害(系数2)
          var exMlt0 = (exInfo.mltDmg1 || 10000) / 10000;

          //易伤乘区
          var eleAdd0 = mDefAttr[BattlePropertyName.yishang]; //全属性易伤1
          if (exInfo.eleType === EleType.All) {
            //各属性易伤1
            eleAdd0 += mDefAttr[DEF_ELE_DMG1[EleType.Huoyan]] + mDefAttr[DEF_ELE_DMG1[EleType.Binghan]] + mDefAttr[DEF_ELE_DMG1[EleType.Shandian]] + mDefAttr[DEF_ELE_DMG1[EleType.Shensheng]] + mDefAttr[DEF_ELE_DMG1[EleType.Dusu]] + mDefAttr[DEF_ELE_DMG1[EleType.Anyin]];
          } else {
            //单属性易伤1
            eleAdd0 += mDefAttr[DEF_ELE_DMG1[exInfo.eleType]] || 0;
          }
          var addMlt0 = (10000 + eleAdd0) / 10000;

          //易伤乘区2
          var addMlt4 = (10000 + mDefAttr[BattlePropertyName.yishang2]) / 10000;

          //增伤乘区1
          var global_31 = DBRecord.fetchId("ShuoMingQuanJu", 31);
          var addMlt1 = (10000 + mAtkAttr[BattlePropertyName.zengshang]) / 10000;
          //减伤乘区1
          var delMlt1 = (10000 - Math.min(mDefAttr[BattlePropertyName.jianshang], global_31.value)) / 10000;

          //增伤乘区2
          var addMlt2 = (10000 + mAtkAttr[BattlePropertyName.zengshang2]) / 10000;

          //增伤乘区3
          var addMlt3 = (10000 + mAtkAttr[BattlePropertyName.zengshang3]) / 10000;

          //减伤乘区3
          var delMlt3 = Math.max(0, 10000 - mDefAttr[BattlePropertyName.jianshang3]) / 10000;

          //元素乘区
          var eleMlt1 = 1; //属性乘区1
          var eleMlt2 = 1; //属性乘区2
          if (exInfo.eleType && exInfo.eleType !== BattlePropertyName.eleWuli) {
            //元素增伤1（加算）
            var eleAdd1 = mAtkAttr[BattlePropertyName.eleAdd]; //全属性增伤1
            if (exInfo.eleType === EleType.All) {
              //各属性增伤1
              eleAdd1 += mAtkAttr[ATK_ELE_DMG1[EleType.Huoyan]] + mAtkAttr[ATK_ELE_DMG1[EleType.Binghan]] + mAtkAttr[ATK_ELE_DMG1[EleType.Shandian]] + mAtkAttr[ATK_ELE_DMG1[EleType.Shensheng]] + mAtkAttr[ATK_ELE_DMG1[EleType.Dusu]] + mAtkAttr[ATK_ELE_DMG1[EleType.Anyin]];
            } else {
              //单属性增伤1
              eleAdd1 += mAtkAttr[ATK_ELE_DMG1[exInfo.eleType]];
            }
            var eleDel1 = mDefAttr[BattlePropertyName.eleDel]; //全属性减伤1
            var global_36 = DBRecord.fetchId("ShuoMingQuanJu", 36);
            eleMlt1 = Math.max(10000 + (eleAdd1 - eleDel1), 10000 - global_36.value) / 10000;

            //元素增伤2（乘算）
            var eleAdd2 = mAtkAttr[BattlePropertyName.eleAdd2]; //全属性增伤2
            if (exInfo.eleType === EleType.All) {
              //各属性增伤2
              eleAdd2 = (10000 + eleAdd2) * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Huoyan]]) / 10000 * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Binghan]]) / 10000 * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Shandian]]) / 10000 * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Shensheng]]) / 10000 * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Dusu]]) / 10000 * (10000 + mAtkAttr[ATK_ELE_DMG2[EleType.Anyin]]) / 10000;
            } else {
              //单属性增伤2
              eleAdd2 = (10000 + eleAdd2) * (10000 + mAtkAttr[ATK_ELE_DMG2[exInfo.eleType]]) / 10000;
            }
            var eleDel2 = Math.min(9999, mDefAttr[BattlePropertyName.eleDel2]); //全属性减伤2
            eleMlt2 = eleAdd2 * (10000 - eleDel2) / (10000 * 10000);
          }

          //技能乘区
          var skillMlt1 = 1;
          var skillKind = App.skillMgr.getSkillKind(exInfo.skillId);
          if (SKILL_TYPE_ATTR[skillKind]) skillMlt1 = (10000 + mAtkAttr[SKILL_TYPE_ATTR[skillKind]]) / 10000;

          //技能乘区2
          var vSkillMlt = [0, 0];
          //精英乘区
          // let mstMlt = (10000 + AtkerVO.getExDmgAttr(MST_TYPE_ATTR[(DeferVO as MonsterVO).quality], BattlePropertyName.mstAll)) / 10000
          var mstMlt = 1;
          if (DeferVO instanceof MonsterVO) {
            mstMlt = (10000 + mAtkAttr[MST_TYPE_ATTR[DeferVO.quality]] + mAtkAttr[BattlePropertyName.mstAll]) / 10000;
            vSkillMlt = Atker._buffBox.getConstantlySkillBuff(exInfo.skillId, DeferVO.quality);
          }
          vSkillMlt[1] += 1;

          //暴击乘区
          var critMlt = 1;
          var crit = mAtkAttr[BattlePropertyName.baojilv]; //baojilv为实际使用属性
          if (randomRangeInt(0, 10001) <= crit) {
            critMlt = (10000 + mAtkAttr[BattlePropertyName.baoshang]) / 10000;
            result[1] = FormulaResultItem._baoji;
          }
          // let valA = DBRecord.fetchId("ShuoMingQuanJu", 25).value
          // let valB = DBRecord.fetchId("ShuoMingQuanJu", 26).value
          // let crit0 = mAtkAttr[BattlePropertyName.baoji]
          // let crit1 = mAtkAttr[BattlePropertyName.baojilv]
          // let playerLv = App.roleMgr.getRoleLv()
          // let cirt2 = (crit0 / (valA * (1 - Math.pow(valA, playerLv)) / (1 - valA) * valB)) * 10000 + crit1

          //结算
          var atk = mAtkAttr[BattlePropertyName.gongji]; //攻击
          // (mAtkAttr[BattlePropertyName.abs_gongji] * (10000 + (mAtkAttr[BattlePropertyName.wfb_gongji] || 0)) * (10000 + (mAtkAttr[BattlePropertyName.wfb_gongji2] || 0))) /
          // 100000000; //mAtkAttr[BattlePropertyName.gongji]; //攻击
          var def = mDefAttr[BattlePropertyName.abs_fangyu] * (10000 + (mDefAttr[BattlePropertyName.wfb_fangyu] || 0)) * (10000 + (mDefAttr[BattlePropertyName.wfb_fangyu2] || 0)) / 100000000;
          result[0] = 1 + atk * atk / (atk + 2 * def) * exMlt1 * exMlt0 * addMlt0 * addMlt1 * delMlt1 * addMlt2 * addMlt3 * addMlt4 * delMlt3 * eleMlt1 * eleMlt2 * mstMlt * skillMlt1 * critMlt * vSkillMlt[1] + vSkillMlt[0];

          // console.log(`结算伤害>>${Atker.type}>>${Defer.type}伤害:${Math.round(result[0])}, 攻击:${atk}, 防御:${def}
          // , 技能附加伤害0:${exMlt0}, 技能附加伤害1:${exMlt1}
          // , 易伤1:${addMlt0}, 易伤2:${addMlt4}
          // , 增伤1:${addMlt1}, 增伤2:${addMlt2},增伤3:${addMlt3}
          // , 减伤1:${delMlt1}, 减伤3:${delMlt3},
          // , 属性乘区1:${eleMlt1}, 属性乘区2:${eleMlt2}, 精英乘区:${mstMlt}, 技能乘区1:${skillMlt1}, 技能乘区2_1:${vSkillMlt[1]}, 技能乘区2_0:${vSkillMlt[0]}
          // , 暴击伤害:${critMlt}`);

          //竞技场修正
          // if (App.battleMgr.guanQiaType == GameBattle.GuanQiaType.JingJiChang) {
          //     //JJC战力压缩
          //     let pvpYaSuo = AtkerVO.tongGuan <= DeferVO.tongGuan ? AtkerVO.pvpYaSuo : DeferVO.pvpYaSuo;
          //     //JJC战力修正
          //     let powerRate = Math.max(1, AtkerVO.pvpPower / DeferVO.pvpPower);
          //     const global_142 = UtilGame.getGlobalVal(142);
          //     powerRate = Math.pow(powerRate, global_142);
          //     //JJC修正
          //     let jjcRate = ((10000 + mAtkAttr[BattlePropertyName.jingjiYaZhi]) * (10000 - mDefAttr[BattlePropertyName.jingjiDiYu])) / (10000 * 10000);
          //     //JJC增辐
          //     let jjcZengFu = App.trialManager.getJJCZenFu();
          //     result[0] = Math.pow(result[0], 10000 / pvpYaSuo) * powerRate * jjcRate * jjcZengFu;
          //     console.log(
          //         `JJC>>${Atker.type}>>${Defer.type}战力压缩:${pvpYaSuo}, 战力修正:${powerRate}, JJC修正:${jjcRate},JJC增辐:${jjcZengFu}, 竞技场修正后伤害${Math.round(result[0])}`
          //     );
          //     console.log(`Atker>${Atker.type}>~~>`, Atker.roleVO.getBuffGroup(), mAtkAttr);
          //     console.log(`Defer>${Defer.type}>~~>`, Defer.roleVO.getBuffGroup(), mDefAttr);
          // }

          result[0] = Math.floor(result[0]);

          // 爬塔模式下应用神力增幅
          // if (App.battleMgr.guanQiaType == GameBattle.GuanQiaType.PaTa && Atker.type == GameBattle.RoleType.Player && App.battleMgr.battleMainViewCtrl.battlePaTa) {
          //     result[0] = App.battleMgr.battleMainViewCtrl.battlePaTa.calculateShenliDamage(result[0], mAtkAttr[BattlePropertyName.shenli]);
          // }

          // if (DEBUG) {
          //     let gmDmg = App.mixMgr.getGmDmg();
          //     if (gmDmg != 1) {
          //         if (Defer.type == GameBattle.RoleType.Player) {
          //             result[0] = 1;
          //         } else {
          //             result[0] = Math.floor(result[0] * gmDmg);
          //         }
          //     }
          // }
          // result[0] = 1 + gongji * (1 - mianshanglv) * jiaceng1 * jiaceng2 * jiaceng3 * eleMulty * mstMulty * skillMulty;
          // if (isNaN(result[0]) || Math.abs(result[0]) == 1) {
          //     console.error('>>>>>>>>>>>>>>>>>>>>>>>>> execBattleFormula result[0] is NaN', result[0], exInfo, Atker, bullet);
          // }
          return result;
        }

        /**
         * 生命求恢复
         * @returns
         */;
        _proto.shengMingQiuZhiLiaoFormula = function shengMingQiuZhiLiaoFormula() {
          var player = App.battleMgr.roleCtrl.player;
          if (player == undefined || player.roleVO == undefined) {
            return 0;
          }
          var playerVo = player.roleVO;
          //  生命球治疗=Int[总生命*20%*(1+生命球恢复)]
          var _curHP = playerVo.curHP;
          var maxHP = playerVo.getRoleAttr(BattlePropertyName.shengming);
          var shengmingqiu = playerVo.getRoleAttr(BattlePropertyName.shengMingQiuHuiFu);
          // let arr = playerVo.battleAttrList;
          // arr.forEach((item) => {
          //     if (item.id == BattlePropertyName.shengMingQiuHuiFu) {
          //         shengmingqiu = item.value;
          //     }
          // });
          var huifuZhi = maxHP * 0.2 * (1 + shengmingqiu / 10000);
          return huifuZhi;
        }

        /**
         * 更新玩家战斗属性
         * @param data
         * @returns
         */
        // public updatePlayerAttributes(player: Player): void {

        //     this.updatePlayerBattleAttributes(this.lastAttProtodata, player);

        // }
        /**
         * 更新玩家战斗属性
         * @param data
         * @returns
         */;
        _proto.updatePlayerBattleAttributes = function updatePlayerBattleAttributes(data, player) {
          if (player && player.roleVO) {
            player.roleVO.udtInitAttr(data.attr.attr_list);
          }
        };
        _createClass(BattleProprMgr, [{
          key: "leftPoint",
          get: function get() {
            return this._leftPoint;
          },
          set: function set(dianshu) {
            this._leftPoint = dianshu;
          }
        }, {
          key: "lastAttrMap",
          get: function get() {
            return this._lastAttrMap;
          }
        }, {
          key: "lastAttr",
          get: function get() {
            return this._lastAttr;
          },
          set: function set(value) {
            this._lastAttr = value;
            //转成map
            this.setDefaultAtti();
            for (var _iterator = _createForOfIteratorHelperLoose(value), _step; !(_step = _iterator()).done;) {
              var element = _step.value;
              this._lastAttrMap.set(element.id, element.value);
            }
          }
        }]);
        return BattleProprMgr;
      }(), _class2._instance = void 0, _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleProps.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, Component, App;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Component = module.Component;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "6263flpdnpOULDPaP5dfAe7", "BattleProps", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattlePropTypeEnum = exports('BattlePropTypeEnum', /*#__PURE__*/function (BattlePropTypeEnum) {
        BattlePropTypeEnum[BattlePropTypeEnum["INT"] = 0] = "INT";
        BattlePropTypeEnum[BattlePropTypeEnum["PERCENT"] = 1] = "PERCENT";
        return BattlePropTypeEnum;
      }({}));

      // export type BattleShuxing = {  //属性id
      // id:number,
      // client:number
      // type:number,
      // limit:number,
      // name:number
      // des:number
      // default:number
      // coefficient:number
      // coefficient_fight:number
      // formula:number
      // }
      var BattleProps = exports('BattleProps', (_dec = ccclass("BattleProps"), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleProps, _Component);
        BattleProps.getInstance = function getInstance() {
          if (!this._instance) {
            this._instance = new BattleProps();
          }
          return this._instance;
        };
        function BattleProps() {
          var _this;
          _this = _Component.call(this) || this;
          // this._player = App.battleMgr.roleCtrl.player;
          _this._player = App.battleMgr.roleCtrl.player;
          _this._damage = {
            perId: 1,
            perTypeDesc: BattlePropTypeEnum.INT,
            value: 3,
            defalut: 3,
            maxLimit: Number.MAX_SAFE_INTEGER,
            isWork: true,
            cal: function cal(hp) {
              _this._damage.value += hp;
              return _this._damage.value;
            },
            add: function add(intVal) {
              //修改战斗中Player属性
              var player = App.battleMgr.roleCtrl.player;
              player.roleVO.updateCurAtk(intVal);
              return _this._damage.value += intVal;
            },
            ext: null
          };
          _this._phyDefence = {
            perId: 2,
            perTypeDesc: BattlePropTypeEnum.INT,
            value: 0,
            defalut: 0,
            maxLimit: Number.MAX_SAFE_INTEGER,
            isWork: true,
            cal: function cal(hp) {
              _this._phyDefence.value += hp;
              return _this._phyDefence.value;
            },
            add: function add(intVal) {
              _this._phyDefence.value += intVal;
              var player = App.battleMgr.roleCtrl.player;
              player.roleVO.updateDef(intVal);
              return _this._phyDefence.value;
            },
            ext: null
          };
          _this._maxHp = {
            perId: 3,
            perTypeDesc: BattlePropTypeEnum.INT,
            value: 396,
            defalut: 396,
            maxLimit: Number.MAX_SAFE_INTEGER,
            isWork: true,
            cal: function cal(hp) {
              _this._maxHp.value += hp;
              return _this._maxHp.value;
            },
            add: function add(intVal) {
              _this._maxHp.value += intVal;
              var player = App.battleMgr.roleCtrl.player;
              player.roleVO.updateHp(intVal);
              return _this._maxHp.value;
            },
            ext: null
          };
          _this._nowHp = {
            perId: 4,
            perTypeDesc: BattlePropTypeEnum.INT,
            value: 0,
            defalut: 0,
            maxLimit: Number.MAX_SAFE_INTEGER,
            isWork: true,
            cal: function cal(hp) {
              _this._nowHp.value += hp;
              return _this._nowHp.value;
            },
            add: function add(intVal) {
              _this._nowHp.value += intVal;
              return _this._nowHp.value;
            },
            ext: null
          };
          /****************************************************二级属性**************************** */
          //攻击百分比
          _this._attackPer = {
            perId: 5,
            perTypeDesc: BattlePropTypeEnum.PERCENT,
            value: 0,
            defalut: 0,
            maxLimit: 50000,
            isWork: true,
            cal: function cal(hp) {
              return _this._attackPer.value;
            },
            add: function add(intVal) {
              //百分比立马加到攻击数值
              _this._damage.add(Math.floor(intVal / 10000 * _this._attackPer.value));
              _this._attackPer.value += intVal / 10000;
              return _this._attackPer.value;
            },
            ext: null
          };
          _this._hpPer = {
            perId: 6,
            perTypeDesc: BattlePropTypeEnum.PERCENT,
            value: 0,
            defalut: 0,
            maxLimit: 50000,
            isWork: true,
            cal: function cal(hp) {
              _this._hpPer.value += hp / 10000;
              return _this._hpPer.value;
            },
            add: function add(intVal) {
              _this._hpPer.value += intVal / 10000;
              return _this._hpPer.value;
            },
            ext: null
          };
          /*****************************************特殊属性**************************** */
          /**
           * 攻速
           */
          _this._attackSpace = void 0;
          /**
           * 冷却缩减
           */
          _this.cooldownRed = void 0;
          /**
           * 暴击率
           */
          _this.critical = void 0;
          /**
           * 暴击伤害
           */
          _this.criticalHurt = void 0;
          /**
           * 闪避
           */
          _this.dodge = void 0;
          /**
           * 伤害加成
           */
          _this.increaseDamage = void 0;
          /**
           * 伤害减免
           */
          _this.damageRed = void 0;
          /**
           * 当前剩余能量
           */
          _this.currentEnergy = void 0;
          /**
           * 能量上限提高
           */
          _this.energyLimitIncreas = void 0;
          /**
           * 移速
           */
          _this.moveSpd = void 0;
          /**
           * 每秒生命恢复
           */
          _this.lifeRecoveryPerSec = void 0;
          /**
           * 生命球恢复
           */
          _this.lifeBallRecovery = void 0;
          /**
           * 每秒能量回复
           */
          _this.energyRecoveryPerSec = void 0;
          /**
           * 对精英伤害
           */
          _this.damage2Elites = void 0;
          /**
           * 精英伤害减免
           */
          _this.eliteDamageRed = void 0;
          /**
           * 范围伤害
           */
          _this.areaDamage = void 0;
          /**
           * 远程伤害
           */
          _this.rangedDamage = void 0;
          /**
           * 近战伤害
           */
          _this.meleeDamage = void 0;
          /**
           * 范围伤害减免
           */
          _this.areaDamageRed = void 0;
          /**
           * 远程伤害减免
           */
          _this.rangedDamageRed = void 0;
          /**
           * 近战伤害减免
           */
          _this.meleedamageRed = void 0;
          /**
           * 物理伤害
           */
          _this.physicalDamage = void 0;
          /**
           * 火焰伤害
           */
          _this.fireDamage = void 0;
          /**
           * 冰寒伤害
           */
          _this.coldDamage = void 0;
          /**
           * 闪电伤害
           */
          _this.lightningDamage = void 0;
          /**
           * 神圣伤害
           */
          _this.godDamage = void 0;
          /**
           * 毒素伤害
           */
          _this.toxinDamage = void 0;
          /**
           * 物理伤害减免
           */
          _this.physicalDamageRed = void 0;
          /**
           * 火焰伤害减免
           */
          _this.firedamageRed = void 0;
          /**
           * 冰寒伤害减免
           */
          _this.coldDamageRed = void 0;
          /**
           * 闪电伤害减免
           */
          _this.LightningDamageRed = void 0;
          /**
           * 神圣伤害减免
           */
          _this.HolyDamageRed = void 0;
          /**
           * 毒素伤害减免
           */
          _this.toxinDamageRed = void 0;
          /**
           * 全元素伤害
           */
          _this.allElementalDamage = void 0;
          /**
           * Buff伤害
           */
          _this.buffDamage = void 0;
          /**
           * Buff伤害
           */
          _this.buffDamageRed = void 0;
          /**
           * 结果伤害
           */
          _this.resultDamage = void 0;
          /**
           * 结果减伤
           */
          _this.resultDamageRed = void 0;
          /**
           * 对首领伤害
           */
          _this.damage2Boss = void 0;
          /**
           * 首领伤害减免
           */
          _this.damage2BossRed = void 0;
          /**
           * 对小怪伤害
           */
          _this.damage2Monsters = void 0;
          /**
           * 小怪伤害减免
           */
          _this.damage2MonstersRed = void 0;
          /**
           * 基础技能伤害
           */
          _this.basicSkillDamage = void 0;
          /**
           * 法术技能伤害
           */
          _this.spellSkillDamage = void 0;
          /**
           * 主宰技能伤害
           */
          _this.dominationSkillDamage = void 0;
          /**
           * 驾驭技能伤害
           */
          _this.controlSkillDamage = void 0;
          /**
           * 终极技能伤害
           */
          _this.ultimateSkillDamage = void 0;
          return _this;
        }
        return BattleProps;
      }(Component), _class2._instance = void 0, _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattlePropsSec.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleProps.ts'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, BattleProps;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
    }, function (module) {
      BattleProps = module.BattleProps;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "69be5ALkm5Fw5K6bHcwJWY2", "BattlePropsSec", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattlePropsSec = exports('BattlePropsSec', (_dec = ccclass("BattlePropsSec"), _dec(_class = /*#__PURE__*/function (_BattleProps) {
        _inheritsLoose(BattlePropsSec, _BattleProps);
        function BattlePropsSec() {
          return _BattleProps.call(this) || this;
        }
        return BattlePropsSec;
      }(BattleProps)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattlePropsSpecial.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattlePropsSec.ts'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, BattlePropsSec;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
    }, function (module) {
      BattlePropsSec = module.BattlePropsSec;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "2a458IRdmpKTI2jsl7JcITh", "BattlePropsSpecial", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattlePropsSpecial = exports('BattlePropsSpecial', (_dec = ccclass("BattlePropsSpecial"), _dec(_class = /*#__PURE__*/function (_BattlePropsSec) {
        _inheritsLoose(BattlePropsSpecial, _BattlePropsSec);
        function BattlePropsSpecial() {
          return _BattlePropsSec.call(this) || this;
        }
        return BattlePropsSpecial;
      }(BattlePropsSec)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleSettingView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './MonitorType.ts', './UIBase.ts', './ModuleContext.ts', './ModuleDef.ts', './Item_prop.ts'], function (exports) {
  var _inheritsLoose, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, Node, App, MonitorType, UIBase, ModuleContext, ModuleDef, Item_prop;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
    }, function (module) {
      App = module.App;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      UIBase = module.UIBase;
    }, function (module) {
      ModuleContext = module.ModuleContext;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      Item_prop = module.Item_prop;
    }],
    execute: function () {
      var _dec, _class, _class2, _binding;
      cclegacy._RF.push({}, "4fb30aqTFpK04g87U6TgHOC", "BattleSettingView", undefined);
      var ccclass = _decorator.ccclass;
      var BattleSettingView = exports('BattleSettingView', (_dec = ccclass("BattleSettingView"), _dec(_class = (_class2 = /*#__PURE__*/function (_UIBase) {
        _inheritsLoose(BattleSettingView, _UIBase);
        function BattleSettingView() {
          var _this;
          _this = _UIBase.call(this, BattleSettingView.custom) || this;
          _this.layoutObj = null;
          _this._isProcessing = false;
          _this._onHideCallback = null;
          return _this;
        }
        var _proto = BattleSettingView.prototype;
        _proto.onCreated = function onCreated(data) {
          var _this$layoutObj$imgBa;
          _UIBase.prototype.onCreated.call(this);
          if (data && data.cb) {
            this._onHideCallback = data.cb;
          }
          this.layoutObj = this.layout;
          this.initUi();
          this.initItemScroll(data.msg);
          (_this$layoutObj$imgBa = this.layoutObj.imgBack) == null || (_this$layoutObj$imgBa = _this$layoutObj$imgBa.node) == null || _this$layoutObj$imgBa.on(Node.EventType.TOUCH_END, this.onClickBackground, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResReTry, this.onResReTry, this);
          // App.monitorMgr.addEventListener(MonitorType.CMD_ResEnterDungeon, this.onEnterDungeon, this);
        };

        _proto.onDispose = function onDispose() {
          var _this$layoutObj$imgBa2;
          _UIBase.prototype.onDispose.call(this);
          (_this$layoutObj$imgBa2 = this.layoutObj.imgBack) == null || (_this$layoutObj$imgBa2 = _this$layoutObj$imgBa2.node) == null || _this$layoutObj$imgBa2.off(Node.EventType.TOUCH_END, this.onClickBackground, this);
          App.monitorMgr.removeEventListener(MonitorType.CMD_ResReTry, this.onResReTry, this);
          // App.monitorMgr.removeEventListener(MonitorType.CMD_ResEnterDungeon, this.onEnterDungeon, this);
          App.monitorMgr.offTarget(this);
        };
        _proto.initUi = function initUi() {
          this.layoutObj.titleLab.string = "暂停";
        };
        _proto.initItemScroll = function initItemScroll(data) {
          this.layoutObj.itemScroll.content.removeAllChildren();
          this.layoutObj.itemScroll.onItemRender = this.onItemRender.bind(this);
          // this.layoutObj.itemScroll.onItemClick = this.onItemClick.bind(this);

          var itemList = data.items;
          this.layoutObj.itemScroll.array = itemList;
        };
        _proto.onItemRender = function onItemRender(item, index) {
          var data = this.layoutObj.itemScroll.array[index];
          var cellComp = item.getComponent(Item_prop);
          cellComp.onItemRender(data);
        }

        /**
         * 背景点击关闭页面
         */;
        _proto.onClickBackground = function onClickBackground() {
          this.closeSelf();
        }

        /**
         * 点击继续按钮
         */;
        _proto.onClickContinue = function onClickContinue() {
          this.closeSelf();
        }

        /**
         * 点击退出按钮
         */;
        _proto.onClickExitBattle = function onClickExitBattle() {
          this.exitBattleToMain();
        }

        /**
         * 点击重战按钮
         */;
        _proto.onClickRestartBattle = function onClickRestartBattle() {
          App.dungeonBattleMgr.reqReTry();
        };
        _proto.onResReTry = function onResReTry(msg) {
          if (msg && msg.code !== 200) {
            return;
          }
          this.restartBattle();
        };
        _proto.exitBattleToMain = /*#__PURE__*/function () {
          var _exitBattleToMain = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  if (!this._isProcessing) {
                    _context.next = 2;
                    break;
                  }
                  return _context.abrupt("return");
                case 2:
                  this._isProcessing = true;
                  this.closeSelf(false);
                  try {
                    App.dungeonBattleMgr.reqBattleSettle(App.dungeonBattleMgr.dungeonId, App.dungeonBattleMgr.battleResult);
                  } catch (error) {
                    console.error("退出战斗失败:", error);
                  } finally {
                    this._isProcessing = false;
                  }
                case 5:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function exitBattleToMain() {
            return _exitBattleToMain.apply(this, arguments);
          }
          return exitBattleToMain;
        }();
        _proto.restartBattle = /*#__PURE__*/function () {
          var _restartBattle = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
            var currentGuanQiaId;
            return _regeneratorRuntime().wrap(function _callee2$(_context2) {
              while (1) switch (_context2.prev = _context2.next) {
                case 0:
                  if (!this._isProcessing) {
                    _context2.next = 2;
                    break;
                  }
                  return _context2.abrupt("return");
                case 2:
                  currentGuanQiaId = App.battleMgr.challengeGuanQiaId;
                  if (!(!currentGuanQiaId || currentGuanQiaId <= 0)) {
                    _context2.next = 7;
                    break;
                  }
                  console.warn("当前没有有效的关卡ID，无法重新进入战斗");
                  this.closeSelf();
                  return _context2.abrupt("return");
                case 7:
                  this._isProcessing = true;
                  this.closeSelf(false);
                  _context2.prev = 9;
                  _context2.next = 12;
                  return App.battleMgr.onExit(0, function () {}, false);
                case 12:
                  _context2.next = 14;
                  return new Promise(function (resolve) {
                    return setTimeout(resolve, 1000);
                  });
                case 14:
                  // 4. 重新请求进入副本
                  App.dungeonBattleMgr.ReqEnterDungeon(currentGuanQiaId);
                  console.log("\u91CD\u65B0\u8FDB\u5165\u5173\u5361: " + currentGuanQiaId);
                  _context2.next = 22;
                  break;
                case 18:
                  _context2.prev = 18;
                  _context2.t0 = _context2["catch"](9);
                  console.error("重新进入战斗失败:", _context2.t0);
                  // 失败时返回主城
                  App.monitorMgr.dispatchEvent(MonitorType.battle_flow_back_home);
                case 22:
                  _context2.prev = 22;
                  this._isProcessing = false;
                  return _context2.finish(22);
                case 25:
                case "end":
                  return _context2.stop();
              }
            }, _callee2, this, [[9, 18, 22, 25]]);
          }));
          function restartBattle() {
            return _restartBattle.apply(this, arguments);
          }
          return restartBattle;
        }();
        _proto.closeSelf = function closeSelf(resumeBattle) {
          if (resumeBattle === void 0) {
            resumeBattle = true;
          }
          if (this._onHideCallback) {
            if (resumeBattle) {
              this._onHideCallback();
            }
            this._onHideCallback = null;
          }
          this.onClose();
        };
        return BattleSettingView;
      }(UIBase), _class2.custom = {
        prefab: "prefabs/ui/BattleSettingView",
        binding: (_binding = {}, _binding["btnBackBat"] = {
          method: "onClickExitBattle"
        }, _binding["btnRest"] = {
          method: "onClickRestartBattle"
        }, _binding["btnContinue"] = {
          method: "onClickContinue"
        }, _binding)
      }, _class2)) || _class));
      ModuleContext.attachModule(BattleSettingView, ModuleDef.GAME_BATTLE_B);
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleSkillProps.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, Component;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Component = module.Component;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "9e249GhF35DjLdsvFvZ7m+g", "BattleSkillProps", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleSkillProps = exports('BattleSkillProps', (_dec = ccclass("BattleSkillProps"), _dec(_class = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleSkillProps, _Component);
        function BattleSkillProps() {
          return _Component.call(this) || this;
        }
        var _proto = BattleSkillProps.prototype;
        _proto.start = function start() {};
        _proto.update = function update(deltaTime) {};
        return BattleSkillProps;
      }(Component)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleSoldierHeadItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './TeamMgr.ts', './App.ts', './ModuleDef.ts', './MonitorType.ts', './UtilGame.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Sprite, Node, Label, Color, Component, TeamMgr, App, ModuleDef, MonitorType, UtilGame;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Node = module.Node;
      Label = module.Label;
      Color = module.Color;
      Component = module.Component;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      App = module.App;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      UtilGame = module.UtilGame;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _descriptor15;
      cclegacy._RF.push({}, "5b632qHsNtB5IJbp/Mwsejc", "BattleSoldierHeadItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleSoldierHeadItem = exports('BattleSoldierHeadItem', (_dec = ccclass("BattleSoldierHeadItem"), _dec2 = property({
        type: Sprite
      }), _dec3 = property({
        type: Sprite
      }), _dec4 = property({
        type: Node
      }), _dec5 = property({
        type: Label
      }), _dec6 = property({
        type: Label
      }), _dec7 = property({
        type: Node
      }), _dec8 = property({
        type: Sprite
      }), _dec9 = property({
        type: Sprite
      }), _dec10 = property({
        type: Label
      }), _dec11 = property({
        type: Node
      }), _dec12 = property({
        type: Sprite
      }), _dec13 = property({
        type: Node
      }), _dec14 = property({
        type: Label
      }), _dec15 = property({
        type: Label
      }), _dec16 = property({
        type: Node
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleSoldierHeadItem, _Component);
        function BattleSoldierHeadItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /** 士兵头像 */
          _initializerDefineProperty(_this, "headIcon", _descriptor, _assertThisInitialized(_this));
          /** 士兵品质背景 */
          _initializerDefineProperty(_this, "headBg", _descriptor2, _assertThisInitialized(_this));
          /** 阶级节点 */
          _initializerDefineProperty(_this, "stageNode", _descriptor3, _assertThisInitialized(_this));
          /** 士兵阶级 */
          _initializerDefineProperty(_this, "stageLabel", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "levelLabel", _descriptor5, _assertThisInitialized(_this));
          /** 上限节点node */
          _initializerDefineProperty(_this, "maxNode", _descriptor6, _assertThisInitialized(_this));
          /** 士兵上限显是状态icon */
          _initializerDefineProperty(_this, "iconSp", _descriptor7, _assertThisInitialized(_this));
          /** 士兵上限锁定状态icon */
          _initializerDefineProperty(_this, "lockSp", _descriptor8, _assertThisInitialized(_this));
          /** 士兵上限显示文本 */
          _initializerDefineProperty(_this, "limitLabel", _descriptor9, _assertThisInitialized(_this));
          /** 可升阶、激活遮罩节点 */
          _initializerDefineProperty(_this, "mask", _descriptor10, _assertThisInitialized(_this));
          /** 遮罩Sprite组件（用于扇形填充） */
          _initializerDefineProperty(_this, "maskSprite", _descriptor11, _assertThisInitialized(_this));
          /** 可升阶、激活节点 */
          _initializerDefineProperty(_this, "canLvNode", _descriptor12, _assertThisInitialized(_this));
          /** 可升阶、激活文本 */
          _initializerDefineProperty(_this, "canLab", _descriptor13, _assertThisInitialized(_this));
          /** 升阶、激活消耗文本 */
          _initializerDefineProperty(_this, "needLab", _descriptor14, _assertThisInitialized(_this));
          /** 选择框 */
          _initializerDefineProperty(_this, "selNode", _descriptor15, _assertThisInitialized(_this));
          // 私有变量
          _this._soldierType = 0;
          // 当前士兵类型
          _this._recruitCD = 0;
          // 招募CD（秒）
          _this._currentCD = 0;
          // 当前倒计时
          _this._currentCount = 0;
          // 当前数量
          _this._maxCount = 0;
          // 最大数量
          _this._soldierInfo = null;
          // 当前士兵信息
          _this._soldierPos = 0;
          // 士兵在编队中的位置
          _this._canUpgrade = false;
          // 是否可以升阶
          _this._itemType = 0;
          return _this;
        }
        var _proto = BattleSoldierHeadItem.prototype;
        // 列表类型 1右边，2左边
        _proto.onLoad = function onLoad() {
          // 注册点击事件
          this.node.on(Node.EventType.TOUCH_END, this.onItemClick, this);
          // 监听士气更新事件
          App.monitorMgr.addEventListener(MonitorType.battle_monster_dead_update_morale, this._onUpdateMorale, this);

          // 获取遮罩的Sprite组件
          if (this.maskSprite) {
            // 设置为扇形填充模式
            this.maskSprite.type = Sprite.Type.FILLED;
            this.maskSprite.fillType = Sprite.FillType.RADIAL;
            this.maskSprite.fillCenter.set(0.5, 0.5); // 中心点
            this.maskSprite.fillStart = 0.25; // 从顶部开始（12点方向）
            this.maskSprite.fillRange = 0; // 初始填充范围为0
          }
        };

        _proto.onDestroy = function onDestroy() {
          // 移除点击事件
          this.node.off(Node.EventType.TOUCH_END, this.onItemClick, this);
          // 移除士气更新监听
          App.monitorMgr.removeEventListener(MonitorType.battle_monster_dead_update_morale, this._onUpdateMorale, this);
        }

        /**
         * 士气更新事件处理
         */;
        _proto._onUpdateMorale = function _onUpdateMorale(morale) {
          // 士气更新后，重新检查是否可以升阶
          if (this._soldierInfo && this._itemType === 2) {
            this.updateUpgradeStatus(morale);
          }
        }

        /**
         *
         * @param data 士兵Unit数据
         * @param type 界面显示的列表；1右边，2左边（左边可进阶、激活）
         * @param battleData 战斗内士兵数据（等级、阶级、激活状态）
         */;
        _proto.show = function show(data, type, battleData) {
          // 如果没有数据或没有id，说明这个位置是空的
          if (!data || !data.id) {
            this.showEmpty();
            if (!data) {
              this.lockSp.node.active = true;
            }
            return;
          }
          this._itemType = type;

          // 获取士兵配置信息
          var soldierInfo = TeamMgr.inst.getSoldierById(data.id);
          if (!soldierInfo) {
            this.showEmpty();
            return;
          }

          // 保存士兵信息和位置
          this._soldierInfo = soldierInfo;
          this._soldierPos = data.pos || 0;
          var soldierCfg = TeamMgr.inst.getSoldierIdCfg(soldierInfo.soldier_id);
          if (!soldierCfg) {
            this.showEmpty();
            return;
          }
          this.selNode.active = false;

          // 显示所有元素
          this.showAllElements();

          // 设置士兵头像
          if (this.headIcon) {
            UtilGame.loadSoldierHeadIcon(this.headIcon, soldierInfo.soldier_id);
          }

          // 使用战斗内数据或默认数据
          var currentStage = battleData ? battleData.stage : soldierInfo.stage;
          var currentLevel = battleData ? battleData.level : soldierInfo.level;
          var isActivated = battleData ? battleData.activated : true;

          // 设置士兵阶级
          if (this.stageLabel) {
            this.stageLabel.string = currentStage + "\u9636";
          }
          this.levelLabel.string = currentLevel + "\u7EA7";

          // 获取士兵战斗相关数据 [cd, membernum, population]
          var _TeamMgr$inst$getSold = TeamMgr.inst.getSoldierBattle(soldierInfo.soldier_id),
            _cd = _TeamMgr$inst$getSold[0],
            membernum = _TeamMgr$inst$getSold[1],
            population = _TeamMgr$inst$getSold[2];

          // 设置人口上限显示
          if (this.limitLabel) {
            this.limitLabel.string = membernum + "/" + population;
          }
          if (this.lockSp) {
            this.lockSp.node.active = false;
          }

          // 如果是左边列表（type === 2），显示可升阶/激活相关信息
          if (type === 2) {
            this.maxNode.active = false;
            this.levelLabel.node.active = true;
            this.showUpgradeInfo(soldierInfo, isActivated, currentStage);
            this._onUpdateMorale(App.dungeonBattleMgr.morale);
          } else {
            // 右边列表显示出兵数量和倒计时
            this.mask.active = false;
            this.canLvNode.active = false;
            this.levelLabel.node.active = false;
            this.stageNode.active = true;
            this.maxNode.active = true;
            // 显示右边列表的招募倒计时
            this.showRecruitCD(soldierInfo.soldier_id);
          }
        }

        /**
         * 显示空位置（只显示背景）
         */;
        _proto.showEmpty = function showEmpty() {
          // 显示背景
          if (this.headBg) {
            this.headBg.node.active = true;
          }

          // 隐藏其他所有元素
          if (this.headIcon) {
            this.headIcon.node.active = false;
          }
          if (this.stageNode) {
            this.stageNode.active = false;
          }
          if (this.maxNode) {
            this.maxNode.active = false;
          }
          if (this.lockSp) {
            this.lockSp.node.active = false; // 显示锁定图标
          }

          if (this.mask) {
            this.mask.active = false;
          }
          if (this.canLvNode) {
            this.canLvNode.active = false;
          }
          this.levelLabel.node.active = false;
          this.selNode.active = false;
          this.maskSprite.node.active = false;
        }

        /**
         * 显示所有元素
         */;
        _proto.showAllElements = function showAllElements() {
          if (this.headBg) {
            this.headBg.node.active = true;
          }
          if (this.headIcon) {
            this.headIcon.node.active = true;
          }
          if (this.stageNode) {
            this.stageNode.active = true;
          }
          if (this.maxNode) {
            this.maxNode.active = true;
          }
        }

        /**
         * 显示升阶/激活信息（左边列表使用）
         * @param soldierInfo 士兵信息
         * @param isActivated 是否已激活
         * @param currentStage 当前阶级
         */;
        _proto.showUpgradeInfo = function showUpgradeInfo(soldierInfo, isActivated, currentStage) {
          this.levelLabel.node.active = true;
          this.maxNode.active = false;

          // 获取对应位置的编队士兵阶级上限
          var soldierUnit = TeamMgr.inst.getPosIUnit(this._soldierPos, 2); // 2 = 士兵编队
          var maxStage = 0; // 默认最高阶级为0（未激活）
          if (soldierUnit) {
            var formationSoldierInfo = TeamMgr.inst.getSoldierById(soldierUnit.id);
            if (formationSoldierInfo) {
              maxStage = formationSoldierInfo.stage;
            }
          }

          // 如果未激活（stage=0），显示激活信息
          if (!isActivated || currentStage === 0) {
            // 激活到1阶，获取1阶的配置
            var targetStage = 1;
            var stageCfg = TeamMgr.inst.getSoldierStageCfg(soldierInfo.soldier_id, targetStage);
            if (stageCfg) {
              var currentMorale = this.getCurrentMorale();
              var requiredMorale = stageCfg.cost_shiqi || 0;
              var hasEnoughMorale = currentMorale >= requiredMorale;
              // 检查激活阶级是否超过编队士兵阶级
              var canActivate = hasEnoughMorale && targetStage <= maxStage;

              // 设置可升级状态
              this._canUpgrade = canActivate;

              // 总是显示遮罩和激活信息
              if (this.mask) {
                this.mask.active = true;
              }
              if (this.canLvNode) {
                this.canLvNode.active = true;
              }
              if (this.canLab) {
                this.canLab.string = "可激活";
                // 士气足够且不超过编队士兵阶级显示绿色，否则显示红色
                this.canLab.color = canActivate ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
              }
              if (this.needLab) {
                this.needLab.string = "" + requiredMorale;
              }

              // 只有可激活时才显示选中框
              this.selNode.active = canActivate;
            }
            return;
          }

          // 已激活，检查是否可以升阶
          var nextStage = currentStage + 1;
          var nextStageCfg = TeamMgr.inst.getSoldierStageCfg(soldierInfo.soldier_id, nextStage);

          // 检查升阶后是否超过编队士兵阶级
          if (nextStage > maxStage) {
            // 已达到编队士兵阶级上限，不能继续升阶，隐藏遮罩和升阶信息
            this._canUpgrade = false;
            if (this.mask) {
              this.mask.active = false;
            }
            if (this.canLvNode) {
              this.canLvNode.active = false;
            }
            this.selNode.active = false;
            return;
          }
          if (nextStageCfg) {
            // 检查当前士气是否足够
            var _currentMorale = this.getCurrentMorale();
            var _requiredMorale = nextStageCfg.cost_shiqi || 0;
            var _hasEnoughMorale = _currentMorale >= _requiredMorale;

            // 设置可升级状态
            this._canUpgrade = _hasEnoughMorale;

            // 总是显示遮罩和升阶信息
            if (this.mask) {
              this.mask.active = true;
            }
            if (this.canLvNode) {
              this.canLvNode.active = true;
            }
            if (this.canLab) {
              this.canLab.string = "可升阶";
              // 士气足够显示绿色，不足显示红色
              this.canLab.color = _hasEnoughMorale ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
            }
            if (this.needLab) {
              this.needLab.string = "" + _requiredMorale;
            }

            // 只有士气足够才显示选中框
            this.selNode.active = _hasEnoughMorale;
          } else {
            // 已满阶，隐藏遮罩和升阶信息
            this._canUpgrade = false;
            if (this.mask) {
              this.mask.active = false;
            }
            if (this.canLvNode) {
              this.canLvNode.active = false;
            }
            this.selNode.active = false;
          }
        }

        /**
         * 更新升阶状态（士气变化时调用）
         */;
        _proto.updateUpgradeStatus = function updateUpgradeStatus(_morale) {
          if (!this._soldierInfo) {
            return;
          }

          // 获取战斗内士兵数据
          var battleData = App.dungeonBattleMgr.getBattleSoldierData(this._soldierInfo.soldier_id);
          if (!battleData) {
            return;
          }

          // 获取对应位置的编队士兵阶级上限
          var soldierUnit = TeamMgr.inst.getPosIUnit(this._soldierPos, 2);
          var maxStage = 0;
          if (soldierUnit) {
            var formationSoldierInfo = TeamMgr.inst.getSoldierById(soldierUnit.id);
            if (formationSoldierInfo) {
              maxStage = formationSoldierInfo.stage;
            }
          }

          // 如果未激活（stage=0），更新激活状态
          if (!battleData.activated || battleData.stage === 0) {
            var targetStage = 1;
            var stageCfg = TeamMgr.inst.getSoldierStageCfg(this._soldierInfo.soldier_id, targetStage);
            if (stageCfg) {
              var _currentMorale2 = this.getCurrentMorale();
              var _requiredMorale2 = stageCfg.cost_shiqi || 0;
              var _hasEnoughMorale2 = _currentMorale2 >= _requiredMorale2;
              var canActivate = _hasEnoughMorale2 && targetStage <= maxStage;
              this._canUpgrade = canActivate;
              this.mask.active = true;
              this.canLvNode.active = true;
              this.canLab.string = "可激活";
              this.canLab.color = canActivate ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
              this.selNode.active = canActivate;
            }
            return;
          }

          // 已激活，更新升阶状态
          var nextStage = battleData.stage + 1;

          // 检查是否超过编队士兵阶级上限
          if (nextStage > maxStage) {
            this._canUpgrade = false;
            this.mask.active = false;
            this.canLvNode.active = false;
            this.selNode.active = false;
            return;
          }
          var nextStageCfg = TeamMgr.inst.getSoldierStageCfg(this._soldierInfo.soldier_id, nextStage);
          if (!nextStageCfg) {
            // 已满阶
            this._canUpgrade = false;
            this.mask.active = false;
            this.canLvNode.active = false;
            this.selNode.active = false;
            return;
          }

          // 检查当前士气是否足够
          var currentMorale = this.getCurrentMorale();
          var requiredMorale = nextStageCfg.cost_shiqi || 0;
          var hasEnoughMorale = currentMorale >= requiredMorale;

          // 更新可升阶状态
          this._canUpgrade = hasEnoughMorale;

          // 更新UI显示
          this.mask.active = true;
          this.canLvNode.active = true;
          this.canLab.string = hasEnoughMorale ? "可升阶" : "";
          this.canLab.color = hasEnoughMorale ? new Color(0, 255, 0, 255) : new Color(255, 0, 0, 255);
          this.selNode.active = hasEnoughMorale;
        }

        /**
         * 获取当前战斗中的士气值
         */;
        _proto.getCurrentMorale = function getCurrentMorale() {
          if (App.dungeonBattleMgr) {
            return App.dungeonBattleMgr.currentMorale;
          }
          return 0;
        }

        /**
         * 显示招募倒计时（右边列表使用）
         */;
        _proto.showRecruitCD = function showRecruitCD(soldierType) {
          this._soldierType = soldierType;

          // 从 SoldierSpawnMgr 获取实时数据
          var soldierSpawnMgr = App.dungeonBattleMgr.soldierSpawnMgr;
          if (soldierSpawnMgr) {
            // 获取当前CD
            this._currentCD = soldierSpawnMgr.getSoldierCd(soldierType);
            // 获取当前数量
            this._currentCount = soldierSpawnMgr.getSoldierCount(soldierType);
            // 获取最大数量
            this._maxCount = soldierSpawnMgr.getSoldierMaxCount(soldierType);

            // 获取基础CD配置（用于重置）
            var _TeamMgr$inst$getSold2 = TeamMgr.inst.getSoldierBattle(soldierType),
              cd = _TeamMgr$inst$getSold2[0],
              _membernum = _TeamMgr$inst$getSold2[1],
              _population = _TeamMgr$inst$getSold2[2];
            this._recruitCD = cd;
          } else {
            // 降级方案：从配置获取
            var _TeamMgr$inst$getSold3 = TeamMgr.inst.getSoldierBattle(soldierType),
              _cd2 = _TeamMgr$inst$getSold3[0],
              _membernum2 = _TeamMgr$inst$getSold3[1],
              population = _TeamMgr$inst$getSold3[2];
            this._recruitCD = _cd2;
            this._maxCount = population;
            this._currentCount = this.getCurrentSoldierCount(soldierType);
          }

          // 更新显示
          this.updateRecruitDisplay();
        }

        /**
         * 获取当前士兵数量（降级方案，从战斗管理器获取）
         */;
        _proto.getCurrentSoldierCount = function getCurrentSoldierCount(soldierType) {
          // 优先从 SoldierSpawnMgr 获取
          var soldierSpawnMgr = App.dungeonBattleMgr.soldierSpawnMgr;
          if (soldierSpawnMgr) {
            return soldierSpawnMgr.getSoldierCount(soldierType);
          }

          // 降级方案：从 DungeonBattleMgr 获取
          if (App.dungeonBattleMgr) {
            var populationMap = App.dungeonBattleMgr.soldierPopulation;
            if (populationMap && populationMap.has(soldierType)) {
              return populationMap.get(soldierType) || 0;
            }
          }
          return 0;
        }

        /**
         * 更新招募显示
         */;
        _proto.updateRecruitDisplay = function updateRecruitDisplay() {
          if (this._itemType !== 1) {
            return;
          }
          // 更新数量显示
          if (this.limitLabel) {
            this.limitLabel.string = this._currentCount + "/" + this._maxCount;
          }

          // 如果未达到上限，显示倒计时
          if (this._currentCount < this._maxCount) {
            this.limitLabel.color = Color.WHITE;
            App.resMgr.loadImage(this.iconSp, ModuleDef.GAME_BATTLE_B, "/images/new_battleUI/zd_bingzhong00");
            if (this.maskSprite) {
              this.maskSprite.node.active = true;
              if (this.maskSprite) {
                // 计算倒计时进度（1到0，从满到空）
                var remainingRatio = this._currentCD / this._recruitCD; // 剩余时间比例（1到0）

                // 设置扇形填充范围（顺时针填充，从1到0表示从满圆到空）
                this.maskSprite.fillRange = remainingRatio;
              }
            }
          } else {
            // 已达到上限，隐藏倒计时
            if (this.maskSprite) {
              this.maskSprite.node.active = false;
            }
            this.limitLabel.color = Color.RED;
            App.resMgr.loadImage(this.iconSp, ModuleDef.GAME_BATTLE_B, "/images/new_battleUI/zd_bingzhong01");
          }
        }

        /**
         * 每帧更新（用于倒计时）
         */;
        _proto.update = function update(_dt) {
          if (App.battleMgr.pause) return;
          // 如果是右边列表（显示招募倒计时），从 SoldierSpawnMgr 获取实时数据
          if (this._itemType === 1 && this._soldierType > 0) {
            var soldierSpawnMgr = App.dungeonBattleMgr.soldierSpawnMgr;
            if (soldierSpawnMgr) {
              // 获取实时CD
              this._currentCD = soldierSpawnMgr.getSoldierCd(this._soldierType);
              // 获取实时数量
              var newCount = soldierSpawnMgr.getSoldierCount(this._soldierType);
              if (newCount !== this._currentCount) {
                this._currentCount = newCount;
              }
              // 获取实时最大数量（可能因升级而变化）
              var newMaxCount = soldierSpawnMgr.getSoldierMaxCount(this._soldierType);
              if (newMaxCount !== this._maxCount) {
                this._maxCount = newMaxCount;
              }
              this.updateRecruitDisplay();
            }
          }
        }

        /**
         * 设置当前倒计时（外部调用，用于同步倒计时）
         */;
        _proto.setCurrentCD = function setCurrentCD(cd) {
          this._currentCD = cd;
          this.updateRecruitDisplay();
        }

        /**
         * 更新士兵数量（外部调用）
         */;
        _proto.updateSoldierCount = function updateSoldierCount(count) {
          this._currentCount = count;
          this.updateRecruitDisplay();
        }

        /**
         * 点击事件处理
         */;
        _proto.onItemClick = function onItemClick() {
          if (this._itemType === 1) {
            App.dungeonBattleMgr.refreshSoldierWithOrder(this._soldierInfo.soldier_id, 2);
            return;
          }
          // 只有左边列表（type === 2）且可以升阶/激活时才响应点击
          if (!this._canUpgrade || !this._soldierInfo) {
            return;
          }

          // 获取战斗内士兵数据
          var battleData = App.dungeonBattleMgr.getBattleSoldierData(this._soldierInfo.soldier_id);
          if (!battleData) {
            return;
          }

          // 获取当前阶级配置（用于激活或升阶）
          var targetStage = battleData.activated ? battleData.stage + 1 : battleData.stage;

          // 获取对应位置的编队士兵阶级上限
          var soldierUnit = TeamMgr.inst.getPosIUnit(this._soldierPos, 2); // 2 = 士兵编队
          var maxStage = 0; // 默认最高阶级为0（未激活）
          if (soldierUnit) {
            var formationSoldierInfo = TeamMgr.inst.getSoldierById(soldierUnit.id);
            if (formationSoldierInfo) {
              maxStage = formationSoldierInfo.stage;
            }
          }

          // 检查士兵升阶是否超过编队士兵阶级
          if (targetStage > maxStage) {
            console.log("\u58EB\u5175\u5347\u9636\u5931\u8D25\uFF1A\u58EB\u5175\u76EE\u6807\u9636\u7EA7" + targetStage + "\u4E0D\u80FD\u8D85\u8FC7\u7F16\u961F\u58EB\u5175\u9636\u7EA7" + maxStage);
            return;
          }
          var stageCfg = TeamMgr.inst.getSoldierStageCfg(this._soldierInfo.soldier_id, targetStage);
          if (!stageCfg) {
            return;
          }

          // 再次检查士气是否足够
          var currentMorale = this.getCurrentMorale();
          var requiredMorale = stageCfg.cost_shiqi || 0;
          if (currentMorale < requiredMorale) {
            console.log("\u58EB\u6C14\u4E0D\u8DB3\uFF0C\u65E0\u6CD5" + (battleData.activated ? "升阶" : "激活") + ": \u5F53\u524D=" + currentMorale + ", \u9700\u8981=" + requiredMorale);
            return;
          }
          App.dungeonBattleMgr.sendBattleHeart();
          // 发送战斗内升阶请求
          App.dungeonBattleMgr.reqBattleUpStage(this._soldierInfo.soldier_id);
          console.log("\u8BF7\u6C42\u6218\u6597\u5185\u58EB\u5175" + (battleData.activated ? "升阶" : "激活") + ": soldier_id=" + this._soldierInfo.soldier_id + ", " + ("\u5F53\u524D\u9636\u7EA7=" + battleData.stage + ", \u76EE\u6807\u9636\u7EA7=" + targetStage + ", \u7F16\u961F\u58EB\u5175\u4E0A\u9650=" + maxStage + ", \u6D88\u8017\u58EB\u6C14=" + requiredMorale));
        }

        /**
         * 刷新显示（外部调用，用于升阶成功后更新UI）
         */;
        _proto.refresh = function refresh(data, type) {
          var battleData = data ? App.dungeonBattleMgr.getBattleSoldierData(data.id) : null;
          this.show(data, type, battleData);
        };
        return BattleSoldierHeadItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "headIcon", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "headBg", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "stageNode", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "stageLabel", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "levelLabel", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "maxNode", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "iconSp", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "lockSp", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "limitLabel", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "mask", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "maskSprite", [_dec12], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "canLvNode", [_dec13], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "canLab", [_dec14], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "needLab", [_dec15], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor15 = _applyDecoratedDescriptor(_class2.prototype, "selNode", [_dec16], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleTipsItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './BattleUtil.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Node, v3, UITransform, Component, App, BattleUtil;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      v3 = module.v3;
      UITransform = module.UITransform;
      Component = module.Component;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2;
      cclegacy._RF.push({}, "86a85AKp0BFrbN/e7sKCt+2", "BattleTipsItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleTipsItem = exports('BattleTipsItem', (_dec = ccclass("BattleTipsItem"), _dec2 = property({
        type: Node
      }), _dec3 = property({
        type: Node
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleTipsItem, _Component);
        function BattleTipsItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "img_icon", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "img_arrow", _descriptor2, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = BattleTipsItem.prototype;
        _proto.start = function start() {};
        _proto.update = function update(deltaTime) {
          this.img_icon.active = false;
          this.img_arrow.active = false;
          var boss = App.battleMgr.roleCtrl.getBoss();
          if (!boss) return;
          var entranceNode = boss.node;
          if (!entranceNode) return;
          var endPos1 = entranceNode.worldPosition;
          var playerCamera = App.battleMgr.battleMainViewCtrl.playerCamera;
          var playerPos = playerCamera.node.worldPosition;
          var endPos = v3(endPos1.x, endPos1.y + boss.hitPos.y, endPos1.z);
          var halfHN = this.node.parent.getComponent(UITransform).height / 2;
          var halfW = 350; // ui.getComponent(UITransform).width / 2;
          var halfH = 600; //ui.getComponent(UITransform).height / 2;
          var reduceX = Math.abs(endPos.x - playerPos.x);
          var reduceY = Math.abs(endPos.y - playerPos.y);
          if (reduceX < halfW && reduceY < halfH) {
            return;
          }
          this.img_arrow.active = true;
          this.img_icon.active = true;
          // const halfW11 = this.node.parent.getComponent(UITransform).width / 2;
          // const halfH11 = this.node.parent.getComponent(UITransform).height / 2;
          var startPos = playerPos; // App.battleMgr.roleCtrl.player.node.worldPosition;
          var angle = BattleUtil.get2DAngleByPoint(startPos, endPos);

          // let lockPos_start = this.node.parent.getComponent(UITransform).convertToNodeSpaceAR(startPos);
          // let lockPos_end = this.node.parent.getComponent(UITransform).convertToNodeSpaceAR(endPos);

          this.node.angle = angle;
          this.img_icon.angle = -angle;
          // this.node.worldPosition = pos;
          this.node.setPosition(endPos.x - startPos.x, endPos.y - startPos.y);
          var halfW22 = 300;
          var halfH22 = 550;
          halfH22 = Math.min(halfH22, halfHN - 180);
          var x = this.node.position.x;
          var y = this.node.position.y;
          x = x < -halfW22 ? -halfW22 : x;
          x = x > halfW22 ? halfW22 : x;
          y = y < -halfH22 ? -halfH22 : y;
          y = y > halfH22 + 180 ? halfH22 + 180 : y;
          this.node.setPosition(x, y);
        };
        return BattleTipsItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "img_icon", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "img_arrow", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleUISkillItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './DBRecord.ts', './ModuleDef.ts', './App.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createClass, cclegacy, _decorator, Sprite, Node, Label, Component, DBRecord, ModuleDef, App;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Node = module.Node;
      Label = module.Label;
      Component = module.Component;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4;
      cclegacy._RF.push({}, "432baMzRRZODJD9iWr7Bmpq", "BattleUISkillItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /**
       * 战斗场景技能栏item
       */
      var BattleUISkillItem = exports('BattleUISkillItem', (_dec = ccclass("BattleUISkillItem"), _dec2 = property({
        type: Sprite
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Sprite
      }), _dec5 = property({
        type: Label
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleUISkillItem, _Component);
        function BattleUISkillItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "img_view", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "cdPart", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "img_cd", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lab_cd", _descriptor4, _assertThisInitialized(_this));
          _this._fClick0 = void 0;
          _this._fClick1 = void 0;
          /** 技能数据对象 */
          _this._skillVO = void 0;
          return _this;
        }
        var _proto = BattleUISkillItem.prototype;
        _proto.start = function start() {
          var _this2 = this;
          this.node.on(Node.EventType.TOUCH_START, function () {
            if (_this2._fClick0) {
              _this2._fClick0();
            }
          });
          this.node.on(Node.EventType.TOUCH_END, function () {
            // this.use()
            if (_this2._fClick1) {
              _this2._fClick1();
            }
          });
          this.node.on(Node.EventType.TOUCH_CANCEL, function () {
            if (_this2._fClick1) {
              _this2._fClick1();
            }
          });
          // this.node.on(Node.EventType.TOUCH_START, () => {
          //     if (this._fClick0) {
          //         this._fClick0()
          //     }
          // })
          // this.node.on(Node.EventType.TOUCH_MOVE, () => { this.unschedule(this._onClick1) })
        };

        _proto.update = function update(deltaTime) {
          this._updateCDPart();
        }

        /**
         * 初始化
         */;
        _proto.init = function init(skill) {
          this.cdPart.active = false;
          this._skillVO = skill;
          var cfg = DBRecord.fetchId("Skill", skill.skillID);
          App.resMgr.loadImage(this.img_view, ModuleDef.GAME_SKILL, "/texture/" + cfg.icon);
        }

        /**
         * 使用技能
         */;
        _proto.use = function use() {
          this.cdPart.active = true;
          this._updateCDPart();
        }

        /**
         * 更新CD相关UI
         * @returns
         */;
        _proto._updateCDPart = function _updateCDPart() {
          if (!this._skillVO) return;
          if (!this.cdPart.active) {
            if (this._skillVO.CD !== this._skillVO.curCD) {
              this.cdPart.active = true;
            } else {
              return;
            }
          }
          var cur = this._skillVO.curCD;
          var max = this._skillVO.CD;
          var progress = max === 0 ? 0 : cur / max;
          this.lab_cd.string = cur.toFixed(1);
          this.img_cd.fillRange = progress;
          this.cdPart.active = cur !== 0;
        };
        _proto.setClick0 = function setClick0(_fClick0) {
          this._fClick0 = _fClick0;
        };
        _proto.setClick1 = function setClick1(_fClick1) {
          this._fClick1 = _fClick1;
        };
        _createClass(BattleUISkillItem, [{
          key: "skillVO",
          get: function get() {
            return this._skillVO;
          }
        }]);
        return BattleUISkillItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "img_view", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "cdPart", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "img_cd", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "lab_cd", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleUISysDef.ts", ['cc'], function (exports) {
  var cclegacy, _decorator;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
    }],
    execute: function () {
      var _dec, _class, _class2;
      cclegacy._RF.push({}, "c8cfcZxGCJPPYtbVdYRoLOG", "BattleUISysDef", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleUISysDef = exports('BattleUISysDef', (_dec = ccclass("BattleUISysDef"), _dec(_class = (_class2 = function BattleUISysDef() {}, _class2.DianFengUISys = "DianFengUISys", _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleUIView.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Utils.ts', './MonitorType.ts', './BattleUISkillItem.ts', './UIUtil.ts', './DBRecord.ts', './UIMgr.ts', './ModuleDef.ts', './BattleDefine.ts', './SoundDef.ts', './SkillVO.ts', './GameConfig.ts', './App.ts', './BattleSoldierHeadItem.ts', './BattleSettingView.ts', './Layout_BattleSettingView.ts', './TeamMgr.ts', './ScrollList.ts', './Item_prop.ts', './BattleDebugNewView.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createClass, cclegacy, _decorator, Node, Prefab, Button, Label, Sprite, Tween, instantiate, UITransform, tween, v3, Component, Utils, MonitorType, BattleUISkillItem, UIUtil, DBRecord, UIMgr, LayerType, ModuleDef, GameBattle, SoundDef, SkillVO, GameConfig, App, BattleSoldierHeadItem, BattleSettingView, Layout_BattleSettingView, TeamMgr, ScrollList, Item_prop, BattleDebugNewView;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      Prefab = module.Prefab;
      Button = module.Button;
      Label = module.Label;
      Sprite = module.Sprite;
      Tween = module.Tween;
      instantiate = module.instantiate;
      UITransform = module.UITransform;
      tween = module.tween;
      v3 = module.v3;
      Component = module.Component;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      BattleUISkillItem = module.BattleUISkillItem;
    }, function (module) {
      UIUtil = module.UIUtil;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      SoundDef = module.SoundDef;
    }, function (module) {
      SkillVO = module.SkillVO;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleSoldierHeadItem = module.BattleSoldierHeadItem;
    }, function (module) {
      BattleSettingView = module.BattleSettingView;
    }, function (module) {
      Layout_BattleSettingView = module.Layout_BattleSettingView;
    }, function (module) {
      TeamMgr = module.TeamMgr;
    }, function (module) {
      ScrollList = module.ScrollList;
    }, function (module) {
      Item_prop = module.Item_prop;
    }, function (module) {
      BattleDebugNewView = module.BattleDebugNewView;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _dec18, _dec19, _dec20, _dec21, _dec22, _dec23, _dec24, _dec25, _dec26, _dec27, _dec28, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _descriptor15, _descriptor16, _descriptor17, _descriptor18, _descriptor19, _descriptor20, _descriptor21, _descriptor22, _descriptor23, _descriptor24, _descriptor25, _descriptor26, _descriptor27;
      cclegacy._RF.push({}, "3543f2+J2tBT558Sup1e6tJ", "BattleUIView", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BattleUIView = exports('BattleUIView', (_dec = ccclass("BattleUIView"), _dec2 = property({
        type: Node
      }), _dec3 = property({
        type: Node
      }), _dec4 = property({
        type: Node
      }), _dec5 = property({
        type: Node
      }), _dec6 = property({
        type: Node
      }), _dec7 = property({
        type: Prefab
      }), _dec8 = property({
        type: Node
      }), _dec9 = property({
        type: Button
      }), _dec10 = property({
        type: Label
      }), _dec11 = property({
        type: Label
      }), _dec12 = property({
        type: Label
      }), _dec13 = property({
        type: Button
      }), _dec14 = property({
        type: Node
      }), _dec15 = property({
        type: Label
      }), _dec16 = property({
        type: Node
      }), _dec17 = property([BattleSoldierHeadItem]), _dec18 = property({
        type: Node
      }), _dec19 = property([BattleSoldierHeadItem]), _dec20 = property({
        type: Label
      }), _dec21 = property({
        type: Button
      }), _dec22 = property({
        type: Button
      }), _dec23 = property({
        type: Node
      }), _dec24 = property({
        type: Sprite
      }), _dec25 = property({
        type: Label
      }), _dec26 = property({
        type: Label
      }), _dec27 = property({
        type: ScrollList
      }), _dec28 = property(BattleDebugNewView), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BattleUIView, _Component);
        function BattleUIView() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "skillItemContainer", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "tempSkillItem", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "battleTipsItem", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "win", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "tip", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "itemTips", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bloodMooon", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "btnBoxInfo", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbMorale", _descriptor9, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbBoxInfo", _descriptor10, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbTime", _descriptor11, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "btn_setting", _descriptor12, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "nameNode", _descriptor13, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "nameLabel", _descriptor14, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "leftNode", _descriptor15, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "leftSoldierHeads", _descriptor16, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "rightNode", _descriptor17, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "rightSoldierHeads", _descriptor18, _assertThisInitialized(_this));
          /** 军令值 */
          _initializerDefineProperty(_this, "mOValue", _descriptor19, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "btnLeftHide", _descriptor20, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "btnRightHide", _descriptor21, _assertThisInitialized(_this));
          /** 显示波数node */
          _initializerDefineProperty(_this, "waveLayer", _descriptor22, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "waveBg", _descriptor23, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "waveLabel", _descriptor24, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "nextTimeLab", _descriptor25, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "rewardScroll", _descriptor26, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "debugView", _descriptor27, _assertThisInitialized(_this));
          // @property({ type: BattleSettingView })
          // public battleSettingView: BattleSettingView;
          _this._skillItemMap = new Map();
          _this._time_limit = 0;
          _this._dt = 0;
          _this._battleEnd = false;
          //战斗结束标志
          _this._leftHidden = false;
          //左侧面板是否隐藏
          _this._rightHidden = false;
          _this._time_limit_DB = 0;
          _this.fbCfg = null;
          /**危险血量计时*/
          _this._dtDangerousHp = -1;
          //等待结算倒计时
          _this._backTime = 0;
          _this._showVictorying = false;
          _this._drugCD = 0;
          _this._useTime = 0;
          _this._heros = [];
          _this._skillData = [];
          _this._settingPaused = false;
          // 波次倒计时计时器
          _this._waveCountdownTimer = 0;
          // 波次倒计时相关
          _this._waveCountdown = 0;
          _this._waveCallback = null;
          _this._drugDt = 0;
          return _this;
        }
        var _proto = BattleUIView.prototype;
        _proto.start = function start() {
          this._registerEvent();
          this._initTime();
          this._initBossTips();
          // App.roleMgr.reqPlayerInfo();

          this._updtView();
          if (this.debugView) {
            this.debugView.node.active = true;
          }
        };
        _proto._updtView = function _updtView() {
          var _this2 = this;
          this.updateLeftSoldier();
          this.initRewardScroll();
          this.mOValue.string = App.dungeonBattleMgr.militaryOrders.toString();
          setTimeout(function () {
            _this2.nameNode.active = false;
          }, 3000);
        };
        _proto.onEnable = function onEnable() {
          this.win.active = false;
          this._backTime = 0;
          this._showVictorying = false;
          this._battleEnd = false;
        };
        _proto.onDisable = function onDisable() {
          var parent = this.node.getChildByName("battleTips");
          parent.removeAllChildren();
          for (var i = this._skillData.length; i--;) {
            if (this._skillData[i]) {
              // this._skillData[i].destroy();
              this._skillData[i] = null;
            }
          }
          this._skillData = [];

          // 清理波次倒计时
          this._waveCountdown = 0;
          this._waveCallback = null;
          this._waveCountdownTimer = 0;
        };
        _proto.onDestroy = function onDestroy() {
          this._unregisterEvent();

          // 清理战斗后处理
          this._battleEnd = true;
          this._showVictorying = false;
          this._backTime = 0;
          this.unscheduleAllCallbacks();
          this.fbCfg = null;

          // 清理波次倒计时
          this._waveCountdown = 0;
          this._waveCallback = null;
          this._waveCountdownTimer = 0;
        };
        _proto.update = function update(dt) {
          this._updateTime(dt);
          this._updateWaveCountdown(dt);
        }
        /**
         * 初始化奖励滚动列表
         * @param _data 奖励数据
         */;
        _proto.initRewardScroll = function initRewardScroll(_data) {
          this.rewardScroll.content.removeAllChildren();
          this.rewardScroll.onItemRender = this.onItemRender.bind(this);
          // this.rewardScroll.onItemClick = this.onItemClick.bind(this);
        };

        _proto.onItemRender = function onItemRender(item, index) {
          var data = this.rewardScroll.array[index];
          var cellComp = item.getComponent(Item_prop);
          cellComp.onItemRender(data);
        }

        /**
         * 更新波次倒计时
         */;
        _proto._updateWaveCountdown = function _updateWaveCountdown(dt) {
          if (this._waveCountdown <= 0) {
            return;
          }
          this._waveCountdownTimer += dt;

          // 每秒更新一次
          if (this._waveCountdownTimer >= 1.0) {
            this._waveCountdownTimer = 0;
            this._waveCountdown--;
            if (this._waveCountdown > 0) {
              // 更新显示
              if (this.nextTimeLab) {
                this.nextTimeLab.string = this._waveCountdown + "S";
              }
            } else {
              // 倒计时结束
              this.setSettingPaused(false);
              if (this.waveLayer) {
                this.waveLayer.active = false;
              }
              App.dungeonBattleMgr.waveStop = false;
              // 执行回调
              if (this._waveCallback) {
                var callback = this._waveCallback;
                this._waveCallback = null;
                callback();
              }
            }
          }
        }

        /**
         * 注册事件
         */;
        _proto._registerEvent = function _registerEvent() {
          App.monitorMgr.addEventListener(MonitorType.battle_player_use_skill, this._onEventBattlePlayerUseSkill, this);
          App.monitorMgr.addEventListener(MonitorType.battle_player_use_junling, this.updateMilitaryOrders, this);
          App.monitorMgr.addEventListener(MonitorType.battle_player_get_falling_item, this._onEventBattleGetFallingItem, this);
          App.monitorMgr.addEventListener(MonitorType.battle_monster_dead_update_morale, this._onEventBattleMonsterDeadUpdateMorale, this);

          // 监听士兵升阶成功事件
          App.monitorMgr.addEventListener(MonitorType.CMD_ResBattleUpStage, this._onManagerToViewUpdate, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResBattleHeart, this._onResBattleHeart, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResBattleRewardInfo, this.onResBattleRewardInfo, this);
          App.monitorMgr.addEventListener(MonitorType.battle_monster_die, this._onEventMonsterDie, this);

          // 添加btn_setting点击事件，点击显示BattleSettingView
          if (this.btn_setting) {
            this.btn_setting.node.on("click", this._onBtnSettingClicked, this);
          }

          // 添加左右隐藏按钮点击事件
          if (this.btnLeftHide) {
            this.btnLeftHide.node.on("click", this._onBtnLeftHideClicked, this);
          }
          if (this.btnRightHide) {
            this.btnRightHide.node.on("click", this._onBtnRightHideClicked, this);
          }
          if (this.waveBg) {
            this.waveBg.node.on("click", this._onBtnWaveBgClicked, this);
          }
          this.tip.removeAllChildren();
        }

        /**
         * 注销事件
         */;
        _proto._unregisterEvent = function _unregisterEvent() {
          var _this$btn_setting, _this$btnLeftHide, _this$btnRightHide, _this$waveBg;
          // 移除btn_setting点击事件
          (_this$btn_setting = this.btn_setting) == null || (_this$btn_setting = _this$btn_setting.node) == null || _this$btn_setting.off("click", this._onBtnSettingClicked, this);

          // 移除左右隐藏按钮点击事件
          (_this$btnLeftHide = this.btnLeftHide) == null || (_this$btnLeftHide = _this$btnLeftHide.node) == null || _this$btnLeftHide.off("click", this._onBtnLeftHideClicked, this);
          (_this$btnRightHide = this.btnRightHide) == null || (_this$btnRightHide = _this$btnRightHide.node) == null || _this$btnRightHide.off("click", this._onBtnRightHideClicked, this);
          (_this$waveBg = this.waveBg) == null || (_this$waveBg = _this$waveBg.node) == null || _this$waveBg.off("click", this._onBtnWaveBgClicked, this);
          App.monitorMgr.offTarget(this);
          Tween.stopAllByTag(99999988);
        };
        _proto.updateLeftSoldier = function updateLeftSoldier() {
          var index = 1;
          this.leftSoldierHeads.forEach(function (item) {
            var info = TeamMgr.inst.getPosIUnit(index, 2);
            // 获取战斗内士兵数据
            var battleData = info ? App.dungeonBattleMgr.getBattleSoldierData(info.id) : null;
            item.show(info, 2, battleData);
            index++;
          });
          index = 1;
          this.rightSoldierHeads.forEach(function (item) {
            var info = TeamMgr.inst.getPosIUnit(index, 2);
            // 获取战斗内士兵数据
            var battleData = info ? App.dungeonBattleMgr.getBattleSoldierData(info.id) : null;
            item.show(info, 1, battleData);
            index++;
          });
          if (App.dungeonBattleMgr.pushDungeonInfo) {
            this.lbMorale.string = App.dungeonBattleMgr.pushDungeonInfo.shiqi_val.toString();
          }
          this.fbCfg = DBRecord.fetchId("Fb", App.dungeonBattleMgr.dungeonId);
          this.nameLabel.string = this.fbCfg.name;
        }
        /**
         * 战斗心跳
         * @param msg 战斗心跳返回信息
         */;
        _proto._onResBattleHeart = function _onResBattleHeart(msg) {
          if (msg && msg.code !== 200) {
            return;
          }
          this.lbMorale.string = msg.shiqi_val.toString();
        };
        _proto.onResBattleRewardInfo = function onResBattleRewardInfo(msg) {
          var _this3 = this;
          if (msg && msg.code !== 200) {
            return;
          }
          if (App.dungeonBattleMgr.waveStop) {
            // this.initRewardScroll(msg.items);
            this.rewardScroll.array = msg.items;
            this.rewardScroll.updateAllItems();
          } else {
            this.waveLayer.active = false;
            if (!this._settingPaused) {
              this.setSettingPaused(true);
            }
            UIMgr.inst.open(BattleSettingView, LayerType.panel, Layout_BattleSettingView, [{
              msg: msg,
              cb: function cb() {
                if (_this3._settingPaused) {
                  _this3.setSettingPaused(false);
                }
              }
            }]);
          }
        };
        _proto.setSettingPaused = function setSettingPaused(flag) {
          this._settingPaused = flag;
          App.battleMgr.setPause(flag);
        };
        _proto.updateMilitaryOrders = function updateMilitaryOrders(militaryOrders) {
          this.mOValue.string = militaryOrders.toString();
        }

        /**
         * 处理管理器到视图的更新事件
         */;
        _proto._onManagerToViewUpdate = function _onManagerToViewUpdate(msg) {
          if (msg && msg.code !== 200) {
            App.log.logError("\u6E38\u620F\u7BA1\u7406\u5668: \u6218\u6597\u58EB\u5175\u5347\u9636 - \u9519\u8BEF\u7801: " + msg.code);
            return;
          }
          this.lbMorale.string = "" + msg.shiqi_val;

          // 搜索检测升阶的士兵
          var upgradedSoldier = this.findAndUpdateUpgradedSoldier(msg.soldier_id, msg.stage);
          if (upgradedSoldier) {
            App.log.logBusiness("\u58EB\u5175\u5347\u9636\u6210\u529F\uFF0C\u5DF2\u66F4\u65B0UI: soldier_id=" + msg.soldier_id + ", stage=" + msg.stage);
          } else {
            App.log.logError("\u58EB\u5175\u5347\u9636\u5931\u8D25: \u672A\u627E\u5230\u5347\u9636\u7684\u58EB\u5175 soldier_id=" + msg.soldier_id);
          }

          // 刷新左侧士兵列表
          this.updateLeftSoldier();
        }

        /**
         * 查找并更新升阶的士兵
         * @param soldierId 士兵ID
         * @param newStage 新的阶级
         * @returns 是否找到并更新成功
         */;
        _proto.findAndUpdateUpgradedSoldier = function findAndUpdateUpgradedSoldier(soldierId, newStage) {
          // 在左侧士兵列表中查找
          for (var i = 0; i < this.leftSoldierHeads.length; i++) {
            var item = this.leftSoldierHeads[i];
            var info = TeamMgr.inst.getPosIUnit(i + 1, 2);
            if (info && info.id === soldierId) {
              // 更新战斗内士兵数据
              App.dungeonBattleMgr.battleSoldierUpStage(soldierId, newStage);

              // 获取更新后的战斗数据
              var battleData = App.dungeonBattleMgr.getBattleSoldierData(soldierId);

              // 重新赋值并显示
              item.show(info, 2, battleData);
              App.log.logBusiness("\u5DE6\u4FA7\u58EB\u5175\u5347\u9636\u663E\u793A\u66F4\u65B0: index=" + i + ", soldier_id=" + soldierId + ", stage=" + newStage);
              return true;
            }
          }

          // 在右侧士兵列表中查找
          for (var _i = 0; _i < this.rightSoldierHeads.length; _i++) {
            var _item = this.rightSoldierHeads[_i];
            var _info = TeamMgr.inst.getPosIUnit(_i + 1, 1);
            if (_info && _info.id === soldierId) {
              // 更新战斗内士兵数据
              App.dungeonBattleMgr.battleSoldierUpStage(soldierId, newStage);

              // 获取更新后的战斗数据
              var _battleData = App.dungeonBattleMgr.getBattleSoldierData(soldierId);

              // 重新赋值并显示
              _item.show(_info, 1, _battleData);
              App.log.logBusiness("\u53F3\u4FA7\u58EB\u5175\u5347\u9636\u663E\u793A\u66F4\u65B0: index=" + _i + ", soldier_id=" + soldierId + ", stage=" + newStage);
              return true;
            }
          }
          return false;
        }

        /**
         * 左侧隐藏/展开按钮点击
         */;
        _proto._onBtnLeftHideClicked = function _onBtnLeftHideClicked() {
          this._leftHidden = !this._leftHidden;
          if (this.leftNode) {
            this.leftNode.active = !this._leftHidden;
          }

          // 使用 scaleX 翻转按钮：隐藏时翻转（scaleX = -1），展开时正常（scaleX = 1）
          if (this.btnLeftHide) {
            var scaleX = this._leftHidden ? 1 : -1;
            this.btnLeftHide.node.setScale(scaleX, 1);
          }
        }

        /**
         * 右侧隐藏/展开按钮点击
         */;
        _proto._onBtnRightHideClicked = function _onBtnRightHideClicked() {
          this._rightHidden = !this._rightHidden;
          if (this.rightNode) {
            this.rightNode.active = !this._rightHidden;
          }

          // 使用 scaleX 翻转按钮：隐藏时翻转（scaleX = -1），展开时正常（scaleX = 1）
          if (this.btnRightHide) {
            var scaleX = this._rightHidden ? -1 : 1;
            this.btnRightHide.node.setScale(scaleX, 1, 1);
          }
        }

        /**
         * 初始化技能
         */;
        _proto.initSkillItems = function initSkillItems() {
          var _this4 = this;
          var skills = App.battleMgr.skillCtrl.getPlayerSkills();
          var dData = App.skillMgr.getSkillData();
          var vData = [];
          for (var dx0 = 1; dx0 <= 5; dx0++) {
            var oTemp = (dData[dx0] || [])[0];
            var oData = undefined;
            if (oTemp) {
              for (var dx1 = 0; dx1 < skills.length; dx1++) {
                var oSkill = skills[dx1];
                if (oTemp.jineng_id === oSkill.skillID) {
                  oData = oSkill;
                  break;
                }
              }
              if (!oData) {
                var oSkillVO = new SkillVO();
                var JiNeng = DBRecord.fetchId("Skill", oTemp.jineng_id);
                oSkillVO.init(JiNeng);
                oData = oSkillVO;
              }
            }
            vData.push(oData);
          }
          this._skillData = vData;
          UIUtil.updateContainer(vData, this.skillItemContainer, this.tempSkillItem, function (data, node) {
            if (!data) return;
            var item = node.getComponent(BattleUISkillItem);
            item.init(data);
            _this4._skillItemMap.set(data.skillID, item);
            item.setClick0(function () {
              var worldPos = node.worldPosition.clone();
              worldPos.y += 50;
              // this.skillDesc.node.setWorldPosition(worldPos);
              // this.skillDesc.setPreData(data.skillID);
            });

            item.setClick1(function () {
              // this.skillDesc.setPreData(-1);
            });
          });
        }

        /**
         * 初始化时间UI
         */;
        _proto._initTime = function _initTime() {
          // let dbr: dbr.GuanQia = DBRecord.fetchId("GuanQia", App.battleMgr.challengeGuanQiaId);

          // dbr.time_limit = 150; //测试
          this._time_limit = 0; //dbr.time_limit + nExNum;
          if (GameConfig.DebugInfo.noTimeLimit) {
            this._time_limit *= 1000;
          }
          this._time_limit_DB = this._time_limit;
          this.lbTime.string = Utils.TimeFormat(this._time_limit, "m:s");
          this._dt = 0;
        }

        /**
         * 更新时间UI
         * @param dt
         */;
        _proto._updateTime = function _updateTime(dt) {
          if (App.battleMgr.pause) return;
          if (this._dtDangerousHp > 0) {
            this._dtDangerousHp -= dt;
            if (this._dtDangerousHp < 0) {
              // this.spine_DangerousHp.node.active = true;
              // this.spine_DangerousHp.setAnimation(0, "animation", false);
              if (!this._battleEnd) ;
              this._dtDangerousHp = -1;
            }
          }
          if (this._backTime > 0) {
            this._backTime -= dt;
            if (this._backTime <= 0) ;
          }
          if (this._battleEnd) return;
          this._dt += dt;
          if (this._time_limit !== undefined && this._dt > 1 && !this.win.active) {
            this._time_limit += this._dt;
            this._dt = 0;
            if (!App.battleMgr.bossIsDead) {
              this.lbTime.string = Utils.TimeFormat(Math.floor(this._time_limit), "m:s");
            }
          }
          this.updateDrugCD(dt);
        }

        /**
         * 初始化boss提示UI
         */;
        _proto._initBossTips = function _initBossTips() {
          this.battleTipsItem.active = false;
        }

        /**
         * 当boss出现时
         */;
        _proto.onShowBoss = function onShowBoss() {
          this.battleTipsItem.active = true;
        };
        /**
         * 显示波次提示层（带倒计时）
         * @param waveId 当前波次ID
         * @param totalWaves 总波次数
         * @param callback 倒计时结束后的回调
         */
        _proto.showWaveLayer = function showWaveLayer(waveId, totalWaves, callback) {
          if (!this.waveLayer) {
            if (callback) callback();
            return;
          }

          // 显示波次层
          this.waveLayer.active = true;
          // 先暂停展示获得奖励
          this.setSettingPaused(true);

          // 显示波次信息
          if (this.waveLabel) {
            this.waveLabel.string = "\u987A\u5229\u901A\u8FC7\u7B2C " + waveId + " / " + totalWaves + " \u6CE2";
          }

          // 设置倒计时（3秒）
          this._waveCountdown = 3;
          this._waveCallback = callback;
          if (this.nextTimeLab) {
            this.nextTimeLab.string = this._waveCountdown + "S";
          }
        };
        _proto._onBtnWaveBgClicked = function _onBtnWaveBgClicked() {
          this._waveCountdown = 1;
          this._updateWaveCountdown(1);
          // this._waveCountdown = 0;
        }

        /**
         * 按钮事件： 设置
         * @param _event
         * @param _customEventData
         */;
        _proto.onBtnEventSetting = function onBtnEventSetting(_event, _customEventData) {
          // console.log('onBtnEventSetting');
          App.soundMgr.playUIEffect(SoundDef.Sound_Audio_CommonButton1);
          // UIMgr.inst.openOnce(uiGameSet, LayerType.panel);
        }
        /**
         * btn_setting点击处理函数
         */;
        _proto._onBtnSettingClicked = function _onBtnSettingClicked() {
          // if (!this.battleSettingView) return;
          App.dungeonBattleMgr.reqBattleRewardInfo();
        }

        /**
         * 按钮事件： 退出
         * @param _event
         * @param _customEventData
         */;
        _proto.onBtnEventQuit = function onBtnEventQuit(_event, _customEventData) {
          console.log("onBtnEventQuit");
          App.soundMgr.playUIEffect(SoundDef.Sound_Audio_CommonButton1);
          App.monitorMgr.dispatchEvent(MonitorType.battle_flow_back_home);
          // App.roleMgr.reqPlayerInfo();
        };

        _proto._onEventBattleMonsterDeadUpdateMorale = function _onEventBattleMonsterDeadUpdateMorale(morale) {
          this.lbMorale.string = morale.toString();
        }

        /**
         * 怪物死亡事件处理
         * @param monster 死亡的怪物
         */;
        _proto._onEventMonsterDie = function _onEventMonsterDie(monster) {
          var _App$battleMgr$battle,
            _this5 = this;
          if (!monster || !monster.node) return;

          // 获取 fallingLayer
          var fallingLayer = (_App$battleMgr$battle = App.battleMgr.battleMainViewCtrl) == null ? void 0 : _App$battleMgr$battle.fallingLayer;
          if (!fallingLayer) {
            console.error("fallingLayer 不存在");
            return;
          }

          // 获取怪物死亡位置（世界坐标）
          var monsterWorldPos = monster.node.worldPosition.clone();

          // 加载并创建 ItemFallUi 节点
          App.resMgr.loadAsset(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemFallUi, Prefab, null, function (err, prefab) {
            if (err) {
              console.error("加载 ItemFallUi 预制体失败:", err);
              return;
            }

            // 实例化节点
            var itemFallNode = instantiate(prefab);
            if (!itemFallNode) {
              console.error("实例化 ItemFallUi 节点失败");
              return;
            }

            // 将节点添加到 fallingLayer
            itemFallNode.setParent(fallingLayer);

            // 转换怪物世界坐标到 fallingLayer 的本地坐标
            var localPos = fallingLayer.getComponent(UITransform).convertToNodeSpaceAR(monsterWorldPos);
            itemFallNode.setPosition(localPos);

            // 获取 btn_setting 的世界坐标并转换到 fallingLayer 的本地坐标
            var btnWorldPos = _this5.btn_setting.node.worldPosition.clone();
            var btnLocalPos = fallingLayer.getComponent(UITransform).convertToNodeSpaceAR(btnWorldPos);

            // 1秒后飞向 btn_setting，0.5秒飞行时间
            tween(itemFallNode).delay(0.6).to(0.5, {
              position: v3(btnLocalPos.x, btnLocalPos.y, 0),
              scale: v3(0.5, 0.5, 0)
            }, {
              easing: "sineInOut"
            }).call(function () {
              // 到达后删除节点
              itemFallNode.destroy();
            }).start();
          });
        }

        /**
         * 事件消息： 战斗 —— 主角 —— 使用技能
         * @param skillID 技能ID
         */;
        _proto._onEventBattlePlayerUseSkill = function _onEventBattlePlayerUseSkill(skillID) {
          var skillItem = this._skillItemMap.get(skillID);
          if (skillItem) {
            skillItem.use();
          }
        }

        /**
         * 事件消息： 战斗 —— 主角 —— 获得道具
         */;
        _proto._onEventBattleGetFallingItem = function _onEventBattleGetFallingItem(data) {
          for (var i = 0; i < this.tip.children.length; i++) {
            this.tip.children[i].y = (this.tip.children.length - i) * 50;
          }
          var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemGetPropTips);
          var lbName = node.getChildByPath("Node/lbItemName").getComponent(Label);
          var lbNum = node.getChildByPath("Node/lbNum").getComponent(Label);
          lbName.string = data.name;
          lbName.color = data.color;
          lbNum.string = "X" + String(data.count);
          node.setParent(this.tip);
          node.setPosition(0, 0, 0);
          tween(node).tag(99999988).delay(1.5).by(0.5, {
            position: v3(-200, 0, 0)
          }).call(function () {
            App.nodePoolMgr.putNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.OtherPrefabPath.itemGetPropTips, node);
          }).start();
        };
        _proto.hideOtherUI = function hideOtherUI() {
          //播放boss出场动画
          var _BattleUIView = this.node; //UIMgr.inst.getLayerNode(LayerType.panel).getChildByPath('BattleMainView/BattleUIView');
          _BattleUIView.children.forEach(function (node) {
            if (node.name !== "win") {
              node.active = false;
            } else {
              node.active = true;
            }
          });
          // BattleUIView.active = false;
          var BattleDebugView = this.node.parent.getChildByPath("BattleDebugView");
          BattleDebugView.active = false;
          // let BattleCtrlView = this.node.parent.getChildByPath('BattleCtrlView');
          // BattleCtrlView.active = false;
          var miniMap = this.node.parent.getChildByPath("miniMap");
          miniMap.active = false;
          // let bossHP = this.node.parent.getChildByPath('bossHP');
        };

        _proto.updateDrugCD = function updateDrugCD(dt) {
          this._drugDt += dt;
          if (this._drugDt < 1) return;
          this._drugDt = 0;
          this._drugCD--;
          if (this._drugCD <= 0) {
            this._drugCD = 0;
            return;
          }
        }

        /**
         * 战斗飘字提示
         * @param str 提示内容
         */;
        _proto.popTips = function popTips(str) {
          var node = instantiate(this.itemTips);
          var lb = node.getChildByName("lb").getComponent(Label);
          lb.string = str;
          var parent = this.node.getChildByName("battleTips");
          node.parent = parent;
          var y = -parent.children.length * 50;
          node.setPosition(0, y);
          tween(node).tag(GameBattle.BattleTweenTag).by(0.5, {
            y: 100
          }).call(function () {
            node.destroy();
          }).start();
        };
        _createClass(BattleUIView, [{
          key: "time_limit",
          get:
          //战斗剩余时间
          function get() {
            return this._time_limit;
          },
          set: function set(value) {
            this._time_limit = value;
          }
        }, {
          key: "battleEnd",
          get: function get() {
            return this._battleEnd;
          },
          set:
          //右侧面板是否隐藏
          function set(value) {
            this._battleEnd = value;
          }
        }, {
          key: "time_limit_DB",
          get: function get() {
            return this._time_limit_DB;
          },
          set: function set(value) {
            this._time_limit_DB = value;
          }
        }]);
        return BattleUIView;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "skillItemContainer", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "tempSkillItem", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "battleTipsItem", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "win", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "tip", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "itemTips", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "bloodMooon", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "btnBoxInfo", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "lbMorale", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "lbBoxInfo", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "lbTime", [_dec12], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "btn_setting", [_dec13], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "nameNode", [_dec14], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "nameLabel", [_dec15], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor15 = _applyDecoratedDescriptor(_class2.prototype, "leftNode", [_dec16], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor16 = _applyDecoratedDescriptor(_class2.prototype, "leftSoldierHeads", [_dec17], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _descriptor17 = _applyDecoratedDescriptor(_class2.prototype, "rightNode", [_dec18], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor18 = _applyDecoratedDescriptor(_class2.prototype, "rightSoldierHeads", [_dec19], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _descriptor19 = _applyDecoratedDescriptor(_class2.prototype, "mOValue", [_dec20], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor20 = _applyDecoratedDescriptor(_class2.prototype, "btnLeftHide", [_dec21], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor21 = _applyDecoratedDescriptor(_class2.prototype, "btnRightHide", [_dec22], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor22 = _applyDecoratedDescriptor(_class2.prototype, "waveLayer", [_dec23], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor23 = _applyDecoratedDescriptor(_class2.prototype, "waveBg", [_dec24], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor24 = _applyDecoratedDescriptor(_class2.prototype, "waveLabel", [_dec25], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor25 = _applyDecoratedDescriptor(_class2.prototype, "nextTimeLab", [_dec26], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor26 = _applyDecoratedDescriptor(_class2.prototype, "rewardScroll", [_dec27], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor27 = _applyDecoratedDescriptor(_class2.prototype, "debugView", [_dec28], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BattleUtil.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleDefine.ts', './BattleBigMap.ts', './AxingManager.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, cclegacy, Vec3, GameBattle, BattleBigMap, AxingManagerNew;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      BattleBigMap = module.BattleBigMap;
    }, function (module) {
      AxingManagerNew = module.AxingManagerNew;
    }],
    execute: function () {
      var _class;
      cclegacy._RF.push({}, "e3629kjlj1GCKJ6d/w4FYSc", "BattleUtil", undefined);

      /**
       * 战斗模块工具类
       */
      var BattleUtil = exports('BattleUtil', /*#__PURE__*/function () {
        function BattleUtil() {}
        /**
         * 分析方向
         * @param directionVector 方向向量
         * @returns
         */
        BattleUtil.analysisDirection = function analysisDirection(directionVector) {
          var dir = GameBattle.Direction.None;
          if (directionVector.x > 0) {
            if (directionVector.y > 0) {
              dir = GameBattle.Direction.RightUp;
            } else if (directionVector.y < 0) {
              dir = GameBattle.Direction.RightDown;
            } else {
              dir = GameBattle.Direction.Right;
            }
          } else if (directionVector.x < 0) {
            if (directionVector.y > 0) {
              dir = GameBattle.Direction.LeftUp;
            } else if (directionVector.y < 0) {
              dir = GameBattle.Direction.LeftDown;
            } else {
              dir = GameBattle.Direction.Left;
            }
          } else {
            if (directionVector.y > 0) {
              dir = GameBattle.Direction.Up;
            } else if (directionVector.y < 0) {
              dir = GameBattle.Direction.Down;
            } else {
              dir = GameBattle.Direction.None;
            }
          }
          return dir;
        };
        BattleUtil.get2DAngleByPoint = function get2DAngleByPoint(p1, p2) {
          return 180 / Math.PI * Math.atan2(p2.y - p1.y, p2.x - p1.x);
        }
        /**
         * 根据权重返回结果
         */;
        BattleUtil.getValueByProbability = function getValueByProbability(data) {
          //[90001,5000],[91001,5000]
          var total = 0;
          var list = [];
          for (var i = 0; i < data.length; i++) {
            total += data[i][1];
            list.push(total);
          }
          var num = Math.random() * total;
          for (var _i = 0; _i < list.length; _i++) {
            if (num < list[_i]) {
              return data[_i][0];
            }
          }
        };
        return BattleUtil;
      }());
      var AxingManager = exports('AxingManager', /*#__PURE__*/function () {
        function AxingManager() {
          //初始化寻路障碍物  w ,h- 地图宽与高
          this.map2d = void 0;
          this._mapCatch = {};
          this._tempV3_1 = new Vec3();
          this._tempV3_2 = new Vec3();
        }
        AxingManager.getInstance = function getInstance() {
          if (this._instance === undefined) {
            this._instance = new this();
          }
          return this._instance;
        };
        var _proto = AxingManager.prototype;
        _proto.init = function init() {
          // if (WECHAT) {
          //     AxingManager.USE_NEW_DATA=true;
          // } else {
          //     AxingManager.USE_NEW_DATA=true;
          // }
          // AxingManagerNew.USE_NEW_DATA=AxingManager.USE_NEW_DATA;
        }

        //二维数组
        ;

        _proto.Array2D = function Array2D(w, h, num) {
          var data = [];
          var default_num = num || 0;
          for (var x = 0; x < w; x++) {
            var temp = [];
            for (var y = 0; y < h; y++) {
              temp.push(default_num);
            }
            data.push(temp);
          }
          return {
            w: w,
            h: h,
            data: data,
            showArray2D: function showArray2D() {
              var s = "";
              for (var y = 0; y < this.h; y++) {
                for (var x = 0; x < this.w; x++) {
                  s += this.data[x][y] + " ";
                }
                s += "\n";
              }
              console.log(s);
            }
          };
        }

        //点
        ;

        _proto.Point = function Point(x, y) {
          return {
            x: x,
            y: y,
            eq: function eq(other) {
              return this.x === other.x && this.y === other.y;
            }
          };
        };
        _proto.Node = function Node(point, endPoint, g) {
          //描述AStar中的节点
          var tG = g || 0;
          return {
            point: point,
            //节点的坐标
            father: null,
            //父节点
            g: tG,
            //G值，g值在用到的时候会重新算
            h: (Math.abs(endPoint.x - point.x) + Math.abs(endPoint.y - point.y)) * 10 //计算H值
          };
        }

        /*
            功能：
                创建AStar对象，进行寻路
            参数：
                map2d:Array2D类型的地图数组
                startPoint:Point类型的寻路起点
                endPoint:Point类型的寻路终点
                passTag:int类型的可行走标记（若地图数据!=passTag即为障碍）
         */;
        _proto.AStar = function AStar(map2d, startPoint, endPoint, passTag, self) {
          var tag = passTag || 0;
          return {
            map2d: map2d,
            startPoint: startPoint,
            endPoint: endPoint,
            passTag: tag,
            openList: [],
            //开启表
            closeList: [],
            //关闭表
            deepCount: 0,
            isBoss: false,
            //获得openList中F值最小的节点
            getMinNode: function getMinNode() {
              var currentNode = this.openList[0];
              for (var _iterator = _createForOfIteratorHelperLoose(this.openList), _step; !(_step = _iterator()).done;) {
                var node = _step.value;
                if (node.g + node.h < currentNode.g + currentNode.h) currentNode = node;
              }
              return currentNode;
            },
            //判断point是否在关闭表中
            pointInCloseList: function pointInCloseList(point) {
              for (var _iterator2 = _createForOfIteratorHelperLoose(this.closeList), _step2; !(_step2 = _iterator2()).done;) {
                var node = _step2.value;
                if (node.point.eq(point)) return true;
              }
              return false;
            },
            //判断point是否在开启表中
            pointInOpenList: function pointInOpenList(point) {
              for (var _iterator3 = _createForOfIteratorHelperLoose(this.openList), _step3; !(_step3 = _iterator3()).done;) {
                var node = _step3.value;
                if (node.point.eq(point)) return node;
              }
              return null;
            },
            //判断终点是否在关闭表中
            endPointInCloseList: function endPointInCloseList() {
              for (var _iterator4 = _createForOfIteratorHelperLoose(this.closeList), _step4; !(_step4 = _iterator4()).done;) {
                var node = _step4.value;
                if (node.point.eq(this.endPoint)) return node;
              }
              return null;
            },
            //搜索节点周围的点
            searchNear: function searchNear(minF, offsetX, offsetY) {
              if (!AxingManager.USE_NEW_DATA) {
                //越界检测
                if (minF.point.x + offsetX < 0 || minF.point.x + offsetX > this.map2d.w - 1 || minF.point.y + offsetY < 0 || minF.point.y + offsetY > this.map2d.h - 1) return null;
                //如果是障碍就忽略
                if (this.map2d.data[minF.point.x + offsetX][minF.point.y + offsetY] !== this.passTag) return null;
              } else {
                if (BattleBigMap.getInstance().isBlock(minF.point.x + offsetX, minF.point.y + offsetY)) return null;
              }
              //如果在关闭表中就忽略
              var currentPoint = self.Point(minF.point.x + offsetX, minF.point.y + offsetY);
              if (this.pointInCloseList(currentPoint)) return null;
              this.deepCount++;
              //设置单位花费
              var step = 0;
              if (offsetX === 0 || offsetY === 0) step = 10;else step = 14;
              //如果不在openList中，就把它加入openList
              var currentNode = this.pointInOpenList(currentPoint);
              if (currentNode === null) {
                currentNode = self.Node(currentPoint, this.endPoint, minF.g + step);
                currentNode.father = minF;
                this.openList.push(currentNode);
                return null;
              }
              //如果在openList中，判断minF到当前点的G是否更小
              if (minF.g + step < currentNode.g) {
                currentNode.g = minF.g + step;
                currentNode.father = minF;
              }
            },
            //开始寻路
            start: function start() {
              //1.将起点放入开启列表
              var startNode = self.Node(this.startPoint, this.endPoint);
              this.openList.push(startNode);
              //2.主循环逻辑
              while (true) {
                //找到F值最小的节点
                var minF = this.getMinNode();
                //把这个点加入closeList中，并且在openList中删除它
                this.closeList.push(minF);
                var index = this.openList.indexOf(minF);
                this.openList.splice(index, 1);
                //搜索这个节点的上下左右节点
                this.searchNear(minF, 0, -1);
                this.searchNear(minF, 0, 1);
                this.searchNear(minF, -1, 0);
                this.searchNear(minF, 1, 0);
                this.searchNear(minF, -1, -1);
                this.searchNear(minF, -1, 1);
                this.searchNear(minF, 1, -1);
                this.searchNear(minF, 1, 1);
                // 判断是否终止
                var point = this.endPointInCloseList();
                if (point) {
                  //如果终点在关闭表中，就返回结果
                  var cPoint = point;
                  var pathList = [];
                  while (true) {
                    if (cPoint.father) {
                      pathList.push(cPoint.point);
                      cPoint = cPoint.father;
                    } else {
                      return pathList.reverse();
                    }
                  }
                }
                //开启表为空
                if (this.openList.length === 0) {
                  return null;
                }
                var limit = this.isBoss ? AxingManager.DEEP_LIMIT_BOSS : AxingManager.DEEP_LIMIT;
                if (this.deepCount > limit) {
                  //console.log("+++++++++++++++++++++++  count limit");
                  return null;
                }
              }
            }
          };
        };
        _proto.initMapData_zhangaiwu = function initMapData_zhangaiwu(h, w, mapData) {
          AxingManagerNew.getInstance().initMapData_zhangaiwu(h, w, mapData);
          // console.log("initMapData_zhangaiwu", mapData)
          this.map2d = this.Array2D(w, h, 0);
          // let index = 0
          // for (let i = 0  ; i < w; i++) {
          //     for ( let j = 0 ; j < h ; j++){
          //         this.map2d.data[j][i] = (mapData[i*w+j] === 0 ? 1: 0 );
          //     }
          // }
          for (var i = 0; i < w; i++) {
            for (var j = 0; j < h; j++) {
              this.map2d.data[i][j] = mapData[j * h + i] === 0 ? 1 : 0;
              //     this.map2d.data[i][j] = (mapData[i * w + j] === 0 ? 1 : 0);
            }
          }
        };

        _proto.Astar_use = function Astar_use(start_point, to_point, isInCity, isBoss) {
          if (AxingManager.USE_NEW_ALG) {
            return AxingManagerNew.getInstance().findPathImmediately(start_point, to_point);
          }
          var key = start_point.x + "," + start_point.y + "," + to_point.x + "," + to_point.y;
          if (this._mapCatch[key]) {
            return this._mapCatch[key];
          }
          var aStar = this.AStar(this.map2d, this.Point(start_point.x, start_point.y), this.Point(to_point.x, to_point.y), 0, this);
          aStar.isBoss = isBoss;
          var pathList = aStar.start();
          //log(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>= old deepCount", aStar.deepCount);
          if (!pathList || pathList.length === 0) {
            console.log("没找到行走的路径 ");
            // return start_point.copyAsVec3()//Vec3.ZERO
            return Vec3.ZERO;
          }
          // console.log("行走的路径= ", pathList, start_point, to_point);
          if (BattleBigMap.SHOW_PATH_SPRITE) {
            BattleBigMap.getInstance().showDebugPath(pathList);
          }
          this._tempV3_1.set(pathList[0].x, pathList[0].y, 0);
          this._tempV3_2.set(start_point.x, start_point.y, 0);
          this._tempV3_2.subtract(this._tempV3_1);
          this._tempV3_2.x *= -1;
          this._mapCatch[key] = this._tempV3_2;
          return this._tempV3_2;
        };
        _proto.Astar_use_new = function Astar_use_new(start_point_pixel, to_point_pixel, isInCity, maxDepthValue) {
          var start_point = BattleBigMap.getInstance().pointToBigMapGrid(start_point_pixel);
          var to_point = BattleBigMap.getInstance().pointToBigMapGrid(to_point_pixel);
          return AxingManagerNew.getInstance().findPathImmediately(start_point, to_point, maxDepthValue);
        }

        //地图数据转换为二维数组
        ;

        _proto.tilesToMapData = function tilesToMapData(width, height, mapData) {
          var data = [];
          var default_num = 0;
          for (var x = 0; x < height; x++) {
            var temp = [];
            for (var y = 0; y < width; y++) {
              temp.push(default_num);
            }
            data.push(temp);
          }
          for (var i = 0; i < height; i++) {
            for (var j = 0; j < width; j++) {
              data[i][j] = mapData[i * width + j] === 0 ? 1 : 0;
            }
          }
          return data;
        }

        //----------寻路test
        ;

        _proto.fineTest = function fineTest() {
          var map2d = this.Array2D(10, 10, 0);
          map2d.data[4][0] = 1;
          map2d.data[4][1] = 1;
          map2d.data[4][2] = 1;
          map2d.data[4][3] = 1;
          map2d.data[4][4] = 1;
          map2d.data[4][5] = 1;
          map2d.data[4][6] = 1;
          map2d.data[0][9] = 1;
          map2d.data[0][8] = 1;
          map2d.showArray2D();
          // console.log(map2d.data[4][0]);
          var aStar = this.AStar(map2d, this.Point(0, 0), this.Point(9, 9), 0, this);
          var pathList = aStar.start();
          for (var _iterator5 = _createForOfIteratorHelperLoose(pathList), _step5; !(_step5 = _iterator5()).done;) {
            var point = _step5.value;
            map2d.data[point.x][point.y] = 8;
          }
          map2d.showArray2D();
          console.log("输出=***********************= ");
        };
        _proto.test = function test(pathList) {
          // console.log("test=***********************= ", this.map2d.data[12][18], this.map2d.data);
          // this.map2d.showArray2D();
          // for (var point of pathList) {
          //     this.map2d.data[point.x][point.y] += 2;
          // }
          // this.map2d.showArray2D();
        };
        _proto.dispose = function dispose() {}

        // 清除缓存方法
        ;

        _proto.clearCache = function clearCache() {
          this._mapCatch = {};
          AxingManagerNew.getInstance().clearCache();
        };
        return AxingManager;
      }());
      _class = AxingManager;
      /**使用新的物理层数据 */
      AxingManager.USE_NEW_DATA = true;
      /**深度限制 */
      AxingManager.DEEP_LIMIT = 300;
      AxingManager.DEEP_LIMIT_BOSS = 1200;
      /**使用新算法 */
      AxingManager.USE_NEW_ALG = true;
      AxingManager._instance = new _class();
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BingLiCell.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './PlaceGameMgr.ts', './UtilGame.ts', './PlaceConfigMgr.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Sprite, Label, ProgressBar, Node, Component, PlaceGameMgr, UtilGame, PlaceConfigMgr;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Label = module.Label;
      ProgressBar = module.ProgressBar;
      Node = module.Node;
      Component = module.Component;
    }, function (module) {
      PlaceGameMgr = module.PlaceGameMgr;
    }, function (module) {
      UtilGame = module.UtilGame;
    }, function (module) {
      PlaceConfigMgr = module.PlaceConfigMgr;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6;
      cclegacy._RF.push({}, "4f8e2vOqbVOTKVkyBYwnFhB", "BingLiCell", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BingLiCell = exports('BingLiCell', (_dec = ccclass("BingLiCell"), _dec2 = property(Sprite), _dec3 = property(Sprite), _dec4 = property(Label), _dec5 = property(ProgressBar), _dec6 = property(Label), _dec7 = property(Node), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BingLiCell, _Component);
        function BingLiCell() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "bg", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "imgIcon", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbName", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "progressBar", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lbProgress", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "gouImg", _descriptor6, _assertThisInitialized(_this));
          _this._data = null;
          _this._index = -1;
          return _this;
        }
        var _proto = BingLiCell.prototype;
        /**
         * 设置数据并渲染
         * @param data 兵力数据
         * @param index 在列表中的索引
         */
        _proto.setData = function setData(data, index) {
          if (index === void 0) {
            index = -1;
          }
          this._data = data;
          this._index = index;
          this.updateView();
        }

        /**
         * 获取当前数据
         */;
        _proto.getData = function getData() {
          return this._data;
        }

        /**
         * 获取当前索引
         */;
        _proto.getIndex = function getIndex() {
          return this._index;
        };
        _proto.updateView = function updateView() {
          if (!this._data) return;

          // 更新兵种图标
          if (this.imgIcon) {
            UtilGame.loadSoldierIcon(this.imgIcon, this._data[0]);
          }

          // 更新兵种名称
          if (this.lbName) {
            var showName = PlaceConfigMgr.inst.getSoldierName(this._data[0]);
            this.lbName.string = showName || "";
          }
          var current = PlaceGameMgr.inst.getSoldierCount(this._data[0]);
          var total = this._data[1] || 1;
          if (this.progressBar && this.lbProgress) {
            this.progressBar.progress = Math.min(current / total, 1);
            this.lbProgress.string = current + "/" + total;
          }
          if (this.gouImg) {
            if (current >= total) {
              this.gouImg.active = true;
            } else {
              this.gouImg.active = false;
            }
          }
          this.updateBgDisplay();
        };
        _proto.updateBgDisplay = function updateBgDisplay() {
          if (!this.bg) return;
          if (this._index === -1) {
            this.bg.node.active = true;
            return;
          }
          var col = this._index % 2;
          this.bg.node.active = col === 1;
        };
        return BingLiCell;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "bg", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "imgIcon", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "lbName", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "progressBar", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "lbProgress", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "gouImg", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BingYingModel.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BuildingModel.ts', './App.ts', './PlaceConfigMgr.ts'], function (exports) {
  var _inheritsLoose, _createForOfIteratorHelperLoose, _createClass, cclegacy, BuildingModel, App, PlaceConfigMgr;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      BuildingModel = module.BuildingModel;
    }, function (module) {
      App = module.App;
    }, function (module) {
      PlaceConfigMgr = module.PlaceConfigMgr;
    }],
    execute: function () {
      cclegacy._RF.push({}, "7d82f5d0IlMSqRyZI/GdTbn", "BingYingModel", undefined);

      /**
       * 训练队列信息接口
       */

      /**
       * 兵营数据模型基类
       */
      var BingYingModel = exports('BingYingModel', /*#__PURE__*/function (_BuildingModel) {
        _inheritsLoose(BingYingModel, _BuildingModel);
        /**
         * 构造函数
         */
        function BingYingModel(buildingUid, buildType, buildIndex, level, owner) {
          var _this;
          if (level === void 0) {
            level = 0;
          }
          _this = _BuildingModel.call(this, buildIndex, buildType, buildingUid, level, owner) || this;
          /**
           * 剩余建造时间(秒)
           */
          _this._remainingBuildTime = 0;
          /**
           * 总建造时间
           */
          _this._totalBuildTime = 0;
          /**
           * 当前训练中的队列
           */
          _this.xlQueues = [];
          /**
           * 最大训练队列数
           */
          _this._maxXLSlots = 1;
          _this.updateMaxXLSlots();
          return _this;
        }
        var _proto = BingYingModel.prototype;
        _proto.getRemainBuildTime = function getRemainBuildTime() {
          return this._remainingBuildTime;
        };
        _proto.getToTalBuildTime = function getToTalBuildTime() {
          return this._totalBuildTime;
        }

        /**
         * 开始建造升级
         * @param buildTime 建造时间（毫秒）
         * @param targetLevel 目标等级
         */;
        _proto.startBuildingUpgrade = function startBuildingUpgrade(buildTime, totalTime) {
          this._remainingBuildTime = buildTime;
          this._totalBuildTime = totalTime;
        }

        /**
         * 减少剩余建造时间
         * @param milliseconds 减少的秒
         * @returns 剩余建造时间
         */;
        _proto.decreaseBuildTime = function decreaseBuildTime(time) {
          this._remainingBuildTime = Math.max(0, this._remainingBuildTime - time);
          return this._remainingBuildTime;
        }

        /**
         * 获取建造进度
         * @returns 进度值 (0-1)
         */;
        _proto.getBuildProgress = function getBuildProgress() {
          if (this._totalBuildTime <= 0) return 0;
          return Math.max(0, (this._totalBuildTime - this._remainingBuildTime) / this._totalBuildTime);
        }

        /**
         * 完成建造，执行升级
         */;
        _proto.completeBuilding = function completeBuilding() {
          this._remainingBuildTime = 0;
          this._totalBuildTime = 0;
        }

        /**
         * 等级改变时的回调
         */;
        _proto.onLevelChanged = function onLevelChanged(newLevel) {
          if (PlaceConfigMgr.inst.getBingYingLevelConfig(this.buildType, newLevel)) {
            this.updateMaxXLSlots();
          }
        }

        /**
         * 更新最大训练位置数
         */;
        _proto.updateMaxXLSlots = function updateMaxXLSlots() {
          if (this.level <= 0) {
            this._maxXLSlots = 0;
            return;
          }
          var maxSlots = PlaceConfigMgr.inst.getBingYingTrainMax(this.buildType, this.level);
          if (maxSlots === undefined) {
            this._maxXLSlots = 0;
            return;
          }
          this._maxXLSlots = maxSlots;
        }

        /**
         * 计算设备提供的训练时间减少
         */;
        _proto.calcXLTimeReduction = function calcXLTimeReduction() {
          if (!this.serverData || !this.serverData.shebeis) return 0;
          var reduction = 0;
          for (var _iterator = _createForOfIteratorHelperLoose(this.serverData.shebeis), _step; !(_step = _iterator()).done;) {
            var sb = _step.value;
            var cfg = PlaceConfigMgr.inst.getBingYingSheBeiConfig(sb.shebei_id, sb.shebei_level);
            if (cfg && cfg.xunliantime) {
              reduction += cfg.xunliantime;
            }
          }
          return reduction;
        }

        /**
         * 计算设备提供的食物消耗减少
         */;
        _proto.calcFoodCostReduction = function calcFoodCostReduction() {
          if (!this.serverData || !this.serverData.shebeis) return 0;
          var reduction = 0;
          for (var _iterator2 = _createForOfIteratorHelperLoose(this.serverData.shebeis), _step2; !(_step2 = _iterator2()).done;) {
            var sb = _step2.value;
            var cfg = PlaceConfigMgr.inst.getBingYingSheBeiConfig(sb.shebei_id, sb.shebei_level);
            if (cfg && cfg.food_cost) {
              reduction += cfg.food_cost;
            }
          }
          return reduction;
        }

        /**
         * 计算设备提供的额外训练位置
         */;
        _proto.calcExtraXLSlots = function calcExtraXLSlots() {
          if (!this.serverData || !this.serverData.shebeis) return 0;
          var extra = 0;
          for (var _iterator3 = _createForOfIteratorHelperLoose(this.serverData.shebeis), _step3; !(_step3 = _iterator3()).done;) {
            var sb = _step3.value;
            var cfg = PlaceConfigMgr.inst.getBingYingSheBeiConfig(sb.shebei_id, sb.shebei_level);
            if (cfg && cfg.xunlianmax) {
              extra += cfg.xunlianmax;
            }
          }
          return extra;
        }

        /**
         * 计算设备提供的训练奖励
         */;
        _proto.calcXLRewardBonus = function calcXLRewardBonus() {
          if (!this.serverData || !this.serverData.shebeis) return [];
          var rewards = [];
          for (var _iterator4 = _createForOfIteratorHelperLoose(this.serverData.shebeis), _step4; !(_step4 = _iterator4()).done;) {
            var sb = _step4.value;
            var cfg = PlaceConfigMgr.inst.getBingYingSheBeiConfig(sb.shebei_id, sb.shebei_level);
            if (cfg && cfg.xunlian_reward) {
              rewards.push.apply(rewards, cfg.xunlian_reward);
            }
          }
          return rewards;
        }

        /**
         * 获取预备兵数量（从服务器数据读取）
         */;
        /**
         * 获取当前可用训练槽数量
         */
        _proto.getAvailableXLSlots = function getAvailableXLSlots() {
          App.log.logBusiness("默认配置数量", "", this._maxXLSlots);
          App.log.logBusiness("额外的训练位置", "", this.calcExtraXLSlots());
          return this._maxXLSlots + this.calcExtraXLSlots();
        }

        /**
         * 获取最大可训练的士兵数量
         */;
        _proto.getMaxTrainCount = function getMaxTrainCount() {
          var maxSlotNum = this.getAvailableXLSlots();
          var trainCount = this.trainingCount;
          return maxSlotNum - trainCount;
        };
        _createClass(BingYingModel, [{
          key: "reserveCount",
          get: function get() {
            var _this$serverData;
            return ((_this$serverData = this.serverData) == null ? void 0 : _this$serverData.reserve_count) || 0;
          }

          /**
           * 获取训练中的士兵数量（从服务器数据读取）
           */
        }, {
          key: "trainingCount",
          get: function get() {
            var _this$serverData2;
            return ((_this$serverData2 = this.serverData) == null ? void 0 : _this$serverData2.train_count) || 0;
          }
        }]);
        return BingYingModel;
      }(BuildingModel));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BossAI.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MonsterAI.ts', './BattleDefine.ts', './GameConfig.ts', './SkillVO.ts', './BaseAi.ts'], function (exports) {
  var _inheritsLoose, cclegacy, _decorator, Vec3, MonsterAI, GameBattle, GameConfig, SkillType, AI_BEHAVIOR;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Vec3 = module.Vec3;
    }, function (module) {
      MonsterAI = module.MonsterAI;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      SkillType = module.SkillType;
    }, function (module) {
      AI_BEHAVIOR = module.AI_BEHAVIOR;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "e3beaJiGvBEToaOEIiD7QNO", "BossAI", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /**
       * BossAI 管理类
       */
      var BossAI = exports('BossAI', (_dec = ccclass("BossAI"), _dec(_class = /*#__PURE__*/function (_MonsterAI) {
        _inheritsLoose(BossAI, _MonsterAI);
        function BossAI() {
          return _MonsterAI.apply(this, arguments) || this;
        }
        var _proto = BossAI.prototype;
        _proto.onUpdate = function onUpdate(dt) {
          if (this.pursuitTime > 0) {
            this.pursuitTime -= dt;
            return;
          }
          if (this.stateLock) {
            return;
          }
          if (this.pause) {
            this.doDaiji();
            return;
          }
          var type = AI_BEHAVIOR.DAIJI;
          for (var i = this._behaviors.length; i--;) {
            var behavior = this._behaviors[i];
            var checkFunc = this._checkTypeFuncMap[behavior];
            if (checkFunc() && behavior >= this._curBehavior) {
              type = behavior;
              break;
            }
          }
          if (type !== this._curBehavior) {
            if (GameConfig.DebugInfo.showMonsterBehaviorLog) {
              console.log("curtype is ", this.testname[type]);
            }
            this._curBehavior = type;
          }
          this._doTypeFuncMap[type]();
        }

        /**
         * 释放技能
         * @returns
         */;
        _proto.doSkill = function doSkill() {
          // 测试用
          // return false;
          if (this._owner.state.isSkilling()) {
            //已经在放技能了
            return;
          }
          if (this._owner.state.type === GameBattle.ActionState.Dead || this._owner.state.type === GameBattle.ActionState.Skill) {
            return;
          }
          this.stateLock = true;
          var skill = this._owner.getUsableSkill();
          if (GameConfig.DebugInfo.showMonsterSkillLog) {
            console.log("怪物释放技能", skill.skillID);
          }
          if (skill.type === SkillType.YuHui) {
            skill.use();
          } else if (skill.checkUpdateUseTime()) {
            this.skillUseTime++;
          }
          this._owner.useSkill(skill);
          this._owner.exitMove();
          this.lastSkillId = skill.skillID;
          this._owner.state.setSkill(skill.arts_action, skill);
        }

        /**
         * 检测能否攻击
         */;
        _proto.checkAttack = function checkAttack() {
          // 测试用
          // return false;
          if (this._owner.state.isAttacking()) {
            return true;
          }
          if (this._owner.state.isSkilling()) {
            //已经在放技能了
            return false;
          }
          var ret = this._owner.checkAttack();
          return ret;
        }

        /**
         * 检测能否追击
         */;
        _proto.checkPursuit = function checkPursuit() {
          var target = this._owner.lockTargetCtrl.target;
          if (!target) return false;
          var distance = Vec3.distance(target.node.worldPosition, this._owner.node.worldPosition);

          // 判定条件 1大于最小索敌范围  2小于追击范围 3不能攻击 4 不在攻击动作中
          var ret = !this._owner.checkCanUseSkill() && !this._owner.state.isAttacking() && distance > this._owner.roleVO.pursuerange;
          // console.log('checkPursuit', ret, distance, lockrange[0], lockrange[1], !this._owner.checkAttack(), !this._owner.state.isAttacking())

          if (ret) {
            this.pursuitTime = 0.1;
          } else {
            this._owner.exitMove();
          }
          return ret;
        }

        /**
         * 检测脱战
         * @returns
         */;
        _proto.checkExitBattle = function checkExitBattle() {
          var target = this._owner.lockTargetCtrl.target;
          var homeDistance = this._owner.node.worldPosition.clone().subtract(this._homePoint).length();
          // if (homeDistance > this._homeDistance) { //不在锁敌范围里 脱战
          //     return true
          // }
          if (!target) {
            //没有目标， 又离开了出生地 脱战
            return true;
          }
          // if (target) {
          //有目标, 但超出了攻击范围 脱战
          // const targetDistance = target.node.worldPosition.clone().subtract(this._owner.node.worldPosition).length();
          // if (targetDistance > this._targetDistance) {
          //     return true;
          // }
          // }
          return false;
          // return false;
        };

        return BossAI;
      }(MonsterAI)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BroadcastMgr.ts", ['cc', './App.ts', './uiBroadcast.ts', './DBRecord.ts', './UtilGame.ts', './Utils.ts', './UIMgr.ts', './GameStateMgr.ts'], function (exports) {
  var cclegacy, App, uiBroadcast, DBRecord, UtilGame, Utils, UIMgr, LayerType, GameState;
  return {
    setters: [function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      App = module.App;
    }, function (module) {
      uiBroadcast = module.uiBroadcast;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      UtilGame = module.UtilGame;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      UIMgr = module.UIMgr;
      LayerType = module.LayerType;
    }, function (module) {
      GameState = module.GameState;
    }],
    execute: function () {
      cclegacy._RF.push({}, "343979MqGRPQYGUiQ032uJk", "BroadcastMgr", undefined);
      var BroadcastMgr = exports('BroadcastMgr', /*#__PURE__*/function () {
        function BroadcastMgr() {
          /** 游戏内部 */
          this.gameMsgList = [];
          /** 后台广播 */
          this.backMsgList = [];
          this.isPlaying = false;
        }
        var _proto = BroadcastMgr.prototype;
        _proto.init = function init() {
          // App.monitorMgr.addEventListener(MonitorType.web_broadcast_106002, this.sc_web_broadcast_106002, this);
          this.resetData();
        };
        _proto.dispose = function dispose() {
          App.monitorMgr.offTarget(this);
          this.resetData();
        };
        _proto.resetData = function resetData() {
          this.gameMsgList = [];
          this.backMsgList = [];
          this.isPlaying = false;
        };
        _proto.sc_web_broadcast_106002 = function sc_web_broadcast_106002(data) {
          var msg = "";
          if (data.type === 1) {
            //  类型1-游戏内部 2-后台广播
            if (Utils) msg = this.dealMsg(data);
            if (msg) {
              this.gameMsgList.push(msg);
              if (App.gameStateMgr.state === GameState.City) {
                this.show();
              }
            }
          } else if (data.type === 3) {
            msg = this.dealMsg(data);
            if (msg) {
              for (var i = 0; i < 5; i++) {
                this.backMsgList.unshift(msg);
              }
              if (App.gameStateMgr.state === GameState.City) {
                this.show();
              }
            }
          } else {
            //系统公告 需要优先播放
            msg = data.msg;
            this.backMsgList.push(msg);
            this.show();
          }
        };
        _proto.dealMsg = function dealMsg(data) {
          if ([5406, 5407, 5408].indexOf(data.template_id) !== -1) ;
          var str = App.languageMgr.getTextById(data.template_id);
          if (str.length > 0) {
            if (data.item_list.length === 0) {
              return str;
            }
            var roleName = "<color=#65baf1>" + data.params[0] + "</color>";
            var id = data.item_list[0].item_id;
            var count = data.item_list[0].item_count;
            var cfg = DBRecord.fetchId("DaoJu", id);
            var name = App.languageMgr.getTextById(cfg.name);
            var color = Utils.getQualityColor(cfg.rarity);
            var hex = color.toHEX();
            var itemStr = "<color=" + hex + ">" + (name + "×" + count) + "<color>";
            console.log(hex);
            var msg = UtilGame.formateStr(str, roleName, itemStr);
            console.log(msg);
            return msg;
          }
          return null;
        };
        _proto.show = function show() {
          if (!this.isPlaying) {
            this.isPlaying = true;
            UIMgr.inst.openOnce(uiBroadcast, LayerType.touchTip);
          }
        };
        return BroadcastMgr;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuBingYing.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BuildingBase.ts', './PlaceGameEnum.ts', './BingYingModel.ts', './PlaceGameMgr.ts', './PlaceConfigMgr.ts', './App.ts', './MovingSoldierNPC.ts', './MonitorType.ts', './EventType.ts', './TrainingMgr.ts', './Utils.ts', './ActionFramesItem.ts', './ModuleDef.ts', './DBRecord.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createForOfIteratorHelperLoose, _createClass, cclegacy, _decorator, Node, ProgressBar, Label, Prefab, Vec3, BuildingBase, SoldierType, BuildingType, BuildingStatus, BingYingModel, PlaceGameMgr, PlaceConfigMgr, App, MovingSoldierNPC, MonitorType, EventType, TrainingMgr, Utils, ActionFramesItem, ModuleDef, DBRecord;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Node = module.Node;
      ProgressBar = module.ProgressBar;
      Label = module.Label;
      Prefab = module.Prefab;
      Vec3 = module.Vec3;
    }, function (module) {
      BuildingBase = module.BuildingBase;
    }, function (module) {
      SoldierType = module.SoldierType;
      BuildingType = module.BuildingType;
      BuildingStatus = module.BuildingStatus;
    }, function (module) {
      BingYingModel = module.BingYingModel;
    }, function (module) {
      PlaceGameMgr = module.PlaceGameMgr;
    }, function (module) {
      PlaceConfigMgr = module.PlaceConfigMgr;
    }, function (module) {
      App = module.App;
    }, function (module) {
      MovingSoldierNPC = module.MovingSoldierNPC;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      EventType = module.EventType;
    }, function (module) {
      TrainingMgr = module.TrainingMgr;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      ActionFramesItem = module.ActionFramesItem;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      DBRecord = module.default;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _dec11, _dec12, _dec13, _dec14, _dec15, _dec16, _dec17, _dec18, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9, _descriptor10, _descriptor11, _descriptor12, _descriptor13, _descriptor14, _descriptor15, _descriptor16, _descriptor17;
      cclegacy._RF.push({}, "a35b1VT+/xONIeaUB+RVlWz", "BuBingYing", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /**
       * 步兵营建筑类
       */
      var BuBingYing = exports('BuBingYing', (_dec = ccclass("BuBingYing"), _dec2 = property(Node), _dec3 = property(Node), _dec4 = property({
        type: ProgressBar,
        displayName: "建造进度条",
        tooltip: "建造进度条"
      }), _dec5 = property({
        type: Label,
        displayName: "建造时间",
        tooltip: "建造时间"
      }), _dec6 = property(Node), _dec7 = property({
        type: ActionFramesItem,
        displayName: "英雄模型",
        tooltip: "英雄模型"
      }), _dec8 = property({
        type: Node,
        displayName: "可升级图标",
        tooltip: "可升级图标"
      }), _dec9 = property({
        type: ProgressBar,
        displayName: "升级进度条",
        tooltip: "升级进度条"
      }), _dec10 = property({
        type: Label,
        displayName: "升级时间",
        tooltip: "升级时间"
      }), _dec11 = property({
        type: Node,
        displayName: "进入路线",
        tooltip: "NPC进入步兵营路线规划"
      }), _dec12 = property({
        type: Node,
        displayName: "出门路线",
        tooltip: "NPC离开步兵营到指挥部路线规划"
      }), _dec13 = property(Node), _dec14 = property(Label), _dec15 = property(Node), _dec16 = property(Node), _dec17 = property(Prefab), _dec18 = property(Vec3), _dec(_class = (_class2 = /*#__PURE__*/function (_BuildingBase) {
        _inheritsLoose(BuBingYing, _BuildingBase);
        function BuBingYing() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _BuildingBase.call.apply(_BuildingBase, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "lockNode", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "jiaImg", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "buildProgress", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "buildTimeLab", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "unLockNode", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "heroAni", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "lvUpImg", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "upgradeProgressBar", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "timeLab", _descriptor9, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "inLine", _descriptor10, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "outLine", _descriptor11, _assertThisInitialized(_this));
          /**
           * 训练中的NPC父容器节点
           */
          _initializerDefineProperty(_this, "trainingNPCParent", _descriptor12, _assertThisInitialized(_this));
          /**
           * 预备兵数量显示节点
           */
          _initializerDefineProperty(_this, "reserveCountLab", _descriptor13, _assertThisInitialized(_this));
          /**
           * 兵营按钮组合
           */
          _initializerDefineProperty(_this, "btnNode", _descriptor14, _assertThisInitialized(_this));
          /**
           * 所有设备节点父容器
           */
          _initializerDefineProperty(_this, "xlShebeiParent", _descriptor15, _assertThisInitialized(_this));
          /**
           * 移动士兵NPC预制体
           */
          _initializerDefineProperty(_this, "movingSoldierPrefab", _descriptor16, _assertThisInitialized(_this));
          /**
           * NPC到达兵营的目标位置
           */
          _initializerDefineProperty(_this, "npcArrivePos", _descriptor17, _assertThisInitialized(_this));
          /**
           * 数据模型
           */
          _this._dataModel = null;
          /**
           * 训练定时器
           */
          _this._xlTimer = null;
          /**
           * 建造定时器
           */
          _this._buildTimer = null;
          /**
           * 升级定时器
           */
          _this._upgradeTimer = null;
          /**
           * 训练设备管理器
           */
          _this.trainingMgr = null;
          /**
           * 当前移动中的NPC列表
           */
          _this._movingNPCs = [];
          /**
           * 预备役NPC创建定时器ID列表
           */
          _this._reserveNPCTimers = [];
          /**
           * 前端记录的训练完成数量
           */
          _this._frontendReserveCount = 0;
          /**
           * 总训练数量（本次训练）
           */
          _this._totalTrainingCount = 0;
          /**
           * 每个NPC的训练时长
           */
          _this._trainingDuration = 0;
          /**
           * 转向对应关系
           */
          _this.inFaceMap = new Map([[1, 1], [2, 1], [3, 2], [4, 2]]);
          /**
           * 出门路线对应关系
           */
          _this.outFaceMap = new Map([[1, 2], [2, 2], [3, 1], [4, 1], [5, 2], [6, 2], [8, 2], [9, 2]]);
          _this.poolName = "MovingSoldierNPC_BB";
          return _this;
        }
        var _proto = BuBingYing.prototype;
        /**
         * 组件启用时的初始化
         */
        _proto.onLoad = function onLoad() {
          this.init();
          this.addEventListener();
          this.initTrainingMgr();

          // 初始化对象池
          if (this.movingSoldierPrefab) {
            App.nodePoolMgr.createPool(this.poolName, this.movingSoldierPrefab, {
              preloadCount: 10,
              maxSize: 20,
              autoExpand: true
            });
          }
        }

        /**
         * 初始化训练设备管理器
         */;
        _proto.initTrainingMgr = function initTrainingMgr() {
          var _this2 = this;
          this.trainingMgr = new TrainingMgr();
          this.trainingMgr.initialize(this.xlShebeiParent, this.trainingNPCParent, SoldierType.BuBing, BuildingType.BuBingYing, function (npcId) {
            return _this2.onSingleTrainingComplete(npcId);
          });
        }

        /**
         * 添加事件监听
         */;
        _proto.addEventListener = function addEventListener() {
          App.monitorMgr.addEventListener(MonitorType.CMD_ResUpgradeBuilding, this.resUpgradeBuilding, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResBuild, this.resBuild, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResBuildingUpgradeFinish, this.resBuildingUpgradeFinish, this);
          App.monitorMgr.addEventListener(EventType.BuildingUpdated, this.onBuildingUpdated, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResTrain, this.resTrain, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResTrainFinish, this.resTrainFinish, this);
          App.monitorMgr.addEventListener(MonitorType.CMD_ResDiamondUpgrade, this.resDiamondUpgrade, this);
          App.monitorMgr.addEventListener(EventType.BuildingBtnClick, this.buildingBtnClick, this);
          App.monitorMgr.addEventListener(EventType.Close_Build_XunLianBtns, this.closeBuildXunLianBtns, this);
          App.monitorMgr.addEventListener(EventType.ui_open, this.closeBuildXunLianBtns, this);
          App.monitorMgr.addEventListener(EventType.bag_update_list, this.updateLevUpImg, this);
        };
        _proto.onDestroy = function onDestroy() {
          App.monitorMgr.offTarget(this);
          this.stopBuildTimer();
          this.stopUpgradeTimer();
          this.stopXLTimer();
          this.clearReserveNPCTimers();
          this.unscheduleAllCallbacks();
          for (var _iterator = _createForOfIteratorHelperLoose(this._movingNPCs), _step; !(_step = _iterator()).done;) {
            var npc = _step.value;
            if (npc && npc.node && npc.node.isValid) {
              npc.stopAndDestroy(this.poolName);
            }
          }
          this._movingNPCs = [];
          if (this.trainingMgr) {
            this.trainingMgr.destroy();
            this.trainingMgr = null;
          }
        }

        /**
         * 升级协议监听
         */;
        _proto.resUpgradeBuilding = function resUpgradeBuilding(msg) {
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this.startUpgradeTimer();
        };
        _proto.resBuild = function resBuild(msg) {
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this.updateView();
        }

        /**
         * 协议升级完成监听
         */;
        _proto.resBuildingUpgradeFinish = function resBuildingUpgradeFinish(msg) {
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this.stopUpgradeTimer();
          this.onLevelChanged();
          this.updateView();
        }

        /**
         * 钻石升级监听
         */;
        _proto.resDiamondUpgrade = function resDiamondUpgrade(msg) {
          if (msg.code !== 200) {
            return;
          }
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this.stopUpgradeTimer();
          this.onLevelChanged();
          this.updateView();
        }

        /**
         * 训练协议响应
         */;
        _proto.resTrain = function resTrain(msg) {
          if (msg.code !== 200) {
            return;
          }
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this._totalTrainingCount = msg.train_count;
          this._trainingDuration = msg.training_duration;
          App.log.logBusiness("\u670D\u52A1\u5668\u8FD4\u56DE \u6B65\u5175\u8425\u8BAD\u7EC3\u5F00\u59CB - \u65B0\u589E\u6570\u91CF: " + msg.count + ", \u7D2F\u8BA1\u603B\u6570: " + this._totalTrainingCount + ", \u65F6\u957F: " + msg.training_duration + "\u6BEB\u79D2");
          this.createMovingNPCs(msg.count, this._trainingDuration);
          this.startXLTimer();
          this.updateView();
        }

        /**
         * 从路径节点中获取路径点数组
         * @param pathNode 路径节点，包含多个point子节点
         * @param npcLayer NPC父容器节点
         * @returns 路径点数组（世界坐标转换为父容器本地坐标）
         */;
        _proto.getPathPoints = function getPathPoints(pathNode, npcLayer) {
          var pathPoints = [];
          if (!pathNode) {
            return pathPoints;
          }

          // 获取所有子节点，按名称排序（point1, point2, ...）
          var pointNodes = pathNode.children.sort(function (a, b) {
            var aNum = parseInt(a.name.replace("point", "")) || 0;
            var bNum = parseInt(b.name.replace("point", "")) || 0;
            return aNum - bNum;
          });

          // 转换路径点为世界坐标
          for (var _iterator2 = _createForOfIteratorHelperLoose(pointNodes), _step2; !(_step2 = _iterator2()).done;) {
            var pointNode = _step2.value;
            var worldPos = pointNode.getWorldPosition();
            var localPos = npcLayer.inverseTransformPoint(new Vec3(), worldPos);
            pathPoints.push(localPos);
          }
          return pathPoints;
        }

        /**
         * 创建移动中的士兵NPC
         * @param count 士兵数量
         * @param trainingDuration 训练时长
         */;
        _proto.createMovingNPCs = function createMovingNPCs(count, trainingDuration) {
          var _this3 = this;
          if (!this.movingSoldierPrefab) {
            App.log.logError("步兵营：移动NPC预制体未设置");
            return;
          }
          var npcLayer = PlaceGameMgr.inst.getRoleLayer();
          if (!npcLayer) {
            App.log.logError("获取不到NPC容器");
            return;
          }
          var pathPoints = this.getPathPoints(this.inLine, npcLayer);
          var startPos = pathPoints[0];
          for (var i = 0; i < count; i++) {
            (function (npcId) {
              _this3.scheduleOnce(function () {
                var npcNode = App.nodePoolMgr.getNode(_this3.poolName);
                if (!npcNode) {
                  App.log.logError("\u521B\u5EFA\u79FB\u52A8NPC\u5931\u8D25: " + npcId);
                  return;
                }
                npcLayer.addChild(npcNode);
                npcNode.setPosition(startPos);
                var movingNPC = npcNode.getComponent(MovingSoldierNPC);
                if (!movingNPC) {
                  App.nodePoolMgr.putNode(_this3.poolName, npcNode);
                  return;
                }
                var faceDirection = _this3.inFaceMap.get(1) || 1;
                movingNPC.setFaceDirection(faceDirection);
                _this3._movingNPCs.push(movingNPC);

                // 开始沿路径点移动
                var resourceConfig = {
                  module: ModuleDef.NPC,
                  name: "npc_xiaoji",
                  action: "Move"
                };
                movingNPC.startMoveAlongPath(pathPoints, function (id, npc) {
                  _this3.onNPCArriveCallFunc(id, npc, trainingDuration);
                }, npcId, _this3.inFaceMap, resourceConfig);
              }, npcId * 0.5);
            })(i);
          }
        }

        /**
         * 创建模型移动到指挥部
         * @param count
         * @returns
         */;
        _proto.createMovingNPCsFromReserve = function createMovingNPCsFromReserve(count) {
          var _this4 = this;
          if (!this.movingSoldierPrefab) {
            App.log.logError("步兵营：移动NPC预制体未设置");
            return;
          }
          this.clearReserveNPCTimers();
          var npcLayer = PlaceGameMgr.inst.getRoleLayer();
          if (!npcLayer) {
            App.log.logError("获取不到NPC容器");
            return;
          }
          var pathPoints = this.getPathPoints(this.outLine, npcLayer);
          for (var i = 0; i < count; i++) {
            (function (npcId) {
              var timerId = _this4.scheduleOnce(function () {
                var npcNode = App.nodePoolMgr.getNode(_this4.poolName);
                if (!npcNode) {
                  App.log.logError("\u521B\u5EFA\u79FB\u52A8NPC\u5931\u8D25: " + npcId);
                  return;
                }
                npcLayer.addChild(npcNode);
                var startWorldPos = _this4.node.getWorldPosition();
                var localStartPos = npcLayer.inverseTransformPoint(new Vec3(), startWorldPos);
                npcNode.setPosition(localStartPos);
                var movingNPC = npcNode.getComponent(MovingSoldierNPC);
                if (!movingNPC) {
                  App.nodePoolMgr.putNode(_this4.poolName, npcNode);
                  return;
                }

                // 设置NPC朝向
                var faceDirection = _this4.outFaceMap.get(1) || 1;
                movingNPC.setFaceDirection(faceDirection);
                _this4._movingNPCs.push(movingNPC);

                // 开始沿路径点移动
                var resourceConfig = {
                  module: ModuleDef.SOLDIER,
                  name: "daodunbing",
                  action: "Move"
                };
                movingNPC.startMoveAlongPath(pathPoints, function (id, npc) {
                  App.log.logBusiness("\u9884\u5907\u5F79NPC " + id + " \u5230\u8FBE\u76EE\u7684\u5730");
                  var index = _this4._movingNPCs.indexOf(npc);
                  if (index !== -1) {
                    _this4._movingNPCs.splice(index, 1);
                  }
                  npc.stopAndDestroy(_this4.poolName);
                }, npcId, _this4.outFaceMap, resourceConfig);
              }, npcId * 0.7);
              _this4._reserveNPCTimers.push(timerId);
            })(i);
          }
        }

        /**
         * NPC到达兵营回调（第一阶段）
         * @param npcId NPC ID
         * @param npc NPC组件
         * @param trainingDuration 训练时长
         */;
        _proto.onNPCArriveCallFunc = function onNPCArriveCallFunc(npcId, npc, trainingDuration) {
          App.log.logBusiness("\u6B65\u5175\u8425: NPC " + npcId + " \u5230\u8FBE\u5175\u8425\uFF0C\u68C0\u67E5\u7A7A\u95F2\u8BBE\u5907");
          if (!this.trainingMgr) {
            var index = this._movingNPCs.indexOf(npc);
            if (index !== -1) {
              this._movingNPCs.splice(index, 1);
            }
            npc.stopAndDestroy(this.poolName);
            return;
          }
          var trainingNPCNode = this.trainingMgr.getFreeEquipmentNode();
          if (trainingNPCNode) {
            App.log.logBusiness("\u6B65\u5175\u8425: NPC " + npcId + " \u83B7\u53D6\u5230\u7A7A\u95F2\u8BBE\u5907\uFF08\u5DF2\u9884\u5360\u7528\uFF09\uFF0C\u7EE7\u7EED\u79FB\u52A8\u5230\u8BBE\u5907\u4F4D\u7F6E");
            this.moveToEquipment(npc, npcId, trainingNPCNode, trainingDuration);
          } else {
            App.log.logBusiness("\u6B65\u5175\u8425: NPC " + npcId + " \u65E0\u7A7A\u95F2\u8BBE\u5907\uFF0C\u76F4\u63A5\u9500\u6BC1");
            // 没有空闲设备，直接销毁
            var _index = this._movingNPCs.indexOf(npc);
            if (_index !== -1) {
              this._movingNPCs.splice(_index, 1);
            }
            npc.stopAndDestroy(this.poolName);
          }
        }

        /**
         * NPC移动到训练设备（第二阶段）
         * @param npc NPC组件
         * @param npcId NPC ID
         * @param trainingNPCNode 目标设备的TrainingNPC节点
         * @param trainingDuration 训练时长
         */;
        _proto.moveToEquipment = function moveToEquipment(npc, npcId, trainingNPCNode, trainingDuration) {
          var _this5 = this;
          var npcLayer = PlaceGameMgr.inst.getRoleLayer();
          if (!npcLayer) {
            App.log.logError("获取不到NPC容器");
            npc.stopAndDestroy(this.poolName);
            return;
          }
          var targetWorldPos = trainingNPCNode.getWorldPosition();
          var localTargetPos = npcLayer.inverseTransformPoint(new Vec3(), targetWorldPos);
          var resourceConfig = {
            module: ModuleDef.NPC,
            name: "npc_xiaoji",
            action: "Move"
          };
          npc.startMoveTo(localTargetPos, function (id, npcObj) {
            _this5.onNPCArriveEquipment(id, npcObj, trainingNPCNode, trainingDuration);
          }, npcId, resourceConfig);
        }

        /**
         * NPC到达训练设备回调（第二阶段）
         * @param npcId NPC ID
         * @param npc NPC组件
         * @param trainingNPCNode 目标设备的TrainingNPC节点
         * @param trainingDuration 训练时长
         */;
        _proto.onNPCArriveEquipment = function onNPCArriveEquipment(npcId, npc, trainingNPCNode, trainingDuration) {
          App.log.logBusiness("\u6B65\u5175\u8425: NPC " + npcId + " \u5230\u8FBE\u8BAD\u7EC3\u8BBE\u5907\u4F4D\u7F6E");
          var index = this._movingNPCs.indexOf(npc);
          if (index !== -1) {
            this._movingNPCs.splice(index, 1);
          }
          npc.stopAndDestroy(this.poolName);
          if (!this.trainingMgr) {
            App.log.logError("\u6B65\u5175\u8425: trainingMgr\u4E0D\u5B58\u5728\uFF0C\u65E0\u6CD5\u5F00\u59CB\u8BAD\u7EC3");
            return;
          }
          var started = this.trainingMgr.occupyEquipmentByNode(trainingNPCNode, npcId, trainingDuration);
          if (started) {
            App.log.logBusiness("\u6B65\u5175\u8425: NPC " + npcId + " \u5F00\u59CB\u5728\u8BBE\u5907\u4E0A\u8BAD\u7EC3");
          } else {
            App.log.logError("\u6B65\u5175\u8425: NPC " + npcId + " \u65E0\u6CD5\u5F00\u59CB\u8BAD\u7EC3\uFF0C\u8BBE\u5907\u72B6\u6001\u5F02\u5E38");
          }
        }

        /**
         * 单个训练完成回调（由设备管理器调用）
         * 这是停止训练定时器的统一出口
         * @param npcId 完成训练的NPC ID
         */;
        _proto.onSingleTrainingComplete = function onSingleTrainingComplete(npcId) {
          App.log.logBusiness("NPC " + npcId + " \u5B8C\u6210\u8BAD\u7EC3");
          this.playTrainingCompleteAnimation(npcId);
          this._frontendReserveCount++;
          App.log.logBusiness("\u8BAD\u7EC3\u8FDB\u5EA6: " + this._frontendReserveCount + "/" + this._totalTrainingCount);
          if (this._frontendReserveCount >= this._totalTrainingCount) {
            App.log.logBusiness("\u6240\u6709NPC\u90FD\u5B8C\u6210\u4E86\u8BAD\u7EC3\uFF0C\u524D\u7AEF\u8BB0\u5F55: " + this._frontendReserveCount + "/" + this._totalTrainingCount);
            this.stopXLTimer();
            this._frontendReserveCount = 0;
            this._totalTrainingCount = 0;
          }
        }

        /**
         * 播放训练完成动画
         * @param npcId NPC ID
         */;
        _proto.playTrainingCompleteAnimation = function playTrainingCompleteAnimation(npcId) {
          if (!this.movingSoldierPrefab) {
            return;
          }
          // 移除移动 直接消失即可
        }

        /**
         * 训练完成协议响应
         */;
        _proto.resTrainFinish = function resTrainFinish(msg) {
          if (msg.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          if (this._dataModel.serverData) {
            this._dataModel.serverData.reserve_count = msg.reserve_count;
            this._dataModel.serverData.train_count = msg.train_count;
          }
          this.updateReserveCount();
          App.log.logBusiness("\u540E\u7AEF\u6B65\u5175\u8425\u8BAD\u7EC3\u5B8C\u6210 - \u9884\u5907\u5F79: " + msg.reserve_count + ", \u8BAD\u7EC3\u4E2D: " + msg.train_count + ", \u524D\u7AEF\u8BB0\u5F55: " + this._frontendReserveCount + "/" + this._totalTrainingCount);
        }

        /**
         * 当建筑数据更新时调用
         */;
        _proto.onBuildingUpdated = function onBuildingUpdated(data) {
          if (data.building_uid !== this._dataModel.buildingUid) {
            return;
          }
          this.updateView();
        }

        /**
         * 启动建造倒计时
         */;
        _proto.startBuildTimer = function startBuildTimer() {
          var _this6 = this;
          if (this.dataModel.status !== BuildingStatus.BUILDING) {
            this.buildProgress.node.active = false;
            return;
          }
          if (this._buildTimer) {
            return;
          }
          var nextLevel = this.dataModel.level + 1;
          if (nextLevel > PlaceConfigMgr.inst.getMaxLevelByType(this.dataModel.buildType)) {
            App.log.logError("出错 还没解锁");
            return;
          }
          var remainTime = this.dataModel.serverData.upgrade_duration / 1000 || 0;
          var totalTime = PlaceConfigMgr.inst.getBuildingUpgradeTime(this.dataModel.buildType, nextLevel);
          this.dataModel.startBuildingUpgrade(remainTime, totalTime);
          this.buildProgress.node.active = true;
          this.jiaImg.active = false;
          this.buildProgress.progress = this.dataModel.getBuildProgress();
          if (this.buildTimeLab) {
            this.buildTimeLab.string = Utils.timeFormat(this.dataModel.getRemainBuildTime());
          }
          this._buildTimer = setInterval(function () {
            _this6.onBuildTimerUpdate();
          }, 1000);
        }

        /**
         * 停止建造倒计时
         */;
        _proto.stopBuildTimer = function stopBuildTimer() {
          this.dataModel.completeBuilding();
          if (this.buildProgress.node) {
            this.buildProgress.node.active = false;
          }
          if (this._buildTimer) {
            clearInterval(this._buildTimer);
            this._buildTimer = null;
          }
        }

        /**
         * 建造更新
         */;
        _proto.onBuildTimerUpdate = function onBuildTimerUpdate() {
          if (!this.node.isValid) return;
          if (this.dataModel.getRemainBuildTime() > 0) {
            this.dataModel.decreaseBuildTime(1);
            this.buildProgress.progress = this.dataModel.getBuildProgress();
            if (this.buildTimeLab) {
              this.buildTimeLab.string = Utils.timeFormat(this.dataModel.getRemainBuildTime());
            }
          } else {
            this.stopBuildTimer();
          }
        }

        /**
         * 启动升级倒计时
         */;
        _proto.startUpgradeTimer = function startUpgradeTimer() {
          var _this7 = this;
          if (!this.dataModel.isUpgrading) {
            this.upgradeProgressBar.node.active = false;
            return;
          }
          var nextLevel = this.dataModel.level + 1;
          if (nextLevel > PlaceConfigMgr.inst.getMaxLevelByType(this.dataModel.buildType)) {
            App.log.logError("步兵营建筑已经达到最高级");
            return;
          }
          var remainTime = this.dataModel.serverData.upgrade_duration / 1000 || 0;
          if (remainTime <= 0) {
            this.stopUpgradeTimer();
            this.upgradeProgressBar.node.active = false;
            return;
          }
          if (this._upgradeTimer && Math.abs(this.dataModel.getRemainBuildTime() - remainTime) < 0.5) {
            return;
          }
          this.stopUpgradeTimer();
          var totalTime = PlaceConfigMgr.inst.getBuildingUpgradeTime(this.dataModel.buildType, nextLevel);
          this.upgradeProgressBar.node.active = true;
          this.dataModel.startBuildingUpgrade(remainTime, totalTime);
          this.onUpgradeTimerUpdate();
          this._upgradeTimer = setInterval(function () {
            _this7.onUpgradeTimerUpdate();
          }, 1000);
        };
        _proto.stopUpgradeTimer = function stopUpgradeTimer() {
          this.dataModel.completeBuilding();
          if (this.upgradeProgressBar.node) {
            this.upgradeProgressBar.node.active = false;
          }
          if (this._upgradeTimer) {
            clearInterval(this._upgradeTimer);
            this._upgradeTimer = null;
          }
        }

        /**
         * 升级计时器更新回调
         */;
        _proto.onUpgradeTimerUpdate = function onUpgradeTimerUpdate() {
          if (!this.node.isValid) return;
          if (this.dataModel.getRemainBuildTime() > 0) {
            this.dataModel.decreaseBuildTime(1);
            this.upgradeProgressBar.progress = this.dataModel.getBuildProgress();
            this.timeLab.string = Utils.timeFormat(this.dataModel.getRemainBuildTime());
          } else {
            this.stopUpgradeTimer();
          }
        }

        /**
         * 开始训练定时器
         */;
        _proto.startXLTimer = function startXLTimer() {
          var _this8 = this;
          if (this._xlTimer) {
            App.log.logBusiness("\u6B65\u5175\u8425[" + this._dataModel.buildingUid + "] \u8BAD\u7EC3\u5B9A\u65F6\u5668\u5DF2\u5B58\u5728\uFF0C\u65E0\u9700\u91CD\u590D\u542F\u52A8");
            return;
          }
          App.log.logBusiness("\u6B65\u5175\u8425[" + this._dataModel.buildingUid + "] \u542F\u52A8\u8BAD\u7EC3\u5B9A\u65F6\u5668\uFF0C\u95F4\u9694100ms");
          this._xlTimer = setInterval(function () {
            _this8.updateXLProgress();
          }, 100);
        }

        /**
         * 停止训练定时器
         */;
        _proto.stopXLTimer = function stopXLTimer() {
          if (this._xlTimer) {
            App.log.logBusiness("\u6B65\u5175\u8425[" + this._dataModel.buildingUid + "] \u505C\u6B62\u8BAD\u7EC3\u5B9A\u65F6\u5668");
            clearInterval(this._xlTimer);
            this._xlTimer = null;
          }
        }

        /**
         * 更新训练进度
         */;
        _proto.updateXLProgress = function updateXLProgress() {
          if (!this.trainingMgr) return;
          this.trainingMgr.updateProgress(100);
          this.updateReserveCount();
        };
        _proto.closeBuildXunLianBtns = function closeBuildXunLianBtns() {
          this.btnNode.active = false;
        }

        /**
         * 更新视图显示
         */;
        _proto.updateView = function updateView() {
          if (!this._dataModel) return;
          this.btnNode.active = false;
          if (this.dataModel.status === BuildingStatus.LOCK) {
            this.lockNode.active = true;
            this.unLockNode.active = false;
            this.buildProgress.node.active = false;
            this.jiaImg.active = true;
            return;
          } else if (this.dataModel.status === BuildingStatus.BUILDING) {
            this.lockNode.active = true;
            this.unLockNode.active = false;
            this.jiaImg.active = false;
            this.startBuildTimer();
            return;
          } else {
            this.lockNode.active = false;
            this.unLockNode.active = true;
          }
          this.updateReserveCount();
          this.updateBuildImg();
          this.updateLevUpImg();
          if (this.dataModel.isUpgrading) {
            this.startUpgradeTimer();
          } else {
            this.upgradeProgressBar.node.active = false;
          }
          if (this.dataModel.serverData.entry_hero > 0) {
            this.heroAni.node.active = true;
            var heroCfg = DBRecord.fetchId("Hero", this.dataModel.serverData.entry_hero);
            if (heroCfg) {
              this.heroAni.playWithResource(ModuleDef.HERO, heroCfg.res, "Idle");
            }
          } else {
            this.heroAni.node.active = false;
          }
        }

        /**
         * 更新可升级图片显示
         * @returns
         */;
        _proto.updateLevUpImg = function updateLevUpImg() {
          if (!this.lvUpImg || !this._dataModel) return;
          var curLevel = this.dataModel.level;
          var targetLevel = curLevel + 1;
          var maxLevel = PlaceConfigMgr.inst.getMaxLevelByType(this.dataModel.buildType);
          if (curLevel >= maxLevel) {
            targetLevel = maxLevel;
          } else {
            targetLevel = curLevel + 1;
          }
          var flag = PlaceGameMgr.inst.checkBuildCondition(this.dataModel.buildType, targetLevel);
          this.lvUpImg.active = flag;
        }

        /**
         * 更新预备役士兵数量显示
         * 只显示服务器数据
         */;
        _proto.updateReserveCount = function updateReserveCount() {
          if (!this.reserveCountLab || !this._dataModel) return;
          this.reserveCountLab.string = "" + (this._dataModel.reserveCount || 0);
        }

        /**
         * 建筑点击后的处理逻辑
         */;
        _proto.onBuildingClick = function onBuildingClick() {
          if (this.btnNode.active) {
            this.btnNode.active = false;
            return;
          }
          this.btnNode.active = false;
          if (this.dataModel.status === BuildingStatus.LOCK) {
            PlaceGameMgr.inst.showUnLockView(this.dataModel.buildType, this.dataModel.buildIndex);
          } else if (this.dataModel.status === BuildingStatus.BUILDING) {
            PlaceGameMgr.inst.showSpeedUpView(this.dataModel.buildType, this.dataModel.buildIndex);
          } else {
            this.btnNode.active = true;
            App.monitorMgr.dispatchEvent(EventType.BuildingBtnClick, this.dataModel.buildingUid);
          }
        };
        _proto.buildingBtnClick = function buildingBtnClick(buildingUid) {
          if (!this.dataModel) return;
          if (this.dataModel.buildingUid === buildingUid) {
            return;
          }
          this.btnNode.active = false;
        }

        /**
         * 升级按钮点击
         */;
        _proto.onBtnUpgradeClick = function onBtnUpgradeClick() {
          this.btnNode.active = false;
          if (this.dataModel.status === BuildingStatus.LOCK || this.dataModel.status === BuildingStatus.BUILDING) {
            return;
          }
          if (this.dataModel.isUpgrading) {
            PlaceGameMgr.inst.showBuildUpgradeView(this.dataModel.buildingUid, this.dataModel.buildType, this.dataModel.buildIndex);
          } else {
            PlaceGameMgr.inst.showSheBeiUpgradeView(this.dataModel.buildingUid, this.dataModel.buildType, this.dataModel.buildIndex);
          }
        }

        /**
         * 训练按钮点击
         */;
        _proto.onBtnXunLianClick = function onBtnXunLianClick() {
          this.btnNode.active = false;
          if (this.dataModel.status === BuildingStatus.LOCK || this.dataModel.status === BuildingStatus.BUILDING) {
            return;
          }
          PlaceGameMgr.inst.showTrainingView(this.dataModel.buildingUid, this.dataModel.buildType, this.dataModel.buildIndex);
        }

        /**
         * 领取预备役士兵
         * @returns 领取预备役士兵
         */;
        _proto.onCangKuClick = function onCangKuClick() {
          var reserveCount = this._dataModel.reserveCount || 0;
          if (reserveCount <= 0) {
            App.log.logBusiness("没有预备役士兵可以领取");
            return;
          }
          this.createMovingNPCsFromReserve(reserveCount);
          PlaceGameMgr.inst.reqGetReserve(this.dataModel.buildingUid, this.dataModel.buildType);
        };
        _proto.clearReserveNPCTimers = function clearReserveNPCTimers() {
          var _this9 = this;
          this._reserveNPCTimers.forEach(function (timerId) {
            _this9.unschedule(timerId);
          });
          this._reserveNPCTimers = [];
        }

        //==============================子类方法重载=======================================
        /**
         * 初始化数据模型
         */;
        _proto.initDataModel = function initDataModel(data) {
          App.log.logBusiness("\u6B65\u5175\u8425: \u521D\u59CB\u5316\u6570\u636E\u6A21\u578B - \u5E8F\u5217\u53F7: " + this.buildIndex);
          var buildingUid = data ? data.building_uid || 0 : 0;
          var buildingType = BuildingType.BuBingYing;
          var buildingIndex = this.buildIndex;
          var buildingLevel = data ? data.building_level || 0 : 0;
          this._dataModel = new BingYingModel(buildingUid, buildingType, buildingIndex, buildingLevel, this);
          this._dataModel.position = this.node.getPosition();
          this.updateDataModel(data);
          this.updateView();
        }

        /**
         * 更新数据模型
         * @param data 服务器返回的建筑数据
         */;
        _proto.updateDataModel = function updateDataModel(data) {
          var oldLevel = this.dataModel.level;
          this.dataModel.setServerData(data);
          if (!this.dataModel.isUnlocked) {
            this.dataModel.status = BuildingStatus.LOCK;
          } else {
            this.dataModel.status = BuildingStatus.IDLE;
          }
          if (data) {
            if (data.building_level !== oldLevel) {
              this.dataModel.level = data.building_level;
            }
            if (data.building_level <= 0 && data.upgrade_duration > 0) {
              this.dataModel.status = BuildingStatus.BUILDING;
              this.dataModel.isUpgrading = false;
            } else if (data.building_level > 0 && data.upgrade_duration > 0) {
              this.dataModel.isUpgrading = true;
            } else {
              this.dataModel.isUpgrading = false;
              this.dataModel.completeBuilding();
            }
          } else {
            this.dataModel.isUpgrading = false;
          }
        }

        /**
         * 等级改变时的回调
         */;
        _proto.onLevelChanged = function onLevelChanged() {
          this.playUpLevelAni();
        }

        /**
         * 播放升级动画
         */;
        _proto.playUpLevelAni = function playUpLevelAni() {
          App.log.logBusiness("步兵营播放升级动画");
          // TODO: 播放升级动画
        }
        //==============================子类方法重载=======================================
        ;

        _createClass(BuBingYing, [{
          key: "dataModel",
          get:
          /**
           * 获取数据模型
           */
          function get() {
            return this._dataModel;
          }
        }]);
        return BuBingYing;
      }(BuildingBase), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "lockNode", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "jiaImg", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "buildProgress", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "buildTimeLab", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "unLockNode", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "heroAni", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "lvUpImg", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "upgradeProgressBar", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "timeLab", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor10 = _applyDecoratedDescriptor(_class2.prototype, "inLine", [_dec11], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor11 = _applyDecoratedDescriptor(_class2.prototype, "outLine", [_dec12], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor12 = _applyDecoratedDescriptor(_class2.prototype, "trainingNPCParent", [_dec13], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor13 = _applyDecoratedDescriptor(_class2.prototype, "reserveCountLab", [_dec14], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor14 = _applyDecoratedDescriptor(_class2.prototype, "btnNode", [_dec15], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor15 = _applyDecoratedDescriptor(_class2.prototype, "xlShebeiParent", [_dec16], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor16 = _applyDecoratedDescriptor(_class2.prototype, "movingSoldierPrefab", [_dec17], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor17 = _applyDecoratedDescriptor(_class2.prototype, "npcArrivePos", [_dec18], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return new Vec3(0, 0, 0);
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/Buff.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MonitorType.ts', './DBRecord.ts', './BattleDefine.ts', './Monster.ts', './BuffEffect.ts', './GameConfig.ts', './App.ts'], function (exports) {
  var _createClass, cclegacy, Vec3, MonitorType, DBRecord, GameBattle, Monster, BuffEffect, GameConfig, App;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      Monster = module.Monster;
    }, function (module) {
      BuffEffect = module.BuffEffect;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      cclegacy._RF.push({}, "1ab25ckLWJEZ5z3z9Bh+IuJ", "Buff", undefined);
      var Buff = exports('Buff', /*#__PURE__*/function () {
        var _proto = Buff.prototype;
        /**
         * buff source是否被回收后重用成别的怪物
         * @returns
         */
        _proto.checkSourceError = function checkSourceError() {
          if (!this.source || !this.initSourceId) {
            return false;
          }
          var vo = this.source.roleVO;
          if (vo && this.initSourceId !== vo.id) {
            return true;
          }
          return false;
        };
        function Buff(buff_id, owner, source, skillId) {
          if (skillId === void 0) {
            skillId = 0;
          }
          this.vo = null;
          this.effects = null;
          // buff效果组
          this.source = null;
          //buff 的源头, 施法者
          this._owner = null;
          this._buffId = 0;
          this._skillId = 0;
          this._triggerTimes = 0;
          //堆叠次数
          this._needUpdateUI = false;
          //是否通知UI更新
          this.maxTime = 0;
          this.curTime = 0;
          this._uid = 0;
          this._tiggered = false;
          this.guanghuanCd = 0;
          //扩展属性, 非配表的属性
          this.ex = null;
          this.target = {};
          this.newTargets = {};
          /**初始sourceId */
          this.initSourceId = 0;
          /** 初始source的属性 */
          this.initSourceFullAttr = {};
          /** 初始source的属性 */
          this.initSourceLockAttr = {};
          this._uid = Buff.uid++;
          this._owner = owner;
          this.source = source;
          this._buffId = buff_id;
          this._skillId = skillId;
          var deepCopy = function deepCopy(obj) {
            return JSON.parse(JSON.stringify(obj));
          };
          var buff_cfg = DBRecord.fetchId("JiNengBuff", buff_id);
          if (!buff_cfg) return;
          this.vo = deepCopy(buff_cfg);
          this.guanghuanCd = 3;
          this.ex = {
            interval: this.vo.interval,
            timeList: [this.vo.time],
            intervalTime: [this.vo.interval]
          };
          this.target = {};
          this.newTargets = {};
          this.setBuffData();
          if (this.vo.icon && this.vo.icon.length > 0) {
            var role = owner.owner;
            if (role instanceof Monster && role.roleVO.quality === GameBattle.MonsterQuality.Boss) {
              this._needUpdateUI = true;
            }
          }
        }
        _proto.setBuffData = function setBuffData() {
          this.effects = [];
          for (var i = 0; i < this.vo.effect_ids.length; i++) {
            this.effects[i] = new BuffEffect(this.vo.effect_ids[i], this._owner, this._buffId, this.source, this._skillId);
          }
          if (this.vo.duration === GameBattle.BuffDurationType.Battle || this.vo.duration === GameBattle.BuffDurationType.Forever) {
            this.vo.time = Number.MAX_SAFE_INTEGER;
          }
          if (this.vo.condition_num === -1) {
            this.vo.condition_num = Number.MAX_SAFE_INTEGER;
          }
          this._triggerTimes = 0;
          this.curTime = this.vo.time;
          if (GameConfig.DebugInfo.showBuffLog) {
            console.log("setBuffData test buff", this._triggerTimes, this._uid);
          }
        }

        //触发生效
        ;

        _proto.trigger = function trigger() {
          // if (this._triggerTimes < this.vo.add_num) {
          // if ([5000191,5000192,5000193].indexOf(this._buffId) > -1) {
          //     if (this.guanghuanCd > 0) {
          //         return;
          //     }
          // }
          // this.guanghuanCd = 3
          for (var i = 0; i < this.effects.length; i++) {
            this.effects[i].trigger();
          }
          this._triggerTimes++;
          // }
          if (GameConfig.DebugInfo.showBuffLog) {
            console.log("触发 test buff", this._triggerTimes, this._uid);
          }
          this.updateBuffUi(false);
          this._tiggered = true;
        };
        _proto.setBufVfx = function setBufVfx() {
          if (!this.vo.vfx) return;
          var target = this._owner.owner;
          var guaWorld = target.getMountPoint(this.vo.dummy_point, Vec3.ZERO);
          var gzNode = target.getBuffNode(this.vo.hierarchy);
          var localPos = target.getBuffLocationPos(this.vo.hierarchy, guaWorld);
          if (guaWorld.x === 0 && guaWorld.y === 0) {
            localPos.set(0, 0, 0);
          }
          var time = 0;
          if (this.vo.duration === GameBattle.BuffDurationType.Timer) {
            time = this.vo.time / 1000 || 0;
          }
          App.monitorMgr.dispatchEvent(MonitorType.battle_buff_attack_effect, {
            node: gzNode,
            effect: this.vo.vfx,
            hit_pos: localPos,
            size: 1,
            duration: this.vo.duration,
            time: time
          });
        }

        // 删除buff
        // 只有增加属性的buff才会扣除增益的属性, 或者返还减益的属性.
        // 伤害类或者移除类的buff不需要处理
        ;

        _proto.remove = function remove() {
          if (!this._tiggered) return; //没有触发过，则不删除
          this.effects.forEach(function (v, index) {
            v.remove();
          });
          this._triggerTimes--;
          // console.log('删除 test buff', this._triggerTimes, this._uid);
          this.updateBuffUi(true);
        };
        _proto.init = function init(buff_id) {};
        _proto.checkCondition = function checkCondition(count, death_count, target) {
          var _this = this;
          var v = this.vo;
          var self = this;
          var checkFunc = {
            1: function _(v1, v2) {
              return v1 >= v2;
            },
            2: function _(v1, v2) {
              // if (App.battleMgr.guanQiaType === GameBattle.GuanQiaType.JingJiChang) {
              //     let player = self.owner.owner as Player;
              //     if (!player.isMyself) {
              //         let list = App.battleMgr.battleMainViewCtrl.battleJingJiChang.enemySkills
              //         return list.indexOf(v2) > -1;
              //     }
              // }
              var skills = App.skillMgr.getAllLearnedSkill();
              return skills.indexOf(v2) > -1;
            },
            3: function _(v1, v2) {
              return v1 >= v2;
            },
            4: function _(v1, v2) {
              return v1 === v2;
            },
            5: function _(v1, v2) {
              return self.source._buffBox.getBuffById(v2) !== null;
            },
            6: function _(v1, v2) {
              return self._owner.getBuffById(v2) !== null;
            },
            7: function _(v1, v2) {
              return v1 <= v2;
            },
            8: function _(v1, v2) {
              //判断身上某个buff的堆叠层数是否满足
              var buffs = target._buffBox.getBuffGroupById(_this.vo.buff_group);
              for (var id in buffs) {
                var buff = buffs[id];
                if (buff._buffId === _this._buffId) {
                  continue;
                }
                if (buff.vo.add_type !== 4) {
                  //不是堆叠buff
                  continue;
                }
                var ret = buff.ex.intervalTime.length >= v2;
                if (ret) {
                  target._buffBox.removeBuff(buff);
                  if (self.target[target.uid]) {
                    delete self.target[target.uid];
                  }
                  self.trigger();
                }
                return ret;
              }
              return false;
            },
            9: function _(v1, v2) {
              //判断元素是否高于其他元素伤害
              var vo = self._owner.owner.roleVO;
              var v = App.battleProprMgr.featchValueById(v2[0], vo);
              for (var i = 1; i < v2.length; i++) {
                if (v <= App.battleProprMgr.featchValueById(v2[i], vo)) {
                  return false;
                }
              }
              return true;
            },
            10: function _(v1, v2) {
              return self._owner.getBuffById(v2) === null;
            },
            //指定种族
            11: function _(v1, v2) {
              // const heroId = App.heroTavernManager.curHeroId;
              // let cfg: dbr.YingXiong = App.heroTavernManager.getHeroConfig(heroId);
              // if (cfg) {
              //     return v2 === cfg.race;
              // }
              return false;
            },
            13: function _(v1, v2) {
              var buffs = self._owner.getBuffGroupById(v2);
              return buffs && Object.keys(buffs).length > 0;
            },
            14: function _(v1, v2) {
              var buffs = self.source._buffBox.getBuffGroupById(v2);
              return buffs && Object.keys(buffs).length > 0;
            },
            15: function _(v1, v2) {
              return self._owner.owner.isBoss();
            }
          };
          var args = [0, count, 0, death_count, count, 0, 0, count, 0];
          if (!v.condition || !Array.isArray(v.condition)) return false;
          for (var i = 0; i < v.condition.length; i++) {
            if (!checkFunc[v.condition[i]](args[v.condition[i]], v.condition_val[i])) {
              return false;
            }
          }
          return true;
        };
        _proto.updateBuffUi = function updateBuffUi(remove) {
          if (!this._needUpdateUI) return;
          var type = this._owner.owner.type;
          App.monitorMgr.dispatchEvent(MonitorType.battle_update_buff_ui, type, this._buffId, this.vo.icon, this.vo.time, this.ex.timeList.length, remove);
        };
        _createClass(Buff, [{
          key: "owner",
          get: function get() {
            return this._owner;
          }
        }, {
          key: "buffId",
          get: function get() {
            return this._buffId;
          }
        }, {
          key: "skillId",
          get: function get() {
            return this._skillId;
          }
        }]);
        return Buff;
      }());
      Buff.uid = 0;
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuffBox.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './Buff.ts', './BattleDefine.ts', './MonitorType.ts', './BattleProprMgr.ts', './DBRecord.ts', './BulletEffect.ts', './BulletVO.ts', './MyBulletLauncher.ts', './GameConfig.ts', './BuffEffect.ts', './Utils.ts', './App.ts', './BattleUtil.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, cclegacy, Vec3, UITransform, Buff, GameBattle, MonitorType, BattlePropertyName, DBRecord, BulletEffect, BulletVO, MyBulletLauncher, GameConfig, BuffEffect, Utils, App, BattleUtil;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
      UITransform = module.UITransform;
    }, function (module) {
      Buff = module.Buff;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      BulletEffect = module.BulletEffect;
    }, function (module) {
      BulletVO = module.BulletVO;
    }, function (module) {
      MyBulletLauncher = module.MyBulletLauncher;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      BuffEffect = module.BuffEffect;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      cclegacy._RF.push({}, "663bap65WJCab0tq9ANvrvq", "BuffBox", undefined);
      var BuffBox = exports('BuffBox', /*#__PURE__*/function () {
        function BuffBox() {
          this._allBuffs = {};
          //buff列表
          this._monsterDieCount = {};
          //怪物死亡个数
          this.subBulletBuff = {};
          //次级子弹buff
          this.subBulletEffectBuff = {};
          //次级子弹effect buff
          this.catchBuff = {};
          //缓存buff
          this.catchBuffEffect = {};
          //缓存buff
          this.constantlySkillBuff = {};
          //实时技能buff
          this.constantlyAttrBuff = {};
          //实时属性buff
          this.eventBuff = {};
          //事件触发buff
          /** 持有者 */
          this.owner = void 0;
        }
        var _proto = BuffBox.prototype;
        _proto.init = function init(owner) {
          this.owner = owner;
          this._allBuffs = {};
          this._monsterDieCount = {};
          this.subBulletBuff = {};
          this.subBulletEffectBuff = {};
          this.catchBuff = {};
          this.catchBuffEffect = {};
          this.constantlySkillBuff = {};
          this.constantlyAttrBuff = {};
          this.eventBuff = {};
        };
        _proto.dispose = function dispose() {
          this.owner = null;
          this._allBuffs = null;
          this._monsterDieCount = null;
          this.subBulletBuff = null;
          this.subBulletEffectBuff = null;
          this.catchBuff = null;
          this.catchBuffEffect = null;
          this.constantlySkillBuff = null;
          this.constantlyAttrBuff = null;
          this.eventBuff = null;
        }

        /**
         * 添加buff到buff列表
         * @param buff_id
         * @param source buff来源
         * @param skillId buff来源技能
         * @param force 是否强制添加
         * @returns
         */;
        _proto.addBuff = function addBuff(buff_id, source, skillId, force, bullet) {
          if (bullet === void 0) {
            bullet = null;
          }
          //console.log('添加buff', buff_id, source.uid);
          var buff = new Buff(buff_id, this, source, skillId);
          // if (!buff.vo) return;

          var catchBuff = this.catchBuff[buff_id];
          if (catchBuff) {
            for (var i = 0; i < catchBuff.length; i++) {
              BuffEffect.setValue(buff.vo, catchBuff[i]);
              buff.curTime = buff.vo.time;
              if (catchBuff[i].grid_type === 4 && catchBuff[i].configuration === "effect_ids") {
                buff.effects = [];
                for (var _i = 0; _i < buff.vo.effect_ids.length; _i++) {
                  buff.effects[_i] = new BuffEffect(buff.vo.effect_ids[_i], buff.owner, buff.buffId, buff.source, buff.skillId);
                }
              }
            }
          }
          if (bullet && bullet.owner && bullet.owner.type === GameBattle.RoleType.Monster) {
            buff.initSourceId = bullet.initOwnerId;
            buff.initSourceFullAttr = Utils.copyObj(bullet.initOwnerFullAttr);
            buff.initSourceLockAttr = Utils.copyObj(bullet.initOwnerLockAttr);
            //console.warn('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR addBuff ,', bullet.bulletVO.bulletID, buff.initSourceId, buff.buffId);
          }

          var groupId = buff.vo.buff_group;
          var group = this._allBuffs[groupId];
          if (buff.vo.type === GameBattle.BuffType.Normal) {
            buff.target = this.owner;
          }
          if (group) {
            if (buff.vo.add_type === GameBattle.BuffAddType.Replace) {
              // 替换
              var oldBuff = null;
              var keys = Object.keys(group);
              if (keys.length > 0) {
                oldBuff = group[keys[0]];
              } else {
                this.addBuffToMap(buff);
              }
              if (oldBuff /** && oldBuff.vo.desc <= buff.vo.desc */) {
                this.removeBuff(oldBuff);
                this.addBuffToMap(buff);
              }
            } else if (buff.vo.add_type === GameBattle.BuffAddType.Add) {
              //添加
              if (group[buff_id]) {
                //是同一个buff 则替换时间
                group[buff_id].vo.time = buff.vo.time;
                group[buff_id].curTime = group[buff_id].vo.time;
              } else {
                //不是同一个buff 则添加
                this.addBuffToMap(buff);
              }
            } else if (buff.vo.add_type === GameBattle.BuffAddType.Exclusive) ;else if (buff.vo.add_type === GameBattle.BuffAddType.Overlap) {
              //堆叠
              if (!group[buff_id]) {
                this.addBuffToMap(buff);
                group[buff_id].vo.time = buff.vo.time;
              } else {
                if (group[buff_id].ex.timeList.length >= group[buff_id].vo.add_num) {
                  group[buff_id].ex.timeList.shift();
                  group[buff_id].ex.intervalTime.shift();
                  group[buff_id].remove();
                }
                group[buff_id].ex.timeList.push(group[buff_id].vo.time);
                group[buff_id].ex.intervalTime.push(group[buff_id].vo.interval);
                this.trigger(group[buff_id]);
                group[buff_id].vo.time = group[buff_id].vo.time;
              }
              group[buff_id].curTime = group[buff_id].vo.time;
            }
          } else {
            this.addBuffToMap(buff);
          }
          return buff;
        };
        _proto.addBuffToMap = function addBuffToMap(buff) {
          if (GameConfig.DebugInfo.showBuffLog) {
            console.log("添加buff id = ", buff.vo.id);
          }
          var groupId = buff.vo.buff_group;
          var buff_id = buff.vo.id;
          if (!this._allBuffs[groupId]) {
            this._allBuffs[groupId] = {};
          }
          this._allBuffs[groupId][buff_id] = buff;
          this.trigger(buff);
          // buff.setBufVfx()
        };

        _proto.trigger = function trigger(buff) {
          if (buff.vo.condition) {
            if (buff.vo.condition_num > 0) {
              var count = this._getEnemiesCountInRange(buff);
              if (buff.checkCondition(count, 0, this.owner)) {
                buff.vo.condition_num--;
                buff.trigger();
              }
            }
          } else {
            buff.trigger();
          }
        };
        _proto.removeBuff = function removeBuff(buff) {
          //console.log('删除 buff', buff.vo.id);
          var groupId = buff.vo.buff_group;
          var buff_id = buff.vo.id;
          if (buff.vo.add_type === 4) {
            var count = buff.ex.timeList.length;
            for (var i = 0; i < count; i++) {
              //叠加的BUFF根据叠加的次数来删除
              buff.remove();
            }
          } else {
            buff.remove();
          }
          buff = null;
          delete this._allBuffs[groupId][buff_id];
          delete this._monsterDieCount[buff_id];
        };
        _proto.removeBuffById = function removeBuffById(buffId) {
          console.log("删除 id buff");
          for (var _k2 in this._allBuffs) {
            for (var id in this._allBuffs[_k2]) {
              if (Number(id) === buffId) {
                var buff = this._allBuffs[_k2][id];
                buff.remove();
                delete this._allBuffs[_k2][id];
                buff = null;
                break;
              }
            }
          }
        };
        _proto.removeGroupBuff = function removeGroupBuff(gourpId) {
          console.log("删除 buff 组");
          for (var i in this._allBuffs[gourpId]) {
            this.removeBuff(this._allBuffs[gourpId][i]);
          }
          this._allBuffs[gourpId] = {};
        };
        _proto.getBuffById = function getBuffById(buff_id) {
          for (var i in this._allBuffs) {
            var group = this._allBuffs[i];
            for (var j in group) {
              if (group[j].vo.id === buff_id) {
                return group[j];
              }
            }
          }
          return null;
        };
        _proto.getBuffGroupById = function getBuffGroupById(groupID) {
          return this._allBuffs[groupID];
        }

        // 光环Buff后面删除
        ;

        _proto.getGuanHuanBuffTargetType = function getGuanHuanBuffTargetType(_target) {
          return GameBattle.RoleType.Monster;
          //光环的监听目标暂时改为监听敌人
          // if (App.battleMgr.guanQiaType === GameBattle.GuanQiaType.JingJiChang) {
          //     if (this.owner.type === GameBattle.RoleType.Player) {
          //         return GameBattle.RoleType.Enemy;
          //     } else {
          //         return GameBattle.RoleType.Player;
          //     }
          // }
          // if (this.owner.type === GameBattle.RoleType.Player) {
          //     return GameBattle.RoleType.Monster;
          // } else {
          //     return GameBattle.RoleType.Player;
          // }
          // if (target === GameBattle.BuffTargetType.enemy) {
          //     if (this.owner.type === GameBattle.RoleType.Player) {
          //         return GameBattle.RoleType.Monster;
          //     } else {
          //         return GameBattle.RoleType.Player;
          //     }
          // } else if (target === GameBattle.BuffTargetType.self || target === GameBattle.BuffTargetType.partner) {
          //     return this.owner.type;
          // } else if (target === GameBattle.BuffTargetType.mainRole) {
          //     return GameBattle.RoleType.Player;
          // }
        };

        _proto._getEnemiesCountInRange = function _getEnemiesCountInRange(buff) {
          var count = 0;
          var targetType = this.getGuanHuanBuffTargetType(buff.vo.target);
          var _map = App.battleMgr.roleCtrl.entityMap;
          for (var _iterator = _createForOfIteratorHelperLoose(_map), _step; !(_step = _iterator()).done;) {
            var _step$value = _step.value,
              _k = _step$value[0],
              v = _step$value[1];
            if (v.type === targetType) {
              var distance = Vec3.distance(v.node.worldPosition, this.owner.node.worldPosition);
              if (count > buff.vo.affect_quantity) break; //超出光环影响的数量
              if (distance < buff.vo.range) {
                count++;
              }
            }
          }
          return count;
        };
        _proto.onUpdate = function onUpdate(dt) {
          for (var _key in this._allBuffs) {
            var group = this._allBuffs[_key];
            for (var key2 in group) {
              var buff = group[key2];
              var vo = buff.vo;
              var tm = dt * 1000;
              // if (buff.vo.type === GameBattle.BuffType.GuangHuan) {
              //     let _map = App.battleMgr.roleCtrl.entityMap;
              //     let curTargetMap = {};
              //     let count = 0;
              //     let targetType = this.getGuanHuanBuffTargetType(buff.vo.target);
              //     for (const [k, v] of _map) {
              //         if (v.type === targetType) {
              //             if (count > buff.vo.affect_quantity) break; //超出光环影响的数量
              //             // if (this.owner.type === GameBattle.RoleType.Player && v.masterId === this.owner.uid) continue;
              //             const distance = Vec3.distance(v.node.worldPosition, this.owner.node.worldPosition);
              //             if (distance < buff.vo.range) {
              //                 curTargetMap[v.uid] = v;
              //                 count++;
              //             }
              //         }
              //     }
              //     buff.newTargets = {};
              //     for (const monster_id in buff.target) {
              //         if (!curTargetMap[monster_id]) {
              //             // console.log('目标离开了光环范围');
              //             if (buff.vo.target === GameBattle.BuffTargetType.enemy) {
              //                 //对敌人生效的光环
              //                 let role = buff.target[monster_id] as RoleBase;
              //                 for (let effect of buff.effects) {
              //                     if (effect.vo.type === GameBattle.BuffEffectType.AddBuffByOdds) {
              //                         let bid = Number(effect.vo.atr[0]);
              //                         role._buffBox.removeBuffById(bid);
              //                     }
              //                 }
              //             }
              //             delete buff.target[monster_id];
              //         }
              //     }

              //     for (const key in curTargetMap) {
              //         if (!buff.target[key]) {
              //             // console.log('新目标进入了光环范围');
              //             buff.target[key] = curTargetMap[key];
              //             buff.newTargets[key] = buff.target[key];
              //         }
              //     }
              //     if (buff.vo.condition_num > 0) {
              //         if (buff.vo.target === GameBattle.BuffTargetType.enemy) {
              //             //对敌人生效的光环
              //             for (const key in buff.newTargets) {
              //                 let role = buff.newTargets[key] as RoleBase;
              //                 if (buff.checkCondition(count, 0, role)) {
              //                     buff.vo.condition_num--;
              //                     for (let effect of buff.effects) {
              //                         if (effect.vo.type === GameBattle.BuffEffectType.AddBuffByOdds) {
              //                             let bid = Number(effect.vo.atr[0]);
              //                             role._buffBox.addBuff(bid, buff.source);
              //                         }
              //                     }
              //                 } else {
              //                     if (curTargetMap[key]) {
              //                         delete curTargetMap[key];
              //                     }
              //                     if (buff.target[key]) {
              //                         delete buff.target[key];
              //                     }
              //                 }
              //             }
              //         } else {
              //             if (buff.checkCondition(count, 0, this.owner)) {
              //                 buff.vo.condition_num--;
              //                 buff.trigger();
              //             }
              //         }
              //     } else {
              //         if (buff.vo.target === GameBattle.BuffTargetType.enemy) {
              //             //对敌人生效的光环
              //             for (const key in buff.target) {
              //                 let role = buff.target[key] as RoleBase;
              //                 if (!buff.checkCondition(count, 0, role)) {
              //                     buff.vo.condition_num++;
              //                     for (let effect of buff.effects) {
              //                         if (effect.vo.type === GameBattle.BuffEffectType.AddBuffByOdds) {
              //                             let bid = Number(effect.vo.atr[0]);
              //                             role._buffBox.removeBuffById(bid);
              //                         }
              //                     }
              //                 }
              //             }
              //         } else {
              //             //宠物释放吸怪子弹做成了光环，利用这个计数器清cd,不执行出区域清除buff流程，只按时间。
              //             if (vo.effect_interval) {
              //                 buff.ex.effect_interval -= tm;
              //                 if (buff.ex.effect_interval < 0) {
              //                     buff.vo.condition_num++;
              //                     buff.ex.effect_interval = buff.vo.effect_interval;
              //                     buff.remove();
              //                 }
              //             } else {
              //                 if (!buff.checkCondition(count, 0, this.owner)) {
              //                     buff.vo.condition_num++;
              //                     buff.remove();
              //                 }
              //             }
              //         }
              //         // console.log('光环失效');
              //     }

              //     // const distance = Vec3.distance(target.node.worldPosition, this._owner.node.worldPosition);
              // } else {
              if (vo.interval && buff.vo.add_type !== 4) {
                //周期性buff
                buff.ex.interval -= tm;
                if (buff.ex.interval < 0) {
                  //触发一次周期
                  buff.ex.interval = buff.vo.interval;
                  this.trigger(buff);
                  // buff.trigger();
                }
              }

              if (buff.vo.add_type === 4) {
                //堆叠buff
                for (var i = 0; i < buff.ex.timeList.length; i++) {
                  buff.ex.timeList[i] -= tm;
                  buff.ex.intervalTime[i] -= tm;
                }
                if (buff.ex.timeList[0] < 0) {
                  console.log("移除第一层堆叠buff", buff.vo.id);
                  buff.ex.timeList.shift();
                  buff.ex.intervalTime.shift();
                  buff.remove();
                }
                for (var _i2 = 0; _i2 < buff.ex.intervalTime.length; _i2++) {
                  if (buff.ex.intervalTime[_i2] < 0) {
                    //console.log('触发buff 第', i, '层');
                    this.trigger(buff);
                    // buff.trigger();
                    buff.ex.intervalTime[_i2] = buff.vo.interval;
                  }
                }
              }
              // }
              buff.curTime -= tm;
              buff.guanghuanCd -= dt;
              if (buff.curTime <= 0) {
                //移除BUFF
                if (GameConfig.DebugInfo.showBuffLog) {
                  console.log("移除BUFF", buff.vo.id, this._allBuffs);
                }

                // if (buff.vo.type === GameBattle.BuffType.GuangHuan && buff.vo.target === GameBattle.BuffTargetType.enemy) {
                //     //对敌人生效的光环
                //     for (const key in buff.target) {
                //         let role = buff.target[key] as RoleBase;
                //         for (let effect of buff.effects) {
                //             if (effect.vo.type === GameBattle.BuffEffectType.AddBuffByOdds) {
                //                 let bid = Number(effect.vo.atr[0]);
                //                 role._buffBox.removeBuffById(bid);
                //             }
                //         }
                //     }
                // } else {
                this.removeBuff(buff);
                // }
                delete group[key2];
                buff = null;
              }
            }
          }
        };
        _proto.addCatchBuff = function addCatchBuff(buff_id, vo) {
          if (!this.catchBuff[buff_id]) {
            this.catchBuff[buff_id] = [];
          }
          this.catchBuff[buff_id].push(vo);
        };
        _proto.addCatchBuffEffect = function addCatchBuffEffect(buff_effect_id, vo) {
          if (!this.catchBuffEffect[buff_effect_id]) {
            this.catchBuffEffect[buff_effect_id] = [];
          }
          this.catchBuffEffect[buff_effect_id].push(vo);
        };
        _proto.monsterDie = function monsterDie(diePos) {
          for (var i in this._monsterDieCount) {
            var buff = this._monsterDieCount[i].buff;
            var distance = Vec3.distance(diePos, this.owner.node.worldPosition);
            if (distance < buff.vo.range) {
              this._monsterDieCount[i].count++;
              if (buff.vo.condition_num > 0) {
                if (buff.checkCondition(0, this._monsterDieCount[i].count, this.owner)) {
                  buff.trigger();
                  console.log("光环 怪物死亡 buff 生效");
                  buff.vo.condition_num--;
                  this._monsterDieCount[i].count -= buff.vo.condition_val[0];
                }
              }
            }
          }
        };
        _proto.addConstantlySkillBuff = function addConstantlySkillBuff(skillId, cfg) {
          this.constantlySkillBuff[skillId] = cfg;
        };
        _proto.removeConstantlySkillBuff = function removeConstantlySkillBuff(skillId) {
          this.constantlySkillBuff[skillId] = null;
          delete this.constantlySkillBuff[skillId];
        }

        /**
         * 获取技能buff属性值
         * @param skillId
         * @param monsterType
         * @returns
         */;
        _proto.getConstantlySkillBuff = function getConstantlySkillBuff(skillId, monsterType) {
          if (!this.constantlySkillBuff || !this.constantlySkillBuff[skillId]) {
            return [0, 0];
          }
          var vo = this.constantlySkillBuff[skillId];
          var _vo$value = vo.value,
            ratio = _vo$value[0],
            value = _vo$value[1],
            mType = _vo$value[2];
          if (Math.random() * 10000 > ratio) {
            return [0, 0];
          }
          if (mType && monsterType) {
            if (mType !== -1 && monsterType !== mType) {
              return [0, 0];
            }
          }
          if (value > 10000) {
            this.triggerEventBuff(GameBattle.EventBuffId.MiaoSha);
          }
          if (vo.calculate === GameBattle.BuffEffectCalculate.add) {
            return [value, 0];
          } else {
            return [0, value];
          }
        }

        /**
         * 增加属性buff属性
         * @param attrId
         * @param cfg
         */;
        _proto.addConstantlyAttrBuff = function addConstantlyAttrBuff(attrId, cfg) {
          this.constantlyAttrBuff[attrId] = cfg;
        };
        _proto.removeConstantlyAttrBuff = function removeConstantlyAttrBuff(attrId) {
          this.constantlySkillBuff[attrId] = null;
          delete this.constantlyAttrBuff[attrId];
        }

        /**
         * 获取buff属性值
         * @returns
         */;
        _proto.getConstantlyAttrBuff = function getConstantlyAttrBuff(target) {
          var map = {};
          for (var _key2 in this.constantlyAttrBuff) {
            var id = Number(_key2);
            var vo = this.constantlyAttrBuff[id];
            var _vo$value2 = vo.value,
              attrId = _vo$value2[0],
              ratio = _vo$value2[1],
              value = _vo$value2[2];
            if (!map[attrId]) {
              map[attrId] = 0;
            }
            var attr = App.battleProprMgr.featchValueById(id, this.owner.roleVO);
            var pass = false;
            if (vo.algorithm === 8) {
              //检测属性高于某个值
              if (attr > ratio) {
                pass = true;
              }
            } else if (vo.algorithm === 9) {
              //检测属性低于某个值
              if (attr < ratio) {
                pass = true;
              }
            } else if (vo.algorithm === 6) {
              //背水一战
              var maxHp = this.owner.roleVO.getRoleAttr(BattlePropertyName.shengming);
              var r = attr / maxHp * 10000;
              value *= Math.floor((10000 - r) / ratio);
              pass = true;
              // console.log(`背水一战 curhp = ${attr} maxhp=${maxHp} 属性id = ${attrId}, 增加值 ${value}`);
            } else if (vo.algorithm === 10) {
              //移动中
              if (this.owner.moveDirection.x !== 0 || this.owner.moveDirection.y !== 0) {
                pass = true;
              }
            } else if (vo.algorithm === 11) {
              if (target.isBoss()) {
                //BOSS血量低于某个比率
                var wfbHp = target.roleVO.getCurWfbHp();
                // console.log('检测属性变化buff', wfbHp);
                if (wfbHp < ratio) pass = true;
              }
            } else if (vo.algorithm === 12) ;else if (vo.algorithm === 13) ;else if (vo.algorithm === 14) {
              //检测目标身上是否有某个buff组
              if (target._buffBox.getBuffGroupById(vo.atr[0])) {
                pass = true;
              }
            } else if (vo.algorithm === 15) {
              //检测自己身上是否有某个buff组
              if (this.owner._buffBox.getBuffGroupById(vo.atr[0])) {
                pass = true;
              }
            } else if (vo.algorithm === 16) {
              //检测自己身上是否有某个buff
              if (this.owner._buffBox.getBuffById(vo.atr[0])) {
                pass = true;
              }
            }
            if (pass) {
              map[attrId] += value;
            }
          }
          // console.log('检测属性变化buff', map);
          return map;
        }

        /**
         * 增加buff
         * @param eventId
         * @param cfg
         */;
        _proto.addEventBuff = function addEventBuff(eventId, cfg) {
          if (!this.eventBuff[eventId]) {
            this.eventBuff[eventId] = [];
          }
          this.eventBuff[eventId].push(cfg);
        }

        /**
         * 移除buff
         * @param eventId
         */;
        _proto.removeEventBuff = function removeEventBuff(eventId) {
          this.eventBuff[eventId] = null;
          delete this.eventBuff[eventId];
        }

        /**
         * 事件触发BUFF
         * @param eventId 事件id
         * @param triggerId 触发ID(技能ID或者子弹ID)
         * @returns
         */;
        _proto.triggerEventBuff = function triggerEventBuff(eventId, triggerId, hitTarget) {
          if (triggerId === void 0) {
            triggerId = 0;
          }
          if (hitTarget === void 0) {
            hitTarget = null;
          }
          if (!this.eventBuff || !this.eventBuff[eventId]) {
            return;
          }
          if (eventId === GameBattle.EventBuffId.HitEnemy) {
            if (hitTarget) {
              for (var _iterator2 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step2; !(_step2 = _iterator2()).done;) {
                var vo = _step2.value;
                for (var i = 0; i < vo.value.length; i++) {
                  var buffId = vo.value[i];
                  if (vo.target === GameBattle.BuffTargetType.enemy) {
                    hitTarget._buffBox.addBuff(buffId, this.owner);
                  } else if (vo.target === GameBattle.BuffTargetType.self) {
                    this.addBuff(buffId, this.owner);
                  }
                }
              }
            }
          } else if (eventId === GameBattle.EventBuffId.allBall) {
            for (var _iterator3 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step3; !(_step3 = _iterator3()).done;) {
              var _vo = _step3.value;
              for (var _i3 = 0; _i3 < _vo.value.length; _i3++) {
                var _buffId = _vo.value[_i3];
                this.addBuff(_buffId, this.owner);
              }
            }
          } else if (eventId === GameBattle.EventBuffId.hpBall) {
            for (var _iterator4 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step4; !(_step4 = _iterator4()).done;) {
              var _vo2 = _step4.value;
              for (var _i4 = 0; _i4 < _vo2.value.length; _i4++) {
                var _buffId2 = _vo2.value[_i4];
                this.addBuff(_buffId2, this.owner);
              }
            }
          } else if (eventId === GameBattle.EventBuffId.reborn) {
            if (this.owner.roleVO.curHP <= 0) {
              for (var index = 0; index < this.eventBuff[eventId].length; index++) {
                var _vo3$__buff_cd__;
                var _vo3 = this.eventBuff[eventId][index];
                var last_tm = (_vo3$__buff_cd__ = _vo3["__buff_cd__"]) != null ? _vo3$__buff_cd__ : 0;
                var cd = _vo3.value[1];
                var now = Date.now() / 1000;
                if (now - last_tm < cd) {
                  return false;
                }
                _vo3["__buff_cd__"] = now;
                var maxHp = this.owner.roleVO.getRoleAttr(BattlePropertyName.shengming);
                var hp = Math.floor(Number(_vo3.value[0]) / 10000 * maxHp);
                var buff_id = _vo3.value[2];
                if (buff_id > 0) {
                  this.addBuff(buff_id, this.owner);
                }
                this.owner.roleVO.updateCurHP(hp);
                var target = this.owner;
                if (_vo3.vfx) {
                  var guaWorld = target.getMountPoint(_vo3.dummy_point, new Vec3(0, 0, 0));
                  var localPos = target.getComponent(UITransform).convertToNodeSpaceAR(guaWorld);
                  var duration = GameBattle.BuffDurationType.Timer;
                  var time = 0;
                  if (_vo3.vfx_time === -1) {
                    duration = GameBattle.BuffDurationType.Forever;
                  } else if (_vo3.vfx_time > 0) {
                    duration = GameBattle.BuffDurationType.Timer;
                    time = _vo3.vfx_time;
                  } else if (_vo3.vfx_time === -2) {
                    duration = GameBattle.BuffDurationType.SpineTimer;
                    time = 0;
                  }
                  App.monitorMgr.dispatchEvent(MonitorType.battle_buff_attack_effect, {
                    node: target.node,
                    effect: _vo3.vfx,
                    hit_pos: localPos,
                    size: 1,
                    duration: duration,
                    time: time
                  });
                }
              }
            }
          } else if (eventId === GameBattle.EventBuffId.shanBi) {
            var vos = this.eventBuff[eventId];
            for (var _iterator5 = _createForOfIteratorHelperLoose(vos), _step5; !(_step5 = _iterator5()).done;) {
              var _vo4 = _step5.value;
              for (var _i5 = 0; _i5 < _vo4.value.length; _i5++) {
                var _buffId3 = _vo4.value[_i5];
                this.addBuff(_buffId3, this.owner);
              }
            }
          } else if (eventId === GameBattle.EventBuffId.attack) {
            for (var _iterator6 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step6; !(_step6 = _iterator6()).done;) {
              var _vo5 = _step6.value;
              var _vo5$value = _vo5.value,
                id = _vo5$value[0],
                _buffId4 = _vo5$value[1],
                ratio = _vo5$value[2];
              if (id === triggerId) {
                if (Math.random() * 10000 < ratio) {
                  this.addBuff(_buffId4, this.owner);
                }
              }
            }
          } else if (eventId === GameBattle.EventBuffId.underAttack) {
            var _vo6 = this.eventBuff[eventId][0];
            var _vo6$value = _vo6.value,
              _buffId5 = _vo6$value[0],
              _ratio = _vo6$value[1];
            if (Math.random() * 10000 < _ratio) {
              this.addBuff(_buffId5, this.owner);
            }
          } else if (eventId === GameBattle.EventBuffId.enterBattle) {
            var _vo7 = this.eventBuff[eventId][0];
            var _index = Math.floor(Math.random() * _vo7.value.length);
            var _buffId6 = _vo7.value[_index];
            this.addBuff(_buffId6, this.owner);
          } else if (eventId === GameBattle.EventBuffId.userSkill) {
            var _vo8 = this.eventBuff[eventId][0];
            var _vo8$value = _vo8.value,
              bullet_id = _vo8$value[0],
              _ratio2 = _vo8$value[1],
              theta = _vo8$value[2];
            if (Math.random() * 10000 > _ratio2) return;
            var cfg = DBRecord.fetchId("JiNengZiDan", bullet_id);
            var bulletVo = new BulletVO();
            bulletVo.load(cfg);
            bulletVo.bulletEffect = {};
            for (var j = 0; j < bulletVo.effect_id.length; j++) {
              var effect_id = bulletVo.effect_id[j];
              bulletVo.bulletEffect[effect_id] = new BulletEffect();
              var cfg2 = DBRecord.fetchId("JiNengXiaoGuo", effect_id);
              bulletVo.bulletEffect[effect_id].load(cfg2);
            }
            var atkSkill = App.battleMgr.skillCtrl.getAtkSkill(this.owner.uid);
            var _target2 = atkSkill.getTarget();
            if (!_target2) return;
            var hit_point = null;
            if (_vo8.target === 2) {
              hit_point = this.owner.node.worldPosition;
            } else {
              hit_point = atkSkill.getTarget().getHitWorldPosition();
            }
            var angle = BattleUtil.get2DAngleByPoint(this.owner.node.worldPosition, _target2.node.worldPosition);
            var count = Number(_vo8.algorithm);
            MyBulletLauncher.addSubBullet(bulletVo, atkSkill, hit_point, count, angle, theta);
          } else if (eventId === GameBattle.EventBuffId.bulletLaunch) {
            for (var _iterator7 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step7; !(_step7 = _iterator7()).done;) {
              var _vo9 = _step7.value;
              var _vo9$value = _vo9.value,
                _id = _vo9$value[0],
                _buffId7 = _vo9$value[1],
                _ratio3 = _vo9$value[2];
              if (_id === triggerId) {
                if (Math.random() * 10000 < _ratio3) {
                  this.addBuff(_buffId7, this.owner);
                }
              }
            }
          } else if (eventId === GameBattle.EventBuffId.geDang) {
            var _vos = this.eventBuff[eventId];
            for (var _iterator8 = _createForOfIteratorHelperLoose(_vos), _step8; !(_step8 = _iterator8()).done;) {
              var _vo10 = _step8.value;
              for (var _i6 = 0; _i6 < _vo10.value.length; _i6++) {
                var _buffId8 = _vo10.value[_i6];
                this.addBuff(_buffId8, this.owner);
              }
            }
          } else if (eventId === GameBattle.EventBuffId.TuTeng) {
            for (var _iterator9 = _createForOfIteratorHelperLoose(this.eventBuff[eventId]), _step9; !(_step9 = _iterator9()).done;) {
              var _vo11 = _step9.value;
              var _vo11$value = _vo11.value,
                _id2 = _vo11$value[0],
                _buffId9 = _vo11$value[1],
                _ratio4 = _vo11$value[2];
              if (_id2 === triggerId) {
                if (Math.random() * 10000 < _ratio4) {
                  this.addBuff(_buffId9, this.owner);
                }
              }
            }
          } else if (eventId === GameBattle.EventBuffId.MiaoSha) {
            var _vos2 = this.eventBuff[eventId];
            for (var _iterator10 = _createForOfIteratorHelperLoose(_vos2), _step10; !(_step10 = _iterator10()).done;) {
              var _vo12 = _step10.value;
              for (var _i7 = 0; _i7 < _vo12.value.length; _i7++) {
                var _buffId10 = _vo12.value[_i7];
                this.addBuff(_buffId10, this.owner);
              }
            }
          }
        };
        return BuffBox;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuffEffect.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './DBRecord.ts', './Utils.ts', './BattleProprMgr.ts', './BulletVO.ts', './BulletEffect.ts', './MyBulletLauncher.ts', './BattleDefine.ts', './MonitorType.ts', './Monster.ts', './GameConfig.ts', './App.ts', './BattleUtil.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, cclegacy, _decorator, Vec3, tween, v3, DBRecord, Utils, BattlePropertyName, FormulaResultItem, BulletVO, BulletEffect, MyBulletLauncher, GameBattle, MonitorType, Monster, GameConfig, App, BattleUtil;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Vec3 = module.Vec3;
      tween = module.tween;
      v3 = module.v3;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
      FormulaResultItem = module.FormulaResultItem;
    }, function (module) {
      BulletVO = module.BulletVO;
    }, function (module) {
      BulletEffect = module.BulletEffect;
    }, function (module) {
      MyBulletLauncher = module.MyBulletLauncher;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      Monster = module.Monster;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      var _dec, _class;
      cclegacy._RF.push({}, "9b8e5h5sXlJaK/z1km9itrS", "BuffEffect", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      // ghjgjuy:

      var BuffEffect = exports('BuffEffect', (_dec = ccclass("BuffEffect"), _dec(_class = /*#__PURE__*/function () {
        //效果动作
        function BuffEffect(buffEffectId, owner, buffId, source, skillId) {
          if (skillId === void 0) {
            skillId = 0;
          }
          this.vo = null;
          this._owner = null;
          this._buffId = 0;
          this._skillId = null;
          //源技能
          this._source = null;
          //buff 的源头, 施法者
          this._tween = null;
          var deepCopy = function deepCopy(obj) {
            return JSON.parse(JSON.stringify(obj));
          };
          this._source = source;
          this._buffId = buffId;
          this._skillId = skillId;
          this._owner = owner;
          var vo = DBRecord.fetchId("JiNengBuffXiaoGuo", buffEffectId);
          if (vo) {
            this.vo = deepCopy(vo);
            var catchBuffEffect = source._buffBox.catchBuffEffect[buffEffectId];
            if (catchBuffEffect) {
              for (var i = 0; i < catchBuffEffect.length; i++) {
                BuffEffect.setValue(this.vo, catchBuffEffect[i]);
              }
            }
          }
        }

        /**
         * 强制增加锁定属性
         * @param target
         * @param vo
         */
        var _proto = BuffEffect.prototype;
        _proto.forcedAttr = function forcedAttr(target, vo) {
          var attrDt = {};
          for (var i = 0; i < vo.atr.length; i++) attrDt[vo.atr[i]] = vo.value[i];
          target.roleVO.addLockAttr(this._buffId, attrDt);
        }

        /**
         * 移除锁定属性
         */;
        _proto.removeForcedAttr = function removeForcedAttr() {
          this._owner.owner.roleVO.delLockAttr(this._buffId);
        };
        _proto._dealDamage = function _dealDamage(type) {
          if (type === void 0) {
            type = GameBattle.BuffEffectType.Hurt;
          }
          var target = this._owner.owner;
          var exInfo = {
            dmgType: type,
            mltDmg0: this.vo.value[0],
            eleType: this.vo.element,
            skillId: this._skillId
          };
          if (type === GameBattle.BuffEffectType.Hurt2) {
            exInfo.mltDmg1 = exInfo.mltDmg0;
          } else if (type === GameBattle.BuffEffectType.Hurt3) {
            exInfo.mltDmg1 = exInfo.mltDmg0 * (this._owner.owner.roleVO.curLvl1 || 1);
          }
          //支持固定比例伤害类型
          if (type === GameBattle.BuffEffectType.Hurt) {
            if (this.vo.algorithm !== 1) {
              exInfo.dmgType = this.vo.algorithm;
            }
          }
          var FResult;
          FResult = App.battleProprMgr.execBattleFormula(this._source, target, exInfo, null, this._owner.getBuffById(this._buffId));
          var atkF = Number(FResult[0].toFixed(0));
          atkF = atkF < 0 ? 0 : -atkF;
          target.underAttack(atkF, this.vo.element, null, FResult[1]);
        }

        //触发生效
        ;

        _proto.trigger = function trigger() {
          var v = this.vo;
          if (v.type === GameBattle.BuffEffectType.Hurt || v.type === GameBattle.BuffEffectType.Hurt2 || v.type === GameBattle.BuffEffectType.Hurt3) {
            this._dealDamage(v.type);
            // } else if (v.type === GameBattle.BuffEffectType.Hurt2) {
            //     this._dealDamage(GameBattle.BuffEffectType.Hurt2);
            // } else if (v.type === GameBattle.BuffEffectType.Hurt3) {
            //     this._dealDamage(GameBattle.BuffEffectType.Hurt3);
          } else if (v.type === GameBattle.BuffEffectType.AddAttr1) {
            this._addAttr(this._owner.owner, this.vo);
          } else if (v.type === GameBattle.BuffEffectType.AddAttr2) {
            this._addAttr(this._owner.owner, this.vo, this._owner.owner.roleVO.curLvl1 || 1);
          } else if (v.type === GameBattle.BuffEffectType.AddAttr3) {
            this._addAttr(this._owner.owner, this.vo, this._owner.owner.roleVO.curLvl0 || 1);
          } else if (v.type === GameBattle.BuffEffectType.ForcedAttr) {
            this.forcedAttr(this._owner.owner, this.vo);
          } else if (v.type === GameBattle.BuffEffectType.removeBuff) {
            var buff_id = v.value[0];
            this._owner.removeBuffById(buff_id);
            this._owner.owner.roleVO.clrEffcAttr();
          } else if (v.type === GameBattle.BuffEffectType.removeGroupBuff) {
            var group_id = v.value[0];
            this._owner.removeGroupBuff(group_id);
            this._owner.owner.roleVO.clrEffcAttr();
          } else if (v.type === GameBattle.BuffEffectType.AddBuffByOdds) {
            var odds = Number(v.value[0]);
            if (Math.random() * 10000 < odds) {
              // let buff: Buff = this._owner.getBuffById(this._buffId);
              // //对敌光环
              // if (buff.vo.target === GameBattle.BuffTargetType.enemy && buff.vo.type === GameBattle.BuffType.GuangHuan) {
              //     let targets = buff.newTargets;
              //     for (let uid in targets) {
              //         targets[uid]._buffBox.addBuff(Number(v.atr[0]), this._source, this._skillId);
              //     }
              // } else {
              var target = this._owner.owner;
              if (v.target === 2) {
                target = this._source;
              }
              target._buffBox.addBuff(Number(v.atr[0]), this._source, this._skillId);
              // }
            }
          } else if (v.type === GameBattle.BuffEffectType.XiuGaiShuXing) {
            var role = this._owner.owner;
            // 1-技能id 2-子弹id 3-子弹效果id  4-buffid 5-buff效果id
            if (v.grid_type === 1) {
              for (var k = 0; k < v.atr.length; k++) {
                var skill_id = Number(v.atr[k]);
                var skill = App.battleMgr.skillCtrl.getSkill(role.uid, skill_id);
                if (!skill) {
                  skill = App.battleMgr.skillCtrl.getAtkSkill(role.uid);
                  if (skill.skillID !== Number(skill_id)) {
                    continue;
                  }
                }
                if (!skill) continue;
                BuffEffect.setValue(skill, v);
                if (GameConfig.DebugInfo.showBattleReportLog) {
                  console.log("add skill buff", skill, v.configuration);
                }
              }
            } else if (v.grid_type === 2) {
              var skills = App.battleMgr.skillCtrl.getSkills(role.uid);
              var atkSkill = App.battleMgr.skillCtrl.getAtkSkill(role.uid);
              var allSkills = [].concat(skills, [atkSkill]);
              for (var _k = 0; _k < v.atr.length; _k++) {
                var bullet_id = Number(v.atr[_k]);
                for (var i = 0; i < allSkills.length; i++) {
                  var bullet = allSkills[i].bulletVo[bullet_id];
                  if (bullet) {
                    BuffEffect.setValue(bullet, v);
                    if (GameConfig.DebugInfo.showBattleReportLog) {
                      console.log("add bullet buff", allSkills);
                    }
                    return;
                  }
                }
                if (!this._owner.subBulletBuff[bullet_id]) {
                  this._owner.subBulletBuff[bullet_id] = [];
                }
                this._owner.subBulletBuff[bullet_id].push(v);
              }
            } else if (v.grid_type === 3) {
              var _skills = App.battleMgr.skillCtrl.getSkills(role.uid);
              var _atkSkill = App.battleMgr.skillCtrl.getAtkSkill(role.uid);
              var _allSkills = [].concat(_skills, [_atkSkill]);
              //console.log('add bullet 11 effect buff', allSkills);

              for (var _k2 = 0; _k2 < v.atr.length; _k2++) {
                var effect_id = Number(v.atr[_k2]);
                var flag = false;
                for (var _i = 0; _i < _allSkills.length; _i++) {
                  var bullets = _allSkills[_i].bulletVo;
                  for (var key in bullets) {
                    var effect = bullets[key].bulletEffect[effect_id];
                    if (effect) {
                      BuffEffect.setValue(effect, v);
                      //console.log('add bullet 22 effect buff', allSkills);
                      flag = true;
                      break;
                    }
                  }
                }
                if (!flag) {
                  if (!this._owner.subBulletEffectBuff[effect_id]) {
                    this._owner.subBulletEffectBuff[effect_id] = [];
                  }
                  this._owner.subBulletEffectBuff[effect_id].push(v);
                }
              }
            } else if (v.grid_type === 4) {
              var buffBox = role._buffBox;
              for (var _k3 = 0; _k3 < v.atr.length; _k3++) {
                var _buff_id = Number(v.atr[_k3]);
                var _buff = buffBox.getBuffById(_buff_id);
                if (_buff) {
                  BuffEffect.setValue(_buff.vo, v);
                } else {
                  buffBox.addCatchBuff(_buff_id, v);
                }
              }
            } else if (v.grid_type === 5) {
              var buffEffectId = Number(v.atr[0]);
              var _buffBox = role._buffBox;
              _buffBox.addCatchBuffEffect(buffEffectId, v);
              // let allBuffs = buffBox._allBuffs
              // for(let group in allBuffs){
              //     let buffs = allBuffs[group]
              //     for(let buffId in buffs){
              //         let buff = buffs[buffId]
              //         buff.effects.forEach((effect)=>{
              //             if(effect.vo.effectid === buffEffectId){
              //                 BuffEffect.setValue(effect.vo, v);
              //             }
              //         })
              //     }
              // }
            }
          } else if (v.type === GameBattle.BuffEffectType.XuanYun) {
            //目标眩晕
            var _target = this._owner.owner;
            var _buff_id2 = this._buffId;
            var _buff2 = _target._buffBox.getBuffById(_buff_id2);
            _target.roleSkill.XuanYun(_buff2, this);
          } else if (v.type === GameBattle.BuffEffectType.Round) {
            //目标缠绕
            var _target2 = this._owner.owner;
            var _buff_id3 = this._buffId;
            var _buff3 = _target2._buffBox.getBuffById(_buff_id3);
            _target2.roleSkill.Round(_buff3, this);
          } else if (v.type === GameBattle.BuffEffectType.XiuGaiQuanJuShuXing) {
            this.xiuGaiQUanJuShuXing();
          } else if (v.type === GameBattle.BuffEffectType.AddSkillHurtByOdds) {
            this.addSkillHurtByOdds();
          } else if (v.type === GameBattle.BuffEffectType.ConstantlyAttr) {
            this.addConstantlyAttr();
          } else if (v.type === GameBattle.BuffEffectType.KillSelf) {
            this.killSelf();
          } else if (v.type === GameBattle.BuffEffectType.EventBuff) {
            this.addEventBuff();
          } else if (v.type === GameBattle.BuffEffectType.CreateBullet) {
            this.newBullet();
          } else if (v.type === GameBattle.BuffEffectType.ZhiLiao) {
            this.zhiLiao();
          } else if (v.type === GameBattle.BuffEffectType.Bewitch) {
            this.Bewitch();
          } else if (v.type === GameBattle.BuffEffectType.Invulnerable) {
            this.Invulnerable();
          } else if (v.type === GameBattle.BuffEffectType.Scale) {
            this.scaleMonster();
          } else if (v.type === GameBattle.BuffEffectType.RemoveBuff) {
            for (var _iterator = _createForOfIteratorHelperLoose(this.vo.value), _step; !(_step = _iterator()).done;) {
              var _buff_id4 = _step.value;
              this._owner.removeBuffById(_buff_id4);
            }
          } else if (v.type === GameBattle.BuffEffectType.MaBi) {
            var view = this._owner.owner.view;
            var timeScale = this.vo.value[0];
            view.setTimeScale(timeScale);
          }
          var buff = this._owner.getBuffById(this._buffId);
          // target_role.roleSkill.buffEffect(buff, this)
          if (buff && buff.vo.vfx) {
            buff.setBufVfx();
          } else {
            // TODOO 单体治疗buff特效，不影响其他buff，写死
            if (this.vo.vfx === "effect_common_buff_dantizhiliao") {
              this.setBufVfx();
            }
          }
        };
        _proto._addAttr = function _addAttr(target, vo, rate) {
          if (rate === void 0) {
            rate = 1;
          }
          var attrDt = {};
          for (var i = 0; i < vo.atr.length; i++) {
            //501、502两种效果如果是算法2，则在参数的上下限范围内随机
            if (vo.algorithm === 2) {
              var randomRange = Utils.GetRandomNum(vo.value[2 * i], vo.value[2 * i + 1]);
              console.log("buff特效501,增加属性的随机范围:", randomRange);
              attrDt[vo.atr[i]] = randomRange * rate;
            } else {
              attrDt[vo.atr[i]] = vo.value[i] * rate;
            }
          }

          // target.roleVO.addEffcAttr(this.vo.effectid, attrDt);
          //console.log('添加属性', this.vo.atr, this.vo);
          var buff = this._owner.getBuffById(this._buffId);
          if (buff.vo.target === GameBattle.BuffTargetType.self || buff.vo.target === GameBattle.BuffTargetType.selfAndSummon) {
            target.roleVO.addEffcAttr(this.vo.effectid, attrDt);
          }
        };
        _proto.setBufVfx = function setBufVfx() {
          var vo = this.vo;
          if (vo.vfx) {
            var target = this._owner.owner;
            var localPos = target.getLocalMountPoint(vo.dummy_point, Vec3.ZERO);
            var duration = GameBattle.BuffDurationType.Timer;
            var time = 0;
            if (vo.vfx_time === -1) {
              duration = GameBattle.BuffDurationType.Forever;
            } else if (vo.vfx_time > 0) {
              duration = GameBattle.BuffDurationType.Timer;
              time = vo.vfx_time;
            } else if (vo.vfx_time === -2) {
              duration = GameBattle.BuffDurationType.SpineTimer;
              time = 0;
            }
            var gzNode = target.getBuffNode(1);
            App.monitorMgr.dispatchEvent(MonitorType.battle_buff_attack_effect, {
              node: gzNode,
              effect: vo.vfx,
              hit_pos: localPos,
              size: 1,
              duration: duration,
              time: time
            });
          }
        };
        BuffEffect.setValue = function setValue(data, v) {
          var key = v.configuration;
          var calculate = v.calculate;
          var value = v.value;
          if (calculate === GameBattle.BuffEffectCalculate.add) {
            //加法
            if (Array.isArray(data[key])) {
              var temp = data[key];
              for (var i = 0; i < temp.length; i++) {
                temp[i] += Number(value[i]);
              }
              data[key] = temp;
            } else {
              if (Array.isArray(value[key])) {
                data[key] += Number(value[0]);
              } else {
                data[key] += Number(value);
              }
            }
          } else if (calculate === GameBattle.BuffEffectCalculate.mul) {
            //乘法
            if (Array.isArray(data[key])) {
              var _temp = data[key];
              for (var _i2 = 0; _i2 < _temp.length; _i2++) {
                _temp[_i2] *= Number(value[_i2]);
              }
              data[key] = _temp;
            } else {
              if (Array.isArray(value[key])) {
                data[key] *= Number(value[0]);
              } else {
                data[key] *= Number(value);
              }
            }
          } else if (calculate === GameBattle.BuffEffectCalculate.equ) {
            //直接赋值
            if (Array.isArray(data[key])) {
              data[key] = value;
            } else {
              data[key] = value;
            }
          } else if (calculate === GameBattle.BuffEffectCalculate.append) {
            //追加
            if (Array.isArray(data[key])) {
              var _temp2 = data[key];
              _temp2.push.apply(_temp2, value);
              data[key] = _temp2;
            }
          }
        };
        BuffEffect.removeValue = function removeValue(data, v) {
          var key = v.configuration;
          var calculate = v.calculate;
          var value = v.value;
          if (calculate === GameBattle.BuffEffectCalculate.add) {
            //加法 变减法
            if (Array.isArray(data[key])) {
              var temp = data[key];
              for (var i = 0; i < temp.length; i++) {
                temp[i] -= Number(value[i]);
              }
              data[key] = temp;
            } else {
              if (Array.isArray(value[key])) {
                data[key] -= Number(value[0]);
              } else {
                data[key] -= Number(value);
              }
            }
          } else if (calculate === GameBattle.BuffEffectCalculate.mul) {
            //乘法 变除法
            if (Array.isArray(data[key])) {
              var _temp3 = data[key];
              for (var _i3 = 0; _i3 < _temp3.length; _i3++) {
                _temp3[_i3] /= Number(value[_i3]);
              }
              data[key] = _temp3;
            } else {
              if (Array.isArray(value[key])) {
                data[key] /= Number(value[0]);
              } else {
                data[key] /= Number(value);
              }
            }
          } else if (calculate === GameBattle.BuffEffectCalculate.equ) {
            //直接赋值 不能配置
            console.error("时效 buff 配置了直接赋值的类型");
          } else if (calculate === GameBattle.BuffEffectCalculate.append) {
            //追加
            if (Array.isArray(data[key])) {
              var _temp4 = data[key];
              _temp4.push.apply(_temp4, value);
              data[key] = _temp4;
            }
          }
        }

        //删除buff
        //只有增加属性的buff才会扣除增益的属性, 或者返还减益的属性 伤害类或者移除类的buff不需要处理
        ;

        _proto.remove = function remove() {
          var v = this.vo;
          if (v.type === GameBattle.BuffEffectType.AddAttr1) {
            // this._owner.owner.roleVO.delEffcAttr(v.effectid);
            // let attrv = App.battleProprMgr.featchValueById(this.vo.atr[0], this._owner.owner.roleVO);
            //console.log('删除属性', this.vo.atr, attrv, this.vo);

            var buff = this._owner.getBuffById(this._buffId);
            if (buff.vo.target === GameBattle.BuffTargetType.self || buff.vo.target === GameBattle.BuffTargetType.selfAndSummon) {
              this._owner.owner.roleVO.delEffcAttr(v.effectid);
            }
          } else if (v.type === GameBattle.BuffEffectType.AddAttr2) {
            this._owner.owner.roleVO.delEffcAttr(v.effectid);
          } else if (v.type === GameBattle.BuffEffectType.XiuGaiShuXing) {
            var role = this._owner.owner;
            // 1-技能id 2-子弹id 3-子弹效果id  4-buffid 5-buff效果id
            if (v.grid_type === 1) {
              for (var k = 0; k < v.atr.length; k++) {
                var skill_id = Number(v.atr[k]);
                var skill = App.battleMgr.skillCtrl.getSkill(role.uid, skill_id);
                if (!skill) {
                  skill = App.battleMgr.skillCtrl.getAtkSkill(role.uid);
                  if (!skill) continue;
                  if (skill.skillID !== Number(skill_id)) {
                    continue;
                  }
                }
                if (!skill) continue;
                BuffEffect.removeValue(skill, v);
                console.log("remove buff", skill, v.configuration);
              }
            } else if (v.grid_type === 3) {
              var skills = App.battleMgr.skillCtrl.getSkills(role.uid);
              var atkSkill = App.battleMgr.skillCtrl.getAtkSkill(role.uid);
              var allSkills = [].concat(skills, [atkSkill]);
              for (var _k4 = 0; _k4 < v.atr.length; _k4++) {
                var effect_id = Number(v.atr[_k4]);
                for (var i = 0; i < allSkills.length; i++) {
                  var bullets = allSkills[i].bulletVo;
                  for (var key in bullets) {
                    var effect = bullets[key].bulletEffect[effect_id];
                    if (effect) {
                      BuffEffect.removeValue(effect, v);
                      break;
                    }
                  }
                }
              }
            }
          } else if (v.type === GameBattle.BuffEffectType.XiuGaiQuanJuShuXing) {
            this.removeXiuGaiQUanJuShuXing();
          } else if (v.type === GameBattle.BuffEffectType.AddSkillHurtByOdds) {
            this.removeSkillHurtByOdds();
          } else if (v.type === GameBattle.BuffEffectType.ConstantlyAttr) {
            this.removeConstantlyAttr();
          } else if (v.type === GameBattle.BuffEffectType.EventBuff) {
            this.removeEventBuff();
          } else if (v.type === GameBattle.BuffEffectType.Bewitch) {
            this.removeBewitch();
          } else if (v.type === GameBattle.BuffEffectType.ForcedAttr) {
            this.removeForcedAttr();
          } else if (v.type === GameBattle.BuffEffectType.XuanYun) {
            this._owner.owner.pause = false;
            this._owner.owner.openAtk = true;
            this._owner.owner.state.exitType(GameBattle.ActionState.Stun);
            if (this._owner.owner instanceof Monster) {
              this._owner.owner._monsterAI.stateLock = false;
            }
          } else if (v.type === GameBattle.BuffEffectType.Invulnerable) {
            this.removeInvulnerable();
          } else if (v.type === GameBattle.BuffEffectType.Scale) {
            this.removeScaleMonster();
          } else if (v.type === GameBattle.BuffEffectType.MaBi) {
            var view = this._owner.owner.view;
            view.setTimeScale(1);
          }
        };
        _proto.xiuGaiQUanJuShuXing = function xiuGaiQUanJuShuXing() {
          var vo = this.vo;
          var globalData = App.battleMgr.globalData;
          for (var i = 0; i < vo.atr.length; i++) {
            globalData.setData(vo.atr[i], vo.value[i]);
          }
        };
        _proto.removeXiuGaiQUanJuShuXing = function removeXiuGaiQUanJuShuXing() {
          var vo = this.vo;
          var globalData = App.battleMgr.globalData;
          for (var i = 0; i < vo.atr.length; i++) {
            globalData.setData(vo.atr[i], -vo.value[i]);
          }
        };
        _proto.addSkillHurtByOdds = function addSkillHurtByOdds() {
          var vo = this.vo;
          var skillId = vo.atr[0];
          this._owner.addConstantlySkillBuff(skillId, vo);
        };
        _proto.removeSkillHurtByOdds = function removeSkillHurtByOdds() {
          var vo = this.vo;
          var skillId = vo.atr[0];
          this._owner.removeConstantlySkillBuff(skillId);
        };
        _proto.addConstantlyAttr = function addConstantlyAttr() {
          var vo = this.vo;
          var attrId = vo.atr[0];
          this._owner.addConstantlyAttrBuff(attrId, vo);
        };
        _proto.removeConstantlyAttr = function removeConstantlyAttr() {
          var vo = this.vo;
          var attrId = vo.atr[0];
          this._owner.removeConstantlyAttrBuff(attrId);
        };
        _proto.killSelf = function killSelf() {
          this._owner.owner.doDead();
        };
        _proto.addEventBuff = function addEventBuff() {
          var vo = this.vo;
          var eventId = vo.atr[0];
          this._owner.addEventBuff(eventId, vo);
        };
        _proto.removeEventBuff = function removeEventBuff() {
          var vo = this.vo;
          var eventId = vo.atr[0];
          this._owner.removeEventBuff(eventId);
        };
        _proto.newBullet = function newBullet() {
          var ratio = Number(this.vo.value[0]);
          if (Math.random() * 10000 > ratio) return;
          var bullet_id = Number(this.vo.atr[0]);
          var theta = Number(this.vo.value[1]) || 0;
          var count = Number(this.vo.algorithm);
          var cfg = DBRecord.fetchId("JiNengZiDan", bullet_id);
          var bulletVo = new BulletVO();
          bulletVo.load(cfg);
          bulletVo.bulletEffect = {};
          for (var j = 0; j < bulletVo.effect_id.length; j++) {
            var effect_id = bulletVo.effect_id[j];
            bulletVo.bulletEffect[effect_id] = new BulletEffect();
            var cfg2 = DBRecord.fetchId("JiNengXiaoGuo", effect_id);
            bulletVo.bulletEffect[effect_id].load(cfg2);
          }
          var atkSkill = App.battleMgr.skillCtrl.getAtkSkill(this._owner.owner.uid);
          //某些特殊怪物没有普攻（疯狂公牛），取第一个技能，否则创建的子弹没有_targetType
          if (!atkSkill || !atkSkill.skillID) {
            var monster = this._owner.owner;
            if (monster instanceof Monster && monster.roleVO.skillIDList && monster.roleVO.skillIDList.length > 0) {
              atkSkill = App.battleMgr.skillCtrl.getSkill(this._owner.owner.uid, monster.roleVO.skillIDList[0]);
            }
          }
          var hit_point = null;
          var angle = 0;
          if (this.vo.target === 2) {
            hit_point = this._owner.owner.node.worldPosition;
            if (this.vo.value[2]) {
              var target = atkSkill.getTarget();
              if (!target) return;
              var p = atkSkill.getTarget().getHitWorldPosition();
              var dummy_pos = this._owner.owner.getMountPoint(bulletVo.position, this._owner.owner.node.worldPosition);
              angle = BattleUtil.get2DAngleByPoint(dummy_pos, p);
            }
          } else {
            var _target3 = atkSkill.getTarget();
            if (!_target3) return;
            hit_point = atkSkill.getTarget().getHitWorldPosition();
            angle = BattleUtil.get2DAngleByPoint(this._owner.owner.node.worldPosition, hit_point);
          }
          MyBulletLauncher.addSubBullet(bulletVo, atkSkill, hit_point, count, angle, theta);
          this.setBufVfx();
        }

        /** 治疗 */;
        _proto.zhiLiao = function zhiLiao() {
          var value = this.vo.value[0];
          var roleVO = this._owner.owner.roleVO;
          var maxHp = roleVO.getRoleAttr(BattlePropertyName.shengming);
          if (this.vo.calculate === GameBattle.BuffEffectCalculate.mul) {
            value *= maxHp / 10000;
          }
          if (roleVO.curHP + value > maxHp) {
            value = maxHp - roleVO.curHP;
          }
          value = ~~value;
          roleVO.updateCurHP(value);
          this._owner.owner._showDamageTips(value, 0, FormulaResultItem._zhiliao);
          console.log("\u602A\u7269\u83B7\u5F97\u6CBB\u7597buff \u6CBB\u7597\u91CF\u4E3A " + value + " buffid\u4E3A " + this._buffId);
        }

        /**
         * 无敌
         */;
        _proto.Invulnerable = function Invulnerable() {
          var owner = this._owner.owner;
          owner.invulnerable = true;
          console.log("\u73A9\u5BB6\u83B7\u5F97\u65E0\u654Cbuff \u65E0\u654Cbuff\u65F6\u95F4\u4E3A " + this.vo.value + " buffid\u4E3A " + this._buffId);
        }

        /**
         * 移除无敌
         */;
        _proto.removeInvulnerable = function removeInvulnerable() {
          var owner = this._owner.owner;
          owner.invulnerable = false;
          console.log("\u73A9\u5BB6\u8EAB\u4E0A\u7684\u65E0\u654Cbuff\u65F6\u95F4\u7ED3\u675F\u3002\u65F6\u95F4\u4E3A " + this.vo.value + " buffid\u4E3A " + this._buffId);
        }

        /** 魅惑 */;
        _proto.Bewitch = function Bewitch() {
          var _this = this;
          var buff = this._owner.getBuffById(this._buffId);
          var tm = buff.vo.time / 1000;
          var targetPos = this._source.node.worldPosition.clone();
          var node = this._owner.owner.node;
          var self = this._owner.owner;
          self.state.type = GameBattle.ActionState.Bewitch;
          // eslint-disable-next-line @typescript-eslint/no-this-alias
          var that = this;
          var t = tween(node).to(tm, {
            scale_z: 1
          }, {
            onUpdate: function onUpdate(target, ratio) {
              var frameSpeed = self.getFrameSpeed();
              var moveDir = App.mapMgr.getMoveVector(node.worldPosition, targetPos);
              if (moveDir.x === 0 && moveDir.y === 0) {
                //同一个地图坐标格
                if (that._tween) {
                  that._tween = null;
                  self.view.play("Idle", true);
                }
                return;
              }
              var offset = moveDir.clone().multiplyScalar(frameSpeed);
              var pos = node.position.clone();
              var x = offset.x;
              var y = offset.y;
              // 检查新位置是否可移动
              if (!App.mapMgr.checkCanMove(v3(pos.x + x, pos.y + y, 0), true)) {
                if (App.mapMgr.checkCanMove(v3(pos.x + x, pos.y, 0), true)) {
                  y = 0;
                } else if (App.mapMgr.checkCanMove(v3(pos.x, pos.y + y, 0), true)) {
                  x = 0;
                } else {
                  x = 0;
                  y = 0;
                }
              }
              node.setPosition(pos.x + x, pos.y + y, pos.z);
            }
          }).call(function () {
            that._tween = null;
            _this._owner.owner.state.exitType(GameBattle.ActionState.Bewitch);
          }).start();
          this._tween = t;
        }
        /** 移除魅惑 */;
        _proto.removeBewitch = function removeBewitch() {
          if (this._tween) {
            this._tween.stop();
            this._tween = null;
          }
          this._owner.owner.state.exitType(GameBattle.ActionState.Bewitch);
        };
        _proto.scaleMonster = function scaleMonster() {
          var s = Number(this.vo.value[0]) / 10000;
          this._owner.owner.node.setScale(s, s, s);
        };
        _proto.removeScaleMonster = function removeScaleMonster() {
          var s = this._owner.owner.roleVO.size / 10000;
          this._owner.owner.node.setScale(s, s, s);
        };
        return BuffEffect;
      }()) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuildingBase.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './PlaceGameEnum.ts', './App.ts', './PlaceConfigMgr.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Enum, Sprite, Vec2, Node, Vec3, Component, BuildingType, App, PlaceConfigMgr;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Enum = module.Enum;
      Sprite = module.Sprite;
      Vec2 = module.Vec2;
      Node = module.Node;
      Vec3 = module.Vec3;
      Component = module.Component;
    }, function (module) {
      BuildingType = module.BuildingType;
    }, function (module) {
      App = module.App;
    }, function (module) {
      PlaceConfigMgr = module.PlaceConfigMgr;
    }],
    execute: function () {
      var _dec, _dec2, _class, _class2, _descriptor, _descriptor2, _descriptor3;
      cclegacy._RF.push({}, "05326JAIglJ0qxecLFDTcVl", "BuildingBase", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var EditorBuildingType = Enum(BuildingType);

      /**
       * 建筑基类
       */
      var BuildingBase = exports('BuildingBase', (_dec = property({
        type: EditorBuildingType,
        displayName: "建筑类型"
      }), _dec2 = property({
        type: Sprite,
        displayName: "建筑图标"
      }), ccclass(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BuildingBase, _Component);
        function BuildingBase() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /**
           * 建筑序列号（在编辑器中设置）
           */
          _initializerDefineProperty(_this, "buildIndex", _descriptor, _assertThisInitialized(_this));
          /**
           * 建筑类型（在编辑器中设置）
           */
          _initializerDefineProperty(_this, "buildType", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "buildImg", _descriptor3, _assertThisInitialized(_this));
          /**
           * 建筑是否可点击
           */
          _this.clickable = true;
          /**
           * 触摸开始位置
           */
          _this._touchStartPos = new Vec2();
          /**
           * 是否正在拖动
           */
          _this._isDragging = false;
          /**
           * 拖动阈值
           */
          _this.DRAG_THRESHOLD = 10;
          return _this;
        }
        var _proto = BuildingBase.prototype;
        _proto.init = function init() {
          this.setupClickEvent();
        };
        _proto.setupClickEvent = function setupClickEvent() {
          this.node.on(Node.EventType.TOUCH_START, this.onTouchStart, this);
          this.node.on(Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
          this.node.on(Node.EventType.TOUCH_END, this.onTouchEnd, this);
          this.node.on(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
        };
        _proto.onTouchStart = function onTouchStart(event) {
          var touchPos = event.getUILocation();
          this._touchStartPos.set(touchPos.x, touchPos.y);
          this._isDragging = false;
        };
        _proto.onTouchMove = function onTouchMove(event) {
          var touchPos = event.getUILocation();
          var deltaX = touchPos.x - this._touchStartPos.x;
          var deltaY = touchPos.y - this._touchStartPos.y;
          var distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
          if (distance > this.DRAG_THRESHOLD) {
            this._isDragging = true;
          }
        };
        _proto.onTouchEnd = function onTouchEnd(event) {
          var touchPos = event.getUILocation();
          var deltaX = touchPos.x - this._touchStartPos.x;
          var deltaY = touchPos.y - this._touchStartPos.y;
          var distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
          if (this._isDragging || distance > this.DRAG_THRESHOLD) {
            this._isDragging = false;
            return;
          }
          event.propagationStopped = true;
          this.onClick(event);
        }

        /**
         * 点击事件处理
         */;
        _proto.onClick = function onClick(event) {
          if (!this.clickable) return;
          if (this.buildImg && !this.isPointInTexture(event)) return;
          this.onBuildingClick();
        }

        /**
         * 检查点击位置是否在纹理的非透明区域内
         */;
        _proto.isPointInTexture = function isPointInTexture(event) {
          if (!this.buildImg || !this.buildImg.spriteFrame) return true;
          var touchPos = event.getUILocation();
          var touchPosInNode = this.node.uiTransform.convertToNodeSpaceAR(new Vec3(touchPos.x, touchPos.y, 0));
          var spriteSize = this.buildImg.node.uiTransform.contentSize;
          var anchor = this.buildImg.node.uiTransform.anchorPoint;
          var textureWidth = this.buildImg.spriteFrame.width;
          var textureHeight = this.buildImg.spriteFrame.height;
          var textureX = (touchPosInNode.x + anchor.x * spriteSize.width) / spriteSize.width;
          var textureY = (touchPosInNode.y + anchor.y * spriteSize.height) / spriteSize.height;
          if (textureX < 0 || textureX > 1 || textureY < 0 || textureY > 1) {
            return false;
          }
          var pixelX = Math.floor(textureX * textureWidth);
          var pixelY = Math.floor((1 - textureY) * textureHeight);
          return this.checkPixelAlpha(this.buildImg.spriteFrame, pixelX, pixelY);
        }

        /**
         * 检查指定像素位置的透明度
         * @param spriteFrame 精灵帧
         * @param x 像素X坐标
         * @param y 像素Y坐标
         * @returns 是否为非透明像素
         */;
        _proto.checkPixelAlpha = function checkPixelAlpha(spriteFrame, x, y) {
          try {
            var texture = spriteFrame.texture;
            var width = texture.width;
            var height = texture.height;
            var centerX = width / 2;
            var centerY = height / 2;
            var distance = Math.sqrt(Math.pow(x - centerX, 2) + Math.pow(y - centerY, 2));
            var maxDistance = Math.min(width, height) / 2;
            return distance < maxDistance * 1.2;
          } catch (error) {
            console.warn("Failed to check pixel:", error);
            return true;
          }
        }

        /**
         * 升级建筑
         * @param level 目标等级
         * @returns 是否升级成功
         */;
        _proto.upgrade = function upgrade(level) {
          if (this._dataModel) {
            this._dataModel.level = level;
            this.onLevelChanged();
            App.log.logBusiness("\u5EFA\u7B51\u5347\u7EA7: " + this._name + " \u5347\u7EA7\u5230 " + level + " \u7EA7");
            return true;
          }
          return false;
        };
        _proto.setClickable = function setClickable(clickable) {
          this.clickable = clickable;
        };
        _proto.getBuildName = function getBuildName() {
          return PlaceConfigMgr.inst.getJianZhuConfig(this._dataModel.getBuildType()).Name;
        };
        _proto.getPosition = function getPosition() {
          return this._dataModel ? this._dataModel.position : {
            x: 0,
            y: 0
          };
        }

        /**
         * 设置建筑位置
         * @param x x坐标
         * @param y y坐标
         */;
        _proto.setPosition = function setPosition(x, y) {
          if (this._dataModel) {
            this._dataModel.position = {
              x: x,
              y: y
            };
          }
          this.node.setPosition(x, y);
        }

        /**
         * 显示飘字效果
         * @param text 飘字内容
         * @param color 飘字颜色
         */;
        _proto.showPromptText = function showPromptText(text) {
          App.log.logBusiness("\u5EFA\u7B51\u98D8\u5B57: " + text + " (\u5EFA\u7B51: " + this._name + ")");
        }

        /**
         * 更新建筑图标
         */;
        _proto.updateBuildImg = function updateBuildImg() {
          if (this.buildImg) ;
        }

        /**
         * 播放建筑动画
         * @param animName 动画名称
         */;
        _proto.onDestroy = function onDestroy() {
          this.node.off(Node.EventType.TOUCH_START, this.onTouchStart, this);
          this.node.off(Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
          this.node.off(Node.EventType.TOUCH_END, this.onTouchEnd, this);
          this.node.off(Node.EventType.TOUCH_CANCEL, this.onTouchEnd, this);
        };
        return BuildingBase;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "buildIndex", [property], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return 0;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "buildType", [_dec], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return EditorBuildingType.FuHua;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "buildImg", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuildingCtrl.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './FuHuaZhongXin.ts', './BuBingYing.ts', './DiBiao.ts', './MoFang.ts', './PlaceGameMgr.ts', './PlaceGameEnum.ts', './GongBingYing.ts', './QiBingYing.ts', './ZhiHuiBu.ts', './FaMuChang.ts', './CaiKuangChang.ts', './App.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Component, FuHuaZhongXin, BuBingYing, DiBiao, MoFang, PlaceGameMgr, BuildingType, GongBingYing, QiBingYing, ZhiHuiBu, FaMuChang, CaiKuangChang, App;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Component = module.Component;
    }, function (module) {
      FuHuaZhongXin = module.FuHuaZhongXin;
    }, function (module) {
      BuBingYing = module.BuBingYing;
    }, function (module) {
      DiBiao = module.DiBiao;
    }, function (module) {
      MoFang = module.MoFang;
    }, function (module) {
      PlaceGameMgr = module.PlaceGameMgr;
    }, function (module) {
      BuildingType = module.BuildingType;
    }, function (module) {
      GongBingYing = module.GongBingYing;
    }, function (module) {
      QiBingYing = module.QiBingYing;
    }, function (module) {
      ZhiHuiBu = module.ZhiHuiBu;
    }, function (module) {
      FaMuChang = module.FaMuChang;
    }, function (module) {
      CaiKuangChang = module.CaiKuangChang;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _dec5, _dec6, _dec7, _dec8, _dec9, _dec10, _class, _class2, _descriptor, _descriptor2, _descriptor3, _descriptor4, _descriptor5, _descriptor6, _descriptor7, _descriptor8, _descriptor9;
      cclegacy._RF.push({}, "bc3e0xLisFFBJZPl9viUPMD", "BuildingCtrl", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;

      /**
       * 建筑管理器
       * 负责管理所有建筑的创建、升级等操作
       */
      var BuildingCtrl = exports('BuildingCtrl', (_dec = ccclass("BuildingCtrl"), _dec2 = property({
        type: FuHuaZhongXin,
        tooltip: "孵化中心建筑"
      }), _dec3 = property({
        type: BuBingYing,
        tooltip: "步兵兵营建筑"
      }), _dec4 = property({
        type: GongBingYing,
        tooltip: "弓兵兵营建筑"
      }), _dec5 = property({
        type: QiBingYing,
        tooltip: "骑兵兵营建筑"
      }), _dec6 = property({
        type: ZhiHuiBu,
        tooltip: "指挥部建筑"
      }), _dec7 = property({
        type: DiBiao,
        tooltip: "地标建筑"
      }), _dec8 = property({
        type: MoFang,
        tooltip: "磨坊建筑"
      }), _dec9 = property({
        type: FaMuChang,
        tooltip: "伐木场建筑"
      }), _dec10 = property({
        type: CaiKuangChang,
        tooltip: "采矿场建筑"
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BuildingCtrl, _Component);
        function BuildingCtrl() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "fuhuaComp", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "bubingyingComp", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "gongbingyingComp", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "qibingyingComp", _descriptor4, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "zhiHuiBuComp", _descriptor5, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "dibiaoComp", _descriptor6, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "mofangCompArr", _descriptor7, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "famuchangCompArr", _descriptor8, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "caikuangchangCompArr", _descriptor9, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = BuildingCtrl.prototype;
        _proto.onLoad = function onLoad() {
          PlaceGameMgr.inst.setBuildCtrl(this);
          this.initBuilds();
          PlaceGameMgr.inst.loadAutoTrainSettings();
          PlaceGameMgr.inst.moveToBuilding(BuildingType.FuHua, function () {}, false);
        };
        _proto.onDestroy = function onDestroy() {
          App.monitorMgr.offTarget(this);
        };
        _proto.initBuilds = function initBuilds() {
          var _this2 = this;
          // 初始化所有建筑
          if (this.fuhuaComp) {
            var serverData = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === _this2.fuhuaComp.buildType && build.sid === _this2.fuhuaComp.buildIndex;
            });
            this.fuhuaComp.initDataModel(serverData);
          }

          // 初始化步兵营建筑
          if (this.bubingyingComp) {
            var _serverData = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === BuildingType.BuBingYing && build.sid === _this2.bubingyingComp.buildIndex;
            });
            this.bubingyingComp.initDataModel(_serverData);
          }

          // 初始化弓兵营建筑
          if (this.gongbingyingComp) {
            var serverData2 = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === BuildingType.GongBingYing && build.sid === _this2.gongbingyingComp.buildIndex;
            });
            this.gongbingyingComp.initDataModel(serverData2);
          }

          // 初始化骑兵营建筑
          if (this.qibingyingComp) {
            var _serverData2 = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === BuildingType.QiBingYing && build.sid === _this2.qibingyingComp.buildIndex;
            });
            this.qibingyingComp.initDataModel(_serverData2);
          }

          // 初始化指挥中心
          if (this.zhiHuiBuComp) {
            var _serverData3 = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === BuildingType.ZhiHuiBu && build.sid === _this2.zhiHuiBuComp.buildIndex;
            });
            if (_serverData3) {
              this.zhiHuiBuComp.initDataModel(_serverData3);
            }
          }

          // 初始化地标建筑
          if (this.dibiaoComp) {
            var _serverData4 = PlaceGameMgr.inst.buildings.find(function (build) {
              return build.building_id === BuildingType.DiBiao && build.sid === _this2.dibiaoComp.buildIndex;
            });
            this.dibiaoComp.initDataModel(_serverData4);
          }

          // // 初始化磨坊建筑
          // if (this.mofangCompArr) {
          //     for (const comp of this.mofangCompArr) {
          //         let serverData = PlaceGameMgr.inst.buildings.find(build => build.building_id === BuildingType.MoFang && build.sid === comp.buildIndex);
          //         comp.initDataModel(serverData);
          //     }
          // }

          // // 初始化伐木场建筑
          // if (this.famuchangCompArr) {
          //     for (const comp of this.famuchangCompArr) {
          //         let serverData = PlaceGameMgr.inst.buildings.find(build => build.building_id === BuildingType.FaMuChang && build.sid === comp.buildIndex);
          //         comp.initDataModel(serverData);
          //     }
          // }

          // // 初始化采矿场建筑
          // if (this.caikuangchangCompArr) {
          //     for (const comp of this.caikuangchangCompArr) {
          //         let serverData = PlaceGameMgr.inst.buildings.find(build => build.building_id === BuildingType.CaiKuangChang && build.sid === comp.buildIndex);
          //         comp.initDataModel(serverData);
          //     }
          // }
        }

        /**
         * 获取孵化中心节点
         * @returns
         */;
        _proto.getFuHuaComp = function getFuHuaComp() {
          if (!this.fuhuaComp) {
            return null;
          }
          return this.fuhuaComp;
        }

        /**
         * 获取步兵营建筑节点
         * @returns
         */;
        _proto.getBuBingYingComp = function getBuBingYingComp() {
          if (!this.bubingyingComp) {
            return null;
          }
          return this.bubingyingComp;
        }

        /**
         * 获取弓兵营建筑节点
         * @returns
         */;
        _proto.getGongBingYingComp = function getGongBingYingComp() {
          if (!this.gongbingyingComp) {
            return null;
          }
          return this.gongbingyingComp;
        };
        _proto.getQiBingYingComp = function getQiBingYingComp() {
          if (!this.qibingyingComp) {
            return null;
          }
          return this.qibingyingComp;
        }

        /**
         * 获取指挥部建筑节点
         * @returns
         */;
        _proto.getZhiHuiBuComp = function getZhiHuiBuComp() {
          if (!this.zhiHuiBuComp) {
            return null;
          }
          return this.zhiHuiBuComp;
        }

        /**
         * 获取地标建筑节点
         * @returns
         */;
        _proto.getDiBiaoComp = function getDiBiaoComp() {
          if (!this.dibiaoComp) {
            return null;
          }
          return this.dibiaoComp;
        }

        /**
         * 获取磨坊建筑组件
         */;
        _proto.getMoFangComp = function getMoFangComp(buildIndex) {
          if (!this.mofangCompArr || this.mofangCompArr.length === 0) {
            return null;
          }
          if (buildIndex < 1 || buildIndex > this.mofangCompArr.length) {
            return null;
          }
          var comp = this.mofangCompArr[buildIndex - 1];
          if (!comp) {
            return null;
          }
          return comp;
        }

        /**
         * 获取伐木场建筑组件
         */;
        _proto.getFaMuChangComp = function getFaMuChangComp(buildIndex) {
          if (!this.famuchangCompArr || this.famuchangCompArr.length === 0) {
            return null;
          }
          if (buildIndex < 1 || buildIndex > this.famuchangCompArr.length) {
            return null;
          }
          var comp = this.famuchangCompArr[buildIndex - 1];
          if (!comp) {
            return null;
          }
          return comp;
        }

        /**
         * 获取采矿场建筑组件
         */;
        _proto.getCaiKuangChangComp = function getCaiKuangChangComp(buildIndex) {
          if (!this.caikuangchangCompArr || this.caikuangchangCompArr.length === 0) {
            return null;
          }
          if (buildIndex < 1 || buildIndex > this.caikuangchangCompArr.length) {
            return null;
          }
          var comp = this.caikuangchangCompArr[buildIndex - 1];
          if (!comp) {
            return null;
          }
          return comp;
        }

        /**
         * 获取建筑组件
         * @param buildType 建筑类型
         * @param buildIndex 建筑索引
         */;
        _proto.getBuildingComp = function getBuildingComp(buildType, buildIndex) {
          var comp = null;
          switch (buildType) {
            case BuildingType.FuHua:
              // 孵化中心
              comp = this.getFuHuaComp();
              break;
            case BuildingType.ZhiHuiBu:
              // 指挥部
              comp = this.getZhiHuiBuComp();
              break;
            case BuildingType.DiBiao:
              // 地标
              comp = this.getDiBiaoComp();
              break;
            case BuildingType.BuBingYing:
              // 步兵营
              comp = this.getBuBingYingComp();
              break;
            case BuildingType.GongBingYing:
              // 弓兵营
              comp = this.getGongBingYingComp();
              break;
            case BuildingType.QiBingYing:
              // 骑兵营
              comp = this.getQiBingYingComp();
              break;
            case BuildingType.MoFang:
              // 磨坊
              comp = this.getMoFangComp(buildIndex);
              break;
            case BuildingType.FaMuChang:
              // 伐木场
              comp = this.getFaMuChangComp(buildIndex);
              break;
            case BuildingType.CaiKuangChang:
              // 采矿场
              comp = this.getCaiKuangChangComp(buildIndex);
              break;
            default:
              return null;
          }
          return comp;
        };
        return BuildingCtrl;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "fuhuaComp", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "bubingyingComp", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class2.prototype, "gongbingyingComp", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class2.prototype, "qibingyingComp", [_dec5], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor5 = _applyDecoratedDescriptor(_class2.prototype, "zhiHuiBuComp", [_dec6], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor6 = _applyDecoratedDescriptor(_class2.prototype, "dibiaoComp", [_dec7], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor7 = _applyDecoratedDescriptor(_class2.prototype, "mofangCompArr", [_dec8], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _descriptor8 = _applyDecoratedDescriptor(_class2.prototype, "famuchangCompArr", [_dec9], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      }), _descriptor9 = _applyDecoratedDescriptor(_class2.prototype, "caikuangchangCompArr", [_dec10], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return [];
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuildingModel.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './PlaceGameEnum.ts'], function (exports) {
  var _createClass, _extends, cclegacy, BuildingStatus;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
      _extends = module.extends;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      BuildingStatus = module.BuildingStatus;
    }],
    execute: function () {
      cclegacy._RF.push({}, "d17d3aRUcVE4JJ1AGUOK2DL", "BuildingModel", undefined);

      /**
       * 建筑模型基类
       */
      var BuildingModel = exports('BuildingModel', /*#__PURE__*/function () {
        /**
         * 构造函数
         * @param buildingUid 建筑唯一ID（服务器生成）
         * @param level 初始等级
         */
        function BuildingModel(buildIndex, buildType, buildingUid, level, owner) {
          /**
           * 建筑序列号
           */
          this.buildIndex = 0;
          /**
           * 建筑类型
           */
          this.buildType = 0;
          /**
           * 建筑唯一ID（服务器生成）
           */
          this._buildingUid = 0;
          /**
           * 当前等级
           */
          this._level = 0;
          /**
           * 建筑状态
           */
          this._status = BuildingStatus.LOCK;
          /**
           * 建筑位置
           */
          this._position = {
            x: 0,
            y: 0
          };
          /**
           * 是否正在升级（独立于工作状态）
           */
          this._isUpgrading = false;
          /**
           * 服务器返回的建筑数据
           */
          this.serverData = null;
          /**
           * 拥有者
           */
          this.owner = null;
          this.buildIndex = buildIndex;
          this.buildType = buildType;
          this._buildingUid = buildingUid;
          this._level = level;
          this.owner = owner;
        }

        /**
         * 从服务器数据初始化模型
         * @param serverData 服务器返回的建筑数据
         */
        var _proto = BuildingModel.prototype;
        _proto.setServerData = function setServerData(serverData) {
          if (serverData) {
            this.serverData = serverData;
            this._buildingUid = serverData.building_uid;
            this._level = serverData.building_level;
          }
        }

        /**
         * 获取服务器返回的建筑数据
         * @returns 服务器返回的建筑数据
         */;
        _proto.getServerData = function getServerData() {
          return this.serverData;
        }

        /**
         * 获取建筑是否正在升级
         */;
        _proto.getBuildType = function getBuildType() {
          return this.buildType;
        };
        _proto.getBuildIndex = function getBuildIndex() {
          return this.buildIndex;
        }

        /**
         * 判断建筑是否已解锁
         */;
        /**
         * 等级改变时的回调（子类可覆盖）
         */
        _proto.onLevelChanged = function onLevelChanged(newLevel) {
          // 子类可覆盖此方法处理等级改变逻辑
        }

        /**
         * 获取建筑位置
         */;
        _createClass(BuildingModel, [{
          key: "isUpgrading",
          get: function get() {
            return this._isUpgrading;
          },
          set: function set(flag) {
            this._isUpgrading = flag;
          }
        }, {
          key: "isUnlocked",
          get: function get() {
            return this._buildingUid > 0;
          }

          /**
           * 获取建筑唯一ID
           */
        }, {
          key: "buildingUid",
          get: function get() {
            return this._buildingUid;
          }

          /**
           * 设置建筑唯一ID
           */,
          set: function set(value) {
            this._buildingUid = value;
          }

          /**
           * 获取当前等级
           */
        }, {
          key: "level",
          get: function get() {
            return this._level;
          }

          /**
           * 设置等级
           */,
          set: function set(value) {
            this._level = Math.max(0, value);
            this.onLevelChanged(this._level);
          }
        }, {
          key: "position",
          get: function get() {
            return _extends({}, this._position);
          }

          /**
           * 设置建筑位置
           */,
          set: function set(value) {
            this._position = {
              x: value.x,
              y: value.y
            };
          }

          /**
           * 获取建造信息
           */
        }, {
          key: "status",
          get:
          /**
           * 获取建筑状态
           */
          function get() {
            return this._status;
          },
          set: function set(value) {
            this._status = value;
          }
        }]);
        return BuildingModel;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BuildItem.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './PlaceConfigMgr.ts', './UtilGame.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, cclegacy, _decorator, Sprite, Component, PlaceConfigMgr, UtilGame;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      Sprite = module.Sprite;
      Component = module.Component;
    }, function (module) {
      PlaceConfigMgr = module.PlaceConfigMgr;
    }, function (module) {
      UtilGame = module.UtilGame;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _class, _class2, _descriptor, _descriptor2;
      cclegacy._RF.push({}, "2c481N5auVDHbMY43WPiFmo", "BuildItem", undefined);
      var ccclass = _decorator.ccclass,
        property = _decorator.property;
      var BuildItem = exports('BuildItem', (_dec = ccclass("BuildItem"), _dec2 = property({
        type: Sprite,
        displayName: "建筑图标",
        tooltip: "建筑图标"
      }), _dec3 = property({
        type: Sprite,
        displayName: "新标识图标",
        tooltip: "新标识图标"
      }), _dec(_class = (_class2 = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BuildItem, _Component);
        function BuildItem() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          _initializerDefineProperty(_this, "icon", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "newImg", _descriptor2, _assertThisInitialized(_this));
          return _this;
        }
        var _proto = BuildItem.prototype;
        _proto.show = function show(buildType, isNew) {
          if (isNew === void 0) {
            isNew = true;
          }
          if (this.icon) {
            var icon = PlaceConfigMgr.inst.getBuildingIcon(buildType);
            UtilGame.loadBuildIcon(this.icon, icon);
          }
          if (this.newImg) {
            this.newImg.node.active = isNew;
          }
        };
        return BuildItem;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "icon", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor2 = _applyDecoratedDescriptor(_class2.prototype, "newImg", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletAttack.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts'], function (exports) {
  var _createClass, cclegacy, Vec3, App;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
    }, function (module) {
      App = module.App;
    }],
    execute: function () {
      cclegacy._RF.push({}, "65914aZ6P9LG7RG9piKVGOD", "BulletAttack", undefined);

      /** 无穷大数值 */
      var Infinity = -1;

      /**
       * 子弹攻击体类
       */
      var BulletAttack = exports('BulletAttack', /*#__PURE__*/function () {
        function BulletAttack() {
          // /** 形状 */
          // protected _shape: number = 0;
          // public get shape() { return this._shape; }
          // public set shape(v) { this._shape = v; }
          /** 持有者 */
          this._owner = void 0;
          /** 当前穿透数 */
          this._curPenetrateNum = 0;
          /** 当前弹射次数 */
          this._curCatapultNum = 0;
          /** 当前持续时间 */
          this._curDuration = 0;
          /** 是否已结束 */
          this._isEnd = false;
          this.init();
        }
        var _proto = BulletAttack.prototype;
        _proto.reset = function reset() {
          this._isEnd = false;
          this._curPenetrateNum = 0;
          this._curDuration = 0;
          this._curCatapultNum = 0;
        };
        _proto.init = function init() {};
        _proto.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          this._onDuration(dt);
        }

        /**
         * 发射
         */;
        _proto.launch = function launch() {}

        /**
         * 持续时间逻辑
         * @param dt
         * @returns
         */;
        _proto._onDuration = function _onDuration(dt) {
          if (this._checkDuration()) return;
          if (!this.owner.launchered) return;
          var maxNum = this._owner.bulletVO.holding_time;
          this._curDuration += dt;
          this._curDuration = this._curDuration > maxNum ? maxNum : this._curDuration;
          this._updateEnd();
        }

        /**
         * 击中时
         */;
        _proto.onHit = function onHit(target) {
          this._onPenetrate();
          this._updateEnd();
        }

        /**
         * 穿透
         * @returns
         */;
        _proto._onPenetrate = function _onPenetrate() {
          if (this._checkPenetrateNum()) return;
          var maxPenetrateNum = this._owner.bulletVO.penetrate_num;
          this._curPenetrateNum++;
          this._curPenetrateNum = this._curPenetrateNum > maxPenetrateNum ? maxPenetrateNum : this._curPenetrateNum;
        }

        /**
         * 寻找弹射目标
         * @param curTarget 当前作用目标
         * @returns
         */;
        _proto._findCatapultTarget = function _findCatapultTarget(curTarget) {
          var bullet = this._owner;
          var newTarget;
          App.battleMgr.roleCtrl.foreachEntity(this, function (v) {
            if (newTarget) return false;
            if (!bullet.bulletVO.repeat) {
              if (bullet.hitHistoryList.get(v.uid)) return false;
            }
            if (!bullet.checkTargetType(v)) return;
            var distance = Vec3.distance(curTarget.node.worldPosition, v.node.worldPosition);
            if (distance > bullet.bulletVO.catapult_srange) return false;
            newTarget = v;
            return true;
          });
          return newTarget;
        }

        /**
         * 是否持续时间到了
         * @returns
         */;
        _proto._checkDuration = function _checkDuration() {
          var result = true;
          var maxDuration = this._owner.bulletVO.holding_time;
          if (maxDuration === Infinity || maxDuration === -2) {
            // 永久持续时间
            result = false;
          } else {
            result = this._curDuration === maxDuration;
          }
          return result;
        }

        /**
         * 是否达到穿透数量
         * @returns
         */;
        _proto._checkPenetrateNum = function _checkPenetrateNum() {
          var result = true;
          var maxNum = this._owner.bulletVO.penetrate_num;
          if (maxNum === 0) {
            // 无此判定
            result = false;
          } else if (maxNum === Infinity) {
            // 无限数量
            result = false;
          } else {
            result = this._curPenetrateNum === maxNum;
          }
          return result;
        }

        /**
         * 是否达到弹射次数
         * @returns
         */;
        _proto._checkCatapultNum = function _checkCatapultNum() {
          var result = true;
          var maxNum = this._owner.bulletVO.catapults_num;
          if (maxNum === 0) {
            // 无此判定
            result = false;
          } else if (maxNum === Infinity) {
            // 无限数量
            result = false;
          } else {
            result = this._curCatapultNum === maxNum;
          }
          return result;
        };
        _proto._updateEnd = function _updateEnd() {
          this._isEnd = this._checkDuration() || this._checkPenetrateNum() || this._checkCatapultNum();
        };
        _createClass(BulletAttack, [{
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "curPenetrateNum",
          get: function get() {
            return this._curPenetrateNum;
          },
          set: function set(v) {
            this._curPenetrateNum = v;
          }
        }, {
          key: "curCatapultNum",
          get: function get() {
            return this._curCatapultNum;
          },
          set: function set(v) {
            this._curCatapultNum = v;
          }
        }, {
          key: "curDuration",
          get: function get() {
            return this._curDuration;
          },
          set: function set(v) {
            this._curDuration = v;
          }
        }, {
          key: "isEnd",
          get: function get() {
            return this._isEnd;
          },
          set: function set(v) {
            this._isEnd = v;
          }
        }]);
        return BulletAttack;
      }());

      /**
       * 子弹攻击体类 —— 穿透功能
       */
      var BulletAttack_Penetrate = exports('BulletAttack_Penetrate', /*#__PURE__*/function () {
        function BulletAttack_Penetrate() {
          /** 持有者 */
          this._owner = void 0;
          /** 当前穿透数 */
          this._curPenetrateNum = 0;
        }
        var _proto2 = BulletAttack_Penetrate.prototype;
        _proto2.onHit = function onHit() {
          if (this._checkPenetrateNum()) return;
          var maxPenetrateNum = this._owner.bulletVO.penetrate_num;
          this._curPenetrateNum++;
          this._curPenetrateNum = this._curPenetrateNum > maxPenetrateNum ? maxPenetrateNum : this._curPenetrateNum;
        }

        /**
         * 是否达到穿透数量
         * @returns
         */;
        _proto2._checkPenetrateNum = function _checkPenetrateNum() {
          var result = true;
          var maxPenetrateNum = this._owner.bulletVO.penetrate_num;
          if (maxPenetrateNum === Infinity) {
            // 无限数量
            result = false;
          } else {
            result = this._curPenetrateNum === maxPenetrateNum;
          }
          return result;
        };
        _createClass(BulletAttack_Penetrate, [{
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "curPenetrateNum",
          get: function get() {
            return this._curPenetrateNum;
          },
          set: function set(v) {
            this._curPenetrateNum = v;
          }
        }]);
        return BulletAttack_Penetrate;
      }());

      /**
       * 子弹攻击体类 —— 弹射功能
       */
      var BulletAttack_Catapult = exports('BulletAttack_Catapult', /*#__PURE__*/function () {
        function BulletAttack_Catapult() {
          /** 持有者 */
          this._owner = void 0;
          /** 当前弹射次数 */
          this._curCatapultNum = 0;
          /** 是否已结束 */
          this._isEnd = false;
        }
        var _proto3 = BulletAttack_Catapult.prototype;
        /**
         * 是否达到弹射次数
         * @returns
         */
        _proto3._checkCatapultNum = function _checkCatapultNum() {
          var result = true;
          var maxPenetrateNum = this._owner.bulletVO.catapults_num;
          if (maxPenetrateNum === Infinity) {
            // 无限数量
            result = false;
          } else {
            result = this._curCatapultNum === maxPenetrateNum;
          }
          return result;
        };
        _createClass(BulletAttack_Catapult, [{
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "curCatapultNum",
          get: function get() {
            return this._curCatapultNum;
          },
          set: function set(v) {
            this._curCatapultNum = v;
          }
        }, {
          key: "isEnd",
          get: function get() {
            return this._isEnd;
          },
          set: function set(v) {
            this._isEnd = v;
          }
        }]);
        return BulletAttack_Catapult;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletBase.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BulletAttack.ts', './BulletMovement.ts', './BattleDefine.ts', './Utils.ts', './BulletVO.ts', './BulletEffect.ts', './BaseSpine.ts', './GameConfig.ts', './ModuleDef.ts', './BulletMovement_Arrow.ts', './SpineUtils.ts', './MonitorType.ts', './Monster.ts', './Item_BattleMap.ts', './App.ts', './BattleProprMgr.ts', './Hero.ts', './Soldier.ts'], function (exports) {
  var _applyDecoratedDescriptor, _inheritsLoose, _initializerDefineProperty, _assertThisInitialized, _createClass, _asyncToGenerator, _regeneratorRuntime, cclegacy, _decorator, UITransform, Node, Vec2, Vec3, assetManager, sp, Component, Prefab, instantiate, ParticleSystem2D, BulletAttack, BulletMovement, BulletMovement_Line, BulletMovement_Follow, BulletMovement_Bezier, BulletMovement_Round, BulletMovement_FollowOwner, BulletMovement_FollowWeapon, BulletMovement_inCreator, BulletMovement_TanTiao, BulletMovement_RoundBullet, BulletMovement_Lock, BulletMovement_onTarget, BulletMovement_YanZhan, BulletMovement_Warning, BulletMovement_AngularFollow, BulletMovement_HuiXuan, BulletMovement_HanBingJiGuang, BulletMovement_ZhiXianFenLie, BulletMovement_ToPlayer, BulletMovement_HuoYanTuXi, BulletMovement_TanLiQiu, BulletMovement_GuangMangSheXian, BulletMovement_ToOwnerLine, BulletMovement_LeiTingWanJun, BulletMovement_FeiWuLeiHuan, BulletMovement_WorldBossTuXi, BulletMovement_DistanceOffset, BulletMovement_HugeBullet, BulletMovement_FollowMoveDir, BulletMovement_FollowMoveDir2, GameBattle, Utils, BulletVO, BulletEffect_Tigger_Time, BulletEffect, BaseSpine, GameConfig, ModuleDef, BulletMovement_Arrow, SpineUtils, MonitorType, Monster, Item_BattleMap, App, BattlePropertyName, Hero, Soldier;
  return {
    setters: [function (module) {
      _applyDecoratedDescriptor = module.applyDecoratedDescriptor;
      _inheritsLoose = module.inheritsLoose;
      _initializerDefineProperty = module.initializerDefineProperty;
      _assertThisInitialized = module.assertThisInitialized;
      _createClass = module.createClass;
      _asyncToGenerator = module.asyncToGenerator;
      _regeneratorRuntime = module.regeneratorRuntime;
    }, function (module) {
      cclegacy = module.cclegacy;
      _decorator = module._decorator;
      UITransform = module.UITransform;
      Node = module.Node;
      Vec2 = module.Vec2;
      Vec3 = module.Vec3;
      assetManager = module.assetManager;
      sp = module.sp;
      Component = module.Component;
      Prefab = module.Prefab;
      instantiate = module.instantiate;
      ParticleSystem2D = module.ParticleSystem2D;
    }, function (module) {
      BulletAttack = module.BulletAttack;
    }, function (module) {
      BulletMovement = module.BulletMovement;
      BulletMovement_Line = module.BulletMovement_Line;
      BulletMovement_Follow = module.BulletMovement_Follow;
      BulletMovement_Bezier = module.BulletMovement_Bezier;
      BulletMovement_Round = module.BulletMovement_Round;
      BulletMovement_FollowOwner = module.BulletMovement_FollowOwner;
      BulletMovement_FollowWeapon = module.BulletMovement_FollowWeapon;
      BulletMovement_inCreator = module.BulletMovement_inCreator;
      BulletMovement_TanTiao = module.BulletMovement_TanTiao;
      BulletMovement_RoundBullet = module.BulletMovement_RoundBullet;
      BulletMovement_Lock = module.BulletMovement_Lock;
      BulletMovement_onTarget = module.BulletMovement_onTarget;
      BulletMovement_YanZhan = module.BulletMovement_YanZhan;
      BulletMovement_Warning = module.BulletMovement_Warning;
      BulletMovement_AngularFollow = module.BulletMovement_AngularFollow;
      BulletMovement_HuiXuan = module.BulletMovement_HuiXuan;
      BulletMovement_HanBingJiGuang = module.BulletMovement_HanBingJiGuang;
      BulletMovement_ZhiXianFenLie = module.BulletMovement_ZhiXianFenLie;
      BulletMovement_ToPlayer = module.BulletMovement_ToPlayer;
      BulletMovement_HuoYanTuXi = module.BulletMovement_HuoYanTuXi;
      BulletMovement_TanLiQiu = module.BulletMovement_TanLiQiu;
      BulletMovement_GuangMangSheXian = module.BulletMovement_GuangMangSheXian;
      BulletMovement_ToOwnerLine = module.BulletMovement_ToOwnerLine;
      BulletMovement_LeiTingWanJun = module.BulletMovement_LeiTingWanJun;
      BulletMovement_FeiWuLeiHuan = module.BulletMovement_FeiWuLeiHuan;
      BulletMovement_WorldBossTuXi = module.BulletMovement_WorldBossTuXi;
      BulletMovement_DistanceOffset = module.BulletMovement_DistanceOffset;
      BulletMovement_HugeBullet = module.BulletMovement_HugeBullet;
      BulletMovement_FollowMoveDir = module.BulletMovement_FollowMoveDir;
      BulletMovement_FollowMoveDir2 = module.BulletMovement_FollowMoveDir2;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      BulletVO = module.BulletVO;
    }, function (module) {
      BulletEffect_Tigger_Time = module.BulletEffect_Tigger_Time;
      BulletEffect = module.BulletEffect;
    }, function (module) {
      BaseSpine = module.BaseSpine;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      BulletMovement_Arrow = module.BulletMovement_Arrow;
    }, function (module) {
      SpineUtils = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      Monster = module.Monster;
    }, function (module) {
      Item_BattleMap = module.Item_BattleMap;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
    }, function (module) {
      Hero = module.Hero;
    }, function (module) {
      Soldier = module.Soldier;
    }],
    execute: function () {
      var _dec, _dec2, _dec3, _dec4, _class, _descriptor, _descriptor2, _descriptor3, _descriptor4;
      cclegacy._RF.push({}, "e9e53pOmmVFhZu9bx9XPBXe", "BulletBase", undefined);
      var property = _decorator.property;

      /**
       * 子弹基类
       */
      var BulletBase = exports('BulletBase', (_dec = property({
        type: BaseSpine
      }), _dec2 = property(UITransform), _dec3 = property(Node), _dec4 = property(Node), (_class = /*#__PURE__*/function (_Component) {
        _inheritsLoose(BulletBase, _Component);
        function BulletBase() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _Component.call.apply(_Component, [this].concat(args)) || this;
          /** 外观 */
          _initializerDefineProperty(_this, "view", _descriptor, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "hitBox", _descriptor2, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "splashRect", _descriptor3, _assertThisInitialized(_this));
          _initializerDefineProperty(_this, "splashRound", _descriptor4, _assertThisInitialized(_this));
          /** 运动器 */
          _this._bulletMovement = new BulletMovement();
          /** 攻击体 */
          _this._bulletAttack = new BulletAttack();
          /** 子弹效果 */
          _this.bulletEffect = [];
          _this.bulletVO = new BulletVO();
          /** 当前击中的目标列表 */
          _this._curHitList = new Map();
          /** 已击中的目标列表 */
          _this._hitHistoryList = new Map();
          /** 子弹类型 */
          _this._type = GameBattle.BulletType.None;
          /** 唯一id */
          _this._uid = 0;
          /** 持有者 */
          _this._owner = void 0;
          /** 目标 */
          _this._target = void 0;
          /** 技能实体 */
          _this._skill = void 0;
          /** 速度(每秒移速) */
          _this._speed = 0;
          /** 是否已结束 */
          _this._isEnd = false;
          /** 发射时间 */
          _this._launcherTime = 0;
          /** 发坐标偏移 */
          _this._startPosOffset = Vec2.ZERO;
          /** 朝向偏移*/
          _this._orientationOffset = Vec2.ZERO;
          /** 发射方式 */
          _this._launcherType = 0;
          /** 子弹个数 */
          _this._bullteCount = 0;
          /** 延迟时间 */
          _this._launcherDelayTime = 0.2;
          /** 是否已经发射(新的子弹发射器需要延迟发射) */
          _this._launchered = false;
          _this._triggerMap = {};
          _this._targetType = 0;
          /** 起始位置 */
          _this._startPosition = new Vec3();
          _this.masterId = 0;
          //召唤物子弹的主人ID（召唤物在发射子弹后自身被回收后就无法从召唤物的实体中获取属性了， 所以在这缓存该属性）
          _this._total_Trigger_num = 0;
          //子弹的总生效次数
          _this._total_PenetrateNum = 0;
          //子弹的总穿透次数
          _this._endTigger = false;
          _this.defaultName = "";
          // 句柄分离 避免干扰
          _this._startTaskId = null;
          _this._loopTaskId = null;
          _this._endTaskId = null;
          _this._dt = 0;
          // 子弹碰撞降帧幅度
          _this._dtUpdateTime = 0.04;
          /**处于技能发射次数中的第几次 */
          _this.indexInSkill = 0;
          // 奇偶帧分组
          _this._bulletGroup = 0;
          /** 临时向量,用于update中的向量计算，避免频繁创建临时向量 */
          _this.tempVec = new Vec3();
          /** 临时向量,用于圆形碰撞检测，避免频繁创建临时向量 */
          _this.tempVecRound = new Vec3();
          /**初始ownerId */
          _this.initOwnerId = 0;
          /**是否玩家召唤物的子弹 */
          _this.isPlayerSummonBullet = false;
          /** 初始owner的属性 */
          _this.initOwnerFullAttr = {};
          /** 初始owner的属性 */
          _this.initOwnerLockAttr = {};
          return _this;
        }
        var _proto = BulletBase.prototype;
        /**
         * 额外的初始化，处理创建子弹后owner被回收重用的问题
         * @param owner
         * @returns
         */
        _proto.exendInit = function exendInit(owner) {
          if (!owner) {
            return;
          }
          if (owner.type === GameBattle.RoleType.Monster) {
            var vo = owner.roleVO;
            if (vo) {
              this.initOwnerId = vo.id;
              this.initOwnerFullAttr = Utils.copyObj(vo.getFullAttr());
              var lockAttr = vo.getLockAttr();
              if (lockAttr && typeof lockAttr === "object") {
                this.initOwnerLockAttr = Utils.copyObj(lockAttr);
              } else {
                this.initOwnerLockAttr = {};
              }
            }
            //console.log('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR exendInit', this.bulletVO.bulletID, this.initOwnerId, this.isPlayerSummonBullet);
          }
        }

        /**
         * 子弹owner是否被回收后重用成别的怪物
         * @returns
         */;
        _proto.checkOwnerError = function checkOwnerError() {
          if (!this.owner || !this.initOwnerId) {
            return false;
          }
          var vo = this.owner.roleVO;
          if (vo && this.initOwnerId !== vo.id) {
            return true;
          }
          return false;
        };
        _proto.onUpdate = function onUpdate(dt) {
          if (!this.checkValid()) return;
          if (this.bulletVO.waiting_move_time > 0) {
            this.bulletVO.waiting_move_time -= dt;
          } else {
            this._bulletMovement.onUpdate(dt);
          }
          if (this.bulletVO.waiting_time > 0) {
            this.bulletVO.waiting_time -= dt;
            this.setHitBoxVisible(this.bulletVO.waiting_time <= 0);
          } else {
            if (this._checkEnd()) {
              if (this.bulletVO.holding_time !== -2) {
                this.end();
              }
            } else {
              this._dt += dt;
              this.updateScale(dt);
              // if (!this._endTigger && this._dt > this._dtUpdateTime) {
              if (App.battleMgr.getCurrentFrame() === this._bulletGroup) {
                this._bulletAttack.onUpdate(this._dt);
                this._updateHitListOld();
                this._updateHitHistory(this._dt);
                this._dt = 0;
                // }
              }
            }
          }
        }

        /**
         * 对象池再利用
         */;
        _proto.reuse = function reuse() {
          this.init();
        }

        /**
         * 对象池回收
         */;
        _proto.recovery = function recovery() {
          this.reset();
        };
        _proto.clearAllSchedules = function clearAllSchedules() {
          if (this._startTaskId) {
            App.scheduleMgr.unschedule(this._startTaskId);
            this._startTaskId = null;
          }
          if (this._loopTaskId) {
            App.scheduleMgr.unschedule(this._loopTaskId);
            this._loopTaskId = null;
          }
          if (this._endTaskId) {
            App.scheduleMgr.unschedule(this._endTaskId);
            this._endTaskId = null;
          }
        }

        /**
         * 结束
         */;
        _proto.end = function end() {
          var _this2 = this;
          if (this._endTaskId !== null && this._endTaskId !== "") {
            //console.log('已经有计时器存在,等待播放动画完成后回收节点');
            return;
          }
          for (var i = 0; i < this.bulletEffect.length; i++) {
            this.bulletEffect[i].launch(this._skill.getTarget(), 0, BulletEffect_Tigger_Time.end);
          }
          if (this.view.node.active) {
            var hadEnd = SpineUtils.checkAnimaionByName(this.view.skeleton, "End");
            if (hadEnd) {
              var endDuration = SpineUtils.getAnimationDuration(this.view.skeleton, "End");
              this._endTaskId = App.scheduleMgr.scheduleOnce(function () {
                var _this2$view;
                _this2._endTaskId = null;
                if (!((_this2$view = _this2.view) != null && _this2$view.isValid)) return;
                App.battleMgr.bulletCtrl.recovery(_this2);
              }, this, endDuration);
              this.view.play("End", false);
            } else {
              this.view.clearAllAnimation();
              this.view.node.active = false;
              App.battleMgr.bulletCtrl.recovery(this);
            }
          } else {
            App.battleMgr.bulletCtrl.recovery(this);
          }
        };
        _proto.init = function init() {
          this._bulletGroup = Math.floor(Math.random() * 2);
          this.defaultName = "";
          this.clearAllSchedules();
          if (this.view) {
            this.view.clearAllAnimation();
            this.view.node.active = false;
          }
          this.initOwnerId = 0;
          this.isPlayerSummonBullet = false;
          this.initOwnerFullAttr = {};
          this.initOwnerLockAttr = {};
        }

        // static bulletSpine = {};
        ;

        _proto.asyncLoadSpine = function asyncLoadSpine() {
          var _this3 = this;
          // if (BulletBase.bulletSpine[this.bulletVO.viewPath]) {
          //     return BulletBase.bulletSpine[this.bulletVO.viewPath];
          // }
          var bundle = assetManager.getBundle(ModuleDef.BULLET_EFFECT);
          // if (GameConfig.DebugInfo.showBulletAniLog) {
          //     console.log('加载子弹动画', this.bulletVO.viewPath);
          // }

          return new Promise(function (resolve, reject) {
            bundle.load(_this3.bulletVO.viewPath + "/" + _this3.bulletVO.viewPath, sp.SkeletonData, null, function (err, asset) {
              if (err) {
                reject(_this3.bulletVO.viewPath + " \u5B50\u5F39\u8D44\u6E90\u52A0\u8F7D\u5931\u8D25");
                return;
              }
              // if (GameConfig.DebugInfo.showBulletAniLog) {
              //     console.log('子弹动画加载完成', this.bulletVO.viewPath);
              // }
              // BulletBase.bulletSpine[this.bulletVO.viewPath] = asset;
              resolve(asset);
            });
          });
        };
        _proto.load = /*#__PURE__*/function () {
          var _load = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(bulletVo) {
            var _this4 = this;
            var i, attachment, path;
            return _regeneratorRuntime().wrap(function _callee$(_context) {
              while (1) switch (_context.prev = _context.next) {
                case 0:
                  this.bulletVO.set(bulletVo);
                  if (this.bulletVO.moveType === GameBattle.BulletMoveType.Line) {
                    this._bulletMovement = new BulletMovement_Line();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Follow) {
                    this._bulletMovement = new BulletMovement_Follow();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Bezier) {
                    this._bulletMovement = new BulletMovement_Bezier();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Round) {
                    this._bulletMovement = new BulletMovement_Round();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.FollowOwner) {
                    this._bulletMovement = new BulletMovement_FollowOwner();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.FollowWeapon) {
                    this._bulletMovement = new BulletMovement_FollowWeapon();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Arrow) {
                    this._bulletMovement = new BulletMovement_Arrow();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.ShiBi) ;else if (this.bulletVO.moveType === GameBattle.BulletMoveType.InCreator || this.bulletVO.moveType === GameBattle.BulletMoveType.InCreatorTaiDao) {
                    this._bulletMovement = new BulletMovement_inCreator();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.TanTiao) {
                    this._bulletMovement = new BulletMovement_TanTiao();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.RoundBullet) {
                    this._bulletMovement = new BulletMovement_RoundBullet();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Lock) {
                    this._bulletMovement = new BulletMovement_Lock();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.onTarget) {
                    this._bulletMovement = new BulletMovement_onTarget();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.yanZHan) {
                    this._bulletMovement = new BulletMovement_YanZhan();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.Warning) {
                    this._bulletMovement = new BulletMovement_Warning();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.AngularFollow) {
                    this._bulletMovement = new BulletMovement_AngularFollow();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.HuiXuan) {
                    this._bulletMovement = new BulletMovement_HuiXuan();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.HanBingJiGuang) {
                    this._bulletMovement = new BulletMovement_HanBingJiGuang();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.ZhiXianFenLie) {
                    this._bulletMovement = new BulletMovement_ZhiXianFenLie();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.ToPlayer) {
                    this._bulletMovement = new BulletMovement_ToPlayer();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.HuoYanTuXi) {
                    this._bulletMovement = new BulletMovement_HuoYanTuXi();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.TanLiQiu) {
                    this._bulletMovement = new BulletMovement_TanLiQiu();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.GuangMangSheXian) {
                    this._bulletMovement = new BulletMovement_GuangMangSheXian();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.ToOwnerLine) {
                    this._bulletMovement = new BulletMovement_ToOwnerLine();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.LeiTingWanJun) {
                    this._bulletMovement = new BulletMovement_LeiTingWanJun();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.FeiWuLeiHuan) {
                    this._bulletMovement = new BulletMovement_FeiWuLeiHuan();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.WorldBossTuXi) {
                    this._bulletMovement = new BulletMovement_WorldBossTuXi();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.DistanceOffset) {
                    this._bulletMovement = new BulletMovement_DistanceOffset();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.HugeBullet) {
                    this._bulletMovement = new BulletMovement_HugeBullet();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.FollowMoveDir) {
                    this._bulletMovement = new BulletMovement_FollowMoveDir();
                  } else if (this.bulletVO.moveType === GameBattle.BulletMoveType.FollowMoveDir2) {
                    this._bulletMovement = new BulletMovement_FollowMoveDir2();
                  }
                  // this._bulletLauncher.owner = this;
                  this._bulletMovement.owner = this;
                  this._bulletAttack.owner = this;
                  this.bulletEffect = [];
                  for (i = 0; i < bulletVo.effect_id.length; i++) {
                    this.bulletEffect[i] = new BulletEffect();
                    this.bulletEffect[i].set(bulletVo.bulletEffect[bulletVo.effect_id[i]]);
                    this.bulletEffect[i].owner = this;
                  }
                  if (!this.view) {
                    _context.next = 24;
                    break;
                  }
                  this.view.skeleton.skeletonData = null;
                  if (!(this.bulletVO.viewPath.length > 0)) {
                    _context.next = 23;
                    break;
                  }
                  this.view.clearAllHandler();
                  this.view.clearAllAnimation();
                  this.view.node.active = true;
                  if (!Item_BattleMap.bulletAsset[this.bulletVO.viewPath]) {
                    _context.next = 16;
                    break;
                  }
                  this.view.skeleton.skeletonData = Item_BattleMap.bulletAsset[this.bulletVO.viewPath];
                  _context.next = 20;
                  break;
                case 16:
                  _context.next = 18;
                  return this.asyncLoadSpine();
                case 18:
                  this.view.skeleton.skeletonData = _context.sent;
                  if (App.battleMgr.isInBattle() && this.view.skeleton.skeletonData && !Item_BattleMap.bulletAsset[this.bulletVO.viewPath]) {
                    console.log("================================>>TEST BULLET 子弹动画加载完成:", bulletVo.bulletID, this.bulletVO.viewPath);
                    Item_BattleMap.bulletAsset[this.bulletVO.viewPath] = this.view.skeleton.skeletonData;
                  }
                case 20:
                  this.view.skeleton.paused = false;
                  _context.next = 24;
                  break;
                case 23:
                  this.view.node.active = false;
                case 24:
                  this.hitBox.setAnchorPoint(bulletVo.angle_point[0], bulletVo.angle_point[1]);
                  if (this.bulletVO.crash_box_type === GameBattle.BulletHitShape.Round) {
                    this.hitBox.width = bulletVo.crash_box[0];
                    this.hitBox.height = bulletVo.crash_box[0];
                  } else {
                    this.hitBox.width = bulletVo.crash_box[0];
                    this.hitBox.height = bulletVo.crash_box[1];
                  }
                  {
                    this.splashRect.active = false;
                    this.splashRound.active = false;
                  }
                  // 测试用
                  {
                    if (GameConfig.DebugInfo.showBulletBox) {
                      this.hitBox.node.children[0].active = GameConfig.DebugInfo.showBulletBox;
                    } else {
                      if (this._owner instanceof Hero) {
                        this.hitBox.node.children[0].active = GameConfig.DebugInfo.showHeroHit;
                      } else if (this._owner instanceof Soldier) {
                        this.hitBox.node.children[0].active = GameConfig.DebugInfo.showSoldierHit;
                      } else if (this._owner instanceof Monster) {
                        this.hitBox.node.children[0].active = GameConfig.DebugInfo.showMonsterHit;
                      }
                    }
                  }
                  attachment = this.node.getChildByName("attachment");
                  if (this.bulletVO.attachment) {
                    attachment.active = true;
                    attachment.removeAllChildren();
                    path = "prefabs/scene/bullet/" + this.bulletVO.attachment;
                    App.resMgr.loadAsset(ModuleDef.GAME_BATTLE_B, path, Prefab, null, function (err, res) {
                      if (err) {
                        console.error(err);
                        return;
                      }
                      var node = instantiate(res);
                      _this4.node.getChildByName("attachment").addChild(node);
                      node.setPosition(0, 0, 0);
                      if (bulletVo.volume !== 1) {
                        var lizi = node.getChildByName("lz").getComponent(ParticleSystem2D);
                        lizi.startSize *= bulletVo.volume;
                        lizi.endSize *= bulletVo.volume;
                        lizi.speed *= bulletVo.volume;
                      }
                    });
                  } else {
                    attachment.active = false;
                  }
                  this.node.setScale(bulletVo.volume, bulletVo.volume, bulletVo.volume);
                  this._total_Trigger_num = bulletVo.Trigger_num;
                  this._total_PenetrateNum = bulletVo.penetrate_num;
                  if (bulletVo.penetrate_num === -1) {
                    this._total_PenetrateNum = Infinity;
                  }
                  this._endTigger = this.bulletEffect.length === 1 && this.bulletEffect[0].before_or_after === BulletEffect_Tigger_Time.end;
                  this.isEnd = false;
                case 36:
                case "end":
                  return _context.stop();
              }
            }, _callee, this);
          }));
          function load(_x2) {
            return _load.apply(this, arguments);
          }
          return load;
        }();
        _proto.reset = function reset() {
          var _this$_bulletMovement, _this$_bulletAttack, _this$bulletVO, _this$_curHitList, _this$_hitHistoryList;
          this.clearAllSchedules();
          if (this.view) {
            this.view.node.active = false;
          }
          this._skill = null;
          // this.view.skeleton.skeletonData = null;
          // this._bulletLauncher.reset();
          (_this$_bulletMovement = this._bulletMovement) == null || _this$_bulletMovement.reset();
          (_this$_bulletAttack = this._bulletAttack) == null || _this$_bulletAttack.reset();
          (_this$bulletVO = this.bulletVO) == null || _this$bulletVO.reset();
          (_this$_curHitList = this._curHitList) == null || _this$_curHitList.clear();
          (_this$_hitHistoryList = this._hitHistoryList) == null || _this$_hitHistoryList.clear();
          this._triggerMap = {};
          this.defaultName = "";
          this.isEnd = true;
          this.startPosition.set(0, 0, 0);
          this.node.position = new Vec3(0, 0, 0);
          this.initOwnerId = 0;
          this.isPlayerSummonBullet = false;
          this.initOwnerFullAttr = {};
          this.initOwnerLockAttr = {};
        }

        /**
         * 检测有效性
         * @returns
         */;
        _proto.checkValid = function checkValid() {
          var result = false;
          do {
            if (!this._launchered) break;
            if (this._isEnd) break;
            if (!this._owner) break;
            if (!this.node.parent) break;
            result = true;
          } while (false);
          return result;
        }

        /**
         * 发射
         */;
        _proto.launch = function launch(bulletLauncherData) {
          this._owner._buffBox.triggerEventBuff(GameBattle.EventBuffId.bulletLaunch, this.bulletVO.bulletID);
          // if (GameConfig.DebugInfo.showBulletBox) {
          //     console.log(`子弹[${this.node.name}] 初始化位置(${this.node.worldPosition.x.toFixed(2)}, ${this.node.worldPosition.y.toFixed(2)})`);
          //     console.log(`子弹[${this.node.name}] 碰撞盒大小: ${this.hitBox.width.toFixed(2)} x ${this.hitBox.height.toFixed(2)}`);
          // }
          // 设置持续时间和播放动画
          this.playStartAnim();
          this._targetType = this._skill.targetType;
          this._bulletMovement.launch(bulletLauncherData);
          this._bulletAttack.launch();
          for (var i = 0; i < this.bulletEffect.length; i++) {
            this.bulletEffect[i].launch(this._skill.getTarget(), 0, BulletEffect_Tigger_Time.before);
          }

          // let master = App.battleMgr.roleCtrl.getRole(this.owner.masterId);
          if (this.bulletVO.bulletID === 40010) {
            //没有索敌类型是自己的子弹, 暂时写死 生存模式用的
            this._targetType = GameBattle.SkillApplyTarget.Self;
          }
          this.startPosition.set(this.node.worldPosition);
          if (this.bulletVO.bullet_sound) {
            App.soundMgr.playEffect(this.bulletVO.bullet_sound);
          }
        }

        /**
         * 命中
         * @target 击中目标
         * @count 此次集中个数
         */;
        _proto.hit = function hit(target, count) {
          for (var i = 0; i < this.bulletEffect.length; i++) {
            this.bulletEffect[i].launch(target, count, BulletEffect_Tigger_Time.hit);
          }
          this._bulletAttack.onHit(target);
          this._bulletMovement.onHit(target);
          if (this.bulletVO.sound && this.bulletVO.sound !== "") {
            App.soundMgr.playEffect(this.bulletVO.sound);
          }
          if (this.bulletVO.hit_effect) {
            // 3、弹出伤害
            var pos = target.getHitPosition();
            var size = 1;
            if (target instanceof Monster) {
              var vo = target.roleVO;
              size = Math.max(vo.crash_box[0], vo.crash_box[1]) / 100;
            }
            App.monitorMgr.dispatchEvent(MonitorType.battle_gun_weapon_attack_affected, {
              node: target.affected,
              effect: this.bulletVO.hit_effect,
              hit_pos: pos,
              size: size
            });
          }
          //如果是弹射子弹只需要记录一个
          if (this.bulletVO.repeat) {
            this._hitHistoryList.clear();
            this._hitHistoryList.set(target.uid, target);
          }
          var owner = this.owner;
          if (owner && owner.checkValid() && !this.checkOwnerError() && owner._buffBox && App.battleMgr.isInBattle()) {
            owner._buffBox.triggerEventBuff(GameBattle.EventBuffId.HitEnemy, undefined, target);
          }
        }

        /**
         * 获取世界坐标系下包围盒
         * @returns
         */;
        _proto.getBoundingBoxToWorld = function getBoundingBoxToWorld() {
          return this.hitBox.getBoundingBoxToWorld();
        }

        /**
         * 获取世界坐标系下圆形碰撞盒的圆心和半径
         * @returns
         */;
        _proto.getRoundToWorld = function getRoundToWorld() {
          var anchorX = this.hitBox.anchorX;
          var anchorY = this.hitBox.anchorY;
          // 计算中心点相对于锚点的偏移
          var offsetX = (0.5 - anchorX) * this.hitBox.width;
          var offsetY = (0.5 - anchorY) * this.hitBox.height;
          // const localCenter = new Vec3(offsetX, offsetY, 0);
          // let center = this.hitBox.convertToWorldSpaceAR(localCenter,this.tempVec);
          this.tempVecRound.x = offsetX;
          this.tempVecRound.y = offsetY;
          this.hitBox.convertToWorldSpaceAR(this.tempVecRound, this.tempVecRound);
          var center = this.tempVecRound;
          return {
            center: center,
            radius: this.hitBox.width / 2
          };
        }

        /**
         * 检测圆形和矩形的碰撞
         * @param round
         * @param rect
         * @returns
         */;
        _proto.checkCollideRoundAndRect = function checkCollideRoundAndRect(round, rect) {
          var x = round.center.x;
          var y = round.center.y;
          // 快速检测1：AABB不相交
          if (x + round.radius < rect.x || x - round.radius > rect.x + rect.width || y + round.radius < rect.y || y - round.radius > rect.y + rect.height) {
            return false;
          }

          // 快速检测2：圆心在矩形内
          if (x >= rect.x && x <= rect.x + rect.width && y >= rect.y && y <= rect.y + rect.height) {
            return true;
          }

          // 找到矩形上离圆心最近的点
          var closestX = Math.max(rect.x, Math.min(x, rect.x + rect.width));
          var closestY = Math.max(rect.y, Math.min(y, rect.y + rect.height));

          // 计算圆心到最近点的距离
          var distanceX = x - closestX;
          var distanceY = y - closestY;

          //console.log("******===",round.radius,distanceX,distanceY,Math.sqrt(distanceX * distanceX + distanceY * distanceY));
          var result = distanceX * distanceX + distanceY * distanceY <= round.radius * round.radius;
          return result;
        }

        /**
         * 碰撞检测
         * @returns
         */;
        _proto.checkHit = function checkHit(target) {
          var selfBox = this.getBoundingBoxToWorld();
          this.tempVec.set(target.node.worldPosition.x, target.node.worldPosition.y, 0);
          var targetPos = new Vec2(target.node.worldPosition.x, target.node.worldPosition.y);
          var hitPos = target.getHitPosition();
          targetPos.add2f(hitPos.x, hitPos.y);

          // if (GameConfig.DebugInfo.showBulletBox) {
          //     console.log(`子弹[${this.node.name}] 碰撞检测:
          //         子弹碰撞盒: x=${selfBox.x.toFixed(2)}, y=${selfBox.y.toFixed(2)}, w=${selfBox.width.toFixed(2)}, h=${selfBox.height.toFixed(2)}
          //         目标位置: x=${targetPos.x.toFixed(2)}, y=${targetPos.y.toFixed(2)}
          //         目标偏移: x=${hitPos.x.toFixed(2)}, y=${hitPos.y.toFixed(2)}`);
          // }

          return selfBox.contains(targetPos);
        };
        _proto._updateHitListOld = function _updateHitListOld() {
          var _this5 = this;
          App.battleMgr.roleCtrl.foreachEntity(this, function (v) {
            if (_this5._hitHistoryList.get(v.uid)) return false;
            if (!_this5.checkTargetType(v)) return false;
            if (v.masterId === _this5._owner.uid || v.uid === _this5._owner.masterId) return false;
            // if (this._total_Trigger_num <= 0) return false;
            if (!_this5._triggerMap[v.uid]) _this5._triggerMap[v.uid] = [0, 0];
            if (_this5._triggerMap[v.uid][0] >= _this5.bulletVO.Trigger_num) return false;
            if (_this5.bulletVO.repeat && _this5._curHitList.size > 0) return false; //如果是弹射子弹只需要记录一个
            if (!_this5.checkHit(v)) return false;
            if (_this5.bulletAttack.curCatapultNum < _this5._total_PenetrateNum) {
              _this5._curHitList.set(v.uid, v);
              _this5._total_PenetrateNum--;
            }
            return false;
          });
          var count = this._curHitList.size;
          this._curHitList.forEach(function (v) {
            _this5._hitHistoryList.set(v.uid, v);
            _this5._curHitList["delete"](v.uid);
            _this5._triggerMap[v.uid][0]++;
            _this5._triggerMap[v.uid][1] = _this5.bulletVO.Trigger_time;
            // if (v.masterId !== this._owner.uid) {
            //     this.hit(v, count);
            // }
            _this5.hit(v, count);
            _this5._total_Trigger_num--;
          });
          this._checkCityCollision();
        };
        _proto._updateHitHistory = function _updateHitHistory(dt) {
          var _this6 = this;
          this._hitHistoryList.forEach(function (_v, k) {
            _this6._triggerMap[k][1] -= dt;
            if (_this6._total_Trigger_num > 0 && _this6._triggerMap[k][1] <= 0) {
              _this6._hitHistoryList["delete"](k);
            }
          });
        };
        _proto._checkCityCollision = function _checkCityCollision() {
          var _this$_skill;
          var dungeonMgr = App.dungeonBattleMgr;
          if (!dungeonMgr) {
            return;
          }
          var city = dungeonMgr.city;
          var owner = this.owner;
          if (!city || !(owner instanceof Monster)) {
            return;
          }
          var monsterOwner = owner;
          var maxDistance = ((_this$_skill = this._skill) == null ? void 0 : _this$_skill.distance[1]) || 0;
          if (typeof city.checkEnemyReachDefenseLine === "function" && !city.checkEnemyReachDefenseLine(monsterOwner, maxDistance)) {
            // 如果monster未到达城墙，则不结算伤害
            return;
          }
          var isHit = false;
          var cityRect = city.getBoundingBoxToWorld();
          if (!cityRect) {
            return;
          }
          if (this.bulletVO.crash_box_type === GameBattle.BulletHitShape.Round) {
            var round = this.getRoundToWorld();
            isHit = this.checkCollideRoundAndRect(round, cityRect);
          } else {
            var bulletRect = this.getBoundingBoxToWorld();
            isHit = cityRect.intersects(bulletRect);
          }
          if (!isHit) {
            return;
          }
          this._onCityHit(city, monsterOwner);
        };
        _proto._onCityHit = function _onCityHit(city, attacker) {
          var _attacker$roleVO;
          var baseAttack = (_attacker$roleVO = attacker.roleVO) != null && _attacker$roleVO.getRoleAttr ? attacker.roleVO.getRoleAttr(BattlePropertyName.gongji) : 0;
          var damage = Math.floor(baseAttack);
          if (damage > 0) {
            city.enemyStartAttack(attacker);
            city.takeDamage(damage, attacker);
          }
          this._bulletAttack.isEnd = true;
          this.end();
        }

        /**
         * 获取子弹的碰撞检测半径（使用碰撞盒的斜线为半径）
         */;
        _proto.getCollisionRadius = function getCollisionRadius() {
          var halfWidth = this.hitBox.width / 2;
          var halfHeight = this.hitBox.height / 2;
          return Math.sqrt(halfWidth * halfWidth + halfHeight * halfHeight);
        }

        /**
         * 检查子弹目标类型
         * @param role
         * @returns
         */;
        _proto.checkTargetType = function checkTargetType(role) {
          var result = false;
          var targetTyp = this._targetType;
          switch (targetTyp) {
            case GameBattle.SkillApplyTarget.Self:
              result = this._owner.uid === role.uid;
              break;
            case GameBattle.SkillApplyTarget.Enemy:
              result = !this._owner.isFriend(role.type);
              break;
            case GameBattle.SkillApplyTarget.Friends:
              result = this._owner.isFriend(role.type);
              break;
            case GameBattle.SkillApplyTarget.SelfAndFriends:
              result = this._owner.uid === role.uid || this._owner.isFriend(role.type);
              break;
            case GameBattle.SkillApplyTarget.All:
              result = true;
              break;
          }
          return result;
        }

        /**
         * 检查子弹是否结束
         * @returns
         */;
        _proto._checkEnd = function _checkEnd() {
          // 检查移动或攻击是否结束
          if (this._bulletMovement.isEnd || this._bulletAttack.isEnd) {
            return true;
          }
          return false;
        };
        _proto.playStartAnim = function playStartAnim() {
          var _this$view,
            _this7 = this;
          if (!((_this$view = this.view) != null && _this$view.skeleton)) return;
          this.view.skeleton.paused = false;
          if (GameConfig.DebugInfo.showBulletAniLog) {
            console.log("播放子弹动画:", this.bulletVO.viewPath);
          }
          if (this._startTaskId) {
            console.log(this.bulletVO.viewPath, "===已经有Start计时器在运行===", this._startTaskId);
            return;
          }
          var hasStartAnim = SpineUtils.checkAnimaionByName(this.view.skeleton, "Start");
          if (hasStartAnim) {
            var startDuration = SpineUtils.getAnimationDuration(this.view.skeleton, "Start");
            this._startTaskId = App.scheduleMgr.scheduleOnce(function () {
              var _this7$view;
              _this7._startTaskId = null;
              if (!((_this7$view = _this7.view) != null && _this7$view.isValid)) return;
              if (_this7.bulletVO.holding_time === -1) {
                _this7.view.play("Loop", true);
              } else if (_this7.bulletVO.holding_time === -2) {
                var loopDuration = SpineUtils.getAnimationDuration(_this7.view.skeleton, "Loop");
                _this7._loopTaskId = App.scheduleMgr.scheduleOnce(function () {
                  var _this7$view2;
                  _this7._loopTaskId = null;
                  if (!((_this7$view2 = _this7.view) != null && _this7$view2.isValid)) return;
                  _this7.end();
                }, _this7, loopDuration);
                _this7.view.play("Loop", false);
              } else if (_this7.bulletVO.holding_time > 0) {
                _this7.view.play("Loop", true);
              }
            }, this, startDuration);
            this.view.play("Start", false);
          } else {
            this.view.playDefault(true);
            if (this.bulletVO.holding_time === -2) {
              var defaultDuration = SpineUtils.getAnimationDuration(this.view.skeleton, this.defaultName);
              this._endTaskId = App.scheduleMgr.scheduleOnce(function () {
                var _this7$view3;
                _this7._endTaskId = null;
                if (!((_this7$view3 = _this7.view) != null && _this7$view3.isValid)) return;
                _this7.end();
              }, this, defaultDuration);
            }
          }
        }

        /**更新子弹缩放 */;
        _proto.updateScale = function updateScale(_dt) {
          var maxScale = this.bulletVO.volume_max;
          if (!maxScale) return;
          var scaleDiff = maxScale - this.bulletVO.volume;
          var curScale;
          if (this.bulletVO.holding_time > 0) {
            var timeRatio = this.bulletAttack.curDuration / this.bulletVO.holding_time;
            curScale = Math.min(this.bulletVO.volume + scaleDiff * timeRatio, maxScale);
            //console.log(">>>>>>>  scale:",this.bulletAttack.curDuration.toFixed(2),timeRatio.toFixed(2),curScale.toFixed(2));
          } else {
            //const distance = this.node.worldPosition.clone().subtract(this.startPosition).length();
            Vec3.subtract(this.tempVec, this.node.worldPosition, this.startPosition);
            var distance = this.tempVec.length();
            var disRatio = distance / this.bulletVO.distance;
            curScale = Math.min(this.bulletVO.volume + scaleDiff * disRatio, maxScale);
            //console.log(">>>>>>>>> maxDistance:",distance,disRatio.toFixed(2),curScale.toFixed(2));
          }

          if (curScale) {
            this.node.setScale(curScale, curScale, curScale);
          }
        }

        /**
         * 设置子弹碰撞盒和view的偏移,某些巨大子弹如果修改子弹node的偏移，子弹朝向会不准
         * @param _x 偏移x
         * @param _y 偏移y
         */;
        _proto.setViewAndHitBoxOffset = function setViewAndHitBoxOffset(_x, _y) {
          // console.log('setViewHitBoxOffset', this.hitBox.node.position, this.view.node.position, x, y);
          // this.hitBox.node.setPosition(x, y);
          // this.view.node.setPosition(x, y);
        }

        /**
         * 动态设置碰撞调试框，在wait_time时间后显示，
         * @param visible
         * @returns
         */;
        _proto.setHitBoxVisible = function setHitBoxVisible(visible) {
          if (this.bulletVO.crash_box_type === GameBattle.BulletHitShape.Round) {
            this.splashRound.active = GameConfig.DebugInfo.showBulletBox && visible;
          } else {
            this.splashRect.active = GameConfig.DebugInfo.showBulletBox && visible;
          }
        };
        _createClass(BulletBase, [{
          key: "bulletMovement",
          get: function get() {
            return this._bulletMovement;
          }
        }, {
          key: "bulletAttack",
          get: function get() {
            return this._bulletAttack;
          }
        }, {
          key: "hitHistoryList",
          get: function get() {
            return this._hitHistoryList;
          }
        }, {
          key: "type",
          get: function get() {
            return this._type;
          },
          set: function set(v) {
            this._type = v;
          }
        }, {
          key: "uid",
          get: function get() {
            return this._uid;
          },
          set: function set(v) {
            this._uid = v;
          }
        }, {
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "target",
          get: function get() {
            return this._target;
          },
          set: function set(v) {
            this._target = v;
          }
        }, {
          key: "skill",
          get: function get() {
            return this._skill;
          },
          set: function set(v) {
            this._skill = v;
          }
        }, {
          key: "speed",
          get: function get() {
            return this._speed;
          },
          set: function set(v) {
            this._speed = v;
          }
        }, {
          key: "isEnd",
          get: function get() {
            return this._isEnd;
          },
          set: function set(v) {
            this._isEnd = v;
          }
        }, {
          key: "launcherTime",
          get: function get() {
            return this._launcherTime;
          },
          set: function set(v) {
            this._launcherTime = v;
          }
        }, {
          key: "startPosOffset",
          get: function get() {
            return this._startPosOffset;
          },
          set: function set(v) {
            this._startPosOffset = v;
          }
        }, {
          key: "orientationOffset",
          get: function get() {
            return this._orientationOffset;
          },
          set: function set(v) {
            this._orientationOffset = v;
          }
        }, {
          key: "launcherType",
          get: function get() {
            return this._launcherType;
          },
          set: function set(v) {
            this._launcherType = v;
          }
        }, {
          key: "bullteCount",
          get: function get() {
            return this._bullteCount;
          },
          set: function set(v) {
            this._bullteCount = v;
          }
        }, {
          key: "launcherDelayTime",
          get: function get() {
            return this._launcherDelayTime;
          },
          set: function set(v) {
            this._launcherDelayTime = v;
          }
        }, {
          key: "launchered",
          get: function get() {
            return this._launchered;
          },
          set: function set(v) {
            this._launchered = v;
          }
        }, {
          key: "targetType",
          get: function get() {
            return this._targetType;
          },
          set: function set(value) {
            this._targetType = value;
          }
        }, {
          key: "startPosition",
          get: function get() {
            return this._startPosition;
          },
          set: function set(value) {
            this._startPosition = value;
          }
        }]);
        return BulletBase;
      }(Component), (_descriptor = _applyDecoratedDescriptor(_class.prototype, "view", [_dec], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: null
      }), _descriptor2 = _applyDecoratedDescriptor(_class.prototype, "hitBox", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor3 = _applyDecoratedDescriptor(_class.prototype, "splashRect", [_dec3], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      }), _descriptor4 = _applyDecoratedDescriptor(_class.prototype, "splashRound", [_dec4], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class)));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletCtrl.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './App.ts', './ModuleDef.ts', './BattleDefine.ts', './AdsorptionBullet.ts', './CircularBullet.ts', './MeleeBullet.ts', './RemoteBullet.ts', './MyBulletLauncher.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, cclegacy, App, ModuleDef, GameBattle, AdsorptionBullet, CircularBullet, MeleeBullet, RemoteBullet, MyBulletLauncher;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      App = module.App;
    }, function (module) {
      ModuleDef = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      AdsorptionBullet = module.AdsorptionBullet;
    }, function (module) {
      CircularBullet = module.CircularBullet;
    }, function (module) {
      MeleeBullet = module.MeleeBullet;
    }, function (module) {
      RemoteBullet = module.RemoteBullet;
    }, function (module) {
      MyBulletLauncher = module.MyBulletLauncher;
    }],
    execute: function () {
      cclegacy._RF.push({}, "b9fa1Q2joxJIqdlf8jmv3kU", "BulletCtrl", undefined);

      /**
       * 子弹控制器
       */
      var BulletCtrl = exports('BulletCtrl', /*#__PURE__*/function () {
        function BulletCtrl() {
          /** 实体列表 */
          this._entityMap = new Map();
          /** 唯一id生成器 */
          this._uidCounter = 0;
        }
        var _proto = BulletCtrl.prototype;
        _proto.init = function init() {};
        _proto.dispose = function dispose() {
          this.onExit();
          this.clearPool();
        };
        _proto.initPool = function initPool() {
          // 为MeleeBullet单独设置更高的预加载数量
          var meleeBulletPath = GameBattle.BulletPrefabPath[GameBattle.BulletType.Melee];
          if (meleeBulletPath) {
            App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, meleeBulletPath, {
              preloadCount: 30,
              // 增加预加载数量
              maxSize: 100,
              // 增加最大容量
              autoExpand: true
            });
          }

          // 为其他子弹类型设置默认预加载数量
          for (var key in GameBattle.BulletPrefabPath) {
            var path = GameBattle.BulletPrefabPath[key];
            // 跳过已经单独设置的MeleeBullet
            if (path !== meleeBulletPath) {
              App.nodePoolMgr.createPoolByPath(ModuleDef.GAME_BATTLE_B, path, {
                preloadCount: 20,
                maxSize: 50,
                autoExpand: true
              });
            }
          }
        };
        _proto.clearPool = function clearPool() {
          for (var key in GameBattle.BulletPrefabPath) {
            App.nodePoolMgr.clearPoolByPath(ModuleDef.GAME_BATTLE_B, GameBattle.BulletPrefabPath[key]);
          }
        };
        _proto.update = function update(dt) {
          MyBulletLauncher.onUpdate(dt);
          // console.log('当前有多少子弹', this._entityMap.size);

          for (var _iterator = _createForOfIteratorHelperLoose(this._entityMap.values()), _step; !(_step = _iterator()).done;) {
            var bullet = _step.value;
            bullet.onUpdate(dt);
          }
        }

        /**
         * 进入战场
         */;
        _proto.onEnter = function onEnter() {
          this.recoveryAll();
          MyBulletLauncher.clear();
        }

        /**
         * 退出战场
         */;
        _proto.onExit = function onExit() {
          this.recoveryAll();
          MyBulletLauncher.clear();
        }

        /**
         * 回收所有实体
         */;
        _proto.recoveryAll = function recoveryAll() {
          var _this = this;
          this._entityMap.forEach(function (v) {
            _this.recovery(v);
          });
          this._entityMap.clear();
        }

        /**
         * 回收实体
         * @param entity 实体对象
         * @returns
         */;
        _proto.recovery = function recovery(entity) {
          var path = GameBattle.BulletPrefabPath[entity.type];
          if (typeof path !== "string" || path === "") return;
          this._entityMap["delete"](entity.uid);
          entity.recovery();
          entity.node.parent = null;
          entity.uid = 0;
          App.nodePoolMgr.putNodeByPath(ModuleDef.GAME_BATTLE_B, path, entity.node);
        }

        /**
         * 再利用实体
         * @param entity 实体对象
         */;
        _proto.reuse = function reuse(entity) {
          entity.reuse();
          entity.uid = this._uidCounter++;
          entity.node.name = GameBattle.BulletType[entity.type] + "\u3010" + entity.uid + "\u3011";
          this._entityMap.set(entity.uid, entity);
        }

        /**
         * 创建子弹
         * @param bulletVo 子弹数据
         * @returns 子弹实体
         */;
        _proto.createBullet = function createBullet(bulletVo) {
          var _map;
          var node = App.nodePoolMgr.getNodeByPath(ModuleDef.GAME_BATTLE_B, GameBattle.BulletPrefabPath[bulletVo.type]);
          if (bulletVo.hierarchy === 1) {
            var _App$battleMgr$battle;
            node.parent = (_App$battleMgr$battle = App.battleMgr.battleMainViewCtrl) == null ? void 0 : _App$battleMgr$battle.bulletLayer;
          } else {
            var _App$battleMgr$battle2;
            node.parent = (_App$battleMgr$battle2 = App.battleMgr.battleMainViewCtrl) == null ? void 0 : _App$battleMgr$battle2.underBulletLayer;
          }
          if (!node.parent) return;
          var map = (_map = {}, _map[GameBattle.BulletType.Remote] = RemoteBullet, _map[GameBattle.BulletType.Melee] = MeleeBullet, _map[GameBattle.BulletType.NoAngle] = RemoteBullet, _map[GameBattle.BulletType.ShiZhu] = MeleeBullet, _map[GameBattle.BulletType.LockNoSame] = RemoteBullet, _map[GameBattle.BulletType.Circular] = CircularBullet, _map[GameBattle.BulletType.Adsorption] = AdsorptionBullet, _map[GameBattle.BulletType.LockNoSame2] = RemoteBullet, _map[GameBattle.BulletType.LockNoSame3] = RemoteBullet, _map);
          var bullet = node.getComponent(map[bulletVo.type]);
          this.reuse(bullet);
          bullet.load(bulletVo);
          return bullet;
        }

        /**
         * 根据子弹bulletId获取子弹实体
         * @param bulletId
         * @returns
         */;
        _proto.getBulletsByBullId = function getBulletsByBullId(bulletId) {
          if (!this) {
            return;
          }
          var bullets = [];
          this._entityMap.forEach(function (v) {
            if (v.bulletVO.bulletID === bulletId) {
              bullets.push(v);
            }
          });
          return bullets;
        }

        /**
         * 根据子弹bulletId获取子弹实体
         * @param bulletId
         * @returns
         */;
        _proto.getBulletsByBullType = function getBulletsByBullType(type) {
          if (!this) {
            return;
          }
          var bullets = [];
          this._entityMap.forEach(function (v) {
            if (v.bulletVO.type === type) {
              bullets.push(v);
            }
          });
          return bullets;
        };
        return BulletCtrl;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletEffect.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleProprMgr.ts', './DBRecord.ts', './BattleDefine.ts', './BuffEffect.ts', './BulletVO.ts', './MyBulletLauncher.ts', './Monster.ts', './GameConfig.ts', './MonitorType.ts', './App.ts', './BattleUtil.ts', './Utils.ts'], function (exports) {
  var _createForOfIteratorHelperLoose, _createClass, cclegacy, Vec3, tween, v3, BattlePropertyName, FormulaResultItem, DBRecord, GameBattle, BuffEffect, BulletVO, MyBulletLauncher, Monster, GameConfig, MonitorType, App, BattleUtil, Utils;
  return {
    setters: [function (module) {
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
      Vec3 = module.Vec3;
      tween = module.tween;
      v3 = module.v3;
    }, function (module) {
      BattlePropertyName = module.BattlePropertyName;
      FormulaResultItem = module.FormulaResultItem;
    }, function (module) {
      DBRecord = module.default;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      BuffEffect = module.BuffEffect;
    }, function (module) {
      BulletVO = module.BulletVO;
    }, function (module) {
      MyBulletLauncher = module.MyBulletLauncher;
    }, function (module) {
      Monster = module.Monster;
    }, function (module) {
      GameConfig = module.default;
    }, function (module) {
      MonitorType = module.MonitorType;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }, function (module) {
      Utils = module.Utils;
    }],
    execute: function () {
      cclegacy._RF.push({}, "edb94vszSxOE51lptDVnqth", "BulletEffect", undefined);

      // ghjgjuy:
      // 1-发射前
      // 2-命中时
      // 3-结束后
      // 4-击杀时
      // 5-孤立无援

      var BulletEffect_Tigger_Time = exports('BulletEffect_Tigger_Time', /*#__PURE__*/function (BulletEffect_Tigger_Time) {
        BulletEffect_Tigger_Time[BulletEffect_Tigger_Time["before"] = 1] = "before";
        BulletEffect_Tigger_Time[BulletEffect_Tigger_Time["hit"] = 2] = "hit";
        BulletEffect_Tigger_Time[BulletEffect_Tigger_Time["end"] = 3] = "end";
        BulletEffect_Tigger_Time[BulletEffect_Tigger_Time["kill"] = 4] = "kill";
        BulletEffect_Tigger_Time[BulletEffect_Tigger_Time["lone"] = 5] = "lone";
        return BulletEffect_Tigger_Time;
      }({}));

      /**
       * 子弹效果
       */
      var BulletEffect = exports('BulletEffect', /*#__PURE__*/function () {
        function BulletEffect() {
          /** 效果ID */
          this.effectid = 0;
          /** 作用目标类型 */
          this._target_type = GameBattle.SkillApplyTarget.None;
          /** 效果类型 */
          this._type = GameBattle.SkillEffectType.None;
          /** 作用时机 */
          this._applyTime = 0;
          /** 算法ID */
          this._algorithm = 0;
          /** 属性类型 */
          this._element = 0;
          /** 属性参数 */
          this._attrParam = [];
          /** 持有者 */
          this._owner = void 0;
          /** 目标 */
          this._target = void 0;
          /** 属性参数 */
          this._point_number = void 0;
          /** 触发时机 */
          this._before_or_after = 0;
          /** 召唤物上限 */
          this._upperlimit = 0;
          /** 威力倍率 */
          this._point_number2 = 10000;
          /** 激活条件 */
          this._active_if = [];
          /** 乘法属性参数 */
          this._multiplication_value = [];
          this.vo = null;
          this.atr = [];
        }
        var _proto = BulletEffect.prototype;
        _proto.load = function load(cfg) {
          // const cfg: dbr.JiNengXiaoGuo = DBRecord.fetchId("JiNengXiaoGuo", id);
          this.effectid = cfg.effectid;
          this._target_type = cfg.target_type;
          this._type = cfg.type;
          this._algorithm = cfg.algorithm;
          this._element = cfg.element;
          this._point_number = Utils.copyObj(cfg.point_number);
          this.before_or_after = cfg.before_or_after;
          this._upperlimit = cfg.upperlimit || 9999999;
          this.atr = [];
          cfg.atr && (this.atr = [].concat(cfg.atr));
          this._point_number2 = 10000;
          this._active_if = [];
          // cfg.active_if && (this._active_if = [...cfg.active_if]);
          this._multiplication_value = [];
          // cfg.multiplication_value && (this._multiplication_value = [...cfg.multiplication_value]);
        };

        _proto.set = function set(cfg) {
          this.effectid = cfg.effectid;
          this._target_type = cfg._target_type;
          this._type = cfg._type;
          this._algorithm = cfg._algorithm;
          this._element = cfg._element;
          this._point_number = cfg._point_number;
          this.before_or_after = cfg.before_or_after;
          this._upperlimit = cfg.upperlimit;
          cfg.atr && (this.atr = [].concat(cfg.atr));
          this._point_number2 = cfg._point_number2;
          this._active_if = cfg.active_if;
          this._multiplication_value = cfg.multiplication_value;
        };
        _proto.launch = function launch(target, count, tiggerTime) {
          // 触发时机匹配才生效  lone 也是击中时机
          if (this._before_or_after !== tiggerTime) return;
          if (!this._owner.owner) return;
          this._target = target;
          switch (this._type) {
            case GameBattle.SkillEffectType.Damage:
              this._dealDamage(GameBattle.SkillEffectType.Damage, count);
              break;
            case GameBattle.SkillEffectType.AddBuff:
              this._dealAddBuff();
              break;
            case GameBattle.SkillEffectType.RemoveBuff:
              this._dealRemoveBuff();
              break;
            case GameBattle.SkillEffectType.CreateBullet:
            case GameBattle.SkillEffectType.CreateBullet360:
              this._dealCreateBullet();
              break;
            case GameBattle.SkillEffectType.TarGetMove:
              this._targetMove();
              break;
            case GameBattle.SkillEffectType.Heal:
              this._heal();
              break;
          }
        }

        /**
         * 处理效果类型： 伤害
         */;
        _proto._dealDamage = function _dealDamage(type, count) {
          if (type === void 0) {
            type = GameBattle.SkillEffectType.Damage;
          }
          var battleProprManager = App.battleProprMgr;
          var atker = this.owner.owner;
          // if (this.owner.owner.isSummon()) {
          //     //召唤物
          //     let vo = this.owner.owner.roleVO as MonsterVO;
          //     if (vo.quality === GameBattle.MonsterQuality.SummonMaster) {
          //         let master = App.battleMgr.roleCtrl.getRole(this.owner.masterId);
          //         atker = master;
          //     }
          // }
          var point_number = this._point_number;
          if (Array.isArray(this.point_number)) {
            point_number = this.point_number[0];
          }
          if (this._active_if.length > 0 && this._active_if[0] === 1 && count === 1) {
            // 孤立无援
            point_number *= this._multiplication_value[0];
          }
          var exInfo = {
            dmgType: type,
            mltDmg0: point_number,
            mltDmg1: this._point_number2,
            eleType: this._element,
            skillId: this._owner.skill.skillID
          };
          if (type === GameBattle.SkillEffectType.Damage) {
            exInfo.dmgType = this._algorithm;
            if (this._algorithm === GameBattle.SkillEffectType.Damage2) {
              exInfo.mltDmg1 = exInfo.mltDmg0;
            } else if (this._algorithm === GameBattle.SkillEffectType.Damage3) {
              exInfo.mltDmg1 = exInfo.mltDmg0 * (this._owner.owner.roleVO.curLvl1 || 1);
            }
          }
          var FResult = battleProprManager.execBattleFormula(atker, this.target, exInfo, this._owner);
          var atkF = FResult[0],
            atkType = FResult[1];
          atkF = atkF < 0 ? 0 : -atkF;
          this.target.underAttack(atkF, this._element, this._owner.bulletVO.hit_effect, atkType, this._owner.owner);
          if (GameConfig.DebugInfo.showBattleReportLog) {
            if (this.target.type === GameBattle.RoleType.Hero || this.target.type === GameBattle.RoleType.Soldier) {
              var monster = this._owner.owner;
              if (monster instanceof Monster) {
                var vo = monster.roleVO;
                console.log("\u6218\u62A5 : \u602A\u7269 " + vo.name + " \u4F7F\u7528\u6280\u80FD " + this._owner.skill.name + " (\u5B50\u5F39id=" + this._owner.bulletVO.bulletID + ") \u653B\u51FBPlayer \u9020\u6210" + atkF + " \u4F24\u5BB3 atkType=" + atkType);
              } else {
                console.log("\u6218\u62A5 : player(\u5B50\u5F39id=" + this._owner.bulletVO.bulletID + ") \u653B\u51FBPlayer \u9020\u6210" + atkF + " \u4F24\u5BB3 atkType=" + atkType);
              }
            } else {
              var _vo = this.target.roleVO;
              // if (this.owner.owner.isSummon()) {
              //     console.log(
              //         `战报 : 召唤物[${this._owner.uid}]  \
              //         使用技能 ${this._owner.skill.name} \
              //         (子弹id=${this._owner.bulletVO.bulletID}) \
              //         攻击 怪物[${vo.name}][${this.target.uid}] \
              //         造成${atkF} 伤害\
              //         point_number2=${this._point_number2}`
              //     );
              // } else {
              // console.log(`战报 : 主角 使用技能 ${this._owner.skill.name} (子弹id=${this._owner.bulletVO.bulletID}) 攻击 怪物[${vo.name}][${this.target.uid}] 造成${atkF} 伤害`);
              // }
            }
          }
        }

        /**
         * 处理效果类型： 添加buff
         */;
        _proto._dealAddBuff = function _dealAddBuff() {
          var target = this.target;
          var buff_id = this.atr[0];
          if (this._target_type === 2) {
            target = this._owner.owner;
          }
          if (!target) {
            return;
          }
          var buff = target._buffBox.addBuff(buff_id, this._owner.owner, this.owner.skill.skillID, false, this._owner);
          var count = this.algorithm;
          if (count && count > 1) {
            for (var i = 1; i < count; i++) {
              target._buffBox.addBuff(buff_id, this._owner.owner, this.owner.skill.skillID, false, this._owner);
            }
          }

          // let catchBuff = target._buffBox.catchBuff[buff_id];
          // if (catchBuff) {
          //     for (let i = 0; i < catchBuff.length; i++) {
          //         BuffEffect.setValue(buff.vo, catchBuff[i]);
          //         buff.curTime = buff.vo.time;
          //     }
          // }
        }

        /**
         * 处理效果类型： 移除buff
         */;
        _proto._dealRemoveBuff = function _dealRemoveBuff() {}

        /**
         * 处理效果类型： 创建子弹
         */;
        _proto._dealCreateBullet = function _dealCreateBullet() {
          var bullet_id = Number(this.atr[0]);
          console.log(">>>>>>>>>>>>>>>>>>>>>>>>> _dealCreateBullet", bullet_id);
          var theta = Number(this.atr[1]) || 0;
          var count = Number(this.point_number);
          var cfg = DBRecord.fetchId("JiNengZiDan", bullet_id);
          var bulletVo = new BulletVO();
          bulletVo.load(cfg);
          var buff = this._owner.skill.owner._buffBox.subBulletBuff[bullet_id];
          if (buff) {
            for (var i = 0; i < buff.length; i++) {
              BuffEffect.setValue(bulletVo, buff[i]);
            }
          }
          bulletVo.bulletEffect = {};
          for (var j = 0; j < bulletVo.effect_id.length; j++) {
            var effect_id = bulletVo.effect_id[j];
            bulletVo.bulletEffect[effect_id] = new BulletEffect();
            var cfg2 = DBRecord.fetchId("JiNengXiaoGuo", effect_id);
            bulletVo.bulletEffect[effect_id].load(cfg2);
            var _buff = this._owner.skill.owner._buffBox.subBulletEffectBuff[effect_id];
            if (_buff) {
              for (var _i = 0; _i < _buff.length; _i++) {
                BuffEffect.setValue(bulletVo.bulletEffect[effect_id], _buff[_i]);
              }
            }
          }
          var hit_point = null;
          if (this.owner.skill.targetPos.x > 0) {
            //预警位置
            hit_point = this.owner.skill.targetPos.clone();
          } else {
            if ("motherBullet" === bulletVo.position) {
              hit_point = this._owner.node.worldPosition;
            } else {
              if (!this._target) return;
              hit_point = this._target.getHitWorldPosition();
            }
          }
          var angle = BattleUtil.get2DAngleByPoint(this._owner.owner.node.worldPosition, hit_point);
          if (this._type === GameBattle.SkillEffectType.CreateBullet360) {
            theta = 360 / count;
            angle = Math.random() * 360;
          }
          var subBulletList = MyBulletLauncher.addSubBullet(bulletVo, this._owner.skill, hit_point, count, angle, theta);
          //console.log('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR _dealCreateBullet ------');
          for (var _i2 = 0; _i2 < subBulletList.length; _i2++) {
            var subBullet = subBulletList[_i2];
            subBullet.initOwnerId = this.owner.initOwnerId;
            subBullet.isPlayerSummonBullet = this.owner.isPlayerSummonBullet;
            subBullet.initOwnerFullAttr = Utils.copyObj(this.owner.initOwnerFullAttr);
            subBullet.initOwnerLockAttr = Utils.copyObj(this.owner.initOwnerLockAttr);
            //console.log('>>>>>>>>>>>>>>>>>>>>>>>>> BULLET_OWNER_ERROR _dealCreateBullet', subBullet.bulletVO.bulletID, subBullet.initOwnerId, subBullet.isPlayerSummonBullet);
          }
        }

        /**
         * 目标位移
         */;
        _proto._targetMove = function _targetMove() {
          this.target.node.setSiblingIndex(10000000);
          var moveDirection = this.owner.owner.node.worldPosition.clone().subtract(this.target.node.worldPosition);
          var node = this._target.node;
          var delayTime = this.point_number[0];
          var endTime = this.point_number[1] - delayTime;
          var distance = this.target.node.worldPosition.clone().subtract(this._owner.owner.getMountPoint("dummy_cast", new Vec3(0, 0, 0))).length();
          var frameSpeed = distance / endTime / 40; //Number(game.frameRate)
          var offset = moveDirection.normalize().multiplyScalar(frameSpeed);
          // eslint-disable-next-line @typescript-eslint/no-this-alias
          var that = this;
          tween(node).delay(0).to(0.1, {
            scale_z: 1
          }, {
            onUpdate: function onUpdate(target, ratio) {
              var pos = node.worldPosition.clone();
              var distance = pos.clone().subtract(that._owner.owner.getMountPoint("dummy_cast", new Vec3(0, 0, 0))).length();
              var dir = pos.clone().subtract(that._owner.owner.getMountPoint("dummy_cast", new Vec3(0, 0, 0))).normalize();
              var dir_f = BattleUtil.analysisDirection(dir);
              var restrictions = 150;
              if (dir_f === GameBattle.Direction.Up || dir_f === GameBattle.Direction.LeftUp || dir_f === GameBattle.Direction.RightUp) {
                restrictions = 50;
              }
              if (dir_f === GameBattle.Direction.Down || dir_f === GameBattle.Direction.LeftDown || dir_f === GameBattle.Direction.RightDown) {
                restrictions = 250;
              }
              //预判断是否靠近
              if (distance < restrictions) {
                return;
              }
              while (offset.length() > 150) {
                offset = offset.multiplyScalar(0.95);
              }
              var x = offset.x;
              var y = offset.y;

              // 检查下一步位置是否可行走
              var nextPos = v3(pos.x + x, pos.y + y, 0);
              if (!App.mapMgr.checkCanMove(nextPos)) {
                return; // 如果不可行走，直接停止
              }

              pos.add3f(x, y, 0);
              node.worldPosition = pos;
            }
          }).start();
        }

        /**
         * 治疗
         */;
        _proto._heal = function _heal() {
          var count = Number(this.point_number);
          var _targets = [];
          var ty = -1;
          switch (this.targetType) {
            case GameBattle.SkillApplyTarget.Self:
              ty = this._owner.owner.type;
              _targets.push(this.owner.owner);
              break;
            case GameBattle.SkillApplyTarget.Enemy:
              ty = this._owner.target.type;
              _targets = this._owner.owner.lockTargetCtrl.getTargetByType(ty, this.owner.bulletVO.crash_box);
              break;
            case GameBattle.SkillApplyTarget.Friends:
              ty = this._owner.owner.type;
              _targets = this._owner.owner.lockTargetCtrl.getTargetByType(ty, this.owner.bulletVO.crash_box);
              break;
            case GameBattle.SkillApplyTarget.SelfAndFriends:
              ty = this._owner.owner.type;
              _targets = this._owner.owner.lockTargetCtrl.getTargetByType(ty, this.owner.bulletVO.crash_box);
              _targets.push(this.owner.owner);
              break;
            case GameBattle.SkillApplyTarget.All:
              break;
          }
          for (var _iterator = _createForOfIteratorHelperLoose(_targets), _step; !(_step = _iterator()).done;) {
            var tar = _step.value;
            // tar.underAttack(0, this._attrType, this._owner.bulletVO.hit_effect, FormulaResultItem._none);
            var roleVO = tar.roleVO;
            var maxHp = roleVO.getRoleAttr(BattlePropertyName.shengming);
            var value = count;
            if (this.algorithm === 2) {
              //百分比回血
              value = Math.floor(maxHp * value / 10000);
            }
            count = value;
            if (roleVO.curHP + value > maxHp) {
              value = maxHp - roleVO.curHP;
            }
            // roleVO.curHP += value;
            roleVO.updateCurHP(value);
            if (this._owner.owner.type === GameBattle.RoleType.Hero || this._owner.owner.type === GameBattle.RoleType.Soldier) {
              // roleVO.updateCurHP(roleVO.curHP, true);
              this._owner.owner._showDamageTips(count, 0, FormulaResultItem._zhiliao);
              App.monitorMgr.dispatchEvent(MonitorType.battle_player_update_hp);
              console.log("\u73A9\u5BB6\u83B7\u5F97\u6CBB\u7597 \u6CBB\u7597\u91CF\u4E3A " + value + " ");
            } else {
              this._owner.owner._showDamageTips(value, 0, FormulaResultItem._zhiliao);
              console.log("\u602A\u7269\u83B7\u5F97\u6CBB\u7597 \u6CBB\u7597\u91CF\u4E3A " + value + " ");
            }
          }
        };
        _createClass(BulletEffect, [{
          key: "targetType",
          get: function get() {
            return this._target_type;
          },
          set: function set(v) {
            this._target_type = v;
          }
        }, {
          key: "type",
          get: function get() {
            return this._type;
          },
          set: function set(v) {
            this._type = v;
          }
        }, {
          key: "applyTime",
          get: function get() {
            return this._applyTime;
          },
          set: function set(v) {
            this._applyTime = v;
          }
        }, {
          key: "algorithm",
          get: function get() {
            return this._algorithm;
          },
          set: function set(v) {
            this._algorithm = v;
          }
        }, {
          key: "element",
          get: function get() {
            return this._element;
          },
          set: function set(v) {
            this._element = v;
          }
        }, {
          key: "attrParam",
          get: function get() {
            return this._attrParam;
          },
          set: function set(v) {
            this._attrParam = v;
          }
        }, {
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "target",
          get: function get() {
            return this._target;
          },
          set: function set(v) {
            this._target = v;
          }
        }, {
          key: "point_number",
          get: function get() {
            return this._point_number;
          },
          set: function set(value) {
            this._point_number = value;
          }
        }, {
          key: "before_or_after",
          get: function get() {
            return this._before_or_after;
          },
          set: function set(v) {
            this._before_or_after = v;
          }
        }, {
          key: "upperlimit",
          get: function get() {
            return this._upperlimit;
          },
          set: function set(value) {
            this._upperlimit = value;
          }
        }, {
          key: "point_number2",
          get: function get() {
            return this._point_number2;
          },
          set: function set(v) {
            this._point_number2 = v;
          }
        }, {
          key: "active_if",
          get: function get() {
            return this._active_if;
          },
          set: function set(value) {
            this._active_if = value;
          }
        }, {
          key: "multiplication_value",
          get: function get() {
            return this._multiplication_value;
          },
          set: function set(value) {
            this._multiplication_value = value;
          }
        }]);
        return BulletEffect;
      }());
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletMovement_Arrow.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MathUtils.ts', './BulletMovement.ts', './App.ts', './BattleUtil.ts'], function (exports) {
  var _inheritsLoose, _createForOfIteratorHelperLoose, cclegacy, Tween, Node, Vec3, tween, MathUtils, BulletMovement, App, BattleUtil;
  return {
    setters: [function (module) {
      _inheritsLoose = module.inheritsLoose;
      _createForOfIteratorHelperLoose = module.createForOfIteratorHelperLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      Tween = module.Tween;
      Node = module.Node;
      Vec3 = module.Vec3;
      tween = module.tween;
    }, function (module) {
      MathUtils = module.default;
    }, function (module) {
      BulletMovement = module.BulletMovement;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      cclegacy._RF.push({}, "1c9a3qTdDREQqGzlYIYzj5C", "BulletMovement_Arrow", undefined);
      var ArrowState = /*#__PURE__*/function (ArrowState) {
        ArrowState[ArrowState["NONE"] = 0] = "NONE";
        ArrowState[ArrowState["INIT"] = 1] = "INIT";
        ArrowState[ArrowState["FLYING"] = 2] = "FLYING";
        ArrowState[ArrowState["FLYBACK"] = 3] = "FLYBACK";
        ArrowState[ArrowState["TWEENBACK"] = 4] = "TWEENBACK";
        return ArrowState;
      }(ArrowState || {});
      /**
       * 子弹运动器类型 —— 哨箭
       */
      var BulletMovement_Arrow = exports('BulletMovement_Arrow', /*#__PURE__*/function (_BulletMovement) {
        _inheritsLoose(BulletMovement_Arrow, _BulletMovement);
        function BulletMovement_Arrow() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _BulletMovement.call.apply(_BulletMovement, [this].concat(args)) || this;
          _this.state = void 0;
          _this.time = void 0;
          _this.maxTime = void 0;
          _this.angleOffset = 5;
          //每帧偏转角度
          _this.target = void 0;
          _this.angle = void 0;
          _this.targetType = void 0;
          _this.last_angle = void 0;
          _this.startAngle = 90;
          _this.startDir = null;
          _this._parent = null;
          return _this;
        }
        var _proto = BulletMovement_Arrow.prototype;
        _proto.reset = function reset() {
          _BulletMovement.prototype.reset.call(this);
          Tween.stopAllByTarget(this.owner.node);
          BulletMovement_Arrow.allTargets = [];
        };
        _proto.getInitPos = function getInitPos() {
          return this._parent.worldPosition;
        };
        _proto.launch = function launch(bulletLauncherData) {
          console.log("bulletLauncherData", bulletLauncherData);
          this.angle = this.owner.node.angle = this.startAngle;
          this.last_angle = this.angle;
          this.state = ArrowState.INIT;
          Tween.stopAllByTarget(this.owner.node);
          this.resetData();
          var name = "__Arrow__" + bulletLauncherData.index;
          this._parent = this.owner.owner.node.getChildByName(name);
          if (!this._parent) {
            this._parent = new Node();
            this._parent.layer = this.owner.owner.node.layer;
            this._parent.setParent(this.owner.owner.node);
            this._parent.setPosition(-100 - 60 * bulletLauncherData.index, 150, 0);
            this._parent.name = name;
          }
          this.owner.node.setParent(this._parent);
          this.owner.node.setPosition(0, 0, 0);
        };
        _proto.getTarget = function getTarget() {
          var target = this._owner.skill.getTarget();
          for (var i = BulletMovement_Arrow.allTargets.length - 1; i >= 0; i--) {
            if (!BulletMovement_Arrow.allTargets[i].checkValid()) {
              BulletMovement_Arrow.allTargets.splice(i, 1);
            }
          }
          if (!target) {
            this.target = null;
            return;
          }
          var map = App.battleMgr.roleCtrl.getRolesByType(target.type);
          var targets = [];
          var range = this.owner.skill.distance[1];
          var curDistance = -1;
          for (var _i in map) {
            var role = map[_i];
            var distance = Vec3.distance(this.owner.owner.node.worldPosition, role.node.worldPosition);
            if (distance > range) {
              continue;
            }
            var flag = true;
            for (var _iterator = _createForOfIteratorHelperLoose(BulletMovement_Arrow.allTargets), _step; !(_step = _iterator()).done;) {
              var t1 = _step.value;
              if (t1.uid === role.uid) {
                flag = false;
                break;
              }
            }
            if (flag) {
              targets.push(role);
            }
            if (distance > curDistance) {
              curDistance = distance;
              target = role;
            }
          }
          curDistance = -1;
          if (targets.length > 0) {
            for (var _iterator2 = _createForOfIteratorHelperLoose(targets), _step2; !(_step2 = _iterator2()).done;) {
              var _role = _step2.value;
              var _distance = Vec3.distance(this.owner.owner.node.worldPosition, _role.node.worldPosition);
              if (_distance > curDistance) {
                curDistance = _distance;
                target = _role;
              }
            }
          }
          this.target = target;
          BulletMovement_Arrow.allTargets.push(target);
          if (this.target) {
            this.owner.node.opacity = 255;
          }
        };
        _proto.resetData = function resetData() {
          this.getTarget();
          if (this.target) {
            this.state = ArrowState.FLYING;
          } else if (this.state === ArrowState.FLYING) {
            this.state = ArrowState.FLYBACK;
            this.target = this.owner.owner;
          }
          this.time = 0;
          this.maxTime = 0.5;
          this.angleOffset = 1;
          this.angle = this.owner.node.angle;
          this.startDir = MathUtils.angleToDirection(this.owner.node.angle).normalize();
        };
        _proto.onUpdate = function onUpdate(dt) {
          var _this$target;
          if (this.state === ArrowState.TWEENBACK) return;
          var initPos = this.getInitPos();
          if (this.state === ArrowState.INIT) {
            var flip = this.owner.owner.isFaceRight();
            var x = Math.abs(this._parent.position.x);
            x = flip ? -x : x;
            this._parent.setPosition(x, this._parent.position.y, this._parent.position.z);
          }
          if (!((_this$target = this.target) != null && _this$target.checkValid())) {
            this.resetData();
          }
          if (!this.target) {
            return;
          }
          var targetPos = this.target.node.worldPosition.clone();
          if (this.state === ArrowState.FLYBACK) {
            targetPos = initPos;
          }
          var angle = BattleUtil.get2DAngleByPoint(this.owner.node.worldPosition, targetPos);
          // if(angle > 0){
          //     if(180-angle < 4){
          //         angle
          //     }
          // }

          this.time += dt;
          if (this.time >= this.maxTime) {
            this.time = this.maxTime;
          }
          var rate = this.time / this.maxTime;

          // let end_dir = targetPos.clone().subtract(this.owner.node.worldPosition).normalize()
          // let cur_dir = this.startDir.clone().lerp(end_dir.copyAsVec2(), rate)

          // // 使用 Math.atan2 计算与 x 轴的角度，并转换为度数
          // const cur_angle = Math.atan2(cur_dir.y, cur_dir.x) * (180 / Math.PI);
          // this.owner.node.angle = cur_angle
          // console.log(`当前角度 : ${end_dir},  上次角度: ${cur_dir}  this.startDir:${this.startDir}  angle :${angle}  rate: ${rate}, this.angle: ${this.angle.toFixed(2)},  angle - this.angle ${angle - this.angle}`)

          this.owner.node.angle = (angle - this.angle) * rate + this.angle;
          var dir = MathUtils.angleToDirection(this.owner.node.angle);
          var frameSpeed = this.getFrameSpeed();
          var offset = dir.multiplyScalar(frameSpeed);
          // console.log(`当前角度 : ${this.owner.node.angle.toFixed(2)},  上次角度: ${this.last_angle.toFixed(2)}  偏差:${(this.owner.node.angle-this.last_angle).toFixed(2)}  angle :${angle}  rate: ${rate}, this.angle: ${this.angle.toFixed(2)},  angle - this.angle ${angle - this.angle}`)
          this.last_angle = this.owner.node.angle;
          this.owner.node.x += offset.x;
          this.owner.node.y += offset.y;
          if (this.state === ArrowState.FLYBACK) {
            var distance = Vec3.distance(this.owner.node.worldPosition, targetPos);
            if (distance < Math.abs(offset.x) + Math.abs(offset.y)) {
              this.target = null;
              this.state = ArrowState.TWEENBACK;
              var self = this;
              tween(this.owner.node).to(0.2, {
                angle: 90,
                worldPosition: targetPos
              }).call(function () {
                self.state = ArrowState.INIT;
                if (self._owner.bulletVO.move_param.length > 0) {
                  self.owner.node.opacity = 0;
                }
              }).start();
            }
          } else {
            if (this.owner.checkHit(this.target) && rate === 1) {
              this.resetData();
            }
          }
        };
        return BulletMovement_Arrow;
      }(BulletMovement));
      BulletMovement_Arrow.allTargets = [];
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletMovement.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './MathUtils.ts', './Utils.ts', './BattleDefine.ts', './App.ts', './BattleUtil.ts'], function (exports) {
  var _createClass, _inheritsLoose, cclegacy, game, Vec3, v3, v2, sp, Size, tween, find, Camera, UITransform, MathUtils, Utils, GameBattle, App, BattleUtil;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
      _inheritsLoose = module.inheritsLoose;
    }, function (module) {
      cclegacy = module.cclegacy;
      game = module.game;
      Vec3 = module.Vec3;
      v3 = module.v3;
      v2 = module.v2;
      sp = module.sp;
      Size = module.Size;
      tween = module.tween;
      find = module.find;
      Camera = module.Camera;
      UITransform = module.UITransform;
    }, function (module) {
      MathUtils = module.default;
    }, function (module) {
      Utils = module.Utils;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      App = module.App;
    }, function (module) {
      BattleUtil = module.BattleUtil;
    }],
    execute: function () {
      cclegacy._RF.push({}, "ff297WKAVJLyIDVR+YFY7gA", "BulletMovement", undefined);

      /**
       * 子弹运动器类
       */
      var BulletMovement = exports('BulletMovement', /*#__PURE__*/function () {
        function BulletMovement() {
          /** 临时向量,用于update中的向量计算，避免频繁创建临时向量 */
          this.tempVec = new Vec3();
          /** 临时位置 ,用于update中的坐标转换，避免频繁创建临时向量*/
          this.tempPos = new Vec3();
          /** 持有者 */
          this._owner = void 0;
          /** 是否已结束 */
          this._isEnd = false;
          /** 子弹速度 */
          this.speed = void 0;
          /** 方向向量 */
          this._direction = new Vec3();
          this.lockAngle = false;
          this.init();
        }
        var _proto = BulletMovement.prototype;
        _proto.reset = function reset() {
          this._isEnd = false;
        };
        _proto.init = function init() {};
        _proto.onUpdate = function onUpdate(dt) {};
        _proto.onHit = function onHit(target) {}

        /**
         * 发射
         */;
        _proto.launch = function launch(bulletLauncherData) {}

        /**
         * 获取当前的移速
         */;
        _proto.getMoveSpeed = function getMoveSpeed() {
          this.speed += this._owner.bulletVO.acceleration / Number(game.frameRate);
          return this.speed;
        }

        /**
         * 获取当前移速的帧速度
         */;
        _proto.getFrameSpeed = function getFrameSpeed() {
          return this._owner.bulletVO.initialSpeed / Number(game.frameRate);
        }

        /**
         * 获取子弹的初始速度
         * @returns
         */;
        _proto.getInitialSpeed = function getInitialSpeed() {
          return this._owner.bulletVO.initialSpeed;
        };
        _createClass(BulletMovement, [{
          key: "owner",
          get: function get() {
            return this._owner;
          },
          set: function set(v) {
            this._owner = v;
          }
        }, {
          key: "isEnd",
          get: function get() {
            return this._isEnd;
          },
          set: function set(v) {
            this._isEnd = v;
          }
        }, {
          key: "direction",
          get: function get() {
            return this._direction;
          },
          set: function set(v) {
            this._direction = v;
            console.log("set dir");
          }
        }]);
        return BulletMovement;
      }());

      /**
       * 子弹运动器类型 —— 跟随
       */
      var BulletMovement_Follow = exports('BulletMovement_Follow', /*#__PURE__*/function (_BulletMovement) {
        _inheritsLoose(BulletMovement_Follow, _BulletMovement);
        function BulletMovement_Follow() {
          var _this;
          for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }
          _this = _BulletMovement.call.apply(_BulletMovement, [this].concat(args)) || this;
          /** 目标 */
          _this._target = void 0;
          return _this;
        }
        var _proto2 = BulletMovement_Follow.prototype;
        _proto2.reset = function reset() {
          this._target = null;
        };
        _proto2.init = function init() {};
        _proto2.launch = function launch(bulletLauncherData) {
          this.speed = this.getFrameSpeed();
          this.target = this._owner.target;
          if (this._owner.bulletVO.type === GameBattle.BulletType.NoAngle) {
            this._owner.node.angle = 0;
          }
        };
        _proto2.onUpdate = function onUpdate(dt) {
          if (!this._target) return;
          if (this.getFrameSpeed() === 0) return;
          var startPos = this._owner.node.worldPosition;
          var endPos = this.tempVec;
          Vec3.add(endPos, this._target.node.worldPosition, this._target.getHitPosition());
          var pos = endPos.subtract(startPos).normalize().multiplyScalar(this.speed);
          pos.add(startPos);
          this._owner.node.parent.uiTransform.convertToNodeSpaceAR(pos, pos);
          if (this._owner.bulletVO.type !== GameBattle.BulletType.NoAngle) {
            var angle = BattleUtil.get2DAngleByPoint(startPos, endPos);
            this._owner.node.angle = angle;
          }
          this._owner.node.position = pos;
          if (!this._target.checkValid()) {
            var dis = Vec3.distance(this._owner.node.worldPosition, this._target.node.worldPosition);
            if (dis < 200) {
              this.owner.end();
            }
          }
        };
        _createClass(BulletMovement_Follow, [{
          key: "target",
          get: function get() {
            return this._target;
          },
          set: function set(v) {
            this._target = v;
          }
        }]);
        return BulletMovement_Follow;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 直线
       */
      var BulletMovement_Line = exports('BulletMovement_Line', /*#__PURE__*/function (_BulletMovement2) {
        _inheritsLoose(BulletMovement_Line, _BulletMovement2);
        function BulletMovement_Line() {
          var _this2;
          for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }
          _this2 = _BulletMovement2.call.apply(_BulletMovement2, [this].concat(args)) || this;
          /** 起始位置 */
          _this2._startPosition = new Vec3();
          return _this2;
        }
        var _proto3 = BulletMovement_Line.prototype;
        _proto3.reset = function reset() {
          _BulletMovement2.prototype.reset.call(this);
          this._direction.set(0, 0, 0);
          this._startPosition.set(0, 0, 0);
        };
        _proto3.init = function init() {};
        _proto3.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          var role = this._owner.owner;
          var target = this._owner.target;
          var startPos = this._owner.node.worldPosition;
          if (this._direction.x === 0 && this._direction.y === 0) {
            // const endPos = target.node.worldPosition.clone().add(target.getHitPosition());
            // Vec3.subtract(this._direction, endPos, startPos).normalize();
            // const angle = BattleUtil.get2DAngleByPoint(startPos, endPos);
            // this._owner.node.angle = angle;
            this._direction.x = 1;
          }
          this._startPosition.set(startPos);
          if (this._owner.bulletVO.type === GameBattle.BulletType.NoAngle) {
            this._owner.node.angle = 0;
          }
        };
        _proto3.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          if (this._checkDistance()) {
            this._isEnd = true;
            return;
          }
          if (this._direction.x === 0 && this._direction.y === 0) return;
          this.speed = this.getMoveSpeed();
          var frameSpeed = this.speed * dt;
          var offset = this.tempVec;
          Vec3.multiplyScalar(offset, this._direction, frameSpeed);

          // const frameSpeed = this.speed * dt;
          // const newPos = startPos.clone().add(moveDir.multiplyScalar(frameSpeed));

          Vec3.add(this.tempPos, this._owner.node.worldPosition, offset);
          this._owner.node.worldPosition = this.tempPos;
          if (this._owner.bulletVO.angle_speed && this._owner.bulletVO.type !== GameBattle.BulletType.NoAngle) {
            this._owner.node.angle += this._owner.bulletVO.angle_speed;
          }
        }

        /**
         * 检测是否达到设定距离
         * @returns
         */;
        _proto3._checkDistance = function _checkDistance() {
          var result = true;
          var maxDistance = this._owner.bulletVO.distance;
          if (maxDistance === -1) {
            // 无限距离
            result = false;
          } else {
            Vec3.subtract(this.tempVec, this._owner.node.worldPosition, this._startPosition);
            var distance = this.tempVec.length();
            result = distance >= maxDistance;
          }
          return result;
        };
        _createClass(BulletMovement_Line, [{
          key: "startPosition",
          get: function get() {
            return this._startPosition;
          }
        }]);
        return BulletMovement_Line;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 贝塞尔
       */
      var BulletMovement_Bezier = exports('BulletMovement_Bezier', /*#__PURE__*/function (_BulletMovement3) {
        _inheritsLoose(BulletMovement_Bezier, _BulletMovement3);
        function BulletMovement_Bezier() {
          var _this3;
          for (var _len3 = arguments.length, args = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
            args[_key3] = arguments[_key3];
          }
          _this3 = _BulletMovement3.call.apply(_BulletMovement3, [this].concat(args)) || this;
          /** 计算贝塞尔时间 0-1 */
          _this3._t = void 0;
          /** 曲线点数组, 起点终点控制点 */
          _this3._startPos = new Vec3();
          _this3._endPos = new Vec3();
          _this3._ctrlPos = new Vec3();
          return _this3;
        }
        var _proto4 = BulletMovement_Bezier.prototype;
        _proto4.reset = function reset() {
          _BulletMovement3.prototype.reset.call(this);
        };
        _proto4.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          var role = this._owner.owner;
          var target = this._owner.target;
          if (!target) {
            return;
          }
          this._t = 0;
          var offset = this._owner.bulletVO.offset;
          if (offset && offset.length > 0) {
            var index = bulletLauncherData.index;
            if (offset[index]) {
              var pos = this._owner.owner.node.worldPosition;
              this._startPos.set(pos.x + offset[index][0], pos.y + offset[index][1], pos.z);
            } else {
              this._isEnd = true;
              return;
            }
          } else {
            this._startPos = this._owner.owner.node.worldPosition;
          }
          if (this.owner.skill.targetPos.x > 0) {
            this._endPos = this.owner.skill.targetPos;
          } else {
            Vec3.add(this._endPos, target.node.worldPosition, target.getHitPosition());
          }
          // this._ctrlPos = this.getCtrlPoint(this._startPos, this._endPos, Math.PI * -0.95).multiplyScalar(1.1); //0.6
          this.getMidPoint();
        };
        _proto4.getMidPoint = function getMidPoint() {
          Vec3.add(this._ctrlPos, this._startPos, this._endPos);
          this._ctrlPos.multiplyScalar(0.5);
          var hight = 0; //Utils.GetRandomNum(-400, 400)
          if (this._owner.bulletVO.move_param.length === 2) {
            hight = Utils.GetRandomNum(this._owner.bulletVO.move_param[0], this._owner.bulletVO.move_param[1]);
          } else {
            hight = this._owner.bulletVO.move_param[0];
          }
          this._ctrlPos.add3f(0, hight, 0);
        };
        _proto4.onUpdate = function onUpdate(dt) {
          if (!this._owner.target) {
            this.owner.end();
            return;
          }
          if (this._isEnd) return;
          this.speed = this.getFrameSpeed() / 8;
          this._t += dt * this.speed;
          if (this._t > 1) {
            this._t = 1;
            this._isEnd = true;
          }
          var point = MathUtils.bessel2eLevel(this._t, this._startPos, this._ctrlPos, this._endPos);
          this._owner.node.setPosition(point.x, point.y);
          var angle = BattleUtil.get2DAngleByPoint(this._owner.node.position, this._endPos);
          this._owner.node.angle = angle;
        };
        _proto4.getCtrlPoint = function getCtrlPoint(p1, p2, theta) {
          var Mx = (p1.x + p2.x) / 2;
          var My = (p1.y + p2.y) / 2;
          var dx = p2.x - p1.x;
          var dy = p2.y - p1.y;
          var d = Math.sqrt(dx * dx + dy * dy);
          var r = d / (2 * Math.sin(theta / 2));
          var h = Math.sqrt(r * r - d / 2 * (d / 2));
          var Ox1 = Mx + dy / d * h;
          var Oy1 = My - dx / d * h;
          var C1x = Ox1 + dy / d * r;
          var C1y = Oy1 - dx / d * r;
          return v3(C1x, C1y);
        };
        return BulletMovement_Bezier;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 弹射
       */
      var BulletMovement_Catapults = exports('BulletMovement_Catapults', /*#__PURE__*/function (_BulletMovement4) {
        _inheritsLoose(BulletMovement_Catapults, _BulletMovement4);
        function BulletMovement_Catapults() {
          var _this4;
          for (var _len4 = arguments.length, args = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
            args[_key4] = arguments[_key4];
          }
          _this4 = _BulletMovement4.call.apply(_BulletMovement4, [this].concat(args)) || this;
          _this4._t = void 0;
          _this4._count = 4;
          return _this4;
        }
        var _proto5 = BulletMovement_Catapults.prototype;
        _proto5.reset = function reset() {
          _BulletMovement4.prototype.reset.call(this);
        };
        _proto5.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          var role = this._owner.owner;
          var target = this._owner.skill.getTarget();
        };
        _proto5.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          this._t += dt * this.speed;
          if (this._t > 1) {
            this._t = 1;
            this._isEnd = true;
          }
        };
        return BulletMovement_Catapults;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 环绕
       */
      var BulletMovement_Round = exports('BulletMovement_Round', /*#__PURE__*/function (_BulletMovement5) {
        _inheritsLoose(BulletMovement_Round, _BulletMovement5);
        function BulletMovement_Round() {
          var _this5;
          for (var _len5 = arguments.length, args = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
            args[_key5] = arguments[_key5];
          }
          _this5 = _BulletMovement5.call.apply(_BulletMovement5, [this].concat(args)) || this;
          _this5._t = void 0;
          //初始与圆心的夹角
          _this5.angle = 0;
          // 圆周运动的半径
          _this5.radius = 60;
          // 圆周运动的半径扩散值
          _this5.radiusAdd = 2;
          // 运动的速度（角速度，单位：弧度每秒）
          _this5.angularSpeed = void 0;
          _this5._needSetAngle = false;
          return _this5;
        }
        var _proto6 = BulletMovement_Round.prototype;
        _proto6.reset = function reset() {
          _BulletMovement5.prototype.reset.call(this);
        };
        _proto6.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          this.radius = this._owner.bulletVO.distance;
          this.angularSpeed = this._owner.bulletVO.angle_speed;
          // 圆心坐标
          var pos = this._owner.owner.getMountPoint("dummy_body", this._owner.owner.node.worldPosition);
          this._needSetAngle = this._owner.type !== GameBattle.BulletType.NoAngle;
          if (!this._needSetAngle) {
            this.owner.node.angle = 0;
          }
          var cx = pos.x;
          var cy = pos.y;
          var i = bulletLauncherData.index + BulletMovement_Round.allIndex;
          var angle = i * (2 * Math.PI / (bulletLauncherData.count * (BulletMovement_Round.allIndex + 1)));
          var x = cx + this.radius * Math.cos(angle);
          var y = cy + this.radius * Math.sin(angle);
          this.angle = angle;
          this.owner.node.setWorldPosition(x, y, 0);
          this.radiusAdd = 0;
          if (this._owner.bulletVO.move_param && this._owner.bulletVO.move_param.length > 0) {
            this.radiusAdd = this._owner.bulletVO.move_param[0];
            if (this._owner.bulletVO.move_param[1] && bulletLauncherData.index === 0) {
              BulletMovement_Round.allIndex++;
              BulletMovement_Round.allCount++;
              if (BulletMovement_Round.allCount === this._owner.bulletVO.move_param[1]) {
                BulletMovement_Round.allCount = 0;
                BulletMovement_Round.allIndex = 0;
              }
            }
          }
        };
        _proto6.onUpdate = function onUpdate(dt) {
          if (this._isEnd) {
            return;
          }
          if (this.owner.owner.state.type === GameBattle.ActionState.Dead) {
            this._isEnd = true;
            return;
          }
          // 更新角度
          this.angle += this.angularSpeed * dt;
          var pos = this._owner.owner.getMountPoint("dummy_body", this._owner.owner.node.worldPosition);
          var centerX = pos.x;
          var centerY = pos.y;
          this.radius += this.radiusAdd;
          // 计算新的位置
          var x = centerX + this.radius * Math.cos(this.angle);
          var y = centerY + this.radius * Math.sin(this.angle);

          // 设置节点的新位置
          this.owner.node.setWorldPosition(x, y, 0);
          if (this._needSetAngle) {
            // 计算节点与中心点的方向向量
            var direction = v2(centerX - x, centerY - y);
            // 计算方向向量的角度（弧度）
            var angleRadians = Math.atan2(direction.y, direction.x);

            // 将弧度转换为角度，并设置节点的旋转角度
            var angleDegrees = angleRadians * (180 / Math.PI);
            this.owner.node.angle = angleDegrees - 180;
          }
        };
        return BulletMovement_Round;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 火焰喷射器
       * 后面也用在怪物身上（皇庭信使一闪）
       */
      BulletMovement_Round.allIndex = 0;
      BulletMovement_Round.allCount = 0;
      var BulletMovement_FollowOwner = exports('BulletMovement_FollowOwner', /*#__PURE__*/function (_BulletMovement6) {
        _inheritsLoose(BulletMovement_FollowOwner, _BulletMovement6);
        function BulletMovement_FollowOwner() {
          var _this6;
          for (var _len6 = arguments.length, args = new Array(_len6), _key6 = 0; _key6 < _len6; _key6++) {
            args[_key6] = arguments[_key6];
          }
          _this6 = _BulletMovement6.call.apply(_BulletMovement6, [this].concat(args)) || this;
          _this6._step = 1;
          _this6._offsetAngle = 0;
          return _this6;
        }
        var _proto7 = BulletMovement_FollowOwner.prototype;
        _proto7.reset = function reset() {
          _BulletMovement6.prototype.reset.call(this);
        };
        _proto7.launch = function launch(bulletLauncherData) {
          var index = bulletLauncherData.index;
          var bulletowner = this.owner.owner;
          var attachment = bulletowner.node.getChildByName("attachment2");
          var pos = bulletowner.getLocalMountPoint(this._owner.bulletVO.position, v3(0, 0, 0));
          this._owner.node.setParent(attachment);
          this._owner.node.setPosition(pos);
          if (bulletowner.type !== GameBattle.RoleType.Hero) {
            //设置子弹朝向为怪物技能冲刺方向
            if (bulletowner.skillMoveDirVec) {
              var moveVec = bulletowner.skillMoveDirVec;
              var moveAngleRadians = Math.atan2(moveVec.y, moveVec.x);
              this._owner.node.angle = moveAngleRadians * (180 / Math.PI);
            }
            return;
          }
          var target = this._owner.skill.getTarget();
          if (target) {
            var endpos = this.tempPos;
            Vec3.add(endpos, target.node.worldPosition, target.getHitPosition());
            var angle = BattleUtil.get2DAngleByPoint(this._owner.node.worldPosition, endpos);
            var offset = this._owner.skill.launch_angle * 180 / 3.141592653;
            if (bulletLauncherData.count > 1) {
              this._offsetAngle = offset * Math.ceil(index / 2) * (index % 2 === 0 ? -1 : 1);
            }
            this._owner.node.angle = angle + this._offsetAngle;
          }
          this._step = this._owner.bulletVO.angle_speed;
        };
        _proto7.onUpdate = function onUpdate(dt) {
          var target = this._owner.skill.getTarget();
          if (!target) return;
          var bulletowner = this.owner.owner;
          var angle = BattleUtil.get2DAngleByPoint(this._owner.node.worldPosition, target.node.worldPosition) + this._offsetAngle;

          // 确保目标角度在 0 到 360 度之间
          var targetAngle = (angle + 360) % 360;
          var currentAngle = (this._owner.node.angle + 360) % 360;

          // 如果两者的角度差大于 180 度，说明跨越了 0 度的边界，需要调整
          if (Math.abs(targetAngle - currentAngle) > 180) {
            if (targetAngle > currentAngle) {
              targetAngle -= 360;
            } else {
              currentAngle -= 360;
            }
          }
          var difference = targetAngle - currentAngle;

          // 如果差值大于步长，继续平滑旋转
          if (Math.abs(difference) > this._step) {
            if (difference > 0) {
              this._owner.node.angle += this._step;
            } else {
              this._owner.node.angle -= this._step;
            }
          } else {
            this._owner.node.angle = angle; // 目标角度已足够接近，直接设置
          }
        };

        return BulletMovement_FollowOwner;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 跟随武器
       */
      var BulletMovement_FollowWeapon = exports('BulletMovement_FollowWeapon', /*#__PURE__*/function (_BulletMovement7) {
        _inheritsLoose(BulletMovement_FollowWeapon, _BulletMovement7);
        function BulletMovement_FollowWeapon() {
          var _this7;
          for (var _len7 = arguments.length, args = new Array(_len7), _key7 = 0; _key7 < _len7; _key7++) {
            args[_key7] = arguments[_key7];
          }
          _this7 = _BulletMovement7.call.apply(_BulletMovement7, [this].concat(args)) || this;
          _this7.index = void 0;
          _this7.count = void 0;
          _this7.angle = void 0;
          return _this7;
        }
        var _proto8 = BulletMovement_FollowWeapon.prototype;
        _proto8.reset = function reset() {
          _BulletMovement7.prototype.reset.call(this);
        };
        _proto8.launch = function launch(bulletLauncherData) {
          this.index = bulletLauncherData.index;
        };
        _proto8.onUpdate = function onUpdate(dt) {
          var hookNode = this.owner.owner.node.getChildByPath("Weapons/Hook" + this.index);
          var ske = hookNode.getComponent(sp.Skeleton);
          var HookX_bone = ske.findBone("HookX");
          if (HookX_bone) {
            var _ske$node$uiTransform;
            // 获取骨骼的局部坐标（相对于Skeleton的坐标）
            var localPosition = v3(HookX_bone.worldX, HookX_bone.worldY, 0);
            (_ske$node$uiTransform = ske.node.uiTransform) == null || _ske$node$uiTransform.convertToWorldSpaceAR(localPosition, this.tempPos);
            this.owner.node.setWorldPosition(this.tempPos);
          }
        };
        return BulletMovement_FollowWeapon;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 石壁召唤
       */
      var BulletMovement_FollowZhaoHuan = exports('BulletMovement_FollowZhaoHuan', /*#__PURE__*/function (_BulletMovement8) {
        _inheritsLoose(BulletMovement_FollowZhaoHuan, _BulletMovement8);
        function BulletMovement_FollowZhaoHuan() {
          return _BulletMovement8.apply(this, arguments) || this;
        }
        return BulletMovement_FollowZhaoHuan;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 创建在施法者身上
       */
      var BulletMovement_inCreator = exports('BulletMovement_inCreator', /*#__PURE__*/function (_BulletMovement9) {
        _inheritsLoose(BulletMovement_inCreator, _BulletMovement9);
        function BulletMovement_inCreator() {
          return _BulletMovement9.apply(this, arguments) || this;
        }
        var _proto9 = BulletMovement_inCreator.prototype;
        _proto9.reset = function reset() {
          _BulletMovement9.prototype.reset.call(this);
        }

        /**
         * 重置子弹的本地位置
         * @param isRight 是否朝右
         */;
        _proto9.resetLocalPosition = function resetLocalPosition(isRight) {
          var x = 0;
          var y = 0;
          //加上初始偏移量
          if (this._owner.bulletVO.moveType === GameBattle.BulletMoveType.InCreatorTaiDao) {
            if (this._owner.bulletVO.offset[0] && this._owner.bulletVO.offset[0].length === 2) {
              x = isRight ? this._owner.bulletVO.offset[0][0] : -this._owner.bulletVO.offset[0][0];
              y = this._owner.bulletVO.offset[0][1];
            }
          }
          this.owner.node.setPosition(x, y);
        };
        _proto9.launch = function launch(bulletLauncherData) {
          this.owner.node.parent = this.owner.owner.node;
          var ownerDir = this.owner.owner.curDirection;
          var isRight = ownerDir === GameBattle.Direction.Right || ownerDir === GameBattle.Direction.RightUp || ownerDir === GameBattle.Direction.RightDown;
          this.resetLocalPosition(isRight);
          if (this._owner.bulletVO.hierarchy === 2) {
            this._owner.node.setSiblingIndex(0);
          }
          if (this._owner.bulletVO.type === GameBattle.BulletType.NoAngle) {
            // 非无角度子弹
            this.owner.node.angle = 0;
          }
        };
        _proto9.onUpdate = function onUpdate(dt) {
          //挂在施法者身上的近战刀光，需要根据施法者朝向翻转
          if (this._owner.bulletVO.moveType === GameBattle.BulletMoveType.InCreatorTaiDao) {
            var ownerDir = this.owner.owner.curDirection;
            var isRight = ownerDir === GameBattle.Direction.Right || ownerDir === GameBattle.Direction.RightUp || ownerDir === GameBattle.Direction.RightDown;
            if (isRight) {
              this.owner.node.setScale(Math.abs(this.owner.node.scale.x), this.owner.node.scale.y, this.owner.node.scale.z);
            } else {
              this.owner.node.setScale(-Math.abs(this.owner.node.scale.x), this.owner.node.scale.y, this.owner.node.scale.z);
            }
            this.resetLocalPosition(isRight);
          }
        };
        return BulletMovement_inCreator;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 弹跳子弹 (弹射)
       */
      var BulletMovement_TanTiao = exports('BulletMovement_TanTiao', /*#__PURE__*/function (_BulletMovement10) {
        _inheritsLoose(BulletMovement_TanTiao, _BulletMovement10);
        function BulletMovement_TanTiao() {
          var _this8;
          for (var _len8 = arguments.length, args = new Array(_len8), _key8 = 0; _key8 < _len8; _key8++) {
            args[_key8] = arguments[_key8];
          }
          _this8 = _BulletMovement10.call.apply(_BulletMovement10, [this].concat(args)) || this;
          _this8.target = void 0;
          _this8.needClean = false;
          _this8.catchTargetList = [];
          _this8.catapults_num = 0;
          return _this8;
        }
        var _proto10 = BulletMovement_TanTiao.prototype;
        //弹跳次数
        _proto10.reset = function reset() {
          _BulletMovement10.prototype.reset.call(this);
        };
        _proto10.getTarget = function getTarget() {
          var target = this._owner.skill.getTarget();
          if (!target) {
            this.target = target;
            this.isEnd = true;
            return;
          }
          var map = App.battleMgr.roleCtrl.getRolesByType(target.type);
          var range = this.owner.bulletVO.catapult_srange;
          target = null;
          var list = [];
          for (var i in map) {
            var role = map[i];
            if (!role.checkValid()) {
              continue;
            }
            if (this.catchTargetList.indexOf(role.uid) > -1) {
              continue;
            }
            list.push(role);
          }
          if (list.length > 0) {
            target = null;
            var distance = -1;
            for (var _i = 0; _i < list.length; _i++) {
              var dis = Vec3.distance(this.owner.node.worldPosition, list[_i].node.worldPosition);
              if (dis < range && dis > distance) {
                target = list[_i];
                distance = dis;
              }
            }
          }
          this.target = target;
          if (!this.target) {
            this.isEnd = true;
          } else {
            if (this.needClean) {
              this.catchTargetList.pop();
            }
            this.catchTargetList.push(target.uid);
          }
        };
        _proto10.launch = function launch(bulletLauncherData) {
          this.target = this._owner.target;
          this.catchTargetList = [this.target.uid];
          this.catapults_num = this.owner.bulletVO.catapults_num;
          this._isEnd = false;
          this.needClean = this.owner.bulletVO.repeat;
        };
        _proto10.onHit = function onHit(target) {
          // console.log('onHit', target.uid);
        };
        _proto10.tanShe = function tanShe(target) {
          if (!this.target || this.target.uid !== target.uid) {
            this.catchTargetList.pop();
            this.target = target;
            this.catchTargetList.push(target.uid);
          }
          this.catapults_num--;
          if (this.catapults_num <= 0) {
            this._isEnd = true;
            return;
          }
          this.getTarget();
        };
        _proto10.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          if (!this.target || !this.target.checkValid()) {
            this._isEnd = true;
            return;
          }
          var startPos = this._owner.node.worldPosition;
          var endPos = this.target.getHitWorldPosition();
          var frameSpeed = this.getFrameSpeed();
          //let pos = endPos.clone().subtract(startPos).normalize().multiplyScalar(frameSpeed);
          Vec3.subtract(this.tempPos, endPos, startPos);
          var pos = this.tempPos.normalize().multiplyScalar(frameSpeed);
          this._owner.node.x += pos.x;
          this._owner.node.y += pos.y;
          var angle = BattleUtil.get2DAngleByPoint(startPos, endPos);
          this._owner.node.angle = angle;
          var distance = Vec3.distance(startPos, endPos);
          if (distance <= frameSpeed) {
            this.tanShe(this.target);
          }
        };
        return BulletMovement_TanTiao;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 环绕子弹运动
       */
      var BulletMovement_RoundBullet = exports('BulletMovement_RoundBullet', /*#__PURE__*/function (_BulletMovement11) {
        _inheritsLoose(BulletMovement_RoundBullet, _BulletMovement11);
        function BulletMovement_RoundBullet() {
          var _this9;
          for (var _len9 = arguments.length, args = new Array(_len9), _key9 = 0; _key9 < _len9; _key9++) {
            args[_key9] = arguments[_key9];
          }
          _this9 = _BulletMovement11.call.apply(_BulletMovement11, [this].concat(args)) || this;
          _this9._t = void 0;
          //初始与圆心的夹角
          _this9.angle = 0;
          // 圆周运动的半径
          _this9.radius = void 0;
          // 运动的速度（角速度，单位：弧度每秒）
          _this9.angularSpeed = void 0;
          _this9._count = 4;
          _this9.target = null;
          return _this9;
        }
        var _proto11 = BulletMovement_RoundBullet.prototype;
        _proto11.reset = function reset() {
          _BulletMovement11.prototype.reset.call(this);
        };
        _proto11.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          this.radius = this._owner.bulletVO.distance;
          this.angularSpeed = this._owner.bulletVO.angle_speed;
          var bulletId = Number(this._owner.bulletVO.position);
          var bullets = App.battleMgr.bulletCtrl.getBulletsByBullId(bulletId);
          if (bullets.length > 0) {
            this.target = bullets.pop();
          }
          // 圆心坐标
          var pos = this.target.node.worldPosition;
          var cx = pos.x;
          var cy = pos.y;
          var i = bulletLauncherData.index;
          var angle = i * (2 * Math.PI / bulletLauncherData.count); // 0, 120, 240 度对应的弧度
          var x = cx + this.radius * Math.cos(angle);
          var y = cy + this.radius * Math.sin(angle);
          this.angle = angle;
          this.owner.node.setWorldPosition(x, y, 0);
          this.owner.node.angle = 0;
        };
        _proto11.onUpdate = function onUpdate(dt) {
          if (!this.target || !this.target.checkValid()) {
            this.isEnd = true;
            return;
          }

          // 更新角度
          this.angle += this.angularSpeed * dt;
          var pos = this.target.node.worldPosition;
          var centerX = pos.x;
          var centerY = pos.y;
          // 计算新的位置
          var x = centerX + this.radius * Math.cos(this.angle);
          var y = centerY + this.radius * Math.sin(this.angle);

          // 设置节点的新位置
          this.owner.node.setWorldPosition(x, y, 0);

          // // 计算节点与中心点的方向向量
          // let direction = v2(centerX - x, centerY - y);

          // // 计算方向向量的角度（弧度）
          // let angleRadians = Math.atan2(direction.y, direction.x);

          // // 将弧度转换为角度，并设置节点的旋转角度
          // let angleDegrees = angleRadians * (180 / Math.PI);
          // this.owner.node.angle = angleDegrees - 180;
        };

        return BulletMovement_RoundBullet;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 乌云
       */
      var BulletMovement_Lock = exports('BulletMovement_Lock', /*#__PURE__*/function (_BulletMovement12) {
        _inheritsLoose(BulletMovement_Lock, _BulletMovement12);
        function BulletMovement_Lock() {
          var _this10;
          for (var _len10 = arguments.length, args = new Array(_len10), _key10 = 0; _key10 < _len10; _key10++) {
            args[_key10] = arguments[_key10];
          }
          _this10 = _BulletMovement12.call.apply(_BulletMovement12, [this].concat(args)) || this;
          _this10.target = null;
          return _this10;
        }
        var _proto12 = BulletMovement_Lock.prototype;
        _proto12.reset = function reset() {
          _BulletMovement12.prototype.reset.call(this);
        };
        _proto12.launch = function launch(bulletLauncherData) {
          this.speed = this.getFrameSpeed();
          this.target = this._owner.skill.getTarget();
          this._owner.node.angle = 0;
          this._owner.node.setWorldPosition(this._owner.owner.node.worldPosition);
        };
        _proto12.onUpdate = function onUpdate(dt) {
          if (!this.target || !this.target.checkValid() || this.target.uid === this.owner.owner.uid) {
            this.target = this._owner.skill.getTarget();
            if (!this.target) {
              this.target = this.owner.owner;
            }
          }
          var startPos = this._owner.node.worldPosition;
          //const endPos = this.target.node.worldPosition.clone();
          // endPos.add(this.target.getHitPosition());
          //let pos = endPos.clone().subtract(startPos).normalize().multiplyScalar(this.speed);
          Vec3.subtract(this.tempPos, this.target.node.worldPosition, startPos);
          var pos = this.tempPos.normalize().multiplyScalar(this.speed);
          pos.add(startPos);
          this._owner.node.position = pos;
        };
        return BulletMovement_Lock;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 创建在目标位置上
       */
      var BulletMovement_onTarget = exports('BulletMovement_onTarget', /*#__PURE__*/function (_BulletMovement13) {
        _inheritsLoose(BulletMovement_onTarget, _BulletMovement13);
        function BulletMovement_onTarget() {
          return _BulletMovement13.apply(this, arguments) || this;
        }
        var _proto13 = BulletMovement_onTarget.prototype;
        _proto13.reset = function reset() {
          _BulletMovement13.prototype.reset.call(this);
        };
        _proto13.launch = function launch(bulletLauncherData) {
          var target = this._owner.target;
          if (!target) {
            return;
          }
          if (this._owner.bulletVO.move_param && this._owner.bulletVO.move_param.length > 0) {
            //最大半径
            var _this$_owner$bulletVO = this._owner.bulletVO.move_param,
              min = _this$_owner$bulletVO[0],
              max = _this$_owner$bulletVO[1];
            //随机半径
            var r = 0;
            if (max) {
              r = Utils.GetRandomNum(min, max);
            } else {
              r = Utils.GetRandomNum(0, min);
            }
            //随机角度
            var theta = Math.random() * (2 * Math.PI);
            var x = target.node.worldPosition.x + r * Math.cos(theta);
            var y = target.node.worldPosition.y + r * Math.sin(theta);
            this.owner.node.setWorldPosition(x, y, target.node.worldPosition.z);
          } else {
            this.owner.node.setWorldPosition(target.node.worldPosition.x, target.node.worldPosition.y, target.node.worldPosition.z);
          }
          this.owner.node.angle = 0;
        };
        _proto13.onUpdate = function onUpdate(dt) {};
        return BulletMovement_onTarget;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 延展子弹(例如裂地波)
       */
      var BulletMovement_YanZhan = exports('BulletMovement_YanZhan', /*#__PURE__*/function (_BulletMovement14) {
        _inheritsLoose(BulletMovement_YanZhan, _BulletMovement14);
        function BulletMovement_YanZhan() {
          return _BulletMovement14.apply(this, arguments) || this;
        }
        var _proto14 = BulletMovement_YanZhan.prototype;
        _proto14.reset = function reset() {
          _BulletMovement14.prototype.reset.call(this);
        };
        _proto14.launch = function launch(bulletLauncherData) {
          var _this11 = this;
          var target = this._owner.target;
          if (this._owner.bulletVO.type !== GameBattle.BulletType.NoAngle) {
            var pos = this._owner.owner.getFirePosition();
            this.owner.node.setWorldPosition(pos.x, pos.y, pos.z);
            //const endPos = target.node.worldPosition.clone().add(target.getHitPosition());
            Vec3.add(this.tempPos, target.node.worldPosition, target.getHitPosition());
            var endPos = this.tempPos;
            var angle = BattleUtil.get2DAngleByPoint(pos, endPos);
            this._owner.node.angle = angle;
          }
          var _this$_owner$bulletVO2 = this._owner.bulletVO.move_param,
            w = _this$_owner$bulletVO2[0],
            h = _this$_owner$bulletVO2[1],
            tm = _this$_owner$bulletVO2[2];
          var size = new Size(w, h);
          tween(this._owner.hitBox).tag(GameBattle.BattleTweenTag).to(tm, {
            contentSize: size
          }).call(function () {
            _this11._isEnd = true;
          }).start();
        };
        return BulletMovement_YanZhan;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 直接创建在预警位置
       */
      var BulletMovement_Warning = exports('BulletMovement_Warning', /*#__PURE__*/function (_BulletMovement15) {
        _inheritsLoose(BulletMovement_Warning, _BulletMovement15);
        function BulletMovement_Warning() {
          return _BulletMovement15.apply(this, arguments) || this;
        }
        var _proto15 = BulletMovement_Warning.prototype;
        _proto15.reset = function reset() {
          _BulletMovement15.prototype.reset.call(this);
        };
        _proto15.launch = function launch(bulletLauncherData) {
          var pos = this.owner.skill.targetPos;
          this.owner.node.setWorldPosition(pos.x, pos.y, pos.z);
        };
        return BulletMovement_Warning;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 有角速度的跟随
       */
      var BulletMovement_AngularFollow = exports('BulletMovement_AngularFollow', /*#__PURE__*/function (_BulletMovement16) {
        _inheritsLoose(BulletMovement_AngularFollow, _BulletMovement16);
        function BulletMovement_AngularFollow() {
          var _this12;
          for (var _len11 = arguments.length, args = new Array(_len11), _key11 = 0; _key11 < _len11; _key11++) {
            args[_key11] = arguments[_key11];
          }
          _this12 = _BulletMovement16.call.apply(_BulletMovement16, [this].concat(args)) || this;
          /** 目标 */
          _this12._target = void 0;
          /** 当前角度 */
          _this12._currentAngle = 0;
          /** 当前飞行距离 */
          _this12._traveledDistance = 0;
          /** 起始位置 */
          _this12._startPosition = new Vec3();
          /** 存活时间 */
          _this12._aliveTime = 0;
          return _this12;
        }
        var _proto16 = BulletMovement_AngularFollow.prototype;
        _proto16.reset = function reset() {
          this._target = null;
          this._currentAngle = 0;
          this._traveledDistance = 0;
          this._aliveTime = 0;
          this._startPosition.set(Vec3.ZERO);
          this._isEnd = false;
        };
        _proto16.launch = function launch(bulletLauncherData) {
          this.lockAngle = this._owner.bulletVO.type === GameBattle.BulletType.NoAngle;
          this._target = this._owner.target;
          this.speed = this._owner.bulletVO.initialSpeed;
          this._startPosition = this._owner.node.worldPosition;

          // 初始角度设置为朝向目标
          if (this._target) {
            var startPos = this._owner.node.worldPosition;
            var endPos = this._target.node.worldPosition;
            this._currentAngle = Math.atan2(endPos.y - startPos.y, endPos.x - startPos.x);
            !this.lockAngle && (this._owner.node.angle = this._currentAngle * 180 / Math.PI);
          }
        };
        _proto16.onUpdate = function onUpdate(dt) {
          if (!this._target || !this._target.checkValid()) {
            this._isEnd = true;
            return;
          }

          // 更新存活时间
          this._aliveTime += dt;
          if (this._owner.bulletVO.holding_time > 0 && this._aliveTime >= this._owner.bulletVO.holding_time) {
            this._isEnd = true;
            return;
          }

          // 获取目标方向
          var startPos = this._owner.node.worldPosition;
          //const endPos = this._target.node.worldPosition.clone().add(this._target.getHitPosition());
          Vec3.add(this.tempPos, this._target.node.worldPosition, this._target.getHitPosition());
          var endPos = this.tempPos;
          var targetAngle = Math.atan2(endPos.y - startPos.y, endPos.x - startPos.x);

          // 计算角度差
          var angleDiff = targetAngle - this._currentAngle;
          while (angleDiff > Math.PI) angleDiff -= Math.PI * 2;
          while (angleDiff < -Math.PI) angleDiff += Math.PI * 2;

          // 根据角速度调整当前角度
          var angleSpeed = this._owner.bulletVO.angle_speed; // 角速度（弧度/秒）
          var maxAngleStep = angleSpeed * dt;
          this._currentAngle += Math.sign(angleDiff) * Math.min(Math.abs(angleDiff), maxAngleStep);

          // 计算移动方向和新位置
          var moveDir = new Vec3(Math.cos(this._currentAngle), Math.sin(this._currentAngle), 0);

          // 应用速度
          var frameSpeed = this.speed * dt;
          //const newPos = startPos.clone().add(moveDir.multiplyScalar(frameSpeed));
          Vec3.add(this.tempVec, startPos, moveDir.multiplyScalar(frameSpeed));
          var newPos = this.tempVec;

          // 更新位置和角度
          this._owner.node.setWorldPosition(newPos);
          !this.lockAngle && (this._owner.node.angle = this._currentAngle * 180 / Math.PI);

          // 更新已飞行距离
          var distanceMoved = Vec3.distance(startPos, newPos);
          this._traveledDistance += distanceMoved;

          // 检查是否达到最大距离
          if (this._owner.bulletVO.distance > 0 && this._traveledDistance >= this._owner.bulletVO.distance) {
            this._isEnd = true;
            return;
          }
        };
        _proto16.onHit = function onHit(target) {
          this._isEnd = true;
        };
        return BulletMovement_AngularFollow;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 回旋子弹
       */
      var BulletMovement_HuiXuan = exports('BulletMovement_HuiXuan', /*#__PURE__*/function (_BulletMovement17) {
        _inheritsLoose(BulletMovement_HuiXuan, _BulletMovement17);
        function BulletMovement_HuiXuan() {
          var _this13;
          for (var _len12 = arguments.length, args = new Array(_len12), _key12 = 0; _key12 < _len12; _key12++) {
            args[_key12] = arguments[_key12];
          }
          _this13 = _BulletMovement17.call.apply(_BulletMovement17, [this].concat(args)) || this;
          _this13._tween = null;
          return _this13;
        }
        var _proto17 = BulletMovement_HuiXuan.prototype;
        _proto17.reset = function reset() {
          if (this._tween) {
            this._tween.stop();
            this._tween = null;
          }
          _BulletMovement17.prototype.reset.call(this);
        };
        _proto17.launch = function launch(bulletLauncherData) {
          if (this._direction.x === 0 && this._direction.y === 0) {
            this._direction.x = 1;
          }

          // let target=this.owner.owner.lockTargetCtrl.target;
          // if(target&&this.owner.owner.type===GameBattle.RoleType.Player){
          //     this._direction=target.node.worldPosition.clone().subtract(this.owner.node.worldPosition).normalize();
          // }

          var startPos = this._owner.owner.getFirePosition2();
          console.log(">>>>>>>>> startPosstartPosstartPos:", startPos);
          this._owner.node.setWorldPosition(startPos);
          var frameSpeed = this.getFrameSpeed();
          //const offset = this._direction.clone().multiplyScalar(frameSpeed);
          Vec3.multiplyScalar(this.tempVec, this._direction, frameSpeed);
          var offset = this.tempVec;
          var node = this._owner.node;
          var self = this;
          var tm = this._owner.bulletVO.distance / this._owner.bulletVO.initialSpeed;
          var _this$_owner$bulletVO3 = this._owner.bulletVO.move_param,
            hole_tm = _this$_owner$bulletVO3[0];
          this._tween = tween(node).tag(GameBattle.BattleTweenTag).to(tm, {
            scale_z: 1
          }, {
            onUpdate: function onUpdate(target, ratio) {
              node.worldPosition = node.worldPosition.add(offset);
            }
          }).delay(hole_tm).to(tm, {
            worldPosition: startPos
          }).call(function () {
            self._isEnd = true;
          }).start();
        };
        return BulletMovement_HuiXuan;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 寒冰激光
       */
      var BulletMovement_HanBingJiGuang = exports('BulletMovement_HanBingJiGuang', /*#__PURE__*/function (_BulletMovement18) {
        _inheritsLoose(BulletMovement_HanBingJiGuang, _BulletMovement18);
        function BulletMovement_HanBingJiGuang() {
          return _BulletMovement18.apply(this, arguments) || this;
        }
        var _proto18 = BulletMovement_HanBingJiGuang.prototype;
        _proto18.reset = function reset() {
          _BulletMovement18.prototype.reset.call(this);
        };
        _proto18.launch = function launch(bulletLauncherData) {
          var target = this._owner.target;
          //最大半径
          var _this$_owner$bulletVO4 = this._owner.bulletVO.move_param,
            r = _this$_owner$bulletVO4[0],
            max = _this$_owner$bulletVO4[1];
          //随机角度
          var theta = Math.random() * (2 * Math.PI);
          var x = target.node.worldPosition.x + r * Math.cos(theta);
          var y = target.node.worldPosition.y + r * Math.sin(theta);
          this.owner.node.setWorldPosition(x, y, target.node.worldPosition.z);
          this.owner.node.angle = Math.random() * 360;
        };
        _proto18.onUpdate = function onUpdate(dt) {};
        return BulletMovement_HanBingJiGuang;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 火焰吐息
       */
      var BulletMovement_HuoYanTuXi = exports('BulletMovement_HuoYanTuXi', /*#__PURE__*/function (_BulletMovement19) {
        _inheritsLoose(BulletMovement_HuoYanTuXi, _BulletMovement19);
        function BulletMovement_HuoYanTuXi() {
          return _BulletMovement19.apply(this, arguments) || this;
        }
        var _proto19 = BulletMovement_HuoYanTuXi.prototype;
        _proto19.reset = function reset() {
          _BulletMovement19.prototype.reset.call(this);
        };
        _proto19.launch = function launch(bulletLauncherData) {
          //console.log('火炎吐息---------->>> ',bulletLauncherData.index,bulletLauncherData.count);
          var target = this._owner.target;
          var _this$_owner$bulletVO5 = this._owner.bulletVO.move_param,
            range = _this$_owner$bulletVO5[0],
            spaceMin = _this$_owner$bulletVO5[1],
            spaceMax = _this$_owner$bulletVO5[2];
          var index = bulletLauncherData.index;
          var count = bulletLauncherData.count;
          var startOffsetX;
          if (index === count - 1) {
            startOffsetX = Utils.GetRandomNum(-range, range);
            BulletMovement_HuoYanTuXi.lastStartOffsetX = startOffsetX;
            //console.log('-------------------------startX',startOffsetX);
          } else {
            startOffsetX = BulletMovement_HuoYanTuXi.lastStartOffsetX;
            //console.log('+++++++lastStartX',startOffsetX);
          }

          var spaceX = Utils.GetRandomNum(spaceMin, spaceMax);
          var dir = index % 2 === 0 ? 1 : -1;
          var x = target.node.worldPosition.x + startOffsetX + dir * spaceX * Math.floor((index + 1) / 2);
          var y = target.node.worldPosition.y;
          this.owner.node.setWorldPosition(x, y, target.node.worldPosition.z);
          //console.log('火炎吐息---------->>> ',startOffsetX,dir*spaceX*(Math.floor((index+1)/2)));
        };

        _proto19.onUpdate = function onUpdate(dt) {};
        return BulletMovement_HuoYanTuXi;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 飞向玩家的子弹
       */
      BulletMovement_HuoYanTuXi.lastStartOffsetX = 0;
      var BulletMovement_ToPlayer = exports('BulletMovement_ToPlayer', /*#__PURE__*/function (_BulletMovement20) {
        _inheritsLoose(BulletMovement_ToPlayer, _BulletMovement20);
        function BulletMovement_ToPlayer() {
          var _this14;
          for (var _len13 = arguments.length, args = new Array(_len13), _key13 = 0; _key13 < _len13; _key13++) {
            args[_key13] = arguments[_key13];
          }
          _this14 = _BulletMovement20.call.apply(_BulletMovement20, [this].concat(args)) || this;
          /** 计算贝塞尔时间 0-1 */
          _this14._t = void 0;
          /** 曲线点数组, 起点终点控制点 */
          _this14._startPos = void 0;
          _this14._endPos = void 0;
          _this14._ctrlPos = new Vec3();
          _this14._target = null;
          return _this14;
        }
        var _proto20 = BulletMovement_ToPlayer.prototype;
        _proto20.reset = function reset() {
          _BulletMovement20.prototype.reset.call(this);
        };
        _proto20.launch = function launch(bulletLauncherData) {
          this._owner.targetType = GameBattle.SkillApplyTarget.Self;
          this.speed = this._owner.bulletVO.initialSpeed;
          this._target = App.battleMgr.roleCtrl.player;
          this._t = 0;
          this._startPos = this._owner.node.worldPosition;
          //this._endPos = this._target.node.worldPosition.clone().add(this._target.getHitPosition());
          Vec3.add(this.tempPos, this._target.node.worldPosition, this._target.getHitPosition());
          this._endPos = this.tempPos;
          this.getMidPoint();
        };
        _proto20.getMidPoint = function getMidPoint() {
          Vec3.add(this._ctrlPos, this._startPos, this._endPos);
          this._ctrlPos.multiplyScalar(0.5);
          var hight = 0; //Utils.GetRandomNum(-400, 400)
          if (this._owner.bulletVO.move_param.length === 2) {
            hight = Utils.GetRandomNum(this._owner.bulletVO.move_param[0], this._owner.bulletVO.move_param[1]);
          } else if (this._owner.bulletVO.move_param.length === 1) {
            hight = this._owner.bulletVO.move_param[0];
          }
          this._ctrlPos.add3f(0, hight, 0);
        };
        _proto20.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          this.speed = this.getFrameSpeed() / 8;
          this._t += dt * this.speed;
          if (this._t > 1) {
            this._t = 1;
            this._isEnd = true;
          }
          //this._endPos = this._target.node.worldPosition.clone().add(this._target.getHitPosition());
          Vec3.add(this.tempPos, this._target.node.worldPosition, this._target.getHitPosition());
          this._endPos = this.tempPos;
          var point = MathUtils.bessel2eLevel(this._t, this._startPos, this._ctrlPos, this._endPos);
          this._owner.node.setWorldPosition(point.x, point.y, 0);
          var angle = BattleUtil.get2DAngleByPoint(this._owner.node.position, this._endPos);
          this._owner.node.angle = angle;
        };
        return BulletMovement_ToPlayer;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 直线分裂
       */
      var BulletMovement_ZhiXianFenLie = exports('BulletMovement_ZhiXianFenLie', /*#__PURE__*/function (_BulletMovement21) {
        _inheritsLoose(BulletMovement_ZhiXianFenLie, _BulletMovement21);
        function BulletMovement_ZhiXianFenLie() {
          var _this15;
          for (var _len14 = arguments.length, args = new Array(_len14), _key14 = 0; _key14 < _len14; _key14++) {
            args[_key14] = arguments[_key14];
          }
          _this15 = _BulletMovement21.call.apply(_BulletMovement21, [this].concat(args)) || this;
          /** 起始位置 */
          _this15._startPosition = new Vec3();
          return _this15;
        }
        var _proto21 = BulletMovement_ZhiXianFenLie.prototype;
        _proto21.reset = function reset() {
          _BulletMovement21.prototype.reset.call(this);
          this._direction.set(0, 0, 0);
          this._startPosition.set(0, 0, 0);
        };
        _proto21.init = function init() {};
        _proto21.launch = function launch(bulletLauncherData) {
          var _this$_owner$bulletVO6 = this._owner.bulletVO.move_param,
            angle = _this$_owner$bulletVO6[0];
          if (!angle) {
            angle = 0;
          }
          var theta = angle * Math.ceil(bulletLauncherData.index / 2) * (bulletLauncherData.index % 2 === 0 ? -1 : 1);
          var dir = MathUtils.angleToDirection(theta);
          this._direction.set(dir.x, dir.y, 0);
          this._direction = this._direction.normalize();
          this._startPosition.set(this._owner.node.worldPosition);
        };
        _proto21.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          if (this._checkDistance()) {
            this._isEnd = true;
            return;
          }
          var frameSpeed = this.getFrameSpeed();
          //const offset = this._direction.clone().multiplyScalar(frameSpeed);
          Vec3.multiplyScalar(this.tempVec, this._direction, frameSpeed);
          var offset = this.tempVec;

          // const pos = this._owner.node.worldPosition.clone();
          Vec3.add(this.tempPos, this._owner.node.worldPosition, offset);
          this._owner.node.worldPosition = this.tempPos;
        }

        /**
         * 检测是否达到设定距离
         * @returns
         */;
        _proto21._checkDistance = function _checkDistance() {
          var result = true;
          var maxDistance = this._owner.bulletVO.distance;
          if (maxDistance === -1) {
            // 无限距离
            result = false;
          } else {
            //const distance = this._owner.node.worldPosition.clone().subtract(this._startPosition).length();
            Vec3.subtract(this.tempVec, this._owner.node.worldPosition, this._startPosition);
            var distance = this.tempVec.length();
            result = distance >= maxDistance;
          }
          return result;
        };
        _createClass(BulletMovement_ZhiXianFenLie, [{
          key: "startPosition",
          get: function get() {
            return this._startPosition;
          }
        }]);
        return BulletMovement_ZhiXianFenLie;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 弹力球，碰到镜头边缘反弹
       */
      var BulletMovement_TanLiQiu = exports('BulletMovement_TanLiQiu', /*#__PURE__*/function (_BulletMovement22) {
        _inheritsLoose(BulletMovement_TanLiQiu, _BulletMovement22);
        function BulletMovement_TanLiQiu() {
          var _this16;
          for (var _len15 = arguments.length, args = new Array(_len15), _key15 = 0; _key15 < _len15; _key15++) {
            args[_key15] = arguments[_key15];
          }
          _this16 = _BulletMovement22.call.apply(_BulletMovement22, [this].concat(args)) || this;
          /** 起始位置 */
          _this16._startPosition = new Vec3();
          /**累计的移动路程 */
          _this16._moveDisAll = 0;
          /** 反弹位置 */
          _this16._reboundPosition = new Vec3();
          return _this16;
        }
        var _proto22 = BulletMovement_TanLiQiu.prototype;
        _proto22.reset = function reset() {
          _BulletMovement22.prototype.reset.call(this);
          this._direction.set(0, 0, 0);
          this._startPosition.set(0, 0, 0);
          this._moveDisAll = 0;
        };
        _proto22.init = function init() {
          this._moveDisAll = 0;
        };
        _proto22.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          var startPos = this._owner.node.worldPosition;
          if (this._direction.x === 0 && this._direction.y === 0) {
            this._direction.x = 1;
          }
          this._startPosition.set(startPos);
          this._reboundPosition.set(startPos);
          if (this._owner.bulletVO.type === GameBattle.BulletType.NoAngle) {
            this._owner.node.angle = 0;
          }
        };
        _proto22.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          if (this._checkDistance()) {
            this._isEnd = true;
            return;
          }
          if (this._direction.x === 0 && this._direction.y === 0) return;
          this.speed = this.getMoveSpeed();
          var frameSpeed = this.speed * dt;
          //const offset = this._direction.clone().multiplyScalar(frameSpeed);
          Vec3.multiplyScalar(this.tempVec, this._direction, frameSpeed);
          var offset = this.tempVec;
          //const pos = this._owner.node.worldPosition.clone();
          Vec3.add(this.tempPos, this._owner.node.worldPosition, offset);
          this._owner.node.worldPosition = this.tempPos;

          //碰到镜头边缘后反弹
          var playerCamera = App.battleMgr.battleMainViewCtrl.playerCamera.camera;
          var uiCamera = find("Canvas/Camera").getComponent(Camera);
          var posInUI = Utils.worldPositionCameraAToCameraB(this._owner.node.position, playerCamera, uiCamera);
          var reboundAreaSize = App.battleMgr.battleMainViewCtrl.node.getComponent(UITransform).contentSize;
          //console.log(">>>>   bullet pos:",posUI.x.toFixed(0),posUI.y.toFixed(0),reboundSize.x,reboundSize.y);
          if (this._direction.x < 0 && posInUI.x <= 0 || this._direction.x > 0 && posInUI.x >= reboundAreaSize.width) {
            this.reBound(false);
          } else if (this._direction.y < 0 && posInUI.y <= 0 || this._direction.y > 0 && posInUI.y >= reboundAreaSize.height) {
            this.reBound(true);
          }
        }

        /**
         * 碰到镜头边缘后反弹
         * @param isHorizontal
         */;
        _proto22.reBound = function reBound(isHorizontal) {
          var angleInRadians = this._owner.node.angle * (Math.PI / 180);
          var angleVec = v2(Math.cos(angleInRadians), Math.sin(angleInRadians));
          if (isHorizontal) {
            this._direction.y *= -1;
            angleVec.y *= -1;
          } else {
            this._direction.x *= -1;
            angleVec.x *= -1;
          }
          var angleInRadiansAfter = Math.atan2(angleVec.y, angleVec.x);
          this._owner.node.angle = angleInRadiansAfter * (180 / Math.PI);
          //const distance = this._owner.node.worldPosition.clone().subtract(this._reboundPosition).length();
          Vec3.subtract(this.tempVec, this._owner.node.worldPosition, this._reboundPosition);
          var distance = this.tempVec.length();
          this._moveDisAll += distance;
          this._reboundPosition.set(this._owner.node.worldPosition);
        }

        /**
         * 检测是否达到设定距离
         * @returns
         */;
        _proto22._checkDistance = function _checkDistance() {
          var result = true;
          var maxDistance = this._owner.bulletVO.distance;
          if (maxDistance === -1) {
            // 无限距离
            result = false;
          } else {
            if (this._moveDisAll > 0) {
              result = this._moveDisAll >= maxDistance;
            } else {
              //const distance = this._owner.node.worldPosition.clone().subtract(this._startPosition).length();
              Vec3.subtract(this.tempVec, this._owner.node.worldPosition, this._startPosition);
              var distance = this.tempVec.length();
              result = distance >= maxDistance;
            }
          }
          return result;
        };
        _createClass(BulletMovement_TanLiQiu, [{
          key: "startPosition",
          get: function get() {
            return this._startPosition;
          }
        }]);
        return BulletMovement_TanLiQiu;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 光芒射线
       */
      var BulletMovement_GuangMangSheXian = exports('BulletMovement_GuangMangSheXian', /*#__PURE__*/function (_BulletMovement23) {
        _inheritsLoose(BulletMovement_GuangMangSheXian, _BulletMovement23);
        function BulletMovement_GuangMangSheXian() {
          return _BulletMovement23.apply(this, arguments) || this;
        }
        var _proto23 = BulletMovement_GuangMangSheXian.prototype;
        _proto23.reset = function reset() {
          _BulletMovement23.prototype.reset.call(this);
        };
        _proto23.launch = function launch(bulletLauncherData) {
          // 目标位置
          var pos = this.owner.target.node.worldPosition;
          this.owner.node.setWorldPosition(pos.x, pos.y, 0);
          var i = bulletLauncherData.index;
          var angleOffset = 0;
          if (this._owner.bulletVO.move_param && this._owner.bulletVO.move_param.length > 0) {
            angleOffset = this._owner.bulletVO.move_param[this.owner.indexInSkill] || 0;
          }
          var angle = i * (360 / bulletLauncherData.count) + angleOffset;
          //console.log(">>>>>>>>> index,indexinskill:",i,this.owner.indexInSkill);
          this.owner.node.angle = angle;
        };
        return BulletMovement_GuangMangSheXian;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 直线飞向施法者
       */
      var BulletMovement_ToOwnerLine = exports('BulletMovement_ToOwnerLine', /*#__PURE__*/function (_BulletMovement24) {
        _inheritsLoose(BulletMovement_ToOwnerLine, _BulletMovement24);
        function BulletMovement_ToOwnerLine() {
          var _this17;
          for (var _len16 = arguments.length, args = new Array(_len16), _key16 = 0; _key16 < _len16; _key16++) {
            args[_key16] = arguments[_key16];
          }
          _this17 = _BulletMovement24.call.apply(_BulletMovement24, [this].concat(args)) || this;
          _this17._target = null;
          _this17._offset = v2(0, 0);
          _this17.targetPosTemp = new Vec3();
          return _this17;
        }
        var _proto24 = BulletMovement_ToOwnerLine.prototype;
        _proto24.reset = function reset() {
          _BulletMovement24.prototype.reset.call(this);
          this._direction.set(0, 0, 0);
        };
        _proto24.launch = function launch(bulletLauncherData) {
          this.speed = this._owner.bulletVO.initialSpeed;
          this._target = this.owner.owner;
          if (!this._target || this._target._isDead) {
            return;
          }
          if (this._owner.bulletVO.move_param.length >= 0) {
            this._offset.x = this._owner.bulletVO.move_param[0];
            this._offset.y = this._owner.bulletVO.move_param[1];
          }
          this.setMoveDir();
        };
        _proto24.setMoveDir = function setMoveDir() {
          this._direction = this.getTargetPos().subtract(this.owner.node.worldPosition).normalize();
        };
        _proto24.getTargetPos = function getTargetPos() {
          // let pos=this._target.node.worldPosition.clone();
          // pos.x+=this._offset.x;
          // pos.y+=this._offset.y;
          this.targetPosTemp.x = this._target.node.worldPosition.x + this._offset.x;
          this.targetPosTemp.y = this._target.node.worldPosition.y + this._offset.y;
          return this.targetPosTemp;
        };
        _proto24.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          this.setMoveDir();
          if (this._direction.x === 0 && this._direction.y === 0) return;
          this.speed = this.getMoveSpeed();
          var frameSpeed = this.speed * dt;
          // const offset = this._direction.clone().multiplyScalar(frameSpeed);
          Vec3.multiplyScalar(this.tempVec, this._direction, frameSpeed);
          var offset = this.tempVec;
          // const pos = this._owner.node.worldPosition.clone();
          Vec3.add(this.tempPos, this._owner.node.worldPosition, offset);
          var nextPos = this.tempPos;
          var angle = BattleUtil.get2DAngleByPoint(this._owner.node.position, nextPos);
          this._owner.node.worldPosition = nextPos;
          this._owner.node.angle = angle;
          var dis = frameSpeed * 1.5;
          if (this.getTargetPos().subtract(this.owner.node.worldPosition).length() <= dis) {
            this.isEnd = true;
          }
        };
        return BulletMovement_ToOwnerLine;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 雷霆万钧
       */
      var BulletMovement_LeiTingWanJun = exports('BulletMovement_LeiTingWanJun', /*#__PURE__*/function (_BulletMovement_TanLi) {
        _inheritsLoose(BulletMovement_LeiTingWanJun, _BulletMovement_TanLi);
        function BulletMovement_LeiTingWanJun() {
          return _BulletMovement_TanLi.apply(this, arguments) || this;
        }
        var _proto25 = BulletMovement_LeiTingWanJun.prototype;
        _proto25.reset = function reset() {
          _BulletMovement_TanLi.prototype.reset.call(this);
          this._direction.set(0, 0, 0);
        };
        _proto25.launch = function launch(bulletLauncherData) {
          // let pos=this.owner.owner.node.worldPosition.clone();
          var width = 0;
          var height = 0;
          if (this._owner.bulletVO.move_param.length >= 0) {
            width = this._owner.bulletVO.move_param[0];
            height = this._owner.bulletVO.move_param[1];
          }
          var offsetX = Utils.GetRandomNum(-width, width);
          var offsetY = Utils.GetRandomNum(-height, height);
          // pos.x+=offsetX;
          // pos.y+=offsetY;
          this.tempPos.x = this.owner.owner.node.worldPosition.x + offsetX;
          this.tempPos.y = this.owner.owner.node.worldPosition.y + offsetY;
          this._owner.node.worldPosition = this.tempPos;
          var v2 = MathUtils.angleToDirection(Utils.GetRandomNum(0, 360));
          this._direction = v3(v2.x, v2.y, 0).normalize();
          _BulletMovement_TanLi.prototype.launch.call(this, bulletLauncherData);
        };
        return BulletMovement_LeiTingWanJun;
      }(BulletMovement_TanLiQiu));

      /**
       * 子弹运动器类型 —— 飞舞雷环
       */
      var BulletMovement_FeiWuLeiHuan = exports('BulletMovement_FeiWuLeiHuan', /*#__PURE__*/function (_BulletMovement25) {
        _inheritsLoose(BulletMovement_FeiWuLeiHuan, _BulletMovement25);
        function BulletMovement_FeiWuLeiHuan() {
          var _this18;
          for (var _len17 = arguments.length, args = new Array(_len17), _key17 = 0; _key17 < _len17; _key17++) {
            args[_key17] = arguments[_key17];
          }
          _this18 = _BulletMovement25.call.apply(_BulletMovement25, [this].concat(args)) || this;
          /** 计算贝塞尔时间 0-1 */
          _this18._t = void 0;
          /** 曲线点数组, 起点终点控制点 */
          _this18._startPos = void 0;
          _this18._endPos = void 0;
          _this18._ctrlPos = new Vec3();
          _this18._dirVec = void 0;
          _this18._isReturn = false;
          _this18._angle = 110;
          _this18._bulletLauncherData = void 0;
          _this18.tempVec2 = new Vec3();
          return _this18;
        }
        var _proto26 = BulletMovement_FeiWuLeiHuan.prototype;
        _proto26.reset = function reset() {
          _BulletMovement25.prototype.reset.call(this);
        };
        _proto26.launch = function launch(bulletLauncherData) {
          this._bulletLauncherData = bulletLauncherData;
          this.speed = this._owner.bulletVO.initialSpeed;
          var target = this._owner.target;
          this._t = 0;
          this._isReturn = false;
          this._startPos = this._owner.node.worldPosition;
          //console.log(">>>>>>>>>>> start:",this._startPos.x,this._startPos.y);
          //this._dirVec=target.node.worldPosition.clone().subtract(this.owner.owner.node.worldPosition).normalize();
          Vec3.subtract(this.tempPos, target.node.worldPosition, this.owner.owner.node.worldPosition);
          this._dirVec = this.tempPos.normalize();
          //this._endPos=this._startPos.clone().add(this._dirVec.clone().multiplyScalar(this._owner.bulletVO.move_param[0]));
          Vec3.multiplyScalar(this.tempVec, this._dirVec, this._owner.bulletVO.move_param[0]);
          Vec3.add(this.tempVec2, this._startPos, this.tempVec);
          this._endPos = this.tempVec2;
          this.getMidPoint();
        };
        _proto26.getMidPoint = function getMidPoint() {
          var sign = this._isReturn ? 1 : -1;
          var sign2 = this._bulletLauncherData.index === 0 ? 1 : -1;
          var dirV = v2(this._dirVec.x, this._dirVec.y).rotate(sign * sign2 * this._angle * (Math.PI / 180));
          var dirV3 = v3(dirV.x, dirV.y, 0).multiplyScalar(this._owner.bulletVO.move_param[1]);
          //this._ctrlPos=(this._isReturn?this._startPos:this._endPos).clone().add(dirV3);
          Vec3.add(this.tempVec, this._isReturn ? this._startPos : this._endPos, dirV3);
          this._ctrlPos = this.tempVec;
        };
        _proto26.onUpdate = function onUpdate(dt) {
          if (this._isEnd) return;
          this.speed = this.getFrameSpeed() / 8;
          this._t += dt * this.speed;
          if (this._t > 1) {
            if (!this._isReturn) {
              this.turnAround();
            } else {
              this._t = 1;
              this._isEnd = true;
            }
          }
          var point = MathUtils.bessel2eLevel(this._t, this._startPos, this._ctrlPos, this._endPos);
          //console.log(">>>>>>>>>>> start--------------:",this._startPos.x,this._startPos.y,point.x,point.y);
          this._owner.node.setPosition(point.x, point.y);
          var angle = BattleUtil.get2DAngleByPoint(this._owner.node.position, this._endPos);
          this._owner.node.angle = angle;
        };
        _proto26.turnAround = function turnAround() {
          this._isReturn = true;
          this._t = 0;
          var temp = this._startPos;
          this._startPos = this._endPos;
          this._endPos = temp;
          this.getMidPoint();
        };
        return BulletMovement_FeiWuLeiHuan;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 世界boss吐息
       */
      var BulletMovement_WorldBossTuXi = exports('BulletMovement_WorldBossTuXi', /*#__PURE__*/function (_BulletMovement26) {
        _inheritsLoose(BulletMovement_WorldBossTuXi, _BulletMovement26);
        function BulletMovement_WorldBossTuXi() {
          return _BulletMovement26.apply(this, arguments) || this;
        }
        var _proto27 = BulletMovement_WorldBossTuXi.prototype;
        _proto27.reset = function reset() {
          _BulletMovement26.prototype.reset.call(this);
        };
        _proto27.launch = function launch(bulletLauncherData) {
          var target = this._owner.target;
          //相对boss位置做偏移[x1,y1,x2,y2,x3,y3...]
          var paramLength = this._owner.bulletVO.move_param.length / 2;
          var index = BulletMovement_WorldBossTuXi.launchCounter % paramLength;
          var x = this.owner.owner.node.worldPosition.x + this._owner.bulletVO.move_param[index * 2] || 0;
          var y = this.owner.owner.node.worldPosition.y + this._owner.bulletVO.move_param[index * 2 + 1] || 0;
          this.owner.node.setWorldPosition(x, y, target.node.worldPosition.z);
          BulletMovement_WorldBossTuXi.launchCounter++;
        };
        _proto27.onUpdate = function onUpdate(dt) {};
        return BulletMovement_WorldBossTuXi;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 向目标方向差值生成子弹    运动参数填距离差值    最远距离填第一颗子弹的位置
       */
      /** 多次发射索引 */
      BulletMovement_WorldBossTuXi.launchCounter = 0;
      var BulletMovement_DistanceOffset = exports('BulletMovement_DistanceOffset', /*#__PURE__*/function (_BulletMovement27) {
        _inheritsLoose(BulletMovement_DistanceOffset, _BulletMovement27);
        function BulletMovement_DistanceOffset() {
          return _BulletMovement27.apply(this, arguments) || this;
        }
        var _proto28 = BulletMovement_DistanceOffset.prototype;
        _proto28.reset = function reset() {
          _BulletMovement27.prototype.reset.call(this);
        };
        _proto28.launch = function launch(bulletLauncherData) {
          var target = this._owner.target;
          if (this.owner.indexInSkill === 0) {
            Vec3.subtract(BulletMovement_DistanceOffset.targetDir, target.node.worldPosition, this.owner.owner.node.worldPosition);
            BulletMovement_DistanceOffset.targetDir.normalize();
          }
          var len = this._owner.bulletVO.move_param[0] + this._owner.bulletVO.move_param[1] * this.owner.indexInSkill;
          var dis = BulletMovement_DistanceOffset.targetDir.clone().multiplyScalar(len);
          console.log(">>>>>>>>>>>>>>>>>>>>>> BulletMovement_DistanceOffset  bullet data:", this.owner.indexInSkill, len, dis.x, dis.y);
          var x = this.owner.owner.node.worldPosition.x + dis.x;
          var y = this.owner.owner.node.worldPosition.y + dis.y;
          this.owner.node.setWorldPosition(x, y, 0);
        };
        _proto28.onUpdate = function onUpdate(dt) {};
        return BulletMovement_DistanceOffset;
      }(BulletMovement));

      /**
       * 子弹运动器类型 —— 巨大子弹,带特殊角度偏移，太刀居合斩刀光
       */
      BulletMovement_DistanceOffset.targetDir = new Vec3();
      var BulletMovement_HugeBullet = exports('BulletMovement_HugeBullet', /*#__PURE__*/function (_BulletMovement_Line) {
        _inheritsLoose(BulletMovement_HugeBullet, _BulletMovement_Line);
        function BulletMovement_HugeBullet() {
          return _BulletMovement_Line.apply(this, arguments) || this;
        }
        var _proto29 = BulletMovement_HugeBullet.prototype;
        _proto29.launch = function launch(bulletLauncherData) {
          _BulletMovement_Line.prototype.launch.call(this, bulletLauncherData);
          // let bullet = this.owner;
          // let turnAngle = this.owner.bulletVO.move_param[bullet.indexInSkill];
          // bullet.node.angle += turnAngle;
          // let dirOffset = turnAngle > 0 ? -1 : 1;
          // const target = bullet.target;
          // const startPos = bullet.node.worldPosition;
          // const endPos = target.node.worldPosition.clone().add(target.getHitPosition());
          // let dis = Vec3.distance(startPos, endPos);
          // let offset = dis * Math.sin((turnAngle * Math.PI) / 180);
          // Vec3.subtract(bullet.bulletMovement.direction, endPos, startPos);

          // // 计算垂直于角度方向的偏移
          // const angleInRadians = (bullet.node.angle * Math.PI) / 180;
          // // 垂直方向的角度（原角度 + 90度）
          // const perpAngleInRadians = angleInRadians + (Math.PI / 2) * dirOffset;
          // const offsetX = Math.cos(perpAngleInRadians) * offset;
          // const offsetY = Math.sin(perpAngleInRadians) * offset;
          // bullet.node.worldPosition.add3f(offsetX, offsetY, 0);
        };

        return BulletMovement_HugeBullet;
      }(BulletMovement_Line));

      /**
       * 子弹运动器类型 —— 朝向跟随施法者的冲刺方向：太刀回旋斩
       */
      var BulletMovement_FollowMoveDir = exports('BulletMovement_FollowMoveDir', /*#__PURE__*/function (_BulletMovement_Line2) {
        _inheritsLoose(BulletMovement_FollowMoveDir, _BulletMovement_Line2);
        function BulletMovement_FollowMoveDir() {
          return _BulletMovement_Line2.apply(this, arguments) || this;
        }
        var _proto30 = BulletMovement_FollowMoveDir.prototype;
        _proto30.launch = function launch(bulletLauncherData) {
          _BulletMovement_Line2.prototype.launch.call(this, bulletLauncherData);
          this.resetDir();
        };
        _proto30.resetDir = function resetDir() {
          var bulletowner = this.owner.owner;
          //console.log('doMoveAction BulletMovement_FollowMoveDir ------------->>>>   launch', this._owner.node.angle, bulletowner.type, bulletowner.skillMoveDirVec);
          if (bulletowner.skillMoveDirVec) {
            var moveVec = bulletowner.skillMoveDirVec;
            var moveAngleRadians = Math.atan2(moveVec.y, moveVec.x);
            this._owner.node.angle = moveAngleRadians * (180 / Math.PI);
            //console.log('doMoveAction BulletMovement_FollowMoveDir------------->>>>', this._owner.node.angle, moveVec);
          }
        };

        _proto30.onUpdate = function onUpdate(dt) {
          _BulletMovement_Line2.prototype.onUpdate.call(this, dt);
          this.resetDir();
        };
        return BulletMovement_FollowMoveDir;
      }(BulletMovement_Line));

      /**
       * 子弹运动器类型 —— 朝向跟随施法者的移动方向：
       */
      var BulletMovement_FollowMoveDir2 = exports('BulletMovement_FollowMoveDir2', /*#__PURE__*/function (_BulletMovement28) {
        _inheritsLoose(BulletMovement_FollowMoveDir2, _BulletMovement28);
        function BulletMovement_FollowMoveDir2() {
          var _this19;
          for (var _len18 = arguments.length, args = new Array(_len18), _key18 = 0; _key18 < _len18; _key18++) {
            args[_key18] = arguments[_key18];
          }
          _this19 = _BulletMovement28.call.apply(_BulletMovement28, [this].concat(args)) || this;
          _this19._step = 1;
          return _this19;
        }
        var _proto31 = BulletMovement_FollowMoveDir2.prototype;
        // private _offsetAngle = 0;
        _proto31.launch = function launch(bulletLauncherData) {
          // let index = bulletLauncherData.index;
          // let bulletowner = this.owner.owner;
          // let attachment = bulletowner.node.getChildByName('attachment2');
          //let pos = bulletowner.getLocalMountPoint(this._owner.bulletVO.position, v3(0, 0, 0));
          // this._owner.node.setParent(bulletowner.node);
          // this._owner.node.setPosition(v3(0, 0, 0));
          this._step = this._owner.bulletVO.angle_speed;
          if (this._owner.bulletVO.hierarchy === 2) {
            this._owner.node.setSiblingIndex(0);
          }
          this.resetDir();
        };
        _proto31.resetDir = function resetDir() {
          var bulletowner = this.owner.owner;
          //console.log('doMoveAction BulletMovement_FollowMoveDir ------------->>>>   launch', this._owner.node.angle, bulletowner.type, bulletowner.skillMoveDirVec);
          if (bulletowner.type === GameBattle.RoleType.Hero) {
            var moveVec = bulletowner.moveDirection;
            var moveAngleRadians = Math.atan2(moveVec.y, moveVec.x);
            this._owner.node.angle = moveAngleRadians * (180 / Math.PI);
            //console.log('doMoveAction BulletMovement_FollowMoveDir------------->>>>', this._owner.node.angle, moveVec);
          }
        };

        _proto31.onUpdate = function onUpdate(dt) {
          //this.resetDir();
          var bulletowner = this.owner.owner;
          this._owner.node.setPosition(bulletowner.node.position);
          var dirVec = bulletowner.moveDirection.clone();
          if (dirVec.length() === 0) {
            var target = this._owner.skill.getTarget();
            if (!target) return;
            Vec3.subtract(dirVec, target.node.worldPosition, this._owner.node.worldPosition);
          }
          var moveAngleRadians = Math.atan2(dirVec.y, dirVec.x);
          var angle = moveAngleRadians * (180 / Math.PI);
          // 确保目标角度在 0 到 360 度之间
          var targetAngle = (angle + 360) % 360;
          var currentAngle = (this._owner.node.angle + 360) % 360;

          // 如果两者的角度差大于 180 度，说明跨越了 0 度的边界，需要调整
          if (Math.abs(targetAngle - currentAngle) > 180) {
            if (targetAngle > currentAngle) {
              targetAngle -= 360;
            } else {
              currentAngle -= 360;
            }
          }
          var difference = targetAngle - currentAngle;

          // 如果差值大于步长，继续平滑旋转
          if (Math.abs(difference) > this._step) {
            if (difference > 0) {
              this._owner.node.angle += this._step;
            } else {
              this._owner.node.angle -= this._step;
            }
          } else {
            this._owner.node.angle = angle; // 目标角度已足够接近，直接设置
          }
        };

        return BulletMovement_FollowMoveDir2;
      }(BulletMovement));
      cclegacy._RF.pop();
    }
  };
});

System.register("chunks:///_virtual/BulletVO.ts", ['./rollupPluginModLoBabelHelpers.js', 'cc', './BattleDefine.ts', './BulletEffect.ts', './DBRecord.ts'], function (exports) {
  var _createClass, cclegacy, GameBattle, BulletEffect, DBRecord;
  return {
    setters: [function (module) {
      _createClass = module.createClass;
    }, function (module) {
      cclegacy = module.cclegacy;
    }, function (module) {
      GameBattle = module.GameBattle;
    }, function (module) {
      BulletEffect = module.BulletEffect;
    }, function (module) {
      DBRecord = module.default;
    }],
    execute: function () {
      cclegacy._RF.push({}, "d09a9vJo5RBnodqHZEyk1Ij", "BulletVO", undefined);

      /**
       * 子弹数据类
       */
      var BulletVO = exports('BulletVO', /*#__PURE__*/function () {
        function BulletVO() {
          /** 类型 */
          this._bulletID = 0;
          /** 类型 */
          this._type = 0;
          /** 外观目录 */
          this._viewPath = "";
          /** 初始位置 */
          this._position = "";
          /** 运动方式 */
          this._moveType = GameBattle.BulletMoveType.None;
          /** 初速度 */
          this._initialVelocity = 0;
          /** 加速度 */
          this._acceleration = 0;
          /** 最远距离 */
          this._distance = 0;
          /** 穿透数 */
          this._penetrate_num = 0;
          /** 弹射次数 */
          this._catapults_num = 0;
          /** 弹射半径 */
          this._catapult_srange = 0;
          /** 是否重复弹射 */
          this._repeat = false;
          /** 触发次数上限 */
          this._Trigger_num = 0;
          /** 触发间隔时间 */
          this._Trigger_time = 0;
          /** 延迟作用时间 */
          this._delayTime = 0;
          /** 持续时间(ms) */
          this._holding_time = 0;
          /** 拖尾参数 */
          this._motion_streak = void 0;
          /** 击中特效 */
          this._hit_effect = void 0;
          /** 子弹特效附件 */
          this._attachment = void 0;
          /** 环绕子弹的角速度 */
          this._angle_speed = void 0;
          /** 子弹大小倍率 */
          this._volume = void 0;
          /** 子弹运行中缩放最大倍率 */
          this._volume_max = void 0;
          this._effect_id = [];
          /** 延迟生效时间 */
          this._waiting_time = void 0;
          this._waiting_move_time = 0;
          /** 子弹碰撞盒锚点 */
          this._angle_point = void 0;
          /** 特效层级 */
          this._hierarchy = void 0;
          this._move_param = [];
          this._res = "";
          this._sound = "";
          this._bullet_sound = "";
          this._offset = [];
          this.crash_box = [];
          this.crash_box_type = void 0;
          /** 子弹效果 */
          this.bulletEffect = {};
          /**子弹类型参数 */
          this.type_param = [];
        }
        var _proto = BulletVO.prototype;
        _proto.reset = function reset() {
          for (var _key in this.bulletEffect) {
            delete this.bulletEffect[_key];
          }
          this.bulletEffect = {};
        };
        _proto.load = function load(cfg) {
          var _this$_effect_id, _this$crash_box, _this$_angle_point, _this$_move_param, _this$_offset;
          this._bulletID = cfg.bullet_id;
          this._type = cfg.type;
          this._viewPath = typeof cfg.res === "string" 